"""
    OpenAPI definition

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: v0
    Contact: support@gooddata.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from gooddata_metadata_client.api_client import ApiClient, Endpoint as _Endpoint
from gooddata_metadata_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from gooddata_metadata_client.model.json_api_analytical_dashboard_in_document import JsonApiAnalyticalDashboardInDocument
from gooddata_metadata_client.model.json_api_analytical_dashboard_out_document import JsonApiAnalyticalDashboardOutDocument
from gooddata_metadata_client.model.json_api_analytical_dashboard_out_list import JsonApiAnalyticalDashboardOutList
from gooddata_metadata_client.model.json_api_analytical_dashboard_patch_document import JsonApiAnalyticalDashboardPatchDocument
from gooddata_metadata_client.model.json_api_api_token_in_document import JsonApiApiTokenInDocument
from gooddata_metadata_client.model.json_api_api_token_out_document import JsonApiApiTokenOutDocument
from gooddata_metadata_client.model.json_api_api_token_out_list import JsonApiApiTokenOutList
from gooddata_metadata_client.model.json_api_attribute_out_document import JsonApiAttributeOutDocument
from gooddata_metadata_client.model.json_api_attribute_out_list import JsonApiAttributeOutList
from gooddata_metadata_client.model.json_api_color_palette_in_document import JsonApiColorPaletteInDocument
from gooddata_metadata_client.model.json_api_color_palette_out_document import JsonApiColorPaletteOutDocument
from gooddata_metadata_client.model.json_api_color_palette_out_list import JsonApiColorPaletteOutList
from gooddata_metadata_client.model.json_api_color_palette_patch_document import JsonApiColorPalettePatchDocument
from gooddata_metadata_client.model.json_api_cookie_security_configuration_in_document import JsonApiCookieSecurityConfigurationInDocument
from gooddata_metadata_client.model.json_api_cookie_security_configuration_out_document import JsonApiCookieSecurityConfigurationOutDocument
from gooddata_metadata_client.model.json_api_cookie_security_configuration_patch_document import JsonApiCookieSecurityConfigurationPatchDocument
from gooddata_metadata_client.model.json_api_csp_directive_in_document import JsonApiCspDirectiveInDocument
from gooddata_metadata_client.model.json_api_csp_directive_out_document import JsonApiCspDirectiveOutDocument
from gooddata_metadata_client.model.json_api_csp_directive_out_list import JsonApiCspDirectiveOutList
from gooddata_metadata_client.model.json_api_csp_directive_patch_document import JsonApiCspDirectivePatchDocument
from gooddata_metadata_client.model.json_api_custom_application_setting_in_document import JsonApiCustomApplicationSettingInDocument
from gooddata_metadata_client.model.json_api_custom_application_setting_out_document import JsonApiCustomApplicationSettingOutDocument
from gooddata_metadata_client.model.json_api_custom_application_setting_out_list import JsonApiCustomApplicationSettingOutList
from gooddata_metadata_client.model.json_api_custom_application_setting_patch_document import JsonApiCustomApplicationSettingPatchDocument
from gooddata_metadata_client.model.json_api_dashboard_plugin_in_document import JsonApiDashboardPluginInDocument
from gooddata_metadata_client.model.json_api_dashboard_plugin_out_document import JsonApiDashboardPluginOutDocument
from gooddata_metadata_client.model.json_api_dashboard_plugin_out_list import JsonApiDashboardPluginOutList
from gooddata_metadata_client.model.json_api_dashboard_plugin_patch_document import JsonApiDashboardPluginPatchDocument
from gooddata_metadata_client.model.json_api_data_source_identifier_out_document import JsonApiDataSourceIdentifierOutDocument
from gooddata_metadata_client.model.json_api_data_source_identifier_out_list import JsonApiDataSourceIdentifierOutList
from gooddata_metadata_client.model.json_api_data_source_in_document import JsonApiDataSourceInDocument
from gooddata_metadata_client.model.json_api_data_source_out_document import JsonApiDataSourceOutDocument
from gooddata_metadata_client.model.json_api_data_source_out_list import JsonApiDataSourceOutList
from gooddata_metadata_client.model.json_api_data_source_patch_document import JsonApiDataSourcePatchDocument
from gooddata_metadata_client.model.json_api_data_source_table_out_document import JsonApiDataSourceTableOutDocument
from gooddata_metadata_client.model.json_api_data_source_table_out_list import JsonApiDataSourceTableOutList
from gooddata_metadata_client.model.json_api_dataset_out_document import JsonApiDatasetOutDocument
from gooddata_metadata_client.model.json_api_dataset_out_list import JsonApiDatasetOutList
from gooddata_metadata_client.model.json_api_entitlement_out_document import JsonApiEntitlementOutDocument
from gooddata_metadata_client.model.json_api_entitlement_out_list import JsonApiEntitlementOutList
from gooddata_metadata_client.model.json_api_fact_out_document import JsonApiFactOutDocument
from gooddata_metadata_client.model.json_api_fact_out_list import JsonApiFactOutList
from gooddata_metadata_client.model.json_api_filter_context_in_document import JsonApiFilterContextInDocument
from gooddata_metadata_client.model.json_api_filter_context_out_document import JsonApiFilterContextOutDocument
from gooddata_metadata_client.model.json_api_filter_context_out_list import JsonApiFilterContextOutList
from gooddata_metadata_client.model.json_api_filter_context_patch_document import JsonApiFilterContextPatchDocument
from gooddata_metadata_client.model.json_api_label_out_document import JsonApiLabelOutDocument
from gooddata_metadata_client.model.json_api_label_out_list import JsonApiLabelOutList
from gooddata_metadata_client.model.json_api_metric_in_document import JsonApiMetricInDocument
from gooddata_metadata_client.model.json_api_metric_out_document import JsonApiMetricOutDocument
from gooddata_metadata_client.model.json_api_metric_out_list import JsonApiMetricOutList
from gooddata_metadata_client.model.json_api_metric_patch_document import JsonApiMetricPatchDocument
from gooddata_metadata_client.model.json_api_organization_in_document import JsonApiOrganizationInDocument
from gooddata_metadata_client.model.json_api_organization_out_document import JsonApiOrganizationOutDocument
from gooddata_metadata_client.model.json_api_organization_patch_document import JsonApiOrganizationPatchDocument
from gooddata_metadata_client.model.json_api_organization_setting_in_document import JsonApiOrganizationSettingInDocument
from gooddata_metadata_client.model.json_api_organization_setting_out_document import JsonApiOrganizationSettingOutDocument
from gooddata_metadata_client.model.json_api_organization_setting_out_list import JsonApiOrganizationSettingOutList
from gooddata_metadata_client.model.json_api_organization_setting_patch_document import JsonApiOrganizationSettingPatchDocument
from gooddata_metadata_client.model.json_api_theme_in_document import JsonApiThemeInDocument
from gooddata_metadata_client.model.json_api_theme_out_document import JsonApiThemeOutDocument
from gooddata_metadata_client.model.json_api_theme_out_list import JsonApiThemeOutList
from gooddata_metadata_client.model.json_api_theme_patch_document import JsonApiThemePatchDocument
from gooddata_metadata_client.model.json_api_user_group_in_document import JsonApiUserGroupInDocument
from gooddata_metadata_client.model.json_api_user_group_out_document import JsonApiUserGroupOutDocument
from gooddata_metadata_client.model.json_api_user_group_out_list import JsonApiUserGroupOutList
from gooddata_metadata_client.model.json_api_user_group_patch_document import JsonApiUserGroupPatchDocument
from gooddata_metadata_client.model.json_api_user_in_document import JsonApiUserInDocument
from gooddata_metadata_client.model.json_api_user_out_document import JsonApiUserOutDocument
from gooddata_metadata_client.model.json_api_user_out_list import JsonApiUserOutList
from gooddata_metadata_client.model.json_api_user_patch_document import JsonApiUserPatchDocument
from gooddata_metadata_client.model.json_api_user_setting_in_document import JsonApiUserSettingInDocument
from gooddata_metadata_client.model.json_api_user_setting_out_document import JsonApiUserSettingOutDocument
from gooddata_metadata_client.model.json_api_user_setting_out_list import JsonApiUserSettingOutList
from gooddata_metadata_client.model.json_api_visualization_object_in_document import JsonApiVisualizationObjectInDocument
from gooddata_metadata_client.model.json_api_visualization_object_out_document import JsonApiVisualizationObjectOutDocument
from gooddata_metadata_client.model.json_api_visualization_object_out_list import JsonApiVisualizationObjectOutList
from gooddata_metadata_client.model.json_api_visualization_object_patch_document import JsonApiVisualizationObjectPatchDocument
from gooddata_metadata_client.model.json_api_workspace_data_filter_in_document import JsonApiWorkspaceDataFilterInDocument
from gooddata_metadata_client.model.json_api_workspace_data_filter_out_document import JsonApiWorkspaceDataFilterOutDocument
from gooddata_metadata_client.model.json_api_workspace_data_filter_out_list import JsonApiWorkspaceDataFilterOutList
from gooddata_metadata_client.model.json_api_workspace_data_filter_patch_document import JsonApiWorkspaceDataFilterPatchDocument
from gooddata_metadata_client.model.json_api_workspace_data_filter_setting_out_document import JsonApiWorkspaceDataFilterSettingOutDocument
from gooddata_metadata_client.model.json_api_workspace_data_filter_setting_out_list import JsonApiWorkspaceDataFilterSettingOutList
from gooddata_metadata_client.model.json_api_workspace_in_document import JsonApiWorkspaceInDocument
from gooddata_metadata_client.model.json_api_workspace_out_document import JsonApiWorkspaceOutDocument
from gooddata_metadata_client.model.json_api_workspace_out_list import JsonApiWorkspaceOutList
from gooddata_metadata_client.model.json_api_workspace_patch_document import JsonApiWorkspacePatchDocument
from gooddata_metadata_client.model.json_api_workspace_setting_in_document import JsonApiWorkspaceSettingInDocument
from gooddata_metadata_client.model.json_api_workspace_setting_out_document import JsonApiWorkspaceSettingOutDocument
from gooddata_metadata_client.model.json_api_workspace_setting_out_list import JsonApiWorkspaceSettingOutList
from gooddata_metadata_client.model.json_api_workspace_setting_patch_document import JsonApiWorkspaceSettingPatchDocument


class EntitiesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_entity_analytical_dashboards_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAnalyticalDashboardOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/analyticalDashboards',
                'operation_id': 'create_entity_analytical_dashboards',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_analytical_dashboard_in_document',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_analytical_dashboard_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "VISUALIZATIONOBJECTS": "visualizationObjects",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "FILTERCONTEXTS": "filterContexts",
                        "DASHBOARDPLUGINS": "dashboardPlugins",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "PERMISSIONS": "permissions",
                        "ORIGIN": "origin",
                        "ACCESSINFO": "accessInfo",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_analytical_dashboard_in_document':
                        (JsonApiAnalyticalDashboardInDocument,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_analytical_dashboard_in_document': 'body',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_api_tokens_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiApiTokenOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/users/{userId}/apiTokens',
                'operation_id': 'create_entity_api_tokens',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_id',
                    'json_api_api_token_in_document',
                ],
                'required': [
                    'user_id',
                    'json_api_api_token_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_id':
                        (str,),
                    'json_api_api_token_in_document':
                        (JsonApiApiTokenInDocument,),
                },
                'attribute_map': {
                    'user_id': 'userId',
                },
                'location_map': {
                    'user_id': 'path',
                    'json_api_api_token_in_document': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_color_palettes_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiColorPaletteOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/colorPalettes',
                'operation_id': 'create_entity_color_palettes',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'json_api_color_palette_in_document',
                ],
                'required': [
                    'json_api_color_palette_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'json_api_color_palette_in_document':
                        (JsonApiColorPaletteInDocument,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'json_api_color_palette_in_document': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_csp_directives_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiCspDirectiveOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/cspDirectives',
                'operation_id': 'create_entity_csp_directives',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'json_api_csp_directive_in_document',
                ],
                'required': [
                    'json_api_csp_directive_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'json_api_csp_directive_in_document':
                        (JsonApiCspDirectiveInDocument,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'json_api_csp_directive_in_document': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_custom_application_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiCustomApplicationSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/customApplicationSettings',
                'operation_id': 'create_entity_custom_application_settings',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_custom_application_setting_in_document',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_custom_application_setting_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_custom_application_setting_in_document':
                        (JsonApiCustomApplicationSettingInDocument,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_custom_application_setting_in_document': 'body',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_dashboard_plugins_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDashboardPluginOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/dashboardPlugins',
                'operation_id': 'create_entity_dashboard_plugins',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_dashboard_plugin_in_document',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_dashboard_plugin_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_dashboard_plugin_in_document':
                        (JsonApiDashboardPluginInDocument,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_dashboard_plugin_in_document': 'body',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_data_sources_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDataSourceOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/dataSources',
                'operation_id': 'create_entity_data_sources',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'json_api_data_source_in_document',
                    'meta_include',
                ],
                'required': [
                    'json_api_data_source_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('meta_include',): {

                        "PERMISSIONS": "permissions",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'json_api_data_source_in_document':
                        (JsonApiDataSourceInDocument,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'json_api_data_source_in_document': 'body',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_filter_contexts_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFilterContextOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/filterContexts',
                'operation_id': 'create_entity_filter_contexts',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_filter_context_in_document',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_filter_context_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "ATTRIBUTES": "attributes",
                        "DATASETS": "datasets",
                        "LABELS": "labels",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_filter_context_in_document':
                        (JsonApiFilterContextInDocument,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_filter_context_in_document': 'body',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_metrics_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiMetricOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/metrics',
                'operation_id': 'create_entity_metrics',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_metric_in_document',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_metric_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_metric_in_document':
                        (JsonApiMetricInDocument,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_metric_in_document': 'body',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_organization_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiOrganizationSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/organizationSettings',
                'operation_id': 'create_entity_organization_settings',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'json_api_organization_setting_in_document',
                ],
                'required': [
                    'json_api_organization_setting_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'json_api_organization_setting_in_document':
                        (JsonApiOrganizationSettingInDocument,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'json_api_organization_setting_in_document': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_themes_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiThemeOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/themes',
                'operation_id': 'create_entity_themes',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'json_api_theme_in_document',
                ],
                'required': [
                    'json_api_theme_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'json_api_theme_in_document':
                        (JsonApiThemeInDocument,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'json_api_theme_in_document': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_user_groups_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserGroupOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/userGroups',
                'operation_id': 'create_entity_user_groups',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'json_api_user_group_in_document',
                    'include',
                ],
                'required': [
                    'json_api_user_group_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "USERGROUPS": "userGroups",
                        "PARENTS": "parents",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'json_api_user_group_in_document':
                        (JsonApiUserGroupInDocument,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'include': 'include',
                },
                'location_map': {
                    'json_api_user_group_in_document': 'body',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_user_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/users/{userId}/userSettings',
                'operation_id': 'create_entity_user_settings',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_id',
                    'json_api_user_setting_in_document',
                ],
                'required': [
                    'user_id',
                    'json_api_user_setting_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_id':
                        (str,),
                    'json_api_user_setting_in_document':
                        (JsonApiUserSettingInDocument,),
                },
                'attribute_map': {
                    'user_id': 'userId',
                },
                'location_map': {
                    'user_id': 'path',
                    'json_api_user_setting_in_document': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_users_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/users',
                'operation_id': 'create_entity_users',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'json_api_user_in_document',
                    'include',
                ],
                'required': [
                    'json_api_user_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "USERGROUPS": "userGroups",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'json_api_user_in_document':
                        (JsonApiUserInDocument,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'include': 'include',
                },
                'location_map': {
                    'json_api_user_in_document': 'body',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_visualization_objects_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiVisualizationObjectOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/visualizationObjects',
                'operation_id': 'create_entity_visualization_objects',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_visualization_object_in_document',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_visualization_object_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_visualization_object_in_document':
                        (JsonApiVisualizationObjectInDocument,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_visualization_object_in_document': 'body',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_workspace_data_filters_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceDataFilterOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters',
                'operation_id': 'create_entity_workspace_data_filters',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_workspace_data_filter_in_document',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_workspace_data_filter_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "WORKSPACEDATAFILTERSETTINGS": "workspaceDataFilterSettings",
                        "FILTERSETTINGS": "filterSettings",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_workspace_data_filter_in_document':
                        (JsonApiWorkspaceDataFilterInDocument,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_workspace_data_filter_in_document': 'body',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_workspace_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceSettings',
                'operation_id': 'create_entity_workspace_settings',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_workspace_setting_in_document',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_workspace_setting_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_workspace_setting_in_document':
                        (JsonApiWorkspaceSettingInDocument,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_workspace_setting_in_document': 'body',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_workspaces_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces',
                'operation_id': 'create_entity_workspaces',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'json_api_workspace_in_document',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'json_api_workspace_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "WORKSPACES": "workspaces",
                        "PARENT": "parent",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "CONFIG": "config",
                        "PERMISSIONS": "permissions",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'json_api_workspace_in_document':
                        (JsonApiWorkspaceInDocument,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'json_api_workspace_in_document': 'body',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.delete_entity_analytical_dashboards_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId}',
                'operation_id': 'delete_entity_analytical_dashboards',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_api_tokens_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/users/{userId}/apiTokens/{id}',
                'operation_id': 'delete_entity_api_tokens',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_id',
                    'id',
                    'filter',
                ],
                'required': [
                    'user_id',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_id':
                        (str,),
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'user_id': 'userId',
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'user_id': 'path',
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_color_palettes_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/colorPalettes/{id}',
                'operation_id': 'delete_entity_color_palettes',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_csp_directives_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/cspDirectives/{id}',
                'operation_id': 'delete_entity_csp_directives',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_custom_application_settings_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId}',
                'operation_id': 'delete_entity_custom_application_settings',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_dashboard_plugins_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId}',
                'operation_id': 'delete_entity_dashboard_plugins',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_data_sources_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/dataSources/{id}',
                'operation_id': 'delete_entity_data_sources',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_filter_contexts_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId}',
                'operation_id': 'delete_entity_filter_contexts',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_metrics_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/metrics/{objectId}',
                'operation_id': 'delete_entity_metrics',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_organization_settings_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/organizationSettings/{id}',
                'operation_id': 'delete_entity_organization_settings',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_themes_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/themes/{id}',
                'operation_id': 'delete_entity_themes',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_user_groups_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/userGroups/{id}',
                'operation_id': 'delete_entity_user_groups',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_user_settings_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/users/{userId}/userSettings/{id}',
                'operation_id': 'delete_entity_user_settings',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_id',
                    'id',
                    'filter',
                ],
                'required': [
                    'user_id',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_id':
                        (str,),
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'user_id': 'userId',
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'user_id': 'path',
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_users_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/users/{id}',
                'operation_id': 'delete_entity_users',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_visualization_objects_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId}',
                'operation_id': 'delete_entity_visualization_objects',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_workspace_data_filters_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId}',
                'operation_id': 'delete_entity_workspace_data_filters',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_workspace_settings_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId}',
                'operation_id': 'delete_entity_workspace_settings',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_workspaces_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{id}',
                'operation_id': 'delete_entity_workspaces',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_analytical_dashboards_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAnalyticalDashboardOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/analyticalDashboards',
                'operation_id': 'get_all_entities_analytical_dashboards',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "VISUALIZATIONOBJECTS": "visualizationObjects",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "FILTERCONTEXTS": "filterContexts",
                        "DASHBOARDPLUGINS": "dashboardPlugins",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "PERMISSIONS": "permissions",
                        "ORIGIN": "origin",
                        "ACCESSINFO": "accessInfo",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_api_tokens_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiApiTokenOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/users/{userId}/apiTokens',
                'operation_id': 'get_all_entities_api_tokens',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_id',
                    'filter',
                    'page',
                    'size',
                    'sort',
                ],
                'required': [
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_id':
                        (str,),
                    'filter':
                        (str,),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                },
                'attribute_map': {
                    'user_id': 'userId',
                    'filter': 'filter',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                },
                'location_map': {
                    'user_id': 'path',
                    'filter': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'sort': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_attributes_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAttributeOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/attributes',
                'operation_id': 'get_all_entities_attributes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "DATASETS": "datasets",
                        "LABELS": "labels",
                        "DATASET": "dataset",
                        "DEFAULTVIEW": "defaultView",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_color_palettes_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiColorPaletteOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/colorPalettes',
                'operation_id': 'get_all_entities_color_palettes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'page',
                    'size',
                    'sort',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                },
                'attribute_map': {
                    'filter': 'filter',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                },
                'location_map': {
                    'filter': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'sort': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_csp_directives_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiCspDirectiveOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/cspDirectives',
                'operation_id': 'get_all_entities_csp_directives',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'page',
                    'size',
                    'sort',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                },
                'attribute_map': {
                    'filter': 'filter',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                },
                'location_map': {
                    'filter': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'sort': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_custom_application_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiCustomApplicationSettingOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/customApplicationSettings',
                'operation_id': 'get_all_entities_custom_application_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_dashboard_plugins_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDashboardPluginOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/dashboardPlugins',
                'operation_id': 'get_all_entities_dashboard_plugins',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_data_source_identifiers_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDataSourceIdentifierOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/dataSourceIdentifiers',
                'operation_id': 'get_all_entities_data_source_identifiers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'page',
                    'size',
                    'sort',
                    'meta_include',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('meta_include',): {

                        "PERMISSIONS": "permissions",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'filter': 'filter',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'filter': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_data_source_tables_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDataSourceTableOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/dataSources/{dataSourceId}/dataSourceTables',
                'operation_id': 'get_all_entities_data_source_tables',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'data_source_id',
                    'filter',
                    'page',
                    'size',
                    'sort',
                ],
                'required': [
                    'data_source_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'data_source_id':
                        (str,),
                    'filter':
                        (str,),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                },
                'attribute_map': {
                    'data_source_id': 'dataSourceId',
                    'filter': 'filter',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                },
                'location_map': {
                    'data_source_id': 'path',
                    'filter': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'sort': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_data_sources_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDataSourceOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/dataSources',
                'operation_id': 'get_all_entities_data_sources',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'page',
                    'size',
                    'sort',
                    'meta_include',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('meta_include',): {

                        "PERMISSIONS": "permissions",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'filter': 'filter',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'filter': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_datasets_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDatasetOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/datasets',
                'operation_id': 'get_all_entities_datasets',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "ATTRIBUTES": "attributes",
                        "FACTS": "facts",
                        "DATASETS": "datasets",
                        "REFERENCES": "references",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_entitlements_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiEntitlementOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/entitlements',
                'operation_id': 'get_all_entities_entitlements',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'page',
                    'size',
                    'sort',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                },
                'attribute_map': {
                    'filter': 'filter',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                },
                'location_map': {
                    'filter': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'sort': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_facts_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFactOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/facts',
                'operation_id': 'get_all_entities_facts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "DATASETS": "datasets",
                        "DATASET": "dataset",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_filter_contexts_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFilterContextOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/filterContexts',
                'operation_id': 'get_all_entities_filter_contexts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "ATTRIBUTES": "attributes",
                        "DATASETS": "datasets",
                        "LABELS": "labels",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_labels_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiLabelOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/labels',
                'operation_id': 'get_all_entities_labels',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "ATTRIBUTES": "attributes",
                        "ATTRIBUTE": "attribute",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_metrics_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiMetricOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/metrics',
                'operation_id': 'get_all_entities_metrics',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_organization_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiOrganizationSettingOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/organizationSettings',
                'operation_id': 'get_all_entities_organization_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'page',
                    'size',
                    'sort',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                },
                'attribute_map': {
                    'filter': 'filter',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                },
                'location_map': {
                    'filter': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'sort': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_themes_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiThemeOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/themes',
                'operation_id': 'get_all_entities_themes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'page',
                    'size',
                    'sort',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                },
                'attribute_map': {
                    'filter': 'filter',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                },
                'location_map': {
                    'filter': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'sort': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_user_groups_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserGroupOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/userGroups',
                'operation_id': 'get_all_entities_user_groups',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "USERGROUPS": "userGroups",
                        "PARENTS": "parents",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                },
                'attribute_map': {
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                },
                'location_map': {
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_user_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserSettingOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/users/{userId}/userSettings',
                'operation_id': 'get_all_entities_user_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_id',
                    'filter',
                    'page',
                    'size',
                    'sort',
                ],
                'required': [
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_id':
                        (str,),
                    'filter':
                        (str,),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                },
                'attribute_map': {
                    'user_id': 'userId',
                    'filter': 'filter',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                },
                'location_map': {
                    'user_id': 'path',
                    'filter': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'sort': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_users_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/users',
                'operation_id': 'get_all_entities_users',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "USERGROUPS": "userGroups",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                },
                'attribute_map': {
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                },
                'location_map': {
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_visualization_objects_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiVisualizationObjectOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/visualizationObjects',
                'operation_id': 'get_all_entities_visualization_objects',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_workspace_data_filter_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceDataFilterSettingOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings',
                'operation_id': 'get_all_entities_workspace_data_filter_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "WORKSPACEDATAFILTERS": "workspaceDataFilters",
                        "WORKSPACEDATAFILTER": "workspaceDataFilter",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_workspace_data_filters_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceDataFilterOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters',
                'operation_id': 'get_all_entities_workspace_data_filters',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "WORKSPACEDATAFILTERSETTINGS": "workspaceDataFilterSettings",
                        "FILTERSETTINGS": "filterSettings",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_workspace_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceSettingOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceSettings',
                'operation_id': 'get_all_entities_workspace_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_workspaces_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces',
                'operation_id': 'get_all_entities_workspaces',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'meta_include',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "WORKSPACES": "workspaces",
                        "PARENT": "parent",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "CONFIG": "config",
                        "PERMISSIONS": "permissions",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_options_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/api/v1/options',
                'operation_id': 'get_all_options',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_data_source_drivers_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/api/v1/options/availableDrivers',
                'operation_id': 'get_data_source_drivers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_analytical_dashboards_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAnalyticalDashboardOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId}',
                'operation_id': 'get_entity_analytical_dashboards',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "VISUALIZATIONOBJECTS": "visualizationObjects",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "FILTERCONTEXTS": "filterContexts",
                        "DASHBOARDPLUGINS": "dashboardPlugins",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "PERMISSIONS": "permissions",
                        "ORIGIN": "origin",
                        "ACCESSINFO": "accessInfo",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_api_tokens_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiApiTokenOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/users/{userId}/apiTokens/{id}',
                'operation_id': 'get_entity_api_tokens',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_id',
                    'id',
                    'filter',
                ],
                'required': [
                    'user_id',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_id':
                        (str,),
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'user_id': 'userId',
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'user_id': 'path',
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_attributes_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAttributeOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/attributes/{objectId}',
                'operation_id': 'get_entity_attributes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "DATASETS": "datasets",
                        "LABELS": "labels",
                        "DATASET": "dataset",
                        "DEFAULTVIEW": "defaultView",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_color_palettes_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiColorPaletteOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/colorPalettes/{id}',
                'operation_id': 'get_entity_color_palettes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_cookie_security_configurations_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiCookieSecurityConfigurationOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/admin/cookieSecurityConfigurations/{id}',
                'operation_id': 'get_entity_cookie_security_configurations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_csp_directives_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiCspDirectiveOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/cspDirectives/{id}',
                'operation_id': 'get_entity_csp_directives',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_custom_application_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiCustomApplicationSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId}',
                'operation_id': 'get_entity_custom_application_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_dashboard_plugins_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDashboardPluginOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId}',
                'operation_id': 'get_entity_dashboard_plugins',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_data_source_identifiers_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDataSourceIdentifierOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/dataSourceIdentifiers/{id}',
                'operation_id': 'get_entity_data_source_identifiers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                    'meta_include',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'meta_include',
                ],
                'validation': [
                    'id',
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('meta_include',): {

                        "PERMISSIONS": "permissions",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_data_source_tables_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDataSourceTableOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/dataSources/{dataSourceId}/dataSourceTables/{id}',
                'operation_id': 'get_entity_data_source_tables',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'data_source_id',
                    'id',
                    'filter',
                ],
                'required': [
                    'data_source_id',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'data_source_id':
                        (str,),
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'data_source_id': 'dataSourceId',
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'data_source_id': 'path',
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_data_sources_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDataSourceOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/dataSources/{id}',
                'operation_id': 'get_entity_data_sources',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                    'meta_include',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'meta_include',
                ],
                'validation': [
                    'id',
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('meta_include',): {

                        "PERMISSIONS": "permissions",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_datasets_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDatasetOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/datasets/{objectId}',
                'operation_id': 'get_entity_datasets',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "ATTRIBUTES": "attributes",
                        "FACTS": "facts",
                        "DATASETS": "datasets",
                        "REFERENCES": "references",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_entitlements_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiEntitlementOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/entitlements/{id}',
                'operation_id': 'get_entity_entitlements',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_facts_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFactOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/facts/{objectId}',
                'operation_id': 'get_entity_facts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "DATASETS": "datasets",
                        "DATASET": "dataset",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_filter_contexts_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFilterContextOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId}',
                'operation_id': 'get_entity_filter_contexts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "ATTRIBUTES": "attributes",
                        "DATASETS": "datasets",
                        "LABELS": "labels",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_labels_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiLabelOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/labels/{objectId}',
                'operation_id': 'get_entity_labels',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "ATTRIBUTES": "attributes",
                        "ATTRIBUTE": "attribute",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_metrics_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiMetricOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/metrics/{objectId}',
                'operation_id': 'get_entity_metrics',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_organization_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiOrganizationSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/organizationSettings/{id}',
                'operation_id': 'get_entity_organization_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_organizations_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiOrganizationOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/admin/organizations/{id}',
                'operation_id': 'get_entity_organizations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'id',
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERS": "users",
                        "USERGROUPS": "userGroups",
                        "BOOTSTRAPUSER": "bootstrapUser",
                        "BOOTSTRAPUSERGROUP": "bootstrapUserGroup",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "PERMISSIONS": "permissions",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_themes_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiThemeOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/themes/{id}',
                'operation_id': 'get_entity_themes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_user_groups_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserGroupOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/userGroups/{id}',
                'operation_id': 'get_entity_user_groups',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                    'include',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERGROUPS": "userGroups",
                        "PARENTS": "parents",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_user_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/users/{userId}/userSettings/{id}',
                'operation_id': 'get_entity_user_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_id',
                    'id',
                    'filter',
                ],
                'required': [
                    'user_id',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_id':
                        (str,),
                    'id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'user_id': 'userId',
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'user_id': 'path',
                    'id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_users_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/users/{id}',
                'operation_id': 'get_entity_users',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                    'include',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERGROUPS": "userGroups",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_visualization_objects_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiVisualizationObjectOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId}',
                'operation_id': 'get_entity_visualization_objects',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_workspace_data_filter_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceDataFilterSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId}',
                'operation_id': 'get_entity_workspace_data_filter_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "WORKSPACEDATAFILTERS": "workspaceDataFilters",
                        "WORKSPACEDATAFILTER": "workspaceDataFilter",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_workspace_data_filters_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceDataFilterOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId}',
                'operation_id': 'get_entity_workspace_data_filters',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "WORKSPACEDATAFILTERSETTINGS": "workspaceDataFilterSettings",
                        "FILTERSETTINGS": "filterSettings",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_workspace_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId}',
                'operation_id': 'get_entity_workspace_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_workspaces_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{id}',
                'operation_id': 'get_entity_workspaces',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'filter',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'id',
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "WORKSPACES": "workspaces",
                        "PARENT": "parent",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "CONFIG": "config",
                        "PERMISSIONS": "permissions",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_organization_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/organization',
                'operation_id': 'get_organization',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'meta_include',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('meta_include',): {

                        "PERMISSIONS": "permissions",
                        "ALL": "all"
                    },
                },
                'openapi_types': {
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.patch_entity_analytical_dashboards_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAnalyticalDashboardOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId}',
                'operation_id': 'patch_entity_analytical_dashboards',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_analytical_dashboard_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_analytical_dashboard_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "VISUALIZATIONOBJECTS": "visualizationObjects",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "FILTERCONTEXTS": "filterContexts",
                        "DASHBOARDPLUGINS": "dashboardPlugins",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_analytical_dashboard_patch_document':
                        (JsonApiAnalyticalDashboardPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_analytical_dashboard_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_color_palettes_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiColorPaletteOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/colorPalettes/{id}',
                'operation_id': 'patch_entity_color_palettes',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_color_palette_patch_document',
                    'filter',
                ],
                'required': [
                    'id',
                    'json_api_color_palette_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_color_palette_patch_document':
                        (JsonApiColorPalettePatchDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_color_palette_patch_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_cookie_security_configurations_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiCookieSecurityConfigurationOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/admin/cookieSecurityConfigurations/{id}',
                'operation_id': 'patch_entity_cookie_security_configurations',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_cookie_security_configuration_patch_document',
                    'filter',
                ],
                'required': [
                    'id',
                    'json_api_cookie_security_configuration_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_cookie_security_configuration_patch_document':
                        (JsonApiCookieSecurityConfigurationPatchDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_cookie_security_configuration_patch_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_csp_directives_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiCspDirectiveOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/cspDirectives/{id}',
                'operation_id': 'patch_entity_csp_directives',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_csp_directive_patch_document',
                    'filter',
                ],
                'required': [
                    'id',
                    'json_api_csp_directive_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_csp_directive_patch_document':
                        (JsonApiCspDirectivePatchDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_csp_directive_patch_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_custom_application_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiCustomApplicationSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId}',
                'operation_id': 'patch_entity_custom_application_settings',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_custom_application_setting_patch_document',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_custom_application_setting_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_custom_application_setting_patch_document':
                        (JsonApiCustomApplicationSettingPatchDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_custom_application_setting_patch_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_dashboard_plugins_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDashboardPluginOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId}',
                'operation_id': 'patch_entity_dashboard_plugins',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_dashboard_plugin_patch_document',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_dashboard_plugin_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_dashboard_plugin_patch_document':
                        (JsonApiDashboardPluginPatchDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_dashboard_plugin_patch_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_data_sources_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDataSourceOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/dataSources/{id}',
                'operation_id': 'patch_entity_data_sources',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_data_source_patch_document',
                    'filter',
                ],
                'required': [
                    'id',
                    'json_api_data_source_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_data_source_patch_document':
                        (JsonApiDataSourcePatchDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_data_source_patch_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_filter_contexts_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFilterContextOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId}',
                'operation_id': 'patch_entity_filter_contexts',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_filter_context_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_filter_context_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "ATTRIBUTES": "attributes",
                        "DATASETS": "datasets",
                        "LABELS": "labels",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_filter_context_patch_document':
                        (JsonApiFilterContextPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_filter_context_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_metrics_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiMetricOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/metrics/{objectId}',
                'operation_id': 'patch_entity_metrics',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_metric_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_metric_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_metric_patch_document':
                        (JsonApiMetricPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_metric_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_organization_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiOrganizationSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/organizationSettings/{id}',
                'operation_id': 'patch_entity_organization_settings',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_organization_setting_patch_document',
                    'filter',
                ],
                'required': [
                    'id',
                    'json_api_organization_setting_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_organization_setting_patch_document':
                        (JsonApiOrganizationSettingPatchDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_organization_setting_patch_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_organizations_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiOrganizationOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/admin/organizations/{id}',
                'operation_id': 'patch_entity_organizations',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_organization_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'id',
                    'json_api_organization_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERS": "users",
                        "USERGROUPS": "userGroups",
                        "BOOTSTRAPUSER": "bootstrapUser",
                        "BOOTSTRAPUSERGROUP": "bootstrapUserGroup",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_organization_patch_document':
                        (JsonApiOrganizationPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_organization_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_themes_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiThemeOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/themes/{id}',
                'operation_id': 'patch_entity_themes',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_theme_patch_document',
                    'filter',
                ],
                'required': [
                    'id',
                    'json_api_theme_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_theme_patch_document':
                        (JsonApiThemePatchDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_theme_patch_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_user_groups_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserGroupOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/userGroups/{id}',
                'operation_id': 'patch_entity_user_groups',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_user_group_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'id',
                    'json_api_user_group_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERGROUPS": "userGroups",
                        "PARENTS": "parents",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_user_group_patch_document':
                        (JsonApiUserGroupPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_user_group_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_users_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/users/{id}',
                'operation_id': 'patch_entity_users',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_user_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'id',
                    'json_api_user_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERGROUPS": "userGroups",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_user_patch_document':
                        (JsonApiUserPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_user_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_visualization_objects_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiVisualizationObjectOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId}',
                'operation_id': 'patch_entity_visualization_objects',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_visualization_object_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_visualization_object_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_visualization_object_patch_document':
                        (JsonApiVisualizationObjectPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_visualization_object_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_workspace_data_filters_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceDataFilterOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId}',
                'operation_id': 'patch_entity_workspace_data_filters',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_data_filter_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_data_filter_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "WORKSPACEDATAFILTERSETTINGS": "workspaceDataFilterSettings",
                        "FILTERSETTINGS": "filterSettings",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_workspace_data_filter_patch_document':
                        (JsonApiWorkspaceDataFilterPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_workspace_data_filter_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_workspace_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId}',
                'operation_id': 'patch_entity_workspace_settings',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_setting_patch_document',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_setting_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_workspace_setting_patch_document':
                        (JsonApiWorkspaceSettingPatchDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_workspace_setting_patch_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_workspaces_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{id}',
                'operation_id': 'patch_entity_workspaces',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_workspace_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'id',
                    'json_api_workspace_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('include',): {

                        "WORKSPACES": "workspaces",
                        "PARENT": "parent",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_workspace_patch_document':
                        (JsonApiWorkspacePatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_workspace_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_analytical_dashboards_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAnalyticalDashboardOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId}',
                'operation_id': 'update_entity_analytical_dashboards',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_analytical_dashboard_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_analytical_dashboard_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "VISUALIZATIONOBJECTS": "visualizationObjects",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "FILTERCONTEXTS": "filterContexts",
                        "DASHBOARDPLUGINS": "dashboardPlugins",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_analytical_dashboard_in_document':
                        (JsonApiAnalyticalDashboardInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_analytical_dashboard_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_api_tokens_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiApiTokenOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/users/{userId}/apiTokens/{id}',
                'operation_id': 'update_entity_api_tokens',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_id',
                    'id',
                    'json_api_api_token_in_document',
                    'filter',
                ],
                'required': [
                    'user_id',
                    'id',
                    'json_api_api_token_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_id':
                        (str,),
                    'id':
                        (str,),
                    'json_api_api_token_in_document':
                        (JsonApiApiTokenInDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'user_id': 'userId',
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'user_id': 'path',
                    'id': 'path',
                    'json_api_api_token_in_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_color_palettes_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiColorPaletteOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/colorPalettes/{id}',
                'operation_id': 'update_entity_color_palettes',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_color_palette_in_document',
                    'filter',
                ],
                'required': [
                    'id',
                    'json_api_color_palette_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_color_palette_in_document':
                        (JsonApiColorPaletteInDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_color_palette_in_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_cookie_security_configurations_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiCookieSecurityConfigurationOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/admin/cookieSecurityConfigurations/{id}',
                'operation_id': 'update_entity_cookie_security_configurations',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_cookie_security_configuration_in_document',
                    'filter',
                ],
                'required': [
                    'id',
                    'json_api_cookie_security_configuration_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_cookie_security_configuration_in_document':
                        (JsonApiCookieSecurityConfigurationInDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_cookie_security_configuration_in_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_csp_directives_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiCspDirectiveOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/cspDirectives/{id}',
                'operation_id': 'update_entity_csp_directives',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_csp_directive_in_document',
                    'filter',
                ],
                'required': [
                    'id',
                    'json_api_csp_directive_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_csp_directive_in_document':
                        (JsonApiCspDirectiveInDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_csp_directive_in_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_custom_application_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiCustomApplicationSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId}',
                'operation_id': 'update_entity_custom_application_settings',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_custom_application_setting_in_document',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_custom_application_setting_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_custom_application_setting_in_document':
                        (JsonApiCustomApplicationSettingInDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_custom_application_setting_in_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_dashboard_plugins_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDashboardPluginOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId}',
                'operation_id': 'update_entity_dashboard_plugins',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_dashboard_plugin_in_document',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_dashboard_plugin_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_dashboard_plugin_in_document':
                        (JsonApiDashboardPluginInDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_dashboard_plugin_in_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_data_sources_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDataSourceOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/dataSources/{id}',
                'operation_id': 'update_entity_data_sources',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_data_source_in_document',
                    'filter',
                ],
                'required': [
                    'id',
                    'json_api_data_source_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_data_source_in_document':
                        (JsonApiDataSourceInDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_data_source_in_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_filter_contexts_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFilterContextOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId}',
                'operation_id': 'update_entity_filter_contexts',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_filter_context_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_filter_context_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "ATTRIBUTES": "attributes",
                        "DATASETS": "datasets",
                        "LABELS": "labels",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_filter_context_in_document':
                        (JsonApiFilterContextInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_filter_context_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_metrics_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiMetricOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/metrics/{objectId}',
                'operation_id': 'update_entity_metrics',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_metric_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_metric_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_metric_in_document':
                        (JsonApiMetricInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_metric_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_organization_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiOrganizationSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/organizationSettings/{id}',
                'operation_id': 'update_entity_organization_settings',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_organization_setting_in_document',
                    'filter',
                ],
                'required': [
                    'id',
                    'json_api_organization_setting_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_organization_setting_in_document':
                        (JsonApiOrganizationSettingInDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_organization_setting_in_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_organizations_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiOrganizationOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/admin/organizations/{id}',
                'operation_id': 'update_entity_organizations',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_organization_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'id',
                    'json_api_organization_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERS": "users",
                        "USERGROUPS": "userGroups",
                        "BOOTSTRAPUSER": "bootstrapUser",
                        "BOOTSTRAPUSERGROUP": "bootstrapUserGroup",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_organization_in_document':
                        (JsonApiOrganizationInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_organization_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_themes_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiThemeOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/themes/{id}',
                'operation_id': 'update_entity_themes',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_theme_in_document',
                    'filter',
                ],
                'required': [
                    'id',
                    'json_api_theme_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_theme_in_document':
                        (JsonApiThemeInDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_theme_in_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_user_groups_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserGroupOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/userGroups/{id}',
                'operation_id': 'update_entity_user_groups',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_user_group_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'id',
                    'json_api_user_group_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERGROUPS": "userGroups",
                        "PARENTS": "parents",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_user_group_in_document':
                        (JsonApiUserGroupInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_user_group_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_user_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/users/{userId}/userSettings/{id}',
                'operation_id': 'update_entity_user_settings',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_id',
                    'id',
                    'json_api_user_setting_in_document',
                    'filter',
                ],
                'required': [
                    'user_id',
                    'id',
                    'json_api_user_setting_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_id':
                        (str,),
                    'id':
                        (str,),
                    'json_api_user_setting_in_document':
                        (JsonApiUserSettingInDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'user_id': 'userId',
                    'id': 'id',
                    'filter': 'filter',
                },
                'location_map': {
                    'user_id': 'path',
                    'id': 'path',
                    'json_api_user_setting_in_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_users_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/users/{id}',
                'operation_id': 'update_entity_users',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_user_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'id',
                    'json_api_user_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERGROUPS": "userGroups",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_user_in_document':
                        (JsonApiUserInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_user_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_visualization_objects_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiVisualizationObjectOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId}',
                'operation_id': 'update_entity_visualization_objects',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_visualization_object_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_visualization_object_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_visualization_object_in_document':
                        (JsonApiVisualizationObjectInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_visualization_object_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_workspace_data_filters_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceDataFilterOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId}',
                'operation_id': 'update_entity_workspace_data_filters',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_data_filter_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_data_filter_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "WORKSPACEDATAFILTERSETTINGS": "workspaceDataFilterSettings",
                        "FILTERSETTINGS": "filterSettings",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_workspace_data_filter_in_document':
                        (JsonApiWorkspaceDataFilterInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_workspace_data_filter_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_workspace_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId}',
                'operation_id': 'update_entity_workspace_settings',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_setting_in_document',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_setting_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_workspace_setting_in_document':
                        (JsonApiWorkspaceSettingInDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_workspace_setting_in_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_workspaces_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{id}',
                'operation_id': 'update_entity_workspaces',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'json_api_workspace_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'id',
                    'json_api_workspace_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^(?!\.)[.A-Za-z0-9_-]{1,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('include',): {

                        "WORKSPACES": "workspaces",
                        "PARENT": "parent",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'json_api_workspace_in_document':
                        (JsonApiWorkspaceInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'id': 'path',
                    'json_api_workspace_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )

    def create_entity_analytical_dashboards(
        self,
        workspace_id,
        json_api_analytical_dashboard_in_document,
        **kwargs
    ):
        """create_entity_analytical_dashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_analytical_dashboards(workspace_id, json_api_analytical_dashboard_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_analytical_dashboard_in_document (JsonApiAnalyticalDashboardInDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAnalyticalDashboardOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_analytical_dashboard_in_document'] = \
            json_api_analytical_dashboard_in_document
        return self.create_entity_analytical_dashboards_endpoint.call_with_http_info(**kwargs)

    def create_entity_api_tokens(
        self,
        user_id,
        json_api_api_token_in_document,
        **kwargs
    ):
        """create_entity_api_tokens  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_api_tokens(user_id, json_api_api_token_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            user_id (str):
            json_api_api_token_in_document (JsonApiApiTokenInDocument):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiApiTokenOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['user_id'] = \
            user_id
        kwargs['json_api_api_token_in_document'] = \
            json_api_api_token_in_document
        return self.create_entity_api_tokens_endpoint.call_with_http_info(**kwargs)

    def create_entity_color_palettes(
        self,
        json_api_color_palette_in_document,
        **kwargs
    ):
        """create_entity_color_palettes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_color_palettes(json_api_color_palette_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            json_api_color_palette_in_document (JsonApiColorPaletteInDocument):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiColorPaletteOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['json_api_color_palette_in_document'] = \
            json_api_color_palette_in_document
        return self.create_entity_color_palettes_endpoint.call_with_http_info(**kwargs)

    def create_entity_csp_directives(
        self,
        json_api_csp_directive_in_document,
        **kwargs
    ):
        """create_entity_csp_directives  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_csp_directives(json_api_csp_directive_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            json_api_csp_directive_in_document (JsonApiCspDirectiveInDocument):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiCspDirectiveOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['json_api_csp_directive_in_document'] = \
            json_api_csp_directive_in_document
        return self.create_entity_csp_directives_endpoint.call_with_http_info(**kwargs)

    def create_entity_custom_application_settings(
        self,
        workspace_id,
        json_api_custom_application_setting_in_document,
        **kwargs
    ):
        """create_entity_custom_application_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_custom_application_settings(workspace_id, json_api_custom_application_setting_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_custom_application_setting_in_document (JsonApiCustomApplicationSettingInDocument):

        Keyword Args:
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiCustomApplicationSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_custom_application_setting_in_document'] = \
            json_api_custom_application_setting_in_document
        return self.create_entity_custom_application_settings_endpoint.call_with_http_info(**kwargs)

    def create_entity_dashboard_plugins(
        self,
        workspace_id,
        json_api_dashboard_plugin_in_document,
        **kwargs
    ):
        """create_entity_dashboard_plugins  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_dashboard_plugins(workspace_id, json_api_dashboard_plugin_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_dashboard_plugin_in_document (JsonApiDashboardPluginInDocument):

        Keyword Args:
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDashboardPluginOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_dashboard_plugin_in_document'] = \
            json_api_dashboard_plugin_in_document
        return self.create_entity_dashboard_plugins_endpoint.call_with_http_info(**kwargs)

    def create_entity_data_sources(
        self,
        json_api_data_source_in_document,
        **kwargs
    ):
        """create_entity_data_sources  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_data_sources(json_api_data_source_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            json_api_data_source_in_document (JsonApiDataSourceInDocument):

        Keyword Args:
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDataSourceOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['json_api_data_source_in_document'] = \
            json_api_data_source_in_document
        return self.create_entity_data_sources_endpoint.call_with_http_info(**kwargs)

    def create_entity_filter_contexts(
        self,
        workspace_id,
        json_api_filter_context_in_document,
        **kwargs
    ):
        """create_entity_filter_contexts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_filter_contexts(workspace_id, json_api_filter_context_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_filter_context_in_document (JsonApiFilterContextInDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFilterContextOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_filter_context_in_document'] = \
            json_api_filter_context_in_document
        return self.create_entity_filter_contexts_endpoint.call_with_http_info(**kwargs)

    def create_entity_metrics(
        self,
        workspace_id,
        json_api_metric_in_document,
        **kwargs
    ):
        """create_entity_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_metrics(workspace_id, json_api_metric_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_metric_in_document (JsonApiMetricInDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiMetricOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_metric_in_document'] = \
            json_api_metric_in_document
        return self.create_entity_metrics_endpoint.call_with_http_info(**kwargs)

    def create_entity_organization_settings(
        self,
        json_api_organization_setting_in_document,
        **kwargs
    ):
        """create_entity_organization_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_organization_settings(json_api_organization_setting_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            json_api_organization_setting_in_document (JsonApiOrganizationSettingInDocument):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiOrganizationSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['json_api_organization_setting_in_document'] = \
            json_api_organization_setting_in_document
        return self.create_entity_organization_settings_endpoint.call_with_http_info(**kwargs)

    def create_entity_themes(
        self,
        json_api_theme_in_document,
        **kwargs
    ):
        """create_entity_themes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_themes(json_api_theme_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            json_api_theme_in_document (JsonApiThemeInDocument):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiThemeOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['json_api_theme_in_document'] = \
            json_api_theme_in_document
        return self.create_entity_themes_endpoint.call_with_http_info(**kwargs)

    def create_entity_user_groups(
        self,
        json_api_user_group_in_document,
        **kwargs
    ):
        """create_entity_user_groups  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_user_groups(json_api_user_group_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            json_api_user_group_in_document (JsonApiUserGroupInDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserGroupOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['json_api_user_group_in_document'] = \
            json_api_user_group_in_document
        return self.create_entity_user_groups_endpoint.call_with_http_info(**kwargs)

    def create_entity_user_settings(
        self,
        user_id,
        json_api_user_setting_in_document,
        **kwargs
    ):
        """create_entity_user_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_user_settings(user_id, json_api_user_setting_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            user_id (str):
            json_api_user_setting_in_document (JsonApiUserSettingInDocument):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['user_id'] = \
            user_id
        kwargs['json_api_user_setting_in_document'] = \
            json_api_user_setting_in_document
        return self.create_entity_user_settings_endpoint.call_with_http_info(**kwargs)

    def create_entity_users(
        self,
        json_api_user_in_document,
        **kwargs
    ):
        """create_entity_users  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_users(json_api_user_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            json_api_user_in_document (JsonApiUserInDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['json_api_user_in_document'] = \
            json_api_user_in_document
        return self.create_entity_users_endpoint.call_with_http_info(**kwargs)

    def create_entity_visualization_objects(
        self,
        workspace_id,
        json_api_visualization_object_in_document,
        **kwargs
    ):
        """create_entity_visualization_objects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_visualization_objects(workspace_id, json_api_visualization_object_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_visualization_object_in_document (JsonApiVisualizationObjectInDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiVisualizationObjectOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_visualization_object_in_document'] = \
            json_api_visualization_object_in_document
        return self.create_entity_visualization_objects_endpoint.call_with_http_info(**kwargs)

    def create_entity_workspace_data_filters(
        self,
        workspace_id,
        json_api_workspace_data_filter_in_document,
        **kwargs
    ):
        """create_entity_workspace_data_filters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_workspace_data_filters(workspace_id, json_api_workspace_data_filter_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_workspace_data_filter_in_document (JsonApiWorkspaceDataFilterInDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceDataFilterOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_workspace_data_filter_in_document'] = \
            json_api_workspace_data_filter_in_document
        return self.create_entity_workspace_data_filters_endpoint.call_with_http_info(**kwargs)

    def create_entity_workspace_settings(
        self,
        workspace_id,
        json_api_workspace_setting_in_document,
        **kwargs
    ):
        """create_entity_workspace_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_workspace_settings(workspace_id, json_api_workspace_setting_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_workspace_setting_in_document (JsonApiWorkspaceSettingInDocument):

        Keyword Args:
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_workspace_setting_in_document'] = \
            json_api_workspace_setting_in_document
        return self.create_entity_workspace_settings_endpoint.call_with_http_info(**kwargs)

    def create_entity_workspaces(
        self,
        json_api_workspace_in_document,
        **kwargs
    ):
        """create_entity_workspaces  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_workspaces(json_api_workspace_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            json_api_workspace_in_document (JsonApiWorkspaceInDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['json_api_workspace_in_document'] = \
            json_api_workspace_in_document
        return self.create_entity_workspaces_endpoint.call_with_http_info(**kwargs)

    def delete_entity_analytical_dashboards(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """delete_entity_analytical_dashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_analytical_dashboards(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_analytical_dashboards_endpoint.call_with_http_info(**kwargs)

    def delete_entity_api_tokens(
        self,
        user_id,
        id,
        **kwargs
    ):
        """delete_entity_api_tokens  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_api_tokens(user_id, id, async_req=True)
        >>> result = thread.get()

        Args:
            user_id (str):
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['user_id'] = \
            user_id
        kwargs['id'] = \
            id
        return self.delete_entity_api_tokens_endpoint.call_with_http_info(**kwargs)

    def delete_entity_color_palettes(
        self,
        id,
        **kwargs
    ):
        """delete_entity_color_palettes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_color_palettes(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.delete_entity_color_palettes_endpoint.call_with_http_info(**kwargs)

    def delete_entity_csp_directives(
        self,
        id,
        **kwargs
    ):
        """delete_entity_csp_directives  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_csp_directives(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.delete_entity_csp_directives_endpoint.call_with_http_info(**kwargs)

    def delete_entity_custom_application_settings(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """delete_entity_custom_application_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_custom_application_settings(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_custom_application_settings_endpoint.call_with_http_info(**kwargs)

    def delete_entity_dashboard_plugins(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """delete_entity_dashboard_plugins  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_dashboard_plugins(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_dashboard_plugins_endpoint.call_with_http_info(**kwargs)

    def delete_entity_data_sources(
        self,
        id,
        **kwargs
    ):
        """delete_entity_data_sources  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_data_sources(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.delete_entity_data_sources_endpoint.call_with_http_info(**kwargs)

    def delete_entity_filter_contexts(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """delete_entity_filter_contexts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_filter_contexts(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_filter_contexts_endpoint.call_with_http_info(**kwargs)

    def delete_entity_metrics(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """delete_entity_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_metrics(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_metrics_endpoint.call_with_http_info(**kwargs)

    def delete_entity_organization_settings(
        self,
        id,
        **kwargs
    ):
        """delete_entity_organization_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_organization_settings(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.delete_entity_organization_settings_endpoint.call_with_http_info(**kwargs)

    def delete_entity_themes(
        self,
        id,
        **kwargs
    ):
        """delete_entity_themes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_themes(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.delete_entity_themes_endpoint.call_with_http_info(**kwargs)

    def delete_entity_user_groups(
        self,
        id,
        **kwargs
    ):
        """delete_entity_user_groups  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_user_groups(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.delete_entity_user_groups_endpoint.call_with_http_info(**kwargs)

    def delete_entity_user_settings(
        self,
        user_id,
        id,
        **kwargs
    ):
        """delete_entity_user_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_user_settings(user_id, id, async_req=True)
        >>> result = thread.get()

        Args:
            user_id (str):
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['user_id'] = \
            user_id
        kwargs['id'] = \
            id
        return self.delete_entity_user_settings_endpoint.call_with_http_info(**kwargs)

    def delete_entity_users(
        self,
        id,
        **kwargs
    ):
        """delete_entity_users  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_users(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.delete_entity_users_endpoint.call_with_http_info(**kwargs)

    def delete_entity_visualization_objects(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """delete_entity_visualization_objects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_visualization_objects(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_visualization_objects_endpoint.call_with_http_info(**kwargs)

    def delete_entity_workspace_data_filters(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """delete_entity_workspace_data_filters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_workspace_data_filters(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_workspace_data_filters_endpoint.call_with_http_info(**kwargs)

    def delete_entity_workspace_settings(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """delete_entity_workspace_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_workspace_settings(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_workspace_settings_endpoint.call_with_http_info(**kwargs)

    def delete_entity_workspaces(
        self,
        id,
        **kwargs
    ):
        """delete_entity_workspaces  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_workspaces(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.delete_entity_workspaces_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_analytical_dashboards(
        self,
        workspace_id,
        **kwargs
    ):
        """get_all_entities_analytical_dashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_analytical_dashboards(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAnalyticalDashboardOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_analytical_dashboards_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_api_tokens(
        self,
        user_id,
        **kwargs
    ):
        """List all api tokens for a user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_api_tokens(user_id, async_req=True)
        >>> result = thread.get()

        Args:
            user_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiApiTokenOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['user_id'] = \
            user_id
        return self.get_all_entities_api_tokens_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_attributes(
        self,
        workspace_id,
        **kwargs
    ):
        """get_all_entities_attributes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_attributes(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAttributeOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_attributes_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_color_palettes(
        self,
        **kwargs
    ):
        """get_all_entities_color_palettes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_color_palettes(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiColorPaletteOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_entities_color_palettes_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_csp_directives(
        self,
        **kwargs
    ):
        """get_all_entities_csp_directives  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_csp_directives(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiCspDirectiveOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_entities_csp_directives_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_custom_application_settings(
        self,
        workspace_id,
        **kwargs
    ):
        """get_all_entities_custom_application_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_custom_application_settings(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiCustomApplicationSettingOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_custom_application_settings_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_dashboard_plugins(
        self,
        workspace_id,
        **kwargs
    ):
        """get_all_entities_dashboard_plugins  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_dashboard_plugins(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDashboardPluginOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_dashboard_plugins_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_data_source_identifiers(
        self,
        **kwargs
    ):
        """get_all_entities_data_source_identifiers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_data_source_identifiers(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDataSourceIdentifierOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_entities_data_source_identifiers_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_data_source_tables(
        self,
        data_source_id,
        **kwargs
    ):
        """get_all_entities_data_source_tables  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_data_source_tables(data_source_id, async_req=True)
        >>> result = thread.get()

        Args:
            data_source_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDataSourceTableOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['data_source_id'] = \
            data_source_id
        return self.get_all_entities_data_source_tables_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_data_sources(
        self,
        **kwargs
    ):
        """get_all_entities_data_sources  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_data_sources(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDataSourceOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_entities_data_sources_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_datasets(
        self,
        workspace_id,
        **kwargs
    ):
        """get_all_entities_datasets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_datasets(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDatasetOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_datasets_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_entitlements(
        self,
        **kwargs
    ):
        """get_all_entities_entitlements  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_entitlements(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiEntitlementOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_entities_entitlements_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_facts(
        self,
        workspace_id,
        **kwargs
    ):
        """get_all_entities_facts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_facts(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFactOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_facts_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_filter_contexts(
        self,
        workspace_id,
        **kwargs
    ):
        """get_all_entities_filter_contexts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_filter_contexts(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFilterContextOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_filter_contexts_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_labels(
        self,
        workspace_id,
        **kwargs
    ):
        """get_all_entities_labels  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_labels(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiLabelOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_labels_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_metrics(
        self,
        workspace_id,
        **kwargs
    ):
        """get_all_entities_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_metrics(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiMetricOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_metrics_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_organization_settings(
        self,
        **kwargs
    ):
        """get_all_entities_organization_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_organization_settings(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiOrganizationSettingOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_entities_organization_settings_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_themes(
        self,
        **kwargs
    ):
        """get_all_entities_themes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_themes(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiThemeOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_entities_themes_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_user_groups(
        self,
        **kwargs
    ):
        """get_all_entities_user_groups  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_user_groups(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserGroupOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_entities_user_groups_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_user_settings(
        self,
        user_id,
        **kwargs
    ):
        """List all settings for a user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_user_settings(user_id, async_req=True)
        >>> result = thread.get()

        Args:
            user_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserSettingOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['user_id'] = \
            user_id
        return self.get_all_entities_user_settings_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_users(
        self,
        **kwargs
    ):
        """get_all_entities_users  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_users(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_entities_users_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_visualization_objects(
        self,
        workspace_id,
        **kwargs
    ):
        """get_all_entities_visualization_objects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_visualization_objects(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiVisualizationObjectOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_visualization_objects_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_workspace_data_filter_settings(
        self,
        workspace_id,
        **kwargs
    ):
        """get_all_entities_workspace_data_filter_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_workspace_data_filter_settings(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceDataFilterSettingOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_workspace_data_filter_settings_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_workspace_data_filters(
        self,
        workspace_id,
        **kwargs
    ):
        """get_all_entities_workspace_data_filters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_workspace_data_filters(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceDataFilterOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_workspace_data_filters_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_workspace_settings(
        self,
        workspace_id,
        **kwargs
    ):
        """get_all_entities_workspace_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_workspace_settings(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceSettingOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_workspace_settings_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_workspaces(
        self,
        **kwargs
    ):
        """get_all_entities_workspaces  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_workspaces(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_entities_workspaces_endpoint.call_with_http_info(**kwargs)

    def get_all_options(
        self,
        **kwargs
    ):
        """Links for all configuration options  # noqa: E501

        Retrieves links for all options for different configurations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_options(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_all_options_endpoint.call_with_http_info(**kwargs)

    def get_data_source_drivers(
        self,
        **kwargs
    ):
        """Get all available data source drivers  # noqa: E501

        Retrieves a list of all supported data sources along with information about the used drivers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_data_source_drivers(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_data_source_drivers_endpoint.call_with_http_info(**kwargs)

    def get_entity_analytical_dashboards(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """get_entity_analytical_dashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_analytical_dashboards(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAnalyticalDashboardOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_analytical_dashboards_endpoint.call_with_http_info(**kwargs)

    def get_entity_api_tokens(
        self,
        user_id,
        id,
        **kwargs
    ):
        """get_entity_api_tokens  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_api_tokens(user_id, id, async_req=True)
        >>> result = thread.get()

        Args:
            user_id (str):
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiApiTokenOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['user_id'] = \
            user_id
        kwargs['id'] = \
            id
        return self.get_entity_api_tokens_endpoint.call_with_http_info(**kwargs)

    def get_entity_attributes(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """get_entity_attributes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_attributes(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAttributeOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_attributes_endpoint.call_with_http_info(**kwargs)

    def get_entity_color_palettes(
        self,
        id,
        **kwargs
    ):
        """get_entity_color_palettes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_color_palettes(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiColorPaletteOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_entity_color_palettes_endpoint.call_with_http_info(**kwargs)

    def get_entity_cookie_security_configurations(
        self,
        id,
        **kwargs
    ):
        """get_entity_cookie_security_configurations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_cookie_security_configurations(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiCookieSecurityConfigurationOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_entity_cookie_security_configurations_endpoint.call_with_http_info(**kwargs)

    def get_entity_csp_directives(
        self,
        id,
        **kwargs
    ):
        """get_entity_csp_directives  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_csp_directives(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiCspDirectiveOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_entity_csp_directives_endpoint.call_with_http_info(**kwargs)

    def get_entity_custom_application_settings(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """get_entity_custom_application_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_custom_application_settings(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiCustomApplicationSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_custom_application_settings_endpoint.call_with_http_info(**kwargs)

    def get_entity_dashboard_plugins(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """get_entity_dashboard_plugins  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_dashboard_plugins(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDashboardPluginOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_dashboard_plugins_endpoint.call_with_http_info(**kwargs)

    def get_entity_data_source_identifiers(
        self,
        id,
        **kwargs
    ):
        """get_entity_data_source_identifiers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_data_source_identifiers(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDataSourceIdentifierOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_entity_data_source_identifiers_endpoint.call_with_http_info(**kwargs)

    def get_entity_data_source_tables(
        self,
        data_source_id,
        id,
        **kwargs
    ):
        """get_entity_data_source_tables  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_data_source_tables(data_source_id, id, async_req=True)
        >>> result = thread.get()

        Args:
            data_source_id (str):
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDataSourceTableOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['data_source_id'] = \
            data_source_id
        kwargs['id'] = \
            id
        return self.get_entity_data_source_tables_endpoint.call_with_http_info(**kwargs)

    def get_entity_data_sources(
        self,
        id,
        **kwargs
    ):
        """get_entity_data_sources  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_data_sources(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDataSourceOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_entity_data_sources_endpoint.call_with_http_info(**kwargs)

    def get_entity_datasets(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """get_entity_datasets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_datasets(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDatasetOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_datasets_endpoint.call_with_http_info(**kwargs)

    def get_entity_entitlements(
        self,
        id,
        **kwargs
    ):
        """get_entity_entitlements  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_entitlements(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiEntitlementOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_entity_entitlements_endpoint.call_with_http_info(**kwargs)

    def get_entity_facts(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """get_entity_facts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_facts(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFactOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_facts_endpoint.call_with_http_info(**kwargs)

    def get_entity_filter_contexts(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """get_entity_filter_contexts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_filter_contexts(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFilterContextOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_filter_contexts_endpoint.call_with_http_info(**kwargs)

    def get_entity_labels(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """get_entity_labels  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_labels(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiLabelOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_labels_endpoint.call_with_http_info(**kwargs)

    def get_entity_metrics(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """get_entity_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_metrics(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiMetricOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_metrics_endpoint.call_with_http_info(**kwargs)

    def get_entity_organization_settings(
        self,
        id,
        **kwargs
    ):
        """get_entity_organization_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_organization_settings(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiOrganizationSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_entity_organization_settings_endpoint.call_with_http_info(**kwargs)

    def get_entity_organizations(
        self,
        id,
        **kwargs
    ):
        """get_entity_organizations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_organizations(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiOrganizationOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_entity_organizations_endpoint.call_with_http_info(**kwargs)

    def get_entity_themes(
        self,
        id,
        **kwargs
    ):
        """get_entity_themes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_themes(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiThemeOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_entity_themes_endpoint.call_with_http_info(**kwargs)

    def get_entity_user_groups(
        self,
        id,
        **kwargs
    ):
        """get_entity_user_groups  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_user_groups(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserGroupOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_entity_user_groups_endpoint.call_with_http_info(**kwargs)

    def get_entity_user_settings(
        self,
        user_id,
        id,
        **kwargs
    ):
        """get_entity_user_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_user_settings(user_id, id, async_req=True)
        >>> result = thread.get()

        Args:
            user_id (str):
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['user_id'] = \
            user_id
        kwargs['id'] = \
            id
        return self.get_entity_user_settings_endpoint.call_with_http_info(**kwargs)

    def get_entity_users(
        self,
        id,
        **kwargs
    ):
        """get_entity_users  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_users(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_entity_users_endpoint.call_with_http_info(**kwargs)

    def get_entity_visualization_objects(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """get_entity_visualization_objects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_visualization_objects(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiVisualizationObjectOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_visualization_objects_endpoint.call_with_http_info(**kwargs)

    def get_entity_workspace_data_filter_settings(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """get_entity_workspace_data_filter_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_workspace_data_filter_settings(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceDataFilterSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_workspace_data_filter_settings_endpoint.call_with_http_info(**kwargs)

    def get_entity_workspace_data_filters(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """get_entity_workspace_data_filters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_workspace_data_filters(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceDataFilterOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_workspace_data_filters_endpoint.call_with_http_info(**kwargs)

    def get_entity_workspace_settings(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """get_entity_workspace_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_workspace_settings(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_workspace_settings_endpoint.call_with_http_info(**kwargs)

    def get_entity_workspaces(
        self,
        id,
        **kwargs
    ):
        """get_entity_workspaces  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_workspaces(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_entity_workspaces_endpoint.call_with_http_info(**kwargs)

    def get_organization(
        self,
        **kwargs
    ):
        """Get current organization info  # noqa: E501

        Gets a basic information about organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_organization(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            meta_include ([str]): Return list of permissions available to logged user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_organization_endpoint.call_with_http_info(**kwargs)

    def patch_entity_analytical_dashboards(
        self,
        workspace_id,
        object_id,
        json_api_analytical_dashboard_patch_document,
        **kwargs
    ):
        """patch_entity_analytical_dashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_analytical_dashboards(workspace_id, object_id, json_api_analytical_dashboard_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_analytical_dashboard_patch_document (JsonApiAnalyticalDashboardPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAnalyticalDashboardOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_analytical_dashboard_patch_document'] = \
            json_api_analytical_dashboard_patch_document
        return self.patch_entity_analytical_dashboards_endpoint.call_with_http_info(**kwargs)

    def patch_entity_color_palettes(
        self,
        id,
        json_api_color_palette_patch_document,
        **kwargs
    ):
        """patch_entity_color_palettes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_color_palettes(id, json_api_color_palette_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_color_palette_patch_document (JsonApiColorPalettePatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiColorPaletteOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_color_palette_patch_document'] = \
            json_api_color_palette_patch_document
        return self.patch_entity_color_palettes_endpoint.call_with_http_info(**kwargs)

    def patch_entity_cookie_security_configurations(
        self,
        id,
        json_api_cookie_security_configuration_patch_document,
        **kwargs
    ):
        """patch_entity_cookie_security_configurations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_cookie_security_configurations(id, json_api_cookie_security_configuration_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_cookie_security_configuration_patch_document (JsonApiCookieSecurityConfigurationPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiCookieSecurityConfigurationOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_cookie_security_configuration_patch_document'] = \
            json_api_cookie_security_configuration_patch_document
        return self.patch_entity_cookie_security_configurations_endpoint.call_with_http_info(**kwargs)

    def patch_entity_csp_directives(
        self,
        id,
        json_api_csp_directive_patch_document,
        **kwargs
    ):
        """patch_entity_csp_directives  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_csp_directives(id, json_api_csp_directive_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_csp_directive_patch_document (JsonApiCspDirectivePatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiCspDirectiveOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_csp_directive_patch_document'] = \
            json_api_csp_directive_patch_document
        return self.patch_entity_csp_directives_endpoint.call_with_http_info(**kwargs)

    def patch_entity_custom_application_settings(
        self,
        workspace_id,
        object_id,
        json_api_custom_application_setting_patch_document,
        **kwargs
    ):
        """patch_entity_custom_application_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_custom_application_settings(workspace_id, object_id, json_api_custom_application_setting_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_custom_application_setting_patch_document (JsonApiCustomApplicationSettingPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiCustomApplicationSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_custom_application_setting_patch_document'] = \
            json_api_custom_application_setting_patch_document
        return self.patch_entity_custom_application_settings_endpoint.call_with_http_info(**kwargs)

    def patch_entity_dashboard_plugins(
        self,
        workspace_id,
        object_id,
        json_api_dashboard_plugin_patch_document,
        **kwargs
    ):
        """patch_entity_dashboard_plugins  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_dashboard_plugins(workspace_id, object_id, json_api_dashboard_plugin_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_dashboard_plugin_patch_document (JsonApiDashboardPluginPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDashboardPluginOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_dashboard_plugin_patch_document'] = \
            json_api_dashboard_plugin_patch_document
        return self.patch_entity_dashboard_plugins_endpoint.call_with_http_info(**kwargs)

    def patch_entity_data_sources(
        self,
        id,
        json_api_data_source_patch_document,
        **kwargs
    ):
        """patch_entity_data_sources  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_data_sources(id, json_api_data_source_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_data_source_patch_document (JsonApiDataSourcePatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDataSourceOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_data_source_patch_document'] = \
            json_api_data_source_patch_document
        return self.patch_entity_data_sources_endpoint.call_with_http_info(**kwargs)

    def patch_entity_filter_contexts(
        self,
        workspace_id,
        object_id,
        json_api_filter_context_patch_document,
        **kwargs
    ):
        """patch_entity_filter_contexts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_filter_contexts(workspace_id, object_id, json_api_filter_context_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_filter_context_patch_document (JsonApiFilterContextPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFilterContextOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_filter_context_patch_document'] = \
            json_api_filter_context_patch_document
        return self.patch_entity_filter_contexts_endpoint.call_with_http_info(**kwargs)

    def patch_entity_metrics(
        self,
        workspace_id,
        object_id,
        json_api_metric_patch_document,
        **kwargs
    ):
        """patch_entity_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_metrics(workspace_id, object_id, json_api_metric_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_metric_patch_document (JsonApiMetricPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiMetricOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_metric_patch_document'] = \
            json_api_metric_patch_document
        return self.patch_entity_metrics_endpoint.call_with_http_info(**kwargs)

    def patch_entity_organization_settings(
        self,
        id,
        json_api_organization_setting_patch_document,
        **kwargs
    ):
        """patch_entity_organization_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_organization_settings(id, json_api_organization_setting_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_organization_setting_patch_document (JsonApiOrganizationSettingPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiOrganizationSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_organization_setting_patch_document'] = \
            json_api_organization_setting_patch_document
        return self.patch_entity_organization_settings_endpoint.call_with_http_info(**kwargs)

    def patch_entity_organizations(
        self,
        id,
        json_api_organization_patch_document,
        **kwargs
    ):
        """patch_entity_organizations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_organizations(id, json_api_organization_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_organization_patch_document (JsonApiOrganizationPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiOrganizationOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_organization_patch_document'] = \
            json_api_organization_patch_document
        return self.patch_entity_organizations_endpoint.call_with_http_info(**kwargs)

    def patch_entity_themes(
        self,
        id,
        json_api_theme_patch_document,
        **kwargs
    ):
        """patch_entity_themes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_themes(id, json_api_theme_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_theme_patch_document (JsonApiThemePatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiThemeOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_theme_patch_document'] = \
            json_api_theme_patch_document
        return self.patch_entity_themes_endpoint.call_with_http_info(**kwargs)

    def patch_entity_user_groups(
        self,
        id,
        json_api_user_group_patch_document,
        **kwargs
    ):
        """patch_entity_user_groups  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_user_groups(id, json_api_user_group_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_user_group_patch_document (JsonApiUserGroupPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserGroupOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_user_group_patch_document'] = \
            json_api_user_group_patch_document
        return self.patch_entity_user_groups_endpoint.call_with_http_info(**kwargs)

    def patch_entity_users(
        self,
        id,
        json_api_user_patch_document,
        **kwargs
    ):
        """patch_entity_users  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_users(id, json_api_user_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_user_patch_document (JsonApiUserPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_user_patch_document'] = \
            json_api_user_patch_document
        return self.patch_entity_users_endpoint.call_with_http_info(**kwargs)

    def patch_entity_visualization_objects(
        self,
        workspace_id,
        object_id,
        json_api_visualization_object_patch_document,
        **kwargs
    ):
        """patch_entity_visualization_objects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_visualization_objects(workspace_id, object_id, json_api_visualization_object_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_visualization_object_patch_document (JsonApiVisualizationObjectPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiVisualizationObjectOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_visualization_object_patch_document'] = \
            json_api_visualization_object_patch_document
        return self.patch_entity_visualization_objects_endpoint.call_with_http_info(**kwargs)

    def patch_entity_workspace_data_filters(
        self,
        workspace_id,
        object_id,
        json_api_workspace_data_filter_patch_document,
        **kwargs
    ):
        """patch_entity_workspace_data_filters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_workspace_data_filters(workspace_id, object_id, json_api_workspace_data_filter_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_workspace_data_filter_patch_document (JsonApiWorkspaceDataFilterPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceDataFilterOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_workspace_data_filter_patch_document'] = \
            json_api_workspace_data_filter_patch_document
        return self.patch_entity_workspace_data_filters_endpoint.call_with_http_info(**kwargs)

    def patch_entity_workspace_settings(
        self,
        workspace_id,
        object_id,
        json_api_workspace_setting_patch_document,
        **kwargs
    ):
        """patch_entity_workspace_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_workspace_settings(workspace_id, object_id, json_api_workspace_setting_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_workspace_setting_patch_document (JsonApiWorkspaceSettingPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_workspace_setting_patch_document'] = \
            json_api_workspace_setting_patch_document
        return self.patch_entity_workspace_settings_endpoint.call_with_http_info(**kwargs)

    def patch_entity_workspaces(
        self,
        id,
        json_api_workspace_patch_document,
        **kwargs
    ):
        """patch_entity_workspaces  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_workspaces(id, json_api_workspace_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_workspace_patch_document (JsonApiWorkspacePatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_workspace_patch_document'] = \
            json_api_workspace_patch_document
        return self.patch_entity_workspaces_endpoint.call_with_http_info(**kwargs)

    def update_entity_analytical_dashboards(
        self,
        workspace_id,
        object_id,
        json_api_analytical_dashboard_in_document,
        **kwargs
    ):
        """update_entity_analytical_dashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_analytical_dashboards(workspace_id, object_id, json_api_analytical_dashboard_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_analytical_dashboard_in_document (JsonApiAnalyticalDashboardInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAnalyticalDashboardOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_analytical_dashboard_in_document'] = \
            json_api_analytical_dashboard_in_document
        return self.update_entity_analytical_dashboards_endpoint.call_with_http_info(**kwargs)

    def update_entity_api_tokens(
        self,
        user_id,
        id,
        json_api_api_token_in_document,
        **kwargs
    ):
        """update_entity_api_tokens  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_api_tokens(user_id, id, json_api_api_token_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            user_id (str):
            id (str):
            json_api_api_token_in_document (JsonApiApiTokenInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiApiTokenOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['user_id'] = \
            user_id
        kwargs['id'] = \
            id
        kwargs['json_api_api_token_in_document'] = \
            json_api_api_token_in_document
        return self.update_entity_api_tokens_endpoint.call_with_http_info(**kwargs)

    def update_entity_color_palettes(
        self,
        id,
        json_api_color_palette_in_document,
        **kwargs
    ):
        """update_entity_color_palettes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_color_palettes(id, json_api_color_palette_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_color_palette_in_document (JsonApiColorPaletteInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiColorPaletteOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_color_palette_in_document'] = \
            json_api_color_palette_in_document
        return self.update_entity_color_palettes_endpoint.call_with_http_info(**kwargs)

    def update_entity_cookie_security_configurations(
        self,
        id,
        json_api_cookie_security_configuration_in_document,
        **kwargs
    ):
        """update_entity_cookie_security_configurations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_cookie_security_configurations(id, json_api_cookie_security_configuration_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_cookie_security_configuration_in_document (JsonApiCookieSecurityConfigurationInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiCookieSecurityConfigurationOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_cookie_security_configuration_in_document'] = \
            json_api_cookie_security_configuration_in_document
        return self.update_entity_cookie_security_configurations_endpoint.call_with_http_info(**kwargs)

    def update_entity_csp_directives(
        self,
        id,
        json_api_csp_directive_in_document,
        **kwargs
    ):
        """update_entity_csp_directives  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_csp_directives(id, json_api_csp_directive_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_csp_directive_in_document (JsonApiCspDirectiveInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiCspDirectiveOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_csp_directive_in_document'] = \
            json_api_csp_directive_in_document
        return self.update_entity_csp_directives_endpoint.call_with_http_info(**kwargs)

    def update_entity_custom_application_settings(
        self,
        workspace_id,
        object_id,
        json_api_custom_application_setting_in_document,
        **kwargs
    ):
        """update_entity_custom_application_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_custom_application_settings(workspace_id, object_id, json_api_custom_application_setting_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_custom_application_setting_in_document (JsonApiCustomApplicationSettingInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiCustomApplicationSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_custom_application_setting_in_document'] = \
            json_api_custom_application_setting_in_document
        return self.update_entity_custom_application_settings_endpoint.call_with_http_info(**kwargs)

    def update_entity_dashboard_plugins(
        self,
        workspace_id,
        object_id,
        json_api_dashboard_plugin_in_document,
        **kwargs
    ):
        """update_entity_dashboard_plugins  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_dashboard_plugins(workspace_id, object_id, json_api_dashboard_plugin_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_dashboard_plugin_in_document (JsonApiDashboardPluginInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDashboardPluginOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_dashboard_plugin_in_document'] = \
            json_api_dashboard_plugin_in_document
        return self.update_entity_dashboard_plugins_endpoint.call_with_http_info(**kwargs)

    def update_entity_data_sources(
        self,
        id,
        json_api_data_source_in_document,
        **kwargs
    ):
        """update_entity_data_sources  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_data_sources(id, json_api_data_source_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_data_source_in_document (JsonApiDataSourceInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDataSourceOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_data_source_in_document'] = \
            json_api_data_source_in_document
        return self.update_entity_data_sources_endpoint.call_with_http_info(**kwargs)

    def update_entity_filter_contexts(
        self,
        workspace_id,
        object_id,
        json_api_filter_context_in_document,
        **kwargs
    ):
        """update_entity_filter_contexts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_filter_contexts(workspace_id, object_id, json_api_filter_context_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_filter_context_in_document (JsonApiFilterContextInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFilterContextOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_filter_context_in_document'] = \
            json_api_filter_context_in_document
        return self.update_entity_filter_contexts_endpoint.call_with_http_info(**kwargs)

    def update_entity_metrics(
        self,
        workspace_id,
        object_id,
        json_api_metric_in_document,
        **kwargs
    ):
        """update_entity_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_metrics(workspace_id, object_id, json_api_metric_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_metric_in_document (JsonApiMetricInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiMetricOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_metric_in_document'] = \
            json_api_metric_in_document
        return self.update_entity_metrics_endpoint.call_with_http_info(**kwargs)

    def update_entity_organization_settings(
        self,
        id,
        json_api_organization_setting_in_document,
        **kwargs
    ):
        """update_entity_organization_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_organization_settings(id, json_api_organization_setting_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_organization_setting_in_document (JsonApiOrganizationSettingInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiOrganizationSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_organization_setting_in_document'] = \
            json_api_organization_setting_in_document
        return self.update_entity_organization_settings_endpoint.call_with_http_info(**kwargs)

    def update_entity_organizations(
        self,
        id,
        json_api_organization_in_document,
        **kwargs
    ):
        """update_entity_organizations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_organizations(id, json_api_organization_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_organization_in_document (JsonApiOrganizationInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiOrganizationOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_organization_in_document'] = \
            json_api_organization_in_document
        return self.update_entity_organizations_endpoint.call_with_http_info(**kwargs)

    def update_entity_themes(
        self,
        id,
        json_api_theme_in_document,
        **kwargs
    ):
        """update_entity_themes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_themes(id, json_api_theme_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_theme_in_document (JsonApiThemeInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiThemeOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_theme_in_document'] = \
            json_api_theme_in_document
        return self.update_entity_themes_endpoint.call_with_http_info(**kwargs)

    def update_entity_user_groups(
        self,
        id,
        json_api_user_group_in_document,
        **kwargs
    ):
        """update_entity_user_groups  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_user_groups(id, json_api_user_group_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_user_group_in_document (JsonApiUserGroupInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserGroupOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_user_group_in_document'] = \
            json_api_user_group_in_document
        return self.update_entity_user_groups_endpoint.call_with_http_info(**kwargs)

    def update_entity_user_settings(
        self,
        user_id,
        id,
        json_api_user_setting_in_document,
        **kwargs
    ):
        """update_entity_user_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_user_settings(user_id, id, json_api_user_setting_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            user_id (str):
            id (str):
            json_api_user_setting_in_document (JsonApiUserSettingInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['user_id'] = \
            user_id
        kwargs['id'] = \
            id
        kwargs['json_api_user_setting_in_document'] = \
            json_api_user_setting_in_document
        return self.update_entity_user_settings_endpoint.call_with_http_info(**kwargs)

    def update_entity_users(
        self,
        id,
        json_api_user_in_document,
        **kwargs
    ):
        """update_entity_users  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_users(id, json_api_user_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_user_in_document (JsonApiUserInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_user_in_document'] = \
            json_api_user_in_document
        return self.update_entity_users_endpoint.call_with_http_info(**kwargs)

    def update_entity_visualization_objects(
        self,
        workspace_id,
        object_id,
        json_api_visualization_object_in_document,
        **kwargs
    ):
        """update_entity_visualization_objects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_visualization_objects(workspace_id, object_id, json_api_visualization_object_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_visualization_object_in_document (JsonApiVisualizationObjectInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiVisualizationObjectOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_visualization_object_in_document'] = \
            json_api_visualization_object_in_document
        return self.update_entity_visualization_objects_endpoint.call_with_http_info(**kwargs)

    def update_entity_workspace_data_filters(
        self,
        workspace_id,
        object_id,
        json_api_workspace_data_filter_in_document,
        **kwargs
    ):
        """update_entity_workspace_data_filters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_workspace_data_filters(workspace_id, object_id, json_api_workspace_data_filter_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_workspace_data_filter_in_document (JsonApiWorkspaceDataFilterInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceDataFilterOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_workspace_data_filter_in_document'] = \
            json_api_workspace_data_filter_in_document
        return self.update_entity_workspace_data_filters_endpoint.call_with_http_info(**kwargs)

    def update_entity_workspace_settings(
        self,
        workspace_id,
        object_id,
        json_api_workspace_setting_in_document,
        **kwargs
    ):
        """update_entity_workspace_settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_workspace_settings(workspace_id, object_id, json_api_workspace_setting_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_workspace_setting_in_document (JsonApiWorkspaceSettingInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_workspace_setting_in_document'] = \
            json_api_workspace_setting_in_document
        return self.update_entity_workspace_settings_endpoint.call_with_http_info(**kwargs)

    def update_entity_workspaces(
        self,
        id,
        json_api_workspace_in_document,
        **kwargs
    ):
        """update_entity_workspaces  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_workspaces(id, json_api_workspace_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            json_api_workspace_in_document (JsonApiWorkspaceInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['json_api_workspace_in_document'] = \
            json_api_workspace_in_document
        return self.update_entity_workspaces_endpoint.call_with_http_info(**kwargs)

