# gooddata-metadata-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v0
- Package version: 1.3.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import gooddata_metadata_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import gooddata_metadata_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import gooddata_metadata_client
from pprint import pprint
from gooddata_metadata_client.api import api_tokens_api
from gooddata_metadata_client.model.json_api_api_token_in_document import JsonApiApiTokenInDocument
from gooddata_metadata_client.model.json_api_api_token_out_document import JsonApiApiTokenOutDocument
from gooddata_metadata_client.model.json_api_api_token_out_list import JsonApiApiTokenOutList
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = gooddata_metadata_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with gooddata_metadata_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = api_tokens_api.APITokensApi(api_client)
    user_id = "userId_example" # str | 
    json_api_api_token_in_document = JsonApiApiTokenInDocument(
        data=JsonApiApiTokenIn(
            id="id1",
            type="apiToken",
        ),
    ) # JsonApiApiTokenInDocument | 

    try:
        api_response = api_instance.create_entity_api_tokens(user_id, json_api_api_token_in_document)
        pprint(api_response)
    except gooddata_metadata_client.ApiException as e:
        print("Exception when calling APITokensApi->create_entity_api_tokens: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APITokensApi* | [**create_entity_api_tokens**](docs/APITokensApi.md#create_entity_api_tokens) | **POST** /api/v1/entities/users/{userId}/apiTokens | 
*APITokensApi* | [**delete_entity_api_tokens**](docs/APITokensApi.md#delete_entity_api_tokens) | **DELETE** /api/v1/entities/users/{userId}/apiTokens/{id} | 
*APITokensApi* | [**get_all_entities_api_tokens**](docs/APITokensApi.md#get_all_entities_api_tokens) | **GET** /api/v1/entities/users/{userId}/apiTokens | List all api tokens for a user
*APITokensApi* | [**get_entity_api_tokens**](docs/APITokensApi.md#get_entity_api_tokens) | **GET** /api/v1/entities/users/{userId}/apiTokens/{id} | 
*APITokensApi* | [**update_entity_api_tokens**](docs/APITokensApi.md#update_entity_api_tokens) | **PUT** /api/v1/entities/users/{userId}/apiTokens/{id} | 
*AnalyticsModelApi* | [**get_analytics_model**](docs/AnalyticsModelApi.md#get_analytics_model) | **GET** /api/v1/layout/workspaces/{workspaceId}/analyticsModel | Get analytics model
*AnalyticsModelApi* | [**set_analytics_model**](docs/AnalyticsModelApi.md#set_analytics_model) | **PUT** /api/v1/layout/workspaces/{workspaceId}/analyticsModel | Set analytics model
*AppearanceApi* | [**create_entity_color_palettes**](docs/AppearanceApi.md#create_entity_color_palettes) | **POST** /api/v1/entities/colorPalettes | 
*AppearanceApi* | [**create_entity_themes**](docs/AppearanceApi.md#create_entity_themes) | **POST** /api/v1/entities/themes | 
*AppearanceApi* | [**delete_entity_color_palettes**](docs/AppearanceApi.md#delete_entity_color_palettes) | **DELETE** /api/v1/entities/colorPalettes/{id} | 
*AppearanceApi* | [**delete_entity_themes**](docs/AppearanceApi.md#delete_entity_themes) | **DELETE** /api/v1/entities/themes/{id} | 
*AppearanceApi* | [**get_all_entities_color_palettes**](docs/AppearanceApi.md#get_all_entities_color_palettes) | **GET** /api/v1/entities/colorPalettes | 
*AppearanceApi* | [**get_all_entities_themes**](docs/AppearanceApi.md#get_all_entities_themes) | **GET** /api/v1/entities/themes | 
*AppearanceApi* | [**get_entity_color_palettes**](docs/AppearanceApi.md#get_entity_color_palettes) | **GET** /api/v1/entities/colorPalettes/{id} | 
*AppearanceApi* | [**get_entity_themes**](docs/AppearanceApi.md#get_entity_themes) | **GET** /api/v1/entities/themes/{id} | 
*AppearanceApi* | [**patch_entity_color_palettes**](docs/AppearanceApi.md#patch_entity_color_palettes) | **PATCH** /api/v1/entities/colorPalettes/{id} | 
*AppearanceApi* | [**patch_entity_themes**](docs/AppearanceApi.md#patch_entity_themes) | **PATCH** /api/v1/entities/themes/{id} | 
*AppearanceApi* | [**update_entity_color_palettes**](docs/AppearanceApi.md#update_entity_color_palettes) | **PUT** /api/v1/entities/colorPalettes/{id} | 
*AppearanceApi* | [**update_entity_themes**](docs/AppearanceApi.md#update_entity_themes) | **PUT** /api/v1/entities/themes/{id} | 
*AttributesApi* | [**get_all_entities_attributes**](docs/AttributesApi.md#get_all_entities_attributes) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributes | 
*AttributesApi* | [**get_entity_attributes**](docs/AttributesApi.md#get_entity_attributes) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributes/{objectId} | 
*AvailableDriversApi* | [**get_data_source_drivers**](docs/AvailableDriversApi.md#get_data_source_drivers) | **GET** /api/v1/options/availableDrivers | Get all available data source drivers
*CSPDirectivesApi* | [**create_entity_csp_directives**](docs/CSPDirectivesApi.md#create_entity_csp_directives) | **POST** /api/v1/entities/cspDirectives | 
*CSPDirectivesApi* | [**delete_entity_csp_directives**](docs/CSPDirectivesApi.md#delete_entity_csp_directives) | **DELETE** /api/v1/entities/cspDirectives/{id} | 
*CSPDirectivesApi* | [**get_all_entities_csp_directives**](docs/CSPDirectivesApi.md#get_all_entities_csp_directives) | **GET** /api/v1/entities/cspDirectives | 
*CSPDirectivesApi* | [**get_entity_csp_directives**](docs/CSPDirectivesApi.md#get_entity_csp_directives) | **GET** /api/v1/entities/cspDirectives/{id} | 
*CSPDirectivesApi* | [**patch_entity_csp_directives**](docs/CSPDirectivesApi.md#patch_entity_csp_directives) | **PATCH** /api/v1/entities/cspDirectives/{id} | 
*CSPDirectivesApi* | [**update_entity_csp_directives**](docs/CSPDirectivesApi.md#update_entity_csp_directives) | **PUT** /api/v1/entities/cspDirectives/{id} | 
*ContextFiltersApi* | [**create_entity_filter_contexts**](docs/ContextFiltersApi.md#create_entity_filter_contexts) | **POST** /api/v1/entities/workspaces/{workspaceId}/filterContexts | 
*ContextFiltersApi* | [**delete_entity_filter_contexts**](docs/ContextFiltersApi.md#delete_entity_filter_contexts) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | 
*ContextFiltersApi* | [**get_all_entities_filter_contexts**](docs/ContextFiltersApi.md#get_all_entities_filter_contexts) | **GET** /api/v1/entities/workspaces/{workspaceId}/filterContexts | 
*ContextFiltersApi* | [**get_entity_filter_contexts**](docs/ContextFiltersApi.md#get_entity_filter_contexts) | **GET** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | 
*ContextFiltersApi* | [**patch_entity_filter_contexts**](docs/ContextFiltersApi.md#patch_entity_filter_contexts) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | 
*ContextFiltersApi* | [**update_entity_filter_contexts**](docs/ContextFiltersApi.md#update_entity_filter_contexts) | **PUT** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | 
*CookieSecurityConfigurationApi* | [**get_entity_cookie_security_configurations**](docs/CookieSecurityConfigurationApi.md#get_entity_cookie_security_configurations) | **GET** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | 
*CookieSecurityConfigurationApi* | [**patch_entity_cookie_security_configurations**](docs/CookieSecurityConfigurationApi.md#patch_entity_cookie_security_configurations) | **PATCH** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | 
*CookieSecurityConfigurationApi* | [**update_entity_cookie_security_configurations**](docs/CookieSecurityConfigurationApi.md#update_entity_cookie_security_configurations) | **PUT** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | 
*DashboardsApi* | [**create_entity_analytical_dashboards**](docs/DashboardsApi.md#create_entity_analytical_dashboards) | **POST** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards | 
*DashboardsApi* | [**delete_entity_analytical_dashboards**](docs/DashboardsApi.md#delete_entity_analytical_dashboards) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | 
*DashboardsApi* | [**get_all_entities_analytical_dashboards**](docs/DashboardsApi.md#get_all_entities_analytical_dashboards) | **GET** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards | 
*DashboardsApi* | [**get_entity_analytical_dashboards**](docs/DashboardsApi.md#get_entity_analytical_dashboards) | **GET** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | 
*DashboardsApi* | [**patch_entity_analytical_dashboards**](docs/DashboardsApi.md#patch_entity_analytical_dashboards) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | 
*DashboardsApi* | [**update_entity_analytical_dashboards**](docs/DashboardsApi.md#update_entity_analytical_dashboards) | **PUT** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | 
*DataFiltersApi* | [**create_entity_workspace_data_filters**](docs/DataFiltersApi.md#create_entity_workspace_data_filters) | **POST** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters | 
*DataFiltersApi* | [**delete_entity_workspace_data_filters**](docs/DataFiltersApi.md#delete_entity_workspace_data_filters) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | 
*DataFiltersApi* | [**get_all_entities_workspace_data_filter_settings**](docs/DataFiltersApi.md#get_all_entities_workspace_data_filter_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings | 
*DataFiltersApi* | [**get_all_entities_workspace_data_filters**](docs/DataFiltersApi.md#get_all_entities_workspace_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters | 
*DataFiltersApi* | [**get_entity_workspace_data_filter_settings**](docs/DataFiltersApi.md#get_entity_workspace_data_filter_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId} | 
*DataFiltersApi* | [**get_entity_workspace_data_filters**](docs/DataFiltersApi.md#get_entity_workspace_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | 
*DataFiltersApi* | [**get_workspace_data_filters_layout**](docs/DataFiltersApi.md#get_workspace_data_filters_layout) | **GET** /api/v1/layout/workspaceDataFilters | Get workspace data filters for all workspaces
*DataFiltersApi* | [**patch_entity_workspace_data_filters**](docs/DataFiltersApi.md#patch_entity_workspace_data_filters) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | 
*DataFiltersApi* | [**set_workspace_data_filters_layout**](docs/DataFiltersApi.md#set_workspace_data_filters_layout) | **PUT** /api/v1/layout/workspaceDataFilters | Set all workspace data filters
*DataFiltersApi* | [**update_entity_workspace_data_filters**](docs/DataFiltersApi.md#update_entity_workspace_data_filters) | **PUT** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | 
*DataSourceDeclarativeAPIsApi* | [**get_data_sources_layout**](docs/DataSourceDeclarativeAPIsApi.md#get_data_sources_layout) | **GET** /api/v1/layout/dataSources | Get all data sources
*DataSourceDeclarativeAPIsApi* | [**put_data_sources_layout**](docs/DataSourceDeclarativeAPIsApi.md#put_data_sources_layout) | **PUT** /api/v1/layout/dataSources | Put all data sources
*DataSourceEntityAPIsApi* | [**create_entity_data_sources**](docs/DataSourceEntityAPIsApi.md#create_entity_data_sources) | **POST** /api/v1/entities/dataSources | 
*DataSourceEntityAPIsApi* | [**delete_entity_data_sources**](docs/DataSourceEntityAPIsApi.md#delete_entity_data_sources) | **DELETE** /api/v1/entities/dataSources/{id} | 
*DataSourceEntityAPIsApi* | [**get_all_entities_data_source_identifiers**](docs/DataSourceEntityAPIsApi.md#get_all_entities_data_source_identifiers) | **GET** /api/v1/entities/dataSourceIdentifiers | 
*DataSourceEntityAPIsApi* | [**get_all_entities_data_source_tables**](docs/DataSourceEntityAPIsApi.md#get_all_entities_data_source_tables) | **GET** /api/v1/entities/dataSources/{dataSourceId}/dataSourceTables | 
*DataSourceEntityAPIsApi* | [**get_all_entities_data_sources**](docs/DataSourceEntityAPIsApi.md#get_all_entities_data_sources) | **GET** /api/v1/entities/dataSources | 
*DataSourceEntityAPIsApi* | [**get_entity_data_source_identifiers**](docs/DataSourceEntityAPIsApi.md#get_entity_data_source_identifiers) | **GET** /api/v1/entities/dataSourceIdentifiers/{id} | 
*DataSourceEntityAPIsApi* | [**get_entity_data_source_tables**](docs/DataSourceEntityAPIsApi.md#get_entity_data_source_tables) | **GET** /api/v1/entities/dataSources/{dataSourceId}/dataSourceTables/{id} | 
*DataSourceEntityAPIsApi* | [**get_entity_data_sources**](docs/DataSourceEntityAPIsApi.md#get_entity_data_sources) | **GET** /api/v1/entities/dataSources/{id} | 
*DataSourceEntityAPIsApi* | [**patch_entity_data_sources**](docs/DataSourceEntityAPIsApi.md#patch_entity_data_sources) | **PATCH** /api/v1/entities/dataSources/{id} | 
*DataSourceEntityAPIsApi* | [**update_entity_data_sources**](docs/DataSourceEntityAPIsApi.md#update_entity_data_sources) | **PUT** /api/v1/entities/dataSources/{id} | 
*DatasetsApi* | [**get_all_entities_datasets**](docs/DatasetsApi.md#get_all_entities_datasets) | **GET** /api/v1/entities/workspaces/{workspaceId}/datasets | 
*DatasetsApi* | [**get_entity_datasets**](docs/DatasetsApi.md#get_entity_datasets) | **GET** /api/v1/entities/workspaces/{workspaceId}/datasets/{objectId} | 
*DependencyGraphApi* | [**get_dependent_entities_graph**](docs/DependencyGraphApi.md#get_dependent_entities_graph) | **GET** /api/v1/actions/workspaces/{workspaceId}/dependentEntitiesGraph | Computes the dependent entities graph
*DependencyGraphApi* | [**get_dependent_entities_graph_from_entry_points**](docs/DependencyGraphApi.md#get_dependent_entities_graph_from_entry_points) | **POST** /api/v1/actions/workspaces/{workspaceId}/dependentEntitiesGraph | Computes the dependent entities graph from given entry points
*EntitlementApi* | [**get_all_entities_entitlements**](docs/EntitlementApi.md#get_all_entities_entitlements) | **GET** /api/v1/entities/entitlements | 
*EntitlementApi* | [**get_entity_entitlements**](docs/EntitlementApi.md#get_entity_entitlements) | **GET** /api/v1/entities/entitlements/{id} | 
*EntitlementApi* | [**resolve_all_entitlements**](docs/EntitlementApi.md#resolve_all_entitlements) | **GET** /api/v1/actions/resolveEntitlements | Values for all public entitlements.
*EntitlementApi* | [**resolve_requested_entitlements**](docs/EntitlementApi.md#resolve_requested_entitlements) | **POST** /api/v1/actions/resolveEntitlements | Values for requested public entitlements.
*FactsApi* | [**get_all_entities_facts**](docs/FactsApi.md#get_all_entities_facts) | **GET** /api/v1/entities/workspaces/{workspaceId}/facts | 
*FactsApi* | [**get_entity_facts**](docs/FactsApi.md#get_entity_facts) | **GET** /api/v1/entities/workspaces/{workspaceId}/facts/{objectId} | 
*GenerateLogicalDataModelApi* | [**generate_logical_model**](docs/GenerateLogicalDataModelApi.md#generate_logical_model) | **POST** /api/v1/actions/dataSources/{dataSourceId}/generateLogicalModel | Generate logical data model (LDM) from physical data model (PDM)
*InvalidateCacheApi* | [**register_upload_notification**](docs/InvalidateCacheApi.md#register_upload_notification) | **POST** /api/v1/actions/dataSources/{dataSourceId}/uploadNotification | Register an upload notification
*LDMDeclarativeAPIsApi* | [**get_logical_model**](docs/LDMDeclarativeAPIsApi.md#get_logical_model) | **GET** /api/v1/layout/workspaces/{workspaceId}/logicalModel | Get logical model
*LDMDeclarativeAPIsApi* | [**set_logical_model**](docs/LDMDeclarativeAPIsApi.md#set_logical_model) | **PUT** /api/v1/layout/workspaces/{workspaceId}/logicalModel | Set logical model
*LabelsApi* | [**get_all_entities_labels**](docs/LabelsApi.md#get_all_entities_labels) | **GET** /api/v1/entities/workspaces/{workspaceId}/labels | 
*LabelsApi* | [**get_entity_labels**](docs/LabelsApi.md#get_entity_labels) | **GET** /api/v1/entities/workspaces/{workspaceId}/labels/{objectId} | 
*MetricsApi* | [**create_entity_metrics**](docs/MetricsApi.md#create_entity_metrics) | **POST** /api/v1/entities/workspaces/{workspaceId}/metrics | 
*MetricsApi* | [**delete_entity_metrics**](docs/MetricsApi.md#delete_entity_metrics) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | 
*MetricsApi* | [**get_all_entities_metrics**](docs/MetricsApi.md#get_all_entities_metrics) | **GET** /api/v1/entities/workspaces/{workspaceId}/metrics | 
*MetricsApi* | [**get_entity_metrics**](docs/MetricsApi.md#get_entity_metrics) | **GET** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | 
*MetricsApi* | [**patch_entity_metrics**](docs/MetricsApi.md#patch_entity_metrics) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | 
*MetricsApi* | [**update_entity_metrics**](docs/MetricsApi.md#update_entity_metrics) | **PUT** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | 
*OptionsApi* | [**get_all_options**](docs/OptionsApi.md#get_all_options) | **GET** /api/v1/options | Links for all configuration options
*OrganizationDeclarativeAPIsApi* | [**get_organization_layout**](docs/OrganizationDeclarativeAPIsApi.md#get_organization_layout) | **GET** /api/v1/layout/organization | Get organization layout
*OrganizationDeclarativeAPIsApi* | [**set_organization_layout**](docs/OrganizationDeclarativeAPIsApi.md#set_organization_layout) | **PUT** /api/v1/layout/organization | Set organization layout
*OrganizationEntityAPIsApi* | [**create_entity_organization_settings**](docs/OrganizationEntityAPIsApi.md#create_entity_organization_settings) | **POST** /api/v1/entities/organizationSettings | 
*OrganizationEntityAPIsApi* | [**delete_entity_organization_settings**](docs/OrganizationEntityAPIsApi.md#delete_entity_organization_settings) | **DELETE** /api/v1/entities/organizationSettings/{id} | 
*OrganizationEntityAPIsApi* | [**get_all_entities_organization_settings**](docs/OrganizationEntityAPIsApi.md#get_all_entities_organization_settings) | **GET** /api/v1/entities/organizationSettings | 
*OrganizationEntityAPIsApi* | [**get_entity_organization_settings**](docs/OrganizationEntityAPIsApi.md#get_entity_organization_settings) | **GET** /api/v1/entities/organizationSettings/{id} | 
*OrganizationEntityAPIsApi* | [**get_entity_organizations**](docs/OrganizationEntityAPIsApi.md#get_entity_organizations) | **GET** /api/v1/entities/admin/organizations/{id} | 
*OrganizationEntityAPIsApi* | [**get_organization**](docs/OrganizationEntityAPIsApi.md#get_organization) | **GET** /api/v1/entities/organization | Get current organization info
*OrganizationEntityAPIsApi* | [**patch_entity_organization_settings**](docs/OrganizationEntityAPIsApi.md#patch_entity_organization_settings) | **PATCH** /api/v1/entities/organizationSettings/{id} | 
*OrganizationEntityAPIsApi* | [**patch_entity_organizations**](docs/OrganizationEntityAPIsApi.md#patch_entity_organizations) | **PATCH** /api/v1/entities/admin/organizations/{id} | 
*OrganizationEntityAPIsApi* | [**update_entity_organization_settings**](docs/OrganizationEntityAPIsApi.md#update_entity_organization_settings) | **PUT** /api/v1/entities/organizationSettings/{id} | 
*OrganizationEntityAPIsApi* | [**update_entity_organizations**](docs/OrganizationEntityAPIsApi.md#update_entity_organizations) | **PUT** /api/v1/entities/admin/organizations/{id} | 
*PDMDeclarativeAPIsApi* | [**get_pdm_layout**](docs/PDMDeclarativeAPIsApi.md#get_pdm_layout) | **GET** /api/v1/layout/dataSources/{dataSourceId}/physicalModel | Get data source physical model layout
*PDMDeclarativeAPIsApi* | [**set_pdm_layout**](docs/PDMDeclarativeAPIsApi.md#set_pdm_layout) | **PUT** /api/v1/layout/dataSources/{dataSourceId}/physicalModel | Set data source physical model layout
*PermissionsApi* | [**get_workspace_permissions**](docs/PermissionsApi.md#get_workspace_permissions) | **GET** /api/v1/layout/workspaces/{workspaceId}/permissions | Get permissions for the workspace
*PermissionsApi* | [**set_workspace_permissions**](docs/PermissionsApi.md#set_workspace_permissions) | **PUT** /api/v1/layout/workspaces/{workspaceId}/permissions | Set permissions for the workspace
*PluginsApi* | [**create_entity_dashboard_plugins**](docs/PluginsApi.md#create_entity_dashboard_plugins) | **POST** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins | 
*PluginsApi* | [**delete_entity_dashboard_plugins**](docs/PluginsApi.md#delete_entity_dashboard_plugins) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | 
*PluginsApi* | [**get_all_entities_dashboard_plugins**](docs/PluginsApi.md#get_all_entities_dashboard_plugins) | **GET** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins | 
*PluginsApi* | [**get_entity_dashboard_plugins**](docs/PluginsApi.md#get_entity_dashboard_plugins) | **GET** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | 
*PluginsApi* | [**patch_entity_dashboard_plugins**](docs/PluginsApi.md#patch_entity_dashboard_plugins) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | 
*PluginsApi* | [**update_entity_dashboard_plugins**](docs/PluginsApi.md#update_entity_dashboard_plugins) | **PUT** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | 
*ReportingSettingsApi* | [**resolve_all_settings_without_workspace**](docs/ReportingSettingsApi.md#resolve_all_settings_without_workspace) | **GET** /api/v1/actions/resolveSettings | Values for all settings without workspace.
*ReportingSettingsApi* | [**resolve_settings_without_workspace**](docs/ReportingSettingsApi.md#resolve_settings_without_workspace) | **POST** /api/v1/actions/resolveSettings | Values for selected settings without workspace.
*UsageApi* | [**all_platform_usage**](docs/UsageApi.md#all_platform_usage) | **GET** /api/v1/actions/collectUsage | Info about the platform usage.
*UsageApi* | [**particular_platform_usage**](docs/UsageApi.md#particular_platform_usage) | **POST** /api/v1/actions/collectUsage | Info about the platform usage for particular items.
*UserGroupsDeclarativeAPIsApi* | [**get_user_groups_layout**](docs/UserGroupsDeclarativeAPIsApi.md#get_user_groups_layout) | **GET** /api/v1/layout/userGroups | Get all user groups
*UserGroupsDeclarativeAPIsApi* | [**get_users_user_groups_layout**](docs/UserGroupsDeclarativeAPIsApi.md#get_users_user_groups_layout) | **GET** /api/v1/layout/usersAndUserGroups | Get all users and user groups
*UserGroupsDeclarativeAPIsApi* | [**put_user_groups_layout**](docs/UserGroupsDeclarativeAPIsApi.md#put_user_groups_layout) | **PUT** /api/v1/layout/userGroups | Put all user groups
*UserGroupsDeclarativeAPIsApi* | [**put_users_user_groups_layout**](docs/UserGroupsDeclarativeAPIsApi.md#put_users_user_groups_layout) | **PUT** /api/v1/layout/usersAndUserGroups | Put all users and user groups
*UserGroupsEntityAPIsApi* | [**create_entity_user_groups**](docs/UserGroupsEntityAPIsApi.md#create_entity_user_groups) | **POST** /api/v1/entities/userGroups | 
*UserGroupsEntityAPIsApi* | [**delete_entity_user_groups**](docs/UserGroupsEntityAPIsApi.md#delete_entity_user_groups) | **DELETE** /api/v1/entities/userGroups/{id} | 
*UserGroupsEntityAPIsApi* | [**get_all_entities_user_groups**](docs/UserGroupsEntityAPIsApi.md#get_all_entities_user_groups) | **GET** /api/v1/entities/userGroups | 
*UserGroupsEntityAPIsApi* | [**get_entity_user_groups**](docs/UserGroupsEntityAPIsApi.md#get_entity_user_groups) | **GET** /api/v1/entities/userGroups/{id} | 
*UserGroupsEntityAPIsApi* | [**patch_entity_user_groups**](docs/UserGroupsEntityAPIsApi.md#patch_entity_user_groups) | **PATCH** /api/v1/entities/userGroups/{id} | 
*UserGroupsEntityAPIsApi* | [**update_entity_user_groups**](docs/UserGroupsEntityAPIsApi.md#update_entity_user_groups) | **PUT** /api/v1/entities/userGroups/{id} | 
*UserSettingsApi* | [**create_entity_user_settings**](docs/UserSettingsApi.md#create_entity_user_settings) | **POST** /api/v1/entities/users/{userId}/userSettings | 
*UserSettingsApi* | [**delete_entity_user_settings**](docs/UserSettingsApi.md#delete_entity_user_settings) | **DELETE** /api/v1/entities/users/{userId}/userSettings/{id} | 
*UserSettingsApi* | [**get_all_entities_user_settings**](docs/UserSettingsApi.md#get_all_entities_user_settings) | **GET** /api/v1/entities/users/{userId}/userSettings | List all settings for a user
*UserSettingsApi* | [**get_entity_user_settings**](docs/UserSettingsApi.md#get_entity_user_settings) | **GET** /api/v1/entities/users/{userId}/userSettings/{id} | 
*UserSettingsApi* | [**update_entity_user_settings**](docs/UserSettingsApi.md#update_entity_user_settings) | **PUT** /api/v1/entities/users/{userId}/userSettings/{id} | 
*UsersDeclarativeAPIsApi* | [**get_users_layout**](docs/UsersDeclarativeAPIsApi.md#get_users_layout) | **GET** /api/v1/layout/users | Get all users
*UsersDeclarativeAPIsApi* | [**put_users_layout**](docs/UsersDeclarativeAPIsApi.md#put_users_layout) | **PUT** /api/v1/layout/users | Put all users
*UsersEntityAPIsApi* | [**create_entity_users**](docs/UsersEntityAPIsApi.md#create_entity_users) | **POST** /api/v1/entities/users | 
*UsersEntityAPIsApi* | [**delete_entity_users**](docs/UsersEntityAPIsApi.md#delete_entity_users) | **DELETE** /api/v1/entities/users/{id} | 
*UsersEntityAPIsApi* | [**get_all_entities_users**](docs/UsersEntityAPIsApi.md#get_all_entities_users) | **GET** /api/v1/entities/users | 
*UsersEntityAPIsApi* | [**get_entity_users**](docs/UsersEntityAPIsApi.md#get_entity_users) | **GET** /api/v1/entities/users/{id} | 
*UsersEntityAPIsApi* | [**patch_entity_users**](docs/UsersEntityAPIsApi.md#patch_entity_users) | **PATCH** /api/v1/entities/users/{id} | 
*UsersEntityAPIsApi* | [**update_entity_users**](docs/UsersEntityAPIsApi.md#update_entity_users) | **PUT** /api/v1/entities/users/{id} | 
*VisualizationObjectsApi* | [**create_entity_visualization_objects**](docs/VisualizationObjectsApi.md#create_entity_visualization_objects) | **POST** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects | 
*VisualizationObjectsApi* | [**delete_entity_visualization_objects**](docs/VisualizationObjectsApi.md#delete_entity_visualization_objects) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | 
*VisualizationObjectsApi* | [**get_all_entities_visualization_objects**](docs/VisualizationObjectsApi.md#get_all_entities_visualization_objects) | **GET** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects | 
*VisualizationObjectsApi* | [**get_entity_visualization_objects**](docs/VisualizationObjectsApi.md#get_entity_visualization_objects) | **GET** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | 
*VisualizationObjectsApi* | [**patch_entity_visualization_objects**](docs/VisualizationObjectsApi.md#patch_entity_visualization_objects) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | 
*VisualizationObjectsApi* | [**update_entity_visualization_objects**](docs/VisualizationObjectsApi.md#update_entity_visualization_objects) | **PUT** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | 
*WorkspacesDeclarativeAPIsApi* | [**get_workspace_layout**](docs/WorkspacesDeclarativeAPIsApi.md#get_workspace_layout) | **GET** /api/v1/layout/workspaces/{workspaceId} | Get workspace layout
*WorkspacesDeclarativeAPIsApi* | [**get_workspaces_layout**](docs/WorkspacesDeclarativeAPIsApi.md#get_workspaces_layout) | **GET** /api/v1/layout/workspaces | Get all workspaces layout
*WorkspacesDeclarativeAPIsApi* | [**put_workspace_layout**](docs/WorkspacesDeclarativeAPIsApi.md#put_workspace_layout) | **PUT** /api/v1/layout/workspaces/{workspaceId} | Set workspace layout
*WorkspacesDeclarativeAPIsApi* | [**set_workspaces_layout**](docs/WorkspacesDeclarativeAPIsApi.md#set_workspaces_layout) | **PUT** /api/v1/layout/workspaces | Set all workspaces layout
*WorkspacesEntityAPIsApi* | [**create_entity_workspaces**](docs/WorkspacesEntityAPIsApi.md#create_entity_workspaces) | **POST** /api/v1/entities/workspaces | 
*WorkspacesEntityAPIsApi* | [**delete_entity_workspaces**](docs/WorkspacesEntityAPIsApi.md#delete_entity_workspaces) | **DELETE** /api/v1/entities/workspaces/{id} | 
*WorkspacesEntityAPIsApi* | [**get_all_entities_workspaces**](docs/WorkspacesEntityAPIsApi.md#get_all_entities_workspaces) | **GET** /api/v1/entities/workspaces | 
*WorkspacesEntityAPIsApi* | [**get_entity_workspaces**](docs/WorkspacesEntityAPIsApi.md#get_entity_workspaces) | **GET** /api/v1/entities/workspaces/{id} | 
*WorkspacesEntityAPIsApi* | [**patch_entity_workspaces**](docs/WorkspacesEntityAPIsApi.md#patch_entity_workspaces) | **PATCH** /api/v1/entities/workspaces/{id} | 
*WorkspacesEntityAPIsApi* | [**update_entity_workspaces**](docs/WorkspacesEntityAPIsApi.md#update_entity_workspaces) | **PUT** /api/v1/entities/workspaces/{id} | 
*WorkspacesSettingsApi* | [**create_entity_custom_application_settings**](docs/WorkspacesSettingsApi.md#create_entity_custom_application_settings) | **POST** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings | 
*WorkspacesSettingsApi* | [**create_entity_workspace_settings**](docs/WorkspacesSettingsApi.md#create_entity_workspace_settings) | **POST** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings | 
*WorkspacesSettingsApi* | [**delete_entity_custom_application_settings**](docs/WorkspacesSettingsApi.md#delete_entity_custom_application_settings) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | 
*WorkspacesSettingsApi* | [**delete_entity_workspace_settings**](docs/WorkspacesSettingsApi.md#delete_entity_workspace_settings) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | 
*WorkspacesSettingsApi* | [**get_all_entities_custom_application_settings**](docs/WorkspacesSettingsApi.md#get_all_entities_custom_application_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings | 
*WorkspacesSettingsApi* | [**get_all_entities_workspace_settings**](docs/WorkspacesSettingsApi.md#get_all_entities_workspace_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings | 
*WorkspacesSettingsApi* | [**get_entity_custom_application_settings**](docs/WorkspacesSettingsApi.md#get_entity_custom_application_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | 
*WorkspacesSettingsApi* | [**get_entity_workspace_settings**](docs/WorkspacesSettingsApi.md#get_entity_workspace_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | 
*WorkspacesSettingsApi* | [**patch_entity_custom_application_settings**](docs/WorkspacesSettingsApi.md#patch_entity_custom_application_settings) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | 
*WorkspacesSettingsApi* | [**patch_entity_workspace_settings**](docs/WorkspacesSettingsApi.md#patch_entity_workspace_settings) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | 
*WorkspacesSettingsApi* | [**update_entity_custom_application_settings**](docs/WorkspacesSettingsApi.md#update_entity_custom_application_settings) | **PUT** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | 
*WorkspacesSettingsApi* | [**update_entity_workspace_settings**](docs/WorkspacesSettingsApi.md#update_entity_workspace_settings) | **PUT** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | 
*WorkspacesSettingsApi* | [**workspace_resolve_all_settings**](docs/WorkspacesSettingsApi.md#workspace_resolve_all_settings) | **GET** /api/v1/actions/workspaces/{workspaceId}/resolveSettings | Values for all settings.
*WorkspacesSettingsApi* | [**workspace_resolve_settings**](docs/WorkspacesSettingsApi.md#workspace_resolve_settings) | **POST** /api/v1/actions/workspaces/{workspaceId}/resolveSettings | Values for selected settings.
*ActionsApi* | [**all_platform_usage**](docs/ActionsApi.md#all_platform_usage) | **GET** /api/v1/actions/collectUsage | Info about the platform usage.
*ActionsApi* | [**available_assignes**](docs/ActionsApi.md#available_assignes) | **GET** /api/v1/actions/workspaces/{workspaceId}/analyticalDashboards/{dashboardId}/availableAssignees | 
*ActionsApi* | [**check_entity_overrides**](docs/ActionsApi.md#check_entity_overrides) | **POST** /api/v1/actions/workspaces/{workspaceId}/checkEntityOverrides | Finds entities with given ID in hierarchy.
*ActionsApi* | [**generate_logical_model**](docs/ActionsApi.md#generate_logical_model) | **POST** /api/v1/actions/dataSources/{dataSourceId}/generateLogicalModel | Generate logical data model (LDM) from physical data model (PDM)
*ActionsApi* | [**get_dependent_entities_graph**](docs/ActionsApi.md#get_dependent_entities_graph) | **GET** /api/v1/actions/workspaces/{workspaceId}/dependentEntitiesGraph | Computes the dependent entities graph
*ActionsApi* | [**get_dependent_entities_graph_from_entry_points**](docs/ActionsApi.md#get_dependent_entities_graph_from_entry_points) | **POST** /api/v1/actions/workspaces/{workspaceId}/dependentEntitiesGraph | Computes the dependent entities graph from given entry points
*ActionsApi* | [**inherited_entity_conflicts**](docs/ActionsApi.md#inherited_entity_conflicts) | **GET** /api/v1/actions/workspaces/{workspaceId}/inheritedEntityConflicts | Finds API identifier conflicts in given workspace hierarchy.
*ActionsApi* | [**manage_permissions**](docs/ActionsApi.md#manage_permissions) | **POST** /api/v1/actions/workspaces/{workspaceId}/analyticalDashboards/{dashboardId}/managePermissions | 
*ActionsApi* | [**overridden_child_entities**](docs/ActionsApi.md#overridden_child_entities) | **GET** /api/v1/actions/workspaces/{workspaceId}/overriddenChildEntities | Finds API identifier overrides in given workspace hierarchy.
*ActionsApi* | [**particular_platform_usage**](docs/ActionsApi.md#particular_platform_usage) | **POST** /api/v1/actions/collectUsage | Info about the platform usage for particular items.
*ActionsApi* | [**permissions**](docs/ActionsApi.md#permissions) | **GET** /api/v1/actions/workspaces/{workspaceId}/analyticalDashboards/{dashboardId}/permissions | 
*ActionsApi* | [**register_upload_notification**](docs/ActionsApi.md#register_upload_notification) | **POST** /api/v1/actions/dataSources/{dataSourceId}/uploadNotification | Register an upload notification
*ActionsApi* | [**resolve_all_entitlements**](docs/ActionsApi.md#resolve_all_entitlements) | **GET** /api/v1/actions/resolveEntitlements | Values for all public entitlements.
*ActionsApi* | [**resolve_all_settings_without_workspace**](docs/ActionsApi.md#resolve_all_settings_without_workspace) | **GET** /api/v1/actions/resolveSettings | Values for all settings without workspace.
*ActionsApi* | [**resolve_requested_entitlements**](docs/ActionsApi.md#resolve_requested_entitlements) | **POST** /api/v1/actions/resolveEntitlements | Values for requested public entitlements.
*ActionsApi* | [**resolve_settings_without_workspace**](docs/ActionsApi.md#resolve_settings_without_workspace) | **POST** /api/v1/actions/resolveSettings | Values for selected settings without workspace.
*ActionsApi* | [**workspace_resolve_all_settings**](docs/ActionsApi.md#workspace_resolve_all_settings) | **GET** /api/v1/actions/workspaces/{workspaceId}/resolveSettings | Values for all settings.
*ActionsApi* | [**workspace_resolve_settings**](docs/ActionsApi.md#workspace_resolve_settings) | **POST** /api/v1/actions/workspaces/{workspaceId}/resolveSettings | Values for selected settings.
*DataSourceEntitiesControllerApi* | [**get_all_entities_data_source_tables**](docs/DataSourceEntitiesControllerApi.md#get_all_entities_data_source_tables) | **GET** /api/v1/entities/dataSources/{dataSourceId}/dataSourceTables | 
*DataSourceEntitiesControllerApi* | [**get_entity_data_source_tables**](docs/DataSourceEntitiesControllerApi.md#get_entity_data_source_tables) | **GET** /api/v1/entities/dataSources/{dataSourceId}/dataSourceTables/{id} | 
*EntitiesApi* | [**create_entity_analytical_dashboards**](docs/EntitiesApi.md#create_entity_analytical_dashboards) | **POST** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards | 
*EntitiesApi* | [**create_entity_api_tokens**](docs/EntitiesApi.md#create_entity_api_tokens) | **POST** /api/v1/entities/users/{userId}/apiTokens | 
*EntitiesApi* | [**create_entity_color_palettes**](docs/EntitiesApi.md#create_entity_color_palettes) | **POST** /api/v1/entities/colorPalettes | 
*EntitiesApi* | [**create_entity_csp_directives**](docs/EntitiesApi.md#create_entity_csp_directives) | **POST** /api/v1/entities/cspDirectives | 
*EntitiesApi* | [**create_entity_custom_application_settings**](docs/EntitiesApi.md#create_entity_custom_application_settings) | **POST** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings | 
*EntitiesApi* | [**create_entity_dashboard_plugins**](docs/EntitiesApi.md#create_entity_dashboard_plugins) | **POST** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins | 
*EntitiesApi* | [**create_entity_data_sources**](docs/EntitiesApi.md#create_entity_data_sources) | **POST** /api/v1/entities/dataSources | 
*EntitiesApi* | [**create_entity_filter_contexts**](docs/EntitiesApi.md#create_entity_filter_contexts) | **POST** /api/v1/entities/workspaces/{workspaceId}/filterContexts | 
*EntitiesApi* | [**create_entity_metrics**](docs/EntitiesApi.md#create_entity_metrics) | **POST** /api/v1/entities/workspaces/{workspaceId}/metrics | 
*EntitiesApi* | [**create_entity_organization_settings**](docs/EntitiesApi.md#create_entity_organization_settings) | **POST** /api/v1/entities/organizationSettings | 
*EntitiesApi* | [**create_entity_themes**](docs/EntitiesApi.md#create_entity_themes) | **POST** /api/v1/entities/themes | 
*EntitiesApi* | [**create_entity_user_groups**](docs/EntitiesApi.md#create_entity_user_groups) | **POST** /api/v1/entities/userGroups | 
*EntitiesApi* | [**create_entity_user_settings**](docs/EntitiesApi.md#create_entity_user_settings) | **POST** /api/v1/entities/users/{userId}/userSettings | 
*EntitiesApi* | [**create_entity_users**](docs/EntitiesApi.md#create_entity_users) | **POST** /api/v1/entities/users | 
*EntitiesApi* | [**create_entity_visualization_objects**](docs/EntitiesApi.md#create_entity_visualization_objects) | **POST** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects | 
*EntitiesApi* | [**create_entity_workspace_data_filters**](docs/EntitiesApi.md#create_entity_workspace_data_filters) | **POST** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters | 
*EntitiesApi* | [**create_entity_workspace_settings**](docs/EntitiesApi.md#create_entity_workspace_settings) | **POST** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings | 
*EntitiesApi* | [**create_entity_workspaces**](docs/EntitiesApi.md#create_entity_workspaces) | **POST** /api/v1/entities/workspaces | 
*EntitiesApi* | [**delete_entity_analytical_dashboards**](docs/EntitiesApi.md#delete_entity_analytical_dashboards) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | 
*EntitiesApi* | [**delete_entity_api_tokens**](docs/EntitiesApi.md#delete_entity_api_tokens) | **DELETE** /api/v1/entities/users/{userId}/apiTokens/{id} | 
*EntitiesApi* | [**delete_entity_color_palettes**](docs/EntitiesApi.md#delete_entity_color_palettes) | **DELETE** /api/v1/entities/colorPalettes/{id} | 
*EntitiesApi* | [**delete_entity_csp_directives**](docs/EntitiesApi.md#delete_entity_csp_directives) | **DELETE** /api/v1/entities/cspDirectives/{id} | 
*EntitiesApi* | [**delete_entity_custom_application_settings**](docs/EntitiesApi.md#delete_entity_custom_application_settings) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | 
*EntitiesApi* | [**delete_entity_dashboard_plugins**](docs/EntitiesApi.md#delete_entity_dashboard_plugins) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | 
*EntitiesApi* | [**delete_entity_data_sources**](docs/EntitiesApi.md#delete_entity_data_sources) | **DELETE** /api/v1/entities/dataSources/{id} | 
*EntitiesApi* | [**delete_entity_filter_contexts**](docs/EntitiesApi.md#delete_entity_filter_contexts) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | 
*EntitiesApi* | [**delete_entity_metrics**](docs/EntitiesApi.md#delete_entity_metrics) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | 
*EntitiesApi* | [**delete_entity_organization_settings**](docs/EntitiesApi.md#delete_entity_organization_settings) | **DELETE** /api/v1/entities/organizationSettings/{id} | 
*EntitiesApi* | [**delete_entity_themes**](docs/EntitiesApi.md#delete_entity_themes) | **DELETE** /api/v1/entities/themes/{id} | 
*EntitiesApi* | [**delete_entity_user_groups**](docs/EntitiesApi.md#delete_entity_user_groups) | **DELETE** /api/v1/entities/userGroups/{id} | 
*EntitiesApi* | [**delete_entity_user_settings**](docs/EntitiesApi.md#delete_entity_user_settings) | **DELETE** /api/v1/entities/users/{userId}/userSettings/{id} | 
*EntitiesApi* | [**delete_entity_users**](docs/EntitiesApi.md#delete_entity_users) | **DELETE** /api/v1/entities/users/{id} | 
*EntitiesApi* | [**delete_entity_visualization_objects**](docs/EntitiesApi.md#delete_entity_visualization_objects) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | 
*EntitiesApi* | [**delete_entity_workspace_data_filters**](docs/EntitiesApi.md#delete_entity_workspace_data_filters) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | 
*EntitiesApi* | [**delete_entity_workspace_settings**](docs/EntitiesApi.md#delete_entity_workspace_settings) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | 
*EntitiesApi* | [**delete_entity_workspaces**](docs/EntitiesApi.md#delete_entity_workspaces) | **DELETE** /api/v1/entities/workspaces/{id} | 
*EntitiesApi* | [**get_all_entities_analytical_dashboards**](docs/EntitiesApi.md#get_all_entities_analytical_dashboards) | **GET** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards | 
*EntitiesApi* | [**get_all_entities_api_tokens**](docs/EntitiesApi.md#get_all_entities_api_tokens) | **GET** /api/v1/entities/users/{userId}/apiTokens | List all api tokens for a user
*EntitiesApi* | [**get_all_entities_attributes**](docs/EntitiesApi.md#get_all_entities_attributes) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributes | 
*EntitiesApi* | [**get_all_entities_color_palettes**](docs/EntitiesApi.md#get_all_entities_color_palettes) | **GET** /api/v1/entities/colorPalettes | 
*EntitiesApi* | [**get_all_entities_csp_directives**](docs/EntitiesApi.md#get_all_entities_csp_directives) | **GET** /api/v1/entities/cspDirectives | 
*EntitiesApi* | [**get_all_entities_custom_application_settings**](docs/EntitiesApi.md#get_all_entities_custom_application_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings | 
*EntitiesApi* | [**get_all_entities_dashboard_plugins**](docs/EntitiesApi.md#get_all_entities_dashboard_plugins) | **GET** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins | 
*EntitiesApi* | [**get_all_entities_data_source_identifiers**](docs/EntitiesApi.md#get_all_entities_data_source_identifiers) | **GET** /api/v1/entities/dataSourceIdentifiers | 
*EntitiesApi* | [**get_all_entities_data_source_tables**](docs/EntitiesApi.md#get_all_entities_data_source_tables) | **GET** /api/v1/entities/dataSources/{dataSourceId}/dataSourceTables | 
*EntitiesApi* | [**get_all_entities_data_sources**](docs/EntitiesApi.md#get_all_entities_data_sources) | **GET** /api/v1/entities/dataSources | 
*EntitiesApi* | [**get_all_entities_datasets**](docs/EntitiesApi.md#get_all_entities_datasets) | **GET** /api/v1/entities/workspaces/{workspaceId}/datasets | 
*EntitiesApi* | [**get_all_entities_entitlements**](docs/EntitiesApi.md#get_all_entities_entitlements) | **GET** /api/v1/entities/entitlements | 
*EntitiesApi* | [**get_all_entities_facts**](docs/EntitiesApi.md#get_all_entities_facts) | **GET** /api/v1/entities/workspaces/{workspaceId}/facts | 
*EntitiesApi* | [**get_all_entities_filter_contexts**](docs/EntitiesApi.md#get_all_entities_filter_contexts) | **GET** /api/v1/entities/workspaces/{workspaceId}/filterContexts | 
*EntitiesApi* | [**get_all_entities_labels**](docs/EntitiesApi.md#get_all_entities_labels) | **GET** /api/v1/entities/workspaces/{workspaceId}/labels | 
*EntitiesApi* | [**get_all_entities_metrics**](docs/EntitiesApi.md#get_all_entities_metrics) | **GET** /api/v1/entities/workspaces/{workspaceId}/metrics | 
*EntitiesApi* | [**get_all_entities_organization_settings**](docs/EntitiesApi.md#get_all_entities_organization_settings) | **GET** /api/v1/entities/organizationSettings | 
*EntitiesApi* | [**get_all_entities_themes**](docs/EntitiesApi.md#get_all_entities_themes) | **GET** /api/v1/entities/themes | 
*EntitiesApi* | [**get_all_entities_user_groups**](docs/EntitiesApi.md#get_all_entities_user_groups) | **GET** /api/v1/entities/userGroups | 
*EntitiesApi* | [**get_all_entities_user_settings**](docs/EntitiesApi.md#get_all_entities_user_settings) | **GET** /api/v1/entities/users/{userId}/userSettings | List all settings for a user
*EntitiesApi* | [**get_all_entities_users**](docs/EntitiesApi.md#get_all_entities_users) | **GET** /api/v1/entities/users | 
*EntitiesApi* | [**get_all_entities_visualization_objects**](docs/EntitiesApi.md#get_all_entities_visualization_objects) | **GET** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects | 
*EntitiesApi* | [**get_all_entities_workspace_data_filter_settings**](docs/EntitiesApi.md#get_all_entities_workspace_data_filter_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings | 
*EntitiesApi* | [**get_all_entities_workspace_data_filters**](docs/EntitiesApi.md#get_all_entities_workspace_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters | 
*EntitiesApi* | [**get_all_entities_workspace_settings**](docs/EntitiesApi.md#get_all_entities_workspace_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings | 
*EntitiesApi* | [**get_all_entities_workspaces**](docs/EntitiesApi.md#get_all_entities_workspaces) | **GET** /api/v1/entities/workspaces | 
*EntitiesApi* | [**get_all_options**](docs/EntitiesApi.md#get_all_options) | **GET** /api/v1/options | Links for all configuration options
*EntitiesApi* | [**get_data_source_drivers**](docs/EntitiesApi.md#get_data_source_drivers) | **GET** /api/v1/options/availableDrivers | Get all available data source drivers
*EntitiesApi* | [**get_entity_analytical_dashboards**](docs/EntitiesApi.md#get_entity_analytical_dashboards) | **GET** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | 
*EntitiesApi* | [**get_entity_api_tokens**](docs/EntitiesApi.md#get_entity_api_tokens) | **GET** /api/v1/entities/users/{userId}/apiTokens/{id} | 
*EntitiesApi* | [**get_entity_attributes**](docs/EntitiesApi.md#get_entity_attributes) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributes/{objectId} | 
*EntitiesApi* | [**get_entity_color_palettes**](docs/EntitiesApi.md#get_entity_color_palettes) | **GET** /api/v1/entities/colorPalettes/{id} | 
*EntitiesApi* | [**get_entity_cookie_security_configurations**](docs/EntitiesApi.md#get_entity_cookie_security_configurations) | **GET** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | 
*EntitiesApi* | [**get_entity_csp_directives**](docs/EntitiesApi.md#get_entity_csp_directives) | **GET** /api/v1/entities/cspDirectives/{id} | 
*EntitiesApi* | [**get_entity_custom_application_settings**](docs/EntitiesApi.md#get_entity_custom_application_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | 
*EntitiesApi* | [**get_entity_dashboard_plugins**](docs/EntitiesApi.md#get_entity_dashboard_plugins) | **GET** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | 
*EntitiesApi* | [**get_entity_data_source_identifiers**](docs/EntitiesApi.md#get_entity_data_source_identifiers) | **GET** /api/v1/entities/dataSourceIdentifiers/{id} | 
*EntitiesApi* | [**get_entity_data_source_tables**](docs/EntitiesApi.md#get_entity_data_source_tables) | **GET** /api/v1/entities/dataSources/{dataSourceId}/dataSourceTables/{id} | 
*EntitiesApi* | [**get_entity_data_sources**](docs/EntitiesApi.md#get_entity_data_sources) | **GET** /api/v1/entities/dataSources/{id} | 
*EntitiesApi* | [**get_entity_datasets**](docs/EntitiesApi.md#get_entity_datasets) | **GET** /api/v1/entities/workspaces/{workspaceId}/datasets/{objectId} | 
*EntitiesApi* | [**get_entity_entitlements**](docs/EntitiesApi.md#get_entity_entitlements) | **GET** /api/v1/entities/entitlements/{id} | 
*EntitiesApi* | [**get_entity_facts**](docs/EntitiesApi.md#get_entity_facts) | **GET** /api/v1/entities/workspaces/{workspaceId}/facts/{objectId} | 
*EntitiesApi* | [**get_entity_filter_contexts**](docs/EntitiesApi.md#get_entity_filter_contexts) | **GET** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | 
*EntitiesApi* | [**get_entity_labels**](docs/EntitiesApi.md#get_entity_labels) | **GET** /api/v1/entities/workspaces/{workspaceId}/labels/{objectId} | 
*EntitiesApi* | [**get_entity_metrics**](docs/EntitiesApi.md#get_entity_metrics) | **GET** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | 
*EntitiesApi* | [**get_entity_organization_settings**](docs/EntitiesApi.md#get_entity_organization_settings) | **GET** /api/v1/entities/organizationSettings/{id} | 
*EntitiesApi* | [**get_entity_organizations**](docs/EntitiesApi.md#get_entity_organizations) | **GET** /api/v1/entities/admin/organizations/{id} | 
*EntitiesApi* | [**get_entity_themes**](docs/EntitiesApi.md#get_entity_themes) | **GET** /api/v1/entities/themes/{id} | 
*EntitiesApi* | [**get_entity_user_groups**](docs/EntitiesApi.md#get_entity_user_groups) | **GET** /api/v1/entities/userGroups/{id} | 
*EntitiesApi* | [**get_entity_user_settings**](docs/EntitiesApi.md#get_entity_user_settings) | **GET** /api/v1/entities/users/{userId}/userSettings/{id} | 
*EntitiesApi* | [**get_entity_users**](docs/EntitiesApi.md#get_entity_users) | **GET** /api/v1/entities/users/{id} | 
*EntitiesApi* | [**get_entity_visualization_objects**](docs/EntitiesApi.md#get_entity_visualization_objects) | **GET** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | 
*EntitiesApi* | [**get_entity_workspace_data_filter_settings**](docs/EntitiesApi.md#get_entity_workspace_data_filter_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId} | 
*EntitiesApi* | [**get_entity_workspace_data_filters**](docs/EntitiesApi.md#get_entity_workspace_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | 
*EntitiesApi* | [**get_entity_workspace_settings**](docs/EntitiesApi.md#get_entity_workspace_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | 
*EntitiesApi* | [**get_entity_workspaces**](docs/EntitiesApi.md#get_entity_workspaces) | **GET** /api/v1/entities/workspaces/{id} | 
*EntitiesApi* | [**get_organization**](docs/EntitiesApi.md#get_organization) | **GET** /api/v1/entities/organization | Get current organization info
*EntitiesApi* | [**patch_entity_analytical_dashboards**](docs/EntitiesApi.md#patch_entity_analytical_dashboards) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | 
*EntitiesApi* | [**patch_entity_color_palettes**](docs/EntitiesApi.md#patch_entity_color_palettes) | **PATCH** /api/v1/entities/colorPalettes/{id} | 
*EntitiesApi* | [**patch_entity_cookie_security_configurations**](docs/EntitiesApi.md#patch_entity_cookie_security_configurations) | **PATCH** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | 
*EntitiesApi* | [**patch_entity_csp_directives**](docs/EntitiesApi.md#patch_entity_csp_directives) | **PATCH** /api/v1/entities/cspDirectives/{id} | 
*EntitiesApi* | [**patch_entity_custom_application_settings**](docs/EntitiesApi.md#patch_entity_custom_application_settings) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | 
*EntitiesApi* | [**patch_entity_dashboard_plugins**](docs/EntitiesApi.md#patch_entity_dashboard_plugins) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | 
*EntitiesApi* | [**patch_entity_data_sources**](docs/EntitiesApi.md#patch_entity_data_sources) | **PATCH** /api/v1/entities/dataSources/{id} | 
*EntitiesApi* | [**patch_entity_filter_contexts**](docs/EntitiesApi.md#patch_entity_filter_contexts) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | 
*EntitiesApi* | [**patch_entity_metrics**](docs/EntitiesApi.md#patch_entity_metrics) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | 
*EntitiesApi* | [**patch_entity_organization_settings**](docs/EntitiesApi.md#patch_entity_organization_settings) | **PATCH** /api/v1/entities/organizationSettings/{id} | 
*EntitiesApi* | [**patch_entity_organizations**](docs/EntitiesApi.md#patch_entity_organizations) | **PATCH** /api/v1/entities/admin/organizations/{id} | 
*EntitiesApi* | [**patch_entity_themes**](docs/EntitiesApi.md#patch_entity_themes) | **PATCH** /api/v1/entities/themes/{id} | 
*EntitiesApi* | [**patch_entity_user_groups**](docs/EntitiesApi.md#patch_entity_user_groups) | **PATCH** /api/v1/entities/userGroups/{id} | 
*EntitiesApi* | [**patch_entity_users**](docs/EntitiesApi.md#patch_entity_users) | **PATCH** /api/v1/entities/users/{id} | 
*EntitiesApi* | [**patch_entity_visualization_objects**](docs/EntitiesApi.md#patch_entity_visualization_objects) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | 
*EntitiesApi* | [**patch_entity_workspace_data_filters**](docs/EntitiesApi.md#patch_entity_workspace_data_filters) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | 
*EntitiesApi* | [**patch_entity_workspace_settings**](docs/EntitiesApi.md#patch_entity_workspace_settings) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | 
*EntitiesApi* | [**patch_entity_workspaces**](docs/EntitiesApi.md#patch_entity_workspaces) | **PATCH** /api/v1/entities/workspaces/{id} | 
*EntitiesApi* | [**update_entity_analytical_dashboards**](docs/EntitiesApi.md#update_entity_analytical_dashboards) | **PUT** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | 
*EntitiesApi* | [**update_entity_api_tokens**](docs/EntitiesApi.md#update_entity_api_tokens) | **PUT** /api/v1/entities/users/{userId}/apiTokens/{id} | 
*EntitiesApi* | [**update_entity_color_palettes**](docs/EntitiesApi.md#update_entity_color_palettes) | **PUT** /api/v1/entities/colorPalettes/{id} | 
*EntitiesApi* | [**update_entity_cookie_security_configurations**](docs/EntitiesApi.md#update_entity_cookie_security_configurations) | **PUT** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | 
*EntitiesApi* | [**update_entity_csp_directives**](docs/EntitiesApi.md#update_entity_csp_directives) | **PUT** /api/v1/entities/cspDirectives/{id} | 
*EntitiesApi* | [**update_entity_custom_application_settings**](docs/EntitiesApi.md#update_entity_custom_application_settings) | **PUT** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | 
*EntitiesApi* | [**update_entity_dashboard_plugins**](docs/EntitiesApi.md#update_entity_dashboard_plugins) | **PUT** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | 
*EntitiesApi* | [**update_entity_data_sources**](docs/EntitiesApi.md#update_entity_data_sources) | **PUT** /api/v1/entities/dataSources/{id} | 
*EntitiesApi* | [**update_entity_filter_contexts**](docs/EntitiesApi.md#update_entity_filter_contexts) | **PUT** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | 
*EntitiesApi* | [**update_entity_metrics**](docs/EntitiesApi.md#update_entity_metrics) | **PUT** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | 
*EntitiesApi* | [**update_entity_organization_settings**](docs/EntitiesApi.md#update_entity_organization_settings) | **PUT** /api/v1/entities/organizationSettings/{id} | 
*EntitiesApi* | [**update_entity_organizations**](docs/EntitiesApi.md#update_entity_organizations) | **PUT** /api/v1/entities/admin/organizations/{id} | 
*EntitiesApi* | [**update_entity_themes**](docs/EntitiesApi.md#update_entity_themes) | **PUT** /api/v1/entities/themes/{id} | 
*EntitiesApi* | [**update_entity_user_groups**](docs/EntitiesApi.md#update_entity_user_groups) | **PUT** /api/v1/entities/userGroups/{id} | 
*EntitiesApi* | [**update_entity_user_settings**](docs/EntitiesApi.md#update_entity_user_settings) | **PUT** /api/v1/entities/users/{userId}/userSettings/{id} | 
*EntitiesApi* | [**update_entity_users**](docs/EntitiesApi.md#update_entity_users) | **PUT** /api/v1/entities/users/{id} | 
*EntitiesApi* | [**update_entity_visualization_objects**](docs/EntitiesApi.md#update_entity_visualization_objects) | **PUT** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | 
*EntitiesApi* | [**update_entity_workspace_data_filters**](docs/EntitiesApi.md#update_entity_workspace_data_filters) | **PUT** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | 
*EntitiesApi* | [**update_entity_workspace_settings**](docs/EntitiesApi.md#update_entity_workspace_settings) | **PUT** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | 
*EntitiesApi* | [**update_entity_workspaces**](docs/EntitiesApi.md#update_entity_workspaces) | **PUT** /api/v1/entities/workspaces/{id} | 
*LayoutApi* | [**get_analytics_model**](docs/LayoutApi.md#get_analytics_model) | **GET** /api/v1/layout/workspaces/{workspaceId}/analyticsModel | Get analytics model
*LayoutApi* | [**get_data_sources_layout**](docs/LayoutApi.md#get_data_sources_layout) | **GET** /api/v1/layout/dataSources | Get all data sources
*LayoutApi* | [**get_logical_model**](docs/LayoutApi.md#get_logical_model) | **GET** /api/v1/layout/workspaces/{workspaceId}/logicalModel | Get logical model
*LayoutApi* | [**get_organization_layout**](docs/LayoutApi.md#get_organization_layout) | **GET** /api/v1/layout/organization | Get organization layout
*LayoutApi* | [**get_pdm_layout**](docs/LayoutApi.md#get_pdm_layout) | **GET** /api/v1/layout/dataSources/{dataSourceId}/physicalModel | Get data source physical model layout
*LayoutApi* | [**get_user_group_permissions**](docs/LayoutApi.md#get_user_group_permissions) | **GET** /api/v1/layout/userGroups/{userGroupId}/permissions | Get permissions for the user-group
*LayoutApi* | [**get_user_groups_layout**](docs/LayoutApi.md#get_user_groups_layout) | **GET** /api/v1/layout/userGroups | Get all user groups
*LayoutApi* | [**get_user_permissions**](docs/LayoutApi.md#get_user_permissions) | **GET** /api/v1/layout/users/{userId}/permissions | Get permissions for the user
*LayoutApi* | [**get_users_layout**](docs/LayoutApi.md#get_users_layout) | **GET** /api/v1/layout/users | Get all users
*LayoutApi* | [**get_users_user_groups_layout**](docs/LayoutApi.md#get_users_user_groups_layout) | **GET** /api/v1/layout/usersAndUserGroups | Get all users and user groups
*LayoutApi* | [**get_workspace_data_filters_layout**](docs/LayoutApi.md#get_workspace_data_filters_layout) | **GET** /api/v1/layout/workspaceDataFilters | Get workspace data filters for all workspaces
*LayoutApi* | [**get_workspace_layout**](docs/LayoutApi.md#get_workspace_layout) | **GET** /api/v1/layout/workspaces/{workspaceId} | Get workspace layout
*LayoutApi* | [**get_workspace_permissions**](docs/LayoutApi.md#get_workspace_permissions) | **GET** /api/v1/layout/workspaces/{workspaceId}/permissions | Get permissions for the workspace
*LayoutApi* | [**get_workspaces_layout**](docs/LayoutApi.md#get_workspaces_layout) | **GET** /api/v1/layout/workspaces | Get all workspaces layout
*LayoutApi* | [**put_data_sources_layout**](docs/LayoutApi.md#put_data_sources_layout) | **PUT** /api/v1/layout/dataSources | Put all data sources
*LayoutApi* | [**put_user_groups_layout**](docs/LayoutApi.md#put_user_groups_layout) | **PUT** /api/v1/layout/userGroups | Put all user groups
*LayoutApi* | [**put_users_layout**](docs/LayoutApi.md#put_users_layout) | **PUT** /api/v1/layout/users | Put all users
*LayoutApi* | [**put_users_user_groups_layout**](docs/LayoutApi.md#put_users_user_groups_layout) | **PUT** /api/v1/layout/usersAndUserGroups | Put all users and user groups
*LayoutApi* | [**put_workspace_layout**](docs/LayoutApi.md#put_workspace_layout) | **PUT** /api/v1/layout/workspaces/{workspaceId} | Set workspace layout
*LayoutApi* | [**set_analytics_model**](docs/LayoutApi.md#set_analytics_model) | **PUT** /api/v1/layout/workspaces/{workspaceId}/analyticsModel | Set analytics model
*LayoutApi* | [**set_logical_model**](docs/LayoutApi.md#set_logical_model) | **PUT** /api/v1/layout/workspaces/{workspaceId}/logicalModel | Set logical model
*LayoutApi* | [**set_organization_layout**](docs/LayoutApi.md#set_organization_layout) | **PUT** /api/v1/layout/organization | Set organization layout
*LayoutApi* | [**set_pdm_layout**](docs/LayoutApi.md#set_pdm_layout) | **PUT** /api/v1/layout/dataSources/{dataSourceId}/physicalModel | Set data source physical model layout
*LayoutApi* | [**set_user_group_permissions**](docs/LayoutApi.md#set_user_group_permissions) | **PUT** /api/v1/layout/userGroups/{userGroupId}/permissions | Set permissions for the user-group
*LayoutApi* | [**set_user_permissions**](docs/LayoutApi.md#set_user_permissions) | **PUT** /api/v1/layout/users/{userId}/permissions | Set permissions for the user
*LayoutApi* | [**set_workspace_data_filters_layout**](docs/LayoutApi.md#set_workspace_data_filters_layout) | **PUT** /api/v1/layout/workspaceDataFilters | Set all workspace data filters
*LayoutApi* | [**set_workspace_permissions**](docs/LayoutApi.md#set_workspace_permissions) | **PUT** /api/v1/layout/workspaces/{workspaceId}/permissions | Set permissions for the workspace
*LayoutApi* | [**set_workspaces_layout**](docs/LayoutApi.md#set_workspaces_layout) | **PUT** /api/v1/layout/workspaces | Set all workspaces layout
*OrganizationControllerApi* | [**get_entity_cookie_security_configurations**](docs/OrganizationControllerApi.md#get_entity_cookie_security_configurations) | **GET** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | 
*OrganizationControllerApi* | [**get_entity_organizations**](docs/OrganizationControllerApi.md#get_entity_organizations) | **GET** /api/v1/entities/admin/organizations/{id} | 
*OrganizationControllerApi* | [**patch_entity_cookie_security_configurations**](docs/OrganizationControllerApi.md#patch_entity_cookie_security_configurations) | **PATCH** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | 
*OrganizationControllerApi* | [**patch_entity_organizations**](docs/OrganizationControllerApi.md#patch_entity_organizations) | **PATCH** /api/v1/entities/admin/organizations/{id} | 
*OrganizationControllerApi* | [**update_entity_cookie_security_configurations**](docs/OrganizationControllerApi.md#update_entity_cookie_security_configurations) | **PUT** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | 
*OrganizationControllerApi* | [**update_entity_organizations**](docs/OrganizationControllerApi.md#update_entity_organizations) | **PUT** /api/v1/entities/admin/organizations/{id} | 
*OrganizationModelControllerApi* | [**create_entity_color_palettes**](docs/OrganizationModelControllerApi.md#create_entity_color_palettes) | **POST** /api/v1/entities/colorPalettes | 
*OrganizationModelControllerApi* | [**create_entity_csp_directives**](docs/OrganizationModelControllerApi.md#create_entity_csp_directives) | **POST** /api/v1/entities/cspDirectives | 
*OrganizationModelControllerApi* | [**create_entity_data_sources**](docs/OrganizationModelControllerApi.md#create_entity_data_sources) | **POST** /api/v1/entities/dataSources | 
*OrganizationModelControllerApi* | [**create_entity_organization_settings**](docs/OrganizationModelControllerApi.md#create_entity_organization_settings) | **POST** /api/v1/entities/organizationSettings | 
*OrganizationModelControllerApi* | [**create_entity_themes**](docs/OrganizationModelControllerApi.md#create_entity_themes) | **POST** /api/v1/entities/themes | 
*OrganizationModelControllerApi* | [**create_entity_user_groups**](docs/OrganizationModelControllerApi.md#create_entity_user_groups) | **POST** /api/v1/entities/userGroups | 
*OrganizationModelControllerApi* | [**create_entity_users**](docs/OrganizationModelControllerApi.md#create_entity_users) | **POST** /api/v1/entities/users | 
*OrganizationModelControllerApi* | [**create_entity_workspaces**](docs/OrganizationModelControllerApi.md#create_entity_workspaces) | **POST** /api/v1/entities/workspaces | 
*OrganizationModelControllerApi* | [**delete_entity_color_palettes**](docs/OrganizationModelControllerApi.md#delete_entity_color_palettes) | **DELETE** /api/v1/entities/colorPalettes/{id} | 
*OrganizationModelControllerApi* | [**delete_entity_csp_directives**](docs/OrganizationModelControllerApi.md#delete_entity_csp_directives) | **DELETE** /api/v1/entities/cspDirectives/{id} | 
*OrganizationModelControllerApi* | [**delete_entity_data_sources**](docs/OrganizationModelControllerApi.md#delete_entity_data_sources) | **DELETE** /api/v1/entities/dataSources/{id} | 
*OrganizationModelControllerApi* | [**delete_entity_organization_settings**](docs/OrganizationModelControllerApi.md#delete_entity_organization_settings) | **DELETE** /api/v1/entities/organizationSettings/{id} | 
*OrganizationModelControllerApi* | [**delete_entity_themes**](docs/OrganizationModelControllerApi.md#delete_entity_themes) | **DELETE** /api/v1/entities/themes/{id} | 
*OrganizationModelControllerApi* | [**delete_entity_user_groups**](docs/OrganizationModelControllerApi.md#delete_entity_user_groups) | **DELETE** /api/v1/entities/userGroups/{id} | 
*OrganizationModelControllerApi* | [**delete_entity_users**](docs/OrganizationModelControllerApi.md#delete_entity_users) | **DELETE** /api/v1/entities/users/{id} | 
*OrganizationModelControllerApi* | [**delete_entity_workspaces**](docs/OrganizationModelControllerApi.md#delete_entity_workspaces) | **DELETE** /api/v1/entities/workspaces/{id} | 
*OrganizationModelControllerApi* | [**get_all_entities_color_palettes**](docs/OrganizationModelControllerApi.md#get_all_entities_color_palettes) | **GET** /api/v1/entities/colorPalettes | 
*OrganizationModelControllerApi* | [**get_all_entities_csp_directives**](docs/OrganizationModelControllerApi.md#get_all_entities_csp_directives) | **GET** /api/v1/entities/cspDirectives | 
*OrganizationModelControllerApi* | [**get_all_entities_data_source_identifiers**](docs/OrganizationModelControllerApi.md#get_all_entities_data_source_identifiers) | **GET** /api/v1/entities/dataSourceIdentifiers | 
*OrganizationModelControllerApi* | [**get_all_entities_data_sources**](docs/OrganizationModelControllerApi.md#get_all_entities_data_sources) | **GET** /api/v1/entities/dataSources | 
*OrganizationModelControllerApi* | [**get_all_entities_entitlements**](docs/OrganizationModelControllerApi.md#get_all_entities_entitlements) | **GET** /api/v1/entities/entitlements | 
*OrganizationModelControllerApi* | [**get_all_entities_organization_settings**](docs/OrganizationModelControllerApi.md#get_all_entities_organization_settings) | **GET** /api/v1/entities/organizationSettings | 
*OrganizationModelControllerApi* | [**get_all_entities_themes**](docs/OrganizationModelControllerApi.md#get_all_entities_themes) | **GET** /api/v1/entities/themes | 
*OrganizationModelControllerApi* | [**get_all_entities_user_groups**](docs/OrganizationModelControllerApi.md#get_all_entities_user_groups) | **GET** /api/v1/entities/userGroups | 
*OrganizationModelControllerApi* | [**get_all_entities_users**](docs/OrganizationModelControllerApi.md#get_all_entities_users) | **GET** /api/v1/entities/users | 
*OrganizationModelControllerApi* | [**get_all_entities_workspaces**](docs/OrganizationModelControllerApi.md#get_all_entities_workspaces) | **GET** /api/v1/entities/workspaces | 
*OrganizationModelControllerApi* | [**get_entity_color_palettes**](docs/OrganizationModelControllerApi.md#get_entity_color_palettes) | **GET** /api/v1/entities/colorPalettes/{id} | 
*OrganizationModelControllerApi* | [**get_entity_csp_directives**](docs/OrganizationModelControllerApi.md#get_entity_csp_directives) | **GET** /api/v1/entities/cspDirectives/{id} | 
*OrganizationModelControllerApi* | [**get_entity_data_source_identifiers**](docs/OrganizationModelControllerApi.md#get_entity_data_source_identifiers) | **GET** /api/v1/entities/dataSourceIdentifiers/{id} | 
*OrganizationModelControllerApi* | [**get_entity_data_sources**](docs/OrganizationModelControllerApi.md#get_entity_data_sources) | **GET** /api/v1/entities/dataSources/{id} | 
*OrganizationModelControllerApi* | [**get_entity_entitlements**](docs/OrganizationModelControllerApi.md#get_entity_entitlements) | **GET** /api/v1/entities/entitlements/{id} | 
*OrganizationModelControllerApi* | [**get_entity_organization_settings**](docs/OrganizationModelControllerApi.md#get_entity_organization_settings) | **GET** /api/v1/entities/organizationSettings/{id} | 
*OrganizationModelControllerApi* | [**get_entity_themes**](docs/OrganizationModelControllerApi.md#get_entity_themes) | **GET** /api/v1/entities/themes/{id} | 
*OrganizationModelControllerApi* | [**get_entity_user_groups**](docs/OrganizationModelControllerApi.md#get_entity_user_groups) | **GET** /api/v1/entities/userGroups/{id} | 
*OrganizationModelControllerApi* | [**get_entity_users**](docs/OrganizationModelControllerApi.md#get_entity_users) | **GET** /api/v1/entities/users/{id} | 
*OrganizationModelControllerApi* | [**get_entity_workspaces**](docs/OrganizationModelControllerApi.md#get_entity_workspaces) | **GET** /api/v1/entities/workspaces/{id} | 
*OrganizationModelControllerApi* | [**patch_entity_color_palettes**](docs/OrganizationModelControllerApi.md#patch_entity_color_palettes) | **PATCH** /api/v1/entities/colorPalettes/{id} | 
*OrganizationModelControllerApi* | [**patch_entity_csp_directives**](docs/OrganizationModelControllerApi.md#patch_entity_csp_directives) | **PATCH** /api/v1/entities/cspDirectives/{id} | 
*OrganizationModelControllerApi* | [**patch_entity_data_sources**](docs/OrganizationModelControllerApi.md#patch_entity_data_sources) | **PATCH** /api/v1/entities/dataSources/{id} | 
*OrganizationModelControllerApi* | [**patch_entity_organization_settings**](docs/OrganizationModelControllerApi.md#patch_entity_organization_settings) | **PATCH** /api/v1/entities/organizationSettings/{id} | 
*OrganizationModelControllerApi* | [**patch_entity_themes**](docs/OrganizationModelControllerApi.md#patch_entity_themes) | **PATCH** /api/v1/entities/themes/{id} | 
*OrganizationModelControllerApi* | [**patch_entity_user_groups**](docs/OrganizationModelControllerApi.md#patch_entity_user_groups) | **PATCH** /api/v1/entities/userGroups/{id} | 
*OrganizationModelControllerApi* | [**patch_entity_users**](docs/OrganizationModelControllerApi.md#patch_entity_users) | **PATCH** /api/v1/entities/users/{id} | 
*OrganizationModelControllerApi* | [**patch_entity_workspaces**](docs/OrganizationModelControllerApi.md#patch_entity_workspaces) | **PATCH** /api/v1/entities/workspaces/{id} | 
*OrganizationModelControllerApi* | [**update_entity_color_palettes**](docs/OrganizationModelControllerApi.md#update_entity_color_palettes) | **PUT** /api/v1/entities/colorPalettes/{id} | 
*OrganizationModelControllerApi* | [**update_entity_csp_directives**](docs/OrganizationModelControllerApi.md#update_entity_csp_directives) | **PUT** /api/v1/entities/cspDirectives/{id} | 
*OrganizationModelControllerApi* | [**update_entity_data_sources**](docs/OrganizationModelControllerApi.md#update_entity_data_sources) | **PUT** /api/v1/entities/dataSources/{id} | 
*OrganizationModelControllerApi* | [**update_entity_organization_settings**](docs/OrganizationModelControllerApi.md#update_entity_organization_settings) | **PUT** /api/v1/entities/organizationSettings/{id} | 
*OrganizationModelControllerApi* | [**update_entity_themes**](docs/OrganizationModelControllerApi.md#update_entity_themes) | **PUT** /api/v1/entities/themes/{id} | 
*OrganizationModelControllerApi* | [**update_entity_user_groups**](docs/OrganizationModelControllerApi.md#update_entity_user_groups) | **PUT** /api/v1/entities/userGroups/{id} | 
*OrganizationModelControllerApi* | [**update_entity_users**](docs/OrganizationModelControllerApi.md#update_entity_users) | **PUT** /api/v1/entities/users/{id} | 
*OrganizationModelControllerApi* | [**update_entity_workspaces**](docs/OrganizationModelControllerApi.md#update_entity_workspaces) | **PUT** /api/v1/entities/workspaces/{id} | 
*UserModelControllerApi* | [**create_entity_api_tokens**](docs/UserModelControllerApi.md#create_entity_api_tokens) | **POST** /api/v1/entities/users/{userId}/apiTokens | 
*UserModelControllerApi* | [**create_entity_user_settings**](docs/UserModelControllerApi.md#create_entity_user_settings) | **POST** /api/v1/entities/users/{userId}/userSettings | 
*UserModelControllerApi* | [**delete_entity_api_tokens**](docs/UserModelControllerApi.md#delete_entity_api_tokens) | **DELETE** /api/v1/entities/users/{userId}/apiTokens/{id} | 
*UserModelControllerApi* | [**delete_entity_user_settings**](docs/UserModelControllerApi.md#delete_entity_user_settings) | **DELETE** /api/v1/entities/users/{userId}/userSettings/{id} | 
*UserModelControllerApi* | [**get_all_entities_api_tokens**](docs/UserModelControllerApi.md#get_all_entities_api_tokens) | **GET** /api/v1/entities/users/{userId}/apiTokens | List all api tokens for a user
*UserModelControllerApi* | [**get_all_entities_user_settings**](docs/UserModelControllerApi.md#get_all_entities_user_settings) | **GET** /api/v1/entities/users/{userId}/userSettings | List all settings for a user
*UserModelControllerApi* | [**get_entity_api_tokens**](docs/UserModelControllerApi.md#get_entity_api_tokens) | **GET** /api/v1/entities/users/{userId}/apiTokens/{id} | 
*UserModelControllerApi* | [**get_entity_user_settings**](docs/UserModelControllerApi.md#get_entity_user_settings) | **GET** /api/v1/entities/users/{userId}/userSettings/{id} | 
*UserModelControllerApi* | [**update_entity_api_tokens**](docs/UserModelControllerApi.md#update_entity_api_tokens) | **PUT** /api/v1/entities/users/{userId}/apiTokens/{id} | 
*UserModelControllerApi* | [**update_entity_user_settings**](docs/UserModelControllerApi.md#update_entity_user_settings) | **PUT** /api/v1/entities/users/{userId}/userSettings/{id} | 
*WorkspaceObjectControllerApi* | [**create_entity_analytical_dashboards**](docs/WorkspaceObjectControllerApi.md#create_entity_analytical_dashboards) | **POST** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards | 
*WorkspaceObjectControllerApi* | [**create_entity_custom_application_settings**](docs/WorkspaceObjectControllerApi.md#create_entity_custom_application_settings) | **POST** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings | 
*WorkspaceObjectControllerApi* | [**create_entity_dashboard_plugins**](docs/WorkspaceObjectControllerApi.md#create_entity_dashboard_plugins) | **POST** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins | 
*WorkspaceObjectControllerApi* | [**create_entity_filter_contexts**](docs/WorkspaceObjectControllerApi.md#create_entity_filter_contexts) | **POST** /api/v1/entities/workspaces/{workspaceId}/filterContexts | 
*WorkspaceObjectControllerApi* | [**create_entity_metrics**](docs/WorkspaceObjectControllerApi.md#create_entity_metrics) | **POST** /api/v1/entities/workspaces/{workspaceId}/metrics | 
*WorkspaceObjectControllerApi* | [**create_entity_visualization_objects**](docs/WorkspaceObjectControllerApi.md#create_entity_visualization_objects) | **POST** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects | 
*WorkspaceObjectControllerApi* | [**create_entity_workspace_data_filters**](docs/WorkspaceObjectControllerApi.md#create_entity_workspace_data_filters) | **POST** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters | 
*WorkspaceObjectControllerApi* | [**create_entity_workspace_settings**](docs/WorkspaceObjectControllerApi.md#create_entity_workspace_settings) | **POST** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings | 
*WorkspaceObjectControllerApi* | [**delete_entity_analytical_dashboards**](docs/WorkspaceObjectControllerApi.md#delete_entity_analytical_dashboards) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | 
*WorkspaceObjectControllerApi* | [**delete_entity_custom_application_settings**](docs/WorkspaceObjectControllerApi.md#delete_entity_custom_application_settings) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | 
*WorkspaceObjectControllerApi* | [**delete_entity_dashboard_plugins**](docs/WorkspaceObjectControllerApi.md#delete_entity_dashboard_plugins) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | 
*WorkspaceObjectControllerApi* | [**delete_entity_filter_contexts**](docs/WorkspaceObjectControllerApi.md#delete_entity_filter_contexts) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | 
*WorkspaceObjectControllerApi* | [**delete_entity_metrics**](docs/WorkspaceObjectControllerApi.md#delete_entity_metrics) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | 
*WorkspaceObjectControllerApi* | [**delete_entity_visualization_objects**](docs/WorkspaceObjectControllerApi.md#delete_entity_visualization_objects) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | 
*WorkspaceObjectControllerApi* | [**delete_entity_workspace_data_filters**](docs/WorkspaceObjectControllerApi.md#delete_entity_workspace_data_filters) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | 
*WorkspaceObjectControllerApi* | [**delete_entity_workspace_settings**](docs/WorkspaceObjectControllerApi.md#delete_entity_workspace_settings) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | 
*WorkspaceObjectControllerApi* | [**get_all_entities_analytical_dashboards**](docs/WorkspaceObjectControllerApi.md#get_all_entities_analytical_dashboards) | **GET** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards | 
*WorkspaceObjectControllerApi* | [**get_all_entities_attributes**](docs/WorkspaceObjectControllerApi.md#get_all_entities_attributes) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributes | 
*WorkspaceObjectControllerApi* | [**get_all_entities_custom_application_settings**](docs/WorkspaceObjectControllerApi.md#get_all_entities_custom_application_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings | 
*WorkspaceObjectControllerApi* | [**get_all_entities_dashboard_plugins**](docs/WorkspaceObjectControllerApi.md#get_all_entities_dashboard_plugins) | **GET** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins | 
*WorkspaceObjectControllerApi* | [**get_all_entities_datasets**](docs/WorkspaceObjectControllerApi.md#get_all_entities_datasets) | **GET** /api/v1/entities/workspaces/{workspaceId}/datasets | 
*WorkspaceObjectControllerApi* | [**get_all_entities_facts**](docs/WorkspaceObjectControllerApi.md#get_all_entities_facts) | **GET** /api/v1/entities/workspaces/{workspaceId}/facts | 
*WorkspaceObjectControllerApi* | [**get_all_entities_filter_contexts**](docs/WorkspaceObjectControllerApi.md#get_all_entities_filter_contexts) | **GET** /api/v1/entities/workspaces/{workspaceId}/filterContexts | 
*WorkspaceObjectControllerApi* | [**get_all_entities_labels**](docs/WorkspaceObjectControllerApi.md#get_all_entities_labels) | **GET** /api/v1/entities/workspaces/{workspaceId}/labels | 
*WorkspaceObjectControllerApi* | [**get_all_entities_metrics**](docs/WorkspaceObjectControllerApi.md#get_all_entities_metrics) | **GET** /api/v1/entities/workspaces/{workspaceId}/metrics | 
*WorkspaceObjectControllerApi* | [**get_all_entities_visualization_objects**](docs/WorkspaceObjectControllerApi.md#get_all_entities_visualization_objects) | **GET** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects | 
*WorkspaceObjectControllerApi* | [**get_all_entities_workspace_data_filter_settings**](docs/WorkspaceObjectControllerApi.md#get_all_entities_workspace_data_filter_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings | 
*WorkspaceObjectControllerApi* | [**get_all_entities_workspace_data_filters**](docs/WorkspaceObjectControllerApi.md#get_all_entities_workspace_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters | 
*WorkspaceObjectControllerApi* | [**get_all_entities_workspace_settings**](docs/WorkspaceObjectControllerApi.md#get_all_entities_workspace_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings | 
*WorkspaceObjectControllerApi* | [**get_entity_analytical_dashboards**](docs/WorkspaceObjectControllerApi.md#get_entity_analytical_dashboards) | **GET** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | 
*WorkspaceObjectControllerApi* | [**get_entity_attributes**](docs/WorkspaceObjectControllerApi.md#get_entity_attributes) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributes/{objectId} | 
*WorkspaceObjectControllerApi* | [**get_entity_custom_application_settings**](docs/WorkspaceObjectControllerApi.md#get_entity_custom_application_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | 
*WorkspaceObjectControllerApi* | [**get_entity_dashboard_plugins**](docs/WorkspaceObjectControllerApi.md#get_entity_dashboard_plugins) | **GET** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | 
*WorkspaceObjectControllerApi* | [**get_entity_datasets**](docs/WorkspaceObjectControllerApi.md#get_entity_datasets) | **GET** /api/v1/entities/workspaces/{workspaceId}/datasets/{objectId} | 
*WorkspaceObjectControllerApi* | [**get_entity_facts**](docs/WorkspaceObjectControllerApi.md#get_entity_facts) | **GET** /api/v1/entities/workspaces/{workspaceId}/facts/{objectId} | 
*WorkspaceObjectControllerApi* | [**get_entity_filter_contexts**](docs/WorkspaceObjectControllerApi.md#get_entity_filter_contexts) | **GET** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | 
*WorkspaceObjectControllerApi* | [**get_entity_labels**](docs/WorkspaceObjectControllerApi.md#get_entity_labels) | **GET** /api/v1/entities/workspaces/{workspaceId}/labels/{objectId} | 
*WorkspaceObjectControllerApi* | [**get_entity_metrics**](docs/WorkspaceObjectControllerApi.md#get_entity_metrics) | **GET** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | 
*WorkspaceObjectControllerApi* | [**get_entity_visualization_objects**](docs/WorkspaceObjectControllerApi.md#get_entity_visualization_objects) | **GET** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | 
*WorkspaceObjectControllerApi* | [**get_entity_workspace_data_filter_settings**](docs/WorkspaceObjectControllerApi.md#get_entity_workspace_data_filter_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId} | 
*WorkspaceObjectControllerApi* | [**get_entity_workspace_data_filters**](docs/WorkspaceObjectControllerApi.md#get_entity_workspace_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | 
*WorkspaceObjectControllerApi* | [**get_entity_workspace_settings**](docs/WorkspaceObjectControllerApi.md#get_entity_workspace_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | 
*WorkspaceObjectControllerApi* | [**patch_entity_analytical_dashboards**](docs/WorkspaceObjectControllerApi.md#patch_entity_analytical_dashboards) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | 
*WorkspaceObjectControllerApi* | [**patch_entity_custom_application_settings**](docs/WorkspaceObjectControllerApi.md#patch_entity_custom_application_settings) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | 
*WorkspaceObjectControllerApi* | [**patch_entity_dashboard_plugins**](docs/WorkspaceObjectControllerApi.md#patch_entity_dashboard_plugins) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | 
*WorkspaceObjectControllerApi* | [**patch_entity_filter_contexts**](docs/WorkspaceObjectControllerApi.md#patch_entity_filter_contexts) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | 
*WorkspaceObjectControllerApi* | [**patch_entity_metrics**](docs/WorkspaceObjectControllerApi.md#patch_entity_metrics) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | 
*WorkspaceObjectControllerApi* | [**patch_entity_visualization_objects**](docs/WorkspaceObjectControllerApi.md#patch_entity_visualization_objects) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | 
*WorkspaceObjectControllerApi* | [**patch_entity_workspace_data_filters**](docs/WorkspaceObjectControllerApi.md#patch_entity_workspace_data_filters) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | 
*WorkspaceObjectControllerApi* | [**patch_entity_workspace_settings**](docs/WorkspaceObjectControllerApi.md#patch_entity_workspace_settings) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | 
*WorkspaceObjectControllerApi* | [**update_entity_analytical_dashboards**](docs/WorkspaceObjectControllerApi.md#update_entity_analytical_dashboards) | **PUT** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | 
*WorkspaceObjectControllerApi* | [**update_entity_custom_application_settings**](docs/WorkspaceObjectControllerApi.md#update_entity_custom_application_settings) | **PUT** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | 
*WorkspaceObjectControllerApi* | [**update_entity_dashboard_plugins**](docs/WorkspaceObjectControllerApi.md#update_entity_dashboard_plugins) | **PUT** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | 
*WorkspaceObjectControllerApi* | [**update_entity_filter_contexts**](docs/WorkspaceObjectControllerApi.md#update_entity_filter_contexts) | **PUT** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | 
*WorkspaceObjectControllerApi* | [**update_entity_metrics**](docs/WorkspaceObjectControllerApi.md#update_entity_metrics) | **PUT** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | 
*WorkspaceObjectControllerApi* | [**update_entity_visualization_objects**](docs/WorkspaceObjectControllerApi.md#update_entity_visualization_objects) | **PUT** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | 
*WorkspaceObjectControllerApi* | [**update_entity_workspace_data_filters**](docs/WorkspaceObjectControllerApi.md#update_entity_workspace_data_filters) | **PUT** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | 
*WorkspaceObjectControllerApi* | [**update_entity_workspace_settings**](docs/WorkspaceObjectControllerApi.md#update_entity_workspace_settings) | **PUT** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | 


## Documentation For Models

 - [ApiEntitlement](docs/ApiEntitlement.md)
 - [AssigneeIdentifier](docs/AssigneeIdentifier.md)
 - [AvailableAssignees](docs/AvailableAssignees.md)
 - [DashboardPermissions](docs/DashboardPermissions.md)
 - [DataSourceTableIdentifier](docs/DataSourceTableIdentifier.md)
 - [DatasetReferenceIdentifier](docs/DatasetReferenceIdentifier.md)
 - [DeclarativeAnalyticalDashboard](docs/DeclarativeAnalyticalDashboard.md)
 - [DeclarativeAnalyticalDashboardExtension](docs/DeclarativeAnalyticalDashboardExtension.md)
 - [DeclarativeAnalyticalDashboardPermission](docs/DeclarativeAnalyticalDashboardPermission.md)
 - [DeclarativeAnalytics](docs/DeclarativeAnalytics.md)
 - [DeclarativeAnalyticsLayer](docs/DeclarativeAnalyticsLayer.md)
 - [DeclarativeAttribute](docs/DeclarativeAttribute.md)
 - [DeclarativeColorPalette](docs/DeclarativeColorPalette.md)
 - [DeclarativeColumn](docs/DeclarativeColumn.md)
 - [DeclarativeCspDirective](docs/DeclarativeCspDirective.md)
 - [DeclarativeCustomApplicationSetting](docs/DeclarativeCustomApplicationSetting.md)
 - [DeclarativeDashboardPlugin](docs/DeclarativeDashboardPlugin.md)
 - [DeclarativeDataSource](docs/DeclarativeDataSource.md)
 - [DeclarativeDataSourcePermission](docs/DeclarativeDataSourcePermission.md)
 - [DeclarativeDataSources](docs/DeclarativeDataSources.md)
 - [DeclarativeDataset](docs/DeclarativeDataset.md)
 - [DeclarativeDatasetSql](docs/DeclarativeDatasetSql.md)
 - [DeclarativeDateDataset](docs/DeclarativeDateDataset.md)
 - [DeclarativeFact](docs/DeclarativeFact.md)
 - [DeclarativeFilterContext](docs/DeclarativeFilterContext.md)
 - [DeclarativeLabel](docs/DeclarativeLabel.md)
 - [DeclarativeLdm](docs/DeclarativeLdm.md)
 - [DeclarativeMetric](docs/DeclarativeMetric.md)
 - [DeclarativeModel](docs/DeclarativeModel.md)
 - [DeclarativeOrganization](docs/DeclarativeOrganization.md)
 - [DeclarativeOrganizationInfo](docs/DeclarativeOrganizationInfo.md)
 - [DeclarativeOrganizationPermission](docs/DeclarativeOrganizationPermission.md)
 - [DeclarativePdm](docs/DeclarativePdm.md)
 - [DeclarativeReference](docs/DeclarativeReference.md)
 - [DeclarativeSetting](docs/DeclarativeSetting.md)
 - [DeclarativeSingleWorkspacePermission](docs/DeclarativeSingleWorkspacePermission.md)
 - [DeclarativeTable](docs/DeclarativeTable.md)
 - [DeclarativeTables](docs/DeclarativeTables.md)
 - [DeclarativeTheme](docs/DeclarativeTheme.md)
 - [DeclarativeUser](docs/DeclarativeUser.md)
 - [DeclarativeUserGroup](docs/DeclarativeUserGroup.md)
 - [DeclarativeUserGroupPermission](docs/DeclarativeUserGroupPermission.md)
 - [DeclarativeUserGroupPermissions](docs/DeclarativeUserGroupPermissions.md)
 - [DeclarativeUserGroups](docs/DeclarativeUserGroups.md)
 - [DeclarativeUserPermission](docs/DeclarativeUserPermission.md)
 - [DeclarativeUserPermissions](docs/DeclarativeUserPermissions.md)
 - [DeclarativeUsers](docs/DeclarativeUsers.md)
 - [DeclarativeUsersUserGroups](docs/DeclarativeUsersUserGroups.md)
 - [DeclarativeVisualizationObject](docs/DeclarativeVisualizationObject.md)
 - [DeclarativeWorkspace](docs/DeclarativeWorkspace.md)
 - [DeclarativeWorkspaceDataFilter](docs/DeclarativeWorkspaceDataFilter.md)
 - [DeclarativeWorkspaceDataFilterSetting](docs/DeclarativeWorkspaceDataFilterSetting.md)
 - [DeclarativeWorkspaceDataFilters](docs/DeclarativeWorkspaceDataFilters.md)
 - [DeclarativeWorkspaceHierarchyPermission](docs/DeclarativeWorkspaceHierarchyPermission.md)
 - [DeclarativeWorkspaceModel](docs/DeclarativeWorkspaceModel.md)
 - [DeclarativeWorkspacePermissions](docs/DeclarativeWorkspacePermissions.md)
 - [DeclarativeWorkspaces](docs/DeclarativeWorkspaces.md)
 - [DependentEntitiesGraph](docs/DependentEntitiesGraph.md)
 - [DependentEntitiesNode](docs/DependentEntitiesNode.md)
 - [DependentEntitiesRequest](docs/DependentEntitiesRequest.md)
 - [DependentEntitiesResponse](docs/DependentEntitiesResponse.md)
 - [EntitlementsRequest](docs/EntitlementsRequest.md)
 - [EntityIdentifier](docs/EntityIdentifier.md)
 - [GenerateLdmRequest](docs/GenerateLdmRequest.md)
 - [GrainIdentifier](docs/GrainIdentifier.md)
 - [GrantedPermission](docs/GrantedPermission.md)
 - [GranularitiesFormatting](docs/GranularitiesFormatting.md)
 - [HierarchyObjectIdentification](docs/HierarchyObjectIdentification.md)
 - [IdentifierDuplications](docs/IdentifierDuplications.md)
 - [JsonApiAnalyticalDashboardIn](docs/JsonApiAnalyticalDashboardIn.md)
 - [JsonApiAnalyticalDashboardInAttributes](docs/JsonApiAnalyticalDashboardInAttributes.md)
 - [JsonApiAnalyticalDashboardInDocument](docs/JsonApiAnalyticalDashboardInDocument.md)
 - [JsonApiAnalyticalDashboardLinkage](docs/JsonApiAnalyticalDashboardLinkage.md)
 - [JsonApiAnalyticalDashboardOut](docs/JsonApiAnalyticalDashboardOut.md)
 - [JsonApiAnalyticalDashboardOutDocument](docs/JsonApiAnalyticalDashboardOutDocument.md)
 - [JsonApiAnalyticalDashboardOutIncludes](docs/JsonApiAnalyticalDashboardOutIncludes.md)
 - [JsonApiAnalyticalDashboardOutList](docs/JsonApiAnalyticalDashboardOutList.md)
 - [JsonApiAnalyticalDashboardOutMeta](docs/JsonApiAnalyticalDashboardOutMeta.md)
 - [JsonApiAnalyticalDashboardOutMetaAccessInfo](docs/JsonApiAnalyticalDashboardOutMetaAccessInfo.md)
 - [JsonApiAnalyticalDashboardOutMetaOrigin](docs/JsonApiAnalyticalDashboardOutMetaOrigin.md)
 - [JsonApiAnalyticalDashboardOutRelationships](docs/JsonApiAnalyticalDashboardOutRelationships.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsAnalyticalDashboards](docs/JsonApiAnalyticalDashboardOutRelationshipsAnalyticalDashboards.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsDashboardPlugins](docs/JsonApiAnalyticalDashboardOutRelationshipsDashboardPlugins.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsDatasets](docs/JsonApiAnalyticalDashboardOutRelationshipsDatasets.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsFilterContexts](docs/JsonApiAnalyticalDashboardOutRelationshipsFilterContexts.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsLabels](docs/JsonApiAnalyticalDashboardOutRelationshipsLabels.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsMetrics](docs/JsonApiAnalyticalDashboardOutRelationshipsMetrics.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsVisualizationObjects](docs/JsonApiAnalyticalDashboardOutRelationshipsVisualizationObjects.md)
 - [JsonApiAnalyticalDashboardOutWithLinks](docs/JsonApiAnalyticalDashboardOutWithLinks.md)
 - [JsonApiAnalyticalDashboardPatch](docs/JsonApiAnalyticalDashboardPatch.md)
 - [JsonApiAnalyticalDashboardPatchDocument](docs/JsonApiAnalyticalDashboardPatchDocument.md)
 - [JsonApiAnalyticalDashboardToManyLinkage](docs/JsonApiAnalyticalDashboardToManyLinkage.md)
 - [JsonApiApiTokenIn](docs/JsonApiApiTokenIn.md)
 - [JsonApiApiTokenInDocument](docs/JsonApiApiTokenInDocument.md)
 - [JsonApiApiTokenOut](docs/JsonApiApiTokenOut.md)
 - [JsonApiApiTokenOutAttributes](docs/JsonApiApiTokenOutAttributes.md)
 - [JsonApiApiTokenOutDocument](docs/JsonApiApiTokenOutDocument.md)
 - [JsonApiApiTokenOutList](docs/JsonApiApiTokenOutList.md)
 - [JsonApiApiTokenOutWithLinks](docs/JsonApiApiTokenOutWithLinks.md)
 - [JsonApiAttributeLinkage](docs/JsonApiAttributeLinkage.md)
 - [JsonApiAttributeOut](docs/JsonApiAttributeOut.md)
 - [JsonApiAttributeOutAttributes](docs/JsonApiAttributeOutAttributes.md)
 - [JsonApiAttributeOutDocument](docs/JsonApiAttributeOutDocument.md)
 - [JsonApiAttributeOutIncludes](docs/JsonApiAttributeOutIncludes.md)
 - [JsonApiAttributeOutList](docs/JsonApiAttributeOutList.md)
 - [JsonApiAttributeOutMeta](docs/JsonApiAttributeOutMeta.md)
 - [JsonApiAttributeOutRelationships](docs/JsonApiAttributeOutRelationships.md)
 - [JsonApiAttributeOutRelationshipsDataset](docs/JsonApiAttributeOutRelationshipsDataset.md)
 - [JsonApiAttributeOutRelationshipsDefaultView](docs/JsonApiAttributeOutRelationshipsDefaultView.md)
 - [JsonApiAttributeOutWithLinks](docs/JsonApiAttributeOutWithLinks.md)
 - [JsonApiAttributeToManyLinkage](docs/JsonApiAttributeToManyLinkage.md)
 - [JsonApiAttributeToOneLinkage](docs/JsonApiAttributeToOneLinkage.md)
 - [JsonApiColorPaletteIn](docs/JsonApiColorPaletteIn.md)
 - [JsonApiColorPaletteInAttributes](docs/JsonApiColorPaletteInAttributes.md)
 - [JsonApiColorPaletteInDocument](docs/JsonApiColorPaletteInDocument.md)
 - [JsonApiColorPaletteOut](docs/JsonApiColorPaletteOut.md)
 - [JsonApiColorPaletteOutDocument](docs/JsonApiColorPaletteOutDocument.md)
 - [JsonApiColorPaletteOutList](docs/JsonApiColorPaletteOutList.md)
 - [JsonApiColorPaletteOutWithLinks](docs/JsonApiColorPaletteOutWithLinks.md)
 - [JsonApiColorPalettePatch](docs/JsonApiColorPalettePatch.md)
 - [JsonApiColorPalettePatchAttributes](docs/JsonApiColorPalettePatchAttributes.md)
 - [JsonApiColorPalettePatchDocument](docs/JsonApiColorPalettePatchDocument.md)
 - [JsonApiCookieSecurityConfigurationIn](docs/JsonApiCookieSecurityConfigurationIn.md)
 - [JsonApiCookieSecurityConfigurationInAttributes](docs/JsonApiCookieSecurityConfigurationInAttributes.md)
 - [JsonApiCookieSecurityConfigurationInDocument](docs/JsonApiCookieSecurityConfigurationInDocument.md)
 - [JsonApiCookieSecurityConfigurationOut](docs/JsonApiCookieSecurityConfigurationOut.md)
 - [JsonApiCookieSecurityConfigurationOutDocument](docs/JsonApiCookieSecurityConfigurationOutDocument.md)
 - [JsonApiCookieSecurityConfigurationPatch](docs/JsonApiCookieSecurityConfigurationPatch.md)
 - [JsonApiCookieSecurityConfigurationPatchDocument](docs/JsonApiCookieSecurityConfigurationPatchDocument.md)
 - [JsonApiCspDirectiveIn](docs/JsonApiCspDirectiveIn.md)
 - [JsonApiCspDirectiveInAttributes](docs/JsonApiCspDirectiveInAttributes.md)
 - [JsonApiCspDirectiveInDocument](docs/JsonApiCspDirectiveInDocument.md)
 - [JsonApiCspDirectiveOut](docs/JsonApiCspDirectiveOut.md)
 - [JsonApiCspDirectiveOutDocument](docs/JsonApiCspDirectiveOutDocument.md)
 - [JsonApiCspDirectiveOutList](docs/JsonApiCspDirectiveOutList.md)
 - [JsonApiCspDirectiveOutWithLinks](docs/JsonApiCspDirectiveOutWithLinks.md)
 - [JsonApiCspDirectivePatch](docs/JsonApiCspDirectivePatch.md)
 - [JsonApiCspDirectivePatchAttributes](docs/JsonApiCspDirectivePatchAttributes.md)
 - [JsonApiCspDirectivePatchDocument](docs/JsonApiCspDirectivePatchDocument.md)
 - [JsonApiCustomApplicationSettingIn](docs/JsonApiCustomApplicationSettingIn.md)
 - [JsonApiCustomApplicationSettingInAttributes](docs/JsonApiCustomApplicationSettingInAttributes.md)
 - [JsonApiCustomApplicationSettingInDocument](docs/JsonApiCustomApplicationSettingInDocument.md)
 - [JsonApiCustomApplicationSettingOut](docs/JsonApiCustomApplicationSettingOut.md)
 - [JsonApiCustomApplicationSettingOutDocument](docs/JsonApiCustomApplicationSettingOutDocument.md)
 - [JsonApiCustomApplicationSettingOutList](docs/JsonApiCustomApplicationSettingOutList.md)
 - [JsonApiCustomApplicationSettingOutWithLinks](docs/JsonApiCustomApplicationSettingOutWithLinks.md)
 - [JsonApiCustomApplicationSettingPatch](docs/JsonApiCustomApplicationSettingPatch.md)
 - [JsonApiCustomApplicationSettingPatchAttributes](docs/JsonApiCustomApplicationSettingPatchAttributes.md)
 - [JsonApiCustomApplicationSettingPatchDocument](docs/JsonApiCustomApplicationSettingPatchDocument.md)
 - [JsonApiDashboardPluginIn](docs/JsonApiDashboardPluginIn.md)
 - [JsonApiDashboardPluginInAttributes](docs/JsonApiDashboardPluginInAttributes.md)
 - [JsonApiDashboardPluginInDocument](docs/JsonApiDashboardPluginInDocument.md)
 - [JsonApiDashboardPluginLinkage](docs/JsonApiDashboardPluginLinkage.md)
 - [JsonApiDashboardPluginOut](docs/JsonApiDashboardPluginOut.md)
 - [JsonApiDashboardPluginOutDocument](docs/JsonApiDashboardPluginOutDocument.md)
 - [JsonApiDashboardPluginOutList](docs/JsonApiDashboardPluginOutList.md)
 - [JsonApiDashboardPluginOutWithLinks](docs/JsonApiDashboardPluginOutWithLinks.md)
 - [JsonApiDashboardPluginPatch](docs/JsonApiDashboardPluginPatch.md)
 - [JsonApiDashboardPluginPatchDocument](docs/JsonApiDashboardPluginPatchDocument.md)
 - [JsonApiDashboardPluginToManyLinkage](docs/JsonApiDashboardPluginToManyLinkage.md)
 - [JsonApiDataSourceIdentifierOut](docs/JsonApiDataSourceIdentifierOut.md)
 - [JsonApiDataSourceIdentifierOutAttributes](docs/JsonApiDataSourceIdentifierOutAttributes.md)
 - [JsonApiDataSourceIdentifierOutDocument](docs/JsonApiDataSourceIdentifierOutDocument.md)
 - [JsonApiDataSourceIdentifierOutList](docs/JsonApiDataSourceIdentifierOutList.md)
 - [JsonApiDataSourceIdentifierOutMeta](docs/JsonApiDataSourceIdentifierOutMeta.md)
 - [JsonApiDataSourceIdentifierOutWithLinks](docs/JsonApiDataSourceIdentifierOutWithLinks.md)
 - [JsonApiDataSourceIn](docs/JsonApiDataSourceIn.md)
 - [JsonApiDataSourceInAttributes](docs/JsonApiDataSourceInAttributes.md)
 - [JsonApiDataSourceInAttributesParametersInner](docs/JsonApiDataSourceInAttributesParametersInner.md)
 - [JsonApiDataSourceInDocument](docs/JsonApiDataSourceInDocument.md)
 - [JsonApiDataSourceOut](docs/JsonApiDataSourceOut.md)
 - [JsonApiDataSourceOutAttributes](docs/JsonApiDataSourceOutAttributes.md)
 - [JsonApiDataSourceOutDocument](docs/JsonApiDataSourceOutDocument.md)
 - [JsonApiDataSourceOutList](docs/JsonApiDataSourceOutList.md)
 - [JsonApiDataSourceOutWithLinks](docs/JsonApiDataSourceOutWithLinks.md)
 - [JsonApiDataSourcePatch](docs/JsonApiDataSourcePatch.md)
 - [JsonApiDataSourcePatchAttributes](docs/JsonApiDataSourcePatchAttributes.md)
 - [JsonApiDataSourcePatchDocument](docs/JsonApiDataSourcePatchDocument.md)
 - [JsonApiDataSourceTableOut](docs/JsonApiDataSourceTableOut.md)
 - [JsonApiDataSourceTableOutAttributes](docs/JsonApiDataSourceTableOutAttributes.md)
 - [JsonApiDataSourceTableOutAttributesColumnsInner](docs/JsonApiDataSourceTableOutAttributesColumnsInner.md)
 - [JsonApiDataSourceTableOutDocument](docs/JsonApiDataSourceTableOutDocument.md)
 - [JsonApiDataSourceTableOutList](docs/JsonApiDataSourceTableOutList.md)
 - [JsonApiDataSourceTableOutWithLinks](docs/JsonApiDataSourceTableOutWithLinks.md)
 - [JsonApiDatasetLinkage](docs/JsonApiDatasetLinkage.md)
 - [JsonApiDatasetOut](docs/JsonApiDatasetOut.md)
 - [JsonApiDatasetOutAttributes](docs/JsonApiDatasetOutAttributes.md)
 - [JsonApiDatasetOutAttributesGrainInner](docs/JsonApiDatasetOutAttributesGrainInner.md)
 - [JsonApiDatasetOutAttributesReferencePropertiesInner](docs/JsonApiDatasetOutAttributesReferencePropertiesInner.md)
 - [JsonApiDatasetOutAttributesSql](docs/JsonApiDatasetOutAttributesSql.md)
 - [JsonApiDatasetOutDocument](docs/JsonApiDatasetOutDocument.md)
 - [JsonApiDatasetOutIncludes](docs/JsonApiDatasetOutIncludes.md)
 - [JsonApiDatasetOutList](docs/JsonApiDatasetOutList.md)
 - [JsonApiDatasetOutRelationships](docs/JsonApiDatasetOutRelationships.md)
 - [JsonApiDatasetOutRelationshipsAttributes](docs/JsonApiDatasetOutRelationshipsAttributes.md)
 - [JsonApiDatasetOutRelationshipsFacts](docs/JsonApiDatasetOutRelationshipsFacts.md)
 - [JsonApiDatasetOutWithLinks](docs/JsonApiDatasetOutWithLinks.md)
 - [JsonApiDatasetToManyLinkage](docs/JsonApiDatasetToManyLinkage.md)
 - [JsonApiDatasetToOneLinkage](docs/JsonApiDatasetToOneLinkage.md)
 - [JsonApiEntitlementOut](docs/JsonApiEntitlementOut.md)
 - [JsonApiEntitlementOutAttributes](docs/JsonApiEntitlementOutAttributes.md)
 - [JsonApiEntitlementOutDocument](docs/JsonApiEntitlementOutDocument.md)
 - [JsonApiEntitlementOutList](docs/JsonApiEntitlementOutList.md)
 - [JsonApiEntitlementOutWithLinks](docs/JsonApiEntitlementOutWithLinks.md)
 - [JsonApiFactLinkage](docs/JsonApiFactLinkage.md)
 - [JsonApiFactOut](docs/JsonApiFactOut.md)
 - [JsonApiFactOutAttributes](docs/JsonApiFactOutAttributes.md)
 - [JsonApiFactOutDocument](docs/JsonApiFactOutDocument.md)
 - [JsonApiFactOutList](docs/JsonApiFactOutList.md)
 - [JsonApiFactOutRelationships](docs/JsonApiFactOutRelationships.md)
 - [JsonApiFactOutWithLinks](docs/JsonApiFactOutWithLinks.md)
 - [JsonApiFactToManyLinkage](docs/JsonApiFactToManyLinkage.md)
 - [JsonApiFilterContextIn](docs/JsonApiFilterContextIn.md)
 - [JsonApiFilterContextInDocument](docs/JsonApiFilterContextInDocument.md)
 - [JsonApiFilterContextLinkage](docs/JsonApiFilterContextLinkage.md)
 - [JsonApiFilterContextOut](docs/JsonApiFilterContextOut.md)
 - [JsonApiFilterContextOutDocument](docs/JsonApiFilterContextOutDocument.md)
 - [JsonApiFilterContextOutIncludes](docs/JsonApiFilterContextOutIncludes.md)
 - [JsonApiFilterContextOutList](docs/JsonApiFilterContextOutList.md)
 - [JsonApiFilterContextOutRelationships](docs/JsonApiFilterContextOutRelationships.md)
 - [JsonApiFilterContextOutWithLinks](docs/JsonApiFilterContextOutWithLinks.md)
 - [JsonApiFilterContextPatch](docs/JsonApiFilterContextPatch.md)
 - [JsonApiFilterContextPatchDocument](docs/JsonApiFilterContextPatchDocument.md)
 - [JsonApiFilterContextToManyLinkage](docs/JsonApiFilterContextToManyLinkage.md)
 - [JsonApiLabelLinkage](docs/JsonApiLabelLinkage.md)
 - [JsonApiLabelOut](docs/JsonApiLabelOut.md)
 - [JsonApiLabelOutAttributes](docs/JsonApiLabelOutAttributes.md)
 - [JsonApiLabelOutDocument](docs/JsonApiLabelOutDocument.md)
 - [JsonApiLabelOutList](docs/JsonApiLabelOutList.md)
 - [JsonApiLabelOutRelationships](docs/JsonApiLabelOutRelationships.md)
 - [JsonApiLabelOutRelationshipsAttribute](docs/JsonApiLabelOutRelationshipsAttribute.md)
 - [JsonApiLabelOutWithLinks](docs/JsonApiLabelOutWithLinks.md)
 - [JsonApiLabelToManyLinkage](docs/JsonApiLabelToManyLinkage.md)
 - [JsonApiLabelToOneLinkage](docs/JsonApiLabelToOneLinkage.md)
 - [JsonApiMetricIn](docs/JsonApiMetricIn.md)
 - [JsonApiMetricInAttributes](docs/JsonApiMetricInAttributes.md)
 - [JsonApiMetricInAttributesContent](docs/JsonApiMetricInAttributesContent.md)
 - [JsonApiMetricInDocument](docs/JsonApiMetricInDocument.md)
 - [JsonApiMetricLinkage](docs/JsonApiMetricLinkage.md)
 - [JsonApiMetricOut](docs/JsonApiMetricOut.md)
 - [JsonApiMetricOutDocument](docs/JsonApiMetricOutDocument.md)
 - [JsonApiMetricOutIncludes](docs/JsonApiMetricOutIncludes.md)
 - [JsonApiMetricOutList](docs/JsonApiMetricOutList.md)
 - [JsonApiMetricOutRelationships](docs/JsonApiMetricOutRelationships.md)
 - [JsonApiMetricOutWithLinks](docs/JsonApiMetricOutWithLinks.md)
 - [JsonApiMetricPatch](docs/JsonApiMetricPatch.md)
 - [JsonApiMetricPatchAttributes](docs/JsonApiMetricPatchAttributes.md)
 - [JsonApiMetricPatchDocument](docs/JsonApiMetricPatchDocument.md)
 - [JsonApiMetricToManyLinkage](docs/JsonApiMetricToManyLinkage.md)
 - [JsonApiOrganizationIn](docs/JsonApiOrganizationIn.md)
 - [JsonApiOrganizationInAttributes](docs/JsonApiOrganizationInAttributes.md)
 - [JsonApiOrganizationInDocument](docs/JsonApiOrganizationInDocument.md)
 - [JsonApiOrganizationOut](docs/JsonApiOrganizationOut.md)
 - [JsonApiOrganizationOutAttributes](docs/JsonApiOrganizationOutAttributes.md)
 - [JsonApiOrganizationOutDocument](docs/JsonApiOrganizationOutDocument.md)
 - [JsonApiOrganizationOutIncludes](docs/JsonApiOrganizationOutIncludes.md)
 - [JsonApiOrganizationOutMeta](docs/JsonApiOrganizationOutMeta.md)
 - [JsonApiOrganizationOutRelationships](docs/JsonApiOrganizationOutRelationships.md)
 - [JsonApiOrganizationOutRelationshipsBootstrapUser](docs/JsonApiOrganizationOutRelationshipsBootstrapUser.md)
 - [JsonApiOrganizationOutRelationshipsBootstrapUserGroup](docs/JsonApiOrganizationOutRelationshipsBootstrapUserGroup.md)
 - [JsonApiOrganizationPatch](docs/JsonApiOrganizationPatch.md)
 - [JsonApiOrganizationPatchDocument](docs/JsonApiOrganizationPatchDocument.md)
 - [JsonApiOrganizationSettingIn](docs/JsonApiOrganizationSettingIn.md)
 - [JsonApiOrganizationSettingInAttributes](docs/JsonApiOrganizationSettingInAttributes.md)
 - [JsonApiOrganizationSettingInDocument](docs/JsonApiOrganizationSettingInDocument.md)
 - [JsonApiOrganizationSettingOut](docs/JsonApiOrganizationSettingOut.md)
 - [JsonApiOrganizationSettingOutDocument](docs/JsonApiOrganizationSettingOutDocument.md)
 - [JsonApiOrganizationSettingOutList](docs/JsonApiOrganizationSettingOutList.md)
 - [JsonApiOrganizationSettingOutWithLinks](docs/JsonApiOrganizationSettingOutWithLinks.md)
 - [JsonApiOrganizationSettingPatch](docs/JsonApiOrganizationSettingPatch.md)
 - [JsonApiOrganizationSettingPatchDocument](docs/JsonApiOrganizationSettingPatchDocument.md)
 - [JsonApiThemeIn](docs/JsonApiThemeIn.md)
 - [JsonApiThemeInDocument](docs/JsonApiThemeInDocument.md)
 - [JsonApiThemeOut](docs/JsonApiThemeOut.md)
 - [JsonApiThemeOutDocument](docs/JsonApiThemeOutDocument.md)
 - [JsonApiThemeOutList](docs/JsonApiThemeOutList.md)
 - [JsonApiThemeOutWithLinks](docs/JsonApiThemeOutWithLinks.md)
 - [JsonApiThemePatch](docs/JsonApiThemePatch.md)
 - [JsonApiThemePatchDocument](docs/JsonApiThemePatchDocument.md)
 - [JsonApiUserGroupIn](docs/JsonApiUserGroupIn.md)
 - [JsonApiUserGroupInAttributes](docs/JsonApiUserGroupInAttributes.md)
 - [JsonApiUserGroupInDocument](docs/JsonApiUserGroupInDocument.md)
 - [JsonApiUserGroupInRelationships](docs/JsonApiUserGroupInRelationships.md)
 - [JsonApiUserGroupInRelationshipsParents](docs/JsonApiUserGroupInRelationshipsParents.md)
 - [JsonApiUserGroupLinkage](docs/JsonApiUserGroupLinkage.md)
 - [JsonApiUserGroupOut](docs/JsonApiUserGroupOut.md)
 - [JsonApiUserGroupOutDocument](docs/JsonApiUserGroupOutDocument.md)
 - [JsonApiUserGroupOutList](docs/JsonApiUserGroupOutList.md)
 - [JsonApiUserGroupOutWithLinks](docs/JsonApiUserGroupOutWithLinks.md)
 - [JsonApiUserGroupPatch](docs/JsonApiUserGroupPatch.md)
 - [JsonApiUserGroupPatchDocument](docs/JsonApiUserGroupPatchDocument.md)
 - [JsonApiUserGroupToManyLinkage](docs/JsonApiUserGroupToManyLinkage.md)
 - [JsonApiUserGroupToOneLinkage](docs/JsonApiUserGroupToOneLinkage.md)
 - [JsonApiUserIn](docs/JsonApiUserIn.md)
 - [JsonApiUserInAttributes](docs/JsonApiUserInAttributes.md)
 - [JsonApiUserInDocument](docs/JsonApiUserInDocument.md)
 - [JsonApiUserInRelationships](docs/JsonApiUserInRelationships.md)
 - [JsonApiUserLinkage](docs/JsonApiUserLinkage.md)
 - [JsonApiUserOut](docs/JsonApiUserOut.md)
 - [JsonApiUserOutDocument](docs/JsonApiUserOutDocument.md)
 - [JsonApiUserOutList](docs/JsonApiUserOutList.md)
 - [JsonApiUserOutWithLinks](docs/JsonApiUserOutWithLinks.md)
 - [JsonApiUserPatch](docs/JsonApiUserPatch.md)
 - [JsonApiUserPatchDocument](docs/JsonApiUserPatchDocument.md)
 - [JsonApiUserSettingIn](docs/JsonApiUserSettingIn.md)
 - [JsonApiUserSettingInDocument](docs/JsonApiUserSettingInDocument.md)
 - [JsonApiUserSettingOut](docs/JsonApiUserSettingOut.md)
 - [JsonApiUserSettingOutDocument](docs/JsonApiUserSettingOutDocument.md)
 - [JsonApiUserSettingOutList](docs/JsonApiUserSettingOutList.md)
 - [JsonApiUserSettingOutWithLinks](docs/JsonApiUserSettingOutWithLinks.md)
 - [JsonApiUserToOneLinkage](docs/JsonApiUserToOneLinkage.md)
 - [JsonApiVisualizationObjectIn](docs/JsonApiVisualizationObjectIn.md)
 - [JsonApiVisualizationObjectInDocument](docs/JsonApiVisualizationObjectInDocument.md)
 - [JsonApiVisualizationObjectLinkage](docs/JsonApiVisualizationObjectLinkage.md)
 - [JsonApiVisualizationObjectOut](docs/JsonApiVisualizationObjectOut.md)
 - [JsonApiVisualizationObjectOutDocument](docs/JsonApiVisualizationObjectOutDocument.md)
 - [JsonApiVisualizationObjectOutList](docs/JsonApiVisualizationObjectOutList.md)
 - [JsonApiVisualizationObjectOutWithLinks](docs/JsonApiVisualizationObjectOutWithLinks.md)
 - [JsonApiVisualizationObjectPatch](docs/JsonApiVisualizationObjectPatch.md)
 - [JsonApiVisualizationObjectPatchDocument](docs/JsonApiVisualizationObjectPatchDocument.md)
 - [JsonApiVisualizationObjectToManyLinkage](docs/JsonApiVisualizationObjectToManyLinkage.md)
 - [JsonApiWorkspaceDataFilterIn](docs/JsonApiWorkspaceDataFilterIn.md)
 - [JsonApiWorkspaceDataFilterInAttributes](docs/JsonApiWorkspaceDataFilterInAttributes.md)
 - [JsonApiWorkspaceDataFilterInDocument](docs/JsonApiWorkspaceDataFilterInDocument.md)
 - [JsonApiWorkspaceDataFilterInRelationships](docs/JsonApiWorkspaceDataFilterInRelationships.md)
 - [JsonApiWorkspaceDataFilterInRelationshipsFilterSettings](docs/JsonApiWorkspaceDataFilterInRelationshipsFilterSettings.md)
 - [JsonApiWorkspaceDataFilterLinkage](docs/JsonApiWorkspaceDataFilterLinkage.md)
 - [JsonApiWorkspaceDataFilterOut](docs/JsonApiWorkspaceDataFilterOut.md)
 - [JsonApiWorkspaceDataFilterOutDocument](docs/JsonApiWorkspaceDataFilterOutDocument.md)
 - [JsonApiWorkspaceDataFilterOutList](docs/JsonApiWorkspaceDataFilterOutList.md)
 - [JsonApiWorkspaceDataFilterOutWithLinks](docs/JsonApiWorkspaceDataFilterOutWithLinks.md)
 - [JsonApiWorkspaceDataFilterPatch](docs/JsonApiWorkspaceDataFilterPatch.md)
 - [JsonApiWorkspaceDataFilterPatchDocument](docs/JsonApiWorkspaceDataFilterPatchDocument.md)
 - [JsonApiWorkspaceDataFilterSettingLinkage](docs/JsonApiWorkspaceDataFilterSettingLinkage.md)
 - [JsonApiWorkspaceDataFilterSettingOut](docs/JsonApiWorkspaceDataFilterSettingOut.md)
 - [JsonApiWorkspaceDataFilterSettingOutAttributes](docs/JsonApiWorkspaceDataFilterSettingOutAttributes.md)
 - [JsonApiWorkspaceDataFilterSettingOutDocument](docs/JsonApiWorkspaceDataFilterSettingOutDocument.md)
 - [JsonApiWorkspaceDataFilterSettingOutList](docs/JsonApiWorkspaceDataFilterSettingOutList.md)
 - [JsonApiWorkspaceDataFilterSettingOutRelationships](docs/JsonApiWorkspaceDataFilterSettingOutRelationships.md)
 - [JsonApiWorkspaceDataFilterSettingOutRelationshipsWorkspaceDataFilter](docs/JsonApiWorkspaceDataFilterSettingOutRelationshipsWorkspaceDataFilter.md)
 - [JsonApiWorkspaceDataFilterSettingOutWithLinks](docs/JsonApiWorkspaceDataFilterSettingOutWithLinks.md)
 - [JsonApiWorkspaceDataFilterSettingToManyLinkage](docs/JsonApiWorkspaceDataFilterSettingToManyLinkage.md)
 - [JsonApiWorkspaceDataFilterToOneLinkage](docs/JsonApiWorkspaceDataFilterToOneLinkage.md)
 - [JsonApiWorkspaceIn](docs/JsonApiWorkspaceIn.md)
 - [JsonApiWorkspaceInAttributes](docs/JsonApiWorkspaceInAttributes.md)
 - [JsonApiWorkspaceInDocument](docs/JsonApiWorkspaceInDocument.md)
 - [JsonApiWorkspaceInRelationships](docs/JsonApiWorkspaceInRelationships.md)
 - [JsonApiWorkspaceInRelationshipsParent](docs/JsonApiWorkspaceInRelationshipsParent.md)
 - [JsonApiWorkspaceLinkage](docs/JsonApiWorkspaceLinkage.md)
 - [JsonApiWorkspaceOut](docs/JsonApiWorkspaceOut.md)
 - [JsonApiWorkspaceOutDocument](docs/JsonApiWorkspaceOutDocument.md)
 - [JsonApiWorkspaceOutList](docs/JsonApiWorkspaceOutList.md)
 - [JsonApiWorkspaceOutMeta](docs/JsonApiWorkspaceOutMeta.md)
 - [JsonApiWorkspaceOutMetaConfig](docs/JsonApiWorkspaceOutMetaConfig.md)
 - [JsonApiWorkspaceOutWithLinks](docs/JsonApiWorkspaceOutWithLinks.md)
 - [JsonApiWorkspacePatch](docs/JsonApiWorkspacePatch.md)
 - [JsonApiWorkspacePatchDocument](docs/JsonApiWorkspacePatchDocument.md)
 - [JsonApiWorkspaceSettingIn](docs/JsonApiWorkspaceSettingIn.md)
 - [JsonApiWorkspaceSettingInDocument](docs/JsonApiWorkspaceSettingInDocument.md)
 - [JsonApiWorkspaceSettingOut](docs/JsonApiWorkspaceSettingOut.md)
 - [JsonApiWorkspaceSettingOutDocument](docs/JsonApiWorkspaceSettingOutDocument.md)
 - [JsonApiWorkspaceSettingOutList](docs/JsonApiWorkspaceSettingOutList.md)
 - [JsonApiWorkspaceSettingOutWithLinks](docs/JsonApiWorkspaceSettingOutWithLinks.md)
 - [JsonApiWorkspaceSettingPatch](docs/JsonApiWorkspaceSettingPatch.md)
 - [JsonApiWorkspaceSettingPatchDocument](docs/JsonApiWorkspaceSettingPatchDocument.md)
 - [JsonApiWorkspaceToOneLinkage](docs/JsonApiWorkspaceToOneLinkage.md)
 - [LabelIdentifier](docs/LabelIdentifier.md)
 - [ListLinks](docs/ListLinks.md)
 - [ListLinksAllOf](docs/ListLinksAllOf.md)
 - [ObjectLinks](docs/ObjectLinks.md)
 - [ObjectLinksContainer](docs/ObjectLinksContainer.md)
 - [Parameter](docs/Parameter.md)
 - [PdmLdmRequest](docs/PdmLdmRequest.md)
 - [PdmSql](docs/PdmSql.md)
 - [PermissionsForAssignee](docs/PermissionsForAssignee.md)
 - [PlatformUsage](docs/PlatformUsage.md)
 - [PlatformUsageRequest](docs/PlatformUsageRequest.md)
 - [ReferenceIdentifier](docs/ReferenceIdentifier.md)
 - [ResolveSettingsRequest](docs/ResolveSettingsRequest.md)
 - [ResolvedSetting](docs/ResolvedSetting.md)
 - [SqlColumn](docs/SqlColumn.md)
 - [UserAssignee](docs/UserAssignee.md)
 - [UserGroupAssignee](docs/UserGroupAssignee.md)
 - [UserGroupIdentifier](docs/UserGroupIdentifier.md)
 - [UserGroupPermission](docs/UserGroupPermission.md)
 - [UserPermission](docs/UserPermission.md)
 - [WorkspaceIdentifier](docs/WorkspaceIdentifier.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

support@gooddata.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in gooddata_metadata_client.apis and gooddata_metadata_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from gooddata_metadata_client.api.default_api import DefaultApi`
- `from gooddata_metadata_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import gooddata_metadata_client
from gooddata_metadata_client.apis import *
from gooddata_metadata_client.models import *
```

