# coding: utf-8

"""
    Selling Partner API for Sellers

    The Selling Partner API for Sellers lets you retrieve information on behalf of sellers about their seller account, such as the marketplaces they participate in. Along with listing the marketplaces that a seller can sell in, the API also provides additional information about the marketplace such as the default language and the default currency. The API also provides seller-specific information such as whether the seller has suspended listings in that marketplace.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class Marketplace(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'country_code': 'str',
        'default_currency_code': 'str',
        'default_language_code': 'str',
        'domain_name': 'str'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'country_code': 'countryCode',
        'default_currency_code': 'defaultCurrencyCode',
        'default_language_code': 'defaultLanguageCode',
        'domain_name': 'domainName'
    }

    def __init__(self, id=None, name=None, country_code=None, default_currency_code=None, default_language_code=None, domain_name=None):  # noqa: E501
        """Marketplace - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._name = None
        self._country_code = None
        self._default_currency_code = None
        self._default_language_code = None
        self._domain_name = None
        self.discriminator = None
        self.id = id
        self.name = name
        self.country_code = country_code
        self.default_currency_code = default_currency_code
        self.default_language_code = default_language_code
        self.domain_name = domain_name

    @property
    def id(self):
        """Gets the id of this Marketplace.  # noqa: E501

        The encrypted marketplace value.  # noqa: E501

        :return: The id of this Marketplace.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Marketplace.

        The encrypted marketplace value.  # noqa: E501

        :param id: The id of this Marketplace.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this Marketplace.  # noqa: E501

        Marketplace name.  # noqa: E501

        :return: The name of this Marketplace.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Marketplace.

        Marketplace name.  # noqa: E501

        :param name: The name of this Marketplace.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def country_code(self):
        """Gets the country_code of this Marketplace.  # noqa: E501

        The ISO 3166-1 alpha-2 format country code of the marketplace.  # noqa: E501

        :return: The country_code of this Marketplace.  # noqa: E501
        :rtype: str
        """
        return self._country_code

    @country_code.setter
    def country_code(self, country_code):
        """Sets the country_code of this Marketplace.

        The ISO 3166-1 alpha-2 format country code of the marketplace.  # noqa: E501

        :param country_code: The country_code of this Marketplace.  # noqa: E501
        :type: str
        """
        if country_code is None:
            raise ValueError("Invalid value for `country_code`, must not be `None`")  # noqa: E501

        self._country_code = country_code

    @property
    def default_currency_code(self):
        """Gets the default_currency_code of this Marketplace.  # noqa: E501

        The ISO 4217 format currency code of the marketplace.  # noqa: E501

        :return: The default_currency_code of this Marketplace.  # noqa: E501
        :rtype: str
        """
        return self._default_currency_code

    @default_currency_code.setter
    def default_currency_code(self, default_currency_code):
        """Sets the default_currency_code of this Marketplace.

        The ISO 4217 format currency code of the marketplace.  # noqa: E501

        :param default_currency_code: The default_currency_code of this Marketplace.  # noqa: E501
        :type: str
        """
        if default_currency_code is None:
            raise ValueError("Invalid value for `default_currency_code`, must not be `None`")  # noqa: E501

        self._default_currency_code = default_currency_code

    @property
    def default_language_code(self):
        """Gets the default_language_code of this Marketplace.  # noqa: E501

        The ISO 639-1 format language code of the marketplace.  # noqa: E501

        :return: The default_language_code of this Marketplace.  # noqa: E501
        :rtype: str
        """
        return self._default_language_code

    @default_language_code.setter
    def default_language_code(self, default_language_code):
        """Sets the default_language_code of this Marketplace.

        The ISO 639-1 format language code of the marketplace.  # noqa: E501

        :param default_language_code: The default_language_code of this Marketplace.  # noqa: E501
        :type: str
        """
        if default_language_code is None:
            raise ValueError("Invalid value for `default_language_code`, must not be `None`")  # noqa: E501

        self._default_language_code = default_language_code

    @property
    def domain_name(self):
        """Gets the domain_name of this Marketplace.  # noqa: E501

        The domain name of the marketplace.  # noqa: E501

        :return: The domain_name of this Marketplace.  # noqa: E501
        :rtype: str
        """
        return self._domain_name

    @domain_name.setter
    def domain_name(self, domain_name):
        """Sets the domain_name of this Marketplace.

        The domain name of the marketplace.  # noqa: E501

        :param domain_name: The domain_name of this Marketplace.  # noqa: E501
        :type: str
        """
        if domain_name is None:
            raise ValueError("Invalid value for `domain_name`, must not be `None`")  # noqa: E501

        self._domain_name = domain_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Marketplace, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Marketplace):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
