# coding: utf-8

"""
    Selling Partner API for Product Fees

    The Selling Partner API for Product Fees lets you programmatically retrieve estimated fees for a product. You can then account for those fees in your pricing.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class FeesEstimateRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'marketplace_id': 'str',
        'is_amazon_fulfilled': 'bool',
        'price_to_estimate_fees': 'PriceToEstimateFees',
        'identifier': 'str'
    }

    attribute_map = {
        'marketplace_id': 'MarketplaceId',
        'is_amazon_fulfilled': 'IsAmazonFulfilled',
        'price_to_estimate_fees': 'PriceToEstimateFees',
        'identifier': 'Identifier'
    }

    def __init__(self, marketplace_id=None, is_amazon_fulfilled=None, price_to_estimate_fees=None, identifier=None):  # noqa: E501
        """FeesEstimateRequest - a model defined in Swagger"""  # noqa: E501
        self._marketplace_id = None
        self._is_amazon_fulfilled = None
        self._price_to_estimate_fees = None
        self._identifier = None
        self.discriminator = None
        self.marketplace_id = marketplace_id
        if is_amazon_fulfilled is not None:
            self.is_amazon_fulfilled = is_amazon_fulfilled
        self.price_to_estimate_fees = price_to_estimate_fees
        self.identifier = identifier

    @property
    def marketplace_id(self):
        """Gets the marketplace_id of this FeesEstimateRequest.  # noqa: E501

        A marketplace identifier.  # noqa: E501

        :return: The marketplace_id of this FeesEstimateRequest.  # noqa: E501
        :rtype: str
        """
        return self._marketplace_id

    @marketplace_id.setter
    def marketplace_id(self, marketplace_id):
        """Sets the marketplace_id of this FeesEstimateRequest.

        A marketplace identifier.  # noqa: E501

        :param marketplace_id: The marketplace_id of this FeesEstimateRequest.  # noqa: E501
        :type: str
        """
        if marketplace_id is None:
            raise ValueError("Invalid value for `marketplace_id`, must not be `None`")  # noqa: E501

        self._marketplace_id = marketplace_id

    @property
    def is_amazon_fulfilled(self):
        """Gets the is_amazon_fulfilled of this FeesEstimateRequest.  # noqa: E501

        When true, the offer is fulfilled by Amazon.  # noqa: E501

        :return: The is_amazon_fulfilled of this FeesEstimateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._is_amazon_fulfilled

    @is_amazon_fulfilled.setter
    def is_amazon_fulfilled(self, is_amazon_fulfilled):
        """Sets the is_amazon_fulfilled of this FeesEstimateRequest.

        When true, the offer is fulfilled by Amazon.  # noqa: E501

        :param is_amazon_fulfilled: The is_amazon_fulfilled of this FeesEstimateRequest.  # noqa: E501
        :type: bool
        """

        self._is_amazon_fulfilled = is_amazon_fulfilled

    @property
    def price_to_estimate_fees(self):
        """Gets the price_to_estimate_fees of this FeesEstimateRequest.  # noqa: E501


        :return: The price_to_estimate_fees of this FeesEstimateRequest.  # noqa: E501
        :rtype: PriceToEstimateFees
        """
        return self._price_to_estimate_fees

    @price_to_estimate_fees.setter
    def price_to_estimate_fees(self, price_to_estimate_fees):
        """Sets the price_to_estimate_fees of this FeesEstimateRequest.


        :param price_to_estimate_fees: The price_to_estimate_fees of this FeesEstimateRequest.  # noqa: E501
        :type: PriceToEstimateFees
        """
        if price_to_estimate_fees is None:
            raise ValueError("Invalid value for `price_to_estimate_fees`, must not be `None`")  # noqa: E501

        self._price_to_estimate_fees = price_to_estimate_fees

    @property
    def identifier(self):
        """Gets the identifier of this FeesEstimateRequest.  # noqa: E501

        The product price on which the fee estimate is based.  # noqa: E501

        :return: The identifier of this FeesEstimateRequest.  # noqa: E501
        :rtype: str
        """
        return self._identifier

    @identifier.setter
    def identifier(self, identifier):
        """Sets the identifier of this FeesEstimateRequest.

        The product price on which the fee estimate is based.  # noqa: E501

        :param identifier: The identifier of this FeesEstimateRequest.  # noqa: E501
        :type: str
        """
        if identifier is None:
            raise ValueError("Invalid value for `identifier`, must not be `None`")  # noqa: E501

        self._identifier = identifier

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FeesEstimateRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FeesEstimateRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
