# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class SAFETReimbursementEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'posted_date': 'ModelDate',
        'safet_claim_id': 'str',
        'reimbursed_amount': 'Currency',
        'reason_code': 'str',
        'safet_reimbursement_item_list': 'SAFETReimbursementItemList'
    }

    attribute_map = {
        'posted_date': 'PostedDate',
        'safet_claim_id': 'SAFETClaimId',
        'reimbursed_amount': 'ReimbursedAmount',
        'reason_code': 'ReasonCode',
        'safet_reimbursement_item_list': 'SAFETReimbursementItemList'
    }

    def __init__(self, posted_date=None, safet_claim_id=None, reimbursed_amount=None, reason_code=None, safet_reimbursement_item_list=None):  # noqa: E501
        """SAFETReimbursementEvent - a model defined in Swagger"""  # noqa: E501
        self._posted_date = None
        self._safet_claim_id = None
        self._reimbursed_amount = None
        self._reason_code = None
        self._safet_reimbursement_item_list = None
        self.discriminator = None
        if posted_date is not None:
            self.posted_date = posted_date
        if safet_claim_id is not None:
            self.safet_claim_id = safet_claim_id
        if reimbursed_amount is not None:
            self.reimbursed_amount = reimbursed_amount
        if reason_code is not None:
            self.reason_code = reason_code
        if safet_reimbursement_item_list is not None:
            self.safet_reimbursement_item_list = safet_reimbursement_item_list

    @property
    def posted_date(self):
        """Gets the posted_date of this SAFETReimbursementEvent.  # noqa: E501


        :return: The posted_date of this SAFETReimbursementEvent.  # noqa: E501
        :rtype: ModelDate
        """
        return self._posted_date

    @posted_date.setter
    def posted_date(self, posted_date):
        """Sets the posted_date of this SAFETReimbursementEvent.


        :param posted_date: The posted_date of this SAFETReimbursementEvent.  # noqa: E501
        :type: ModelDate
        """

        self._posted_date = posted_date

    @property
    def safet_claim_id(self):
        """Gets the safet_claim_id of this SAFETReimbursementEvent.  # noqa: E501

        A SAFE-T claim identifier.  # noqa: E501

        :return: The safet_claim_id of this SAFETReimbursementEvent.  # noqa: E501
        :rtype: str
        """
        return self._safet_claim_id

    @safet_claim_id.setter
    def safet_claim_id(self, safet_claim_id):
        """Sets the safet_claim_id of this SAFETReimbursementEvent.

        A SAFE-T claim identifier.  # noqa: E501

        :param safet_claim_id: The safet_claim_id of this SAFETReimbursementEvent.  # noqa: E501
        :type: str
        """

        self._safet_claim_id = safet_claim_id

    @property
    def reimbursed_amount(self):
        """Gets the reimbursed_amount of this SAFETReimbursementEvent.  # noqa: E501


        :return: The reimbursed_amount of this SAFETReimbursementEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._reimbursed_amount

    @reimbursed_amount.setter
    def reimbursed_amount(self, reimbursed_amount):
        """Sets the reimbursed_amount of this SAFETReimbursementEvent.


        :param reimbursed_amount: The reimbursed_amount of this SAFETReimbursementEvent.  # noqa: E501
        :type: Currency
        """

        self._reimbursed_amount = reimbursed_amount

    @property
    def reason_code(self):
        """Gets the reason_code of this SAFETReimbursementEvent.  # noqa: E501

        Indicates why the seller was reimbursed.  # noqa: E501

        :return: The reason_code of this SAFETReimbursementEvent.  # noqa: E501
        :rtype: str
        """
        return self._reason_code

    @reason_code.setter
    def reason_code(self, reason_code):
        """Sets the reason_code of this SAFETReimbursementEvent.

        Indicates why the seller was reimbursed.  # noqa: E501

        :param reason_code: The reason_code of this SAFETReimbursementEvent.  # noqa: E501
        :type: str
        """

        self._reason_code = reason_code

    @property
    def safet_reimbursement_item_list(self):
        """Gets the safet_reimbursement_item_list of this SAFETReimbursementEvent.  # noqa: E501


        :return: The safet_reimbursement_item_list of this SAFETReimbursementEvent.  # noqa: E501
        :rtype: SAFETReimbursementItemList
        """
        return self._safet_reimbursement_item_list

    @safet_reimbursement_item_list.setter
    def safet_reimbursement_item_list(self, safet_reimbursement_item_list):
        """Sets the safet_reimbursement_item_list of this SAFETReimbursementEvent.


        :param safet_reimbursement_item_list: The safet_reimbursement_item_list of this SAFETReimbursementEvent.  # noqa: E501
        :type: SAFETReimbursementItemList
        """

        self._safet_reimbursement_item_list = safet_reimbursement_item_list

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SAFETReimbursementEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SAFETReimbursementEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
