"""Repeat the following paper for `CCPSO2`:
    Li, X. and Yao, X., 2012.
    Cooperatively coevolving particle swarms for large scale optimization.
    IEEE Transactions on Evolutionary Computation, 16(2), pp.210-224.
    https://ieeexplore.ieee.org/document/5910380/

    Luckily our code could repeat the data generated by the other Python code *well*.
    Therefore, we argue that the repeatability of `CCPSO2` could be **well-documented**.



    You can run the following Python script (note that first install `pymoo` via `pip install pymoo`):

    from pymoo.algorithms.soo.nonconvex.pso import PSO
    from pymoo.problems.single import Ackley
    from pymoo.optimize import minimize

    problem = Ackley(n_var=1000)
    algorithm = PSO(pop_size=20)
    res = minimize(problem=problem, algorithm=algorithm, termination=('n_eval', 1e6),  verbose=True, seed=1)
    print("Best solution found: \nX = %s\nF = %s" % (res.X, res.F))
"""
import time

import numpy as np

from pypop7.benchmarks.base_functions import ackley
from pypop7.optimizers.pso.ccpso2 import CCPSO2 as Solver

if __name__ == '__main__':
    start_run = time.time()
    ndim_problem = 1000
    for f in [ackley]:
        print('*' * 7 + ' ' + f.__name__ + ' ' + '*' * 7)
        problem = {'fitness_function': f,
                   'ndim_problem': ndim_problem,
                   'lower_boundary': -32.768 * np.ones((ndim_problem,)),
                   'upper_boundary': 32.768 * np.ones((ndim_problem,))}
        options = {'max_function_evaluations': 1e6,
                   'verbose': 1e1}
        solver = Solver(problem, options)
        results = solver.optimize()
        print(results)      # 0.6790650459040042 vs 3.55110307 (from pymoo)
        print('*** Runtime: {:7.5e}'.format(time.time() - start_run))
