"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cluster = exports.ClusterProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const provider_aws_1 = require("@cdktf/provider-aws");
const cdktf_1 = require("cdktf");
const constructs_1 = require("constructs");
const _1 = require(".");
const awsEcs = require("./imports/modules/terraform-aws-modules/ecs/aws");
const awsVpc = require("./imports/modules/terraform-aws-modules/vpc/aws");
/**
 * @stability stable
 */
class ClusterProps {
}
exports.ClusterProps = ClusterProps;
_a = JSII_RTTI_SYMBOL_1;
ClusterProps[_a] = { fqn: "@pahud/cdktf-aws-ecs.ClusterProps", version: "0.1.40" };
/**
 * @stability stable
 */
class Cluster extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _c, _d;
        super(scope, id);
        this.props = props;
        this.region = (_c = props.region) !== null && _c !== void 0 ? _c : 'us-east-1';
        new provider_aws_1.AwsProvider(this, 'aws', { region: this.region });
        this.clusterName = (_d = props.name) !== null && _d !== void 0 ? _d : `${id}-cluster`;
        // no private subnets given
        if (!props.vpcSubnets) {
            const vpc = this._createVpc();
            this.vpc = vpc;
            this.vpcId = cdktf_1.Token.asString(vpc.vpcIdOutput);
            this.vpcSubnets = cdktf_1.Token.asList(vpc.privateSubnetsOutput);
        }
        else {
            this.vpcSubnets = props.vpcSubnets;
        }
        // cluster
        new awsEcs.TerraformAwsModulesEcsAws(this, 'Cluster', {
            name: this.clusterName,
        });
    }
    _createContainerServiceforEC2Role(id) {
        const role = new provider_aws_1.IamRole(this, `${id}-ecs-instance-role`, {
            name: `${id}-ecs-instance-role`,
            // name: 'ecs-instance-role',
            assumeRolePolicy: JSON.stringify({
                Version: '2012-10-17',
                Statement: [
                    {
                        Action: 'sts:AssumeRole',
                        Effect: 'Allow',
                        Sid: '',
                        Principal: {
                            Service: 'ec2.amazonaws.com',
                        },
                    },
                ],
            }),
        });
        new provider_aws_1.IamPolicyAttachment(this, `${id}AmazonEC2ContainerServiceforEC2RoleAttachment`, {
            name: 'AmazonEC2ContainerServiceforEC2RoleAttachment',
            policyArn: 'arn:aws:iam::aws:policy/service-role/AmazonEC2ContainerServiceforEC2Role',
            roles: [role.name],
        });
        new provider_aws_1.IamPolicyAttachment(this, `${id}AmazonSSMManagedInstanceCoreAttachment`, {
            name: 'AmazonSSMManagedInstanceCoreAttachment',
            policyArn: 'arn:aws:iam::aws:policy/AmazonSSMManagedInstanceCore',
            roles: [role.name],
        });
        return role;
    }
    _createIamInstanceProfile(id, roleName) {
        return new provider_aws_1.IamInstanceProfile(this, `${id}InstanceProfile`, {
            role: roleName,
        });
    }
    _createVpc() {
        const vpc = new awsVpc.TerraformAwsModulesVpcAws(this, 'Vpc', {
            cidr: '10.0.0.0/16',
            azs: new provider_aws_1.DataAwsAvailabilityZones(this, 'AZs', {
                state: 'available',
            }).names,
            publicSubnets: ['10.0.1.0/24', '10.0.2.0/24', '10.0.3.0/24'],
            privateSubnets: ['10.0.11.0/24', '10.0.12.0/24', '10.0.13.0/24'],
            singleNatGateway: true,
            enableNatGateway: true,
            oneNatGatewayPerAz: false,
        });
        return vpc;
    }
    _createLaunchTemplate(id, instanceProfileArn, image) {
        var _c, _d;
        return new provider_aws_1.LaunchTemplate(this, `${id}LT`, {
            imageId: (_c = image === null || image === void 0 ? void 0 : image.amiId) !== null && _c !== void 0 ? _c : new _1.EcsOptimizedAmi(this, {
                generation: _1.AmazonLinuxGeneration.AMAZON_LINUX_2,
            }).amiId,
            iamInstanceProfile: [{ arn: instanceProfileArn }],
            instanceType: (_d = this.props.instanceType) !== null && _d !== void 0 ? _d : 't3.large',
        });
    }
    /**
     * @stability stable
     */
    addAsgCapacity(id, options) {
        var _c, _d, _e;
        const instanceRole = this._createContainerServiceforEC2Role(id);
        const instanceProfile = this._createIamInstanceProfile(id, instanceRole.name);
        const lt = this._createLaunchTemplate(id, instanceProfile.arn, options.machineImage);
        // default userData
        let userData = `#!/bin/bash\necho ECS_CLUSTER=${this.clusterName} > /etc/ecs/ecs.config`;
        // if bottlerocket image
        if (options.machineImage && isBottleRocketImage(options.machineImage)) {
            userData = `[settings.ecs]\ncluster = "${this.clusterName}"`;
        }
        let b64userdata = Buffer.from(userData).toString('base64');
        lt.addOverride('user_data', b64userdata);
        const minCapacity = (_c = options.minCapacity) !== null && _c !== void 0 ? _c : 0;
        const desiredCapacity = (_d = options.desiredCapacity) !== null && _d !== void 0 ? _d : minCapacity;
        const maxCapacity = ((_e = options.maxCapacity) !== null && _e !== void 0 ? _e : (desiredCapacity > 0)) ?
            desiredCapacity : 1;
        const asg = new provider_aws_1.AutoscalingGroup(this, `${id}-ASG`, {
            maxSize: maxCapacity,
            desiredCapacity: desiredCapacity,
            minSize: minCapacity,
            vpcZoneIdentifier: this.vpcSubnets,
            launchTemplate: [
                {
                    id: lt.id,
                    version: '$Latest',
                },
            ],
        });
        new provider_aws_1.EcsCapacityProvider(this, `${id}EcsCapacityProvider`, {
            name: `cp-${id}`,
            autoScalingGroupProvider: [
                {
                    autoScalingGroupArn: asg.arn,
                },
            ],
        });
    }
}
exports.Cluster = Cluster;
_b = JSII_RTTI_SYMBOL_1;
Cluster[_b] = { fqn: "@pahud/cdktf-aws-ecs.Cluster", version: "0.1.40" };
function isBottleRocketImage(image) {
    return image instanceof _1.BottleRocketImage;
}
//# sourceMappingURL=data:application/json;base64,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