import os

BY_DEFAULT_REQUEST_TIMEOUT = 60 * 5  # 5 minutes
BY_DEFAULT_RESPONSE_RESULT_TIMEOUT = 60 * 60  # 1 hour

DATA_FILE_TESTING = "test.md"
DATA_FILE_TRANING = "train.md"
NLG_DATA_SET_FILE = "responses.md"
OUTCOME_FILES = "results.json"
NO_OF_TRAINING_STORY_FILE = "num_stories.json"
PERCENTAGE_WISE_KEY = "__percentage__"

PACKAGING_NAME = "convo"
NLU_MODEL_AFFIX_NAME = "nlu_"
CHECKS_FOR_MODEL_NAME = "convo_model_checkpoint"

BY_DEFAULT_X_PORT = 5002
BY_DEFAULT_PORT = 5005

# Key in global config file which contains whether the user agreed to telemetry
# reporting. These are reused in Convo X. Keep this in mind when changing their names.
CONFIGURATION_FILE_TELEMETRY_KEYS = "metrics"
CONFIGURATION_TELEMETRY_ID = "convo_user_id"
CONFIGURATION_TELEMETRY_ALLOWED = "enabled"
CONFIGURATION_TELEMETRY_DATE = "date"

MIN_COMPATIBLE_VER = "2.0.0"

SUPER_USER_CONFIGURATION_PATH = os.path.expanduser("~/.config/convo/global.yml")

BY_DEFAULT_LOGING_LEVEL_X = "WARNING"
BY_DEFAULT_LOGING_LEVEL_LIBRARY = "ERROR"
ENVIRONMENT_LOGING_LEVEL_LIBRARY = "LOG_LEVEL_LIBRARIES"

BY_DEFAULT_SANIC_WORKERS = 1
ENV_SANIC_WORKERS = "SANIC_WORKERS"
ENVIRONMENT_SANIC_BACKLOG = "SANIC_BACKLOG"

ENVIRONMENT_GPU_CONFIGURATION = "TF_GPU_MEMORY_ALLOC"
ENVIRONMENT_CPU_INTER_OP_CONFIGURATION = "TF_INTER_OP_PARALLELISM_THREADS"
ENV_CPU_INTRA_OP_CONFIG = "TF_INTRA_OP_PARALLELISM_THREADS"
