from secml_malware.attack.whitebox import CFormatExploitEvasion
from secml_malware.models import CClassifierEnd2EndMalware


class CContentShiftingEvasion(CFormatExploitEvasion):
	def __init__(self,
			end2end_model : CClassifierEnd2EndMalware,
			preferable_extension_amount=0x200,
			iterations : int =100,
			is_debug: bool = False,
			random_init: bool = False,
			threshold: float = 0.5,
			penalty_regularizer: float = 0,
			chunk_hyper_parameter : int = None,
	):
		super(CContentShiftingEvasion, self).__init__(
			end2end_model=end2end_model,
			pe_header_extension=0,
			preferable_extension_amount=preferable_extension_amount,
			iterations=iterations,
			is_debug=is_debug,
			random_init=random_init,
			threshold=threshold,
			penalty_regularizer=penalty_regularizer,
			chunk_hyper_parameter=chunk_hyper_parameter
		)