from secml_malware.attack.whitebox import CFormatExploitEvasion
from secml_malware.models import CClassifierEnd2EndMalware
from secml_malware.utils.extend_pe import create_int_list_from_x_adv, shift_pe_header_by


class CExtendDOSEvasion(CFormatExploitEvasion):
	def __init__(self,
			end2end_model : CClassifierEnd2EndMalware,
			pe_header_extension : int = 0x200,
			iterations : int =100,
			is_debug: bool = False,
			random_init: bool = False,
			threshold: float = 0.5,
			penalty_regularizer: float = 0,
			chunk_hyper_parameter : int = None,
	):
		super(CExtendDOSEvasion, self).__init__(
			end2end_model=end2end_model,
			pe_header_extension=pe_header_extension,
			preferable_extension_amount=0,
			iterations=iterations,
			is_debug=is_debug,
			random_init=random_init,
			threshold=threshold,
			penalty_regularizer=penalty_regularizer,
			chunk_hyper_parameter=chunk_hyper_parameter
		)
		self.max_header_size = 0x1000

	def _generate_list_adv_example(self, x0):
		x_init = create_int_list_from_x_adv(x0, self.classifier.get_embedding_value(), self.classifier.get_is_shifting_values())
		x_init, index_to_perturb_pe = shift_pe_header_by(x_init, preferable_extension_amount=self.pe_header_extension)
		return x_init, index_to_perturb_pe

