# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/clickhouseConnection.json
#   timestamp: 2022-05-12T14:28:56+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class ClickhouseType(Enum):
    Clickhouse = 'Clickhouse'


class ClickhouseScheme(Enum):
    clickhouse_http = 'clickhouse+http'


class ClickhouseConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[ClickhouseType] = Field(
        ClickhouseType.Clickhouse, description='Service Type', title='Service Type'
    )
    scheme: Optional[ClickhouseScheme] = Field(
        ClickhouseScheme.clickhouse_http,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: str = Field(
        ...,
        description='Username to connect to Clickhouse. This user should have privileges to read all the metadata in Clickhouse.',
        title='Username',
    )
    password: Optional[SecretStr] = Field(
        None, description='Password to connect to Clickhouse.', title='Password'
    )
    hostPort: str = Field(
        ...,
        description='Host and port of the Clickhouse service.',
        title='Host and Port',
    )
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank, OpenMetadata Ingestion attempts to scan all the databases.',
        title='Database',
    )
    duration: Optional[int] = Field(
        None, description='Clickhouse SQL connection duration.', title='Duration'
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsUsageExtraction: Optional[
        connectionBasicType.SupportsUsageExtraction
    ] = None
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
