# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/bigQueryConnection.json
#   timestamp: 2022-05-12T14:28:56+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from .....security.credentials import gcsCredentials
from .. import connectionBasicType


class BigqueryType(Enum):
    BigQuery = 'BigQuery'


class BigqueryScheme(Enum):
    bigquery = 'bigquery'


class BigQueryConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[BigqueryType] = Field(
        BigqueryType.BigQuery, description='Service Type', title='Service Type'
    )
    scheme: Optional[BigqueryScheme] = Field(
        BigqueryScheme.bigquery,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    hostPort: Optional[str] = Field(
        'bigquery.googleapis.com',
        description='BigQuery APIs URL.',
        title='Host and Port',
    )
    username: Optional[str] = Field(
        None,
        description='Username to connect to Bigquery. This user should have privileges to read all the metadata in Bigquery.',
        title='Username',
    )
    projectId: Optional[str] = Field(
        None,
        description='BigQuery project ID. Only required if using credentials path instead of values.',
        title='Project ID',
    )
    credentials: gcsCredentials.GCSCredentials = Field(
        ..., description='GCS Credentials', title='GCS Credentials'
    )
    enablePolicyTagImport: Optional[bool] = Field(
        True,
        description='Enable importing policy tags of BigQuery into OpenMetadata',
        title='Enable Policy Tag Import',
    )
    tagCategoryName: Optional[str] = Field(
        'BigqueryPolicyTags',
        description='OpenMetadata Tag category name if enablePolicyTagImport is set to true.',
        title='Tag Category Name',
    )
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank, OpenMetadata Ingestion attempts to scan all the databases.',
        title='Database',
    )
    partitionQueryDuration: Optional[int] = Field(
        1,
        description='Duration for partitioning BigQuery tables.',
        title='Partition Query Duration',
    )
    partitionQuery: Optional[str] = Field(
        'select * from {}.{} WHERE {} = "{}" LIMIT 1000',
        description='Partitioning query for BigQuery tables.',
        title='Partition Query',
    )
    partitionField: Optional[str] = Field(
        '_PARTITIONTIME',
        description='Column name on which the BigQuery table will be partitioned.',
        title='Partition Field',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsUsageExtraction: Optional[
        connectionBasicType.SupportsUsageExtraction
    ] = None
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
