"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const subs = require("@aws-cdk/aws-sns-subscriptions");
/**
 * Use an Amazon SNS topic as an event source for AWS Lambda.
 */
class SnsEventSource {
    constructor(topic) {
        this.topic = topic;
    }
    bind(target) {
        this.topic.addSubscription(new subs.LambdaSubscription(target));
    }
}
exports.SnsEventSource = SnsEventSource;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBRUEsdURBQXVEO0FBRXZEOztHQUVHO0FBQ0gsTUFBYSxjQUFjO0lBQ3pCLFlBQXFCLEtBQWlCO1FBQWpCLFVBQUssR0FBTCxLQUFLLENBQVk7SUFDdEMsQ0FBQztJQUVNLElBQUksQ0FBQyxNQUF3QjtRQUNsQyxJQUFJLENBQUMsS0FBSyxDQUFDLGVBQWUsQ0FBQyxJQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQ2xFLENBQUM7Q0FDRjtBQVBELHdDQU9DIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0ICogYXMgc25zIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMnO1xuaW1wb3J0ICogYXMgc3VicyBmcm9tICdAYXdzLWNkay9hd3Mtc25zLXN1YnNjcmlwdGlvbnMnO1xuXG4vKipcbiAqIFVzZSBhbiBBbWF6b24gU05TIHRvcGljIGFzIGFuIGV2ZW50IHNvdXJjZSBmb3IgQVdTIExhbWJkYS5cbiAqL1xuZXhwb3J0IGNsYXNzIFNuc0V2ZW50U291cmNlIGltcGxlbWVudHMgbGFtYmRhLklFdmVudFNvdXJjZSB7XG4gIGNvbnN0cnVjdG9yKHJlYWRvbmx5IHRvcGljOiBzbnMuSVRvcGljKSB7XG4gIH1cblxuICBwdWJsaWMgYmluZCh0YXJnZXQ6IGxhbWJkYS5JRnVuY3Rpb24pIHtcbiAgICB0aGlzLnRvcGljLmFkZFN1YnNjcmlwdGlvbihuZXcgc3Vicy5MYW1iZGFTdWJzY3JpcHRpb24odGFyZ2V0KSk7XG4gIH1cbn1cbiJdfQ==