
# Welcome to skbase

> A base class for scikit-learn-like and sktime-like parametric objects

`skbase` provides base classes for creating scikit-learn-like parametric objects,
along with tools to make it easier to build your own packages that follow these
design patterns.

| Overview | |
|---|---|
| **CI/CD** | [![Tests](https://github.com/sktime/baseobject/actions/workflows/test.yml/badge.svg?branch=main)](https://github.com/sktime/baseobject/actions/workflows/test.yml) [![codecov](https://codecov.io/gh/sktime/baseobject/branch/main/graph/badge.svg?token=2J424NLO82)](https://codecov.io/gh/sktime/baseobject) [![Documentation Status](https://readthedocs.org/projects/baseobject/badge/?version=latest)](https://baseobject.readthedocs.io/en/latest/?badge=latest) [![pre-commit.ci status](https://results.pre-commit.ci/badge/github/sktime/BaseObject/main.svg)](https://results.pre-commit.ci/latest/github/sktime/BaseObject/main) |
| **Code** |  [![!pypi](https://img.shields.io/pypi/v/skbase?color=orange)](https://pypi.org/project/skbase/)  [![!python-versions](https://img.shields.io/pypi/pyversions/skbase)](https://www.python.org/) [![!black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black) [![security: bandit](https://img.shields.io/badge/security-bandit-yellow.svg)](https://github.com/PyCQA/bandit) |
| **Downloads**| [![Downloads](https://static.pepy.tech/personalized-badge/skbase?period=week&units=international_system&left_color=grey&right_color=blue&left_text=weekly%20(pypi))](https://pepy.tech/project/skbase) [![Downloads](https://static.pepy.tech/personalized-badge/skbase?period=month&units=international_system&left_color=grey&right_color=blue&left_text=monthly%20(pypi))](https://pepy.tech/project/skbase) [![Downloads](https://static.pepy.tech/personalized-badge/skbase?period=total&units=international_system&left_color=grey&right_color=blue&left_text=cumulative%20(pypi))](https://pepy.tech/project/skbase) |

<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
[![All Contributors](https://img.shields.io/badge/all_contributors-13-orange.svg?style=flat-square)](#contributors)
<!-- ALL-CONTRIBUTORS-BADGE:END -->

## Documentation

To learn more about the package checkout our [documentation](https://baseobject.readthedocs.io/en/latest/).

## :hourglass_flowing_sand: Install skbase
For trouble shooting or more information, see our
[detailed installation instructions](https://baseobject.readthedocs.io/en/latest/user_documentation/installation.html).

- **Operating system**: macOS X · Linux · Windows 8.1 or higher
- **Python version**: Python 3.7, 3.8, 3.9, and 3.10
- **Package managers**: [pip]

[pip]: https://pip.pypa.io/en/stable/

### pip
skbase releases are available as source packages and binary wheels via PyPI
and can be installed using pip. Checkout the full list of pre-compiled [wheels on PyPi](https://pypi.org/simple/skbase/).

To install the core package use:

```bash
pip install skbase
```

or, if you want to install with the maximum set of dependencies, use:

```bash
pip install skbase[all_extras]
```
