# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class TrialShipmentEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'amazon_order_id': 'str',
        'financial_event_group_id': 'str',
        'posted_date': 'ModelDate',
        'sku': 'str',
        'fee_list': 'FeeComponentList'
    }

    attribute_map = {
        'amazon_order_id': 'AmazonOrderId',
        'financial_event_group_id': 'FinancialEventGroupId',
        'posted_date': 'PostedDate',
        'sku': 'SKU',
        'fee_list': 'FeeList'
    }

    def __init__(self, amazon_order_id=None, financial_event_group_id=None, posted_date=None, sku=None, fee_list=None):  # noqa: E501
        """TrialShipmentEvent - a model defined in Swagger"""  # noqa: E501
        self._amazon_order_id = None
        self._financial_event_group_id = None
        self._posted_date = None
        self._sku = None
        self._fee_list = None
        self.discriminator = None
        if amazon_order_id is not None:
            self.amazon_order_id = amazon_order_id
        if financial_event_group_id is not None:
            self.financial_event_group_id = financial_event_group_id
        if posted_date is not None:
            self.posted_date = posted_date
        if sku is not None:
            self.sku = sku
        if fee_list is not None:
            self.fee_list = fee_list

    @property
    def amazon_order_id(self):
        """Gets the amazon_order_id of this TrialShipmentEvent.  # noqa: E501

        An Amazon-defined identifier for an order.  # noqa: E501

        :return: The amazon_order_id of this TrialShipmentEvent.  # noqa: E501
        :rtype: str
        """
        return self._amazon_order_id

    @amazon_order_id.setter
    def amazon_order_id(self, amazon_order_id):
        """Sets the amazon_order_id of this TrialShipmentEvent.

        An Amazon-defined identifier for an order.  # noqa: E501

        :param amazon_order_id: The amazon_order_id of this TrialShipmentEvent.  # noqa: E501
        :type: str
        """

        self._amazon_order_id = amazon_order_id

    @property
    def financial_event_group_id(self):
        """Gets the financial_event_group_id of this TrialShipmentEvent.  # noqa: E501

        The identifier of the financial event group.  # noqa: E501

        :return: The financial_event_group_id of this TrialShipmentEvent.  # noqa: E501
        :rtype: str
        """
        return self._financial_event_group_id

    @financial_event_group_id.setter
    def financial_event_group_id(self, financial_event_group_id):
        """Sets the financial_event_group_id of this TrialShipmentEvent.

        The identifier of the financial event group.  # noqa: E501

        :param financial_event_group_id: The financial_event_group_id of this TrialShipmentEvent.  # noqa: E501
        :type: str
        """

        self._financial_event_group_id = financial_event_group_id

    @property
    def posted_date(self):
        """Gets the posted_date of this TrialShipmentEvent.  # noqa: E501


        :return: The posted_date of this TrialShipmentEvent.  # noqa: E501
        :rtype: ModelDate
        """
        return self._posted_date

    @posted_date.setter
    def posted_date(self, posted_date):
        """Sets the posted_date of this TrialShipmentEvent.


        :param posted_date: The posted_date of this TrialShipmentEvent.  # noqa: E501
        :type: ModelDate
        """

        self._posted_date = posted_date

    @property
    def sku(self):
        """Gets the sku of this TrialShipmentEvent.  # noqa: E501

        The seller SKU of the item. The seller SKU is qualified by the seller's seller ID, which is included with every call to the Selling Partner API.  # noqa: E501

        :return: The sku of this TrialShipmentEvent.  # noqa: E501
        :rtype: str
        """
        return self._sku

    @sku.setter
    def sku(self, sku):
        """Sets the sku of this TrialShipmentEvent.

        The seller SKU of the item. The seller SKU is qualified by the seller's seller ID, which is included with every call to the Selling Partner API.  # noqa: E501

        :param sku: The sku of this TrialShipmentEvent.  # noqa: E501
        :type: str
        """

        self._sku = sku

    @property
    def fee_list(self):
        """Gets the fee_list of this TrialShipmentEvent.  # noqa: E501


        :return: The fee_list of this TrialShipmentEvent.  # noqa: E501
        :rtype: FeeComponentList
        """
        return self._fee_list

    @fee_list.setter
    def fee_list(self, fee_list):
        """Sets the fee_list of this TrialShipmentEvent.


        :param fee_list: The fee_list of this TrialShipmentEvent.  # noqa: E501
        :type: FeeComponentList
        """

        self._fee_list = fee_list

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TrialShipmentEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TrialShipmentEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
