from setuptools import setup
setup(name='mapshader',
      use_scm_version={
          "write_to": "mapshader/_version.py",
          "write_to_template": '__version__ = "{version}"',
          "tag_regex": r"^(?P<prefix>v)?(?P<version>[^\+]+)(?P<suffix>.*)?$",
      },
      description='Simple Python GIS Web Services',
      url='https://github.com/makepath/mapshader',
      packages=['mapshader',
                'mapshader.tests'],
      install_requires=['xarray-spatial',
                        'datashader',
                        'geopandas',
                        'click',
                        'jinja2',
                        'spatialpandas',
                        'pytest',
                        'tbb',
                        'rtree',
                        'rioxarray',
                        'matplotlib',
                        'descartes',
                        'flask',
                        'flask-cors>=3.0.10',
                        'rasterio',
                        'jupyter',
                        'pyarrow'],
      zip_safe=False,
      classifiers=["Programming Language :: Python :: 3",
                   "License :: OSI Approved :: MIT License",
                   "Operating System :: OS Independent"],
      include_package_data=True)
