# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
pyFltk, the Python bindings to the FLTK GUI toolkit.
This is an easy to use and light-weight GUI toolkit
offering basic capabilities for the creation of
graphical user interfaces.
"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_fltk')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_fltk')
    _fltk = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_fltk', [dirname(__file__)])
        except ImportError:
            import _fltk
            return _fltk
        try:
            _mod = imp.load_module('_fltk', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _fltk = swig_import_helper()
    del swig_import_helper
else:
    import _fltk
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        object.__setattr__(self, name, value)
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_method(set):
    def set_attr(self, name, value):
        if (name == "thisown"):
            return self.this.own(value)
        if hasattr(self, name) or (name == "this"):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x



import sys
if sys.version < '3':
  print("Python3 required!")
  exit(1)

FL_MAJOR_VERSION = _fltk.FL_MAJOR_VERSION
FL_MINOR_VERSION = _fltk.FL_MINOR_VERSION
FL_PATCH_VERSION = _fltk.FL_PATCH_VERSION
FL_API_VERSION = _fltk.FL_API_VERSION
FL_ABI_VERSION = _fltk.FL_ABI_VERSION
FLTK_ABI_VERSION = _fltk.FLTK_ABI_VERSION
FL_NO_EVENT = _fltk.FL_NO_EVENT
FL_PUSH = _fltk.FL_PUSH
FL_RELEASE = _fltk.FL_RELEASE
FL_ENTER = _fltk.FL_ENTER
FL_LEAVE = _fltk.FL_LEAVE
FL_DRAG = _fltk.FL_DRAG
FL_FOCUS = _fltk.FL_FOCUS
FL_UNFOCUS = _fltk.FL_UNFOCUS
FL_KEYDOWN = _fltk.FL_KEYDOWN
FL_KEYBOARD = _fltk.FL_KEYBOARD
FL_KEYUP = _fltk.FL_KEYUP
FL_CLOSE = _fltk.FL_CLOSE
FL_MOVE = _fltk.FL_MOVE
FL_SHORTCUT = _fltk.FL_SHORTCUT
FL_DEACTIVATE = _fltk.FL_DEACTIVATE
FL_ACTIVATE = _fltk.FL_ACTIVATE
FL_HIDE = _fltk.FL_HIDE
FL_SHOW = _fltk.FL_SHOW
FL_PASTE = _fltk.FL_PASTE
FL_SELECTIONCLEAR = _fltk.FL_SELECTIONCLEAR
FL_MOUSEWHEEL = _fltk.FL_MOUSEWHEEL
FL_DND_ENTER = _fltk.FL_DND_ENTER
FL_DND_DRAG = _fltk.FL_DND_DRAG
FL_DND_LEAVE = _fltk.FL_DND_LEAVE
FL_DND_RELEASE = _fltk.FL_DND_RELEASE
FL_SCREEN_CONFIGURATION_CHANGED = _fltk.FL_SCREEN_CONFIGURATION_CHANGED
FL_FULLSCREEN = _fltk.FL_FULLSCREEN
FL_ZOOM_GESTURE = _fltk.FL_ZOOM_GESTURE
FL_WHEN_NEVER = _fltk.FL_WHEN_NEVER
FL_WHEN_CHANGED = _fltk.FL_WHEN_CHANGED
FL_WHEN_NOT_CHANGED = _fltk.FL_WHEN_NOT_CHANGED
FL_WHEN_RELEASE = _fltk.FL_WHEN_RELEASE
FL_WHEN_RELEASE_ALWAYS = _fltk.FL_WHEN_RELEASE_ALWAYS
FL_WHEN_ENTER_KEY = _fltk.FL_WHEN_ENTER_KEY
FL_WHEN_ENTER_KEY_ALWAYS = _fltk.FL_WHEN_ENTER_KEY_ALWAYS
FL_WHEN_ENTER_KEY_CHANGED = _fltk.FL_WHEN_ENTER_KEY_CHANGED
FL_Button = _fltk.FL_Button
FL_BackSpace = _fltk.FL_BackSpace
FL_Tab = _fltk.FL_Tab
FL_Iso_Key = _fltk.FL_Iso_Key
FL_Enter = _fltk.FL_Enter
FL_Pause = _fltk.FL_Pause
FL_Scroll_Lock = _fltk.FL_Scroll_Lock
FL_Escape = _fltk.FL_Escape
FL_Kana = _fltk.FL_Kana
FL_Eisu = _fltk.FL_Eisu
FL_Yen = _fltk.FL_Yen
FL_JIS_Underscore = _fltk.FL_JIS_Underscore
FL_Home = _fltk.FL_Home
FL_Left = _fltk.FL_Left
FL_Up = _fltk.FL_Up
FL_Right = _fltk.FL_Right
FL_Down = _fltk.FL_Down
FL_Page_Up = _fltk.FL_Page_Up
FL_Page_Down = _fltk.FL_Page_Down
FL_End = _fltk.FL_End
FL_Print = _fltk.FL_Print
FL_Insert = _fltk.FL_Insert
FL_Menu = _fltk.FL_Menu
FL_Help = _fltk.FL_Help
FL_Num_Lock = _fltk.FL_Num_Lock
FL_KP = _fltk.FL_KP
FL_KP_Enter = _fltk.FL_KP_Enter
FL_KP_Last = _fltk.FL_KP_Last
FL_F = _fltk.FL_F
FL_F_Last = _fltk.FL_F_Last
FL_Shift_L = _fltk.FL_Shift_L
FL_Shift_R = _fltk.FL_Shift_R
FL_Control_L = _fltk.FL_Control_L
FL_Control_R = _fltk.FL_Control_R
FL_Caps_Lock = _fltk.FL_Caps_Lock
FL_Meta_L = _fltk.FL_Meta_L
FL_Meta_R = _fltk.FL_Meta_R
FL_Alt_L = _fltk.FL_Alt_L
FL_Alt_R = _fltk.FL_Alt_R
FL_Delete = _fltk.FL_Delete
FL_Volume_Down = _fltk.FL_Volume_Down
FL_Volume_Mute = _fltk.FL_Volume_Mute
FL_Volume_Up = _fltk.FL_Volume_Up
FL_Media_Play = _fltk.FL_Media_Play
FL_Media_Stop = _fltk.FL_Media_Stop
FL_Media_Prev = _fltk.FL_Media_Prev
FL_Media_Next = _fltk.FL_Media_Next
FL_Home_Page = _fltk.FL_Home_Page
FL_Mail = _fltk.FL_Mail
FL_Search = _fltk.FL_Search
FL_Back = _fltk.FL_Back
FL_Forward = _fltk.FL_Forward
FL_Stop = _fltk.FL_Stop
FL_Refresh = _fltk.FL_Refresh
FL_Sleep = _fltk.FL_Sleep
FL_Favorites = _fltk.FL_Favorites
FL_LEFT_MOUSE = _fltk.FL_LEFT_MOUSE
FL_MIDDLE_MOUSE = _fltk.FL_MIDDLE_MOUSE
FL_RIGHT_MOUSE = _fltk.FL_RIGHT_MOUSE
FL_SHIFT = _fltk.FL_SHIFT
FL_CAPS_LOCK = _fltk.FL_CAPS_LOCK
FL_CTRL = _fltk.FL_CTRL
FL_ALT = _fltk.FL_ALT
FL_NUM_LOCK = _fltk.FL_NUM_LOCK
FL_META = _fltk.FL_META
FL_SCROLL_LOCK = _fltk.FL_SCROLL_LOCK
FL_BUTTON1 = _fltk.FL_BUTTON1
FL_BUTTON2 = _fltk.FL_BUTTON2
FL_BUTTON3 = _fltk.FL_BUTTON3
FL_BUTTONS = _fltk.FL_BUTTONS
FL_KEY_MASK = _fltk.FL_KEY_MASK
FL_COMMAND = _fltk.FL_COMMAND
FL_CONTROL = _fltk.FL_CONTROL
FL_NO_BOX = _fltk.FL_NO_BOX
FL_FLAT_BOX = _fltk.FL_FLAT_BOX
FL_UP_BOX = _fltk.FL_UP_BOX
FL_DOWN_BOX = _fltk.FL_DOWN_BOX
FL_UP_FRAME = _fltk.FL_UP_FRAME
FL_DOWN_FRAME = _fltk.FL_DOWN_FRAME
FL_THIN_UP_BOX = _fltk.FL_THIN_UP_BOX
FL_THIN_DOWN_BOX = _fltk.FL_THIN_DOWN_BOX
FL_THIN_UP_FRAME = _fltk.FL_THIN_UP_FRAME
FL_THIN_DOWN_FRAME = _fltk.FL_THIN_DOWN_FRAME
FL_ENGRAVED_BOX = _fltk.FL_ENGRAVED_BOX
FL_EMBOSSED_BOX = _fltk.FL_EMBOSSED_BOX
FL_ENGRAVED_FRAME = _fltk.FL_ENGRAVED_FRAME
FL_EMBOSSED_FRAME = _fltk.FL_EMBOSSED_FRAME
FL_BORDER_BOX = _fltk.FL_BORDER_BOX
_FL_SHADOW_BOX = _fltk._FL_SHADOW_BOX
FL_BORDER_FRAME = _fltk.FL_BORDER_FRAME
_FL_SHADOW_FRAME = _fltk._FL_SHADOW_FRAME
_FL_ROUNDED_BOX = _fltk._FL_ROUNDED_BOX
_FL_RSHADOW_BOX = _fltk._FL_RSHADOW_BOX
_FL_ROUNDED_FRAME = _fltk._FL_ROUNDED_FRAME
_FL_RFLAT_BOX = _fltk._FL_RFLAT_BOX
_FL_ROUND_UP_BOX = _fltk._FL_ROUND_UP_BOX
_FL_ROUND_DOWN_BOX = _fltk._FL_ROUND_DOWN_BOX
_FL_DIAMOND_UP_BOX = _fltk._FL_DIAMOND_UP_BOX
_FL_DIAMOND_DOWN_BOX = _fltk._FL_DIAMOND_DOWN_BOX
_FL_OVAL_BOX = _fltk._FL_OVAL_BOX
_FL_OSHADOW_BOX = _fltk._FL_OSHADOW_BOX
_FL_OVAL_FRAME = _fltk._FL_OVAL_FRAME
_FL_OFLAT_BOX = _fltk._FL_OFLAT_BOX
_FL_PLASTIC_UP_BOX = _fltk._FL_PLASTIC_UP_BOX
_FL_PLASTIC_DOWN_BOX = _fltk._FL_PLASTIC_DOWN_BOX
_FL_PLASTIC_UP_FRAME = _fltk._FL_PLASTIC_UP_FRAME
_FL_PLASTIC_DOWN_FRAME = _fltk._FL_PLASTIC_DOWN_FRAME
_FL_PLASTIC_THIN_UP_BOX = _fltk._FL_PLASTIC_THIN_UP_BOX
_FL_PLASTIC_THIN_DOWN_BOX = _fltk._FL_PLASTIC_THIN_DOWN_BOX
_FL_PLASTIC_ROUND_UP_BOX = _fltk._FL_PLASTIC_ROUND_UP_BOX
_FL_PLASTIC_ROUND_DOWN_BOX = _fltk._FL_PLASTIC_ROUND_DOWN_BOX
_FL_GTK_UP_BOX = _fltk._FL_GTK_UP_BOX
_FL_GTK_DOWN_BOX = _fltk._FL_GTK_DOWN_BOX
_FL_GTK_UP_FRAME = _fltk._FL_GTK_UP_FRAME
_FL_GTK_DOWN_FRAME = _fltk._FL_GTK_DOWN_FRAME
_FL_GTK_THIN_UP_BOX = _fltk._FL_GTK_THIN_UP_BOX
_FL_GTK_THIN_DOWN_BOX = _fltk._FL_GTK_THIN_DOWN_BOX
_FL_GTK_THIN_UP_FRAME = _fltk._FL_GTK_THIN_UP_FRAME
_FL_GTK_THIN_DOWN_FRAME = _fltk._FL_GTK_THIN_DOWN_FRAME
_FL_GTK_ROUND_UP_BOX = _fltk._FL_GTK_ROUND_UP_BOX
_FL_GTK_ROUND_DOWN_BOX = _fltk._FL_GTK_ROUND_DOWN_BOX
_FL_GLEAM_UP_BOX = _fltk._FL_GLEAM_UP_BOX
_FL_GLEAM_DOWN_BOX = _fltk._FL_GLEAM_DOWN_BOX
_FL_GLEAM_UP_FRAME = _fltk._FL_GLEAM_UP_FRAME
_FL_GLEAM_DOWN_FRAME = _fltk._FL_GLEAM_DOWN_FRAME
_FL_GLEAM_THIN_UP_BOX = _fltk._FL_GLEAM_THIN_UP_BOX
_FL_GLEAM_THIN_DOWN_BOX = _fltk._FL_GLEAM_THIN_DOWN_BOX
_FL_GLEAM_ROUND_UP_BOX = _fltk._FL_GLEAM_ROUND_UP_BOX
_FL_GLEAM_ROUND_DOWN_BOX = _fltk._FL_GLEAM_ROUND_DOWN_BOX
FL_FREE_BOXTYPE = _fltk.FL_FREE_BOXTYPE

def fl_define_FL_ROUND_UP_BOX(*args) -> "Fl_Boxtype":
    """fl_define_FL_ROUND_UP_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_ROUND_UP_BOX(*args)

def fl_define_FL_SHADOW_BOX(*args) -> "Fl_Boxtype":
    """fl_define_FL_SHADOW_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_SHADOW_BOX(*args)

def fl_define_FL_ROUNDED_BOX(*args) -> "Fl_Boxtype":
    """fl_define_FL_ROUNDED_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_ROUNDED_BOX(*args)

def fl_define_FL_RFLAT_BOX(*args) -> "Fl_Boxtype":
    """fl_define_FL_RFLAT_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_RFLAT_BOX(*args)

def fl_define_FL_RSHADOW_BOX(*args) -> "Fl_Boxtype":
    """fl_define_FL_RSHADOW_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_RSHADOW_BOX(*args)

def fl_define_FL_DIAMOND_BOX(*args) -> "Fl_Boxtype":
    """fl_define_FL_DIAMOND_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_DIAMOND_BOX(*args)

def fl_define_FL_OVAL_BOX(*args) -> "Fl_Boxtype":
    """fl_define_FL_OVAL_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_OVAL_BOX(*args)

def fl_define_FL_PLASTIC_UP_BOX(*args) -> "Fl_Boxtype":
    """fl_define_FL_PLASTIC_UP_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_PLASTIC_UP_BOX(*args)

def fl_define_FL_GTK_UP_BOX(*args) -> "Fl_Boxtype":
    """fl_define_FL_GTK_UP_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_GTK_UP_BOX(*args)

def fl_define_FL_GLEAM_UP_BOX(*args) -> "Fl_Boxtype":
    """fl_define_FL_GLEAM_UP_BOX() -> Fl_Boxtype"""
    return _fltk.fl_define_FL_GLEAM_UP_BOX(*args)

def fl_box(*args) -> "Fl_Boxtype":
    """fl_box(Fl_Boxtype b) -> Fl_Boxtype"""
    return _fltk.fl_box(*args)

def fl_down(*args) -> "Fl_Boxtype":
    """fl_down(Fl_Boxtype b) -> Fl_Boxtype"""
    return _fltk.fl_down(*args)
FL_NORMAL_LABEL = _fltk.FL_NORMAL_LABEL
FL_NO_LABEL = _fltk.FL_NO_LABEL
_FL_SHADOW_LABEL = _fltk._FL_SHADOW_LABEL
_FL_ENGRAVED_LABEL = _fltk._FL_ENGRAVED_LABEL
_FL_EMBOSSED_LABEL = _fltk._FL_EMBOSSED_LABEL
_FL_MULTI_LABEL = _fltk._FL_MULTI_LABEL
_FL_ICON_LABEL = _fltk._FL_ICON_LABEL
_FL_IMAGE_LABEL = _fltk._FL_IMAGE_LABEL
FL_FREE_LABELTYPE = _fltk.FL_FREE_LABELTYPE

def fl_define_FL_SHADOW_LABEL(*args) -> "Fl_Labeltype":
    """fl_define_FL_SHADOW_LABEL() -> Fl_Labeltype"""
    return _fltk.fl_define_FL_SHADOW_LABEL(*args)

def fl_define_FL_ENGRAVED_LABEL(*args) -> "Fl_Labeltype":
    """fl_define_FL_ENGRAVED_LABEL() -> Fl_Labeltype"""
    return _fltk.fl_define_FL_ENGRAVED_LABEL(*args)

def fl_define_FL_EMBOSSED_LABEL(*args) -> "Fl_Labeltype":
    """fl_define_FL_EMBOSSED_LABEL() -> Fl_Labeltype"""
    return _fltk.fl_define_FL_EMBOSSED_LABEL(*args)
FL_NUM_FREE_COLOR = _fltk.FL_NUM_FREE_COLOR
FL_NUM_GRAY = _fltk.FL_NUM_GRAY
FL_NUM_RED = _fltk.FL_NUM_RED
FL_NUM_GREEN = _fltk.FL_NUM_GREEN
FL_NUM_BLUE = _fltk.FL_NUM_BLUE

def fl_inactive(*args) -> "Fl_Color":
    """fl_inactive(Fl_Color c) -> Fl_Color"""
    return _fltk.fl_inactive(*args)

def fl_contrast(*args) -> "Fl_Color":
    """fl_contrast(Fl_Color fg, Fl_Color bg) -> Fl_Color"""
    return _fltk.fl_contrast(*args)

def fl_color_average(*args) -> "Fl_Color":
    """fl_color_average(Fl_Color c1, Fl_Color c2, float weight) -> Fl_Color"""
    return _fltk.fl_color_average(*args)

def fl_lighter(*args) -> "Fl_Color":
    """fl_lighter(Fl_Color c) -> Fl_Color"""
    return _fltk.fl_lighter(*args)

def fl_darker(*args) -> "Fl_Color":
    """fl_darker(Fl_Color c) -> Fl_Color"""
    return _fltk.fl_darker(*args)

def fl_rgb_color(*args) -> "Fl_Color":
    """
    fl_rgb_color(uchar r, uchar g, uchar b) -> Fl_Color
    fl_rgb_color(uchar g) -> Fl_Color
    """
    return _fltk.fl_rgb_color(*args)

def fl_gray_ramp(*args) -> "Fl_Color":
    """fl_gray_ramp(int i) -> Fl_Color"""
    return _fltk.fl_gray_ramp(*args)

def fl_color_cube(*args) -> "Fl_Color":
    """fl_color_cube(int r, int g, int b) -> Fl_Color"""
    return _fltk.fl_color_cube(*args)
FL_CURSOR_DEFAULT = _fltk.FL_CURSOR_DEFAULT
FL_CURSOR_ARROW = _fltk.FL_CURSOR_ARROW
FL_CURSOR_CROSS = _fltk.FL_CURSOR_CROSS
FL_CURSOR_WAIT = _fltk.FL_CURSOR_WAIT
FL_CURSOR_INSERT = _fltk.FL_CURSOR_INSERT
FL_CURSOR_HAND = _fltk.FL_CURSOR_HAND
FL_CURSOR_HELP = _fltk.FL_CURSOR_HELP
FL_CURSOR_MOVE = _fltk.FL_CURSOR_MOVE
FL_CURSOR_NS = _fltk.FL_CURSOR_NS
FL_CURSOR_WE = _fltk.FL_CURSOR_WE
FL_CURSOR_NWSE = _fltk.FL_CURSOR_NWSE
FL_CURSOR_NESW = _fltk.FL_CURSOR_NESW
FL_CURSOR_N = _fltk.FL_CURSOR_N
FL_CURSOR_NE = _fltk.FL_CURSOR_NE
FL_CURSOR_E = _fltk.FL_CURSOR_E
FL_CURSOR_SE = _fltk.FL_CURSOR_SE
FL_CURSOR_S = _fltk.FL_CURSOR_S
FL_CURSOR_SW = _fltk.FL_CURSOR_SW
FL_CURSOR_W = _fltk.FL_CURSOR_W
FL_CURSOR_NW = _fltk.FL_CURSOR_NW
FL_CURSOR_NONE = _fltk.FL_CURSOR_NONE
FL_READ = _fltk.FL_READ
FL_WRITE = _fltk.FL_WRITE
FL_EXCEPT = _fltk.FL_EXCEPT
FL_RGB = _fltk.FL_RGB
FL_INDEX = _fltk.FL_INDEX
FL_SINGLE = _fltk.FL_SINGLE
FL_DOUBLE = _fltk.FL_DOUBLE
FL_ACCUM = _fltk.FL_ACCUM
FL_ALPHA = _fltk.FL_ALPHA
FL_DEPTH = _fltk.FL_DEPTH
FL_STENCIL = _fltk.FL_STENCIL
FL_RGB8 = _fltk.FL_RGB8
FL_MULTISAMPLE = _fltk.FL_MULTISAMPLE
FL_STEREO = _fltk.FL_STEREO
FL_FAKE_SINGLE = _fltk.FL_FAKE_SINGLE
FL_OPENGL3 = _fltk.FL_OPENGL3
FL_IMAGE_WITH_ALPHA = _fltk.FL_IMAGE_WITH_ALPHA
FL_DAMAGE_CHILD = _fltk.FL_DAMAGE_CHILD
FL_DAMAGE_EXPOSE = _fltk.FL_DAMAGE_EXPOSE
FL_DAMAGE_SCROLL = _fltk.FL_DAMAGE_SCROLL
FL_DAMAGE_OVERLAY = _fltk.FL_DAMAGE_OVERLAY
FL_DAMAGE_USER1 = _fltk.FL_DAMAGE_USER1
FL_DAMAGE_USER2 = _fltk.FL_DAMAGE_USER2
FL_DAMAGE_ALL = _fltk.FL_DAMAGE_ALL

# events
FL_KEYBOARD=FL_KEYDOWN

# additional boxtypes instead of defines
FL_ROUND_UP_BOX=fl_define_FL_ROUND_UP_BOX()
FL_ROUND_DOWN_BOX=fl_define_FL_ROUND_UP_BOX()+1
FL_SHADOW_BOX=fl_define_FL_SHADOW_BOX()
FL_SHADOW_FRAME=fl_define_FL_SHADOW_BOX()+2
FL_ROUNDED_BOX=fl_define_FL_ROUNDED_BOX()
FL_ROUNDED_FRAME=fl_define_FL_ROUNDED_BOX()+2
FL_RFLAT_BOX=fl_define_FL_RFLAT_BOX()
FL_RSHADOW_BOX=fl_define_FL_RSHADOW_BOX()
FL_DIAMOND_UP_BOX=fl_define_FL_DIAMOND_BOX()
FL_DIAMOND_DOWN_BOX=fl_define_FL_DIAMOND_BOX()+1
FL_OVAL_BOX=fl_define_FL_OVAL_BOX()
FL_OSHADOW_BOX=fl_define_FL_OVAL_BOX()+1
FL_OVAL_FRAME=fl_define_FL_OVAL_BOX()+2
FL_OFLAT_BOX=fl_define_FL_OVAL_BOX()+3
FL_PLASTIC_UP_BOX=fl_define_FL_PLASTIC_UP_BOX()
FL_PLASTIC_DOWN_BOX=fl_define_FL_PLASTIC_UP_BOX()+1
FL_PLASTIC_UP_FRAME=fl_define_FL_PLASTIC_UP_BOX()+2
FL_PLASTIC_DOWN_FRAME=fl_define_FL_PLASTIC_UP_BOX()+3
FL_PLASTIC_THIN_UP_BOX=fl_define_FL_PLASTIC_UP_BOX()+4
FL_PLASTIC_THIN_DOWN_BOX=fl_define_FL_PLASTIC_UP_BOX()+5
FL_PLASTIC_ROUND_UP_BOX=fl_define_FL_PLASTIC_UP_BOX()+6
FL_PLASTIC_ROUND_DOWN_BOX=fl_define_FL_PLASTIC_UP_BOX()+7

FL_GTK_UP_BOX=fl_define_FL_GTK_UP_BOX()
FL_GTK_DOWN_BOX=fl_define_FL_GTK_UP_BOX()+1
FL_GTK_UP_FRAME=fl_define_FL_GTK_UP_BOX()+2
FL_GTK_DOWN_FRAME=fl_define_FL_GTK_UP_BOX()+3
FL_GTK_THIN_UP_BOX=fl_define_FL_GTK_UP_BOX()+4
FL_GTK_THIN_DOWN_BOX=fl_define_FL_GTK_UP_BOX()+5
FL_GTK_THIN_UP_FRAME=fl_define_FL_GTK_UP_BOX()+6
FL_GTK_THIN_DOWN_FRAME=fl_define_FL_GTK_UP_BOX()+7
FL_GTK_ROUND_UP_BOX=fl_define_FL_GTK_UP_BOX()+8
FL_GTK_ROUND_DOWN_BOX=fl_define_FL_GTK_UP_BOX()+9

FL_GLEAM_UP_BOX=fl_define_FL_GLEAM_UP_BOX()
FL_GLEAM_DOWN_BOX=fl_define_FL_GLEAM_UP_BOX()+1
FL_GLEAM_UP_FRAME=fl_define_FL_GLEAM_UP_BOX()+2
FL_GLEAM_DOWN_FRAME=fl_define_FL_GLEAM_UP_BOX()+3
FL_GLEAM_THIN_UP_BOX=fl_define_FL_GLEAM_UP_BOX()+4
FL_GLEAM_THIN_DOWN_BOX=fl_define_FL_GLEAM_UP_BOX()+5
FL_GLEAM_ROUND_UP_BOX=fl_define_FL_GLEAM_UP_BOX()+8
FL_GLEAM_ROUND_DOWN_BOX=fl_define_FL_GLEAM_UP_BOX()+9


# color defines
FL_FOREGROUND_COLOR  = 0
FL_BACKGROUND2_COLOR = 7
FL_INACTIVE_COLOR    = 8
FL_SELECTION_COLOR   = 15

FL_GRAY0   = 32
FL_DARK3   = 39
FL_DARK2   = 45
FL_DARK1   = 47
FL_BACKGROUND_COLOR  = 49
FL_LIGHT1  = 50
FL_LIGHT2  = 52
FL_LIGHT3  = 54

FL_BLACK   = 56
FL_RED     = 88
FL_GREEN   = 63
FL_YELLOW  = 95
FL_BLUE    = 216
FL_MAGENTA = 248
FL_CYAN    = 223
FL_DARK_RED = 72

FL_DARK_GREEN    = 60
FL_DARK_YELLOW   = 76
FL_DARK_BLUE     = 136
FL_DARK_MAGENTA  = 152
FL_DARK_CYAN     = 140

FL_WHITE         = 255

FL_FREE_COLOR=16           
FL_NUM_FREE_COLOR=16       
FL_GRAY_RAMP=32           
FL_NUM_GRAY=24                     
FL_GRAY=49
FL_COLOR_CUBE=56           
FL_NUM_RED=5                      
FL_NUM_GREEN=8                      
FL_NUM_BLUE=5

# label defines
FL_SYMBOL_LABEL=FL_NORMAL_LABEL
FL_SHADOW_LABEL=fl_define_FL_SHADOW_LABEL()
FL_ENGRAVED_LABEL=fl_define_FL_ENGRAVED_LABEL()
FL_EMBOSSED_LABEL=fl_define_FL_EMBOSSED_LABEL()

FL_ALIGN_CENTER=0
FL_ALIGN_TOP=1
FL_ALIGN_BOTTOM=2
FL_ALIGN_LEFT=4
FL_ALIGN_RIGHT=8
FL_ALIGN_INSIDE=16
FL_ALIGN_TEXT_OVER_IMAGE=32
FL_ALIGN_IMAGE_OVER_TEXT=0
FL_ALIGN_CLIP=64
FL_ALIGN_WRAP=128
FL_ALIGN_IMAGE_NEXT_TO_TEXT=0x0100
FL_ALIGN_TEXT_NEXT_TO_IMAGE=0x0120
FL_ALIGN_IMAGE_BACKDROP=0x0200
FL_ALIGN_TOP_LEFT= FL_ALIGN_TOP | FL_ALIGN_LEFT
FL_ALIGN_TOP_RIGHT= FL_ALIGN_TOP | FL_ALIGN_RIGHT
FL_ALIGN_BOTTOM_LEFT= FL_ALIGN_BOTTOM | FL_ALIGN_LEFT
FL_ALIGN_BOTTOM_RIGHT= FL_ALIGN_BOTTOM | FL_ALIGN_RIGHT
FL_ALIGN_LEFT_TOP= FL_ALIGN_TOP_LEFT
FL_ALIGN_RIGHT_TOP= FL_ALIGN_TOP_RIGHT
FL_ALIGN_LEFT_BOTTOM= FL_ALIGN_BOTTOM_LEFT
FL_ALIGN_RIGHT_BOTTOM= FL_ALIGN_BOTTOM_RIGHT
FL_ALIGN_NOWRAP=0

# font defines
FL_HELVETICA              = 0	## Helvetica (or Arial) normal (0)
FL_HELVETICA_BOLD         = 1	## Helvetica (or Arial) bold
FL_HELVETICA_ITALIC       = 2	## Helvetica (or Arial) oblique
FL_HELVETICA_BOLD_ITALIC  = 3	## Helvetica (or Arial) bold-oblique
FL_COURIER                = 4	## Courier normal
FL_COURIER_BOLD           = 5	## Courier bold 
FL_COURIER_ITALIC         = 6	## Courier italic
FL_COURIER_BOLD_ITALIC    = 7	## Courier bold-italic
FL_TIMES                  = 8	## Times roman
FL_TIMES_BOLD             = 9	## Times roman bold
FL_TIMES_ITALIC           = 10	## Times roman italic
FL_TIMES_BOLD_ITALIC      = 11	## Times roman bold-italic
FL_SYMBOL                 = 12	## Standard symbol font
FL_SCREEN                 = 13	## Default monospaced screen font
FL_SCREEN_BOLD            = 14	## Default monospaced bold screen font
FL_ZAPF_DINGBATS          = 15	## Zapf-dingbats font

FL_FREE_FONT              = 16	## first one to allocate
FL_BOLD                   = 1	## add this to helvetica, courier, or times
FL_ITALIC                 = 2	## add this to helvetica, courier, or times
FL_BOLD_ITALIC            = 3	## add this to helvetica, courier, or times



FL_RGB_SCALING_NEAREST = _fltk.FL_RGB_SCALING_NEAREST
FL_RGB_SCALING_BILINEAR = _fltk.FL_RGB_SCALING_BILINEAR
class Fl_Image(object):
    """

    Fl_Image is the base class used for caching and drawing all kinds of images 
    in FLTK. This class keeps track of common image data such as the pixels, 
    colormap, width, height, and depth. Virtual methods are used to provide 
    type-specific image handling.

    Since the Fl_Image class does not support image drawing by itself, calling 
    the draw() method results in a box with an X in it being drawn instead.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def w(self, *args) -> "int":
        """w(Fl_Image self) -> int"""
        return _fltk.Fl_Image_w(self, *args)


    def h(self, *args) -> "int":
        """h(Fl_Image self) -> int"""
        return _fltk.Fl_Image_h(self, *args)


    def d(self, *args) -> "int":
        """d(Fl_Image self) -> int"""
        return _fltk.Fl_Image_d(self, *args)


    def ld(self, *args) -> "int":
        """ld(Fl_Image self) -> int"""
        return _fltk.Fl_Image_ld(self, *args)


    def count(self, *args) -> "int":
        """count(Fl_Image self) -> int"""
        return _fltk.Fl_Image_count(self, *args)


    def data(self, *args) -> "char const *const *":
        """data(Fl_Image self) -> char const *const *"""
        return _fltk.Fl_Image_data(self, *args)


    def fail(self, *args) -> "int":
        """fail(Fl_Image self) -> int"""
        return _fltk.Fl_Image_fail(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Image self, int W, int H, int D) -> Fl_Image"""
        if self.__class__ == Fl_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Image(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Image
    __del__ = lambda self: None

    def copy(self, *args) -> "Fl_Image *":
        """
        copy(Fl_Image self, int W, int H) -> Fl_Image
        copy(Fl_Image self) -> Fl_Image
        """
        return _fltk.Fl_Image_copy(self, *args)


    def color_average(self, *args) -> "void":
        """color_average(Fl_Image self, Fl_Color c, float i)"""
        return _fltk.Fl_Image_color_average(self, *args)


    def inactive(self, *args) -> "void":
        """inactive(Fl_Image self)"""
        return _fltk.Fl_Image_inactive(self, *args)


    def desaturate(self, *args) -> "void":
        """desaturate(Fl_Image self)"""
        return _fltk.Fl_Image_desaturate(self, *args)


    def label(self, *args) -> "void":
        """
        label(Fl_Image self, Fl_Widget w)
        label(Fl_Image self, Fl_Menu_Item m)
        """
        return _fltk.Fl_Image_label(self, *args)


    def draw(self, *args) -> "void":
        """
        draw(Fl_Image self, int X, int Y, int W, int H, int cx=0, int cy=0)
        draw(Fl_Image self, int X, int Y)
        """
        return _fltk.Fl_Image_draw(self, *args)


    def uncache(self, *args) -> "void":
        """uncache(Fl_Image self)"""
        return _fltk.Fl_Image_uncache(self, *args)


    def RGB_scaling(*args) -> "Fl_RGB_Scaling":
        """
        RGB_scaling(Fl_RGB_Scaling arg1)
        RGB_scaling() -> Fl_RGB_Scaling
        """
        return _fltk.Fl_Image_RGB_scaling(*args)

    RGB_scaling = staticmethod(RGB_scaling)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Image(self)
        return weakref_proxy(self)
Fl_Image_swigregister = _fltk.Fl_Image_swigregister
Fl_Image_swigregister(Fl_Image)

def Fl_Image_RGB_scaling(*args) -> "Fl_RGB_Scaling":
    """
    RGB_scaling(Fl_RGB_Scaling arg1)
    Fl_Image_RGB_scaling() -> Fl_RGB_Scaling
    """
    return _fltk.Fl_Image_RGB_scaling(*args)

class Fl_RGB_Image(Fl_Image):
    """Proxy of C++ Fl_RGB_Image class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Fl_RGB_Image self, uchar const * bits, int W, int H, int D=3, int LD=0) -> Fl_RGB_Image
        __init__(Fl_RGB_Image self, Fl_Pixmap pxm, Fl_Color bg) -> Fl_RGB_Image
        """
        if self.__class__ == Fl_RGB_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_RGB_Image(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_RGB_Image
    __del__ = lambda self: None

    def copy(self, *args) -> "Fl_Image *":
        """
        copy(Fl_RGB_Image self, int W, int H) -> Fl_Image
        copy(Fl_RGB_Image self) -> Fl_Image
        """
        return _fltk.Fl_RGB_Image_copy(self, *args)


    def color_average(self, *args) -> "void":
        """color_average(Fl_RGB_Image self, Fl_Color c, float i)"""
        return _fltk.Fl_RGB_Image_color_average(self, *args)


    def desaturate(self, *args) -> "void":
        """desaturate(Fl_RGB_Image self)"""
        return _fltk.Fl_RGB_Image_desaturate(self, *args)


    def draw(self, *args) -> "void":
        """
        draw(Fl_RGB_Image self, int X, int Y, int W, int H, int cx=0, int cy=0)
        draw(Fl_RGB_Image self, int X, int Y)
        """
        return _fltk.Fl_RGB_Image_draw(self, *args)


    def label(self, *args) -> "void":
        """
        label(Fl_RGB_Image self, Fl_Widget w)
        label(Fl_RGB_Image self, Fl_Menu_Item m)
        """
        return _fltk.Fl_RGB_Image_label(self, *args)


    def uncache(self, *args) -> "void":
        """uncache(Fl_RGB_Image self)"""
        return _fltk.Fl_RGB_Image_uncache(self, *args)


    def max_size(*args) -> "size_t":
        """
        max_size(size_t size)
        max_size() -> size_t
        """
        return _fltk.Fl_RGB_Image_max_size(*args)

    max_size = staticmethod(max_size)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_RGB_Image(self)
        return weakref_proxy(self)
Fl_RGB_Image_swigregister = _fltk.Fl_RGB_Image_swigregister
Fl_RGB_Image_swigregister(Fl_RGB_Image)

def Fl_RGB_Image_max_size(*args) -> "size_t":
    """
    max_size(size_t size)
    Fl_RGB_Image_max_size() -> size_t
    """
    return _fltk.Fl_RGB_Image_max_size(*args)

class Fl_Label(object):
    """Proxy of C++ Fl_Label class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Label self, int arg2, int arg3, int arg4, int arg5, Fl_Align arg6)"""
        return _fltk.Fl_Label_draw(self, *args)


    def measure(self, *args) -> "void":
        """measure(Fl_Label self, int & w, int & h)"""
        return _fltk.Fl_Label_measure(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Label self) -> Fl_Label"""
        this = _fltk.new_Fl_Label(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Label
    __del__ = lambda self: None
Fl_Label_swigregister = _fltk.Fl_Label_swigregister
Fl_Label_swigregister(Fl_Label)

class Fl_Widget(object):
    """

    Fl_Widget is the base class for all widgets in FLTK. You can't create one of 
    these because the constructor is not public. However you can subclass it.

    All 'property' accessing methods, such as color(), parent(), or argument() 
    are implemented as trivial inline functions and thus are as fast and small 
    as accessing fields in a structure. Unless otherwise noted, the property 
    setting methods such as color(n) or label(s) are also trivial inline 
    functions, even if they change the widget's appearance. It is up to the user 
    code to call redraw() after these. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Widget self, int x, int y, int w, int h, char const * label=0) -> Fl_Widget"""
        if self.__class__ == Fl_Widget:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Widget(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Widget
    __del__ = lambda self: None

    def draw(self, *args) -> "void":
        """draw(Fl_Widget self)"""
        return _fltk.Fl_Widget_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Widget self, int event) -> int"""
        return _fltk.Fl_Widget_handle(self, *args)


    def is_label_copied(self, *args) -> "int":
        """is_label_copied(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_is_label_copied(self, *args)


    def parent(self, *args) -> "void":
        """
        parent(Fl_Widget self) -> Fl_Group
        parent(Fl_Widget self, Fl_Group p)
        """
        return _fltk.Fl_Widget_parent(self, *args)


    def type(self, *args) -> "void":
        """
        type(Fl_Widget self) -> uchar
        type(Fl_Widget self, uchar t)
        """
        return _fltk.Fl_Widget_type(self, *args)


    def x(self, *args) -> "int":
        """x(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_x(self, *args)


    def y(self, *args) -> "int":
        """y(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_y(self, *args)


    def w(self, *args) -> "int":
        """w(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_w(self, *args)


    def h(self, *args) -> "int":
        """h(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_h(self, *args)


    def resize(self, *args) -> "void":
        """resize(Fl_Widget self, int x, int y, int w, int h)"""
        return _fltk.Fl_Widget_resize(self, *args)


    def damage_resize(self, *args) -> "int":
        """damage_resize(Fl_Widget self, int arg2, int arg3, int arg4, int arg5) -> int"""
        return _fltk.Fl_Widget_damage_resize(self, *args)


    def position(self, *args) -> "void":
        """position(Fl_Widget self, int X, int Y)"""
        return _fltk.Fl_Widget_position(self, *args)


    def size(self, *args) -> "void":
        """size(Fl_Widget self, int W, int H)"""
        return _fltk.Fl_Widget_size(self, *args)


    def align(self, *args) -> "void":
        """
        align(Fl_Widget self) -> Fl_Align
        align(Fl_Widget self, Fl_Align alignment)
        """
        return _fltk.Fl_Widget_align(self, *args)


    def box(self, *args) -> "void":
        """
        box(Fl_Widget self) -> Fl_Boxtype
        box(Fl_Widget self, Fl_Boxtype new_box)
        """
        return _fltk.Fl_Widget_box(self, *args)


    def selection_color(self, *args) -> "void":
        """
        selection_color(Fl_Widget self) -> Fl_Color
        selection_color(Fl_Widget self, Fl_Color a)
        """
        return _fltk.Fl_Widget_selection_color(self, *args)


    def color(self, *args) -> "void":
        """
        color(Fl_Widget self) -> Fl_Color
        color(Fl_Widget self, Fl_Color bg)
        color(Fl_Widget self, Fl_Color bg, Fl_Color sel)
        """
        return _fltk.Fl_Widget_color(self, *args)


    def copy_label(self, *args) -> "void":
        """copy_label(Fl_Widget self, char const * new_label)"""
        return _fltk.Fl_Widget_copy_label(self, *args)


    def label(self, *args) -> "void":
        """
        label(Fl_Widget self) -> char const
        label(Fl_Widget self, char const * text)
        label(Fl_Widget self, Fl_Labeltype a, char const * b)
        """
        val = _fltk.Fl_Widget_label(self, *args)

        if len(args) > 0:
            self.my_label = args[len(args)-1]


        return val


    def labeltype(self, *args) -> "void":
        """
        labeltype(Fl_Widget self) -> Fl_Labeltype
        labeltype(Fl_Widget self, Fl_Labeltype a)
        """
        return _fltk.Fl_Widget_labeltype(self, *args)


    def labelcolor(self, *args) -> "void":
        """
        labelcolor(Fl_Widget self) -> Fl_Color
        labelcolor(Fl_Widget self, Fl_Color c)
        """
        return _fltk.Fl_Widget_labelcolor(self, *args)


    def labelfont(self, *args) -> "void":
        """
        labelfont(Fl_Widget self) -> Fl_Font
        labelfont(Fl_Widget self, Fl_Font f)
        """
        return _fltk.Fl_Widget_labelfont(self, *args)


    def labelsize(self, *args) -> "void":
        """
        labelsize(Fl_Widget self) -> Fl_Fontsize
        labelsize(Fl_Widget self, Fl_Fontsize pix)
        """
        return _fltk.Fl_Widget_labelsize(self, *args)


    def image(self, *args) -> "void":
        """
        image(Fl_Widget self) -> Fl_Image
        image(Fl_Widget self) -> Fl_Image
        image(Fl_Widget self, Fl_Image img)
        """
        val = _fltk.Fl_Widget_image(self, *args)

        if len(args) > 0:
        #delegate ownership to C++
            self.my_image = args[0]


        return val


    def deimage(self, *args) -> "void":
        """
        deimage(Fl_Widget self) -> Fl_Image
        deimage(Fl_Widget self) -> Fl_Image
        deimage(Fl_Widget self, Fl_Image img)
        """
        val = _fltk.Fl_Widget_deimage(self, *args)

        if len(args) > 0:
        #delegate ownership to C++
            self.my_deimage = args[0]


        return val


    def tooltip(self, *args) -> "void":
        """
        tooltip(Fl_Widget self) -> char const
        tooltip(Fl_Widget self, char const * text)
        """
        return _fltk.Fl_Widget_tooltip(self, *args)


    def copy_tooltip(self, *args) -> "void":
        """copy_tooltip(Fl_Widget self, char const * text)"""
        return _fltk.Fl_Widget_copy_tooltip(self, *args)


    def argument(self, *args) -> "void":
        """
        argument(Fl_Widget self) -> long
        argument(Fl_Widget self, long v)
        """
        return _fltk.Fl_Widget_argument(self, *args)


    def when(self, *args) -> "void":
        """
        when(Fl_Widget self) -> Fl_When
        when(Fl_Widget self, uchar i)
        """
        return _fltk.Fl_Widget_when(self, *args)


    def visible(self, *args) -> "unsigned int":
        """visible(Fl_Widget self) -> unsigned int"""
        return _fltk.Fl_Widget_visible(self, *args)


    def visible_r(self, *args) -> "int":
        """visible_r(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_visible_r(self, *args)


    def show(self, *args) -> "void":
        """show(Fl_Widget self)"""
        return _fltk.Fl_Widget_show(self, *args)


    def hide(self, *args) -> "void":
        """hide(Fl_Widget self)"""
        return _fltk.Fl_Widget_hide(self, *args)


    def set_visible(self, *args) -> "void":
        """set_visible(Fl_Widget self)"""
        return _fltk.Fl_Widget_set_visible(self, *args)


    def clear_visible(self, *args) -> "void":
        """clear_visible(Fl_Widget self)"""
        return _fltk.Fl_Widget_clear_visible(self, *args)


    def active(self, *args) -> "unsigned int":
        """active(Fl_Widget self) -> unsigned int"""
        return _fltk.Fl_Widget_active(self, *args)


    def active_r(self, *args) -> "int":
        """active_r(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_active_r(self, *args)


    def activate(self, *args) -> "void":
        """activate(Fl_Widget self)"""
        return _fltk.Fl_Widget_activate(self, *args)


    def deactivate(self, *args) -> "void":
        """deactivate(Fl_Widget self)"""
        return _fltk.Fl_Widget_deactivate(self, *args)


    def output(self, *args) -> "unsigned int":
        """output(Fl_Widget self) -> unsigned int"""
        return _fltk.Fl_Widget_output(self, *args)


    def set_output(self, *args) -> "void":
        """set_output(Fl_Widget self)"""
        return _fltk.Fl_Widget_set_output(self, *args)


    def clear_output(self, *args) -> "void":
        """clear_output(Fl_Widget self)"""
        return _fltk.Fl_Widget_clear_output(self, *args)


    def takesevents(self, *args) -> "unsigned int":
        """takesevents(Fl_Widget self) -> unsigned int"""
        return _fltk.Fl_Widget_takesevents(self, *args)


    def changed(self, *args) -> "unsigned int":
        """changed(Fl_Widget self) -> unsigned int"""
        return _fltk.Fl_Widget_changed(self, *args)


    def set_changed(self, *args) -> "void":
        """set_changed(Fl_Widget self)"""
        return _fltk.Fl_Widget_set_changed(self, *args)


    def clear_changed(self, *args) -> "void":
        """clear_changed(Fl_Widget self)"""
        return _fltk.Fl_Widget_clear_changed(self, *args)


    def clear_active(self, *args) -> "void":
        """clear_active(Fl_Widget self)"""
        return _fltk.Fl_Widget_clear_active(self, *args)


    def set_active(self, *args) -> "void":
        """set_active(Fl_Widget self)"""
        return _fltk.Fl_Widget_set_active(self, *args)


    def take_focus(self, *args) -> "int":
        """take_focus(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_take_focus(self, *args)


    def set_visible_focus(self, *args) -> "void":
        """set_visible_focus(Fl_Widget self)"""
        return _fltk.Fl_Widget_set_visible_focus(self, *args)


    def clear_visible_focus(self, *args) -> "void":
        """clear_visible_focus(Fl_Widget self)"""
        return _fltk.Fl_Widget_clear_visible_focus(self, *args)


    def visible_focus(self, *args) -> "unsigned int":
        """
        visible_focus(Fl_Widget self, int v)
        visible_focus(Fl_Widget self) -> unsigned int
        """
        return _fltk.Fl_Widget_visible_focus(self, *args)


    def default_callback(*args) -> "void":
        """default_callback(Fl_Widget cb, void * d)"""
        return _fltk.Fl_Widget_default_callback(*args)

    default_callback = staticmethod(default_callback)

    def do_callback(self, *args) -> "void":
        """
        do_callback(Fl_Widget self)
        do_callback(Fl_Widget self, Fl_Widget o, long arg)
        do_callback(Fl_Widget self, Fl_Widget o, void * arg=None)
        """
        return _fltk.Fl_Widget_do_callback(self, *args)


    def label_shortcut(*args) -> "unsigned int":
        """label_shortcut(char const * t) -> unsigned int"""
        return _fltk.Fl_Widget_label_shortcut(*args)

    label_shortcut = staticmethod(label_shortcut)

    def test_shortcut(*args) -> "int":
        """
        test_shortcut() -> int
        test_shortcut(char const * arg1, bool const require_alt=False) -> int
        """
        return _fltk.Fl_Widget_test_shortcut(*args)

    test_shortcut = staticmethod(test_shortcut)

    def _set_fullscreen(self, *args) -> "void":
        """_set_fullscreen(Fl_Widget self)"""
        return _fltk.Fl_Widget__set_fullscreen(self, *args)


    def _clear_fullscreen(self, *args) -> "void":
        """_clear_fullscreen(Fl_Widget self)"""
        return _fltk.Fl_Widget__clear_fullscreen(self, *args)


    def contains(self, *args) -> "int":
        """contains(Fl_Widget self, Fl_Widget w) -> int"""
        return _fltk.Fl_Widget_contains(self, *args)


    def inside(self, *args) -> "int":
        """inside(Fl_Widget self, Fl_Widget wgt) -> int"""
        return _fltk.Fl_Widget_inside(self, *args)


    def redraw(self, *args) -> "void":
        """redraw(Fl_Widget self)"""
        return _fltk.Fl_Widget_redraw(self, *args)


    def redraw_label(self, *args) -> "void":
        """redraw_label(Fl_Widget self)"""
        return _fltk.Fl_Widget_redraw_label(self, *args)


    def clear_damage(self, *args) -> "void":
        """clear_damage(Fl_Widget self, uchar c=0)"""
        return _fltk.Fl_Widget_clear_damage(self, *args)


    def damage(self, *args) -> "void":
        """
        damage(Fl_Widget self) -> uchar
        damage(Fl_Widget self, uchar c)
        damage(Fl_Widget self, uchar c, int x, int y, int w, int h)
        """
        return _fltk.Fl_Widget_damage(self, *args)


    def measure_label(self, *args) -> "void":
        """measure_label(Fl_Widget self, int & ww, int & hh)"""
        return _fltk.Fl_Widget_measure_label(self, *args)


    def window(self, *args) -> "Fl_Window *":
        """window(Fl_Widget self) -> Fl_Window"""
        return _fltk.Fl_Widget_window(self, *args)


    def top_window(self, *args) -> "Fl_Window *":
        """top_window(Fl_Widget self) -> Fl_Window"""
        return _fltk.Fl_Widget_top_window(self, *args)


    def top_window_offset(self, *args) -> "Fl_Window *":
        """top_window_offset(Fl_Widget self, int & xoff, int & yoff) -> Fl_Window"""
        return _fltk.Fl_Widget_top_window_offset(self, *args)


    def as_group(self, *args) -> "Fl_Group *":
        """as_group(Fl_Widget self) -> Fl_Group"""
        return _fltk.Fl_Widget_as_group(self, *args)


    def as_window(self, *args) -> "Fl_Window *":
        """as_window(Fl_Widget self) -> Fl_Window"""
        return _fltk.Fl_Widget_as_window(self, *args)


    def as_gl_window(self, *args) -> "Fl_Gl_Window *":
        """as_gl_window(Fl_Widget self) -> Fl_Gl_Window"""
        return _fltk.Fl_Widget_as_gl_window(self, *args)


    def use_accents_menu(self, *args) -> "int":
        """use_accents_menu(Fl_Widget self) -> int"""
        return _fltk.Fl_Widget_use_accents_menu(self, *args)


    def color2(self, *args) -> "void":
        """
        color2(Fl_Widget self) -> Fl_Color
        color2(Fl_Widget self, unsigned int a)
        """
        return _fltk.Fl_Widget_color2(self, *args)


    def draw_label(self, *args) -> "void":
        """
        draw_label(Fl_Widget self, int arg2, int arg3, int arg4, int arg5, Fl_Align arg6)
        draw_label(Fl_Widget self)
        """
        return _fltk.Fl_Widget_draw_label(self, *args)


    def draw_backdrop(self, *args) -> "void":
        """draw_backdrop(Fl_Widget self)"""
        return _fltk.Fl_Widget_draw_backdrop(self, *args)


    def callback(self, *args) -> "void":
        """
        callback(Fl_Widget self) -> Fl_Callback_p
        callback(Fl_Widget self, Fl_Callback * cb, void * p)
        callback(Fl_Widget self, Fl_Callback * cb)
        callback(Fl_Widget self, Fl_Callback0 * cb)
        callback(Fl_Widget self, Fl_Callback1 * cb, long p=0)
        callback(Fl_Widget self, PyObject * PyFunc, PyObject * PyWidget, PyObject * PyData=None)
        """
        return _fltk.Fl_Widget_callback(self, *args)


    def user_data(self, *args) -> "PyObject *":
        """
        user_data(Fl_Widget self)
        user_data(Fl_Widget self, void * v)
        user_data(Fl_Widget self, PyObject * PyData)
        user_data(Fl_Widget self) -> PyObject *
        """
        return _fltk.Fl_Widget_user_data(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Widget(self)
        return weakref_proxy(self)
Fl_Widget_swigregister = _fltk.Fl_Widget_swigregister
Fl_Widget_swigregister(Fl_Widget)

def Fl_Widget_default_callback(*args) -> "void":
    """Fl_Widget_default_callback(Fl_Widget cb, void * d)"""
    return _fltk.Fl_Widget_default_callback(*args)

def Fl_Widget_label_shortcut(*args) -> "unsigned int":
    """Fl_Widget_label_shortcut(char const * t) -> unsigned int"""
    return _fltk.Fl_Widget_label_shortcut(*args)

def Fl_Widget_test_shortcut(*args) -> "int":
    """
    test_shortcut() -> int
    Fl_Widget_test_shortcut(char const * arg2, bool const require_alt=False) -> int
    """
    return _fltk.Fl_Widget_test_shortcut(*args)

FL_RESERVED_TYPE = _fltk.FL_RESERVED_TYPE
class Fl_Group(Fl_Widget):
    """

    The Fl_Group class is the FLTK container widget. It maintains an array of 
    child widgets. These children can themselves be any widget including Fl_Group. 
    The most important subclass of Fl_Group  is Fl_Window, however groups can 
    also be used to control radio buttons or to enforce resize behavior.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Group self)"""
        return _fltk.Fl_Group_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Group self, int arg0) -> int"""
        return _fltk.Fl_Group_handle(self, *args)


    def begin(self, *args) -> "void":
        """begin(Fl_Group self)"""
        return _fltk.Fl_Group_begin(self, *args)


    def end(self, *args) -> "void":
        """end(Fl_Group self)"""
        return _fltk.Fl_Group_end(self, *args)


    def current(*args) -> "void":
        """
        current() -> Fl_Group
        current(Fl_Group g)
        """
        return _fltk.Fl_Group_current(*args)

    current = staticmethod(current)

    def children(self, *args) -> "int":
        """children(Fl_Group self) -> int"""
        return _fltk.Fl_Group_children(self, *args)


    def child(self, *args) -> "Fl_Widget *":
        """child(Fl_Group self, int n) -> Fl_Widget"""
        return _fltk.Fl_Group_child(self, *args)


    def find(self, *args) -> "int":
        """find(Fl_Group self, Fl_Widget o) -> int"""
        return _fltk.Fl_Group_find(self, *args)


    def resize(self, *args) -> "void":
        """resize(Fl_Group self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Group_resize(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Group self, int arg2, int arg3, int arg4, int arg5, char const * arg6=None) -> Fl_Group"""
        if self.__class__ == Fl_Group:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Group(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Group
    __del__ = lambda self: None

    def add(self, *args) -> "void":
        """add(Fl_Group self, Fl_Widget o)"""
        val = _fltk.Fl_Group_add(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def insert(self, *args) -> "void":
        """insert(Fl_Group self, Fl_Widget arg2, int i)"""
        return _fltk.Fl_Group_insert(self, *args)


    def insert_before(self, *args) -> "void":
        """insert_before(Fl_Group self, Fl_Widget o, Fl_Widget before)"""
        return _fltk.Fl_Group_insert_before(self, *args)


    def remove(self, *args) -> "void":
        """
        remove(Fl_Group self, int index)
        remove(Fl_Group self, Fl_Widget o)
        """
        val = _fltk.Fl_Group_remove(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def clear(self, *args) -> "void":
        """clear(Fl_Group self)"""
        return _fltk.Fl_Group_clear(self, *args)


    def resizable(self, *args) -> "Fl_Widget *":
        """
        resizable(Fl_Group self, Fl_Widget o)
        resizable(Fl_Group self) -> Fl_Widget
        """
        return _fltk.Fl_Group_resizable(self, *args)


    def add_resizable(self, *args) -> "void":
        """add_resizable(Fl_Group self, Fl_Widget o)"""
        return _fltk.Fl_Group_add_resizable(self, *args)


    def init_sizes(self, *args) -> "void":
        """init_sizes(Fl_Group self)"""
        return _fltk.Fl_Group_init_sizes(self, *args)


    def clip_children(self, *args) -> "unsigned int":
        """
        clip_children(Fl_Group self, int c)
        clip_children(Fl_Group self) -> unsigned int
        """
        return _fltk.Fl_Group_clip_children(self, *args)


    def as_group(self, *args) -> "Fl_Group *":
        """as_group(Fl_Group self) -> Fl_Group"""
        return _fltk.Fl_Group_as_group(self, *args)


    def focus(self, *args) -> "void":
        """focus(Fl_Group self, Fl_Widget W)"""
        return _fltk.Fl_Group_focus(self, *args)


    def _ddfdesign_kludge(self, *args) -> "Fl_Widget *&":
        """_ddfdesign_kludge(Fl_Group self) -> Fl_Widget *&"""
        return _fltk.Fl_Group__ddfdesign_kludge(self, *args)


    def forms_end(self, *args) -> "void":
        """forms_end(Fl_Group self)"""
        return _fltk.Fl_Group_forms_end(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Group(self)
        return weakref_proxy(self)
Fl_Group_swigregister = _fltk.Fl_Group_swigregister
Fl_Group_swigregister(Fl_Group)

def Fl_Group_current(*args) -> "void":
    """
    current() -> Fl_Group
    Fl_Group_current(Fl_Group g)
    """
    return _fltk.Fl_Group_current(*args)

class Fl_End(object):
    """Proxy of C++ Fl_End class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_End self) -> Fl_End"""
        this = _fltk.new_Fl_End(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_End
    __del__ = lambda self: None
Fl_End_swigregister = _fltk.Fl_End_swigregister
Fl_End_swigregister(Fl_End)

FL_NORMAL_BROWSER = _fltk.FL_NORMAL_BROWSER
FL_SELECT_BROWSER = _fltk.FL_SELECT_BROWSER
FL_HOLD_BROWSER = _fltk.FL_HOLD_BROWSER
FL_MULTI_BROWSER = _fltk.FL_MULTI_BROWSER
FL_SORT_ASCENDING = _fltk.FL_SORT_ASCENDING
FL_SORT_DESCENDING = _fltk.FL_SORT_DESCENDING
class Fl_Browser_(Fl_Group):
    """

    This is the base class for browsers. To be useful it must be subclassed 
    and several virtual functions defined. The Forms-compatible browser and 
    the file chooser's browser are subclassed off of this.

    This has been designed so that the subclass has complete control over 
    the storage of the data, although because next() and prev() functions 
    are used to index, it works best as a linked list or as a large block 
    of characters in which the line breaks must be searched for.

    A great deal of work has been done so that the 'height' of a data object 
    does not need to be determined until it is drawn. This is useful if 
    actually figuring out the size of an object requires accessing image 
    data or doing stat() on a file or doing some other slow operation. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def item_first(self, *args) -> "void *":
        """item_first(Fl_Browser_ self) -> void *"""
        return _fltk.Fl_Browser__item_first(self, *args)


    def item_next(self, *args) -> "void *":
        """item_next(Fl_Browser_ self, void * item) -> void *"""
        return _fltk.Fl_Browser__item_next(self, *args)


    def item_prev(self, *args) -> "void *":
        """item_prev(Fl_Browser_ self, void * item) -> void *"""
        return _fltk.Fl_Browser__item_prev(self, *args)


    def item_last(self, *args) -> "void *":
        """item_last(Fl_Browser_ self) -> void *"""
        return _fltk.Fl_Browser__item_last(self, *args)


    def item_height(self, *args) -> "int":
        """item_height(Fl_Browser_ self, void * item) -> int"""
        return _fltk.Fl_Browser__item_height(self, *args)


    def item_width(self, *args) -> "int":
        """item_width(Fl_Browser_ self, void * item) -> int"""
        return _fltk.Fl_Browser__item_width(self, *args)


    def item_quick_height(self, *args) -> "int":
        """item_quick_height(Fl_Browser_ self, void * item) -> int"""
        return _fltk.Fl_Browser__item_quick_height(self, *args)


    def item_draw(self, *args) -> "void":
        """item_draw(Fl_Browser_ self, void * item, int X, int Y, int W, int H)"""
        return _fltk.Fl_Browser__item_draw(self, *args)


    def item_text(self, *args) -> "char const *":
        """item_text(Fl_Browser_ self, void * item) -> char const *"""
        return _fltk.Fl_Browser__item_text(self, *args)


    def item_swap(self, *args) -> "void":
        """item_swap(Fl_Browser_ self, void * a, void * b)"""
        return _fltk.Fl_Browser__item_swap(self, *args)


    def item_at(self, *args) -> "void *":
        """item_at(Fl_Browser_ self, int index) -> void *"""
        return _fltk.Fl_Browser__item_at(self, *args)


    def full_width(self, *args) -> "int":
        """full_width(Fl_Browser_ self) -> int"""
        return _fltk.Fl_Browser__full_width(self, *args)


    def full_height(self, *args) -> "int":
        """full_height(Fl_Browser_ self) -> int"""
        return _fltk.Fl_Browser__full_height(self, *args)


    def incr_height(self, *args) -> "int":
        """incr_height(Fl_Browser_ self) -> int"""
        return _fltk.Fl_Browser__incr_height(self, *args)


    def item_select(self, *args) -> "void":
        """item_select(Fl_Browser_ self, void * item, int val=1)"""
        return _fltk.Fl_Browser__item_select(self, *args)


    def item_selected(self, *args) -> "int":
        """item_selected(Fl_Browser_ self, void * item) -> int"""
        return _fltk.Fl_Browser__item_selected(self, *args)


    def draw(self, *args) -> "void":
        """draw(Fl_Browser_ self)"""
        return _fltk.Fl_Browser__draw(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Browser_ self, int X, int Y, int W, int H, char const * L=None) -> Fl_Browser_"""
        if self.__class__ == Fl_Browser_:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Browser_(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def handle(self, *args) -> "int":
        """handle(Fl_Browser_ self, int event) -> int"""
        return _fltk.Fl_Browser__handle(self, *args)


    def resize(self, *args) -> "void":
        """resize(Fl_Browser_ self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Browser__resize(self, *args)


    def select(self, *args) -> "int":
        """select(Fl_Browser_ self, void * item, int val=1, int docallbacks=0) -> int"""
        return _fltk.Fl_Browser__select(self, *args)


    def select_only(self, *args) -> "int":
        """select_only(Fl_Browser_ self, void * item, int docallbacks=0) -> int"""
        return _fltk.Fl_Browser__select_only(self, *args)


    def deselect(self, *args) -> "int":
        """deselect(Fl_Browser_ self, int docallbacks=0) -> int"""
        return _fltk.Fl_Browser__deselect(self, *args)


    def position(self, *args) -> "void":
        """
        position(Fl_Browser_ self) -> int
        position(Fl_Browser_ self, int pos)
        """
        return _fltk.Fl_Browser__position(self, *args)


    def hposition(self, *args) -> "void":
        """
        hposition(Fl_Browser_ self) -> int
        hposition(Fl_Browser_ self, int arg2)
        """
        return _fltk.Fl_Browser__hposition(self, *args)


    def display(self, *args) -> "void":
        """display(Fl_Browser_ self, void * item)"""
        return _fltk.Fl_Browser__display(self, *args)

    HORIZONTAL = _fltk.Fl_Browser__HORIZONTAL
    VERTICAL = _fltk.Fl_Browser__VERTICAL
    BOTH = _fltk.Fl_Browser__BOTH
    ALWAYS_ON = _fltk.Fl_Browser__ALWAYS_ON
    HORIZONTAL_ALWAYS = _fltk.Fl_Browser__HORIZONTAL_ALWAYS
    VERTICAL_ALWAYS = _fltk.Fl_Browser__VERTICAL_ALWAYS
    BOTH_ALWAYS = _fltk.Fl_Browser__BOTH_ALWAYS

    def has_scrollbar(self, *args) -> "void":
        """
        has_scrollbar(Fl_Browser_ self) -> uchar
        has_scrollbar(Fl_Browser_ self, uchar mode)
        """
        return _fltk.Fl_Browser__has_scrollbar(self, *args)


    def textfont(self, *args) -> "void":
        """
        textfont(Fl_Browser_ self) -> Fl_Font
        textfont(Fl_Browser_ self, Fl_Font font)
        """
        return _fltk.Fl_Browser__textfont(self, *args)


    def textsize(self, *args) -> "void":
        """
        textsize(Fl_Browser_ self) -> Fl_Fontsize
        textsize(Fl_Browser_ self, Fl_Fontsize newSize)
        """
        return _fltk.Fl_Browser__textsize(self, *args)


    def textcolor(self, *args) -> "void":
        """
        textcolor(Fl_Browser_ self) -> Fl_Color
        textcolor(Fl_Browser_ self, Fl_Color col)
        """
        return _fltk.Fl_Browser__textcolor(self, *args)


    def scrollbar_size(self, *args) -> "void":
        """
        scrollbar_size(Fl_Browser_ self) -> int
        scrollbar_size(Fl_Browser_ self, int newSize)
        """
        return _fltk.Fl_Browser__scrollbar_size(self, *args)


    def scrollbar_width(self, *args) -> "void":
        """
        scrollbar_width(Fl_Browser_ self) -> int
        scrollbar_width(Fl_Browser_ self, int width)
        """
        return _fltk.Fl_Browser__scrollbar_width(self, *args)


    def scrollbar_right(self, *args) -> "void":
        """scrollbar_right(Fl_Browser_ self)"""
        return _fltk.Fl_Browser__scrollbar_right(self, *args)


    def scrollbar_left(self, *args) -> "void":
        """scrollbar_left(Fl_Browser_ self)"""
        return _fltk.Fl_Browser__scrollbar_left(self, *args)


    def sort(self, *args) -> "void":
        """sort(Fl_Browser_ self, int flags=0)"""
        return _fltk.Fl_Browser__sort(self, *args)


    def getScrollbar(self, *args) -> "Fl_Scrollbar *":
        """getScrollbar(Fl_Browser_ self) -> Fl_Scrollbar"""
        return _fltk.Fl_Browser__getScrollbar(self, *args)


    def getHScrollbar(self, *args) -> "Fl_Scrollbar *":
        """getHScrollbar(Fl_Browser_ self) -> Fl_Scrollbar"""
        return _fltk.Fl_Browser__getHScrollbar(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Browser_
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Browser_(self)
        return weakref_proxy(self)
Fl_Browser__swigregister = _fltk.Fl_Browser__swigregister
Fl_Browser__swigregister(Fl_Browser_)

class Fl_Browser(Fl_Browser_):
    """

    The Fl_Browser widget displays a scrolling list of text lines, and manages 
    all the storage for the text. This is not a text editor or spreadsheet! But 
    it is useful for showing a vertical list of named objects to the user.

    Each line in the browser is identified by number. The numbers start at one 
    (this is so that zero can be reserved for 'no line' in the selective browsers).
    Unless otherwise noted, the methods do not check to see if the passed line 
    number is in range and legal. It must always be greater than zero 
    and <= size().

    Each line contains a null-terminated string of text and a data pointer. 
    The text string is displayed, the  pointer can be used by the callbacks 
    to reference the object the text describes.

    The base class does nothing when the user clicks on it. The subclasses 
    Fl_Select_Browser, Fl_Hold_Browser, and Fl_Multi_Browser react to user 
    clicks to select lines in the browser and do callbacks.

    The base class called Fl_Browser_ provides the scrolling and selection 
    mechanisms of this and all the subclasses, but the dimensions and appearance 
    of each item are determined by the subclass. You can use Fl_Browser_ to 
    display information other than text, or text that is dynamically produced 
    from your own data structures. If you find that loading the browser is a 
    lot of work or is inefficient, you may want to make a subclass of Fl_Browser_. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def item_first(self, *args) -> "void *":
        """item_first(Fl_Browser self) -> void *"""
        return _fltk.Fl_Browser_item_first(self, *args)


    def item_next(self, *args) -> "void *":
        """item_next(Fl_Browser self, void * item) -> void *"""
        return _fltk.Fl_Browser_item_next(self, *args)


    def item_prev(self, *args) -> "void *":
        """item_prev(Fl_Browser self, void * item) -> void *"""
        return _fltk.Fl_Browser_item_prev(self, *args)


    def item_last(self, *args) -> "void *":
        """item_last(Fl_Browser self) -> void *"""
        return _fltk.Fl_Browser_item_last(self, *args)


    def item_selected(self, *args) -> "int":
        """item_selected(Fl_Browser self, void * item) -> int"""
        return _fltk.Fl_Browser_item_selected(self, *args)


    def item_select(self, *args) -> "void":
        """item_select(Fl_Browser self, void * item, int val)"""
        return _fltk.Fl_Browser_item_select(self, *args)


    def item_height(self, *args) -> "int":
        """item_height(Fl_Browser self, void * item) -> int"""
        return _fltk.Fl_Browser_item_height(self, *args)


    def item_width(self, *args) -> "int":
        """item_width(Fl_Browser self, void * item) -> int"""
        return _fltk.Fl_Browser_item_width(self, *args)


    def item_draw(self, *args) -> "void":
        """item_draw(Fl_Browser self, void * item, int X, int Y, int W, int H)"""
        return _fltk.Fl_Browser_item_draw(self, *args)


    def full_height(self, *args) -> "int":
        """full_height(Fl_Browser self) -> int"""
        return _fltk.Fl_Browser_full_height(self, *args)


    def incr_height(self, *args) -> "int":
        """incr_height(Fl_Browser self) -> int"""
        return _fltk.Fl_Browser_incr_height(self, *args)


    def item_text(self, *args) -> "char const *":
        """item_text(Fl_Browser self, void * item) -> char const *"""
        return _fltk.Fl_Browser_item_text(self, *args)


    def item_swap(self, *args) -> "void":
        """item_swap(Fl_Browser self, void * a, void * b)"""
        return _fltk.Fl_Browser_item_swap(self, *args)


    def item_at(self, *args) -> "void *":
        """item_at(Fl_Browser self, int line) -> void *"""
        return _fltk.Fl_Browser_item_at(self, *args)


    def remove(self, *args) -> "void":
        """remove(Fl_Browser self, int line)"""
        val = _fltk.Fl_Browser_remove(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def move(self, *args) -> "void":
        """move(Fl_Browser self, int to, int arg3)"""
        return _fltk.Fl_Browser_move(self, *args)


    def load(self, *args) -> "int":
        """load(Fl_Browser self, char const * filename) -> int"""
        return _fltk.Fl_Browser_load(self, *args)


    def swap(self, *args) -> "void":
        """swap(Fl_Browser self, int a, int b)"""
        return _fltk.Fl_Browser_swap(self, *args)


    def clear(self, *args) -> "void":
        """clear(Fl_Browser self)"""
        return _fltk.Fl_Browser_clear(self, *args)


    def size(self, *args) -> "void":
        """
        size(Fl_Browser self) -> int
        size(Fl_Browser self, int W, int H)
        """
        return _fltk.Fl_Browser_size(self, *args)


    def textsize(self, *args) -> "void":
        """
        textsize(Fl_Browser self) -> Fl_Fontsize
        textsize(Fl_Browser self, Fl_Fontsize newSize)
        """
        return _fltk.Fl_Browser_textsize(self, *args)

    TOP = _fltk.Fl_Browser_TOP
    BOTTOM = _fltk.Fl_Browser_BOTTOM
    MIDDLE = _fltk.Fl_Browser_MIDDLE

    def lineposition(self, *args) -> "void":
        """lineposition(Fl_Browser self, int line, Fl_Browser::Fl_Line_Position pos)"""
        return _fltk.Fl_Browser_lineposition(self, *args)


    def topline(self, *args) -> "void":
        """
        topline(Fl_Browser self) -> int
        topline(Fl_Browser self, int line)
        """
        return _fltk.Fl_Browser_topline(self, *args)


    def bottomline(self, *args) -> "void":
        """bottomline(Fl_Browser self, int line)"""
        return _fltk.Fl_Browser_bottomline(self, *args)


    def middleline(self, *args) -> "void":
        """middleline(Fl_Browser self, int line)"""
        return _fltk.Fl_Browser_middleline(self, *args)


    def select(self, *args) -> "int":
        """select(Fl_Browser self, int line, int val=1) -> int"""
        return _fltk.Fl_Browser_select(self, *args)


    def selected(self, *args) -> "int":
        """selected(Fl_Browser self, int line) -> int"""
        return _fltk.Fl_Browser_selected(self, *args)


    def show(self, *args) -> "void":
        """
        show(Fl_Browser self, int line)
        show(Fl_Browser self)
        """
        return _fltk.Fl_Browser_show(self, *args)


    def hide(self, *args) -> "void":
        """
        hide(Fl_Browser self, int line)
        hide(Fl_Browser self)
        """
        return _fltk.Fl_Browser_hide(self, *args)


    def visible(self, *args) -> "int":
        """visible(Fl_Browser self, int line) -> int"""
        return _fltk.Fl_Browser_visible(self, *args)


    def value(self, *args) -> "void":
        """
        value(Fl_Browser self) -> int
        value(Fl_Browser self, int line)
        """
        return _fltk.Fl_Browser_value(self, *args)


    def text(self, *args) -> "void":
        """
        text(Fl_Browser self, int line) -> char const
        text(Fl_Browser self, int line, char const * newtext)
        """
        return _fltk.Fl_Browser_text(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Browser self, int X, int Y, int W, int H, char const * L=None) -> Fl_Browser"""
        if self.__class__ == Fl_Browser:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Browser(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Browser
    __del__ = lambda self: None

    def format_char(self, *args) -> "void":
        """
        format_char(Fl_Browser self) -> char
        format_char(Fl_Browser self, char c)
        """
        return _fltk.Fl_Browser_format_char(self, *args)


    def column_char(self, *args) -> "void":
        """
        column_char(Fl_Browser self) -> char
        column_char(Fl_Browser self, char c)
        """
        return _fltk.Fl_Browser_column_char(self, *args)


    def displayed(self, *args) -> "int":
        """displayed(Fl_Browser self, int line) -> int"""
        return _fltk.Fl_Browser_displayed(self, *args)


    def make_visible(self, *args) -> "void":
        """make_visible(Fl_Browser self, int line)"""
        return _fltk.Fl_Browser_make_visible(self, *args)


    def icon(self, *args) -> "Fl_Image *":
        """
        icon(Fl_Browser self, int line, Fl_Image icon)
        icon(Fl_Browser self, int line) -> Fl_Image
        """
        return _fltk.Fl_Browser_icon(self, *args)


    def remove_icon(self, *args) -> "void":
        """remove_icon(Fl_Browser self, int line)"""
        return _fltk.Fl_Browser_remove_icon(self, *args)


    def replace(self, *args) -> "void":
        """replace(Fl_Browser self, int a, char const * b)"""
        return _fltk.Fl_Browser_replace(self, *args)


    def display(self, *args) -> "void":
        """display(Fl_Browser self, int line, int val=1)"""
        return _fltk.Fl_Browser_display(self, *args)


    def add(self, *args) -> "void":
        """add(Fl_Browser self, char const * text, PyObject * data=None)"""
        val = _fltk.Fl_Browser_add(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def insert(self, *args) -> "void":
        """insert(Fl_Browser self, int index, char const * text, PyObject * data=None)"""
        return _fltk.Fl_Browser_insert(self, *args)


    def get_data(self, *args) -> "PyObject *":
        """get_data(Fl_Browser self, int index) -> PyObject *"""
        return _fltk.Fl_Browser_get_data(self, *args)


    def data(self, *args) -> "PyObject *":
        """data(Fl_Browser self, int index, PyObject * data=None) -> PyObject *"""
        return _fltk.Fl_Browser_data(self, *args)


    def column_widths(self, *args) -> "void":
        """
        column_widths(Fl_Browser self) -> int const
        column_widths(Fl_Browser self, PyObject * widths)
        """
        return _fltk.Fl_Browser_column_widths(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Browser(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Browser self)"""
        return _fltk.Fl_Browser_draw(self, *args)


    def item_quick_height(self, *args) -> "int":
        """item_quick_height(Fl_Browser self, void * item) -> int"""
        return _fltk.Fl_Browser_item_quick_height(self, *args)


    def full_width(self, *args) -> "int":
        """full_width(Fl_Browser self) -> int"""
        return _fltk.Fl_Browser_full_width(self, *args)

Fl_Browser_swigregister = _fltk.Fl_Browser_swigregister
Fl_Browser_swigregister(Fl_Browser)

class Fl_File_Browser(Fl_Browser):
    """

    The Fl_File_Browser widget displays a list of filenames, optionally with 
    file-specific icons.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    FILES = _fltk.Fl_File_Browser_FILES
    DIRECTORIES = _fltk.Fl_File_Browser_DIRECTORIES

    def __init__(self, *args):
        """__init__(Fl_File_Browser self, int arg2, int arg3, int arg4, int arg5, char const * arg6=None) -> Fl_File_Browser"""
        if self.__class__ == Fl_File_Browser:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_File_Browser(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def iconsize(self, *args) -> "void":
        """
        iconsize(Fl_File_Browser self) -> uchar
        iconsize(Fl_File_Browser self, uchar s)
        """
        return _fltk.Fl_File_Browser_iconsize(self, *args)


    def filter(self, *args) -> "char const *":
        """
        filter(Fl_File_Browser self, char const * pattern)
        filter(Fl_File_Browser self) -> char const *
        """
        return _fltk.Fl_File_Browser_filter(self, *args)


    def textsize(self, *args) -> "void":
        """
        textsize(Fl_File_Browser self) -> Fl_Fontsize
        textsize(Fl_File_Browser self, Fl_Fontsize s)
        """
        return _fltk.Fl_File_Browser_textsize(self, *args)


    def filetype(self, *args) -> "void":
        """
        filetype(Fl_File_Browser self) -> int
        filetype(Fl_File_Browser self, int t)
        """
        return _fltk.Fl_File_Browser_filetype(self, *args)


    def load(self, *args) -> "int":
        """load(Fl_File_Browser self, PyObject * dObj, PyObject * sObj) -> int"""
        return _fltk.Fl_File_Browser_load(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_File_Browser
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_File_Browser(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_File_Browser self)"""
        return _fltk.Fl_File_Browser_draw(self, *args)


    def item_first(self, *args) -> "void *":
        """item_first(Fl_File_Browser self) -> void *"""
        return _fltk.Fl_File_Browser_item_first(self, *args)


    def item_next(self, *args) -> "void *":
        """item_next(Fl_File_Browser self, void * item) -> void *"""
        return _fltk.Fl_File_Browser_item_next(self, *args)


    def item_prev(self, *args) -> "void *":
        """item_prev(Fl_File_Browser self, void * item) -> void *"""
        return _fltk.Fl_File_Browser_item_prev(self, *args)


    def item_last(self, *args) -> "void *":
        """item_last(Fl_File_Browser self) -> void *"""
        return _fltk.Fl_File_Browser_item_last(self, *args)


    def item_height(self, *args) -> "int":
        """item_height(Fl_File_Browser self, void * item) -> int"""
        return _fltk.Fl_File_Browser_item_height(self, *args)


    def item_width(self, *args) -> "int":
        """item_width(Fl_File_Browser self, void * item) -> int"""
        return _fltk.Fl_File_Browser_item_width(self, *args)


    def item_quick_height(self, *args) -> "int":
        """item_quick_height(Fl_File_Browser self, void * item) -> int"""
        return _fltk.Fl_File_Browser_item_quick_height(self, *args)


    def item_draw(self, *args) -> "void":
        """item_draw(Fl_File_Browser self, void * item, int X, int Y, int W, int H)"""
        return _fltk.Fl_File_Browser_item_draw(self, *args)


    def item_text(self, *args) -> "char const *":
        """item_text(Fl_File_Browser self, void * item) -> char const *"""
        return _fltk.Fl_File_Browser_item_text(self, *args)


    def item_swap(self, *args) -> "void":
        """item_swap(Fl_File_Browser self, void * a, void * b)"""
        return _fltk.Fl_File_Browser_item_swap(self, *args)


    def item_at(self, *args) -> "void *":
        """item_at(Fl_File_Browser self, int line) -> void *"""
        return _fltk.Fl_File_Browser_item_at(self, *args)


    def full_width(self, *args) -> "int":
        """full_width(Fl_File_Browser self) -> int"""
        return _fltk.Fl_File_Browser_full_width(self, *args)


    def full_height(self, *args) -> "int":
        """full_height(Fl_File_Browser self) -> int"""
        return _fltk.Fl_File_Browser_full_height(self, *args)


    def incr_height(self, *args) -> "int":
        """incr_height(Fl_File_Browser self) -> int"""
        return _fltk.Fl_File_Browser_incr_height(self, *args)


    def item_select(self, *args) -> "void":
        """item_select(Fl_File_Browser self, void * item, int val)"""
        return _fltk.Fl_File_Browser_item_select(self, *args)


    def item_selected(self, *args) -> "int":
        """item_selected(Fl_File_Browser self, void * item) -> int"""
        return _fltk.Fl_File_Browser_item_selected(self, *args)

Fl_File_Browser_swigregister = _fltk.Fl_File_Browser_swigregister
Fl_File_Browser_swigregister(Fl_File_Browser)

FL_ALPHASORT = _fltk.FL_ALPHASORT
FL_CASEALPHASORT = _fltk.FL_CASEALPHASORT
FL_CASENUMERICSORT = _fltk.FL_CASENUMERICSORT
FL_NUMERICSORT = _fltk.FL_NUMERICSORT
class Fl_File_Icon(object):
    """

    The Fl_File_Icon class manages icon images that can be used as labels in 
    other widgets and as icons in the FileBrowser widget.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    ANY = _fltk.Fl_File_Icon_ANY
    PLAIN = _fltk.Fl_File_Icon_PLAIN
    FIFO = _fltk.Fl_File_Icon_FIFO
    DEVICE = _fltk.Fl_File_Icon_DEVICE
    LINK = _fltk.Fl_File_Icon_LINK
    DIRECTORY = _fltk.Fl_File_Icon_DIRECTORY
    END = _fltk.Fl_File_Icon_END
    COLOR = _fltk.Fl_File_Icon_COLOR
    LINE = _fltk.Fl_File_Icon_LINE
    CLOSEDLINE = _fltk.Fl_File_Icon_CLOSEDLINE
    POLYGON = _fltk.Fl_File_Icon_POLYGON
    OUTLINEPOLYGON = _fltk.Fl_File_Icon_OUTLINEPOLYGON
    VERTEX = _fltk.Fl_File_Icon_VERTEX

    def __init__(self, *args):
        """__init__(Fl_File_Icon self, char const * p, int t, int nd=0, short * d=None) -> Fl_File_Icon"""
        this = _fltk.new_Fl_File_Icon(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_File_Icon
    __del__ = lambda self: None

    def add(self, *args) -> "short *":
        """add(Fl_File_Icon self, short d) -> short *"""
        return _fltk.Fl_File_Icon_add(self, *args)


    def add_color(self, *args) -> "short *":
        """add_color(Fl_File_Icon self, Fl_Color c) -> short *"""
        return _fltk.Fl_File_Icon_add_color(self, *args)


    def add_vertex(self, *args) -> "short *":
        """
        add_vertex(Fl_File_Icon self, int x, int y) -> short
        add_vertex(Fl_File_Icon self, float x, float y) -> short *
        """
        return _fltk.Fl_File_Icon_add_vertex(self, *args)


    def clear(self, *args) -> "void":
        """clear(Fl_File_Icon self)"""
        return _fltk.Fl_File_Icon_clear(self, *args)


    def draw(self, *args) -> "void":
        """draw(Fl_File_Icon self, int x, int y, int w, int h, Fl_Color ic, int active=1)"""
        return _fltk.Fl_File_Icon_draw(self, *args)


    def label(self, *args) -> "void":
        """label(Fl_File_Icon self, Fl_Widget w)"""
        return _fltk.Fl_File_Icon_label(self, *args)


    def labeltype(*args) -> "void":
        """labeltype(Fl_Label o, int x, int y, int w, int h, Fl_Align a)"""
        return _fltk.Fl_File_Icon_labeltype(*args)

    labeltype = staticmethod(labeltype)

    def load(self, *args) -> "void":
        """load(Fl_File_Icon self, char const * f)"""
        return _fltk.Fl_File_Icon_load(self, *args)


    def load_fti(self, *args) -> "int":
        """load_fti(Fl_File_Icon self, char const * fti) -> int"""
        return _fltk.Fl_File_Icon_load_fti(self, *args)


    def load_image(self, *args) -> "int":
        """load_image(Fl_File_Icon self, char const * i) -> int"""
        return _fltk.Fl_File_Icon_load_image(self, *args)


    def next(self, *args) -> "Fl_File_Icon *":
        """next(Fl_File_Icon self) -> Fl_File_Icon"""
        return _fltk.Fl_File_Icon_next(self, *args)


    def pattern(self, *args) -> "char const *":
        """pattern(Fl_File_Icon self) -> char const *"""
        return _fltk.Fl_File_Icon_pattern(self, *args)


    def size(self, *args) -> "int":
        """size(Fl_File_Icon self) -> int"""
        return _fltk.Fl_File_Icon_size(self, *args)


    def type(self, *args) -> "int":
        """type(Fl_File_Icon self) -> int"""
        return _fltk.Fl_File_Icon_type(self, *args)


    def value(self, *args) -> "short *":
        """value(Fl_File_Icon self) -> short *"""
        return _fltk.Fl_File_Icon_value(self, *args)


    def find(*args) -> "Fl_File_Icon *":
        """find(char const * filename, int filetype) -> Fl_File_Icon"""
        return _fltk.Fl_File_Icon_find(*args)

    find = staticmethod(find)

    def first(*args) -> "Fl_File_Icon *":
        """first() -> Fl_File_Icon"""
        return _fltk.Fl_File_Icon_first(*args)

    first = staticmethod(first)

    def load_system_icons(*args) -> "void":
        """load_system_icons()"""
        return _fltk.Fl_File_Icon_load_system_icons(*args)

    load_system_icons = staticmethod(load_system_icons)
Fl_File_Icon_swigregister = _fltk.Fl_File_Icon_swigregister
Fl_File_Icon_swigregister(Fl_File_Icon)

def Fl_File_Icon_labeltype(*args) -> "void":
    """Fl_File_Icon_labeltype(Fl_Label o, int x, int y, int w, int h, Fl_Align a)"""
    return _fltk.Fl_File_Icon_labeltype(*args)

def Fl_File_Icon_find(*args) -> "Fl_File_Icon *":
    """Fl_File_Icon_find(char const * filename, int filetype) -> Fl_File_Icon"""
    return _fltk.Fl_File_Icon_find(*args)

def Fl_File_Icon_first(*args) -> "Fl_File_Icon *":
    """Fl_File_Icon_first() -> Fl_File_Icon"""
    return _fltk.Fl_File_Icon_first(*args)

def Fl_File_Icon_load_system_icons(*args) -> "void":
    """Fl_File_Icon_load_system_icons()"""
    return _fltk.Fl_File_Icon_load_system_icons(*args)

class Fl_File_Chooser(object):
    """

    The Fl_File_Chooser widget displays a standard file selection dialog that 
    supports various selection modes.

    The Fl_File_Chooser class also exports several static values that may be used 
    to localize or customize the appearance of all file chooser dialogs:
    Member 	Default value
    add_favorites_label 	'Add to Favorites'
    all_files_label 	'All Files (*)'
    custom_filter_label 	'Custom Filter'
    existing_file_label 	'Please choose an existing file!'
    favorites_label 	'Favorites'
    filename_label 		'Filename:'
    filesystems_label 	'My Computer' (WIN32)
    			'File Systems' (all others)
    manage_favorites_label 	'Manage Favorites'
    new_directory_label 	'New Directory?'
    new_directory_tooltip 	'Create a new directory.'
    preview_label 		'Preview'
    save_label 		'Save'
    show_label 		'Show:'
    sort 			fl_numericsort

    The sort member specifies the sort function that is used when loading the 
    contents of a directory. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    SINGLE = _fltk.Fl_File_Chooser_SINGLE
    MULTI = _fltk.Fl_File_Chooser_MULTI
    CREATE = _fltk.Fl_File_Chooser_CREATE
    DIRECTORY = _fltk.Fl_File_Chooser_DIRECTORY

    def __init__(self, *args):
        """__init__(Fl_File_Chooser self, char const * d, char const * p, int t, char const * title) -> Fl_File_Chooser"""
        this = _fltk.new_Fl_File_Chooser(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_File_Chooser
    __del__ = lambda self: None

    def color(self, *args) -> "Fl_Color":
        """
        color(Fl_File_Chooser self, Fl_Color c)
        color(Fl_File_Chooser self) -> Fl_Color
        """
        return _fltk.Fl_File_Chooser_color(self, *args)


    def count(self, *args) -> "int":
        """count(Fl_File_Chooser self) -> int"""
        return _fltk.Fl_File_Chooser_count(self, *args)


    def directory(self, *args) -> "char *":
        """
        directory(Fl_File_Chooser self, char const * d)
        directory(Fl_File_Chooser self) -> char *
        """
        return _fltk.Fl_File_Chooser_directory(self, *args)


    def filter(self, *args) -> "char const *":
        """
        filter(Fl_File_Chooser self, char const * p)
        filter(Fl_File_Chooser self) -> char const *
        """
        return _fltk.Fl_File_Chooser_filter(self, *args)


    def filter_value(self, *args) -> "void":
        """
        filter_value(Fl_File_Chooser self) -> int
        filter_value(Fl_File_Chooser self, int f)
        """
        return _fltk.Fl_File_Chooser_filter_value(self, *args)


    def hide(self, *args) -> "void":
        """hide(Fl_File_Chooser self)"""
        return _fltk.Fl_File_Chooser_hide(self, *args)


    def iconsize(self, *args) -> "uchar":
        """
        iconsize(Fl_File_Chooser self, uchar s)
        iconsize(Fl_File_Chooser self) -> uchar
        """
        return _fltk.Fl_File_Chooser_iconsize(self, *args)


    def label(self, *args) -> "char const *":
        """
        label(Fl_File_Chooser self, char const * l)
        label(Fl_File_Chooser self) -> char const *
        """
        return _fltk.Fl_File_Chooser_label(self, *args)


    def ok_label(self, *args) -> "char const *":
        """
        ok_label(Fl_File_Chooser self, char const * l)
        ok_label(Fl_File_Chooser self) -> char const *
        """
        return _fltk.Fl_File_Chooser_ok_label(self, *args)


    def preview(self, *args) -> "int":
        """
        preview(Fl_File_Chooser self, int e)
        preview(Fl_File_Chooser self) -> int
        """
        return _fltk.Fl_File_Chooser_preview(self, *args)


    def rescan(self, *args) -> "void":
        """rescan(Fl_File_Chooser self)"""
        return _fltk.Fl_File_Chooser_rescan(self, *args)


    def show(self, *args) -> "void":
        """show(Fl_File_Chooser self)"""
        return _fltk.Fl_File_Chooser_show(self, *args)


    def shown(self, *args) -> "int":
        """shown(Fl_File_Chooser self) -> int"""
        return _fltk.Fl_File_Chooser_shown(self, *args)


    def textcolor(self, *args) -> "Fl_Color":
        """
        textcolor(Fl_File_Chooser self, Fl_Color c)
        textcolor(Fl_File_Chooser self) -> Fl_Color
        """
        return _fltk.Fl_File_Chooser_textcolor(self, *args)


    def textfont(self, *args) -> "Fl_Font":
        """
        textfont(Fl_File_Chooser self, Fl_Font f)
        textfont(Fl_File_Chooser self) -> Fl_Font
        """
        return _fltk.Fl_File_Chooser_textfont(self, *args)


    def textsize(self, *args) -> "Fl_Fontsize":
        """
        textsize(Fl_File_Chooser self, Fl_Fontsize s)
        textsize(Fl_File_Chooser self) -> Fl_Fontsize
        """
        return _fltk.Fl_File_Chooser_textsize(self, *args)


    def type(self, *args) -> "int":
        """
        type(Fl_File_Chooser self, int t)
        type(Fl_File_Chooser self) -> int
        """
        return _fltk.Fl_File_Chooser_type(self, *args)


    def user_data(self, *args) -> "void":
        """
        user_data(Fl_File_Chooser self)
        user_data(Fl_File_Chooser self, void * d)
        """
        return _fltk.Fl_File_Chooser_user_data(self, *args)


    def value(self, *args) -> "void":
        """
        value(Fl_File_Chooser self, int f=1) -> char const
        value(Fl_File_Chooser self, char const * filename)
        """
        return _fltk.Fl_File_Chooser_value(self, *args)


    def visible(self, *args) -> "int":
        """visible(Fl_File_Chooser self) -> int"""
        return _fltk.Fl_File_Chooser_visible(self, *args)


    def add_extra(self, *args) -> "Fl_Widget *":
        """add_extra(Fl_File_Chooser self, Fl_Widget gr) -> Fl_Widget"""
        return _fltk.Fl_File_Chooser_add_extra(self, *args)


    def callback(self, *args) -> "void":
        """
        callback(Fl_File_Chooser self, void (*)(Fl_File_Chooser *,void *) cb, void * d=None)
        callback(Fl_File_Chooser self, PyObject * PyFunc, PyObject * PyWidget, PyObject * PyData=None)
        """
        return _fltk.Fl_File_Chooser_callback(self, *args)

Fl_File_Chooser_swigregister = _fltk.Fl_File_Chooser_swigregister
Fl_File_Chooser_swigregister(Fl_File_Chooser)


def fl_dir_chooser(*args) -> "char *":
    """fl_dir_chooser(char const * message, char const * fname, int relative=0) -> char *"""
    return _fltk.fl_dir_chooser(*args)

def fl_file_chooser(*args) -> "char *":
    """fl_file_chooser(char const * message, char const * pat, char const * fname, int relative=0) -> char *"""
    return _fltk.fl_file_chooser(*args)

def fl_file_chooser_callback(*args) -> "void":
    """fl_file_chooser_callback(void (*)(char const *) cb)"""
    return _fltk.fl_file_chooser_callback(*args)

def fl_file_chooser_ok_label(*args) -> "void":
    """fl_file_chooser_ok_label(char const * l)"""
    return _fltk.fl_file_chooser_ok_label(*args)
class Fl(object):
    """
    The Fl class is the FLTK global (static) class containing state 
    information and global methods for the current application.
    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def call_screen_init(*args) -> "void":
        """call_screen_init()"""
        return _fltk.Fl_call_screen_init(*args)

    call_screen_init = staticmethod(call_screen_init)
    OPTION_ARROW_FOCUS = _fltk.Fl_OPTION_ARROW_FOCUS
    OPTION_VISIBLE_FOCUS = _fltk.Fl_OPTION_VISIBLE_FOCUS
    OPTION_DND_TEXT = _fltk.Fl_OPTION_DND_TEXT
    OPTION_SHOW_TOOLTIPS = _fltk.Fl_OPTION_SHOW_TOOLTIPS
    OPTION_FNFC_USES_GTK = _fltk.Fl_OPTION_FNFC_USES_GTK
    OPTION_LAST = _fltk.Fl_OPTION_LAST

    def option(*args) -> "void":
        """
        option(Fl::Fl_Option opt) -> bool
        option(Fl::Fl_Option opt, bool val)
        """
        return _fltk.Fl_option(*args)

    option = staticmethod(option)

    def add_awake_handler_(*args) -> "int":
        """add_awake_handler_(Fl_Awake_Handler arg1, void * arg2) -> int"""
        return _fltk.Fl_add_awake_handler_(*args)

    add_awake_handler_ = staticmethod(add_awake_handler_)

    def version(*args) -> "double":
        """version() -> double"""
        return _fltk.Fl_version(*args)

    version = staticmethod(version)

    def api_version(*args) -> "int":
        """api_version() -> int"""
        return _fltk.Fl_api_version(*args)

    api_version = staticmethod(api_version)

    def abi_version(*args) -> "int":
        """abi_version() -> int"""
        return _fltk.Fl_abi_version(*args)

    abi_version = staticmethod(abi_version)

    def abi_check(*args) -> "int":
        """abi_check(int const val) -> int"""
        return _fltk.Fl_abi_check(*args)

    abi_check = staticmethod(abi_check)

    def arg(*args) -> "int":
        """arg(int argc, char ** argv, int & i) -> int"""
        return _fltk.Fl_arg(*args)

    arg = staticmethod(arg)

    def args(*args) -> "void":
        """
        args(int argc, char ** argv, int & i, Fl_Args_Handler cb=None) -> int
        args(int argc, char ** argv)
        """
        return _fltk.Fl_args(*args)

    args = staticmethod(args)

    def display(*args) -> "void":
        """display(char const * arg1)"""
        return _fltk.Fl_display(*args)

    display = staticmethod(display)

    def visual(*args) -> "int":
        """visual(int arg1) -> int"""
        return _fltk.Fl_visual(*args)

    visual = staticmethod(visual)

    def own_colormap(*args) -> "void":
        """own_colormap()"""
        return _fltk.Fl_own_colormap(*args)

    own_colormap = staticmethod(own_colormap)

    def get_system_colors(*args) -> "void":
        """get_system_colors()"""
        return _fltk.Fl_get_system_colors(*args)

    get_system_colors = staticmethod(get_system_colors)

    def foreground(*args) -> "void":
        """foreground(uchar arg1, uchar arg2, uchar arg3)"""
        return _fltk.Fl_foreground(*args)

    foreground = staticmethod(foreground)

    def background(*args) -> "void":
        """background(uchar arg1, uchar arg2, uchar arg3)"""
        return _fltk.Fl_background(*args)

    background = staticmethod(background)

    def background2(*args) -> "void":
        """background2(uchar arg1, uchar arg2, uchar arg3)"""
        return _fltk.Fl_background2(*args)

    background2 = staticmethod(background2)

    def scheme(*args) -> "char const *":
        """
        scheme(char const * name) -> int
        scheme() -> char const *
        """
        return _fltk.Fl_scheme(*args)

    scheme = staticmethod(scheme)

    def is_scheme(*args) -> "int":
        """is_scheme(char const * name) -> int"""
        return _fltk.Fl_is_scheme(*args)

    is_scheme = staticmethod(is_scheme)

    def reload_scheme(*args) -> "int":
        """reload_scheme() -> int"""
        return _fltk.Fl_reload_scheme(*args)

    reload_scheme = staticmethod(reload_scheme)

    def scrollbar_size(*args) -> "void":
        """
        scrollbar_size() -> int
        scrollbar_size(int W)
        """
        return _fltk.Fl_scrollbar_size(*args)

    scrollbar_size = staticmethod(scrollbar_size)

    def wait(*args) -> "double":
        """
        wait() -> int
        wait(double time) -> double
        """
        return _fltk.Fl_wait(*args)

    wait = staticmethod(wait)

    def check(*args) -> "int":
        """check() -> int"""
        return _fltk.Fl_check(*args)

    check = staticmethod(check)

    def ready(*args) -> "int":
        """ready() -> int"""
        return _fltk.Fl_ready(*args)

    ready = staticmethod(ready)

    def run(*args) -> "int":
        """run() -> int"""
        return _fltk.Fl_run(*args)

    run = staticmethod(run)

    def readqueue(*args) -> "Fl_Widget *":
        """readqueue() -> Fl_Widget"""
        return _fltk.Fl_readqueue(*args)

    readqueue = staticmethod(readqueue)

    def has_timeout(*args) -> "int":
        """has_timeout(Fl_Timeout_Handler arg1, void * arg2=None) -> int"""
        return _fltk.Fl_has_timeout(*args)

    has_timeout = staticmethod(has_timeout)

    def add_idle(*args) -> "void":
        """add_idle(Fl_Idle_Handler cb, void * data=None)"""
        return _fltk.Fl_add_idle(*args)

    add_idle = staticmethod(add_idle)

    def has_idle(*args) -> "int":
        """has_idle(Fl_Idle_Handler cb, void * data=None) -> int"""
        return _fltk.Fl_has_idle(*args)

    has_idle = staticmethod(has_idle)

    def remove_idle(*args) -> "void":
        """remove_idle(Fl_Idle_Handler cb, void * data=None)"""
        return _fltk.Fl_remove_idle(*args)

    remove_idle = staticmethod(remove_idle)

    def damage(*args) -> "int":
        """
        damage(int d)
        damage() -> int
        """
        return _fltk.Fl_damage(*args)

    damage = staticmethod(damage)

    def redraw(*args) -> "void":
        """redraw()"""
        return _fltk.Fl_redraw(*args)

    redraw = staticmethod(redraw)

    def flush(*args) -> "void":
        """flush()"""
        return _fltk.Fl_flush(*args)

    flush = staticmethod(flush)

    def first_window(*args) -> "void":
        """
        first_window() -> Fl_Window
        first_window(Fl_Window arg1)
        """
        return _fltk.Fl_first_window(*args)

    first_window = staticmethod(first_window)

    def next_window(*args) -> "Fl_Window *":
        """next_window(Fl_Window arg1) -> Fl_Window"""
        return _fltk.Fl_next_window(*args)

    next_window = staticmethod(next_window)

    def modal(*args) -> "Fl_Window *":
        """modal() -> Fl_Window"""
        return _fltk.Fl_modal(*args)

    modal = staticmethod(modal)

    def grab(*args) -> "void":
        """
        grab() -> Fl_Window
        grab(Fl_Window arg1)
        """
        return _fltk.Fl_grab(*args)

    grab = staticmethod(grab)

    def event(*args) -> "int":
        """event() -> int"""
        return _fltk.Fl_event(*args)

    event = staticmethod(event)

    def event_x(*args) -> "int":
        """event_x() -> int"""
        return _fltk.Fl_event_x(*args)

    event_x = staticmethod(event_x)

    def event_y(*args) -> "int":
        """event_y() -> int"""
        return _fltk.Fl_event_y(*args)

    event_y = staticmethod(event_y)

    def event_x_root(*args) -> "int":
        """event_x_root() -> int"""
        return _fltk.Fl_event_x_root(*args)

    event_x_root = staticmethod(event_x_root)

    def event_y_root(*args) -> "int":
        """event_y_root() -> int"""
        return _fltk.Fl_event_y_root(*args)

    event_y_root = staticmethod(event_y_root)

    def event_dx(*args) -> "int":
        """event_dx() -> int"""
        return _fltk.Fl_event_dx(*args)

    event_dx = staticmethod(event_dx)

    def event_dy(*args) -> "int":
        """event_dy() -> int"""
        return _fltk.Fl_event_dy(*args)

    event_dy = staticmethod(event_dy)

    def get_mouse(*args) -> "void":
        """get_mouse(int & arg1, int & arg2)"""
        return _fltk.Fl_get_mouse(*args)

    get_mouse = staticmethod(get_mouse)

    def event_clicks(*args) -> "void":
        """
        event_clicks() -> int
        event_clicks(int i)
        """
        return _fltk.Fl_event_clicks(*args)

    event_clicks = staticmethod(event_clicks)

    def event_is_click(*args) -> "void":
        """
        event_is_click() -> int
        event_is_click(int i)
        """
        return _fltk.Fl_event_is_click(*args)

    event_is_click = staticmethod(event_is_click)

    def event_button(*args) -> "int":
        """event_button() -> int"""
        return _fltk.Fl_event_button(*args)

    event_button = staticmethod(event_button)

    def event_state(*args) -> "int":
        """
        event_state() -> int
        event_state(int mask) -> int
        """
        return _fltk.Fl_event_state(*args)

    event_state = staticmethod(event_state)

    def event_original_key(*args) -> "int":
        """event_original_key() -> int"""
        return _fltk.Fl_event_original_key(*args)

    event_original_key = staticmethod(event_original_key)

    def event_key(*args) -> "int":
        """
        event_key() -> int
        event_key(int key) -> int
        """
        return _fltk.Fl_event_key(*args)

    event_key = staticmethod(event_key)

    def get_key(*args) -> "int":
        """get_key(int key) -> int"""
        return _fltk.Fl_get_key(*args)

    get_key = staticmethod(get_key)

    def event_text(*args) -> "char const *":
        """event_text() -> char const *"""
        return _fltk.Fl_event_text(*args)

    event_text = staticmethod(event_text)

    def event_length(*args) -> "int":
        """event_length() -> int"""
        return _fltk.Fl_event_length(*args)

    event_length = staticmethod(event_length)

    def event_clipboard(*args) -> "void *":
        """event_clipboard() -> void *"""
        return _fltk.Fl_event_clipboard(*args)

    event_clipboard = staticmethod(event_clipboard)

    def event_clipboard_type(*args) -> "char const *":
        """event_clipboard_type() -> char const *"""
        return _fltk.Fl_event_clipboard_type(*args)

    event_clipboard_type = staticmethod(event_clipboard_type)

    def compose(*args) -> "int":
        """compose(int & arg1) -> int"""
        return _fltk.Fl_compose(*args)

    compose = staticmethod(compose)

    def compose_reset(*args) -> "void":
        """compose_reset()"""
        return _fltk.Fl_compose_reset(*args)

    compose_reset = staticmethod(compose_reset)

    def event_inside(*args) -> "int":
        """
        event_inside(int arg1, int arg2, int arg3, int arg4) -> int
        event_inside(Fl_Widget arg1) -> int
        """
        return _fltk.Fl_event_inside(*args)

    event_inside = staticmethod(event_inside)

    def test_shortcut(*args) -> "int":
        """test_shortcut(Fl_Shortcut arg1) -> int"""
        return _fltk.Fl_test_shortcut(*args)

    test_shortcut = staticmethod(test_shortcut)

    def enable_im(*args) -> "void":
        """enable_im()"""
        return _fltk.Fl_enable_im(*args)

    enable_im = staticmethod(enable_im)

    def disable_im(*args) -> "void":
        """disable_im()"""
        return _fltk.Fl_disable_im(*args)

    disable_im = staticmethod(disable_im)

    def handle(*args) -> "int":
        """handle(int arg1, Fl_Window arg2) -> int"""
        return _fltk.Fl_handle(*args)

    handle = staticmethod(handle)

    def handle_(*args) -> "int":
        """handle_(int arg1, Fl_Window arg2) -> int"""
        return _fltk.Fl_handle_(*args)

    handle_ = staticmethod(handle_)

    def belowmouse(*args) -> "void":
        """
        belowmouse() -> Fl_Widget
        belowmouse(Fl_Widget arg1)
        """
        return _fltk.Fl_belowmouse(*args)

    belowmouse = staticmethod(belowmouse)

    def pushed(*args) -> "void":
        """
        pushed() -> Fl_Widget
        pushed(Fl_Widget arg1)
        """
        return _fltk.Fl_pushed(*args)

    pushed = staticmethod(pushed)

    def focus(*args) -> "void":
        """
        focus() -> Fl_Widget
        focus(Fl_Widget arg1)
        """
        return _fltk.Fl_focus(*args)

    focus = staticmethod(focus)

    def add_system_handler(*args) -> "void":
        """add_system_handler(Fl_System_Handler h, void * data)"""
        return _fltk.Fl_add_system_handler(*args)

    add_system_handler = staticmethod(add_system_handler)

    def remove_system_handler(*args) -> "void":
        """remove_system_handler(Fl_System_Handler h)"""
        return _fltk.Fl_remove_system_handler(*args)

    remove_system_handler = staticmethod(remove_system_handler)

    def event_dispatch(*args) -> "Fl_Event_Dispatch":
        """
        event_dispatch(Fl_Event_Dispatch d)
        event_dispatch() -> Fl_Event_Dispatch
        """
        return _fltk.Fl_event_dispatch(*args)

    event_dispatch = staticmethod(event_dispatch)

    def copy(*args) -> "void":
        """
        copy(char const * stuff, int len, int destination, char const * type)
        copy(char const * stuff, int len, int destination=0)
        """
        return _fltk.Fl_copy(*args)

    copy = staticmethod(copy)

    def add_clipboard_notify(*args) -> "void":
        """add_clipboard_notify(Fl_Clipboard_Notify_Handler h, void * data=None)"""
        return _fltk.Fl_add_clipboard_notify(*args)

    add_clipboard_notify = staticmethod(add_clipboard_notify)

    def remove_clipboard_notify(*args) -> "void":
        """remove_clipboard_notify(Fl_Clipboard_Notify_Handler h)"""
        return _fltk.Fl_remove_clipboard_notify(*args)

    remove_clipboard_notify = staticmethod(remove_clipboard_notify)

    def clipboard_contains(*args) -> "int":
        """clipboard_contains(char const * type) -> int"""
        return _fltk.Fl_clipboard_contains(*args)

    clipboard_contains = staticmethod(clipboard_contains)

    def dnd(*args) -> "int":
        """dnd() -> int"""
        return _fltk.Fl_dnd(*args)

    dnd = staticmethod(dnd)

    def selection_owner(*args) -> "void":
        """
        selection_owner() -> Fl_Widget
        selection_owner(Fl_Widget arg1)
        """
        return _fltk.Fl_selection_owner(*args)

    selection_owner = staticmethod(selection_owner)

    def selection(*args) -> "void":
        """selection(Fl_Widget owner, char const * arg2, int len)"""
        return _fltk.Fl_selection(*args)

    selection = staticmethod(selection)

    def paste(*args) -> "void":
        """
        paste(Fl_Widget receiver, int source, char const * type)
        paste(Fl_Widget receiver, int source)
        paste(Fl_Widget receiver)
        """
        return _fltk.Fl_paste(*args)

    paste = staticmethod(paste)

    def x(*args) -> "int":
        """x() -> int"""
        return _fltk.Fl_x(*args)

    x = staticmethod(x)

    def y(*args) -> "int":
        """y() -> int"""
        return _fltk.Fl_y(*args)

    y = staticmethod(y)

    def w(*args) -> "int":
        """w() -> int"""
        return _fltk.Fl_w(*args)

    w = staticmethod(w)

    def h(*args) -> "int":
        """h() -> int"""
        return _fltk.Fl_h(*args)

    h = staticmethod(h)

    def screen_count(*args) -> "int":
        """screen_count() -> int"""
        return _fltk.Fl_screen_count(*args)

    screen_count = staticmethod(screen_count)

    def screen_xywh(*args) -> "void":
        """
        screen_xywh(int & X, int & Y, int & W, int & H)
        screen_xywh(int & X, int & Y, int & W, int & H, int mx, int my)
        screen_xywh(int & X, int & Y, int & W, int & H, int n)
        screen_xywh(int & X, int & Y, int & W, int & H, int mx, int my, int mw, int mh)
        """
        return _fltk.Fl_screen_xywh(*args)

    screen_xywh = staticmethod(screen_xywh)

    def screen_num(*args) -> "int":
        """
        screen_num(int x, int y) -> int
        screen_num(int x, int y, int w, int h) -> int
        """
        return _fltk.Fl_screen_num(*args)

    screen_num = staticmethod(screen_num)

    def screen_dpi(*args) -> "void":
        """screen_dpi(float & h, float & v, int n=0)"""
        return _fltk.Fl_screen_dpi(*args)

    screen_dpi = staticmethod(screen_dpi)

    def screen_work_area(*args) -> "void":
        """
        screen_work_area(int & X, int & Y, int & W, int & H, int mx, int my)
        screen_work_area(int & X, int & Y, int & W, int & H, int n)
        screen_work_area(int & X, int & Y, int & W, int & H)
        """
        return _fltk.Fl_screen_work_area(*args)

    screen_work_area = staticmethod(screen_work_area)

    def set_color(*args) -> "void":
        """
        set_color(Fl_Color arg1, uchar arg2, uchar arg3, uchar arg4)
        set_color(Fl_Color i, unsigned int c)
        """
        return _fltk.Fl_set_color(*args)

    set_color = staticmethod(set_color)

    def get_color(*args) -> "uchar &, uchar &, uchar &":
        """get_color(Fl_Color i)"""
        return _fltk.Fl_get_color(*args)

    get_color = staticmethod(get_color)

    def free_color(*args) -> "void":
        """free_color(Fl_Color i, int overlay=0)"""
        return _fltk.Fl_free_color(*args)

    free_color = staticmethod(free_color)

    def get_font(*args) -> "char const *":
        """get_font(Fl_Font arg1) -> char const *"""
        return _fltk.Fl_get_font(*args)

    get_font = staticmethod(get_font)

    def get_font_name(*args) -> "int *":
        """get_font_name(Fl_Font arg1) -> char const *"""
        return _fltk.Fl_get_font_name(*args)

    get_font_name = staticmethod(get_font_name)

    def set_font(*args) -> "void":
        """
        set_font(Fl_Font arg1, char const * arg2)
        set_font(Fl_Font arg1, Fl_Font arg2)
        """
        return _fltk.Fl_set_font(*args)

    set_font = staticmethod(set_font)

    def set_fonts(*args) -> "Fl_Font":
        """set_fonts(char const * arg1=None) -> Fl_Font"""
        return _fltk.Fl_set_fonts(*args)

    set_fonts = staticmethod(set_fonts)

    def set_labeltype(*args) -> "void":
        """set_labeltype(Fl_Labeltype arg1, Fl_Label_Draw_F * arg2, Fl_Label_Measure_F * arg3)"""
        return _fltk.Fl_set_labeltype(*args)

    set_labeltype = staticmethod(set_labeltype)

    def get_boxtype(*args) -> "Fl_Box_Draw_F *":
        """get_boxtype(Fl_Boxtype arg1) -> Fl_Box_Draw_F *"""
        return _fltk.Fl_get_boxtype(*args)

    get_boxtype = staticmethod(get_boxtype)

    def set_boxtype(*args) -> "void":
        """
        set_boxtype(Fl_Boxtype arg1, Fl_Box_Draw_F * arg2, uchar arg3, uchar arg4, uchar arg5, uchar arg6)
        set_boxtype(Fl_Boxtype arg1, Fl_Boxtype arg2)
        """
        return _fltk.Fl_set_boxtype(*args)

    set_boxtype = staticmethod(set_boxtype)

    def box_dx(*args) -> "int":
        """box_dx(Fl_Boxtype arg1) -> int"""
        return _fltk.Fl_box_dx(*args)

    box_dx = staticmethod(box_dx)

    def box_dy(*args) -> "int":
        """box_dy(Fl_Boxtype arg1) -> int"""
        return _fltk.Fl_box_dy(*args)

    box_dy = staticmethod(box_dy)

    def box_dw(*args) -> "int":
        """box_dw(Fl_Boxtype arg1) -> int"""
        return _fltk.Fl_box_dw(*args)

    box_dw = staticmethod(box_dw)

    def box_dh(*args) -> "int":
        """box_dh(Fl_Boxtype arg1) -> int"""
        return _fltk.Fl_box_dh(*args)

    box_dh = staticmethod(box_dh)

    def draw_box_active(*args) -> "int":
        """draw_box_active() -> int"""
        return _fltk.Fl_draw_box_active(*args)

    draw_box_active = staticmethod(draw_box_active)

    def box_color(*args) -> "Fl_Color":
        """box_color(Fl_Color arg1) -> Fl_Color"""
        return _fltk.Fl_box_color(*args)

    box_color = staticmethod(box_color)

    def set_box_color(*args) -> "void":
        """set_box_color(Fl_Color arg1)"""
        return _fltk.Fl_set_box_color(*args)

    set_box_color = staticmethod(set_box_color)

    def set_abort(*args) -> "void":
        """set_abort(Fl_Abort_Handler f)"""
        return _fltk.Fl_set_abort(*args)

    set_abort = staticmethod(set_abort)

    def default_atclose(*args) -> "void":
        """default_atclose(Fl_Window arg1, void * arg2)"""
        return _fltk.Fl_default_atclose(*args)

    default_atclose = staticmethod(default_atclose)

    def set_atclose(*args) -> "void":
        """set_atclose(Fl_Atclose_Handler f)"""
        return _fltk.Fl_set_atclose(*args)

    set_atclose = staticmethod(set_atclose)

    def event_shift(*args) -> "int":
        """event_shift() -> int"""
        return _fltk.Fl_event_shift(*args)

    event_shift = staticmethod(event_shift)

    def event_ctrl(*args) -> "int":
        """event_ctrl() -> int"""
        return _fltk.Fl_event_ctrl(*args)

    event_ctrl = staticmethod(event_ctrl)

    def event_command(*args) -> "int":
        """event_command() -> int"""
        return _fltk.Fl_event_command(*args)

    event_command = staticmethod(event_command)

    def event_alt(*args) -> "int":
        """event_alt() -> int"""
        return _fltk.Fl_event_alt(*args)

    event_alt = staticmethod(event_alt)

    def event_buttons(*args) -> "int":
        """event_buttons() -> int"""
        return _fltk.Fl_event_buttons(*args)

    event_buttons = staticmethod(event_buttons)

    def event_button1(*args) -> "int":
        """event_button1() -> int"""
        return _fltk.Fl_event_button1(*args)

    event_button1 = staticmethod(event_button1)

    def event_button2(*args) -> "int":
        """event_button2() -> int"""
        return _fltk.Fl_event_button2(*args)

    event_button2 = staticmethod(event_button2)

    def event_button3(*args) -> "int":
        """event_button3() -> int"""
        return _fltk.Fl_event_button3(*args)

    event_button3 = staticmethod(event_button3)

    def set_idle(*args) -> "void":
        """set_idle(Fl_Old_Idle_Handler cb)"""
        return _fltk.Fl_set_idle(*args)

    set_idle = staticmethod(set_idle)

    def release(*args) -> "void":
        """release()"""
        return _fltk.Fl_release(*args)

    release = staticmethod(release)

    def visible_focus(*args) -> "int":
        """
        visible_focus(int v)
        visible_focus() -> int
        """
        return _fltk.Fl_visible_focus(*args)

    visible_focus = staticmethod(visible_focus)

    def dnd_text_ops(*args) -> "int":
        """
        dnd_text_ops(int v)
        dnd_text_ops() -> int
        """
        return _fltk.Fl_dnd_text_ops(*args)

    dnd_text_ops = staticmethod(dnd_text_ops)

    def delete_widget(*args) -> "void":
        """delete_widget(Fl_Widget w)"""
        return _fltk.Fl_delete_widget(*args)

    delete_widget = staticmethod(delete_widget)

    def do_widget_deletion(*args) -> "void":
        """do_widget_deletion()"""
        return _fltk.Fl_do_widget_deletion(*args)

    do_widget_deletion = staticmethod(do_widget_deletion)

    def watch_widget_pointer(*args) -> "void":
        """watch_widget_pointer(Fl_Widget *& w)"""
        return _fltk.Fl_watch_widget_pointer(*args)

    watch_widget_pointer = staticmethod(watch_widget_pointer)

    def release_widget_pointer(*args) -> "void":
        """release_widget_pointer(Fl_Widget *& w)"""
        return _fltk.Fl_release_widget_pointer(*args)

    release_widget_pointer = staticmethod(release_widget_pointer)

    def clear_widget_pointer(*args) -> "void":
        """clear_widget_pointer(Fl_Widget w)"""
        return _fltk.Fl_clear_widget_pointer(*args)

    clear_widget_pointer = staticmethod(clear_widget_pointer)

    def use_high_res_GL(*args) -> "int":
        """
        use_high_res_GL(int val)
        use_high_res_GL() -> int
        """
        return _fltk.Fl_use_high_res_GL(*args)

    use_high_res_GL = staticmethod(use_high_res_GL)

    def lock(*args) -> "void":
        """lock()"""
        return _fltk.Fl_lock(*args)

    lock = staticmethod(lock)

    def unlock(*args) -> "void":
        """unlock()"""
        return _fltk.Fl_unlock(*args)

    unlock = staticmethod(unlock)

    def awake(*args) -> "void":
        """
        awake(Fl_Awake_Handler cb, void * message=None) -> int
        awake(void * message=None)
        """
        return _fltk.Fl_awake(*args)

    awake = staticmethod(awake)

    def thread_message(*args) -> "void":
        """thread_message()"""
        return _fltk.Fl_thread_message(*args)

    thread_message = staticmethod(thread_message)
    __swig_destroy__ = _fltk.delete_Fl
    __del__ = lambda self: None
Fl_swigregister = _fltk.Fl_swigregister
Fl_swigregister(Fl)

def Fl_call_screen_init(*args) -> "void":
    """Fl_call_screen_init()"""
    return _fltk.Fl_call_screen_init(*args)

def Fl_option(*args) -> "void":
    """
    option(Fl::Fl_Option opt) -> bool
    Fl_option(Fl::Fl_Option opt, bool val)
    """
    return _fltk.Fl_option(*args)

def Fl_add_awake_handler_(*args) -> "int":
    """Fl_add_awake_handler_(Fl_Awake_Handler arg2, void * arg3) -> int"""
    return _fltk.Fl_add_awake_handler_(*args)

def Fl_version(*args) -> "double":
    """Fl_version() -> double"""
    return _fltk.Fl_version(*args)

def Fl_api_version(*args) -> "int":
    """Fl_api_version() -> int"""
    return _fltk.Fl_api_version(*args)

def Fl_abi_version(*args) -> "int":
    """Fl_abi_version() -> int"""
    return _fltk.Fl_abi_version(*args)

def Fl_abi_check(*args) -> "int":
    """Fl_abi_check(int const val) -> int"""
    return _fltk.Fl_abi_check(*args)

def Fl_arg(*args) -> "int":
    """Fl_arg(int argc, char ** argv, int & i) -> int"""
    return _fltk.Fl_arg(*args)

def Fl_args(*args) -> "void":
    """
    args(int argc, char ** argv, int & i, Fl_Args_Handler cb=None) -> int
    Fl_args(int argc, char ** argv)
    """
    return _fltk.Fl_args(*args)

def Fl_display(*args) -> "void":
    """Fl_display(char const * arg2)"""
    return _fltk.Fl_display(*args)

def Fl_visual(*args) -> "int":
    """Fl_visual(int arg2) -> int"""
    return _fltk.Fl_visual(*args)

def Fl_own_colormap(*args) -> "void":
    """Fl_own_colormap()"""
    return _fltk.Fl_own_colormap(*args)

def Fl_get_system_colors(*args) -> "void":
    """Fl_get_system_colors()"""
    return _fltk.Fl_get_system_colors(*args)

def Fl_foreground(*args) -> "void":
    """Fl_foreground(uchar arg2, uchar arg3, uchar arg4)"""
    return _fltk.Fl_foreground(*args)

def Fl_background(*args) -> "void":
    """Fl_background(uchar arg2, uchar arg3, uchar arg4)"""
    return _fltk.Fl_background(*args)

def Fl_background2(*args) -> "void":
    """Fl_background2(uchar arg2, uchar arg3, uchar arg4)"""
    return _fltk.Fl_background2(*args)

def Fl_scheme(*args) -> "char const *":
    """
    scheme(char const * name) -> int
    Fl_scheme() -> char const *
    """
    return _fltk.Fl_scheme(*args)

def Fl_is_scheme(*args) -> "int":
    """Fl_is_scheme(char const * name) -> int"""
    return _fltk.Fl_is_scheme(*args)

def Fl_reload_scheme(*args) -> "int":
    """Fl_reload_scheme() -> int"""
    return _fltk.Fl_reload_scheme(*args)

def Fl_scrollbar_size(*args) -> "void":
    """
    scrollbar_size() -> int
    Fl_scrollbar_size(int W)
    """
    return _fltk.Fl_scrollbar_size(*args)

def Fl_wait(*args) -> "double":
    """
    wait() -> int
    Fl_wait(double time) -> double
    """
    return _fltk.Fl_wait(*args)

def Fl_check(*args) -> "int":
    """Fl_check() -> int"""
    return _fltk.Fl_check(*args)

def Fl_ready(*args) -> "int":
    """Fl_ready() -> int"""
    return _fltk.Fl_ready(*args)

def Fl_run(*args) -> "int":
    """Fl_run() -> int"""
    return _fltk.Fl_run(*args)

def Fl_readqueue(*args) -> "Fl_Widget *":
    """Fl_readqueue() -> Fl_Widget"""
    return _fltk.Fl_readqueue(*args)

def Fl_has_timeout(*args) -> "int":
    """Fl_has_timeout(Fl_Timeout_Handler arg2, void * arg3=None) -> int"""
    return _fltk.Fl_has_timeout(*args)

def Fl_add_idle(*args) -> "void":
    """Fl_add_idle(Fl_Idle_Handler cb, void * data=None)"""
    return _fltk.Fl_add_idle(*args)

def Fl_has_idle(*args) -> "int":
    """Fl_has_idle(Fl_Idle_Handler cb, void * data=None) -> int"""
    return _fltk.Fl_has_idle(*args)

def Fl_remove_idle(*args) -> "void":
    """Fl_remove_idle(Fl_Idle_Handler cb, void * data=None)"""
    return _fltk.Fl_remove_idle(*args)

def Fl_damage(*args) -> "int":
    """
    damage(int d)
    Fl_damage() -> int
    """
    return _fltk.Fl_damage(*args)

def Fl_redraw(*args) -> "void":
    """Fl_redraw()"""
    return _fltk.Fl_redraw(*args)

def Fl_flush(*args) -> "void":
    """Fl_flush()"""
    return _fltk.Fl_flush(*args)

def Fl_first_window(*args) -> "void":
    """
    first_window() -> Fl_Window
    Fl_first_window(Fl_Window arg2)
    """
    return _fltk.Fl_first_window(*args)

def Fl_next_window(*args) -> "Fl_Window *":
    """Fl_next_window(Fl_Window arg2) -> Fl_Window"""
    return _fltk.Fl_next_window(*args)

def Fl_modal(*args) -> "Fl_Window *":
    """Fl_modal() -> Fl_Window"""
    return _fltk.Fl_modal(*args)

def Fl_grab(*args) -> "void":
    """
    grab() -> Fl_Window
    Fl_grab(Fl_Window arg2)
    """
    return _fltk.Fl_grab(*args)

def Fl_event(*args) -> "int":
    """Fl_event() -> int"""
    return _fltk.Fl_event(*args)

def Fl_event_x(*args) -> "int":
    """Fl_event_x() -> int"""
    return _fltk.Fl_event_x(*args)

def Fl_event_y(*args) -> "int":
    """Fl_event_y() -> int"""
    return _fltk.Fl_event_y(*args)

def Fl_event_x_root(*args) -> "int":
    """Fl_event_x_root() -> int"""
    return _fltk.Fl_event_x_root(*args)

def Fl_event_y_root(*args) -> "int":
    """Fl_event_y_root() -> int"""
    return _fltk.Fl_event_y_root(*args)

def Fl_event_dx(*args) -> "int":
    """Fl_event_dx() -> int"""
    return _fltk.Fl_event_dx(*args)

def Fl_event_dy(*args) -> "int":
    """Fl_event_dy() -> int"""
    return _fltk.Fl_event_dy(*args)

def Fl_get_mouse(*args) -> "void":
    """Fl_get_mouse(int & arg2, int & arg3)"""
    return _fltk.Fl_get_mouse(*args)

def Fl_event_clicks(*args) -> "void":
    """
    event_clicks() -> int
    Fl_event_clicks(int i)
    """
    return _fltk.Fl_event_clicks(*args)

def Fl_event_is_click(*args) -> "void":
    """
    event_is_click() -> int
    Fl_event_is_click(int i)
    """
    return _fltk.Fl_event_is_click(*args)

def Fl_event_button(*args) -> "int":
    """Fl_event_button() -> int"""
    return _fltk.Fl_event_button(*args)

def Fl_event_state(*args) -> "int":
    """
    event_state() -> int
    Fl_event_state(int mask) -> int
    """
    return _fltk.Fl_event_state(*args)

def Fl_event_original_key(*args) -> "int":
    """Fl_event_original_key() -> int"""
    return _fltk.Fl_event_original_key(*args)

def Fl_event_key(*args) -> "int":
    """
    event_key() -> int
    Fl_event_key(int key) -> int
    """
    return _fltk.Fl_event_key(*args)

def Fl_get_key(*args) -> "int":
    """Fl_get_key(int key) -> int"""
    return _fltk.Fl_get_key(*args)

def Fl_event_text(*args) -> "char const *":
    """Fl_event_text() -> char const *"""
    return _fltk.Fl_event_text(*args)

def Fl_event_length(*args) -> "int":
    """Fl_event_length() -> int"""
    return _fltk.Fl_event_length(*args)

def Fl_event_clipboard(*args) -> "void *":
    """Fl_event_clipboard() -> void *"""
    return _fltk.Fl_event_clipboard(*args)

def Fl_event_clipboard_type(*args) -> "char const *":
    """Fl_event_clipboard_type() -> char const *"""
    return _fltk.Fl_event_clipboard_type(*args)

def Fl_compose(*args) -> "int":
    """Fl_compose(int & arg2) -> int"""
    return _fltk.Fl_compose(*args)

def Fl_compose_reset(*args) -> "void":
    """Fl_compose_reset()"""
    return _fltk.Fl_compose_reset(*args)

def Fl_event_inside(*args) -> "int":
    """
    event_inside(int arg1, int arg2, int arg3, int arg4) -> int
    Fl_event_inside(Fl_Widget arg2) -> int
    """
    return _fltk.Fl_event_inside(*args)

def Fl_test_shortcut(*args) -> "int":
    """Fl_test_shortcut(Fl_Shortcut arg2) -> int"""
    return _fltk.Fl_test_shortcut(*args)

def Fl_enable_im(*args) -> "void":
    """Fl_enable_im()"""
    return _fltk.Fl_enable_im(*args)

def Fl_disable_im(*args) -> "void":
    """Fl_disable_im()"""
    return _fltk.Fl_disable_im(*args)

def Fl_handle(*args) -> "int":
    """Fl_handle(int arg2, Fl_Window arg3) -> int"""
    return _fltk.Fl_handle(*args)

def Fl_handle_(*args) -> "int":
    """Fl_handle_(int arg2, Fl_Window arg3) -> int"""
    return _fltk.Fl_handle_(*args)

def Fl_belowmouse(*args) -> "void":
    """
    belowmouse() -> Fl_Widget
    Fl_belowmouse(Fl_Widget arg2)
    """
    return _fltk.Fl_belowmouse(*args)

def Fl_pushed(*args) -> "void":
    """
    pushed() -> Fl_Widget
    Fl_pushed(Fl_Widget arg2)
    """
    return _fltk.Fl_pushed(*args)

def Fl_focus(*args) -> "void":
    """
    focus() -> Fl_Widget
    Fl_focus(Fl_Widget arg2)
    """
    return _fltk.Fl_focus(*args)

def Fl_add_system_handler(*args) -> "void":
    """Fl_add_system_handler(Fl_System_Handler h, void * data)"""
    return _fltk.Fl_add_system_handler(*args)

def Fl_remove_system_handler(*args) -> "void":
    """Fl_remove_system_handler(Fl_System_Handler h)"""
    return _fltk.Fl_remove_system_handler(*args)

def Fl_event_dispatch(*args) -> "Fl_Event_Dispatch":
    """
    event_dispatch(Fl_Event_Dispatch d)
    Fl_event_dispatch() -> Fl_Event_Dispatch
    """
    return _fltk.Fl_event_dispatch(*args)

def Fl_copy(*args) -> "void":
    """
    copy(char const * stuff, int len, int destination, char const * type)
    Fl_copy(char const * stuff, int len, int destination=0)
    """
    return _fltk.Fl_copy(*args)

def Fl_add_clipboard_notify(*args) -> "void":
    """Fl_add_clipboard_notify(Fl_Clipboard_Notify_Handler h, void * data=None)"""
    return _fltk.Fl_add_clipboard_notify(*args)

def Fl_remove_clipboard_notify(*args) -> "void":
    """Fl_remove_clipboard_notify(Fl_Clipboard_Notify_Handler h)"""
    return _fltk.Fl_remove_clipboard_notify(*args)

def Fl_clipboard_contains(*args) -> "int":
    """Fl_clipboard_contains(char const * type) -> int"""
    return _fltk.Fl_clipboard_contains(*args)

def Fl_dnd(*args) -> "int":
    """Fl_dnd() -> int"""
    return _fltk.Fl_dnd(*args)

def Fl_selection_owner(*args) -> "void":
    """
    selection_owner() -> Fl_Widget
    Fl_selection_owner(Fl_Widget arg2)
    """
    return _fltk.Fl_selection_owner(*args)

def Fl_selection(*args) -> "void":
    """Fl_selection(Fl_Widget owner, char const * arg3, int len)"""
    return _fltk.Fl_selection(*args)

def Fl_paste(*args) -> "void":
    """
    paste(Fl_Widget receiver, int source, char const * type)
    paste(Fl_Widget receiver, int source)
    Fl_paste(Fl_Widget receiver)
    """
    return _fltk.Fl_paste(*args)

def Fl_x(*args) -> "int":
    """Fl_x() -> int"""
    return _fltk.Fl_x(*args)

def Fl_y(*args) -> "int":
    """Fl_y() -> int"""
    return _fltk.Fl_y(*args)

def Fl_w(*args) -> "int":
    """Fl_w() -> int"""
    return _fltk.Fl_w(*args)

def Fl_h(*args) -> "int":
    """Fl_h() -> int"""
    return _fltk.Fl_h(*args)

def Fl_screen_count(*args) -> "int":
    """Fl_screen_count() -> int"""
    return _fltk.Fl_screen_count(*args)

def Fl_screen_xywh(*args) -> "void":
    """
    screen_xywh(int & X, int & Y, int & W, int & H)
    screen_xywh(int & X, int & Y, int & W, int & H, int mx, int my)
    screen_xywh(int & X, int & Y, int & W, int & H, int n)
    Fl_screen_xywh(int & X, int & Y, int & W, int & H, int mx, int my, int mw, int mh)
    """
    return _fltk.Fl_screen_xywh(*args)

def Fl_screen_num(*args) -> "int":
    """
    screen_num(int x, int y) -> int
    Fl_screen_num(int x, int y, int w, int h) -> int
    """
    return _fltk.Fl_screen_num(*args)

def Fl_screen_dpi(*args) -> "void":
    """Fl_screen_dpi(float & h, float & v, int n=0)"""
    return _fltk.Fl_screen_dpi(*args)

def Fl_screen_work_area(*args) -> "void":
    """
    screen_work_area(int & X, int & Y, int & W, int & H, int mx, int my)
    screen_work_area(int & X, int & Y, int & W, int & H, int n)
    Fl_screen_work_area(int & X, int & Y, int & W, int & H)
    """
    return _fltk.Fl_screen_work_area(*args)

def Fl_set_color(*args) -> "void":
    """
    set_color(Fl_Color arg1, uchar arg2, uchar arg3, uchar arg4)
    Fl_set_color(Fl_Color i, unsigned int c)
    """
    return _fltk.Fl_set_color(*args)

def Fl_get_color(*args) -> "uchar &, uchar &, uchar &":
    """Fl_get_color(Fl_Color i)"""
    return _fltk.Fl_get_color(*args)

def Fl_free_color(*args) -> "void":
    """Fl_free_color(Fl_Color i, int overlay=0)"""
    return _fltk.Fl_free_color(*args)

def Fl_get_font(*args) -> "char const *":
    """Fl_get_font(Fl_Font arg2) -> char const *"""
    return _fltk.Fl_get_font(*args)

def Fl_get_font_name(*args) -> "int *":
    """Fl_get_font_name(Fl_Font arg2) -> char const *"""
    return _fltk.Fl_get_font_name(*args)

def Fl_set_font(*args) -> "void":
    """
    set_font(Fl_Font arg1, char const * arg2)
    Fl_set_font(Fl_Font arg2, Fl_Font arg3)
    """
    return _fltk.Fl_set_font(*args)

def Fl_set_fonts(*args) -> "Fl_Font":
    """Fl_set_fonts(char const * arg2=None) -> Fl_Font"""
    return _fltk.Fl_set_fonts(*args)

def Fl_set_labeltype(*args) -> "void":
    """Fl_set_labeltype(Fl_Labeltype arg2, Fl_Label_Draw_F * arg3, Fl_Label_Measure_F * arg4)"""
    return _fltk.Fl_set_labeltype(*args)

def Fl_get_boxtype(*args) -> "Fl_Box_Draw_F *":
    """Fl_get_boxtype(Fl_Boxtype arg2) -> Fl_Box_Draw_F *"""
    return _fltk.Fl_get_boxtype(*args)

def Fl_set_boxtype(*args) -> "void":
    """
    set_boxtype(Fl_Boxtype arg1, Fl_Box_Draw_F * arg2, uchar arg3, uchar arg4, uchar arg5, uchar arg6)
    Fl_set_boxtype(Fl_Boxtype arg2, Fl_Boxtype arg3)
    """
    return _fltk.Fl_set_boxtype(*args)

def Fl_box_dx(*args) -> "int":
    """Fl_box_dx(Fl_Boxtype arg2) -> int"""
    return _fltk.Fl_box_dx(*args)

def Fl_box_dy(*args) -> "int":
    """Fl_box_dy(Fl_Boxtype arg2) -> int"""
    return _fltk.Fl_box_dy(*args)

def Fl_box_dw(*args) -> "int":
    """Fl_box_dw(Fl_Boxtype arg2) -> int"""
    return _fltk.Fl_box_dw(*args)

def Fl_box_dh(*args) -> "int":
    """Fl_box_dh(Fl_Boxtype arg2) -> int"""
    return _fltk.Fl_box_dh(*args)

def Fl_draw_box_active(*args) -> "int":
    """Fl_draw_box_active() -> int"""
    return _fltk.Fl_draw_box_active(*args)

def Fl_box_color(*args) -> "Fl_Color":
    """Fl_box_color(Fl_Color arg2) -> Fl_Color"""
    return _fltk.Fl_box_color(*args)

def Fl_set_box_color(*args) -> "void":
    """Fl_set_box_color(Fl_Color arg2)"""
    return _fltk.Fl_set_box_color(*args)

def Fl_set_abort(*args) -> "void":
    """Fl_set_abort(Fl_Abort_Handler f)"""
    return _fltk.Fl_set_abort(*args)

def Fl_default_atclose(*args) -> "void":
    """Fl_default_atclose(Fl_Window arg2, void * arg3)"""
    return _fltk.Fl_default_atclose(*args)

def Fl_set_atclose(*args) -> "void":
    """Fl_set_atclose(Fl_Atclose_Handler f)"""
    return _fltk.Fl_set_atclose(*args)

def Fl_event_shift(*args) -> "int":
    """Fl_event_shift() -> int"""
    return _fltk.Fl_event_shift(*args)

def Fl_event_ctrl(*args) -> "int":
    """Fl_event_ctrl() -> int"""
    return _fltk.Fl_event_ctrl(*args)

def Fl_event_command(*args) -> "int":
    """Fl_event_command() -> int"""
    return _fltk.Fl_event_command(*args)

def Fl_event_alt(*args) -> "int":
    """Fl_event_alt() -> int"""
    return _fltk.Fl_event_alt(*args)

def Fl_event_buttons(*args) -> "int":
    """Fl_event_buttons() -> int"""
    return _fltk.Fl_event_buttons(*args)

def Fl_event_button1(*args) -> "int":
    """Fl_event_button1() -> int"""
    return _fltk.Fl_event_button1(*args)

def Fl_event_button2(*args) -> "int":
    """Fl_event_button2() -> int"""
    return _fltk.Fl_event_button2(*args)

def Fl_event_button3(*args) -> "int":
    """Fl_event_button3() -> int"""
    return _fltk.Fl_event_button3(*args)

def Fl_set_idle(*args) -> "void":
    """Fl_set_idle(Fl_Old_Idle_Handler cb)"""
    return _fltk.Fl_set_idle(*args)

def Fl_release(*args) -> "void":
    """Fl_release()"""
    return _fltk.Fl_release(*args)

def Fl_visible_focus(*args) -> "int":
    """
    visible_focus(int v)
    Fl_visible_focus() -> int
    """
    return _fltk.Fl_visible_focus(*args)

def Fl_dnd_text_ops(*args) -> "int":
    """
    dnd_text_ops(int v)
    Fl_dnd_text_ops() -> int
    """
    return _fltk.Fl_dnd_text_ops(*args)

def Fl_delete_widget(*args) -> "void":
    """Fl_delete_widget(Fl_Widget w)"""
    return _fltk.Fl_delete_widget(*args)

def Fl_do_widget_deletion(*args) -> "void":
    """Fl_do_widget_deletion()"""
    return _fltk.Fl_do_widget_deletion(*args)

def Fl_watch_widget_pointer(*args) -> "void":
    """Fl_watch_widget_pointer(Fl_Widget *& w)"""
    return _fltk.Fl_watch_widget_pointer(*args)

def Fl_release_widget_pointer(*args) -> "void":
    """Fl_release_widget_pointer(Fl_Widget *& w)"""
    return _fltk.Fl_release_widget_pointer(*args)

def Fl_clear_widget_pointer(*args) -> "void":
    """Fl_clear_widget_pointer(Fl_Widget w)"""
    return _fltk.Fl_clear_widget_pointer(*args)

def Fl_use_high_res_GL(*args) -> "int":
    """
    use_high_res_GL(int val)
    Fl_use_high_res_GL() -> int
    """
    return _fltk.Fl_use_high_res_GL(*args)

def Fl_lock(*args) -> "void":
    """Fl_lock()"""
    return _fltk.Fl_lock(*args)

def Fl_unlock(*args) -> "void":
    """Fl_unlock()"""
    return _fltk.Fl_unlock(*args)

def Fl_awake(*args) -> "void":
    """
    awake(Fl_Awake_Handler cb, void * message=None) -> int
    Fl_awake(void * message=None)
    """
    return _fltk.Fl_awake(*args)

def Fl_thread_message(*args) -> "void":
    """Fl_thread_message()"""
    return _fltk.Fl_thread_message(*args)

class Fl_Widget_Tracker(object):
    """Proxy of C++ Fl_Widget_Tracker class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Widget_Tracker self, Fl_Widget wi) -> Fl_Widget_Tracker"""
        this = _fltk.new_Fl_Widget_Tracker(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Widget_Tracker
    __del__ = lambda self: None

    def widget(self, *args) -> "Fl_Widget *":
        """widget(Fl_Widget_Tracker self) -> Fl_Widget"""
        return _fltk.Fl_Widget_Tracker_widget(self, *args)


    def deleted(self, *args) -> "int":
        """deleted(Fl_Widget_Tracker self) -> int"""
        return _fltk.Fl_Widget_Tracker_deleted(self, *args)


    def exists(self, *args) -> "int":
        """exists(Fl_Widget_Tracker self) -> int"""
        return _fltk.Fl_Widget_Tracker_exists(self, *args)

Fl_Widget_Tracker_swigregister = _fltk.Fl_Widget_Tracker_swigregister
Fl_Widget_Tracker_swigregister(Fl_Widget_Tracker)


def pyFLTK_controlIdleCallbacks(*args) -> "void":
    """pyFLTK_controlIdleCallbacks(int enable)"""
    return _fltk.pyFLTK_controlIdleCallbacks(*args)

def Fl_mt_run(window):
    import time
    while window.visible():
        time.sleep(0.1)
        Fl.check()

Fl.mt_run = staticmethod(Fl_mt_run)

FL_PATH_MAX = _fltk.FL_PATH_MAX

def fl_filename_name(*args) -> "char const *":
    """fl_filename_name(char const * filename) -> char const *"""
    return _fltk.fl_filename_name(*args)

def fl_filename_ext(*args) -> "char const *":
    """fl_filename_ext(char const * buf) -> char const *"""
    return _fltk.fl_filename_ext(*args)

def fl_filename_match(*args) -> "int":
    """fl_filename_match(char const * name, char const * pattern) -> int"""
    return _fltk.fl_filename_match(*args)

def fl_filename_isdir(*args) -> "int":
    """fl_filename_isdir(char const * name) -> int"""
    return _fltk.fl_filename_isdir(*args)

def fl_filename_setext(*args) -> "char *":
    """
    fl_filename_setext(char * to, int tolen, char const * ext) -> char
    fl_filename_setext(char * to, char const * ext) -> char *
    """
    return _fltk.fl_filename_setext(*args)

def fl_filename_expand(*args) -> "char *":
    """
    fl_filename_expand(char * to, int tolen, char const * arg3) -> int
    fl_filename_expand(char * to, char const * arg2) -> int
    """
    return _fltk.fl_filename_expand(*args)

def fl_filename_absolute(*args) -> "char *":
    """
    fl_filename_absolute(char * to, int tolen, char const * arg3) -> int
    fl_filename_absolute(char * to, char const * arg2) -> int
    """
    return _fltk.fl_filename_absolute(*args)

def fl_filename_relative(*args) -> "char *":
    """
    fl_filename_relative(char * to, int tolen, char const * arg3) -> int
    fl_filename_relative(char * to, int tolen, char const * arg3, char const * cwd) -> int
    fl_filename_relative(char * to, char const * arg2) -> int
    """
    return _fltk.fl_filename_relative(*args)

def fl_filename_free_list(*args) -> "void":
    """fl_filename_free_list(dirent *** l, int n)"""
    return _fltk.fl_filename_free_list(*args)

def fl_open_uri(*args) -> "int":
    """fl_open_uri(char const * uri, char * msg, int msglen=0) -> int"""
    return _fltk.fl_open_uri(*args)

def fl_decode_uri(*args) -> "void":
    """fl_decode_uri(char * uri)"""
    return _fltk.fl_decode_uri(*args)
class Fl_Valuator(Fl_Widget):
    """

    The Fl_Valuator class controls a single floating-point value and provides 
    a consistent interface to set the value, range, and step, and insures that 
    callbacks are done the same for every object.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def bounds(self, *args) -> "void":
        """bounds(Fl_Valuator self, double a, double b)"""
        return _fltk.Fl_Valuator_bounds(self, *args)


    def minimum(self, *args) -> "void":
        """
        minimum(Fl_Valuator self) -> double
        minimum(Fl_Valuator self, double a)
        """
        return _fltk.Fl_Valuator_minimum(self, *args)


    def maximum(self, *args) -> "void":
        """
        maximum(Fl_Valuator self) -> double
        maximum(Fl_Valuator self, double a)
        """
        return _fltk.Fl_Valuator_maximum(self, *args)


    def range(self, *args) -> "void":
        """range(Fl_Valuator self, double a, double b)"""
        return _fltk.Fl_Valuator_range(self, *args)


    def step(self, *args) -> "double":
        """
        step(Fl_Valuator self, int a)
        step(Fl_Valuator self, double a, int b)
        step(Fl_Valuator self, double s)
        step(Fl_Valuator self) -> double
        """
        return _fltk.Fl_Valuator_step(self, *args)


    def precision(self, *args) -> "void":
        """precision(Fl_Valuator self, int arg2)"""
        return _fltk.Fl_Valuator_precision(self, *args)


    def value(self, *args) -> "int":
        """
        value(Fl_Valuator self) -> double
        value(Fl_Valuator self, double arg2) -> int
        """
        return _fltk.Fl_Valuator_value(self, *args)


    def format(self, *args) -> "int":
        """format(Fl_Valuator self, char * format_string) -> int"""
        return _fltk.Fl_Valuator_format(self, *args)


    def round(self, *args) -> "double":
        """round(Fl_Valuator self, double arg2) -> double"""
        return _fltk.Fl_Valuator_round(self, *args)


    def clamp(self, *args) -> "double":
        """clamp(Fl_Valuator self, double arg2) -> double"""
        return _fltk.Fl_Valuator_clamp(self, *args)


    def increment(self, *args) -> "double":
        """increment(Fl_Valuator self, double arg2, int arg3) -> double"""
        return _fltk.Fl_Valuator_increment(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Valuator
    __del__ = lambda self: None
Fl_Valuator_swigregister = _fltk.Fl_Valuator_swigregister
Fl_Valuator_swigregister(Fl_Valuator)
pyFLTK_registerDoIdle = _fltk.pyFLTK_registerDoIdle
Fl_add_timeout = _fltk.Fl_add_timeout
Fl_repeat_timeout = _fltk.Fl_repeat_timeout
Fl_remove_timeout = _fltk.Fl_remove_timeout
Fl_add_fd = _fltk.Fl_add_fd
Fl_remove_fd = _fltk.Fl_remove_fd
Fl_add_handler = _fltk.Fl_add_handler
Fl_remove_handler = _fltk.Fl_remove_handler
Fl_add_check = _fltk.Fl_add_check
Fl_remove_check = _fltk.Fl_remove_check
Fl_get_font_sizes_tmp = _fltk.Fl_get_font_sizes_tmp


FL_VERTICAL=0
FL_HORIZONTAL=1

class Fl_Adjuster(Fl_Valuator):
    """

    The Fl_Adjuster widget has proven to be very useful for values that need a 
    was stolen from Prisms, and large dynamic range.
    When you press a button and drag to the right the value increases. When you 
    drag to the left it decreases. The largest button adjusts by 100 * step(), 
    the next by 10 * step() and that smallest button by step(). Clicking on the 
    buttons increments by 10 times the amount dragging by a pixel does. 
    Shift + click decrements by 10 times the amount. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Adjuster self)"""
        return _fltk.Fl_Adjuster_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Adjuster self, int arg0) -> int"""
        return _fltk.Fl_Adjuster_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Adjuster self, int X, int Y, int W, int H, char const * l=None) -> Fl_Adjuster"""
        if self.__class__ == Fl_Adjuster:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Adjuster(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def soft(self, *args) -> "int":
        """
        soft(Fl_Adjuster self, int s)
        soft(Fl_Adjuster self) -> int
        """
        return _fltk.Fl_Adjuster_soft(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Adjuster
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Adjuster(self)
        return weakref_proxy(self)
Fl_Adjuster_swigregister = _fltk.Fl_Adjuster_swigregister
Fl_Adjuster_swigregister(Fl_Adjuster)

FL_BEEP_DEFAULT = _fltk.FL_BEEP_DEFAULT
FL_BEEP_MESSAGE = _fltk.FL_BEEP_MESSAGE
FL_BEEP_ERROR = _fltk.FL_BEEP_ERROR
FL_BEEP_QUESTION = _fltk.FL_BEEP_QUESTION
FL_BEEP_PASSWORD = _fltk.FL_BEEP_PASSWORD
FL_BEEP_NOTIFICATION = _fltk.FL_BEEP_NOTIFICATION

def fl_beep(*args) -> "void":
    """fl_beep(int type=FL_BEEP_DEFAULT)"""
    return _fltk.fl_beep(*args)

def fl_message(*args) -> "void":
    """fl_message(char const * arg1)"""
    return _fltk.fl_message(*args)

def fl_alert(*args) -> "void":
    """fl_alert(char const * arg1)"""
    return _fltk.fl_alert(*args)

def fl_ask(*args) -> "int":
    """fl_ask(char const * arg1) -> int"""
    return _fltk.fl_ask(*args)

def fl_choice(*args) -> "int":
    """fl_choice(char const * q, char const * b0, char const * b1, char const * b2) -> int"""
    return _fltk.fl_choice(*args)

def fl_message_icon(*args) -> "Fl_Widget *":
    """fl_message_icon() -> Fl_Widget"""
    return _fltk.fl_message_icon(*args)

def fl_message_font(*args) -> "void":
    """fl_message_font(Fl_Font f, Fl_Fontsize s)"""
    return _fltk.fl_message_font(*args)

def fl_message_hotspot(*args) -> "int":
    """
    fl_message_hotspot(int enable)
    fl_message_hotspot() -> int
    """
    return _fltk.fl_message_hotspot(*args)

def fl_message_title(*args) -> "void":
    """fl_message_title(char const * title)"""
    return _fltk.fl_message_title(*args)

def fl_message_title_default(*args) -> "void":
    """fl_message_title_default(char const * title)"""
    return _fltk.fl_message_title_default(*args)

def fl_input(*args) -> "char const *":
    """fl_input(char const * label, char const * deflt=None) -> char const *"""
    return _fltk.fl_input(*args)

def fl_password(*args) -> "char const *":
    """fl_password(char const * label, char const * deflt=None) -> char const *"""
    return _fltk.fl_password(*args)

def fl_no_get(*args) -> "char const *":
    """fl_no_get() -> char const *"""
    return _fltk.fl_no_get(*args)

def fl_yes_get(*args) -> "char const *":
    """fl_yes_get() -> char const *"""
    return _fltk.fl_yes_get(*args)

def fl_ok_get(*args) -> "char const *":
    """fl_ok_get() -> char const *"""
    return _fltk.fl_ok_get(*args)

def fl_cancel_get(*args) -> "char const *":
    """fl_cancel_get() -> char const *"""
    return _fltk.fl_cancel_get(*args)

def fl_close_get(*args) -> "char const *":
    """fl_close_get() -> char const *"""
    return _fltk.fl_close_get(*args)

def fl_no_set(*args) -> "void":
    """fl_no_set(char const * value)"""
    return _fltk.fl_no_set(*args)

def fl_yes_set(*args) -> "void":
    """fl_yes_set(char const * value)"""
    return _fltk.fl_yes_set(*args)

def fl_ok_set(*args) -> "void":
    """fl_ok_set(char const * value)"""
    return _fltk.fl_ok_set(*args)

def fl_cancel_set(*args) -> "void":
    """fl_cancel_set(char const * value)"""
    return _fltk.fl_cancel_set(*args)

def fl_close_set(*args) -> "void":
    """fl_close_set(char const * value)"""
    return _fltk.fl_close_set(*args)

def fl_mt_message(*args) -> "void":
    """fl_mt_message(char const * text)"""
    return _fltk.fl_mt_message(*args)

def fl_mt_alert(*args) -> "void":
    """fl_mt_alert(char const * text)"""
    return _fltk.fl_mt_alert(*args)

def fl_mt_ask(*args) -> "int":
    """fl_mt_ask(char const * text) -> int"""
    return _fltk.fl_mt_ask(*args)

def fl_mt_choice(*args) -> "int":
    """fl_mt_choice(char const * q, char const * b0, char const * b1, char const * b2) -> int"""
    return _fltk.fl_mt_choice(*args)

def fl_mt_input(*args) -> "char const *":
    """fl_mt_input(char const * label, char const * deflt=None) -> char const *"""
    return _fltk.fl_mt_input(*args)

def fl_mt_password(*args) -> "char const *":
    """fl_mt_password(char const * label, char const * deflt=None) -> char const *"""
    return _fltk.fl_mt_password(*args)
class Fl_Bitmap(Fl_Image):
    """

    The Fl_Bitmap class supports caching and drawing of mono-color 
    (bitmap) images. Images are drawn using the current color.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Bitmap self, uchar const * bits, int W, int H) -> Fl_Bitmap"""
        if self.__class__ == Fl_Bitmap:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Bitmap(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Bitmap
    __del__ = lambda self: None

    def copy(self, *args) -> "Fl_Image *":
        """
        copy(Fl_Bitmap self, int W, int H) -> Fl_Image
        copy(Fl_Bitmap self) -> Fl_Image
        """
        return _fltk.Fl_Bitmap_copy(self, *args)


    def draw(self, *args) -> "void":
        """
        draw(Fl_Bitmap self, int X, int Y, int W, int H, int cx=0, int cy=0)
        draw(Fl_Bitmap self, int X, int Y)
        """
        return _fltk.Fl_Bitmap_draw(self, *args)


    def label(self, *args) -> "void":
        """
        label(Fl_Bitmap self, Fl_Widget w)
        label(Fl_Bitmap self, Fl_Menu_Item m)
        """
        return _fltk.Fl_Bitmap_label(self, *args)


    def uncache(self, *args) -> "void":
        """uncache(Fl_Bitmap self)"""
        return _fltk.Fl_Bitmap_uncache(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Bitmap(self)
        return weakref_proxy(self)
Fl_Bitmap_swigregister = _fltk.Fl_Bitmap_swigregister
Fl_Bitmap_swigregister(Fl_Bitmap)

class Fl_BMP_Image(Fl_RGB_Image):
    """

    The Fl_BMP_Image class supports loading, caching, and drawing of 
    Windows Bitmap (BMP) image files.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_BMP_Image self, char const * filename) -> Fl_BMP_Image"""
        if self.__class__ == Fl_BMP_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_BMP_Image(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_BMP_Image
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_BMP_Image(self)
        return weakref_proxy(self)
Fl_BMP_Image_swigregister = _fltk.Fl_BMP_Image_swigregister
Fl_BMP_Image_swigregister(Fl_BMP_Image)

class Fl_Box(Fl_Widget):
    """

    This widget simply draws its box, and possibly it's label. 
    Putting it before some other widgets and making it big enough 
    to surround them will let you draw a frame around them.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Box self)"""
        return _fltk.Fl_Box_draw(self, *args)


    def __init__(self, *args):
        """
        __init__(Fl_Box self, int X, int Y, int W, int H, char const * l=None) -> Fl_Box
        __init__(Fl_Box self, Fl_Boxtype b, int X, int Y, int W, int H, char const * l) -> Fl_Box
        """
        if self.__class__ == Fl_Box:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Box(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def handle(self, *args) -> "int":
        """handle(Fl_Box self, int arg0) -> int"""
        return _fltk.Fl_Box_handle(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Box
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Box(self)
        return weakref_proxy(self)
Fl_Box_swigregister = _fltk.Fl_Box_swigregister
Fl_Box_swigregister(Fl_Box)

FL_NORMAL_BUTTON = _fltk.FL_NORMAL_BUTTON
FL_TOGGLE_BUTTON = _fltk.FL_TOGGLE_BUTTON
FL_RADIO_BUTTON = _fltk.FL_RADIO_BUTTON
FL_HIDDEN_BUTTON = _fltk.FL_HIDDEN_BUTTON

def fl_old_shortcut(*args) -> "Fl_Shortcut":
    """fl_old_shortcut(char const * arg1) -> Fl_Shortcut"""
    return _fltk.fl_old_shortcut(*args)
class Fl_Button(Fl_Widget):
    """

    Buttons generate callbacks when they are clicked by the user. You control 
    exactly when and how by changing the values for type()  and when().

    Buttons can also generate callbacks in response to FL_SHORTCUT events. The 
    button can either have an explicit shortcut() value or a letter shortcut 
    can be indicated in the label() with an '&' character before it. For the 
    label shortcut it does not matter if Alt is held down, but if you have an 
    input field in the same window, the user will have to hold down the Alt key 
    so that the input field does not eat the event first as an FL_KEYBOARD event. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Button self)"""
        return _fltk.Fl_Button_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Button self, int arg0) -> int"""
        return _fltk.Fl_Button_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Button self, int X, int Y, int W, int H, char const * L=None) -> Fl_Button"""
        if self.__class__ == Fl_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Button(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def value(self, *args) -> "char":
        """
        value(Fl_Button self, int v) -> int
        value(Fl_Button self) -> char
        """
        return _fltk.Fl_Button_value(self, *args)


    def set(self, *args) -> "int":
        """set(Fl_Button self) -> int"""
        return _fltk.Fl_Button_set(self, *args)


    def clear(self, *args) -> "int":
        """clear(Fl_Button self) -> int"""
        return _fltk.Fl_Button_clear(self, *args)


    def setonly(self, *args) -> "void":
        """setonly(Fl_Button self)"""
        return _fltk.Fl_Button_setonly(self, *args)


    def down_box(self, *args) -> "void":
        """
        down_box(Fl_Button self) -> Fl_Boxtype
        down_box(Fl_Button self, Fl_Boxtype b)
        """
        return _fltk.Fl_Button_down_box(self, *args)


    def shortcut(self, *args) -> "void":
        """
        shortcut(Fl_Button self) -> int
        shortcut(Fl_Button self, int s)
        shortcut(Fl_Button self, char const * s)
        """
        return _fltk.Fl_Button_shortcut(self, *args)


    def down_color(self, *args) -> "void":
        """
        down_color(Fl_Button self) -> Fl_Color
        down_color(Fl_Button self, unsigned int c)
        """
        return _fltk.Fl_Button_down_color(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Button
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Button(self)
        return weakref_proxy(self)
Fl_Button_swigregister = _fltk.Fl_Button_swigregister
Fl_Button_swigregister(Fl_Button)

FL_BAR_CHART = _fltk.FL_BAR_CHART
FL_HORBAR_CHART = _fltk.FL_HORBAR_CHART
FL_LINE_CHART = _fltk.FL_LINE_CHART
FL_FILL_CHART = _fltk.FL_FILL_CHART
FL_SPIKE_CHART = _fltk.FL_SPIKE_CHART
FL_PIE_CHART = _fltk.FL_PIE_CHART
FL_SPECIALPIE_CHART = _fltk.FL_SPECIALPIE_CHART
FL_FILLED_CHART = _fltk.FL_FILLED_CHART
FL_CHART_MAX = _fltk.FL_CHART_MAX
FL_CHART_LABEL_MAX = _fltk.FL_CHART_LABEL_MAX
class FL_CHART_ENTRY(object):
    """Proxy of C++ FL_CHART_ENTRY class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(FL_CHART_ENTRY self) -> FL_CHART_ENTRY"""
        this = _fltk.new_FL_CHART_ENTRY(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_FL_CHART_ENTRY
    __del__ = lambda self: None
FL_CHART_ENTRY_swigregister = _fltk.FL_CHART_ENTRY_swigregister
FL_CHART_ENTRY_swigregister(FL_CHART_ENTRY)

class Fl_Chart(Fl_Widget):
    """

    This widget displays simple charts and is provided for Forms compatibility.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Chart self)"""
        return _fltk.Fl_Chart_draw(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Chart self, int X, int Y, int W, int H, char const * L=None) -> Fl_Chart"""
        if self.__class__ == Fl_Chart:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Chart(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Chart
    __del__ = lambda self: None

    def clear(self, *args) -> "void":
        """clear(Fl_Chart self)"""
        return _fltk.Fl_Chart_clear(self, *args)


    def add(self, *args) -> "void":
        """add(Fl_Chart self, double val, char const * str=None, unsigned int col=0)"""
        return _fltk.Fl_Chart_add(self, *args)


    def insert(self, *args) -> "void":
        """insert(Fl_Chart self, int ind, double val, char const * str=None, unsigned int col=0)"""
        return _fltk.Fl_Chart_insert(self, *args)


    def replace(self, *args) -> "void":
        """replace(Fl_Chart self, int ind, double val, char const * str=None, unsigned int col=0)"""
        return _fltk.Fl_Chart_replace(self, *args)


    def bounds(self, *args) -> "void":
        """
        bounds(Fl_Chart self, double * a, double * b)
        bounds(Fl_Chart self, double a, double b)
        """
        return _fltk.Fl_Chart_bounds(self, *args)


    def size(self, *args) -> "void":
        """
        size(Fl_Chart self) -> int
        size(Fl_Chart self, int W, int H)
        """
        return _fltk.Fl_Chart_size(self, *args)


    def maxsize(self, *args) -> "void":
        """
        maxsize(Fl_Chart self) -> int
        maxsize(Fl_Chart self, int m)
        """
        return _fltk.Fl_Chart_maxsize(self, *args)


    def textfont(self, *args) -> "void":
        """
        textfont(Fl_Chart self) -> Fl_Font
        textfont(Fl_Chart self, Fl_Font s)
        """
        return _fltk.Fl_Chart_textfont(self, *args)


    def textsize(self, *args) -> "void":
        """
        textsize(Fl_Chart self) -> Fl_Fontsize
        textsize(Fl_Chart self, Fl_Fontsize s)
        """
        return _fltk.Fl_Chart_textsize(self, *args)


    def textcolor(self, *args) -> "void":
        """
        textcolor(Fl_Chart self) -> Fl_Color
        textcolor(Fl_Chart self, Fl_Color n)
        """
        return _fltk.Fl_Chart_textcolor(self, *args)


    def autosize(self, *args) -> "void":
        """
        autosize(Fl_Chart self) -> uchar
        autosize(Fl_Chart self, uchar n)
        """
        return _fltk.Fl_Chart_autosize(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Chart(self)
        return weakref_proxy(self)
Fl_Chart_swigregister = _fltk.Fl_Chart_swigregister
Fl_Chart_swigregister(Fl_Chart)

class Fl_Check_Browser(Fl_Browser_):
    """

    The Fl_Check_Browser widget displays a scrolling list of text lines that may be selected and/or checked by the user.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Check_Browser self, int x, int y, int w, int h, char const * l=None) -> Fl_Check_Browser"""
        if self.__class__ == Fl_Check_Browser:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Check_Browser(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Check_Browser
    __del__ = lambda self: None

    def remove(self, *args) -> "int":
        """remove(Fl_Check_Browser self, int item) -> int"""
        val = _fltk.Fl_Check_Browser_remove(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def add(self, *args) -> "int":
        """
        add(Fl_Check_Browser self, char const * s) -> int
        add(Fl_Check_Browser self, char const * s, int b) -> int
        """
        val = _fltk.Fl_Check_Browser_add(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def clear(self, *args) -> "void":
        """clear(Fl_Check_Browser self)"""
        return _fltk.Fl_Check_Browser_clear(self, *args)


    def nitems(self, *args) -> "int":
        """nitems(Fl_Check_Browser self) -> int"""
        return _fltk.Fl_Check_Browser_nitems(self, *args)


    def nchecked(self, *args) -> "int":
        """nchecked(Fl_Check_Browser self) -> int"""
        return _fltk.Fl_Check_Browser_nchecked(self, *args)


    def checked(self, *args) -> "void":
        """
        checked(Fl_Check_Browser self, int item) -> int
        checked(Fl_Check_Browser self, int item, int b)
        """
        return _fltk.Fl_Check_Browser_checked(self, *args)


    def set_checked(self, *args) -> "void":
        """set_checked(Fl_Check_Browser self, int item)"""
        return _fltk.Fl_Check_Browser_set_checked(self, *args)


    def check_all(self, *args) -> "void":
        """check_all(Fl_Check_Browser self)"""
        return _fltk.Fl_Check_Browser_check_all(self, *args)


    def check_none(self, *args) -> "void":
        """check_none(Fl_Check_Browser self)"""
        return _fltk.Fl_Check_Browser_check_none(self, *args)


    def value(self, *args) -> "int":
        """value(Fl_Check_Browser self) -> int"""
        return _fltk.Fl_Check_Browser_value(self, *args)


    def text(self, *args) -> "char *":
        """text(Fl_Check_Browser self, int item) -> char *"""
        return _fltk.Fl_Check_Browser_text(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Check_Browser self, int arg0) -> int"""
        return _fltk.Fl_Check_Browser_handle(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Check_Browser(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Check_Browser self)"""
        return _fltk.Fl_Check_Browser_draw(self, *args)


    def item_first(self, *args) -> "void *":
        """item_first(Fl_Check_Browser self) -> void *"""
        return _fltk.Fl_Check_Browser_item_first(self, *args)


    def item_next(self, *args) -> "void *":
        """item_next(Fl_Check_Browser self, void * item) -> void *"""
        return _fltk.Fl_Check_Browser_item_next(self, *args)


    def item_prev(self, *args) -> "void *":
        """item_prev(Fl_Check_Browser self, void * item) -> void *"""
        return _fltk.Fl_Check_Browser_item_prev(self, *args)


    def item_last(self, *args) -> "void *":
        """item_last(Fl_Check_Browser self) -> void *"""
        return _fltk.Fl_Check_Browser_item_last(self, *args)


    def item_height(self, *args) -> "int":
        """item_height(Fl_Check_Browser self, void * item) -> int"""
        return _fltk.Fl_Check_Browser_item_height(self, *args)


    def item_width(self, *args) -> "int":
        """item_width(Fl_Check_Browser self, void * item) -> int"""
        return _fltk.Fl_Check_Browser_item_width(self, *args)


    def item_quick_height(self, *args) -> "int":
        """item_quick_height(Fl_Check_Browser self, void * item) -> int"""
        return _fltk.Fl_Check_Browser_item_quick_height(self, *args)


    def item_draw(self, *args) -> "void":
        """item_draw(Fl_Check_Browser self, void * item, int X, int Y, int W, int H)"""
        return _fltk.Fl_Check_Browser_item_draw(self, *args)


    def item_text(self, *args) -> "char const *":
        """item_text(Fl_Check_Browser self, void * item) -> char const *"""
        return _fltk.Fl_Check_Browser_item_text(self, *args)


    def item_swap(self, *args) -> "void":
        """item_swap(Fl_Check_Browser self, void * a, void * b)"""
        return _fltk.Fl_Check_Browser_item_swap(self, *args)


    def item_at(self, *args) -> "void *":
        """item_at(Fl_Check_Browser self, int index) -> void *"""
        return _fltk.Fl_Check_Browser_item_at(self, *args)


    def full_width(self, *args) -> "int":
        """full_width(Fl_Check_Browser self) -> int"""
        return _fltk.Fl_Check_Browser_full_width(self, *args)


    def full_height(self, *args) -> "int":
        """full_height(Fl_Check_Browser self) -> int"""
        return _fltk.Fl_Check_Browser_full_height(self, *args)


    def incr_height(self, *args) -> "int":
        """incr_height(Fl_Check_Browser self) -> int"""
        return _fltk.Fl_Check_Browser_incr_height(self, *args)


    def item_select(self, *args) -> "void":
        """item_select(Fl_Check_Browser self, void * item, int val=1)"""
        return _fltk.Fl_Check_Browser_item_select(self, *args)


    def item_selected(self, *args) -> "int":
        """item_selected(Fl_Check_Browser self, void * item) -> int"""
        return _fltk.Fl_Check_Browser_item_selected(self, *args)

Fl_Check_Browser_swigregister = _fltk.Fl_Check_Browser_swigregister
Fl_Check_Browser_swigregister(Fl_Check_Browser)

class Fl_Light_Button(Fl_Button):
    """

    Buttons generate callbacks when they are clicked by the user. You control 
    exactly when and how by changing the values for type() and when().

    The Fl_Light_Button subclass display the 'on' state by turning on a light, 
    rather than drawing pushed in. The shape of the 'light' is initially set 
    to FL_DOWN_BOX. The color of the light when on is controlled with 
    selection_color(), which defaults to FL_YELLOW.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Light_Button self)"""
        return _fltk.Fl_Light_Button_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Light_Button self, int arg0) -> int"""
        return _fltk.Fl_Light_Button_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Light_Button self, int x, int y, int w, int h, char const * l=None) -> Fl_Light_Button"""
        if self.__class__ == Fl_Light_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Light_Button(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Light_Button
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Light_Button(self)
        return weakref_proxy(self)
Fl_Light_Button_swigregister = _fltk.Fl_Light_Button_swigregister
Fl_Light_Button_swigregister(Fl_Light_Button)

class Fl_Check_Button(Fl_Light_Button):
    """

    Buttons generate callbacks when they are clicked by the user. You control 
    exactly when and how by changing the values for type() and when().

    The Fl_Check_Button subclass display the 'on' state by turning on a light, 
    rather than drawing pushed in. The shape of the 'light' is initially set to 
    FL_DIAMOND_DOWN_BOX. The color of the light when on is controlled with 
    selection_color(), which defaults to FL_RED.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Check_Button self, int X, int Y, int W, int H, char const * L=None) -> Fl_Check_Button"""
        if self.__class__ == Fl_Check_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Check_Button(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Check_Button
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Check_Button(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Check_Button self)"""
        return _fltk.Fl_Check_Button_draw(self, *args)

Fl_Check_Button_swigregister = _fltk.Fl_Check_Button_swigregister
Fl_Check_Button_swigregister(Fl_Check_Button)

class Fl_Menu_(Fl_Widget):
    """

    All widgets that have a menu in FLTK are subclassed off of this class. 
    Currently FLTK provides you with Fl_Menu_Button, Fl_Menu_Bar, and Fl_Choice .

    The class contains a pointer to an array of structures of type Fl_Menu_Item. 
    The array may either be supplied directly by the user program, or it may be 
    'private': a dynamically allocated array managed by the Fl_Menu_. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Menu_ self, int arg2, int arg3, int arg4, int arg5, char const * arg6=None) -> Fl_Menu_"""
        if self.__class__ == Fl_Menu_:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Menu_(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Menu_
    __del__ = lambda self: None

    def item_pathname(self, *args) -> "int":
        """item_pathname(Fl_Menu_ self, char * name, int namelen, Fl_Menu_Item finditem=None) -> int"""
        return _fltk.Fl_Menu__item_pathname(self, *args)


    def picked(self, *args) -> "Fl_Menu_Item const *":
        """picked(Fl_Menu_ self, Fl_Menu_Item arg2) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu__picked(self, *args)


    def find_item(self, *args) -> "Fl_Menu_Item const *":
        """
        find_item(Fl_Menu_ self, char const * name) -> Fl_Menu_Item
        find_item(Fl_Menu_ self, Fl_Callback * arg2) -> Fl_Menu_Item
        """
        return _fltk.Fl_Menu__find_item(self, *args)


    def find_index(self, *args) -> "int":
        """
        find_index(Fl_Menu_ self, char const * name) -> int
        find_index(Fl_Menu_ self, Fl_Menu_Item item) -> int
        find_index(Fl_Menu_ self, Fl_Callback * cb) -> int
        """
        return _fltk.Fl_Menu__find_index(self, *args)


    def test_shortcut(self, *args) -> "Fl_Menu_Item const *":
        """test_shortcut(Fl_Menu_ self) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu__test_shortcut(self, *args)


    def insert(self, *args) -> "int":
        """
        insert(Fl_Menu_ self, int index, char const * arg3, int shortcut, Fl_Callback * arg5, void * arg6=None, int arg7=0) -> int
        insert(Fl_Menu_ self, int index, char const * a, char const * b, Fl_Callback * c, void * d=None, int e=0) -> int
        """
        return _fltk.Fl_Menu__insert(self, *args)


    def size(self, *args) -> "void":
        """
        size(Fl_Menu_ self) -> int
        size(Fl_Menu_ self, int W, int H)
        """
        return _fltk.Fl_Menu__size(self, *args)


    def clear(self, *args) -> "void":
        """clear(Fl_Menu_ self)"""
        return _fltk.Fl_Menu__clear(self, *args)


    def clear_submenu(self, *args) -> "int":
        """clear_submenu(Fl_Menu_ self, int index) -> int"""
        return _fltk.Fl_Menu__clear_submenu(self, *args)


    def replace(self, *args) -> "void":
        """replace(Fl_Menu_ self, int arg2, char const * arg3)"""
        return _fltk.Fl_Menu__replace(self, *args)


    def remove(self, *args) -> "void":
        """remove(Fl_Menu_ self, int arg2)"""
        return _fltk.Fl_Menu__remove(self, *args)


    def shortcut(self, *args) -> "void":
        """shortcut(Fl_Menu_ self, int i, int s)"""
        return _fltk.Fl_Menu__shortcut(self, *args)


    def mode(self, *args) -> "int":
        """
        mode(Fl_Menu_ self, int i, int fl)
        mode(Fl_Menu_ self, int i) -> int
        """
        return _fltk.Fl_Menu__mode(self, *args)


    def mvalue(self, *args) -> "Fl_Menu_Item const *":
        """mvalue(Fl_Menu_ self) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu__mvalue(self, *args)


    def value(self, *args) -> "int":
        """
        value(Fl_Menu_ self) -> int
        value(Fl_Menu_ self, int i) -> int
        """
        return _fltk.Fl_Menu__value(self, *args)


    def text(self, *args) -> "char const *":
        """
        text(Fl_Menu_ self) -> char const
        text(Fl_Menu_ self, int i) -> char const *
        """
        return _fltk.Fl_Menu__text(self, *args)


    def textfont(self, *args) -> "void":
        """
        textfont(Fl_Menu_ self) -> Fl_Font
        textfont(Fl_Menu_ self, Fl_Font c)
        """
        return _fltk.Fl_Menu__textfont(self, *args)


    def textsize(self, *args) -> "void":
        """
        textsize(Fl_Menu_ self) -> Fl_Fontsize
        textsize(Fl_Menu_ self, Fl_Fontsize c)
        """
        return _fltk.Fl_Menu__textsize(self, *args)


    def textcolor(self, *args) -> "void":
        """
        textcolor(Fl_Menu_ self) -> Fl_Color
        textcolor(Fl_Menu_ self, Fl_Color c)
        """
        return _fltk.Fl_Menu__textcolor(self, *args)


    def down_box(self, *args) -> "void":
        """
        down_box(Fl_Menu_ self) -> Fl_Boxtype
        down_box(Fl_Menu_ self, Fl_Boxtype b)
        """
        return _fltk.Fl_Menu__down_box(self, *args)


    def down_color(self, *args) -> "void":
        """
        down_color(Fl_Menu_ self) -> Fl_Color
        down_color(Fl_Menu_ self, unsigned int c)
        """
        return _fltk.Fl_Menu__down_color(self, *args)


    def setonly(self, *args) -> "void":
        """setonly(Fl_Menu_ self, Fl_Menu_Item item)"""
        return _fltk.Fl_Menu__setonly(self, *args)


    def copy(self, *args) -> "void":
        """
        copy(Fl_Menu_ self, Fl_Menu_Item m, void * user_data=None)
        copy(Fl_Menu_ self, PyObject * args, PyObject * user_data=None)
        """
        return _fltk.Fl_Menu__copy(self, *args)


    def add(self, *args) -> "int":
        """
        add(Fl_Menu_ self, char const * arg2, int shortcut, Fl_Callback * arg4, void * arg5=None, int arg6=0) -> int
        add(Fl_Menu_ self, char const * arg2) -> int
        add(Fl_Menu_ self, PyObject * lObj, PyObject * sObj, PyObject * cObj, PyObject * uObj=None, PyObject * fObj=None) -> int
        """
        return _fltk.Fl_Menu__add(self, *args)


    def menu(self, *args) -> "PyObject *":
        """
        menu(Fl_Menu_ self) -> Fl_Menu_Item
        menu(Fl_Menu_ self, PyObject * args)
        menu(Fl_Menu_ self) -> PyObject *
        """
        return _fltk.Fl_Menu__menu(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Menu_(self)
        return weakref_proxy(self)
Fl_Menu__swigregister = _fltk.Fl_Menu__swigregister
Fl_Menu__swigregister(Fl_Menu_)

class Fl_Choice(Fl_Menu_):
    """

    This is a button that when pushed pops up a menu (or hierarchy of menus) 
    defined by an array of Fl_Menu_Item objects. Motif calls this an OptionButton.

    The only difference between this and a Fl_Menu_Button is that the name of 
    the most recent chosen menu item is displayed inside the box, while the 
    label is displayed outside the box. However, since the use of this is most 
    often to control a single variable rather than do individual callbacks, some 
    of the Fl_Menu_Button methods are redescribed here in those terms.

    When the user picks an item off the menu the value() is set to that item and 
    then the item's callback is done with the menu_button as the Fl_Widget 
    argument. If the item does not have a callback the menu_button's callback is 
    done instead.

    All three mouse buttons pop up the menu. The Forms behavior of the first two 
    buttons to increment/decrement the choice is not implemented. This could be 
    added with a subclass, however.

    The menu will also pop up in response to shortcuts indicated by putting a '&' 
    character in the label(). See Fl_Button for a description of this.

    Typing the shortcut() of any of the items will do exactly the same as when 
    you pick the item with the mouse. The '&' character in item names are only 
    looked at when the menu is popped up, however. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Choice self)"""
        return _fltk.Fl_Choice_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Choice self, int arg0) -> int"""
        return _fltk.Fl_Choice_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Choice self, int X, int Y, int W, int H, char const * L=None) -> Fl_Choice"""
        if self.__class__ == Fl_Choice:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Choice(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def value(self, *args) -> "int":
        """
        value(Fl_Choice self) -> int
        value(Fl_Choice self, int v) -> int
        """
        return _fltk.Fl_Choice_value(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Choice
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Choice(self)
        return weakref_proxy(self)
Fl_Choice_swigregister = _fltk.Fl_Choice_swigregister
Fl_Choice_swigregister(Fl_Choice)

FL_SQUARE_CLOCK = _fltk.FL_SQUARE_CLOCK
FL_ROUND_CLOCK = _fltk.FL_ROUND_CLOCK
FL_ANALOG_CLOCK = _fltk.FL_ANALOG_CLOCK
FL_DIGITAL_CLOCK = _fltk.FL_DIGITAL_CLOCK
class Fl_Clock_Output(Fl_Widget):
    """Proxy of C++ Fl_Clock_Output class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Clock_Output self)"""
        return _fltk.Fl_Clock_Output_draw(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Clock_Output self, int X, int Y, int W, int H, char const * L=None) -> Fl_Clock_Output"""
        if self.__class__ == Fl_Clock_Output:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Clock_Output(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def value(self, *args) -> "ulong":
        """
        value(Fl_Clock_Output self, ulong v)
        value(Fl_Clock_Output self, int H, int m, int s)
        value(Fl_Clock_Output self) -> ulong
        """
        return _fltk.Fl_Clock_Output_value(self, *args)


    def hour(self, *args) -> "int":
        """hour(Fl_Clock_Output self) -> int"""
        return _fltk.Fl_Clock_Output_hour(self, *args)


    def minute(self, *args) -> "int":
        """minute(Fl_Clock_Output self) -> int"""
        return _fltk.Fl_Clock_Output_minute(self, *args)


    def second(self, *args) -> "int":
        """second(Fl_Clock_Output self) -> int"""
        return _fltk.Fl_Clock_Output_second(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Clock_Output
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Clock_Output(self)
        return weakref_proxy(self)
Fl_Clock_Output_swigregister = _fltk.Fl_Clock_Output_swigregister
Fl_Clock_Output_swigregister(Fl_Clock_Output)

class Fl_Clock(Fl_Clock_Output):
    """

    This widget provides a round analog clock display and is provided for Forms 
    compatibility. It installs a 1-second timeout callback using Fl.add_timeout().

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def handle(self, *args) -> "int":
        """handle(Fl_Clock self, int arg0) -> int"""
        return _fltk.Fl_Clock_handle(self, *args)


    def __init__(self, *args):
        """
        __init__(Fl_Clock self, int X, int Y, int W, int H, char const * L=None) -> Fl_Clock
        __init__(Fl_Clock self, uchar t, int X, int Y, int W, int H, char const * L) -> Fl_Clock
        """
        if self.__class__ == Fl_Clock:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Clock(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Clock
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Clock(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Clock self)"""
        return _fltk.Fl_Clock_draw(self, *args)

Fl_Clock_swigregister = _fltk.Fl_Clock_swigregister
Fl_Clock_swigregister(Fl_Clock)

class Fl_Value_Input(Fl_Valuator):
    """

    The Fl_Value_Input widget displays a numeric value. The user can click in 
    the text field and edit it - there is in fact a hidden Fl_Input widget with 
    type(FL_FLOAT_INPUT) or type(FL_INT_INPUT) in there - and when they hit 
    return or tab the value updates to what they typed and the callback is done.

    If step() is non-zero, the user can also drag the mouse across the object 
    and thus slide the value. The left button moves one step() per pixel, the 
    middle by 10 * step(), and the right button by 100 * step(). It is therefore 
    impossible to select text by dragging across it, although clicking can still 
    move the insertion cursor.

    If step() is non-zero and integral, then the range of numbers are limited 
    to integers instead of floating point values. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def handle(self, *args) -> "int":
        """handle(Fl_Value_Input self, int arg0) -> int"""
        return _fltk.Fl_Value_Input_handle(self, *args)


    def draw(self, *args) -> "void":
        """draw(Fl_Value_Input self)"""
        return _fltk.Fl_Value_Input_draw(self, *args)


    def resize(self, *args) -> "void":
        """resize(Fl_Value_Input self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Value_Input_resize(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Value_Input self, int x, int y, int w, int h, char const * l=None) -> Fl_Value_Input"""
        if self.__class__ == Fl_Value_Input:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Value_Input(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Value_Input
    __del__ = lambda self: None

    def soft(self, *args) -> "char":
        """
        soft(Fl_Value_Input self, char s)
        soft(Fl_Value_Input self) -> char
        """
        return _fltk.Fl_Value_Input_soft(self, *args)


    def shortcut(self, *args) -> "void":
        """
        shortcut(Fl_Value_Input self) -> int
        shortcut(Fl_Value_Input self, int s)
        """
        return _fltk.Fl_Value_Input_shortcut(self, *args)


    def textfont(self, *args) -> "void":
        """
        textfont(Fl_Value_Input self) -> Fl_Font
        textfont(Fl_Value_Input self, Fl_Font s)
        """
        return _fltk.Fl_Value_Input_textfont(self, *args)


    def textsize(self, *args) -> "void":
        """
        textsize(Fl_Value_Input self) -> Fl_Fontsize
        textsize(Fl_Value_Input self, Fl_Fontsize s)
        """
        return _fltk.Fl_Value_Input_textsize(self, *args)


    def textcolor(self, *args) -> "void":
        """
        textcolor(Fl_Value_Input self) -> Fl_Color
        textcolor(Fl_Value_Input self, Fl_Color n)
        """
        return _fltk.Fl_Value_Input_textcolor(self, *args)


    def cursor_color(self, *args) -> "void":
        """
        cursor_color(Fl_Value_Input self) -> Fl_Color
        cursor_color(Fl_Value_Input self, Fl_Color n)
        """
        return _fltk.Fl_Value_Input_cursor_color(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Value_Input(self)
        return weakref_proxy(self)
Fl_Value_Input_swigregister = _fltk.Fl_Value_Input_swigregister
Fl_Value_Input_swigregister(Fl_Value_Input)

class Flcc_HueBox(Fl_Widget):
    """Proxy of C++ Flcc_HueBox class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Flcc_HueBox self)"""
        return _fltk.Flcc_HueBox_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Flcc_HueBox self, int arg0) -> int"""
        return _fltk.Flcc_HueBox_handle(self, *args)


    def __init__(self, *args):
        """__init__(Flcc_HueBox self, int X, int Y, int W, int H) -> Flcc_HueBox"""
        if self.__class__ == Flcc_HueBox:
            _self = None
        else:
            _self = self
        this = _fltk.new_Flcc_HueBox(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Flcc_HueBox
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Flcc_HueBox(self)
        return weakref_proxy(self)
Flcc_HueBox_swigregister = _fltk.Flcc_HueBox_swigregister
Flcc_HueBox_swigregister(Flcc_HueBox)

class Flcc_ValueBox(Fl_Widget):
    """Proxy of C++ Flcc_ValueBox class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Flcc_ValueBox self)"""
        return _fltk.Flcc_ValueBox_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Flcc_ValueBox self, int arg0) -> int"""
        return _fltk.Flcc_ValueBox_handle(self, *args)


    def __init__(self, *args):
        """__init__(Flcc_ValueBox self, int X, int Y, int W, int H) -> Flcc_ValueBox"""
        if self.__class__ == Flcc_ValueBox:
            _self = None
        else:
            _self = self
        this = _fltk.new_Flcc_ValueBox(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Flcc_ValueBox
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Flcc_ValueBox(self)
        return weakref_proxy(self)
Flcc_ValueBox_swigregister = _fltk.Flcc_ValueBox_swigregister
Flcc_ValueBox_swigregister(Flcc_ValueBox)

class Flcc_Value_Input(Fl_Value_Input):
    """Proxy of C++ Flcc_Value_Input class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def format(self, *args) -> "int":
        """format(Flcc_Value_Input self, char * arg0) -> int"""
        return _fltk.Flcc_Value_Input_format(self, *args)


    def __init__(self, *args):
        """__init__(Flcc_Value_Input self, int X, int Y, int W, int H) -> Flcc_Value_Input"""
        if self.__class__ == Flcc_Value_Input:
            _self = None
        else:
            _self = self
        this = _fltk.new_Flcc_Value_Input(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Flcc_Value_Input
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Flcc_Value_Input(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Flcc_Value_Input self)"""
        return _fltk.Flcc_Value_Input_draw(self, *args)

Flcc_Value_Input_swigregister = _fltk.Flcc_Value_Input_swigregister
Flcc_Value_Input_swigregister(Flcc_Value_Input)

class Fl_Color_Chooser(Fl_Group):
    """

    The Fl_Color_Chooser widget provides a standard RGB color chooser. You can 
    place any number of these into a panel of your own design. This widget 
    contains the hue box, value slider, and rgb input fields from the above 
    diagram (it does not have the color chips or the Cancel or OK buttons). The 
    callback is done every time the user changes the rgb value. It is not done 
    if they move the hue control in a way that produces the same rgb value, such 
    as when saturation or value is zero.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def mode(self, *args) -> "void":
        """
        mode(Fl_Color_Chooser self) -> int
        mode(Fl_Color_Chooser self, int newMode)
        """
        return _fltk.Fl_Color_Chooser_mode(self, *args)


    def hue(self, *args) -> "double":
        """hue(Fl_Color_Chooser self) -> double"""
        return _fltk.Fl_Color_Chooser_hue(self, *args)


    def saturation(self, *args) -> "double":
        """saturation(Fl_Color_Chooser self) -> double"""
        return _fltk.Fl_Color_Chooser_saturation(self, *args)


    def value(self, *args) -> "double":
        """value(Fl_Color_Chooser self) -> double"""
        return _fltk.Fl_Color_Chooser_value(self, *args)


    def r(self, *args) -> "double":
        """r(Fl_Color_Chooser self) -> double"""
        return _fltk.Fl_Color_Chooser_r(self, *args)


    def g(self, *args) -> "double":
        """g(Fl_Color_Chooser self) -> double"""
        return _fltk.Fl_Color_Chooser_g(self, *args)


    def b(self, *args) -> "double":
        """b(Fl_Color_Chooser self) -> double"""
        return _fltk.Fl_Color_Chooser_b(self, *args)


    def hsv(self, *args) -> "int":
        """hsv(Fl_Color_Chooser self, double H, double S, double V) -> int"""
        return _fltk.Fl_Color_Chooser_hsv(self, *args)


    def rgb(self, *args) -> "int":
        """rgb(Fl_Color_Chooser self, double R, double G, double B) -> int"""
        return _fltk.Fl_Color_Chooser_rgb(self, *args)


    def hsv2rgb(*args) -> "void":
        """hsv2rgb(double H, double S, double V, double & R, double & G, double & B)"""
        return _fltk.Fl_Color_Chooser_hsv2rgb(*args)

    hsv2rgb = staticmethod(hsv2rgb)

    def rgb2hsv(*args) -> "void":
        """rgb2hsv(double R, double G, double B, double & H, double & S, double & V)"""
        return _fltk.Fl_Color_Chooser_rgb2hsv(*args)

    rgb2hsv = staticmethod(rgb2hsv)

    def __init__(self, *args):
        """__init__(Fl_Color_Chooser self, int X, int Y, int W, int H, char const * L=None) -> Fl_Color_Chooser"""
        if self.__class__ == Fl_Color_Chooser:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Color_Chooser(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Color_Chooser
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Color_Chooser(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Color_Chooser self)"""
        return _fltk.Fl_Color_Chooser_draw(self, *args)

Fl_Color_Chooser_swigregister = _fltk.Fl_Color_Chooser_swigregister
Fl_Color_Chooser_swigregister(Fl_Color_Chooser)

def Fl_Color_Chooser_hsv2rgb(*args) -> "void":
    """Fl_Color_Chooser_hsv2rgb(double H, double S, double V, double & R, double & G, double & B)"""
    return _fltk.Fl_Color_Chooser_hsv2rgb(*args)

def Fl_Color_Chooser_rgb2hsv(*args) -> "void":
    """Fl_Color_Chooser_rgb2hsv(double R, double G, double B, double & H, double & S, double & V)"""
    return _fltk.Fl_Color_Chooser_rgb2hsv(*args)


def fl_color_chooser(*args) -> "unsigned char &, unsigned char &, unsigned char &":
    """
    fl_color_chooser(char const * name, double & r, double & g, double & b, int m=-1) -> int
    fl_color_chooser(char const * name, uchar & r, uchar & g, uchar & b, int m=-1) -> int
    """
    return _fltk.fl_color_chooser(*args)
FL_NORMAL_COUNTER = _fltk.FL_NORMAL_COUNTER
FL_SIMPLE_COUNTER = _fltk.FL_SIMPLE_COUNTER
class Fl_Counter(Fl_Valuator):
    """

    The Fl_Counter widget is provided for forms compatibility. It controls a 
    single floating point value.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Counter self)"""
        return _fltk.Fl_Counter_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Counter self, int arg0) -> int"""
        return _fltk.Fl_Counter_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Counter self, int X, int Y, int W, int H, char const * L=None) -> Fl_Counter"""
        if self.__class__ == Fl_Counter:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Counter(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Counter
    __del__ = lambda self: None

    def lstep(self, *args) -> "void":
        """lstep(Fl_Counter self, double a)"""
        return _fltk.Fl_Counter_lstep(self, *args)


    def step(self, *args) -> "double":
        """
        step(Fl_Counter self, double a, double b)
        step(Fl_Counter self, double a)
        step(Fl_Counter self) -> double
        """
        return _fltk.Fl_Counter_step(self, *args)


    def textfont(self, *args) -> "void":
        """
        textfont(Fl_Counter self) -> Fl_Font
        textfont(Fl_Counter self, Fl_Font s)
        """
        return _fltk.Fl_Counter_textfont(self, *args)


    def textsize(self, *args) -> "void":
        """
        textsize(Fl_Counter self) -> Fl_Fontsize
        textsize(Fl_Counter self, Fl_Fontsize s)
        """
        return _fltk.Fl_Counter_textsize(self, *args)


    def textcolor(self, *args) -> "void":
        """
        textcolor(Fl_Counter self) -> Fl_Color
        textcolor(Fl_Counter self, Fl_Color s)
        """
        return _fltk.Fl_Counter_textcolor(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Counter(self)
        return weakref_proxy(self)
Fl_Counter_swigregister = _fltk.Fl_Counter_swigregister
Fl_Counter_swigregister(Fl_Counter)

FL_NORMAL_DIAL = _fltk.FL_NORMAL_DIAL
FL_LINE_DIAL = _fltk.FL_LINE_DIAL
FL_FILL_DIAL = _fltk.FL_FILL_DIAL
class Fl_Dial(Fl_Valuator):
    """

    The Fl_Dial widget provides a circular dial to control a single floating 
    point value.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Dial self)"""
        return _fltk.Fl_Dial_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Dial self, int arg0) -> int"""
        return _fltk.Fl_Dial_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Dial self, int x, int y, int w, int h, char const * l=None) -> Fl_Dial"""
        if self.__class__ == Fl_Dial:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Dial(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def angle1(self, *args) -> "void":
        """
        angle1(Fl_Dial self) -> short
        angle1(Fl_Dial self, short a)
        """
        return _fltk.Fl_Dial_angle1(self, *args)


    def angle2(self, *args) -> "void":
        """
        angle2(Fl_Dial self) -> short
        angle2(Fl_Dial self, short a)
        """
        return _fltk.Fl_Dial_angle2(self, *args)


    def angles(self, *args) -> "void":
        """angles(Fl_Dial self, short a, short b)"""
        return _fltk.Fl_Dial_angles(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Dial
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Dial(self)
        return weakref_proxy(self)
Fl_Dial_swigregister = _fltk.Fl_Dial_swigregister
Fl_Dial_swigregister(Fl_Dial)

FL_WINDOW = _fltk.FL_WINDOW
FL_DOUBLE_WINDOW = _fltk.FL_DOUBLE_WINDOW
class Fl_Window(Fl_Group):
    """

    This widget produces an actual window. This can either be a main window, 
    with a border and title and all the window management controls, or a 
    'subwindow' inside a window. This is controlled by whether or not the 
    window has a parent().

    Once you create a window, you usually add children Fl_Widget 's to it by 
    using window->add(child) for each new widget. See Fl_Group for more 
    information on how to add and remove children.

    There are several subclasses of Fl_Window that provide double-buffering, 
    overlay, menu, and OpenGL support.

    The window's callback is done if the user tries to close a window using 
    the window manager and Fl.modal() is zero or equal to the window. Fl_Window 
    has a default callback that calls Fl_Window.hide(). 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def shape(self, *args) -> "void":
        """
        shape(Fl_Window self, Fl_Image img)
        shape(Fl_Window self, Fl_Image b)
        """
        return _fltk.Fl_Window_shape(self, *args)


    def draw(self, *args) -> "void":
        """draw(Fl_Window self)"""
        return _fltk.Fl_Window_draw(self, *args)


    def flush(self, *args) -> "void":
        """flush(Fl_Window self)"""
        return _fltk.Fl_Window_flush(self, *args)


    def __init__(self, *args):
        """
        __init__(Fl_Window self, int w, int h, char const * title=None) -> Fl_Window
        __init__(Fl_Window self, int x, int y, int w, int h, char const * title=None) -> Fl_Window
        """
        if self.__class__ == Fl_Window:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Window(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Window
    __del__ = lambda self: None

    def handle(self, *args) -> "int":
        """handle(Fl_Window self, int arg0) -> int"""
        return _fltk.Fl_Window_handle(self, *args)


    def resize(self, *args) -> "void":
        """resize(Fl_Window self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Window_resize(self, *args)


    def clear_border(self, *args) -> "void":
        """clear_border(Fl_Window self)"""
        return _fltk.Fl_Window_clear_border(self, *args)


    def border(self, *args) -> "unsigned int":
        """
        border(Fl_Window self, int b)
        border(Fl_Window self) -> unsigned int
        """
        return _fltk.Fl_Window_border(self, *args)


    def set_override(self, *args) -> "void":
        """set_override(Fl_Window self)"""
        return _fltk.Fl_Window_set_override(self, *args)


    def override(self, *args) -> "unsigned int":
        """override(Fl_Window self) -> unsigned int"""
        return _fltk.Fl_Window_override(self, *args)


    def set_modal(self, *args) -> "void":
        """set_modal(Fl_Window self)"""
        return _fltk.Fl_Window_set_modal(self, *args)


    def modal(self, *args) -> "unsigned int":
        """modal(Fl_Window self) -> unsigned int"""
        return _fltk.Fl_Window_modal(self, *args)


    def set_non_modal(self, *args) -> "void":
        """set_non_modal(Fl_Window self)"""
        return _fltk.Fl_Window_set_non_modal(self, *args)


    def non_modal(self, *args) -> "unsigned int":
        """non_modal(Fl_Window self) -> unsigned int"""
        return _fltk.Fl_Window_non_modal(self, *args)


    def clear_modal_states(self, *args) -> "void":
        """clear_modal_states(Fl_Window self)"""
        return _fltk.Fl_Window_clear_modal_states(self, *args)


    def set_menu_window(self, *args) -> "void":
        """set_menu_window(Fl_Window self)"""
        return _fltk.Fl_Window_set_menu_window(self, *args)


    def menu_window(self, *args) -> "unsigned int":
        """menu_window(Fl_Window self) -> unsigned int"""
        return _fltk.Fl_Window_menu_window(self, *args)


    def set_tooltip_window(self, *args) -> "void":
        """set_tooltip_window(Fl_Window self)"""
        return _fltk.Fl_Window_set_tooltip_window(self, *args)


    def tooltip_window(self, *args) -> "unsigned int":
        """tooltip_window(Fl_Window self) -> unsigned int"""
        return _fltk.Fl_Window_tooltip_window(self, *args)


    def hotspot(self, *args) -> "void":
        """
        hotspot(Fl_Window self, int x, int y, int offscreen=0)
        hotspot(Fl_Window self, Fl_Widget arg2, int offscreen=0)
        """
        return _fltk.Fl_Window_hotspot(self, *args)


    def free_position(self, *args) -> "void":
        """free_position(Fl_Window self)"""
        return _fltk.Fl_Window_free_position(self, *args)


    def size_range(self, *args) -> "void":
        """size_range(Fl_Window self, int minw, int minh, int maxw=0, int maxh=0, int dw=0, int dh=0, int aspect=0)"""
        return _fltk.Fl_Window_size_range(self, *args)


    def iconlabel(self, *args) -> "void":
        """
        iconlabel(Fl_Window self) -> char const
        iconlabel(Fl_Window self, char const * arg2)
        """
        return _fltk.Fl_Window_iconlabel(self, *args)


    def label(self, *args) -> "void":
        """
        label(Fl_Window self) -> char const
        label(Fl_Window self, char const * arg2)
        label(Fl_Window self, char const * label, char const * iconlabel)
        """
        val = _fltk.Fl_Window_label(self, *args)

        if len(args) > 0:
            self.my_label = args[len(args)-1]


        return val


    def copy_label(self, *args) -> "void":
        """copy_label(Fl_Window self, char const * a)"""
        return _fltk.Fl_Window_copy_label(self, *args)


    def default_xclass(*args) -> "char const *":
        """
        default_xclass(char const * arg1)
        default_xclass() -> char const *
        """
        return _fltk.Fl_Window_default_xclass(*args)

    default_xclass = staticmethod(default_xclass)

    def xclass(self, *args) -> "void":
        """
        xclass(Fl_Window self) -> char const
        xclass(Fl_Window self, char const * c)
        """
        return _fltk.Fl_Window_xclass(self, *args)


    def default_icon(*args) -> "void":
        """default_icon(Fl_RGB_Image arg1)"""
        return _fltk.Fl_Window_default_icon(*args)

    default_icon = staticmethod(default_icon)

    def default_icons(*args) -> "void":
        """default_icons(Fl_RGB_Image const *[] arg1, int arg2)"""
        return _fltk.Fl_Window_default_icons(*args)

    default_icons = staticmethod(default_icons)

    def icons(self, *args) -> "void":
        """icons(Fl_Window self, Fl_RGB_Image const *[] arg2, int arg3)"""
        return _fltk.Fl_Window_icons(self, *args)


    def icon(self, *args) -> "void":
        """
        icon(Fl_Window self, Fl_RGB_Image arg2)
        icon(Fl_Window self) -> void const
        icon(Fl_Window self, void const * ic)
        """
        return _fltk.Fl_Window_icon(self, *args)


    def shown(self, *args) -> "int":
        """shown(Fl_Window self) -> int"""
        return _fltk.Fl_Window_shown(self, *args)


    def hide(self, *args) -> "void":
        """hide(Fl_Window self)"""
        return _fltk.Fl_Window_hide(self, *args)


    def wait_for_expose(self, *args) -> "void":
        """wait_for_expose(Fl_Window self)"""
        return _fltk.Fl_Window_wait_for_expose(self, *args)


    def fullscreen(self, *args) -> "void":
        """fullscreen(Fl_Window self)"""
        return _fltk.Fl_Window_fullscreen(self, *args)


    def fullscreen_off(self, *args) -> "void":
        """
        fullscreen_off(Fl_Window self)
        fullscreen_off(Fl_Window self, int X, int Y, int W, int H)
        """
        return _fltk.Fl_Window_fullscreen_off(self, *args)


    def fullscreen_active(self, *args) -> "unsigned int":
        """fullscreen_active(Fl_Window self) -> unsigned int"""
        return _fltk.Fl_Window_fullscreen_active(self, *args)


    def fullscreen_screens(self, *args) -> "void":
        """fullscreen_screens(Fl_Window self, int top, int bottom, int left, int right)"""
        return _fltk.Fl_Window_fullscreen_screens(self, *args)


    def iconize(self, *args) -> "void":
        """iconize(Fl_Window self)"""
        return _fltk.Fl_Window_iconize(self, *args)


    def x_root(self, *args) -> "int":
        """x_root(Fl_Window self) -> int"""
        return _fltk.Fl_Window_x_root(self, *args)


    def y_root(self, *args) -> "int":
        """y_root(Fl_Window self) -> int"""
        return _fltk.Fl_Window_y_root(self, *args)


    def current(*args) -> "Fl_Window *":
        """current() -> Fl_Window"""
        return _fltk.Fl_Window_current(*args)

    current = staticmethod(current)

    def make_current(self, *args) -> "void":
        """make_current(Fl_Window self)"""
        return _fltk.Fl_Window_make_current(self, *args)


    def as_window(self, *args) -> "Fl_Window *":
        """as_window(Fl_Window self) -> Fl_Window"""
        return _fltk.Fl_Window_as_window(self, *args)


    def cursor(self, *args) -> "void":
        """
        cursor(Fl_Window self, Fl_Cursor arg2)
        cursor(Fl_Window self, Fl_RGB_Image arg2, int arg3, int arg4)
        cursor(Fl_Window self, Fl_Cursor c, Fl_Color arg3, Fl_Color arg4)
        """
        return _fltk.Fl_Window_cursor(self, *args)


    def default_cursor(self, *args) -> "void":
        """
        default_cursor(Fl_Window self, Fl_Cursor arg2)
        default_cursor(Fl_Window self, Fl_Cursor c, Fl_Color arg3, Fl_Color arg4)
        """
        return _fltk.Fl_Window_default_cursor(self, *args)


    def default_callback(*args) -> "void":
        """default_callback(Fl_Window arg1, void * v)"""
        return _fltk.Fl_Window_default_callback(*args)

    default_callback = staticmethod(default_callback)

    def decorated_w(self, *args) -> "int":
        """decorated_w(Fl_Window self) -> int"""
        return _fltk.Fl_Window_decorated_w(self, *args)


    def decorated_h(self, *args) -> "int":
        """decorated_h(Fl_Window self) -> int"""
        return _fltk.Fl_Window_decorated_h(self, *args)


    def show(self, *args) -> "void":
        """show(Fl_Window self, PyObject * count=None, PyObject * data=None)"""
        return _fltk.Fl_Window_show(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Window(self)
        return weakref_proxy(self)
Fl_Window_swigregister = _fltk.Fl_Window_swigregister
Fl_Window_swigregister(Fl_Window)

def Fl_Window_default_xclass(*args) -> "char const *":
    """
    default_xclass(char const * arg1)
    Fl_Window_default_xclass() -> char const *
    """
    return _fltk.Fl_Window_default_xclass(*args)

def Fl_Window_default_icon(*args) -> "void":
    """Fl_Window_default_icon(Fl_RGB_Image arg2)"""
    return _fltk.Fl_Window_default_icon(*args)

def Fl_Window_default_icons(*args) -> "void":
    """Fl_Window_default_icons(Fl_RGB_Image const *[] arg2, int arg3)"""
    return _fltk.Fl_Window_default_icons(*args)

def Fl_Window_current(*args) -> "Fl_Window *":
    """Fl_Window_current() -> Fl_Window"""
    return _fltk.Fl_Window_current(*args)

def Fl_Window_default_callback(*args) -> "void":
    """Fl_Window_default_callback(Fl_Window arg2, void * v)"""
    return _fltk.Fl_Window_default_callback(*args)

class Fl_Double_Window(Fl_Window):
    """

    The Fl_Double_Window class provides a double-buffered window. If possible 
    this will use the X double buffering extension (Xdbe). If not, it will draw 
    the window data into an off-screen pixmap, and then copy it to the on-screen 
    window.

    It is highly recommended that you put the following code before the first 
    show() of any window in your program:

          Fl.visual(FL_DOUBLE|FL_INDEX)

    This makes sure you can use Xdbe on servers where double buffering does not 
    exist for every visual.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def flush(self, *args) -> "void":
        """flush(Fl_Double_Window self)"""
        return _fltk.Fl_Double_Window_flush(self, *args)


    def resize(self, *args) -> "void":
        """resize(Fl_Double_Window self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Double_Window_resize(self, *args)


    def hide(self, *args) -> "void":
        """hide(Fl_Double_Window self)"""
        return _fltk.Fl_Double_Window_hide(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Double_Window
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(Fl_Double_Window self, int W, int H, char const * l=None) -> Fl_Double_Window
        __init__(Fl_Double_Window self, int X, int Y, int W, int H, char const * l=None) -> Fl_Double_Window
        """
        if self.__class__ == Fl_Double_Window:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Double_Window(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def show(self, *args) -> "void":
        """show(Fl_Double_Window self, PyObject * count=None, PyObject * data=None)"""
        return _fltk.Fl_Double_Window_show(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Double_Window(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Double_Window self)"""
        return _fltk.Fl_Double_Window_draw(self, *args)

Fl_Double_Window_swigregister = _fltk.Fl_Double_Window_swigregister
Fl_Double_Window_swigregister(Fl_Double_Window)


def fl_color(*args) -> "Fl_Color":
    """
    fl_color(Fl_Color c)
    fl_color(uchar r, uchar g, uchar b)
    fl_color() -> Fl_Color
    """
    return _fltk.fl_color(*args)

def fl_push_clip(*args) -> "void":
    """fl_push_clip(int x, int y, int w, int h)"""
    return _fltk.fl_push_clip(*args)

def fl_push_no_clip(*args) -> "void":
    """fl_push_no_clip()"""
    return _fltk.fl_push_no_clip(*args)

def fl_pop_clip(*args) -> "void":
    """fl_pop_clip()"""
    return _fltk.fl_pop_clip(*args)

def fl_not_clipped(*args) -> "int":
    """fl_not_clipped(int x, int y, int w, int h) -> int"""
    return _fltk.fl_not_clipped(*args)

def fl_clip_box(*args) -> "int &, int &, int &, int &":
    """fl_clip_box(int x, int y, int w, int h) -> int"""
    return _fltk.fl_clip_box(*args)

def fl_restore_clip(*args) -> "void":
    """fl_restore_clip()"""
    return _fltk.fl_restore_clip(*args)

def fl_clip_region(*args) -> "Fl_Region":
    """
    fl_clip_region(Fl_Region r)
    fl_clip_region() -> Fl_Region
    """
    return _fltk.fl_clip_region(*args)

def fl_point(*args) -> "void":
    """fl_point(int x, int y)"""
    return _fltk.fl_point(*args)

def fl_line_style(*args) -> "void":
    """fl_line_style(int style, int width=0, char * dashes=None)"""
    return _fltk.fl_line_style(*args)
FL_SOLID = _fltk.FL_SOLID
FL_DASH = _fltk.FL_DASH
FL_DOT = _fltk.FL_DOT
FL_DASHDOT = _fltk.FL_DASHDOT
FL_DASHDOTDOT = _fltk.FL_DASHDOTDOT
FL_CAP_FLAT = _fltk.FL_CAP_FLAT
FL_CAP_ROUND = _fltk.FL_CAP_ROUND
FL_CAP_SQUARE = _fltk.FL_CAP_SQUARE
FL_JOIN_MITER = _fltk.FL_JOIN_MITER
FL_JOIN_ROUND = _fltk.FL_JOIN_ROUND
FL_JOIN_BEVEL = _fltk.FL_JOIN_BEVEL

def fl_rect(*args) -> "void":
    """
    fl_rect(int x, int y, int w, int h)
    fl_rect(int x, int y, int w, int h, Fl_Color c)
    """
    return _fltk.fl_rect(*args)

def fl_rectf(*args) -> "void":
    """
    fl_rectf(int x, int y, int w, int h)
    fl_rectf(int x, int y, int w, int h, Fl_Color c)
    fl_rectf(int x, int y, int w, int h, uchar r, uchar g, uchar b)
    """
    return _fltk.fl_rectf(*args)

def fl_line(*args) -> "void":
    """
    fl_line(int x, int y, int x1, int y1)
    fl_line(int x, int y, int x1, int y1, int x2, int y2)
    """
    return _fltk.fl_line(*args)

def fl_loop(*args) -> "void":
    """
    fl_loop(int x, int y, int x1, int y1, int x2, int y2)
    fl_loop(int x, int y, int x1, int y1, int x2, int y2, int x3, int y3)
    """
    return _fltk.fl_loop(*args)

def fl_polygon(*args) -> "void":
    """
    fl_polygon(int x, int y, int x1, int y1, int x2, int y2)
    fl_polygon(int x, int y, int x1, int y1, int x2, int y2, int x3, int y3)
    """
    return _fltk.fl_polygon(*args)

def fl_xyline(*args) -> "void":
    """
    fl_xyline(int x, int y, int x1)
    fl_xyline(int x, int y, int x1, int y2)
    fl_xyline(int x, int y, int x1, int y2, int x3)
    """
    return _fltk.fl_xyline(*args)

def fl_yxline(*args) -> "void":
    """
    fl_yxline(int x, int y, int y1)
    fl_yxline(int x, int y, int y1, int x2)
    fl_yxline(int x, int y, int y1, int x2, int y3)
    """
    return _fltk.fl_yxline(*args)

def fl_pie(*args) -> "void":
    """fl_pie(int x, int y, int w, int h, double a1, double a2)"""
    return _fltk.fl_pie(*args)

def fl_push_matrix(*args) -> "void":
    """fl_push_matrix()"""
    return _fltk.fl_push_matrix(*args)

def fl_pop_matrix(*args) -> "void":
    """fl_pop_matrix()"""
    return _fltk.fl_pop_matrix(*args)

def fl_scale(*args) -> "void":
    """
    fl_scale(double x, double y)
    fl_scale(double x)
    """
    return _fltk.fl_scale(*args)

def fl_translate(*args) -> "void":
    """fl_translate(double x, double y)"""
    return _fltk.fl_translate(*args)

def fl_rotate(*args) -> "void":
    """fl_rotate(double d)"""
    return _fltk.fl_rotate(*args)

def fl_mult_matrix(*args) -> "void":
    """fl_mult_matrix(double a, double b, double c, double d, double x, double y)"""
    return _fltk.fl_mult_matrix(*args)

def fl_begin_points(*args) -> "void":
    """fl_begin_points()"""
    return _fltk.fl_begin_points(*args)

def fl_begin_line(*args) -> "void":
    """fl_begin_line()"""
    return _fltk.fl_begin_line(*args)

def fl_begin_loop(*args) -> "void":
    """fl_begin_loop()"""
    return _fltk.fl_begin_loop(*args)

def fl_begin_polygon(*args) -> "void":
    """fl_begin_polygon()"""
    return _fltk.fl_begin_polygon(*args)

def fl_vertex(*args) -> "void":
    """fl_vertex(double x, double y)"""
    return _fltk.fl_vertex(*args)

def fl_curve(*args) -> "void":
    """fl_curve(double X0, double Y0, double X1, double Y1, double X2, double Y2, double X3, double Y3)"""
    return _fltk.fl_curve(*args)

def fl_arc(*args) -> "void":
    """
    fl_arc(int x, int y, int w, int h, double a1, double a2)
    fl_arc(double x, double y, double r, double start, double end)
    """
    return _fltk.fl_arc(*args)

def fl_circle(*args) -> "void":
    """fl_circle(double x, double y, double r)"""
    return _fltk.fl_circle(*args)

def fl_end_points(*args) -> "void":
    """fl_end_points()"""
    return _fltk.fl_end_points(*args)

def fl_end_line(*args) -> "void":
    """fl_end_line()"""
    return _fltk.fl_end_line(*args)

def fl_end_loop(*args) -> "void":
    """fl_end_loop()"""
    return _fltk.fl_end_loop(*args)

def fl_end_polygon(*args) -> "void":
    """fl_end_polygon()"""
    return _fltk.fl_end_polygon(*args)

def fl_begin_complex_polygon(*args) -> "void":
    """fl_begin_complex_polygon()"""
    return _fltk.fl_begin_complex_polygon(*args)

def fl_gap(*args) -> "void":
    """fl_gap()"""
    return _fltk.fl_gap(*args)

def fl_end_complex_polygon(*args) -> "void":
    """fl_end_complex_polygon()"""
    return _fltk.fl_end_complex_polygon(*args)

def fl_transform_x(*args) -> "double":
    """fl_transform_x(double x, double y) -> double"""
    return _fltk.fl_transform_x(*args)

def fl_transform_y(*args) -> "double":
    """fl_transform_y(double x, double y) -> double"""
    return _fltk.fl_transform_y(*args)

def fl_transform_dx(*args) -> "double":
    """fl_transform_dx(double x, double y) -> double"""
    return _fltk.fl_transform_dx(*args)

def fl_transform_dy(*args) -> "double":
    """fl_transform_dy(double x, double y) -> double"""
    return _fltk.fl_transform_dy(*args)

def fl_transformed_vertex(*args) -> "void":
    """fl_transformed_vertex(double xf, double yf)"""
    return _fltk.fl_transformed_vertex(*args)

def fl_font(*args) -> "Fl_Font":
    """
    fl_font(Fl_Font face, Fl_Fontsize fsize)
    fl_font() -> Fl_Font
    """
    return _fltk.fl_font(*args)

def fl_size(*args) -> "Fl_Fontsize":
    """fl_size() -> Fl_Fontsize"""
    return _fltk.fl_size(*args)

def fl_height(*args) -> "int":
    """
    fl_height() -> int
    fl_height(int font, int size) -> int
    """
    return _fltk.fl_height(*args)

def fl_descent(*args) -> "int":
    """fl_descent() -> int"""
    return _fltk.fl_descent(*args)

def fl_width(*args) -> "double":
    """
    fl_width(char const * txt) -> double
    fl_width(char const * txt, int n) -> double
    fl_width(unsigned int c) -> double
    """
    return _fltk.fl_width(*args)

def fl_text_extents(*args) -> "int &, int &, int &, int &":
    """
    fl_text_extents(char const * arg1)
    fl_text_extents(char const * t, int n)
    """
    return _fltk.fl_text_extents(*args)

def fl_latin1_to_local(*args) -> "char const *":
    """fl_latin1_to_local(char const * t, int n=-1) -> char const *"""
    return _fltk.fl_latin1_to_local(*args)

def fl_local_to_latin1(*args) -> "char const *":
    """fl_local_to_latin1(char const * t, int n=-1) -> char const *"""
    return _fltk.fl_local_to_latin1(*args)

def fl_mac_roman_to_local(*args) -> "char const *":
    """fl_mac_roman_to_local(char const * t, int n=-1) -> char const *"""
    return _fltk.fl_mac_roman_to_local(*args)

def fl_local_to_mac_roman(*args) -> "char const *":
    """fl_local_to_mac_roman(char const * t, int n=-1) -> char const *"""
    return _fltk.fl_local_to_mac_roman(*args)

def fl_rtl_draw(*args) -> "void":
    """fl_rtl_draw(char const * str, int n, int x, int y)"""
    return _fltk.fl_rtl_draw(*args)

def fl_measure(*args) -> "int &, int &":
    """fl_measure(char const * str, int draw_symbols=1)"""
    return _fltk.fl_measure(*args)

def fl_draw(*args) -> "void":
    """
    fl_draw(char const * str, int x, int y)
    fl_draw(int angle, char const * str, int x, int y)
    fl_draw(char const * str, int n, int x, int y)
    fl_draw(int angle, char const * str, int n, int x, int y)
    fl_draw(char const * str, int x, int y, int w, int h, Fl_Align align, Fl_Image img=None, int draw_symbols=1)
    fl_draw(char const * str, int x, int y, int w, int h, Fl_Align align, void (*)(char const *,int,int,int) callthis, Fl_Image img=None, int draw_symbols=1)
    """
    return _fltk.fl_draw(*args)

def fl_frame(*args) -> "void":
    """
    fl_frame(Fl_Boxtype b) -> Fl_Boxtype
    fl_frame(char const * s, int x, int y, int w, int h)
    """
    return _fltk.fl_frame(*args)

def fl_frame2(*args) -> "void":
    """fl_frame2(char const * s, int x, int y, int w, int h)"""
    return _fltk.fl_frame2(*args)

def fl_draw_box(*args) -> "void":
    """fl_draw_box(Fl_Boxtype arg1, int x, int y, int w, int h, Fl_Color arg6)"""
    return _fltk.fl_draw_box(*args)

def fl_draw_image(*args) -> "void":
    """fl_draw_image(uchar const * buf, int X, int Y, int W, int H, int D=3, int L=0)"""
    return _fltk.fl_draw_image(*args)

def fl_draw_image_mono(*args) -> "void":
    """fl_draw_image_mono(uchar const * buf, int X, int Y, int W, int H, int D=1, int L=0)"""
    return _fltk.fl_draw_image_mono(*args)

def fl_can_do_alpha_blending(*args) -> "char":
    """fl_can_do_alpha_blending() -> char"""
    return _fltk.fl_can_do_alpha_blending(*args)

def fl_draw_pixmap(*args) -> "int":
    """fl_draw_pixmap(char *const * data, int x, int y, Fl_Color arg4) -> int"""
    return _fltk.fl_draw_pixmap(*args)

def fl_measure_pixmap(*args) -> "int &, int &":
    """fl_measure_pixmap(char *const * data) -> int"""
    return _fltk.fl_measure_pixmap(*args)

def fl_scroll(*args) -> "void":
    """fl_scroll(int X, int Y, int W, int H, int dx, int dy, void (*)(void *,int,int,int,int) draw_area, void * data)"""
    return _fltk.fl_scroll(*args)

def fl_shortcut_label(*args) -> "char const *":
    """
    fl_shortcut_label(unsigned int shortcut) -> char const
    fl_shortcut_label(unsigned int shortcut, char const ** eom) -> char const *
    """
    return _fltk.fl_shortcut_label(*args)

def fl_overlay_rect(*args) -> "void":
    """fl_overlay_rect(int x, int y, int w, int h)"""
    return _fltk.fl_overlay_rect(*args)

def fl_overlay_clear(*args) -> "void":
    """fl_overlay_clear()"""
    return _fltk.fl_overlay_clear(*args)

def fl_cursor(*args) -> "void":
    """
    fl_cursor(Fl_Cursor arg1)
    fl_cursor(Fl_Cursor arg1, Fl_Color fg, Fl_Color bg)
    """
    return _fltk.fl_cursor(*args)

def fl_expand_text(*args) -> "int &":
    """fl_expand_text(char const * arg1, char * buf, int maxbuf, double maxw, double & width, int wrap, int draw_symbols=0) -> char const *"""
    return _fltk.fl_expand_text(*args)

def fl_set_status(*args) -> "void":
    """fl_set_status(int X, int Y, int W, int H)"""
    return _fltk.fl_set_status(*args)

def fl_set_spot(*args) -> "void":
    """fl_set_spot(int font, int size, int X, int Y, int W, int H, Fl_Window win=None)"""
    return _fltk.fl_set_spot(*args)

def fl_reset_spot(*args) -> "void":
    """fl_reset_spot()"""
    return _fltk.fl_reset_spot(*args)

def fl_draw_symbol(*args) -> "int":
    """fl_draw_symbol(char const * label, int x, int y, int w, int h, Fl_Color arg6) -> int"""
    return _fltk.fl_draw_symbol(*args)

def fl_add_symbol(*args) -> "int":
    """fl_add_symbol(char const * name, void (*)(Fl_Color) drawit, int scalable) -> int"""
    return _fltk.fl_add_symbol(*args)
FL_NORMAL_INPUT = _fltk.FL_NORMAL_INPUT
FL_FLOAT_INPUT = _fltk.FL_FLOAT_INPUT
FL_INT_INPUT = _fltk.FL_INT_INPUT
FL_HIDDEN_INPUT = _fltk.FL_HIDDEN_INPUT
FL_MULTILINE_INPUT = _fltk.FL_MULTILINE_INPUT
FL_SECRET_INPUT = _fltk.FL_SECRET_INPUT
FL_INPUT_TYPE = _fltk.FL_INPUT_TYPE
FL_INPUT_READONLY = _fltk.FL_INPUT_READONLY
FL_NORMAL_OUTPUT = _fltk.FL_NORMAL_OUTPUT
FL_MULTILINE_OUTPUT = _fltk.FL_MULTILINE_OUTPUT
FL_INPUT_WRAP = _fltk.FL_INPUT_WRAP
FL_MULTILINE_INPUT_WRAP = _fltk.FL_MULTILINE_INPUT_WRAP
FL_MULTILINE_OUTPUT_WRAP = _fltk.FL_MULTILINE_OUTPUT_WRAP
class Fl_Input_(Fl_Widget):
    """

    This is a virtual base class below Fl_Input. It has all the same interfaces, 
    but lacks the handle() and draw() method. You may want to subclass it if you 
    are one of those people who likes to change how the editing keys work.

    This can act like any of the subclasses of Fl_Input, by setting type() to one 
    of the following values:

          FL_NORMAL_INPUT		0
          FL_FLOAT_INPUT		1
          FL_INT_INPUT		2
          FL_MULTILINE_INPUT	4
          FL_SECRET_INPUT		5
          FL_INPUT_TYPE		7
          FL_INPUT_READONLY		8
          FL_NORMAL_OUTPUT		(FL_NORMAL_INPUT | FL_INPUT_READONLY)
          FL_MULTILINE_OUTPUT	(FL_MULTILINE_INPUT | FL_INPUT_READONLY)
          FL_INPUT_WRAP		16
          FL_MULTILINE_INPUT_WRAP	(FL_MULTILINE_INPUT | FL_INPUT_WRAP)
          FL_MULTILINE_OUTPUT_WRAP 	(FL_MULTILINE_INPUT | FL_INPUT_READONLY | FL_INPUT_WRAP)


    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def resize(self, *args) -> "void":
        """resize(Fl_Input_ self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Input__resize(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Input_ self, int arg2, int arg3, int arg4, int arg5, char const * arg6=None) -> Fl_Input_"""
        if self.__class__ == Fl_Input_:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Input_(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Input_
    __del__ = lambda self: None

    def static_value(self, *args) -> "int":
        """
        static_value(Fl_Input_ self, char const * arg2) -> int
        static_value(Fl_Input_ self, char const * arg2, int arg3) -> int
        """
        return _fltk.Fl_Input__static_value(self, *args)


    def value(self, *args) -> "char const *":
        """
        value(Fl_Input_ self, char const * arg2) -> int
        value(Fl_Input_ self, char const * arg2, int arg3) -> int
        value(Fl_Input_ self) -> char const *
        """
        return _fltk.Fl_Input__value(self, *args)


    def index(self, *args) -> "Fl_Char":
        """index(Fl_Input_ self, int i) -> Fl_Char"""
        return _fltk.Fl_Input__index(self, *args)


    def size(self, *args) -> "void":
        """
        size(Fl_Input_ self) -> int
        size(Fl_Input_ self, int W, int H)
        """
        return _fltk.Fl_Input__size(self, *args)


    def maximum_size(self, *args) -> "void":
        """
        maximum_size(Fl_Input_ self) -> int
        maximum_size(Fl_Input_ self, int m)
        """
        return _fltk.Fl_Input__maximum_size(self, *args)


    def position(self, *args) -> "int":
        """
        position(Fl_Input_ self) -> int
        position(Fl_Input_ self, int p, int m) -> int
        position(Fl_Input_ self, int p) -> int
        """
        return _fltk.Fl_Input__position(self, *args)


    def mark(self, *args) -> "int":
        """
        mark(Fl_Input_ self) -> int
        mark(Fl_Input_ self, int m) -> int
        """
        return _fltk.Fl_Input__mark(self, *args)


    def replace(self, *args) -> "int":
        """replace(Fl_Input_ self, int b, int e, char const * text, int ilen=0) -> int"""
        return _fltk.Fl_Input__replace(self, *args)


    def cut(self, *args) -> "int":
        """
        cut(Fl_Input_ self) -> int
        cut(Fl_Input_ self, int n) -> int
        cut(Fl_Input_ self, int a, int b) -> int
        """
        return _fltk.Fl_Input__cut(self, *args)


    def insert(self, *args) -> "int":
        """insert(Fl_Input_ self, char const * t, int l=0) -> int"""
        return _fltk.Fl_Input__insert(self, *args)


    def copy(self, *args) -> "int":
        """copy(Fl_Input_ self, int clipboard) -> int"""
        return _fltk.Fl_Input__copy(self, *args)


    def undo(self, *args) -> "int":
        """undo(Fl_Input_ self) -> int"""
        return _fltk.Fl_Input__undo(self, *args)


    def copy_cuts(self, *args) -> "int":
        """copy_cuts(Fl_Input_ self) -> int"""
        return _fltk.Fl_Input__copy_cuts(self, *args)


    def shortcut(self, *args) -> "void":
        """
        shortcut(Fl_Input_ self) -> int
        shortcut(Fl_Input_ self, int s)
        """
        return _fltk.Fl_Input__shortcut(self, *args)


    def textfont(self, *args) -> "void":
        """
        textfont(Fl_Input_ self) -> Fl_Font
        textfont(Fl_Input_ self, Fl_Font s)
        """
        return _fltk.Fl_Input__textfont(self, *args)


    def textsize(self, *args) -> "void":
        """
        textsize(Fl_Input_ self) -> Fl_Fontsize
        textsize(Fl_Input_ self, Fl_Fontsize s)
        """
        return _fltk.Fl_Input__textsize(self, *args)


    def textcolor(self, *args) -> "void":
        """
        textcolor(Fl_Input_ self) -> Fl_Color
        textcolor(Fl_Input_ self, Fl_Color n)
        """
        return _fltk.Fl_Input__textcolor(self, *args)


    def cursor_color(self, *args) -> "void":
        """
        cursor_color(Fl_Input_ self) -> Fl_Color
        cursor_color(Fl_Input_ self, Fl_Color n)
        """
        return _fltk.Fl_Input__cursor_color(self, *args)


    def input_type(self, *args) -> "void":
        """
        input_type(Fl_Input_ self) -> int
        input_type(Fl_Input_ self, int t)
        """
        return _fltk.Fl_Input__input_type(self, *args)


    def readonly(self, *args) -> "void":
        """
        readonly(Fl_Input_ self) -> int
        readonly(Fl_Input_ self, int b)
        """
        return _fltk.Fl_Input__readonly(self, *args)


    def wrap(self, *args) -> "void":
        """
        wrap(Fl_Input_ self) -> int
        wrap(Fl_Input_ self, int b)
        """
        return _fltk.Fl_Input__wrap(self, *args)


    def tab_nav(self, *args) -> "int":
        """
        tab_nav(Fl_Input_ self, int val)
        tab_nav(Fl_Input_ self) -> int
        """
        return _fltk.Fl_Input__tab_nav(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Input_(self)
        return weakref_proxy(self)
Fl_Input__swigregister = _fltk.Fl_Input__swigregister
Fl_Input__swigregister(Fl_Input_)

class Fl_Input(Fl_Input_):
    """

    This is the FLTK text input widget. It displays a single line of text and 
    lets the user edit it. Normally it is drawn with an inset box and a white 
    background. The text may contain any characters (even 0), and will correctly 
    display anything, using ^X notation for unprintable control characters 
    and 
    nn notation for unprintable characters with the high bit set. It 
    assumes the font can draw any characters in the ISO-8859-1 character set.
    Mouse button 1	Moves the cursor to this point. Drag selects characters. 
    Double click selects words. Triple click selects all text. Shift+click 
    extends the selection. When you select text it is automatically copied 
    to the clipboard.
    Mouse button 2	Insert the clipboard at the point clicked. You can also 
    select a region and replace it with the clipboard by selecting the region 
    with mouse button 2.
    Mouse button 3	Currently acts like button 1.
    Backspace	Deletes one character to the left, or deletes the selected 
    region.
    Enter	May cause the callback, see when().
    ^A or Home	Go to start of line.
    ^B or Left	Move left
    ^C	Copy the selection to the clipboard
    ^D or Delete	Deletes one character to the right or deletes the selected 
    region.
    ^E or End	Go to the end of line.
    ^F or Right	Move right
    ^K	Delete to the end of line (next 
     character) or deletes a single 

    character. These deletions are all concatenated into the clipboard.
    ^N or Down	Move down (for Fl_Multiline_Input only, otherwise it moves
    to the next input field).
    ^P or Up	Move up (for Fl_Multiline_Input only, otherwise it moves to 
    the previous input field).
    ^U	Delete everything.
    ^V or ^Y	Paste the clipboard
    ^X or ^W	Copy the region to the clipboard and delete it.
    ^Z or ^_	Undo. This is a single-level undo mechanism, but all adjacent 
    deletions and insertions are concatenated into a single 'undo'. Often this 
    will undo a lot more than you expected.
    Shift+move	Move the cursor but also extend the selection.
    RightCtrl or
    Compose	Start a compose-character sequence. The next one or two keys typed 
    define the character to insert (see table that follows.)

    The character 'nbsp' (non-breaking space) is typed by using [compose][space].

    The single-character sequences may be followed by a space if necessary to 
    remove ambiguity. 

    The same key may be used to 'quote' control characters into the text. If you 
    need a ^Q character you can get one by typing [compose][Control+Q].

    X may have a key on the keyboard defined as XK_Multi_key. If so this key 
    may be used as well as the right-hand control key. You can set this up 
    with the program xmodmap.

    If your keyboard is set to support a foreign language you should also be 
    able to type 'dead key' prefix characters. On X you will actually be able 
    to see what dead key you typed, and if you then move the cursor without 
    completing the sequence the accent will remain inserted. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Input self)"""
        return _fltk.Fl_Input_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Input self, int arg0) -> int"""
        return _fltk.Fl_Input_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Input self, int arg2, int arg3, int arg4, int arg5, char const * arg6=None) -> Fl_Input"""
        if self.__class__ == Fl_Input:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Input(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Input
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Input(self)
        return weakref_proxy(self)
Fl_Input_swigregister = _fltk.Fl_Input_swigregister
Fl_Input_swigregister(Fl_Input)

class Fl_File_Input(Fl_Input):
    """

    This widget displays a pathname in a text input field. A navigation bar 
    located above the input field allows the user to navigate upward in the 
    directory tree.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_File_Input self, int X, int Y, int W, int H, char const * L=None) -> Fl_File_Input"""
        if self.__class__ == Fl_File_Input:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_File_Input(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def handle(self, *args) -> "int":
        """handle(Fl_File_Input self, int event) -> int"""
        return _fltk.Fl_File_Input_handle(self, *args)


    def draw(self, *args) -> "void":
        """draw(Fl_File_Input self)"""
        return _fltk.Fl_File_Input_draw(self, *args)


    def down_box(self, *args) -> "void":
        """
        down_box(Fl_File_Input self) -> Fl_Boxtype
        down_box(Fl_File_Input self, Fl_Boxtype b)
        """
        return _fltk.Fl_File_Input_down_box(self, *args)


    def errorcolor(self, *args) -> "void":
        """
        errorcolor(Fl_File_Input self) -> Fl_Color
        errorcolor(Fl_File_Input self, Fl_Color c)
        """
        return _fltk.Fl_File_Input_errorcolor(self, *args)


    def value(self, *args) -> "char const *":
        """
        value(Fl_File_Input self, char const * str) -> int
        value(Fl_File_Input self, char const * str, int len) -> int
        value(Fl_File_Input self) -> char const *
        """
        return _fltk.Fl_File_Input_value(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_File_Input
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_File_Input(self)
        return weakref_proxy(self)
Fl_File_Input_swigregister = _fltk.Fl_File_Input_swigregister
Fl_File_Input_swigregister(Fl_File_Input)

class Fl_Fill_Dial(Fl_Dial):
    """

    The Fl_Fill_Dial widget provides a filled, circular dial to control a single 
    floating point value.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Fill_Dial self, int X, int Y, int W, int H, char const * L) -> Fl_Fill_Dial"""
        if self.__class__ == Fl_Fill_Dial:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Fill_Dial(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Fill_Dial
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Fill_Dial(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Fill_Dial self)"""
        return _fltk.Fl_Fill_Dial_draw(self, *args)

Fl_Fill_Dial_swigregister = _fltk.Fl_Fill_Dial_swigregister
Fl_Fill_Dial_swigregister(Fl_Fill_Dial)

FL_VERT_SLIDER = _fltk.FL_VERT_SLIDER
FL_HOR_SLIDER = _fltk.FL_HOR_SLIDER
FL_VERT_FILL_SLIDER = _fltk.FL_VERT_FILL_SLIDER
FL_HOR_FILL_SLIDER = _fltk.FL_HOR_FILL_SLIDER
FL_VERT_NICE_SLIDER = _fltk.FL_VERT_NICE_SLIDER
FL_HOR_NICE_SLIDER = _fltk.FL_HOR_NICE_SLIDER
class Fl_Slider(Fl_Valuator):
    """

    The Fl_Slider widget contains a sliding knob inside a box. It if often 
    used as a scrollbar. Moving the box all the way to the top/left sets it 
    to the minimum(), and to the bottom/right to the maximum(). The minimum() 
    may be greater than the maximum() to reverse the slider direction.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Slider self)"""
        return _fltk.Fl_Slider_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Slider self, int arg0) -> int"""
        return _fltk.Fl_Slider_handle(self, *args)


    def __init__(self, *args):
        """
        __init__(Fl_Slider self, int X, int Y, int W, int H, char const * L=None) -> Fl_Slider
        __init__(Fl_Slider self, uchar t, int X, int Y, int W, int H, char const * L) -> Fl_Slider
        """
        if self.__class__ == Fl_Slider:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Slider(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def scrollvalue(self, *args) -> "int":
        """scrollvalue(Fl_Slider self, int pos, int size, int first, int total) -> int"""
        return _fltk.Fl_Slider_scrollvalue(self, *args)


    def bounds(self, *args) -> "void":
        """bounds(Fl_Slider self, double a, double b)"""
        return _fltk.Fl_Slider_bounds(self, *args)


    def slider_size(self, *args) -> "void":
        """
        slider_size(Fl_Slider self) -> float
        slider_size(Fl_Slider self, double v)
        """
        return _fltk.Fl_Slider_slider_size(self, *args)


    def slider(self, *args) -> "void":
        """
        slider(Fl_Slider self) -> Fl_Boxtype
        slider(Fl_Slider self, Fl_Boxtype c)
        """
        return _fltk.Fl_Slider_slider(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Slider
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Slider(self)
        return weakref_proxy(self)
Fl_Slider_swigregister = _fltk.Fl_Slider_swigregister
Fl_Slider_swigregister(Fl_Slider)

class Fl_Fill_Slider(Fl_Slider):
    """

    The Fl_Fill_Slider widget contains a sliding knob inside a box. It if often 
    used as a scrollbar. Moving the box all the way to the top/left sets it to 
    the minimum(), and to the bottom/right to the maximum(). The minimum() may 
    be greater than the maximum() to reverse the slider direction.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Fill_Slider self, int X, int Y, int W, int H, char const * L=None) -> Fl_Fill_Slider"""
        if self.__class__ == Fl_Fill_Slider:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Fill_Slider(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Fill_Slider
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Fill_Slider(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Fill_Slider self)"""
        return _fltk.Fl_Fill_Slider_draw(self, *args)

Fl_Fill_Slider_swigregister = _fltk.Fl_Fill_Slider_swigregister
Fl_Fill_Slider_swigregister(Fl_Fill_Slider)

class Fl_Float_Input(Fl_Input):
    """

    The Fl_Float_Input class is a subclass of Fl_Input  that only allows the 
    user to type floating point numbers (sign, digits, decimal point, more 
    digits, 'E' or 'e', sign, digits).

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Float_Input self, int X, int Y, int W, int H, char const * l=None) -> Fl_Float_Input"""
        if self.__class__ == Fl_Float_Input:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Float_Input(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Float_Input
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Float_Input(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Float_Input self)"""
        return _fltk.Fl_Float_Input_draw(self, *args)

Fl_Float_Input_swigregister = _fltk.Fl_Float_Input_swigregister
Fl_Float_Input_swigregister(Fl_Float_Input)

class Fl_FormsBitmap(Fl_Widget):
    """Proxy of C++ Fl_FormsBitmap class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_FormsBitmap self)"""
        return _fltk.Fl_FormsBitmap_draw(self, *args)


    def __init__(self, *args):
        """__init__(Fl_FormsBitmap self, Fl_Boxtype arg2, int arg3, int arg4, int arg5, int arg6, char const * arg7=None) -> Fl_FormsBitmap"""
        if self.__class__ == Fl_FormsBitmap:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_FormsBitmap(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def set(self, *args) -> "void":
        """set(Fl_FormsBitmap self, int W, int H, uchar const * bits)"""
        return _fltk.Fl_FormsBitmap_set(self, *args)


    def bitmap(self, *args) -> "Fl_Bitmap *":
        """
        bitmap(Fl_FormsBitmap self, Fl_Bitmap B)
        bitmap(Fl_FormsBitmap self) -> Fl_Bitmap
        """
        return _fltk.Fl_FormsBitmap_bitmap(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_FormsBitmap
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_FormsBitmap(self)
        return weakref_proxy(self)
Fl_FormsBitmap_swigregister = _fltk.Fl_FormsBitmap_swigregister
Fl_FormsBitmap_swigregister(Fl_FormsBitmap)

class Fl_FormsPixmap(Fl_Widget):
    """Proxy of C++ Fl_FormsPixmap class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_FormsPixmap self)"""
        return _fltk.Fl_FormsPixmap_draw(self, *args)


    def __init__(self, *args):
        """__init__(Fl_FormsPixmap self, Fl_Boxtype t, int X, int Y, int W, int H, char const * L=None) -> Fl_FormsPixmap"""
        if self.__class__ == Fl_FormsPixmap:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_FormsPixmap(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def set(self, *args) -> "void":
        """set(Fl_FormsPixmap self, char *const * bits)"""
        return _fltk.Fl_FormsPixmap_set(self, *args)


    def Pixmap(self, *args) -> "Fl_Pixmap *":
        """
        Pixmap(Fl_FormsPixmap self, Fl_Pixmap B)
        Pixmap(Fl_FormsPixmap self) -> Fl_Pixmap
        """
        return _fltk.Fl_FormsPixmap_Pixmap(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_FormsPixmap
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_FormsPixmap(self)
        return weakref_proxy(self)
Fl_FormsPixmap_swigregister = _fltk.Fl_FormsPixmap_swigregister
Fl_FormsPixmap_swigregister(Fl_FormsPixmap)

FL_NORMAL_FREE = _fltk.FL_NORMAL_FREE
FL_SLEEPING_FREE = _fltk.FL_SLEEPING_FREE
FL_INPUT_FREE = _fltk.FL_INPUT_FREE
FL_CONTINUOUS_FREE = _fltk.FL_CONTINUOUS_FREE
FL_ALL_FREE = _fltk.FL_ALL_FREE
class Fl_Free(Fl_Widget):
    """

    Emulation of the Forms 'free' widget. This emulation allows the free demo 
    to run, and appears to be useful for porting programs written in Forms which 
    use the free widget or make subclasses of the Forms widgets.

    There are five types of free, which determine when the handle function is 
    called:

          FL_NORMAL_FREE		1
          FL_SLEEPING_FREE		2
          FL_INPUT_FREE		3
          FL_CONTINUOUS_FREE	4
          FL_ALL_FREE		5

    An FL_INPUT_FREE accepts FL_FOCUS events. A FL_CONTINUOUS_FREE sets a 
    timeout callback 100 times a second and provides a FL_STEP event, this 
    has obvious detrimental effects on machine performance. FL_ALL_FREE does 
    both. FL_SLEEPING_FREE are deactivated. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Free self)"""
        return _fltk.Fl_Free_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Free self, int e) -> int"""
        return _fltk.Fl_Free_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Free self, uchar t, int X, int Y, int W, int H, char const * L, FL_HANDLEPTR hdl) -> Fl_Free"""
        if self.__class__ == Fl_Free:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Free(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Free
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Free(self)
        return weakref_proxy(self)
Fl_Free_swigregister = _fltk.Fl_Free_swigregister
Fl_Free_swigregister(Fl_Free)

FL_DRAW = _fltk.FL_DRAW
FL_STEP = _fltk.FL_STEP
FL_FREEMEM = _fltk.FL_FREEMEM
FL_FREEZE = _fltk.FL_FREEZE
FL_THAW = _fltk.FL_THAW
class Fl_Pixmap(Fl_Image):
    """

    The Fl_Pixmap class supports caching and drawing of colormap (pixmap) images, including transparency.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Pixmap self, char const *const * D) -> Fl_Pixmap"""
        if self.__class__ == Fl_Pixmap:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Pixmap(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Pixmap
    __del__ = lambda self: None

    def copy(self, *args) -> "Fl_Image *":
        """
        copy(Fl_Pixmap self, int W, int H) -> Fl_Image
        copy(Fl_Pixmap self) -> Fl_Image
        """
        return _fltk.Fl_Pixmap_copy(self, *args)


    def color_average(self, *args) -> "void":
        """color_average(Fl_Pixmap self, Fl_Color c, float i)"""
        return _fltk.Fl_Pixmap_color_average(self, *args)


    def desaturate(self, *args) -> "void":
        """desaturate(Fl_Pixmap self)"""
        return _fltk.Fl_Pixmap_desaturate(self, *args)


    def draw(self, *args) -> "void":
        """
        draw(Fl_Pixmap self, int X, int Y, int W, int H, int cx=0, int cy=0)
        draw(Fl_Pixmap self, int X, int Y)
        """
        return _fltk.Fl_Pixmap_draw(self, *args)


    def label(self, *args) -> "void":
        """
        label(Fl_Pixmap self, Fl_Widget w)
        label(Fl_Pixmap self, Fl_Menu_Item m)
        """
        return _fltk.Fl_Pixmap_label(self, *args)


    def uncache(self, *args) -> "void":
        """uncache(Fl_Pixmap self)"""
        return _fltk.Fl_Pixmap_uncache(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Pixmap(self)
        return weakref_proxy(self)
Fl_Pixmap_swigregister = _fltk.Fl_Pixmap_swigregister
Fl_Pixmap_swigregister(Fl_Pixmap)

class Fl_GIF_Image(Fl_Pixmap):
    """

    The Fl_GIF_Image class supports loading, caching, and drawing of Compuserve 
    GIF images. The class loads the first image and supports transparency.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_GIF_Image self, char const * filename) -> Fl_GIF_Image"""
        if self.__class__ == Fl_GIF_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_GIF_Image(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_GIF_Image
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_GIF_Image(self)
        return weakref_proxy(self)
Fl_GIF_Image_swigregister = _fltk.Fl_GIF_Image_swigregister
Fl_GIF_Image_swigregister(Fl_GIF_Image)

class Fl_Gl_Window(Fl_Window):
    """

    The Fl_Gl_Window widget sets things up so OpenGL works, and also keeps an 
    OpenGL 'context' for that window, so that changes to the lighting and 
    projection may be reused between redraws. Fl_Gl_Window also flushes the 
    OpenGL streams and swaps buffers after draw()  returns.

    OpenGL hardware typically provides some overlay bit planes, which are very 
    useful for drawing UI controls atop your 3D graphics. If the overlay hardware 
    is not provided, FLTK tries to simulate the overlay, This works pretty well 
    if your graphics are double buffered, but not very well for single-buffered. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def flush(self, *args) -> "void":
        """flush(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_flush(self, *args)


    def hide(self, *args) -> "void":
        """hide(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_hide(self, *args)


    def resize(self, *args) -> "void":
        """resize(Fl_Gl_Window self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Gl_Window_resize(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Gl_Window self, int arg0) -> int"""
        return _fltk.Fl_Gl_Window_handle(self, *args)


    def valid(self, *args) -> "void":
        """
        valid(Fl_Gl_Window self) -> char
        valid(Fl_Gl_Window self, char v)
        """
        return _fltk.Fl_Gl_Window_valid(self, *args)


    def invalidate(self, *args) -> "void":
        """invalidate(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_invalidate(self, *args)


    def context_valid(self, *args) -> "void":
        """
        context_valid(Fl_Gl_Window self) -> char
        context_valid(Fl_Gl_Window self, char v)
        """
        return _fltk.Fl_Gl_Window_context_valid(self, *args)


    def can_do(self, *args) -> "int":
        """
        can_do(Fl_Gl_Window self, int m) -> int
        can_do(Fl_Gl_Window self, int const * m) -> int
        can_do(Fl_Gl_Window self) -> int
        """
        return _fltk.Fl_Gl_Window_can_do(self, *args)


    def mode(self, *args) -> "int":
        """
        mode(Fl_Gl_Window self) -> Fl_Mode
        mode(Fl_Gl_Window self, int a) -> int
        mode(Fl_Gl_Window self, int const * a) -> int
        """
        return _fltk.Fl_Gl_Window_mode(self, *args)


    def context(self, *args) -> "void":
        """
        context(Fl_Gl_Window self)
        context(Fl_Gl_Window self, void * arg2, int destroy_flag=0)
        """
        return _fltk.Fl_Gl_Window_context(self, *args)


    def make_current(self, *args) -> "void":
        """make_current(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_make_current(self, *args)


    def swap_buffers(self, *args) -> "void":
        """swap_buffers(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_swap_buffers(self, *args)


    def ortho(self, *args) -> "void":
        """ortho(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_ortho(self, *args)


    def can_do_overlay(self, *args) -> "int":
        """can_do_overlay(Fl_Gl_Window self) -> int"""
        return _fltk.Fl_Gl_Window_can_do_overlay(self, *args)


    def redraw_overlay(self, *args) -> "void":
        """redraw_overlay(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_redraw_overlay(self, *args)


    def hide_overlay(self, *args) -> "void":
        """hide_overlay(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_hide_overlay(self, *args)


    def make_overlay_current(self, *args) -> "void":
        """make_overlay_current(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_make_overlay_current(self, *args)


    def as_gl_window(self, *args) -> "Fl_Gl_Window *":
        """as_gl_window(Fl_Gl_Window self) -> Fl_Gl_Window"""
        return _fltk.Fl_Gl_Window_as_gl_window(self, *args)


    def pixels_per_unit(self, *args) -> "float":
        """pixels_per_unit(Fl_Gl_Window self) -> float"""
        return _fltk.Fl_Gl_Window_pixels_per_unit(self, *args)


    def pixel_w(self, *args) -> "int":
        """pixel_w(Fl_Gl_Window self) -> int"""
        return _fltk.Fl_Gl_Window_pixel_w(self, *args)


    def pixel_h(self, *args) -> "int":
        """pixel_h(Fl_Gl_Window self) -> int"""
        return _fltk.Fl_Gl_Window_pixel_h(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Gl_Window
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(Fl_Gl_Window self, int W, int H, char const * l=None) -> Fl_Gl_Window
        __init__(Fl_Gl_Window self, int X, int Y, int W, int H, char const * l=None) -> Fl_Gl_Window
        """
        if self.__class__ == Fl_Gl_Window:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Gl_Window(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def draw(self, *args) -> "void":
        """draw(Fl_Gl_Window self)"""
        return _fltk.Fl_Gl_Window_draw(self, *args)


    def show(self, *args) -> "void":
        """show(Fl_Gl_Window self, PyObject * count=None, PyObject * data=None)"""
        return _fltk.Fl_Gl_Window_show(self, *args)


    def drawPixels(self, *args) -> "void":
        """
        drawPixels(Fl_Gl_Window self, PyObject * rgb_py)

        Writes a raw RGB string to the canvas.

        Arguments:
            - rgb - a string of width * height * 3 bytes, comprising
              the raw image in RGB format

        """
        return _fltk.Fl_Gl_Window_drawPixels(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Gl_Window(self)
        return weakref_proxy(self)
Fl_Gl_Window_swigregister = _fltk.Fl_Gl_Window_swigregister
Fl_Gl_Window_swigregister(Fl_Gl_Window)


def gl_start(*args) -> "void":
    """gl_start()"""
    return _fltk.gl_start(*args)

def gl_finish(*args) -> "void":
    """gl_finish()"""
    return _fltk.gl_finish(*args)

def gl_color(*args) -> "void":
    """
    gl_color(Fl_Color i)
    gl_color(int c)
    """
    return _fltk.gl_color(*args)

def gl_rect(*args) -> "void":
    """gl_rect(int x, int y, int w, int h)"""
    return _fltk.gl_rect(*args)

def gl_rectf(*args) -> "void":
    """gl_rectf(int x, int y, int w, int h)"""
    return _fltk.gl_rectf(*args)

def gl_font(*args) -> "void":
    """gl_font(int fontid, int size)"""
    return _fltk.gl_font(*args)

def gl_height(*args) -> "int":
    """gl_height() -> int"""
    return _fltk.gl_height(*args)

def gl_descent(*args) -> "int":
    """gl_descent() -> int"""
    return _fltk.gl_descent(*args)

def gl_width(*args) -> "double":
    """
    gl_width(char const * arg1) -> double
    gl_width(char const * arg1, int n) -> double
    gl_width(uchar arg1) -> double
    """
    return _fltk.gl_width(*args)

def gl_draw(*args) -> "void":
    """
    gl_draw(char const * arg1)
    gl_draw(char const * arg1, int n)
    gl_draw(char const * arg1, int x, int y)
    gl_draw(char const * arg1, float x, float y)
    gl_draw(char const * arg1, int n, int x, int y)
    gl_draw(char const * arg1, int n, float x, float y)
    gl_draw(char const * arg1, int x, int y, int w, int h, Fl_Align arg6)
    """
    return _fltk.gl_draw(*args)

def gl_measure(*args) -> "int &, int &":
    """gl_measure(char const * arg1)"""
    return _fltk.gl_measure(*args)

def gl_draw_image(*args) -> "void":
    """gl_draw_image(uchar const * arg1, int x, int y, int w, int h, int d=3, int ld=0)"""
    return _fltk.gl_draw_image(*args)
class Fl_Help_Dialog(object):
    """

    The Fl_Help_Dialog widget displays a standard help dialog window using the 
    Fl_Help_View widget.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Help_Dialog self) -> Fl_Help_Dialog"""
        this = _fltk.new_Fl_Help_Dialog(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Help_Dialog
    __del__ = lambda self: None

    def h(self, *args) -> "int":
        """h(Fl_Help_Dialog self) -> int"""
        return _fltk.Fl_Help_Dialog_h(self, *args)


    def hide(self, *args) -> "void":
        """hide(Fl_Help_Dialog self)"""
        return _fltk.Fl_Help_Dialog_hide(self, *args)


    def load(self, *args) -> "void":
        """load(Fl_Help_Dialog self, char const * f)"""
        return _fltk.Fl_Help_Dialog_load(self, *args)


    def position(self, *args) -> "void":
        """position(Fl_Help_Dialog self, int xx, int yy)"""
        return _fltk.Fl_Help_Dialog_position(self, *args)


    def resize(self, *args) -> "void":
        """resize(Fl_Help_Dialog self, int xx, int yy, int ww, int hh)"""
        return _fltk.Fl_Help_Dialog_resize(self, *args)


    def show(self, *args) -> "void":
        """
        show(Fl_Help_Dialog self)
        show(Fl_Help_Dialog self, int argc, char ** argv)
        """
        return _fltk.Fl_Help_Dialog_show(self, *args)


    def textsize(self, *args) -> "Fl_Fontsize":
        """
        textsize(Fl_Help_Dialog self, Fl_Fontsize s)
        textsize(Fl_Help_Dialog self) -> Fl_Fontsize
        """
        return _fltk.Fl_Help_Dialog_textsize(self, *args)


    def topline(self, *args) -> "void":
        """
        topline(Fl_Help_Dialog self, char const * n)
        topline(Fl_Help_Dialog self, int n)
        """
        return _fltk.Fl_Help_Dialog_topline(self, *args)


    def value(self, *args) -> "char const *":
        """
        value(Fl_Help_Dialog self, char const * f)
        value(Fl_Help_Dialog self) -> char const *
        """
        return _fltk.Fl_Help_Dialog_value(self, *args)


    def visible(self, *args) -> "int":
        """visible(Fl_Help_Dialog self) -> int"""
        return _fltk.Fl_Help_Dialog_visible(self, *args)


    def w(self, *args) -> "int":
        """w(Fl_Help_Dialog self) -> int"""
        return _fltk.Fl_Help_Dialog_w(self, *args)


    def x(self, *args) -> "int":
        """x(Fl_Help_Dialog self) -> int"""
        return _fltk.Fl_Help_Dialog_x(self, *args)


    def y(self, *args) -> "int":
        """y(Fl_Help_Dialog self) -> int"""
        return _fltk.Fl_Help_Dialog_y(self, *args)

Fl_Help_Dialog_swigregister = _fltk.Fl_Help_Dialog_swigregister
Fl_Help_Dialog_swigregister(Fl_Help_Dialog)

class Fl_Help_Block(object):
    """Proxy of C++ Fl_Help_Block class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Help_Block self) -> Fl_Help_Block"""
        this = _fltk.new_Fl_Help_Block(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Help_Block
    __del__ = lambda self: None
Fl_Help_Block_swigregister = _fltk.Fl_Help_Block_swigregister
Fl_Help_Block_swigregister(Fl_Help_Block)

class Fl_Help_Link(object):
    """Proxy of C++ Fl_Help_Link class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Help_Link self) -> Fl_Help_Link"""
        this = _fltk.new_Fl_Help_Link(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Help_Link
    __del__ = lambda self: None
Fl_Help_Link_swigregister = _fltk.Fl_Help_Link_swigregister
Fl_Help_Link_swigregister(Fl_Help_Link)

class Fl_Help_Font_Style(object):
    """Proxy of C++ Fl_Help_Font_Style class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def get(self, *args) -> "void":
        """get(Fl_Help_Font_Style self, Fl_Color & acolor)"""
        return _fltk.Fl_Help_Font_Style_get(self, *args)


    def set(self, *args) -> "void":
        """set(Fl_Help_Font_Style self, Fl_Font afont, Fl_Fontsize asize, Fl_Color acolor)"""
        return _fltk.Fl_Help_Font_Style_set(self, *args)


    def __init__(self, *args):
        """
        __init__(Fl_Help_Font_Style self, Fl_Font afont, Fl_Fontsize asize, Fl_Color acolor) -> Fl_Help_Font_Style
        __init__(Fl_Help_Font_Style self) -> Fl_Help_Font_Style
        """
        this = _fltk.new_Fl_Help_Font_Style(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Help_Font_Style
    __del__ = lambda self: None
Fl_Help_Font_Style_swigregister = _fltk.Fl_Help_Font_Style_swigregister
Fl_Help_Font_Style_swigregister(Fl_Help_Font_Style)

class Fl_Help_Font_Stack(object):
    """Proxy of C++ Fl_Help_Font_Stack class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Help_Font_Stack self) -> Fl_Help_Font_Stack"""
        this = _fltk.new_Fl_Help_Font_Stack(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def init(self, *args) -> "void":
        """init(Fl_Help_Font_Stack self, Fl_Font f, Fl_Fontsize s, Fl_Color c)"""
        return _fltk.Fl_Help_Font_Stack_init(self, *args)


    def top(self, *args) -> "void":
        """top(Fl_Help_Font_Stack self, Fl_Color & c)"""
        return _fltk.Fl_Help_Font_Stack_top(self, *args)


    def push(self, *args) -> "void":
        """push(Fl_Help_Font_Stack self, Fl_Font f, Fl_Fontsize s, Fl_Color c)"""
        return _fltk.Fl_Help_Font_Stack_push(self, *args)


    def pop(self, *args) -> "void":
        """pop(Fl_Help_Font_Stack self, Fl_Color & c)"""
        return _fltk.Fl_Help_Font_Stack_pop(self, *args)


    def count(self, *args) -> "size_t":
        """count(Fl_Help_Font_Stack self) -> size_t"""
        return _fltk.Fl_Help_Font_Stack_count(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Help_Font_Stack
    __del__ = lambda self: None
Fl_Help_Font_Stack_swigregister = _fltk.Fl_Help_Font_Stack_swigregister
Fl_Help_Font_Stack_swigregister(Fl_Help_Font_Stack)

class Fl_Help_Target(object):
    """Proxy of C++ Fl_Help_Target class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Help_Target self) -> Fl_Help_Target"""
        this = _fltk.new_Fl_Help_Target(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Help_Target
    __del__ = lambda self: None
Fl_Help_Target_swigregister = _fltk.Fl_Help_Target_swigregister
Fl_Help_Target_swigregister(Fl_Help_Target)

class Fl_Help_View(Fl_Group):
    """

    The Fl_Help_View widget displays HTML text. Most HTML 2.0 elements are 
    supported, as well as a primitive implementation of tables. GIF, JPEG, 
    and PNG images are displayed inline.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Help_View self, int xx, int yy, int ww, int hh, char const * l=None) -> Fl_Help_View"""
        if self.__class__ == Fl_Help_View:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Help_View(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Help_View
    __del__ = lambda self: None

    def directory(self, *args) -> "char const *":
        """directory(Fl_Help_View self) -> char const *"""
        return _fltk.Fl_Help_View_directory(self, *args)


    def filename(self, *args) -> "char const *":
        """filename(Fl_Help_View self) -> char const *"""
        return _fltk.Fl_Help_View_filename(self, *args)


    def find(self, *args) -> "int":
        """find(Fl_Help_View self, char const * s, int p=0) -> int"""
        return _fltk.Fl_Help_View_find(self, *args)


    def load(self, *args) -> "int":
        """load(Fl_Help_View self, char const * f) -> int"""
        return _fltk.Fl_Help_View_load(self, *args)


    def resize(self, *args) -> "void":
        """resize(Fl_Help_View self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Help_View_resize(self, *args)


    def size(self, *args) -> "void":
        """
        size(Fl_Help_View self) -> int
        size(Fl_Help_View self, int W, int H)
        """
        return _fltk.Fl_Help_View_size(self, *args)


    def textcolor(self, *args) -> "Fl_Color":
        """
        textcolor(Fl_Help_View self, Fl_Color c)
        textcolor(Fl_Help_View self) -> Fl_Color
        """
        return _fltk.Fl_Help_View_textcolor(self, *args)


    def textfont(self, *args) -> "Fl_Font":
        """
        textfont(Fl_Help_View self, Fl_Font f)
        textfont(Fl_Help_View self) -> Fl_Font
        """
        return _fltk.Fl_Help_View_textfont(self, *args)


    def textsize(self, *args) -> "Fl_Fontsize":
        """
        textsize(Fl_Help_View self, Fl_Fontsize s)
        textsize(Fl_Help_View self) -> Fl_Fontsize
        """
        return _fltk.Fl_Help_View_textsize(self, *args)


    def title(self, *args) -> "char const *":
        """title(Fl_Help_View self) -> char const *"""
        return _fltk.Fl_Help_View_title(self, *args)


    def topline(self, *args) -> "int":
        """
        topline(Fl_Help_View self, char const * n)
        topline(Fl_Help_View self, int arg2)
        topline(Fl_Help_View self) -> int
        """
        return _fltk.Fl_Help_View_topline(self, *args)


    def leftline(self, *args) -> "int":
        """
        leftline(Fl_Help_View self, int arg2)
        leftline(Fl_Help_View self) -> int
        """
        return _fltk.Fl_Help_View_leftline(self, *args)


    def value(self, *args) -> "char const *":
        """
        value(Fl_Help_View self, char const * val)
        value(Fl_Help_View self) -> char const *
        """
        return _fltk.Fl_Help_View_value(self, *args)


    def clear_selection(self, *args) -> "void":
        """clear_selection(Fl_Help_View self)"""
        return _fltk.Fl_Help_View_clear_selection(self, *args)


    def select_all(self, *args) -> "void":
        """select_all(Fl_Help_View self)"""
        return _fltk.Fl_Help_View_select_all(self, *args)


    def scrollbar_size(self, *args) -> "void":
        """
        scrollbar_size(Fl_Help_View self) -> int
        scrollbar_size(Fl_Help_View self, int newSize)
        """
        return _fltk.Fl_Help_View_scrollbar_size(self, *args)


    def link(self, *args) -> "void":
        """
        link(Fl_Help_View self, Fl_Help_Func * fn)
        link(Fl_Help_View self, PyObject * PyFunc, PyObject * PyWidget)
        """
        return _fltk.Fl_Help_View_link(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Help_View(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Help_View self)"""
        return _fltk.Fl_Help_View_draw(self, *args)

Fl_Help_View_swigregister = _fltk.Fl_Help_View_swigregister
Fl_Help_View_swigregister(Fl_Help_View)

class Fl_Hold_Browser(Fl_Browser):
    """

    The Fl_Hold_Browser class is a subclass of Fl_Browser  which lets the user 
    select a single item, or no items by clicking on the empty space. As long 
    as the mouse button is held down the item pointed to by it is highlighted, 
    and this highlighting remains on when the mouse button is released. Normally 
    the callback is done when the user releases the mouse, but you can change 
    this with when().

    See Fl_Browser for methods to add and remove lines from the browser. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Hold_Browser self, int X, int Y, int W, int H, char const * L=None) -> Fl_Hold_Browser"""
        if self.__class__ == Fl_Hold_Browser:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Hold_Browser(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Hold_Browser
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Hold_Browser(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Hold_Browser self)"""
        return _fltk.Fl_Hold_Browser_draw(self, *args)


    def item_first(self, *args) -> "void *":
        """item_first(Fl_Hold_Browser self) -> void *"""
        return _fltk.Fl_Hold_Browser_item_first(self, *args)


    def item_next(self, *args) -> "void *":
        """item_next(Fl_Hold_Browser self, void * item) -> void *"""
        return _fltk.Fl_Hold_Browser_item_next(self, *args)


    def item_prev(self, *args) -> "void *":
        """item_prev(Fl_Hold_Browser self, void * item) -> void *"""
        return _fltk.Fl_Hold_Browser_item_prev(self, *args)


    def item_last(self, *args) -> "void *":
        """item_last(Fl_Hold_Browser self) -> void *"""
        return _fltk.Fl_Hold_Browser_item_last(self, *args)


    def item_height(self, *args) -> "int":
        """item_height(Fl_Hold_Browser self, void * item) -> int"""
        return _fltk.Fl_Hold_Browser_item_height(self, *args)


    def item_width(self, *args) -> "int":
        """item_width(Fl_Hold_Browser self, void * item) -> int"""
        return _fltk.Fl_Hold_Browser_item_width(self, *args)


    def item_quick_height(self, *args) -> "int":
        """item_quick_height(Fl_Hold_Browser self, void * item) -> int"""
        return _fltk.Fl_Hold_Browser_item_quick_height(self, *args)


    def item_draw(self, *args) -> "void":
        """item_draw(Fl_Hold_Browser self, void * item, int X, int Y, int W, int H)"""
        return _fltk.Fl_Hold_Browser_item_draw(self, *args)


    def item_text(self, *args) -> "char const *":
        """item_text(Fl_Hold_Browser self, void * item) -> char const *"""
        return _fltk.Fl_Hold_Browser_item_text(self, *args)


    def item_swap(self, *args) -> "void":
        """item_swap(Fl_Hold_Browser self, void * a, void * b)"""
        return _fltk.Fl_Hold_Browser_item_swap(self, *args)


    def item_at(self, *args) -> "void *":
        """item_at(Fl_Hold_Browser self, int line) -> void *"""
        return _fltk.Fl_Hold_Browser_item_at(self, *args)


    def full_width(self, *args) -> "int":
        """full_width(Fl_Hold_Browser self) -> int"""
        return _fltk.Fl_Hold_Browser_full_width(self, *args)


    def full_height(self, *args) -> "int":
        """full_height(Fl_Hold_Browser self) -> int"""
        return _fltk.Fl_Hold_Browser_full_height(self, *args)


    def incr_height(self, *args) -> "int":
        """incr_height(Fl_Hold_Browser self) -> int"""
        return _fltk.Fl_Hold_Browser_incr_height(self, *args)


    def item_select(self, *args) -> "void":
        """item_select(Fl_Hold_Browser self, void * item, int val)"""
        return _fltk.Fl_Hold_Browser_item_select(self, *args)


    def item_selected(self, *args) -> "int":
        """item_selected(Fl_Hold_Browser self, void * item) -> int"""
        return _fltk.Fl_Hold_Browser_item_selected(self, *args)

Fl_Hold_Browser_swigregister = _fltk.Fl_Hold_Browser_swigregister
Fl_Hold_Browser_swigregister(Fl_Hold_Browser)

class Fl_Hor_Fill_Slider(Fl_Slider):
    """

    The Fl_Hor_Fill_Slider widget contains a sliding knob inside a box. It is 
    often used as a scrollbar. Moving the box all the way to the top/left sets 
    it to the minimum(), and to the bottom/right to the maximum(). The minimum() 
    may be greater than the maximum() to reverse the slider direction.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Hor_Fill_Slider self, int X, int Y, int W, int H, char const * L=None) -> Fl_Hor_Fill_Slider"""
        if self.__class__ == Fl_Hor_Fill_Slider:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Hor_Fill_Slider(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Hor_Fill_Slider
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Hor_Fill_Slider(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Hor_Fill_Slider self)"""
        return _fltk.Fl_Hor_Fill_Slider_draw(self, *args)

Fl_Hor_Fill_Slider_swigregister = _fltk.Fl_Hor_Fill_Slider_swigregister
Fl_Hor_Fill_Slider_swigregister(Fl_Hor_Fill_Slider)

class Fl_Hor_Nice_Slider(Fl_Slider):
    """

    The Fl_Hor_Nice_Slider widget contains a sliding knob inside a box. It is 
    often used as a scrollbar. Moving the box all the way to the top/left sets 
    it to the minimum(), and to the bottom/right to the maximum(). The minimum() 
    may be greater than the maximum() to reverse the slider direction.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Hor_Nice_Slider self, int X, int Y, int W, int H, char const * L=None) -> Fl_Hor_Nice_Slider"""
        if self.__class__ == Fl_Hor_Nice_Slider:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Hor_Nice_Slider(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Hor_Nice_Slider
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Hor_Nice_Slider(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Hor_Nice_Slider self)"""
        return _fltk.Fl_Hor_Nice_Slider_draw(self, *args)

Fl_Hor_Nice_Slider_swigregister = _fltk.Fl_Hor_Nice_Slider_swigregister
Fl_Hor_Nice_Slider_swigregister(Fl_Hor_Nice_Slider)

class Fl_Hor_Slider(Fl_Slider):
    """

    The Fl_Hor_Slider widget contains a sliding knob inside a box. It is 
    often used as a scrollbar. Moving the box all the way to the top/left sets 
    it to the minimum(), and to the bottom/right to the maximum(). The minimum() 
    may be greater than the maximum() to reverse the slider direction.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Hor_Slider self, int X, int Y, int W, int H, char const * l=None) -> Fl_Hor_Slider"""
        if self.__class__ == Fl_Hor_Slider:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Hor_Slider(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Hor_Slider
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Hor_Slider(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Hor_Slider self)"""
        return _fltk.Fl_Hor_Slider_draw(self, *args)

Fl_Hor_Slider_swigregister = _fltk.Fl_Hor_Slider_swigregister
Fl_Hor_Slider_swigregister(Fl_Hor_Slider)

class Fl_Value_Slider(Fl_Slider):
    """

    The Fl_Value_Slider widget is a Fl_Slider widget with a box displaying 
    the current value.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Value_Slider self)"""
        return _fltk.Fl_Value_Slider_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Value_Slider self, int arg0) -> int"""
        return _fltk.Fl_Value_Slider_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Value_Slider self, int x, int y, int w, int h, char const * l=None) -> Fl_Value_Slider"""
        if self.__class__ == Fl_Value_Slider:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Value_Slider(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def textfont(self, *args) -> "void":
        """
        textfont(Fl_Value_Slider self) -> Fl_Font
        textfont(Fl_Value_Slider self, Fl_Font s)
        """
        return _fltk.Fl_Value_Slider_textfont(self, *args)


    def textsize(self, *args) -> "void":
        """
        textsize(Fl_Value_Slider self) -> Fl_Fontsize
        textsize(Fl_Value_Slider self, Fl_Fontsize s)
        """
        return _fltk.Fl_Value_Slider_textsize(self, *args)


    def textcolor(self, *args) -> "void":
        """
        textcolor(Fl_Value_Slider self) -> Fl_Color
        textcolor(Fl_Value_Slider self, Fl_Color s)
        """
        return _fltk.Fl_Value_Slider_textcolor(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Value_Slider
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Value_Slider(self)
        return weakref_proxy(self)
Fl_Value_Slider_swigregister = _fltk.Fl_Value_Slider_swigregister
Fl_Value_Slider_swigregister(Fl_Value_Slider)

class Fl_Hor_Value_Slider(Fl_Value_Slider):
    """

    The Fl_Hor_Value_Slider widget contains a sliding knob inside a box. It is 
    often used as a scrollbar. Moving the box all the way to the top/left sets 
    it to the minimum(), and to the bottom/right to the maximum(). The minimum() 
    may be greater than the maximum() to reverse the slider direction.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Hor_Value_Slider self, int X, int Y, int W, int H, char const * l=None) -> Fl_Hor_Value_Slider"""
        if self.__class__ == Fl_Hor_Value_Slider:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Hor_Value_Slider(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Hor_Value_Slider
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Hor_Value_Slider(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Hor_Value_Slider self)"""
        return _fltk.Fl_Hor_Value_Slider_draw(self, *args)

Fl_Hor_Value_Slider_swigregister = _fltk.Fl_Hor_Value_Slider_swigregister
Fl_Hor_Value_Slider_swigregister(Fl_Hor_Value_Slider)

class Fl_Int_Input(Fl_Input):
    """

    The Fl_Int_Input class is a subclass of Fl_Input  that only allows the user 
    to type decimal digits (or hex numbers of the form 0xaef).

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Int_Input self, int X, int Y, int W, int H, char const * l=None) -> Fl_Int_Input"""
        if self.__class__ == Fl_Int_Input:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Int_Input(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Int_Input
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Int_Input(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Int_Input self)"""
        return _fltk.Fl_Int_Input_draw(self, *args)

Fl_Int_Input_swigregister = _fltk.Fl_Int_Input_swigregister
Fl_Int_Input_swigregister(Fl_Int_Input)

class Fl_Input_Choice(Fl_Group):
    """

    A combination of the input widget and a menu button. The user can either 
    type into the input area, or use the menu button chooser on the right, 
    which loads the input area with predefined text. Normally it is drawn with 
    an inset box and a white background.

    The application can directly access both the input and menu widgets directly, 
    using the menubutton() and input() accessor methods. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Input_Choice self, int X, int Y, int W, int H, char const * L=None) -> Fl_Input_Choice"""
        if self.__class__ == Fl_Input_Choice:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Input_Choice(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def add(self, *args) -> "void":
        """add(Fl_Input_Choice self, char const * s)"""
        val = _fltk.Fl_Input_Choice_add(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def changed(self, *args) -> "int":
        """changed(Fl_Input_Choice self) -> int"""
        return _fltk.Fl_Input_Choice_changed(self, *args)


    def clear_changed(self, *args) -> "void":
        """clear_changed(Fl_Input_Choice self)"""
        return _fltk.Fl_Input_Choice_clear_changed(self, *args)


    def set_changed(self, *args) -> "void":
        """set_changed(Fl_Input_Choice self)"""
        return _fltk.Fl_Input_Choice_set_changed(self, *args)


    def clear(self, *args) -> "void":
        """clear(Fl_Input_Choice self)"""
        return _fltk.Fl_Input_Choice_clear(self, *args)


    def down_box(self, *args) -> "void":
        """
        down_box(Fl_Input_Choice self) -> Fl_Boxtype
        down_box(Fl_Input_Choice self, Fl_Boxtype b)
        """
        return _fltk.Fl_Input_Choice_down_box(self, *args)


    def menu(self, *args) -> "void":
        """
        menu(Fl_Input_Choice self) -> Fl_Menu_Item
        menu(Fl_Input_Choice self, Fl_Menu_Item m)
        """
        return _fltk.Fl_Input_Choice_menu(self, *args)


    def resize(self, *args) -> "void":
        """resize(Fl_Input_Choice self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Input_Choice_resize(self, *args)


    def textcolor(self, *args) -> "void":
        """
        textcolor(Fl_Input_Choice self) -> Fl_Color
        textcolor(Fl_Input_Choice self, Fl_Color c)
        """
        return _fltk.Fl_Input_Choice_textcolor(self, *args)


    def textfont(self, *args) -> "void":
        """
        textfont(Fl_Input_Choice self) -> Fl_Font
        textfont(Fl_Input_Choice self, Fl_Font f)
        """
        return _fltk.Fl_Input_Choice_textfont(self, *args)


    def textsize(self, *args) -> "void":
        """
        textsize(Fl_Input_Choice self) -> Fl_Fontsize
        textsize(Fl_Input_Choice self, Fl_Fontsize s)
        """
        return _fltk.Fl_Input_Choice_textsize(self, *args)


    def value(self, *args) -> "void":
        """
        value(Fl_Input_Choice self) -> char const
        value(Fl_Input_Choice self, char const * val)
        value(Fl_Input_Choice self, int val)
        """
        return _fltk.Fl_Input_Choice_value(self, *args)


    def menubutton(self, *args) -> "Fl_Menu_Button *":
        """menubutton(Fl_Input_Choice self) -> Fl_Menu_Button"""
        return _fltk.Fl_Input_Choice_menubutton(self, *args)


    def input(self, *args) -> "Fl_Input *":
        """input(Fl_Input_Choice self) -> Fl_Input"""
        return _fltk.Fl_Input_Choice_input(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Input_Choice
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Input_Choice(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Input_Choice self)"""
        return _fltk.Fl_Input_Choice_draw(self, *args)

Fl_Input_Choice_swigregister = _fltk.Fl_Input_Choice_swigregister
Fl_Input_Choice_swigregister(Fl_Input_Choice)

class Fl_JPEG_Image(Fl_RGB_Image):
    """

    The Fl_JPEG_Image class supports loading, caching, and drawing of Joint 
    Photographic Experts Group (JPEG) File Interchange Format (JFIF) images. 
    The class supports grayscale and color (RGB) JPEG image files.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Fl_JPEG_Image self, char const * filename) -> Fl_JPEG_Image
        __init__(Fl_JPEG_Image self, char const * name, unsigned char const * data) -> Fl_JPEG_Image
        """
        if self.__class__ == Fl_JPEG_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_JPEG_Image(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_JPEG_Image
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_JPEG_Image(self)
        return weakref_proxy(self)
Fl_JPEG_Image_swigregister = _fltk.Fl_JPEG_Image_swigregister
Fl_JPEG_Image_swigregister(Fl_JPEG_Image)

class Fl_Line_Dial(Fl_Dial):
    """

    The Fl_Line_Dial widget provides a circular dial to control a single 
    floating point value.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Line_Dial self, int X, int Y, int W, int H, char const * L=None) -> Fl_Line_Dial"""
        if self.__class__ == Fl_Line_Dial:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Line_Dial(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Line_Dial
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Line_Dial(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Line_Dial self)"""
        return _fltk.Fl_Line_Dial_draw(self, *args)

Fl_Line_Dial_swigregister = _fltk.Fl_Line_Dial_swigregister
Fl_Line_Dial_swigregister(Fl_Line_Dial)

class Fl_Menu_Bar(Fl_Menu_):
    """

    This widget provides a standard menubar interface. Usually you will put 
    this widget along the top edge of your window. The height of the widget 
    should be 30 for the menu titles to draw correctly with the default font.

    The items on the bar and the menus they bring up are defined by a single 
    Fl_Menu_Item array. Because a Fl_Menu_Item array defines a hierarchy, the 
    top level menu defines the items in the menubar, while the submenus define 
    the pull-down menus. Sub-sub menus and lower pop up to the right of the 
    submenus.

    If there is an item in the top menu that is not a title of a submenu, then 
    it acts like a 'button' in the menubar. Clicking on it will pick it.

    When the user picks an item off the menu, the item's callback is done with 
    the menubar as the Fl_Widget* argument. If the item does not have a callback 
    the menubar's callback is done instead.

    Submenus will also pop up in response to shortcuts indicated by putting 
    a '&' character in the name field of the menu item. If you put a '&' 
    character in a top-level 'button' then the shortcut picks it. The '&' 
    character in submenus is ignored until the menu is popped up.

    Typing the shortcut() of any of the menu items will cause callbacks 
    exactly the same as when you pick the item with the mouse. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Menu_Bar self)"""
        return _fltk.Fl_Menu_Bar_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Menu_Bar self, int arg0) -> int"""
        return _fltk.Fl_Menu_Bar_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Menu_Bar self, int X, int Y, int W, int H, char const * l=None) -> Fl_Menu_Bar"""
        if self.__class__ == Fl_Menu_Bar:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Menu_Bar(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Menu_Bar
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Menu_Bar(self)
        return weakref_proxy(self)
Fl_Menu_Bar_swigregister = _fltk.Fl_Menu_Bar_swigregister
Fl_Menu_Bar_swigregister(Fl_Menu_Bar)

class Fl_Menu_Button(Fl_Menu_):
    """

    This is a button that when pushed pops up a menu (or hierarchy of menus) 
    defined by an array of Fl_Menu_Item objects.

    Fl_Menu_Button widget.

    Normally any mouse button will pop up a menu and it is lined up below the 
    button as shown in the picture. However an Fl_Menu_Button may also control 
    a pop-up menu. This is done by setting the type() , see below.

    The menu will also pop up in response to shortcuts indicated by putting 
    a '&' character in the label().

    Typing the shortcut() of any of the menu items will cause callbacks exactly 
    the same as when you pick the item with the mouse. The '&' character in menu 
    item names are only looked at when the menu is popped up, however.

    When the user picks an item off the menu, the item's callback is done with 
    the menu_button as the Fl_Widget* argument. If the item does not have a 
    callback the menu_button's callback is done instead. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Menu_Button self)"""
        return _fltk.Fl_Menu_Button_draw(self, *args)

    POPUP1 = _fltk.Fl_Menu_Button_POPUP1
    POPUP2 = _fltk.Fl_Menu_Button_POPUP2
    POPUP12 = _fltk.Fl_Menu_Button_POPUP12
    POPUP3 = _fltk.Fl_Menu_Button_POPUP3
    POPUP13 = _fltk.Fl_Menu_Button_POPUP13
    POPUP23 = _fltk.Fl_Menu_Button_POPUP23
    POPUP123 = _fltk.Fl_Menu_Button_POPUP123

    def handle(self, *args) -> "int":
        """handle(Fl_Menu_Button self, int arg0) -> int"""
        return _fltk.Fl_Menu_Button_handle(self, *args)


    def popup(self, *args) -> "Fl_Menu_Item const *":
        """popup(Fl_Menu_Button self) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu_Button_popup(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Menu_Button self, int arg2, int arg3, int arg4, int arg5, char const * arg6=None) -> Fl_Menu_Button"""
        if self.__class__ == Fl_Menu_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Menu_Button(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Menu_Button
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Menu_Button(self)
        return weakref_proxy(self)
Fl_Menu_Button_swigregister = _fltk.Fl_Menu_Button_swigregister
Fl_Menu_Button_swigregister(Fl_Menu_Button)

FL_MENU_INACTIVE = _fltk.FL_MENU_INACTIVE
FL_MENU_TOGGLE = _fltk.FL_MENU_TOGGLE
FL_MENU_VALUE = _fltk.FL_MENU_VALUE
FL_MENU_RADIO = _fltk.FL_MENU_RADIO
FL_MENU_INVISIBLE = _fltk.FL_MENU_INVISIBLE
FL_SUBMENU_POINTER = _fltk.FL_SUBMENU_POINTER
FL_SUBMENU = _fltk.FL_SUBMENU
FL_MENU_DIVIDER = _fltk.FL_MENU_DIVIDER
FL_MENU_HORIZONTAL = _fltk.FL_MENU_HORIZONTAL
class Fl_Menu_Item(object):
    """

    The Fl_Menu_Item structure defines a single menu item that is used by the 
    Fl_Menu_ class. This structure is defined as

          Fl_Menu_Item :
            text 		-> character array # label()
            shortcut_ 	-> unsigned long
            callback_	-> Fl_Callback
            user_data_	
            flags		-> int
            labeltype_	-> unsigned character
            labelfont_	-> unsigned character
            labelsize_	-> unsigned character
            labelcolor_	-> unsigned character


          enum: # values for flags:
            FL_MENU_INACTIVE	= 1,
            FL_MENU_TOGGLE		= 2,
            FL_MENU_VALUE		= 4,
            FL_MENU_RADIO		= 8,
            FL_MENU_INVISIBLE	= 0x10,
            FL_SUBMENU_POINTER	= 0x20,
            FL_SUBMENU		= 0x40,
            FL_MENU_DIVIDER		= 0x80,
            FL_MENU_HORIZONTAL	= 0x100


    Typically menu items are statically defined; for example:

          MenuTable = (
            ('&alpha',   FL_ALT+ord('a'), the_cb, 1),
            ('&beta',    FL_ALT+ord('b'), the_cb, 2),
            ('gamma',    FL_ALT+ord('c'), the_cb, 3, FL_MENU_DIVIDER),
            ('&strange',  0,   strange_cb),
            ('&charm',    0,   charm_cb),
            ('&truth',    0,   truth_cb),
            ('b&eauty',   0,   beauty_cb),
            ('sub&menu',	0,   0, 0, FL_SUBMENU),
              ('one'),
              ('two'),
              ('three'),
            (None,),
            ('inactive', FL_ALT+'i', 0, 0, FL_MENU_INACTIVE|FL_MENU_DIVIDER),
            ('invisible',FL_ALT+'i', 0, 0, FL_MENU_INVISIBLE),
            ('check',    FL_ALT+'i', 0, 0, FL_MENU_TOGGLE|FL_MENU_VALUE),
            ('box',      FL_ALT+'i', 0, 0, FL_MENU_TOGGLE),
          (None,);

    A submenu title is identified by the bit FL_SUBMENU in the flags field, 
    and ends with a label() that is NULL. You can nest menus to any depth. A 
    pointer to the first item in the submenu can be treated as an Fl_Menu array 
    itself. It is also possible to make seperate submenu arrays with 
    FL_SUBMENU_POINTER flags.

    You should use the method functions to access structure members and not 
    access them directly to avoid compatibility problems with future releases 
    of FLTK. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def next(self, *args) -> "Fl_Menu_Item *":
        """
        next(Fl_Menu_Item self, int arg2=1) -> Fl_Menu_Item
        next(Fl_Menu_Item self, int i=1) -> Fl_Menu_Item
        """
        return _fltk.Fl_Menu_Item_next(self, *args)


    def first(self, *args) -> "Fl_Menu_Item *":
        """
        first(Fl_Menu_Item self) -> Fl_Menu_Item
        first(Fl_Menu_Item self) -> Fl_Menu_Item
        """
        return _fltk.Fl_Menu_Item_first(self, *args)


    def label(self, *args) -> "void":
        """
        label(Fl_Menu_Item self) -> char const
        label(Fl_Menu_Item self, char const * a)
        label(Fl_Menu_Item self, Fl_Labeltype a, char const * b)
        """
        return _fltk.Fl_Menu_Item_label(self, *args)


    def labeltype(self, *args) -> "void":
        """
        labeltype(Fl_Menu_Item self) -> Fl_Labeltype
        labeltype(Fl_Menu_Item self, Fl_Labeltype a)
        """
        return _fltk.Fl_Menu_Item_labeltype(self, *args)


    def labelcolor(self, *args) -> "void":
        """
        labelcolor(Fl_Menu_Item self) -> Fl_Color
        labelcolor(Fl_Menu_Item self, Fl_Color a)
        """
        return _fltk.Fl_Menu_Item_labelcolor(self, *args)


    def labelfont(self, *args) -> "void":
        """
        labelfont(Fl_Menu_Item self) -> Fl_Font
        labelfont(Fl_Menu_Item self, Fl_Font a)
        """
        return _fltk.Fl_Menu_Item_labelfont(self, *args)


    def labelsize(self, *args) -> "void":
        """
        labelsize(Fl_Menu_Item self) -> Fl_Fontsize
        labelsize(Fl_Menu_Item self, Fl_Fontsize a)
        """
        return _fltk.Fl_Menu_Item_labelsize(self, *args)


    def argument(self, *args) -> "void":
        """
        argument(Fl_Menu_Item self) -> long
        argument(Fl_Menu_Item self, long v)
        """
        return _fltk.Fl_Menu_Item_argument(self, *args)


    def shortcut(self, *args) -> "void":
        """
        shortcut(Fl_Menu_Item self) -> int
        shortcut(Fl_Menu_Item self, int s)
        """
        return _fltk.Fl_Menu_Item_shortcut(self, *args)


    def submenu(self, *args) -> "int":
        """submenu(Fl_Menu_Item self) -> int"""
        return _fltk.Fl_Menu_Item_submenu(self, *args)


    def checkbox(self, *args) -> "int":
        """checkbox(Fl_Menu_Item self) -> int"""
        return _fltk.Fl_Menu_Item_checkbox(self, *args)


    def radio(self, *args) -> "int":
        """radio(Fl_Menu_Item self) -> int"""
        return _fltk.Fl_Menu_Item_radio(self, *args)


    def value(self, *args) -> "int":
        """value(Fl_Menu_Item self) -> int"""
        return _fltk.Fl_Menu_Item_value(self, *args)


    def set(self, *args) -> "void":
        """set(Fl_Menu_Item self)"""
        return _fltk.Fl_Menu_Item_set(self, *args)


    def clear(self, *args) -> "void":
        """clear(Fl_Menu_Item self)"""
        return _fltk.Fl_Menu_Item_clear(self, *args)


    def setonly(self, *args) -> "void":
        """setonly(Fl_Menu_Item self)"""
        return _fltk.Fl_Menu_Item_setonly(self, *args)


    def visible(self, *args) -> "int":
        """visible(Fl_Menu_Item self) -> int"""
        return _fltk.Fl_Menu_Item_visible(self, *args)


    def show(self, *args) -> "void":
        """show(Fl_Menu_Item self)"""
        return _fltk.Fl_Menu_Item_show(self, *args)


    def hide(self, *args) -> "void":
        """hide(Fl_Menu_Item self)"""
        return _fltk.Fl_Menu_Item_hide(self, *args)


    def active(self, *args) -> "int":
        """active(Fl_Menu_Item self) -> int"""
        return _fltk.Fl_Menu_Item_active(self, *args)


    def activate(self, *args) -> "void":
        """activate(Fl_Menu_Item self)"""
        return _fltk.Fl_Menu_Item_activate(self, *args)


    def deactivate(self, *args) -> "void":
        """deactivate(Fl_Menu_Item self)"""
        return _fltk.Fl_Menu_Item_deactivate(self, *args)


    def activevisible(self, *args) -> "int":
        """activevisible(Fl_Menu_Item self) -> int"""
        return _fltk.Fl_Menu_Item_activevisible(self, *args)


    def image(self, *args) -> "void":
        """image(Fl_Menu_Item self, Fl_Image a)"""
        return _fltk.Fl_Menu_Item_image(self, *args)


    def measure(self, *args) -> "int":
        """measure(Fl_Menu_Item self, int * h, Fl_Menu_ arg3) -> int"""
        return _fltk.Fl_Menu_Item_measure(self, *args)


    def draw(self, *args) -> "void":
        """draw(Fl_Menu_Item self, int x, int y, int w, int h, Fl_Menu_ arg6, int t=0)"""
        return _fltk.Fl_Menu_Item_draw(self, *args)


    def popup(self, *args) -> "Fl_Menu_Item const *":
        """popup(Fl_Menu_Item self, int X, int Y, char const * title=None, Fl_Menu_Item picked=None, Fl_Menu_ arg6=None) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu_Item_popup(self, *args)


    def pulldown(self, *args) -> "Fl_Menu_Item const *":
        """pulldown(Fl_Menu_Item self, int X, int Y, int W, int H, Fl_Menu_Item picked=None, Fl_Menu_ arg7=None, Fl_Menu_Item title=None, int menubar=0) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu_Item_pulldown(self, *args)


    def test_shortcut(self, *args) -> "Fl_Menu_Item const *":
        """test_shortcut(Fl_Menu_Item self) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu_Item_test_shortcut(self, *args)


    def find_shortcut(self, *args) -> "Fl_Menu_Item const *":
        """find_shortcut(Fl_Menu_Item self, int * ip=None, bool const require_alt=False) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu_Item_find_shortcut(self, *args)


    def do_callback(self, *args) -> "void":
        """
        do_callback(Fl_Menu_Item self, Fl_Widget o)
        do_callback(Fl_Menu_Item self, Fl_Widget o, void * arg)
        do_callback(Fl_Menu_Item self, Fl_Widget o, long arg)
        """
        return _fltk.Fl_Menu_Item_do_callback(self, *args)


    def checked(self, *args) -> "int":
        """checked(Fl_Menu_Item self) -> int"""
        return _fltk.Fl_Menu_Item_checked(self, *args)


    def check(self, *args) -> "void":
        """check(Fl_Menu_Item self)"""
        return _fltk.Fl_Menu_Item_check(self, *args)


    def uncheck(self, *args) -> "void":
        """uncheck(Fl_Menu_Item self)"""
        return _fltk.Fl_Menu_Item_uncheck(self, *args)


    def insert(self, *args) -> "int":
        """insert(Fl_Menu_Item self, int arg2, char const * arg3, int arg4, Fl_Callback * arg5, void * arg6=None, int arg7=0) -> int"""
        return _fltk.Fl_Menu_Item_insert(self, *args)


    def add(self, *args) -> "int":
        """
        add(Fl_Menu_Item self, char const * arg2, int shortcut, Fl_Callback * arg4, void * arg5=None, int arg6=0) -> int
        add(Fl_Menu_Item self, char const * a, char const * b, Fl_Callback * c, void * d=None, int e=0) -> int
        """
        return _fltk.Fl_Menu_Item_add(self, *args)


    def size(self, *args) -> "int":
        """size(Fl_Menu_Item self) -> int"""
        return _fltk.Fl_Menu_Item_size(self, *args)


    def callback(self, *args) -> "PyObject *":
        """
        callback(Fl_Menu_Item self, Fl_Callback * c, void * p)
        callback(Fl_Menu_Item self, Fl_Callback * c)
        callback(Fl_Menu_Item self, Fl_Callback0 * c)
        callback(Fl_Menu_Item self, Fl_Callback1 * c, long p=0)
        callback(Fl_Menu_Item self) -> PyObject *
        """
        return _fltk.Fl_Menu_Item_callback(self, *args)


    def user_data(self, *args) -> "PyObject *":
        """
        user_data(Fl_Menu_Item self)
        user_data(Fl_Menu_Item self, void * v)
        user_data(Fl_Menu_Item self) -> PyObject *
        """
        return _fltk.Fl_Menu_Item_user_data(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Menu_Item self) -> Fl_Menu_Item"""
        this = _fltk.new_Fl_Menu_Item(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Menu_Item
    __del__ = lambda self: None
Fl_Menu_Item_swigregister = _fltk.Fl_Menu_Item_swigregister
Fl_Menu_Item_swigregister(Fl_Menu_Item)

FL_PUP_NONE = _fltk.FL_PUP_NONE
FL_PUP_GREY = _fltk.FL_PUP_GREY
FL_PUP_GRAY = _fltk.FL_PUP_GRAY
FL_MENU_BOX = _fltk.FL_MENU_BOX
FL_PUP_BOX = _fltk.FL_PUP_BOX
FL_MENU_CHECK = _fltk.FL_MENU_CHECK
FL_PUP_CHECK = _fltk.FL_PUP_CHECK
FL_PUP_RADIO = _fltk.FL_PUP_RADIO
FL_PUP_INVISIBLE = _fltk.FL_PUP_INVISIBLE
FL_PUP_SUBMENU = _fltk.FL_PUP_SUBMENU
class Fl_Single_Window(Fl_Window):
    """

    This is the same as Fl_Window. However, it is possible that some 
    implementations will provide double-buffered windows by default. This 
    subclass can be used to force single-buffering. This may be useful for 
    modifying existing programs that use incremental update, or for some 
    types of image data, such as a movie flipbook.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def flush(self, *args) -> "void":
        """flush(Fl_Single_Window self)"""
        return _fltk.Fl_Single_Window_flush(self, *args)


    def __init__(self, *args):
        """
        __init__(Fl_Single_Window self, int W, int H, char const * l=None) -> Fl_Single_Window
        __init__(Fl_Single_Window self, int X, int Y, int W, int H, char const * l=None) -> Fl_Single_Window
        """
        if self.__class__ == Fl_Single_Window:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Single_Window(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def show(self, *args) -> "void":
        """show(Fl_Single_Window self, PyObject * count=None, PyObject * data=None)"""
        return _fltk.Fl_Single_Window_show(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Single_Window
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Single_Window(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Single_Window self)"""
        return _fltk.Fl_Single_Window_draw(self, *args)

Fl_Single_Window_swigregister = _fltk.Fl_Single_Window_swigregister
Fl_Single_Window_swigregister(Fl_Single_Window)

class Fl_Menu_Window(Fl_Single_Window):
    """

    The Fl_Menu_Window widget is a window type used for menus. By default the 
    window is drawn in the hardware overlay planes if they are available so that 
    the menu don't force the rest of the window to redraw.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def erase(self, *args) -> "void":
        """erase(Fl_Menu_Window self)"""
        return _fltk.Fl_Menu_Window_erase(self, *args)


    def flush(self, *args) -> "void":
        """flush(Fl_Menu_Window self)"""
        return _fltk.Fl_Menu_Window_flush(self, *args)


    def hide(self, *args) -> "void":
        """hide(Fl_Menu_Window self)"""
        return _fltk.Fl_Menu_Window_hide(self, *args)


    def overlay(self, *args) -> "unsigned int":
        """overlay(Fl_Menu_Window self) -> unsigned int"""
        return _fltk.Fl_Menu_Window_overlay(self, *args)


    def set_overlay(self, *args) -> "void":
        """set_overlay(Fl_Menu_Window self)"""
        return _fltk.Fl_Menu_Window_set_overlay(self, *args)


    def clear_overlay(self, *args) -> "void":
        """clear_overlay(Fl_Menu_Window self)"""
        return _fltk.Fl_Menu_Window_clear_overlay(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Menu_Window
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(Fl_Menu_Window self, int W, int H, char const * l=None) -> Fl_Menu_Window
        __init__(Fl_Menu_Window self, int X, int Y, int W, int H, char const * l=None) -> Fl_Menu_Window
        """
        if self.__class__ == Fl_Menu_Window:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Menu_Window(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Menu_Window(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Menu_Window self)"""
        return _fltk.Fl_Menu_Window_draw(self, *args)

Fl_Menu_Window_swigregister = _fltk.Fl_Menu_Window_swigregister
Fl_Menu_Window_swigregister(Fl_Menu_Window)

class Fl_Multiline_Input(Fl_Input):
    """

    This input field displays '
    ' characters as new lines rather than ^J, and 
    accepts the Return, Tab, and up and down arrow keys. This is for editing 
    multiline text.

    This is far from the nirvana of text editors, and is probably only good for 
    small bits of text, 10 lines at most. I think FLTK can be used to write a 
    powerful text editor, but it is not going to be a built-in feature. Powerful 
    text editors in a toolkit are a big source of bloat. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Multiline_Input self, int X, int Y, int W, int H, char const * l=None) -> Fl_Multiline_Input"""
        if self.__class__ == Fl_Multiline_Input:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Multiline_Input(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Multiline_Input
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Multiline_Input(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Multiline_Input self)"""
        return _fltk.Fl_Multiline_Input_draw(self, *args)

Fl_Multiline_Input_swigregister = _fltk.Fl_Multiline_Input_swigregister
Fl_Multiline_Input_swigregister(Fl_Multiline_Input)

class Fl_Output(Fl_Input):
    """

    This widget displays a piece of text. When you set the value() , Fl_Output 
    does a strcpy() to it's own storage, which is useful for program-generated 
    values. The user may select portions of the text using the mouse and paste 
    the contents into other fields or programs.

    There is a single subclass, Fl_Multiline_Output, which allows you to 
    display multiple lines of text.

    The text may contain any characters except 
    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Output self, int X, int Y, int W, int H, char const * l=None) -> Fl_Output"""
        if self.__class__ == Fl_Output:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Output(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Output
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Output(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Output self)"""
        return _fltk.Fl_Output_draw(self, *args)

Fl_Output_swigregister = _fltk.Fl_Output_swigregister
Fl_Output_swigregister(Fl_Output)

class Fl_Multiline_Output(Fl_Output):
    """

    This widget is a subclass of Fl_Output that displays multiple lines of text. 
    It also displays tab characters as whitespace to the next column.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Multiline_Output self, int X, int Y, int W, int H, char const * l=None) -> Fl_Multiline_Output"""
        if self.__class__ == Fl_Multiline_Output:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Multiline_Output(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Multiline_Output
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Multiline_Output(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Multiline_Output self)"""
        return _fltk.Fl_Multiline_Output_draw(self, *args)

Fl_Multiline_Output_swigregister = _fltk.Fl_Multiline_Output_swigregister
Fl_Multiline_Output_swigregister(Fl_Multiline_Output)

class Fl_Multi_Browser(Fl_Browser):
    """

    The Fl_Multi_Browser class is a subclass of Fl_Browser  which lets the user 
    select any set of the lines. The user interface is Macintosh style: clicking 
    an item turns off all the others and selects that one, dragging selects all 
    the items the mouse moves over, and shift + click toggles the items. This 
    is different then how forms did it. Normally the callback is done when the 
    user releases the mouse, but you can change this with when().

    See Fl_Browser for methods to add and remove lines from the browser. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Multi_Browser self, int X, int Y, int W, int H, char const * L=None) -> Fl_Multi_Browser"""
        if self.__class__ == Fl_Multi_Browser:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Multi_Browser(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Multi_Browser
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Multi_Browser(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Multi_Browser self)"""
        return _fltk.Fl_Multi_Browser_draw(self, *args)


    def item_first(self, *args) -> "void *":
        """item_first(Fl_Multi_Browser self) -> void *"""
        return _fltk.Fl_Multi_Browser_item_first(self, *args)


    def item_next(self, *args) -> "void *":
        """item_next(Fl_Multi_Browser self, void * item) -> void *"""
        return _fltk.Fl_Multi_Browser_item_next(self, *args)


    def item_prev(self, *args) -> "void *":
        """item_prev(Fl_Multi_Browser self, void * item) -> void *"""
        return _fltk.Fl_Multi_Browser_item_prev(self, *args)


    def item_last(self, *args) -> "void *":
        """item_last(Fl_Multi_Browser self) -> void *"""
        return _fltk.Fl_Multi_Browser_item_last(self, *args)


    def item_height(self, *args) -> "int":
        """item_height(Fl_Multi_Browser self, void * item) -> int"""
        return _fltk.Fl_Multi_Browser_item_height(self, *args)


    def item_width(self, *args) -> "int":
        """item_width(Fl_Multi_Browser self, void * item) -> int"""
        return _fltk.Fl_Multi_Browser_item_width(self, *args)


    def item_quick_height(self, *args) -> "int":
        """item_quick_height(Fl_Multi_Browser self, void * item) -> int"""
        return _fltk.Fl_Multi_Browser_item_quick_height(self, *args)


    def item_draw(self, *args) -> "void":
        """item_draw(Fl_Multi_Browser self, void * item, int X, int Y, int W, int H)"""
        return _fltk.Fl_Multi_Browser_item_draw(self, *args)


    def item_text(self, *args) -> "char const *":
        """item_text(Fl_Multi_Browser self, void * item) -> char const *"""
        return _fltk.Fl_Multi_Browser_item_text(self, *args)


    def item_swap(self, *args) -> "void":
        """item_swap(Fl_Multi_Browser self, void * a, void * b)"""
        return _fltk.Fl_Multi_Browser_item_swap(self, *args)


    def item_at(self, *args) -> "void *":
        """item_at(Fl_Multi_Browser self, int line) -> void *"""
        return _fltk.Fl_Multi_Browser_item_at(self, *args)


    def full_width(self, *args) -> "int":
        """full_width(Fl_Multi_Browser self) -> int"""
        return _fltk.Fl_Multi_Browser_full_width(self, *args)


    def full_height(self, *args) -> "int":
        """full_height(Fl_Multi_Browser self) -> int"""
        return _fltk.Fl_Multi_Browser_full_height(self, *args)


    def incr_height(self, *args) -> "int":
        """incr_height(Fl_Multi_Browser self) -> int"""
        return _fltk.Fl_Multi_Browser_incr_height(self, *args)


    def item_select(self, *args) -> "void":
        """item_select(Fl_Multi_Browser self, void * item, int val)"""
        return _fltk.Fl_Multi_Browser_item_select(self, *args)


    def item_selected(self, *args) -> "int":
        """item_selected(Fl_Multi_Browser self, void * item) -> int"""
        return _fltk.Fl_Multi_Browser_item_selected(self, *args)

Fl_Multi_Browser_swigregister = _fltk.Fl_Multi_Browser_swigregister
Fl_Multi_Browser_swigregister(Fl_Multi_Browser)

class Fl_Multi_Label(object):
    """Proxy of C++ Fl_Multi_Label class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def label(self, *args) -> "void":
        """
        label(Fl_Multi_Label self, Fl_Widget arg2)
        label(Fl_Multi_Label self, Fl_Menu_Item arg2)
        """
        return _fltk.Fl_Multi_Label_label(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Multi_Label self) -> Fl_Multi_Label"""
        this = _fltk.new_Fl_Multi_Label(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Multi_Label
    __del__ = lambda self: None
Fl_Multi_Label_swigregister = _fltk.Fl_Multi_Label_swigregister
Fl_Multi_Label_swigregister(Fl_Multi_Label)

class Fl_Nice_Slider(Fl_Slider):
    """

    The Fl_Nice_Slider widget contains a sliding knob inside a box. It is 
    often used as a scrollbar. Moving the box all the way to the top/left sets 
    it to the minimum(), and to the bottom/right to the maximum(). The minimum() 
    may be greater than the maximum() to reverse the slider direction.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Nice_Slider self, int X, int Y, int W, int H, char const * L=None) -> Fl_Nice_Slider"""
        if self.__class__ == Fl_Nice_Slider:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Nice_Slider(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Nice_Slider
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Nice_Slider(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Nice_Slider self)"""
        return _fltk.Fl_Nice_Slider_draw(self, *args)

Fl_Nice_Slider_swigregister = _fltk.Fl_Nice_Slider_swigregister
Fl_Nice_Slider_swigregister(Fl_Nice_Slider)

class Fl_Overlay_Window(Fl_Double_Window):
    """

    This window provides double buffering and also the ability to draw the 
    'overlay' which is another picture placed on top of the main image. The 
    overlay is designed to be a rapidly-changing but simple graphic such as 
    a mouse selection box. Fl_Overlay_Window uses the overlay planes provided 
    by your graphics hardware if they are available.

    If no hardware support is found the overlay is simulated by drawing directly 
    into the on-screen copy of the double-buffered window, and 'erased' by 
    copying the backbuffer over it again. This means the overlay will blink if 
    you change the image in the window. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw_overlay(self, *args) -> "void":
        """draw_overlay(Fl_Overlay_Window self)"""
        return _fltk.Fl_Overlay_Window_draw_overlay(self, *args)


    def flush(self, *args) -> "void":
        """flush(Fl_Overlay_Window self)"""
        return _fltk.Fl_Overlay_Window_flush(self, *args)


    def hide(self, *args) -> "void":
        """hide(Fl_Overlay_Window self)"""
        return _fltk.Fl_Overlay_Window_hide(self, *args)


    def resize(self, *args) -> "void":
        """resize(Fl_Overlay_Window self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Overlay_Window_resize(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Overlay_Window
    __del__ = lambda self: None

    def can_do_overlay(self, *args) -> "int":
        """can_do_overlay(Fl_Overlay_Window self) -> int"""
        return _fltk.Fl_Overlay_Window_can_do_overlay(self, *args)


    def redraw_overlay(self, *args) -> "void":
        """redraw_overlay(Fl_Overlay_Window self)"""
        return _fltk.Fl_Overlay_Window_redraw_overlay(self, *args)


    def __init__(self, *args):
        """
        __init__(Fl_Overlay_Window self, int W, int H, char const * l=None) -> Fl_Overlay_Window
        __init__(Fl_Overlay_Window self, int X, int Y, int W, int H, char const * l=None) -> Fl_Overlay_Window
        """
        if self.__class__ == Fl_Overlay_Window:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Overlay_Window(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def show(self, *args) -> "void":
        """show(Fl_Overlay_Window self, PyObject * count=None, PyObject * data=None)"""
        return _fltk.Fl_Overlay_Window_show(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Overlay_Window(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Overlay_Window self)"""
        return _fltk.Fl_Overlay_Window_draw(self, *args)

Fl_Overlay_Window_swigregister = _fltk.Fl_Overlay_Window_swigregister
Fl_Overlay_Window_swigregister(Fl_Overlay_Window)

class Fl_Pack(Fl_Group):
    """

    This widget was designed to add the functionality of compressing and 
    aligning widgets.

    If type() is FL_HORIZONTAL all the children are resized to the height of 
    the Fl_Pack, and are moved next to each other horizontally. If type() is 
    not FL_HORIZONTAL then the children are resized to the width and are stacked 
    below each other. Then the Fl_Pack resizes itself to surround the child 
    widgets.

    This widget is needed for the Fl_Tabs. In addition you may want to put the 
    Fl_Pack inside an Fl_Scroll. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    VERTICAL = _fltk.Fl_Pack_VERTICAL
    HORIZONTAL = _fltk.Fl_Pack_HORIZONTAL

    def draw(self, *args) -> "void":
        """draw(Fl_Pack self)"""
        return _fltk.Fl_Pack_draw(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Pack self, int x, int y, int w, int h, char const * l=None) -> Fl_Pack"""
        if self.__class__ == Fl_Pack:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Pack(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def spacing(self, *args) -> "void":
        """
        spacing(Fl_Pack self) -> int
        spacing(Fl_Pack self, int i)
        """
        return _fltk.Fl_Pack_spacing(self, *args)


    def horizontal(self, *args) -> "uchar":
        """horizontal(Fl_Pack self) -> uchar"""
        return _fltk.Fl_Pack_horizontal(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Pack
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Pack(self)
        return weakref_proxy(self)
Fl_Pack_swigregister = _fltk.Fl_Pack_swigregister
Fl_Pack_swigregister(Fl_Pack)

class Fl_PNG_Image(Fl_RGB_Image):
    """

    The Fl_PNG_Image class supports loading, caching, and drawing of Portable 
    Network Graphics (PNG) image files. The class loads colormapped and 
    full-color images and handles color- and alpha-based transparency.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Fl_PNG_Image self, char const * filename) -> Fl_PNG_Image
        __init__(Fl_PNG_Image self, char const * name_png, unsigned char const * buffer, int datasize) -> Fl_PNG_Image
        """
        if self.__class__ == Fl_PNG_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_PNG_Image(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_PNG_Image
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_PNG_Image(self)
        return weakref_proxy(self)
Fl_PNG_Image_swigregister = _fltk.Fl_PNG_Image_swigregister
Fl_PNG_Image_swigregister(Fl_PNG_Image)

class Fl_PNM_Image(Fl_RGB_Image):
    """

    The Fl_PNM_Image class supports loading, caching, and drawing of Portable 
    Anymap (PNM, PBM, PGM, PPM) image files. The class loads bitmap, grayscale, 
    and full-color images in both ASCII and binary formats.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_PNM_Image self, char const * filename) -> Fl_PNM_Image"""
        if self.__class__ == Fl_PNM_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_PNM_Image(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_PNM_Image
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_PNM_Image(self)
        return weakref_proxy(self)
Fl_PNM_Image_swigregister = _fltk.Fl_PNM_Image_swigregister
Fl_PNM_Image_swigregister(Fl_PNM_Image)

class Fl_Positioner(Fl_Widget):
    """

    This class is provided for Forms compatibility. It provides 2D input. It 
    would be useful if this could be put atop another widget so that the 
    crosshairs are on top, but this is not implemented. The color of the 
    crosshairs is selection_color().

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Positioner self)"""
        return _fltk.Fl_Positioner_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Positioner self, int arg0) -> int"""
        return _fltk.Fl_Positioner_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Positioner self, int x, int y, int w, int h, char const * l=None) -> Fl_Positioner"""
        if self.__class__ == Fl_Positioner:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Positioner(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def xvalue(self, *args) -> "int":
        """
        xvalue(Fl_Positioner self) -> double
        xvalue(Fl_Positioner self, double arg2) -> int
        """
        return _fltk.Fl_Positioner_xvalue(self, *args)


    def yvalue(self, *args) -> "int":
        """
        yvalue(Fl_Positioner self) -> double
        yvalue(Fl_Positioner self, double arg2) -> int
        """
        return _fltk.Fl_Positioner_yvalue(self, *args)


    def value(self, *args) -> "int":
        """value(Fl_Positioner self, double arg2, double arg3) -> int"""
        return _fltk.Fl_Positioner_value(self, *args)


    def xbounds(self, *args) -> "void":
        """xbounds(Fl_Positioner self, double arg2, double arg3)"""
        return _fltk.Fl_Positioner_xbounds(self, *args)


    def xminimum(self, *args) -> "void":
        """
        xminimum(Fl_Positioner self) -> double
        xminimum(Fl_Positioner self, double a)
        """
        return _fltk.Fl_Positioner_xminimum(self, *args)


    def xmaximum(self, *args) -> "void":
        """
        xmaximum(Fl_Positioner self) -> double
        xmaximum(Fl_Positioner self, double a)
        """
        return _fltk.Fl_Positioner_xmaximum(self, *args)


    def ybounds(self, *args) -> "void":
        """ybounds(Fl_Positioner self, double arg2, double arg3)"""
        return _fltk.Fl_Positioner_ybounds(self, *args)


    def yminimum(self, *args) -> "void":
        """
        yminimum(Fl_Positioner self) -> double
        yminimum(Fl_Positioner self, double a)
        """
        return _fltk.Fl_Positioner_yminimum(self, *args)


    def ymaximum(self, *args) -> "void":
        """
        ymaximum(Fl_Positioner self) -> double
        ymaximum(Fl_Positioner self, double a)
        """
        return _fltk.Fl_Positioner_ymaximum(self, *args)


    def xstep(self, *args) -> "void":
        """xstep(Fl_Positioner self, double a)"""
        return _fltk.Fl_Positioner_xstep(self, *args)


    def ystep(self, *args) -> "void":
        """ystep(Fl_Positioner self, double a)"""
        return _fltk.Fl_Positioner_ystep(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Positioner
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Positioner(self)
        return weakref_proxy(self)
Fl_Positioner_swigregister = _fltk.Fl_Positioner_swigregister
Fl_Positioner_swigregister(Fl_Positioner)

class Fl_Preferences(object):
    """

    Fl_Preferences provides methods to store user setting between application 
    starts. It is similar to the Registry on WIN32 and Preferences on MacOS, 
    and provides a simple configuration mechanism for UNIX.

    Fl_Preferences uses a hierarchy to store data. It bundles similar data into 
    groups and manages entries into those groups as name/value pairs.

    Preferences are stored in text files that can be edited manually. The file 
    format is easy to read and relatively forgiving. Preferences files are the 
    same on all platforms. User comments in preference files are preserved. 
    Filenames are unique for each application by using a vendor/application 
    naming scheme. The user must provide default values for all entries to 
    ensure proper operation should preferences be corrupted or not yet exist.

    Entries can be of any length. However, the size of each preferences file 
    should be kept under 100k for performance reasons. One application can 
    have multiple preferences files. Extensive binary data however should be 
    stored in seperate files; see the getUserdataPath() method. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    SYSTEM = _fltk.Fl_Preferences_SYSTEM
    USER = _fltk.Fl_Preferences_USER

    def __init__(self, *args):
        """
        __init__(Fl_Preferences self, Fl_Preferences::Root root, char const * vendor, char const * application) -> Fl_Preferences
        __init__(Fl_Preferences self, char const * path, char const * vendor, char const * application) -> Fl_Preferences
        __init__(Fl_Preferences self, Fl_Preferences arg2, char const * group) -> Fl_Preferences
        """
        this = _fltk.new_Fl_Preferences(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Preferences
    __del__ = lambda self: None

    def groups(self, *args) -> "int":
        """groups(Fl_Preferences self) -> int"""
        return _fltk.Fl_Preferences_groups(self, *args)


    def group(self, *args) -> "char const *":
        """group(Fl_Preferences self, int arg2) -> char const *"""
        return _fltk.Fl_Preferences_group(self, *args)


    def groupExists(self, *args) -> "char":
        """groupExists(Fl_Preferences self, char const * group) -> char"""
        return _fltk.Fl_Preferences_groupExists(self, *args)


    def deleteGroup(self, *args) -> "char":
        """deleteGroup(Fl_Preferences self, char const * group) -> char"""
        return _fltk.Fl_Preferences_deleteGroup(self, *args)


    def entries(self, *args) -> "int":
        """entries(Fl_Preferences self) -> int"""
        return _fltk.Fl_Preferences_entries(self, *args)


    def entry(self, *args) -> "char const *":
        """entry(Fl_Preferences self, int arg2) -> char const *"""
        return _fltk.Fl_Preferences_entry(self, *args)


    def entryExists(self, *args) -> "char":
        """entryExists(Fl_Preferences self, char const * entry) -> char"""
        return _fltk.Fl_Preferences_entryExists(self, *args)


    def deleteEntry(self, *args) -> "char":
        """deleteEntry(Fl_Preferences self, char const * entry) -> char"""
        return _fltk.Fl_Preferences_deleteEntry(self, *args)


    def set(self, *args) -> "char":
        """
        set(Fl_Preferences self, char const * entry, int value) -> char
        set(Fl_Preferences self, char const * entry, float value, int precision) -> char
        set(Fl_Preferences self, char const * entry, double value) -> char
        set(Fl_Preferences self, char const * entry, double value, int precision) -> char
        set(Fl_Preferences self, char const * entry, char const * cvalue) -> char
        set(Fl_Preferences self, char const * entry, void const * cvalue, int size) -> char
        """
        return _fltk.Fl_Preferences_set(self, *args)


    def get(self, *args) -> "char":
        """
        get(Fl_Preferences self, char const * entry, int defaultValue) -> char
        get(Fl_Preferences self, char const * entry, float defaultValue) -> char
        get(Fl_Preferences self, char const * entry, double defaultValue) -> char
        get(Fl_Preferences self, char const * entry, char const * defaultValue, int maxSize) -> char
        get(Fl_Preferences self, char const * entry, void * value, void const * defaultValue, int defaultSize, int maxSize) -> char
        """
        return _fltk.Fl_Preferences_get(self, *args)


    def size(self, *args) -> "int":
        """size(Fl_Preferences self, char const * entry) -> int"""
        return _fltk.Fl_Preferences_size(self, *args)


    def getUserdataPath(self, *args) -> "char":
        """getUserdataPath(Fl_Preferences self, char * path) -> char"""
        return _fltk.Fl_Preferences_getUserdataPath(self, *args)


    def flush(self, *args) -> "void":
        """flush(Fl_Preferences self)"""
        return _fltk.Fl_Preferences_flush(self, *args)

Fl_Preferences_swigregister = _fltk.Fl_Preferences_swigregister
Fl_Preferences_swigregister(Fl_Preferences)

class Fl_Progress(Fl_Widget):
    """

    The Fl_Progress widget displays a progress bar for the user.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Progress self)"""
        return _fltk.Fl_Progress_draw(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Progress self, int x, int y, int w, int h, char const * l=None) -> Fl_Progress"""
        if self.__class__ == Fl_Progress:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Progress(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def maximum(self, *args) -> "float":
        """
        maximum(Fl_Progress self, float v)
        maximum(Fl_Progress self) -> float
        """
        return _fltk.Fl_Progress_maximum(self, *args)


    def minimum(self, *args) -> "float":
        """
        minimum(Fl_Progress self, float v)
        minimum(Fl_Progress self) -> float
        """
        return _fltk.Fl_Progress_minimum(self, *args)


    def value(self, *args) -> "float":
        """
        value(Fl_Progress self, float v)
        value(Fl_Progress self) -> float
        """
        return _fltk.Fl_Progress_value(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Progress
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Progress(self)
        return weakref_proxy(self)
Fl_Progress_swigregister = _fltk.Fl_Progress_swigregister
Fl_Progress_swigregister(Fl_Progress)

class Fl_Radio_Button(Fl_Button):
    """Proxy of C++ Fl_Radio_Button class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Radio_Button self, int X, int Y, int W, int H, char const * L=None) -> Fl_Radio_Button"""
        if self.__class__ == Fl_Radio_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Radio_Button(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Radio_Button
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Radio_Button(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Radio_Button self)"""
        return _fltk.Fl_Radio_Button_draw(self, *args)

Fl_Radio_Button_swigregister = _fltk.Fl_Radio_Button_swigregister
Fl_Radio_Button_swigregister(Fl_Radio_Button)

class Fl_Radio_Light_Button(Fl_Light_Button):
    """Proxy of C++ Fl_Radio_Light_Button class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Radio_Light_Button self, int X, int Y, int W, int H, char const * l=None) -> Fl_Radio_Light_Button"""
        if self.__class__ == Fl_Radio_Light_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Radio_Light_Button(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Radio_Light_Button
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Radio_Light_Button(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Radio_Light_Button self)"""
        return _fltk.Fl_Radio_Light_Button_draw(self, *args)

Fl_Radio_Light_Button_swigregister = _fltk.Fl_Radio_Light_Button_swigregister
Fl_Radio_Light_Button_swigregister(Fl_Radio_Light_Button)

class Fl_Round_Button(Fl_Light_Button):
    """

    Buttons generate callbacks when they are clicked by the user. You control 
    exactly when and how by changing the values for type() and when().

    The Fl_Round_Button subclass display the 'on' state by turning on a light, 
    rather than drawing pushed in. The shape of the 'light' is initially set 
    to FL_ROUND_DOWN_BOX. The color of the light when on is controlled with 
    selection_color(), which defaults to FL_RED.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Round_Button self, int x, int y, int w, int h, char const * l=None) -> Fl_Round_Button"""
        if self.__class__ == Fl_Round_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Round_Button(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Round_Button
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Round_Button(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Round_Button self)"""
        return _fltk.Fl_Round_Button_draw(self, *args)

Fl_Round_Button_swigregister = _fltk.Fl_Round_Button_swigregister
Fl_Round_Button_swigregister(Fl_Round_Button)

class Fl_Radio_Round_Button(Fl_Round_Button):
    """Proxy of C++ Fl_Radio_Round_Button class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Radio_Round_Button self, int X, int Y, int W, int H, char const * L=None) -> Fl_Radio_Round_Button"""
        if self.__class__ == Fl_Radio_Round_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Radio_Round_Button(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Radio_Round_Button
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Radio_Round_Button(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Radio_Round_Button self)"""
        return _fltk.Fl_Radio_Round_Button_draw(self, *args)

Fl_Radio_Round_Button_swigregister = _fltk.Fl_Radio_Round_Button_swigregister
Fl_Radio_Round_Button_swigregister(Fl_Radio_Round_Button)

class Fl_Repeat_Button(Fl_Button):
    """

    The Fl_Repeat_Button is a subclass of Fl_Button that generates a callback 
    when it is pressed and then repeatedly generates callbacks as long as it 
    is held down. The speed of the repeat is fixed and depends on the 
    implementation.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def handle(self, *args) -> "int":
        """handle(Fl_Repeat_Button self, int arg0) -> int"""
        return _fltk.Fl_Repeat_Button_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Repeat_Button self, int X, int Y, int W, int H, char const * l=None) -> Fl_Repeat_Button"""
        if self.__class__ == Fl_Repeat_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Repeat_Button(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def deactivate(self, *args) -> "void":
        """deactivate(Fl_Repeat_Button self)"""
        return _fltk.Fl_Repeat_Button_deactivate(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Repeat_Button
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Repeat_Button(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Repeat_Button self)"""
        return _fltk.Fl_Repeat_Button_draw(self, *args)

Fl_Repeat_Button_swigregister = _fltk.Fl_Repeat_Button_swigregister
Fl_Repeat_Button_swigregister(Fl_Repeat_Button)

class Fl_Return_Button(Fl_Button):
    """

    The Fl_Return_Button is a subclass of Fl_Button that generates a callback 
    when it is pressed or when the user presses the Enter key. A carriage-return 
    symbol is drawn next to the button label.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Return_Button self)"""
        return _fltk.Fl_Return_Button_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Return_Button self, int arg0) -> int"""
        return _fltk.Fl_Return_Button_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Return_Button self, int X, int Y, int W, int H, char const * l=None) -> Fl_Return_Button"""
        if self.__class__ == Fl_Return_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Return_Button(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Return_Button
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Return_Button(self)
        return weakref_proxy(self)
Fl_Return_Button_swigregister = _fltk.Fl_Return_Button_swigregister
Fl_Return_Button_swigregister(Fl_Return_Button)

class Fl_Roller(Fl_Valuator):
    """

    The Fl_Roller widget is a 'dolly' control commonly used to move 3D objects.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Roller self)"""
        return _fltk.Fl_Roller_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Roller self, int arg0) -> int"""
        return _fltk.Fl_Roller_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Roller self, int X, int Y, int W, int H, char const * L=None) -> Fl_Roller"""
        if self.__class__ == Fl_Roller:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Roller(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Roller
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Roller(self)
        return weakref_proxy(self)
Fl_Roller_swigregister = _fltk.Fl_Roller_swigregister
Fl_Roller_swigregister(Fl_Roller)

class Fl_Round_Clock(Fl_Clock):
    """

    This widget provides a round analog clock display and is provided for 
    Forms compatibility. It installs a 1-second timeout callback using 
    Fl::add_timeout().

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Round_Clock self, int X, int Y, int W, int H, char const * L=None) -> Fl_Round_Clock"""
        if self.__class__ == Fl_Round_Clock:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Round_Clock(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Round_Clock
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Round_Clock(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Round_Clock self)"""
        return _fltk.Fl_Round_Clock_draw(self, *args)

Fl_Round_Clock_swigregister = _fltk.Fl_Round_Clock_swigregister
Fl_Round_Clock_swigregister(Fl_Round_Clock)

class Fl_Scroll(Fl_Group):
    """

    This container widget lets you maneuver around a set of widgets much larger 
    than your window. If the child widgets are larger than the size of this 
    object then scrollbars will appear so that you can scroll over to them:

    If all of the child widgets are packed together into a solid rectangle then 
    you want to set box() to FL_NO_BOX or one of the _FRAME types. This will 
    result in the best output. However, if the child widgets are a sparse 
    arrangment you must set box() to a real _BOX type. This can result in some 
    blinking during redrawing, but that can be solved by using a Fl_Double_Window.

    This widget can also be used to pan around a single child widget 'canvas'. 
    This child widget should be of your own class, with a draw() method that 
    draws the contents. The scrolling is done by changing the x() and y() of 
    the widget, so this child must use the x() and y() to position it's drawing. 
    To speed up drawing it should test fl_push_clip() .

    Another very useful child is a single Fl_Pack, which is itself a group that 
    packs it's children together and changes size to surround them. Filling the 
    Fl_Pack with Fl_Tabs groups (and then putting normal widgets inside those) 
    gives you a very powerful scrolling list of individually-openable panels.

    Fluid lets you create these, but you can only lay out objects that fit 
    inside the Fl_Scroll without scrolling. Be sure to leave space for the 
    scrollbars, as Fluid won't show these either.

    You cannot use Fl_Window as a child of this since the clipping is not 
    conveyed to it when drawn, and it will draw over the scrollbars and 
    neighboring objects.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Scroll self)"""
        return _fltk.Fl_Scroll_draw(self, *args)


    def resize(self, *args) -> "void":
        """resize(Fl_Scroll self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Scroll_resize(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Scroll self, int arg0) -> int"""
        return _fltk.Fl_Scroll_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Scroll self, int X, int Y, int W, int H, char const * l=None) -> Fl_Scroll"""
        if self.__class__ == Fl_Scroll:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Scroll(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    HORIZONTAL = _fltk.Fl_Scroll_HORIZONTAL
    VERTICAL = _fltk.Fl_Scroll_VERTICAL
    BOTH = _fltk.Fl_Scroll_BOTH
    ALWAYS_ON = _fltk.Fl_Scroll_ALWAYS_ON
    HORIZONTAL_ALWAYS = _fltk.Fl_Scroll_HORIZONTAL_ALWAYS
    VERTICAL_ALWAYS = _fltk.Fl_Scroll_VERTICAL_ALWAYS
    BOTH_ALWAYS = _fltk.Fl_Scroll_BOTH_ALWAYS

    def xposition(self, *args) -> "int":
        """xposition(Fl_Scroll self) -> int"""
        return _fltk.Fl_Scroll_xposition(self, *args)


    def yposition(self, *args) -> "int":
        """yposition(Fl_Scroll self) -> int"""
        return _fltk.Fl_Scroll_yposition(self, *args)


    def scroll_to(self, *args) -> "void":
        """scroll_to(Fl_Scroll self, int arg2, int arg3)"""
        return _fltk.Fl_Scroll_scroll_to(self, *args)


    def clear(self, *args) -> "void":
        """clear(Fl_Scroll self)"""
        return _fltk.Fl_Scroll_clear(self, *args)


    def scrollbar_size(self, *args) -> "void":
        """
        scrollbar_size(Fl_Scroll self) -> int
        scrollbar_size(Fl_Scroll self, int newSize)
        """
        return _fltk.Fl_Scroll_scrollbar_size(self, *args)


    def getScrollbar(self, *args) -> "Fl_Scrollbar *":
        """getScrollbar(Fl_Scroll self) -> Fl_Scrollbar"""
        return _fltk.Fl_Scroll_getScrollbar(self, *args)


    def getHScrollbar(self, *args) -> "Fl_Scrollbar *":
        """getHScrollbar(Fl_Scroll self) -> Fl_Scrollbar"""
        return _fltk.Fl_Scroll_getHScrollbar(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Scroll
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Scroll(self)
        return weakref_proxy(self)
Fl_Scroll_swigregister = _fltk.Fl_Scroll_swigregister
Fl_Scroll_swigregister(Fl_Scroll)

class Fl_Scrollbar(Fl_Slider):
    """

    The Fl_Scrollbar widget displays a slider with arrow buttons at the ends 
    of the scrollbar. Clicking on the arrows move up/left and down/right by 
    linesize(). Scrollbars also accept FL_SHORTCUT events: the arrows move by 
    linesize(), and vertical scrollbars take Page Up/Down (they move by the 
    page size minus linesize()) and Home/End (they jump to the top or bottom).

    Scrollbars have step(1) preset (they always return integers). If desired 
    you can set the step() to non-integer values. You will then have to use 
    casts to get at the floating-point versions of value() from Fl_Slider. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Scrollbar self)"""
        return _fltk.Fl_Scrollbar_draw(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Scrollbar self, int X, int Y, int W, int H, char const * L=None) -> Fl_Scrollbar"""
        if self.__class__ == Fl_Scrollbar:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Scrollbar(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Scrollbar
    __del__ = lambda self: None

    def handle(self, *args) -> "int":
        """handle(Fl_Scrollbar self, int arg0) -> int"""
        return _fltk.Fl_Scrollbar_handle(self, *args)


    def value(self, *args) -> "int":
        """
        value(Fl_Scrollbar self) -> int
        value(Fl_Scrollbar self, int p) -> int
        value(Fl_Scrollbar self, int pos, int windowSize, int first, int total) -> int
        """
        return _fltk.Fl_Scrollbar_value(self, *args)


    def linesize(self, *args) -> "void":
        """
        linesize(Fl_Scrollbar self) -> int
        linesize(Fl_Scrollbar self, int i)
        """
        return _fltk.Fl_Scrollbar_linesize(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Scrollbar(self)
        return weakref_proxy(self)
Fl_Scrollbar_swigregister = _fltk.Fl_Scrollbar_swigregister
Fl_Scrollbar_swigregister(Fl_Scrollbar)

class Fl_Secret_Input(Fl_Input):
    """

    The Fl_Secret_Input class is a subclass of Fl_Input  that displays its input 
    as a string of asterisks. This subclass is usually used to receive passwords 
    and other 'secret' information.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Secret_Input self, int X, int Y, int W, int H, char const * l=None) -> Fl_Secret_Input"""
        if self.__class__ == Fl_Secret_Input:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Secret_Input(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def handle(self, *args) -> "int":
        """handle(Fl_Secret_Input self, int arg0) -> int"""
        return _fltk.Fl_Secret_Input_handle(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Secret_Input
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Secret_Input(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Secret_Input self)"""
        return _fltk.Fl_Secret_Input_draw(self, *args)

Fl_Secret_Input_swigregister = _fltk.Fl_Secret_Input_swigregister
Fl_Secret_Input_swigregister(Fl_Secret_Input)

class Fl_Select_Browser(Fl_Browser):
    """

    The Fl_Select_Browser class is a subclass of Fl_Browser  which lets the 
    user select a single item, or no items by clicking on the empty space. As 
    long as the mouse button is held down the item pointed to by it is 
    highlighted. Normally the callback is done when the user presses the mouse, 
    but you can change this with when().

    See Fl_Browser for methods to add and remove lines from the browser. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Select_Browser self, int X, int Y, int W, int H, char const * L=None) -> Fl_Select_Browser"""
        if self.__class__ == Fl_Select_Browser:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Select_Browser(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Select_Browser
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Select_Browser(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Select_Browser self)"""
        return _fltk.Fl_Select_Browser_draw(self, *args)


    def item_first(self, *args) -> "void *":
        """item_first(Fl_Select_Browser self) -> void *"""
        return _fltk.Fl_Select_Browser_item_first(self, *args)


    def item_next(self, *args) -> "void *":
        """item_next(Fl_Select_Browser self, void * item) -> void *"""
        return _fltk.Fl_Select_Browser_item_next(self, *args)


    def item_prev(self, *args) -> "void *":
        """item_prev(Fl_Select_Browser self, void * item) -> void *"""
        return _fltk.Fl_Select_Browser_item_prev(self, *args)


    def item_last(self, *args) -> "void *":
        """item_last(Fl_Select_Browser self) -> void *"""
        return _fltk.Fl_Select_Browser_item_last(self, *args)


    def item_height(self, *args) -> "int":
        """item_height(Fl_Select_Browser self, void * item) -> int"""
        return _fltk.Fl_Select_Browser_item_height(self, *args)


    def item_width(self, *args) -> "int":
        """item_width(Fl_Select_Browser self, void * item) -> int"""
        return _fltk.Fl_Select_Browser_item_width(self, *args)


    def item_quick_height(self, *args) -> "int":
        """item_quick_height(Fl_Select_Browser self, void * item) -> int"""
        return _fltk.Fl_Select_Browser_item_quick_height(self, *args)


    def item_draw(self, *args) -> "void":
        """item_draw(Fl_Select_Browser self, void * item, int X, int Y, int W, int H)"""
        return _fltk.Fl_Select_Browser_item_draw(self, *args)


    def item_text(self, *args) -> "char const *":
        """item_text(Fl_Select_Browser self, void * item) -> char const *"""
        return _fltk.Fl_Select_Browser_item_text(self, *args)


    def item_swap(self, *args) -> "void":
        """item_swap(Fl_Select_Browser self, void * a, void * b)"""
        return _fltk.Fl_Select_Browser_item_swap(self, *args)


    def item_at(self, *args) -> "void *":
        """item_at(Fl_Select_Browser self, int line) -> void *"""
        return _fltk.Fl_Select_Browser_item_at(self, *args)


    def full_width(self, *args) -> "int":
        """full_width(Fl_Select_Browser self) -> int"""
        return _fltk.Fl_Select_Browser_full_width(self, *args)


    def full_height(self, *args) -> "int":
        """full_height(Fl_Select_Browser self) -> int"""
        return _fltk.Fl_Select_Browser_full_height(self, *args)


    def incr_height(self, *args) -> "int":
        """incr_height(Fl_Select_Browser self) -> int"""
        return _fltk.Fl_Select_Browser_incr_height(self, *args)


    def item_select(self, *args) -> "void":
        """item_select(Fl_Select_Browser self, void * item, int val)"""
        return _fltk.Fl_Select_Browser_item_select(self, *args)


    def item_selected(self, *args) -> "int":
        """item_selected(Fl_Select_Browser self, void * item) -> int"""
        return _fltk.Fl_Select_Browser_item_selected(self, *args)

Fl_Select_Browser_swigregister = _fltk.Fl_Select_Browser_swigregister
Fl_Select_Browser_swigregister(Fl_Select_Browser)

class Fl_Shared_Image(Fl_Image):
    """

    The Fl_Shared_Image class supports caching, loading, and drawing of image 
    files. Most applications will also want to link against the fltk_images 
    library and call the fl_register_images() function to support standard image 
    formats such as BMP, GIF, JPEG, and PNG.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Fl_Shared_Image self) -> Fl_Shared_Image
        __init__(Fl_Shared_Image self, char const * n, Fl_Image img=None) -> Fl_Shared_Image
        """
        if self.__class__ == Fl_Shared_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Shared_Image(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def name(self, *args) -> "char const *":
        """name(Fl_Shared_Image self) -> char const *"""
        return _fltk.Fl_Shared_Image_name(self, *args)


    def refcount(self, *args) -> "int":
        """refcount(Fl_Shared_Image self) -> int"""
        return _fltk.Fl_Shared_Image_refcount(self, *args)


    def original(self, *args) -> "int":
        """original(Fl_Shared_Image self) -> int"""
        return _fltk.Fl_Shared_Image_original(self, *args)


    def release(self, *args) -> "void":
        """release(Fl_Shared_Image self)"""
        return _fltk.Fl_Shared_Image_release(self, *args)


    def reload(self, *args) -> "void":
        """reload(Fl_Shared_Image self)"""
        return _fltk.Fl_Shared_Image_reload(self, *args)


    def copy(self, *args) -> "Fl_Image *":
        """
        copy(Fl_Shared_Image self, int W, int H) -> Fl_Image
        copy(Fl_Shared_Image self) -> Fl_Image
        """
        return _fltk.Fl_Shared_Image_copy(self, *args)


    def color_average(self, *args) -> "void":
        """color_average(Fl_Shared_Image self, Fl_Color c, float i)"""
        return _fltk.Fl_Shared_Image_color_average(self, *args)


    def desaturate(self, *args) -> "void":
        """desaturate(Fl_Shared_Image self)"""
        return _fltk.Fl_Shared_Image_desaturate(self, *args)


    def draw(self, *args) -> "void":
        """
        draw(Fl_Shared_Image self, int X, int Y, int W, int H, int cx, int cy)
        draw(Fl_Shared_Image self, int X, int Y)
        """
        return _fltk.Fl_Shared_Image_draw(self, *args)


    def scale(self, *args) -> "void":
        """scale(Fl_Shared_Image self, int width, int height, int proportional=1, int can_expand=0)"""
        return _fltk.Fl_Shared_Image_scale(self, *args)


    def uncache(self, *args) -> "void":
        """uncache(Fl_Shared_Image self)"""
        return _fltk.Fl_Shared_Image_uncache(self, *args)


    def find(*args) -> "Fl_Shared_Image *":
        """find(char const * name, int W=0, int H=0) -> Fl_Shared_Image"""
        return _fltk.Fl_Shared_Image_find(*args)

    find = staticmethod(find)

    def get(*args) -> "Fl_Shared_Image *":
        """
        get(char const * name, int W=0, int H=0) -> Fl_Shared_Image
        get(Fl_RGB_Image rgb, int own_it=1) -> Fl_Shared_Image
        """
        return _fltk.Fl_Shared_Image_get(*args)

    get = staticmethod(get)

    def images(*args) -> "Fl_Shared_Image **":
        """images() -> Fl_Shared_Image **"""
        return _fltk.Fl_Shared_Image_images(*args)

    images = staticmethod(images)

    def num_images(*args) -> "int":
        """num_images() -> int"""
        return _fltk.Fl_Shared_Image_num_images(*args)

    num_images = staticmethod(num_images)

    def add_handler(*args) -> "void":
        """add_handler(Fl_Shared_Handler f)"""
        return _fltk.Fl_Shared_Image_add_handler(*args)

    add_handler = staticmethod(add_handler)

    def remove_handler(*args) -> "void":
        """remove_handler(Fl_Shared_Handler f)"""
        return _fltk.Fl_Shared_Image_remove_handler(*args)

    remove_handler = staticmethod(remove_handler)

    def scaling_algorithm(*args) -> "void":
        """scaling_algorithm(Fl_RGB_Scaling algorithm)"""
        return _fltk.Fl_Shared_Image_scaling_algorithm(*args)

    scaling_algorithm = staticmethod(scaling_algorithm)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Shared_Image(self)
        return weakref_proxy(self)
Fl_Shared_Image_swigregister = _fltk.Fl_Shared_Image_swigregister
Fl_Shared_Image_swigregister(Fl_Shared_Image)

def Fl_Shared_Image_find(*args) -> "Fl_Shared_Image *":
    """Fl_Shared_Image_find(char const * name, int W=0, int H=0) -> Fl_Shared_Image"""
    return _fltk.Fl_Shared_Image_find(*args)

def Fl_Shared_Image_get(*args) -> "Fl_Shared_Image *":
    """
    get(char const * name, int W=0, int H=0) -> Fl_Shared_Image
    Fl_Shared_Image_get(Fl_RGB_Image rgb, int own_it=1) -> Fl_Shared_Image
    """
    return _fltk.Fl_Shared_Image_get(*args)

def Fl_Shared_Image_images(*args) -> "Fl_Shared_Image **":
    """Fl_Shared_Image_images() -> Fl_Shared_Image **"""
    return _fltk.Fl_Shared_Image_images(*args)

def Fl_Shared_Image_num_images(*args) -> "int":
    """Fl_Shared_Image_num_images() -> int"""
    return _fltk.Fl_Shared_Image_num_images(*args)

def Fl_Shared_Image_add_handler(*args) -> "void":
    """Fl_Shared_Image_add_handler(Fl_Shared_Handler f)"""
    return _fltk.Fl_Shared_Image_add_handler(*args)

def Fl_Shared_Image_remove_handler(*args) -> "void":
    """Fl_Shared_Image_remove_handler(Fl_Shared_Handler f)"""
    return _fltk.Fl_Shared_Image_remove_handler(*args)

def Fl_Shared_Image_scaling_algorithm(*args) -> "void":
    """Fl_Shared_Image_scaling_algorithm(Fl_RGB_Scaling algorithm)"""
    return _fltk.Fl_Shared_Image_scaling_algorithm(*args)


def fl_register_images(*args) -> "void":
    """fl_register_images()"""
    return _fltk.fl_register_images(*args)
class Fl_Spinner(Fl_Group):
    """

    The Fl_Spinner widget is a combination of the input widget and repeat 
    buttons. The user can either type into the input area or use the buttons 
    to change the value.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Spinner self, int X, int Y, int W, int H, char const * L=None) -> Fl_Spinner"""
        if self.__class__ == Fl_Spinner:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Spinner(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def format(self, *args) -> "void":
        """
        format(Fl_Spinner self) -> char const
        format(Fl_Spinner self, char const * f)
        """
        return _fltk.Fl_Spinner_format(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Spinner self, int event) -> int"""
        return _fltk.Fl_Spinner_handle(self, *args)


    def maxinum(self, *args) -> "double":
        """maxinum(Fl_Spinner self) -> double"""
        return _fltk.Fl_Spinner_maxinum(self, *args)


    def mininum(self, *args) -> "double":
        """mininum(Fl_Spinner self) -> double"""
        return _fltk.Fl_Spinner_mininum(self, *args)


    def range(self, *args) -> "void":
        """range(Fl_Spinner self, double a, double b)"""
        return _fltk.Fl_Spinner_range(self, *args)


    def resize(self, *args) -> "void":
        """resize(Fl_Spinner self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Spinner_resize(self, *args)


    def step(self, *args) -> "void":
        """
        step(Fl_Spinner self) -> double
        step(Fl_Spinner self, double s)
        """
        return _fltk.Fl_Spinner_step(self, *args)


    def textcolor(self, *args) -> "void":
        """
        textcolor(Fl_Spinner self) -> Fl_Color
        textcolor(Fl_Spinner self, Fl_Color c)
        """
        return _fltk.Fl_Spinner_textcolor(self, *args)


    def textfont(self, *args) -> "void":
        """
        textfont(Fl_Spinner self) -> Fl_Font
        textfont(Fl_Spinner self, Fl_Font f)
        """
        return _fltk.Fl_Spinner_textfont(self, *args)


    def textsize(self, *args) -> "void":
        """
        textsize(Fl_Spinner self) -> Fl_Fontsize
        textsize(Fl_Spinner self, Fl_Fontsize s)
        """
        return _fltk.Fl_Spinner_textsize(self, *args)


    def type(self, *args) -> "void":
        """
        type(Fl_Spinner self) -> uchar
        type(Fl_Spinner self, uchar v)
        """
        return _fltk.Fl_Spinner_type(self, *args)


    def value(self, *args) -> "void":
        """
        value(Fl_Spinner self) -> double
        value(Fl_Spinner self, double v)
        """
        return _fltk.Fl_Spinner_value(self, *args)


    def color(self, *args) -> "Fl_Color":
        """
        color(Fl_Spinner self, Fl_Color v)
        color(Fl_Spinner self) -> Fl_Color
        """
        return _fltk.Fl_Spinner_color(self, *args)


    def selection_color(self, *args) -> "Fl_Color":
        """
        selection_color(Fl_Spinner self, Fl_Color val)
        selection_color(Fl_Spinner self) -> Fl_Color
        """
        return _fltk.Fl_Spinner_selection_color(self, *args)


    def minimum(self, *args) -> "double":
        """
        minimum(Fl_Spinner self, double m)
        minimum(Fl_Spinner self) -> double
        """
        return _fltk.Fl_Spinner_minimum(self, *args)


    def maximum(self, *args) -> "double":
        """
        maximum(Fl_Spinner self, double m)
        maximum(Fl_Spinner self) -> double
        """
        return _fltk.Fl_Spinner_maximum(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Spinner
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Spinner(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Spinner self)"""
        return _fltk.Fl_Spinner_draw(self, *args)

Fl_Spinner_swigregister = _fltk.Fl_Spinner_swigregister
Fl_Spinner_swigregister(Fl_Spinner)


def fl_show_colormap(*args) -> "Fl_Color":
    """fl_show_colormap(Fl_Color oldcol) -> Fl_Color"""
    return _fltk.fl_show_colormap(*args)
class Fl_Simple_Counter(Fl_Counter):
    """Proxy of C++ Fl_Simple_Counter class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Simple_Counter self, int X, int Y, int W, int H, char const * L=None) -> Fl_Simple_Counter"""
        if self.__class__ == Fl_Simple_Counter:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Simple_Counter(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Simple_Counter
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Simple_Counter(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Simple_Counter self)"""
        return _fltk.Fl_Simple_Counter_draw(self, *args)

Fl_Simple_Counter_swigregister = _fltk.Fl_Simple_Counter_swigregister
Fl_Simple_Counter_swigregister(Fl_Simple_Counter)

class Fl_Tabs(Fl_Group):
    """

    The Fl_Tabs widget is the 'file card tabs' interface that allows you to 
    put lots and lots of buttons and switches in a panel, as popularized by 
    many toolkits.

    Clicking the tab makes a child visible() by calling show() on it, and 
    all other children are made invisible by calling hide() on them. Usually 
    the children are Fl_Group widgets containing several widgets themselves.

    Each child makes a card, and it's label() is printed on the card tab, 
    including the label font and style. The selection color of that child 
    is used to color the tab, while the color of the child determines the 
    background color of the pane.

    The size of the tabs is controlled by the bounding box of the children 
    (there should be some space between the children and the edge of the Fl_Tabs), 
    and the tabs may be placed 'inverted' on the bottom, this is determined 
    by which gap is larger. It is easiest to lay this out in fluid, using the 
    fluid browser to select each child group and resize them until the tabs 
    look the way you want them to. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Tabs self)"""
        return _fltk.Fl_Tabs_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Tabs self, int arg0) -> int"""
        return _fltk.Fl_Tabs_handle(self, *args)


    def value(self, *args) -> "int":
        """
        value(Fl_Tabs self) -> Fl_Widget
        value(Fl_Tabs self, Fl_Widget arg2) -> int
        """
        return _fltk.Fl_Tabs_value(self, *args)


    def push(self, *args) -> "int":
        """
        push(Fl_Tabs self) -> Fl_Widget
        push(Fl_Tabs self, Fl_Widget arg2) -> int
        """
        return _fltk.Fl_Tabs_push(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Tabs self, int arg2, int arg3, int arg4, int arg5, char const * arg6=None) -> Fl_Tabs"""
        if self.__class__ == Fl_Tabs:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Tabs(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def which(self, *args) -> "Fl_Widget *":
        """which(Fl_Tabs self, int event_x, int event_y) -> Fl_Widget"""
        return _fltk.Fl_Tabs_which(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Tabs
    __del__ = lambda self: None

    def client_area(self, *args) -> "void":
        """client_area(Fl_Tabs self, int tabh=0)"""
        return _fltk.Fl_Tabs_client_area(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Tabs(self)
        return weakref_proxy(self)
Fl_Tabs_swigregister = _fltk.Fl_Tabs_swigregister
Fl_Tabs_swigregister(Fl_Tabs)

FL_TEXT_MAX_EXP_CHAR_LEN = _fltk.FL_TEXT_MAX_EXP_CHAR_LEN
class Fl_Text_Selection(object):
    """Proxy of C++ Fl_Text_Selection class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def set(self, *args) -> "void":
        """set(Fl_Text_Selection self, int start, int end)"""
        return _fltk.Fl_Text_Selection_set(self, *args)


    def update(self, *args) -> "void":
        """update(Fl_Text_Selection self, int pos, int nDeleted, int nInserted)"""
        return _fltk.Fl_Text_Selection_update(self, *args)


    def start(self, *args) -> "int":
        """start(Fl_Text_Selection self) -> int"""
        return _fltk.Fl_Text_Selection_start(self, *args)


    def end(self, *args) -> "int":
        """end(Fl_Text_Selection self) -> int"""
        return _fltk.Fl_Text_Selection_end(self, *args)


    def selected(self, *args) -> "void":
        """
        selected(Fl_Text_Selection self) -> bool
        selected(Fl_Text_Selection self, bool b)
        """
        return _fltk.Fl_Text_Selection_selected(self, *args)


    def includes(self, *args) -> "int":
        """includes(Fl_Text_Selection self, int pos) -> int"""
        return _fltk.Fl_Text_Selection_includes(self, *args)


    def position(self, *args) -> "int":
        """position(Fl_Text_Selection self, int * start, int * end) -> int"""
        return _fltk.Fl_Text_Selection_position(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Text_Selection self) -> Fl_Text_Selection"""
        this = _fltk.new_Fl_Text_Selection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Text_Selection
    __del__ = lambda self: None
Fl_Text_Selection_swigregister = _fltk.Fl_Text_Selection_swigregister
Fl_Text_Selection_swigregister(Fl_Text_Selection)

class Fl_Text_Buffer(object):
    """

    The Fl_Text_Buffer class is used by the Fl_Text_Display and Fl_Text_Editor 
    to manage complex text data and is based upon the excellent NEdit text 
    editor engine - see http://www.nedit.org/.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Text_Buffer self, int requestedSize=0, int preferredGapSize=1024) -> Fl_Text_Buffer"""
        this = _fltk.new_Fl_Text_Buffer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Text_Buffer
    __del__ = lambda self: None

    def length(self, *args) -> "int":
        """length(Fl_Text_Buffer self) -> int"""
        return _fltk.Fl_Text_Buffer_length(self, *args)


    def text(self, *args) -> "void":
        """
        text(Fl_Text_Buffer self) -> char
        text(Fl_Text_Buffer self, char const * text)
        """
        return _fltk.Fl_Text_Buffer_text(self, *args)


    def text_range(self, *args) -> "char *":
        """text_range(Fl_Text_Buffer self, int start, int end) -> char *"""
        return _fltk.Fl_Text_Buffer_text_range(self, *args)


    def char_at(self, *args) -> "unsigned int":
        """char_at(Fl_Text_Buffer self, int pos) -> unsigned int"""
        return _fltk.Fl_Text_Buffer_char_at(self, *args)


    def byte_at(self, *args) -> "char":
        """byte_at(Fl_Text_Buffer self, int pos) -> char"""
        return _fltk.Fl_Text_Buffer_byte_at(self, *args)


    def address(self, *args) -> "char *":
        """
        address(Fl_Text_Buffer self, int pos) -> char const
        address(Fl_Text_Buffer self, int pos) -> char *
        """
        return _fltk.Fl_Text_Buffer_address(self, *args)


    def insert(self, *args) -> "void":
        """insert(Fl_Text_Buffer self, int pos, char const * text)"""
        return _fltk.Fl_Text_Buffer_insert(self, *args)


    def append(self, *args) -> "void":
        """append(Fl_Text_Buffer self, char const * t)"""
        return _fltk.Fl_Text_Buffer_append(self, *args)


    def remove(self, *args) -> "void":
        """remove(Fl_Text_Buffer self, int start, int end)"""
        return _fltk.Fl_Text_Buffer_remove(self, *args)


    def replace(self, *args) -> "void":
        """replace(Fl_Text_Buffer self, int start, int end, char const * text)"""
        return _fltk.Fl_Text_Buffer_replace(self, *args)


    def copy(self, *args) -> "void":
        """copy(Fl_Text_Buffer self, Fl_Text_Buffer fromBuf, int fromStart, int fromEnd, int toPos)"""
        return _fltk.Fl_Text_Buffer_copy(self, *args)


    def undo(self, *args) -> "int":
        """undo(Fl_Text_Buffer self, int * cp=None) -> int"""
        return _fltk.Fl_Text_Buffer_undo(self, *args)


    def canUndo(self, *args) -> "void":
        """canUndo(Fl_Text_Buffer self, char flag=1)"""
        return _fltk.Fl_Text_Buffer_canUndo(self, *args)


    def insertfile(self, *args) -> "int":
        """insertfile(Fl_Text_Buffer self, char const * file, int pos, int buflen=128) -> int"""
        return _fltk.Fl_Text_Buffer_insertfile(self, *args)


    def appendfile(self, *args) -> "int":
        """appendfile(Fl_Text_Buffer self, char const * file, int buflen=128) -> int"""
        return _fltk.Fl_Text_Buffer_appendfile(self, *args)


    def loadfile(self, *args) -> "int":
        """loadfile(Fl_Text_Buffer self, char const * file, int buflen=128) -> int"""
        return _fltk.Fl_Text_Buffer_loadfile(self, *args)


    def outputfile(self, *args) -> "int":
        """outputfile(Fl_Text_Buffer self, char const * file, int start, int end, int buflen=128) -> int"""
        return _fltk.Fl_Text_Buffer_outputfile(self, *args)


    def savefile(self, *args) -> "int":
        """savefile(Fl_Text_Buffer self, char const * file, int buflen=128) -> int"""
        return _fltk.Fl_Text_Buffer_savefile(self, *args)


    def tab_distance(self, *args) -> "void":
        """
        tab_distance(Fl_Text_Buffer self) -> int
        tab_distance(Fl_Text_Buffer self, int tabDist)
        """
        return _fltk.Fl_Text_Buffer_tab_distance(self, *args)


    def select(self, *args) -> "void":
        """select(Fl_Text_Buffer self, int start, int end)"""
        return _fltk.Fl_Text_Buffer_select(self, *args)


    def selected(self, *args) -> "int":
        """selected(Fl_Text_Buffer self) -> int"""
        return _fltk.Fl_Text_Buffer_selected(self, *args)


    def unselect(self, *args) -> "void":
        """unselect(Fl_Text_Buffer self)"""
        return _fltk.Fl_Text_Buffer_unselect(self, *args)


    def selection_position(self, *args) -> "int":
        """selection_position(Fl_Text_Buffer self, int * start, int * end) -> int"""
        return _fltk.Fl_Text_Buffer_selection_position(self, *args)


    def selection_text(self, *args) -> "char *":
        """selection_text(Fl_Text_Buffer self) -> char *"""
        return _fltk.Fl_Text_Buffer_selection_text(self, *args)


    def remove_selection(self, *args) -> "void":
        """remove_selection(Fl_Text_Buffer self)"""
        return _fltk.Fl_Text_Buffer_remove_selection(self, *args)


    def replace_selection(self, *args) -> "void":
        """replace_selection(Fl_Text_Buffer self, char const * text)"""
        return _fltk.Fl_Text_Buffer_replace_selection(self, *args)


    def secondary_select(self, *args) -> "void":
        """secondary_select(Fl_Text_Buffer self, int start, int end)"""
        return _fltk.Fl_Text_Buffer_secondary_select(self, *args)


    def secondary_selected(self, *args) -> "int":
        """secondary_selected(Fl_Text_Buffer self) -> int"""
        return _fltk.Fl_Text_Buffer_secondary_selected(self, *args)


    def secondary_unselect(self, *args) -> "void":
        """secondary_unselect(Fl_Text_Buffer self)"""
        return _fltk.Fl_Text_Buffer_secondary_unselect(self, *args)


    def secondary_selection_position(self, *args) -> "int":
        """secondary_selection_position(Fl_Text_Buffer self, int * start, int * end) -> int"""
        return _fltk.Fl_Text_Buffer_secondary_selection_position(self, *args)


    def secondary_selection_text(self, *args) -> "char *":
        """secondary_selection_text(Fl_Text_Buffer self) -> char *"""
        return _fltk.Fl_Text_Buffer_secondary_selection_text(self, *args)


    def remove_secondary_selection(self, *args) -> "void":
        """remove_secondary_selection(Fl_Text_Buffer self)"""
        return _fltk.Fl_Text_Buffer_remove_secondary_selection(self, *args)


    def replace_secondary_selection(self, *args) -> "void":
        """replace_secondary_selection(Fl_Text_Buffer self, char const * text)"""
        return _fltk.Fl_Text_Buffer_replace_secondary_selection(self, *args)


    def highlight(self, *args) -> "int":
        """
        highlight(Fl_Text_Buffer self, int start, int end)
        highlight(Fl_Text_Buffer self) -> int
        """
        return _fltk.Fl_Text_Buffer_highlight(self, *args)


    def unhighlight(self, *args) -> "void":
        """unhighlight(Fl_Text_Buffer self)"""
        return _fltk.Fl_Text_Buffer_unhighlight(self, *args)


    def highlight_position(self, *args) -> "int":
        """highlight_position(Fl_Text_Buffer self, int * start, int * end) -> int"""
        return _fltk.Fl_Text_Buffer_highlight_position(self, *args)


    def highlight_text(self, *args) -> "char *":
        """highlight_text(Fl_Text_Buffer self) -> char *"""
        return _fltk.Fl_Text_Buffer_highlight_text(self, *args)


    def call_modify_callbacks(self, *args) -> "void":
        """call_modify_callbacks(Fl_Text_Buffer self)"""
        return _fltk.Fl_Text_Buffer_call_modify_callbacks(self, *args)


    def add_predelete_callback(self, *args) -> "void":
        """add_predelete_callback(Fl_Text_Buffer self, Fl_Text_Predelete_Cb bufPredelCB, void * cbArg)"""
        return _fltk.Fl_Text_Buffer_add_predelete_callback(self, *args)


    def remove_predelete_callback(self, *args) -> "void":
        """remove_predelete_callback(Fl_Text_Buffer self, Fl_Text_Predelete_Cb predelCB, void * cbArg)"""
        return _fltk.Fl_Text_Buffer_remove_predelete_callback(self, *args)


    def call_predelete_callbacks(self, *args) -> "void":
        """call_predelete_callbacks(Fl_Text_Buffer self)"""
        return _fltk.Fl_Text_Buffer_call_predelete_callbacks(self, *args)


    def line_text(self, *args) -> "char *":
        """line_text(Fl_Text_Buffer self, int pos) -> char *"""
        return _fltk.Fl_Text_Buffer_line_text(self, *args)


    def line_start(self, *args) -> "int":
        """line_start(Fl_Text_Buffer self, int pos) -> int"""
        return _fltk.Fl_Text_Buffer_line_start(self, *args)


    def line_end(self, *args) -> "int":
        """line_end(Fl_Text_Buffer self, int pos) -> int"""
        return _fltk.Fl_Text_Buffer_line_end(self, *args)


    def word_start(self, *args) -> "int":
        """word_start(Fl_Text_Buffer self, int pos) -> int"""
        return _fltk.Fl_Text_Buffer_word_start(self, *args)


    def word_end(self, *args) -> "int":
        """word_end(Fl_Text_Buffer self, int pos) -> int"""
        return _fltk.Fl_Text_Buffer_word_end(self, *args)


    def count_displayed_characters(self, *args) -> "int":
        """count_displayed_characters(Fl_Text_Buffer self, int lineStartPos, int targetPos) -> int"""
        return _fltk.Fl_Text_Buffer_count_displayed_characters(self, *args)


    def skip_displayed_characters(self, *args) -> "int":
        """skip_displayed_characters(Fl_Text_Buffer self, int lineStartPos, int nChars) -> int"""
        return _fltk.Fl_Text_Buffer_skip_displayed_characters(self, *args)


    def count_lines(self, *args) -> "int":
        """count_lines(Fl_Text_Buffer self, int startPos, int endPos) -> int"""
        return _fltk.Fl_Text_Buffer_count_lines(self, *args)


    def skip_lines(self, *args) -> "int":
        """skip_lines(Fl_Text_Buffer self, int startPos, int nLines) -> int"""
        return _fltk.Fl_Text_Buffer_skip_lines(self, *args)


    def rewind_lines(self, *args) -> "int":
        """rewind_lines(Fl_Text_Buffer self, int startPos, int nLines) -> int"""
        return _fltk.Fl_Text_Buffer_rewind_lines(self, *args)


    def findchar_forward(self, *args) -> "int":
        """findchar_forward(Fl_Text_Buffer self, int startPos, unsigned int searchChar) -> int"""
        return _fltk.Fl_Text_Buffer_findchar_forward(self, *args)


    def findchar_backward(self, *args) -> "int":
        """findchar_backward(Fl_Text_Buffer self, int startPos, unsigned int searchChar) -> int"""
        return _fltk.Fl_Text_Buffer_findchar_backward(self, *args)


    def search_forward(self, *args) -> "int":
        """search_forward(Fl_Text_Buffer self, int startPos, char const * searchString, int matchCase=0) -> int"""
        return _fltk.Fl_Text_Buffer_search_forward(self, *args)


    def search_backward(self, *args) -> "int":
        """search_backward(Fl_Text_Buffer self, int startPos, char const * searchString, int matchCase=0) -> int"""
        return _fltk.Fl_Text_Buffer_search_backward(self, *args)


    def primary_selection(self, *args) -> "Fl_Text_Selection *":
        """
        primary_selection(Fl_Text_Buffer self) -> Fl_Text_Selection
        primary_selection(Fl_Text_Buffer self) -> Fl_Text_Selection
        """
        return _fltk.Fl_Text_Buffer_primary_selection(self, *args)


    def secondary_selection(self, *args) -> "Fl_Text_Selection const *":
        """secondary_selection(Fl_Text_Buffer self) -> Fl_Text_Selection"""
        return _fltk.Fl_Text_Buffer_secondary_selection(self, *args)


    def highlight_selection(self, *args) -> "Fl_Text_Selection const *":
        """highlight_selection(Fl_Text_Buffer self) -> Fl_Text_Selection"""
        return _fltk.Fl_Text_Buffer_highlight_selection(self, *args)


    def prev_char(self, *args) -> "int":
        """prev_char(Fl_Text_Buffer self, int ix) -> int"""
        return _fltk.Fl_Text_Buffer_prev_char(self, *args)


    def prev_char_clipped(self, *args) -> "int":
        """prev_char_clipped(Fl_Text_Buffer self, int ix) -> int"""
        return _fltk.Fl_Text_Buffer_prev_char_clipped(self, *args)


    def next_char(self, *args) -> "int":
        """next_char(Fl_Text_Buffer self, int ix) -> int"""
        return _fltk.Fl_Text_Buffer_next_char(self, *args)


    def next_char_clipped(self, *args) -> "int":
        """next_char_clipped(Fl_Text_Buffer self, int ix) -> int"""
        return _fltk.Fl_Text_Buffer_next_char_clipped(self, *args)


    def utf8_align(self, *args) -> "int":
        """utf8_align(Fl_Text_Buffer self, int arg2) -> int"""
        return _fltk.Fl_Text_Buffer_utf8_align(self, *args)


    def add_modify_callback(self, *args) -> "void":
        """
        add_modify_callback(Fl_Text_Buffer self, Fl_Text_Modify_Cb bufModifiedCB, void * cbArg)
        add_modify_callback(Fl_Text_Buffer self, PyObject * PyFunc, PyObject * PyTarget=None)
        """
        return _fltk.Fl_Text_Buffer_add_modify_callback(self, *args)


    def remove_modify_callback(self, *args) -> "void":
        """
        remove_modify_callback(Fl_Text_Buffer self, Fl_Text_Modify_Cb bufModifiedCB, void * cbArg)
        remove_modify_callback(Fl_Text_Buffer self, PyObject * PyFunc, PyObject * PyWidget, PyObject * PyTarget)
        """
        return _fltk.Fl_Text_Buffer_remove_modify_callback(self, *args)

Fl_Text_Buffer_swigregister = _fltk.Fl_Text_Buffer_swigregister
Fl_Text_Buffer_swigregister(Fl_Text_Buffer)

class Style_Table_Entry(object):
    """Proxy of C++ Style_Table_Entry class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Style_Table_Entry self) -> Style_Table_Entry"""
        this = _fltk.new_Style_Table_Entry(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Style_Table_Entry
    __del__ = lambda self: None
Style_Table_Entry_swigregister = _fltk.Style_Table_Entry_swigregister
Style_Table_Entry_swigregister(Style_Table_Entry)

class Fl_Text_Display(Fl_Group):
    """

    This is the FLTK text display widget. It allows the user to view multiple 
    lines of text and supports highlighting and scrolling. The buffer that is 
    displayed in the widget is managed by the Fl_Text_Buffer class.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    NORMAL_CURSOR = _fltk.Fl_Text_Display_NORMAL_CURSOR
    CARET_CURSOR = _fltk.Fl_Text_Display_CARET_CURSOR
    DIM_CURSOR = _fltk.Fl_Text_Display_DIM_CURSOR
    BLOCK_CURSOR = _fltk.Fl_Text_Display_BLOCK_CURSOR
    HEAVY_CURSOR = _fltk.Fl_Text_Display_HEAVY_CURSOR
    SIMPLE_CURSOR = _fltk.Fl_Text_Display_SIMPLE_CURSOR
    CURSOR_POS = _fltk.Fl_Text_Display_CURSOR_POS
    CHARACTER_POS = _fltk.Fl_Text_Display_CHARACTER_POS
    DRAG_NONE = _fltk.Fl_Text_Display_DRAG_NONE
    DRAG_START_DND = _fltk.Fl_Text_Display_DRAG_START_DND
    DRAG_CHAR = _fltk.Fl_Text_Display_DRAG_CHAR
    DRAG_WORD = _fltk.Fl_Text_Display_DRAG_WORD
    DRAG_LINE = _fltk.Fl_Text_Display_DRAG_LINE
    WRAP_NONE = _fltk.Fl_Text_Display_WRAP_NONE
    WRAP_AT_COLUMN = _fltk.Fl_Text_Display_WRAP_AT_COLUMN
    WRAP_AT_PIXEL = _fltk.Fl_Text_Display_WRAP_AT_PIXEL
    WRAP_AT_BOUNDS = _fltk.Fl_Text_Display_WRAP_AT_BOUNDS

    def __init__(self, *args):
        """__init__(Fl_Text_Display self, int X, int Y, int W, int H, char const * l=None) -> Fl_Text_Display"""
        if self.__class__ == Fl_Text_Display:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Text_Display(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Text_Display
    __del__ = lambda self: None

    def handle(self, *args) -> "int":
        """handle(Fl_Text_Display self, int e) -> int"""
        return _fltk.Fl_Text_Display_handle(self, *args)


    def buffer(self, *args) -> "Fl_Text_Buffer *":
        """
        buffer(Fl_Text_Display self, Fl_Text_Buffer buf)
        buffer(Fl_Text_Display self) -> Fl_Text_Buffer
        """
        val = _fltk.Fl_Text_Display_buffer(self, *args)

        if len(args) > 0 and args[0] != None:
        #delegate ownership to C++
            args[0].this.disown()


        return val


    def redisplay_range(self, *args) -> "void":
        """redisplay_range(Fl_Text_Display self, int start, int end)"""
        return _fltk.Fl_Text_Display_redisplay_range(self, *args)


    def scroll(self, *args) -> "void":
        """scroll(Fl_Text_Display self, int topLineNum, int horizOffset)"""
        return _fltk.Fl_Text_Display_scroll(self, *args)


    def insert(self, *args) -> "void":
        """insert(Fl_Text_Display self, char const * text)"""
        return _fltk.Fl_Text_Display_insert(self, *args)


    def overstrike(self, *args) -> "void":
        """overstrike(Fl_Text_Display self, char const * text)"""
        return _fltk.Fl_Text_Display_overstrike(self, *args)


    def insert_position(self, *args) -> "int":
        """
        insert_position(Fl_Text_Display self, int newPos)
        insert_position(Fl_Text_Display self) -> int
        """
        return _fltk.Fl_Text_Display_insert_position(self, *args)


    def position_to_xy(self, *args) -> "int":
        """position_to_xy(Fl_Text_Display self, int pos, int * x, int * y) -> int"""
        return _fltk.Fl_Text_Display_position_to_xy(self, *args)


    def in_selection(self, *args) -> "int":
        """in_selection(Fl_Text_Display self, int x, int y) -> int"""
        return _fltk.Fl_Text_Display_in_selection(self, *args)


    def show_insert_position(self, *args) -> "void":
        """show_insert_position(Fl_Text_Display self)"""
        return _fltk.Fl_Text_Display_show_insert_position(self, *args)


    def move_right(self, *args) -> "int":
        """move_right(Fl_Text_Display self) -> int"""
        return _fltk.Fl_Text_Display_move_right(self, *args)


    def move_left(self, *args) -> "int":
        """move_left(Fl_Text_Display self) -> int"""
        return _fltk.Fl_Text_Display_move_left(self, *args)


    def move_up(self, *args) -> "int":
        """move_up(Fl_Text_Display self) -> int"""
        return _fltk.Fl_Text_Display_move_up(self, *args)


    def move_down(self, *args) -> "int":
        """move_down(Fl_Text_Display self) -> int"""
        return _fltk.Fl_Text_Display_move_down(self, *args)


    def count_lines(self, *args) -> "int":
        """count_lines(Fl_Text_Display self, int start, int end, bool start_pos_is_line_start) -> int"""
        return _fltk.Fl_Text_Display_count_lines(self, *args)


    def line_start(self, *args) -> "int":
        """line_start(Fl_Text_Display self, int pos) -> int"""
        return _fltk.Fl_Text_Display_line_start(self, *args)


    def line_end(self, *args) -> "int":
        """line_end(Fl_Text_Display self, int startPos, bool startPosIsLineStart) -> int"""
        return _fltk.Fl_Text_Display_line_end(self, *args)


    def skip_lines(self, *args) -> "int":
        """skip_lines(Fl_Text_Display self, int startPos, int nLines, bool startPosIsLineStart) -> int"""
        return _fltk.Fl_Text_Display_skip_lines(self, *args)


    def rewind_lines(self, *args) -> "int":
        """rewind_lines(Fl_Text_Display self, int startPos, int nLines) -> int"""
        return _fltk.Fl_Text_Display_rewind_lines(self, *args)


    def next_word(self, *args) -> "void":
        """next_word(Fl_Text_Display self)"""
        return _fltk.Fl_Text_Display_next_word(self, *args)


    def previous_word(self, *args) -> "void":
        """previous_word(Fl_Text_Display self)"""
        return _fltk.Fl_Text_Display_previous_word(self, *args)


    def show_cursor(self, *args) -> "void":
        """show_cursor(Fl_Text_Display self, int b=1)"""
        return _fltk.Fl_Text_Display_show_cursor(self, *args)


    def hide_cursor(self, *args) -> "void":
        """hide_cursor(Fl_Text_Display self)"""
        return _fltk.Fl_Text_Display_hide_cursor(self, *args)


    def cursor_style(self, *args) -> "void":
        """cursor_style(Fl_Text_Display self, int style)"""
        return _fltk.Fl_Text_Display_cursor_style(self, *args)


    def cursor_color(self, *args) -> "void":
        """
        cursor_color(Fl_Text_Display self) -> Fl_Color
        cursor_color(Fl_Text_Display self, Fl_Color n)
        """
        return _fltk.Fl_Text_Display_cursor_color(self, *args)


    def scrollbar_width(self, *args) -> "void":
        """
        scrollbar_width(Fl_Text_Display self) -> int
        scrollbar_width(Fl_Text_Display self, int W)
        """
        return _fltk.Fl_Text_Display_scrollbar_width(self, *args)


    def scrollbar_align(self, *args) -> "void":
        """
        scrollbar_align(Fl_Text_Display self) -> Fl_Align
        scrollbar_align(Fl_Text_Display self, Fl_Align a)
        """
        return _fltk.Fl_Text_Display_scrollbar_align(self, *args)


    def word_start(self, *args) -> "int":
        """word_start(Fl_Text_Display self, int pos) -> int"""
        return _fltk.Fl_Text_Display_word_start(self, *args)


    def word_end(self, *args) -> "int":
        """word_end(Fl_Text_Display self, int pos) -> int"""
        return _fltk.Fl_Text_Display_word_end(self, *args)


    def position_style(self, *args) -> "int":
        """position_style(Fl_Text_Display self, int lineStartPos, int lineLen, int lineIndex) -> int"""
        return _fltk.Fl_Text_Display_position_style(self, *args)


    def shortcut(self, *args) -> "void":
        """
        shortcut(Fl_Text_Display self) -> int
        shortcut(Fl_Text_Display self, int s)
        """
        return _fltk.Fl_Text_Display_shortcut(self, *args)


    def textfont(self, *args) -> "void":
        """
        textfont(Fl_Text_Display self) -> Fl_Font
        textfont(Fl_Text_Display self, Fl_Font s)
        """
        return _fltk.Fl_Text_Display_textfont(self, *args)


    def textsize(self, *args) -> "void":
        """
        textsize(Fl_Text_Display self) -> Fl_Fontsize
        textsize(Fl_Text_Display self, Fl_Fontsize s)
        """
        return _fltk.Fl_Text_Display_textsize(self, *args)


    def textcolor(self, *args) -> "void":
        """
        textcolor(Fl_Text_Display self) -> Fl_Color
        textcolor(Fl_Text_Display self, Fl_Color n)
        """
        return _fltk.Fl_Text_Display_textcolor(self, *args)


    def wrapped_column(self, *args) -> "int":
        """wrapped_column(Fl_Text_Display self, int row, int column) -> int"""
        return _fltk.Fl_Text_Display_wrapped_column(self, *args)


    def wrapped_row(self, *args) -> "int":
        """wrapped_row(Fl_Text_Display self, int row) -> int"""
        return _fltk.Fl_Text_Display_wrapped_row(self, *args)


    def wrap_mode(self, *args) -> "void":
        """wrap_mode(Fl_Text_Display self, int wrap, int wrap_margin)"""
        return _fltk.Fl_Text_Display_wrap_mode(self, *args)


    def resize(self, *args) -> "void":
        """resize(Fl_Text_Display self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Text_Display_resize(self, *args)


    def x_to_col(self, *args) -> "double":
        """x_to_col(Fl_Text_Display self, double x) -> double"""
        return _fltk.Fl_Text_Display_x_to_col(self, *args)


    def col_to_x(self, *args) -> "double":
        """col_to_x(Fl_Text_Display self, double col) -> double"""
        return _fltk.Fl_Text_Display_col_to_x(self, *args)


    def linenumber_width(self, *args) -> "int":
        """
        linenumber_width(Fl_Text_Display self, int width)
        linenumber_width(Fl_Text_Display self) -> int
        """
        return _fltk.Fl_Text_Display_linenumber_width(self, *args)


    def linenumber_font(self, *args) -> "Fl_Font":
        """
        linenumber_font(Fl_Text_Display self, Fl_Font val)
        linenumber_font(Fl_Text_Display self) -> Fl_Font
        """
        return _fltk.Fl_Text_Display_linenumber_font(self, *args)


    def linenumber_size(self, *args) -> "Fl_Fontsize":
        """
        linenumber_size(Fl_Text_Display self, Fl_Fontsize val)
        linenumber_size(Fl_Text_Display self) -> Fl_Fontsize
        """
        return _fltk.Fl_Text_Display_linenumber_size(self, *args)


    def linenumber_fgcolor(self, *args) -> "Fl_Color":
        """
        linenumber_fgcolor(Fl_Text_Display self, Fl_Color val)
        linenumber_fgcolor(Fl_Text_Display self) -> Fl_Color
        """
        return _fltk.Fl_Text_Display_linenumber_fgcolor(self, *args)


    def linenumber_bgcolor(self, *args) -> "Fl_Color":
        """
        linenumber_bgcolor(Fl_Text_Display self, Fl_Color val)
        linenumber_bgcolor(Fl_Text_Display self) -> Fl_Color
        """
        return _fltk.Fl_Text_Display_linenumber_bgcolor(self, *args)


    def linenumber_align(self, *args) -> "Fl_Align":
        """
        linenumber_align(Fl_Text_Display self, Fl_Align val)
        linenumber_align(Fl_Text_Display self) -> Fl_Align
        """
        return _fltk.Fl_Text_Display_linenumber_align(self, *args)


    def linenumber_format(self, *args) -> "char const *":
        """
        linenumber_format(Fl_Text_Display self, char const * val)
        linenumber_format(Fl_Text_Display self) -> char const *
        """
        return _fltk.Fl_Text_Display_linenumber_format(self, *args)


    def draw(self, *args) -> "void":
        """draw(Fl_Text_Display self)"""
        return _fltk.Fl_Text_Display_draw(self, *args)


    def highlight_data(self, *args) -> "void":
        """highlight_data(Fl_Text_Display self, Fl_Text_Buffer styleBuffer, Fl_Text_Display::Style_Table_Entry const * styleTable, int nStyles, char unfinishedStyle, PyObject * func, PyObject * cbArg)"""
        return _fltk.Fl_Text_Display_highlight_data(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Text_Display(self)
        return weakref_proxy(self)
Fl_Text_Display_swigregister = _fltk.Fl_Text_Display_swigregister
Fl_Text_Display_swigregister(Fl_Text_Display)

FL_TEXT_EDITOR_ANY_STATE = _fltk.FL_TEXT_EDITOR_ANY_STATE
class Fl_Text_Editor(Fl_Text_Display):
    """

    This is the FLTK text editor widget. It allows the user to edit multiple 
    lines of text and supports highlighting and scrolling. The buffer that is 
    displayed in the widget is managed by the Fl_Text_Buffer class.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Text_Editor self, int X, int Y, int W, int H, char const * l=None) -> Fl_Text_Editor"""
        if self.__class__ == Fl_Text_Editor:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Text_Editor(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Text_Editor
    __del__ = lambda self: None

    def handle(self, *args) -> "int":
        """handle(Fl_Text_Editor self, int e) -> int"""
        return _fltk.Fl_Text_Editor_handle(self, *args)


    def insert_mode(self, *args) -> "int":
        """
        insert_mode(Fl_Text_Editor self, int b)
        insert_mode(Fl_Text_Editor self) -> int
        """
        return _fltk.Fl_Text_Editor_insert_mode(self, *args)


    def add_key_binding(self, *args) -> "void":
        """add_key_binding(Fl_Text_Editor self, int key, int state, Fl_Text_Editor::Key_Func f)"""
        return _fltk.Fl_Text_Editor_add_key_binding(self, *args)


    def remove_key_binding(self, *args) -> "void":
        """remove_key_binding(Fl_Text_Editor self, int key, int state)"""
        return _fltk.Fl_Text_Editor_remove_key_binding(self, *args)


    def remove_all_key_bindings(self, *args) -> "void":
        """remove_all_key_bindings(Fl_Text_Editor self)"""
        return _fltk.Fl_Text_Editor_remove_all_key_bindings(self, *args)


    def bound_key_function(self, *args) -> "Fl_Text_Editor::Key_Func":
        """bound_key_function(Fl_Text_Editor self, int key, int state) -> Fl_Text_Editor::Key_Func"""
        return _fltk.Fl_Text_Editor_bound_key_function(self, *args)


    def default_key_function(self, *args) -> "void":
        """default_key_function(Fl_Text_Editor self, Fl_Text_Editor::Key_Func f)"""
        return _fltk.Fl_Text_Editor_default_key_function(self, *args)


    def kf_default(*args) -> "int":
        """kf_default(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_default(*args)

    kf_default = staticmethod(kf_default)

    def kf_ignore(*args) -> "int":
        """kf_ignore(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_ignore(*args)

    kf_ignore = staticmethod(kf_ignore)

    def kf_backspace(*args) -> "int":
        """kf_backspace(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_backspace(*args)

    kf_backspace = staticmethod(kf_backspace)

    def kf_enter(*args) -> "int":
        """kf_enter(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_enter(*args)

    kf_enter = staticmethod(kf_enter)

    def kf_move(*args) -> "int":
        """kf_move(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_move(*args)

    kf_move = staticmethod(kf_move)

    def kf_shift_move(*args) -> "int":
        """kf_shift_move(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_shift_move(*args)

    kf_shift_move = staticmethod(kf_shift_move)

    def kf_ctrl_move(*args) -> "int":
        """kf_ctrl_move(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_ctrl_move(*args)

    kf_ctrl_move = staticmethod(kf_ctrl_move)

    def kf_c_s_move(*args) -> "int":
        """kf_c_s_move(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_c_s_move(*args)

    kf_c_s_move = staticmethod(kf_c_s_move)

    def kf_meta_move(*args) -> "int":
        """kf_meta_move(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_meta_move(*args)

    kf_meta_move = staticmethod(kf_meta_move)

    def kf_m_s_move(*args) -> "int":
        """kf_m_s_move(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_m_s_move(*args)

    kf_m_s_move = staticmethod(kf_m_s_move)

    def kf_home(*args) -> "int":
        """kf_home(int arg1, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_home(*args)

    kf_home = staticmethod(kf_home)

    def kf_end(*args) -> "int":
        """kf_end(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_end(*args)

    kf_end = staticmethod(kf_end)

    def kf_left(*args) -> "int":
        """kf_left(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_left(*args)

    kf_left = staticmethod(kf_left)

    def kf_up(*args) -> "int":
        """kf_up(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_up(*args)

    kf_up = staticmethod(kf_up)

    def kf_right(*args) -> "int":
        """kf_right(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_right(*args)

    kf_right = staticmethod(kf_right)

    def kf_down(*args) -> "int":
        """kf_down(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_down(*args)

    kf_down = staticmethod(kf_down)

    def kf_page_up(*args) -> "int":
        """kf_page_up(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_page_up(*args)

    kf_page_up = staticmethod(kf_page_up)

    def kf_page_down(*args) -> "int":
        """kf_page_down(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_page_down(*args)

    kf_page_down = staticmethod(kf_page_down)

    def kf_insert(*args) -> "int":
        """kf_insert(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_insert(*args)

    kf_insert = staticmethod(kf_insert)

    def kf_delete(*args) -> "int":
        """kf_delete(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_delete(*args)

    kf_delete = staticmethod(kf_delete)

    def kf_copy(*args) -> "int":
        """kf_copy(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_copy(*args)

    kf_copy = staticmethod(kf_copy)

    def kf_cut(*args) -> "int":
        """kf_cut(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_cut(*args)

    kf_cut = staticmethod(kf_cut)

    def kf_paste(*args) -> "int":
        """kf_paste(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_paste(*args)

    kf_paste = staticmethod(kf_paste)

    def kf_select_all(*args) -> "int":
        """kf_select_all(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_select_all(*args)

    kf_select_all = staticmethod(kf_select_all)

    def kf_undo(*args) -> "int":
        """kf_undo(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_undo(*args)

    kf_undo = staticmethod(kf_undo)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Text_Editor(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Text_Editor self)"""
        return _fltk.Fl_Text_Editor_draw(self, *args)

Fl_Text_Editor_swigregister = _fltk.Fl_Text_Editor_swigregister
Fl_Text_Editor_swigregister(Fl_Text_Editor)

def Fl_Text_Editor_kf_default(*args) -> "int":
    """Fl_Text_Editor_kf_default(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_default(*args)

def Fl_Text_Editor_kf_ignore(*args) -> "int":
    """Fl_Text_Editor_kf_ignore(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_ignore(*args)

def Fl_Text_Editor_kf_backspace(*args) -> "int":
    """Fl_Text_Editor_kf_backspace(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_backspace(*args)

def Fl_Text_Editor_kf_enter(*args) -> "int":
    """Fl_Text_Editor_kf_enter(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_enter(*args)

def Fl_Text_Editor_kf_move(*args) -> "int":
    """Fl_Text_Editor_kf_move(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_move(*args)

def Fl_Text_Editor_kf_shift_move(*args) -> "int":
    """Fl_Text_Editor_kf_shift_move(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_shift_move(*args)

def Fl_Text_Editor_kf_ctrl_move(*args) -> "int":
    """Fl_Text_Editor_kf_ctrl_move(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_ctrl_move(*args)

def Fl_Text_Editor_kf_c_s_move(*args) -> "int":
    """Fl_Text_Editor_kf_c_s_move(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_c_s_move(*args)

def Fl_Text_Editor_kf_meta_move(*args) -> "int":
    """Fl_Text_Editor_kf_meta_move(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_meta_move(*args)

def Fl_Text_Editor_kf_m_s_move(*args) -> "int":
    """Fl_Text_Editor_kf_m_s_move(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_m_s_move(*args)

def Fl_Text_Editor_kf_home(*args) -> "int":
    """Fl_Text_Editor_kf_home(int arg2, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_home(*args)

def Fl_Text_Editor_kf_end(*args) -> "int":
    """Fl_Text_Editor_kf_end(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_end(*args)

def Fl_Text_Editor_kf_left(*args) -> "int":
    """Fl_Text_Editor_kf_left(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_left(*args)

def Fl_Text_Editor_kf_up(*args) -> "int":
    """Fl_Text_Editor_kf_up(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_up(*args)

def Fl_Text_Editor_kf_right(*args) -> "int":
    """Fl_Text_Editor_kf_right(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_right(*args)

def Fl_Text_Editor_kf_down(*args) -> "int":
    """Fl_Text_Editor_kf_down(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_down(*args)

def Fl_Text_Editor_kf_page_up(*args) -> "int":
    """Fl_Text_Editor_kf_page_up(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_page_up(*args)

def Fl_Text_Editor_kf_page_down(*args) -> "int":
    """Fl_Text_Editor_kf_page_down(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_page_down(*args)

def Fl_Text_Editor_kf_insert(*args) -> "int":
    """Fl_Text_Editor_kf_insert(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_insert(*args)

def Fl_Text_Editor_kf_delete(*args) -> "int":
    """Fl_Text_Editor_kf_delete(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_delete(*args)

def Fl_Text_Editor_kf_copy(*args) -> "int":
    """Fl_Text_Editor_kf_copy(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_copy(*args)

def Fl_Text_Editor_kf_cut(*args) -> "int":
    """Fl_Text_Editor_kf_cut(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_cut(*args)

def Fl_Text_Editor_kf_paste(*args) -> "int":
    """Fl_Text_Editor_kf_paste(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_paste(*args)

def Fl_Text_Editor_kf_select_all(*args) -> "int":
    """Fl_Text_Editor_kf_select_all(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_select_all(*args)

def Fl_Text_Editor_kf_undo(*args) -> "int":
    """Fl_Text_Editor_kf_undo(int c, Fl_Text_Editor e) -> int"""
    return _fltk.Fl_Text_Editor_kf_undo(*args)

class Fl_Tile(Fl_Group):
    """

    The Fl_Tile class lets you resize the children by dragging the border between 
    them:

    Fl_Tile allows objects to be resized to zero dimensions. To prevent this you 
    can use the resizable() to limit where corners can be dragged to.

    Even though objects can be resized to zero sizes, they must initially have 
    non-zero sizes so the Fl_Tile can figure out their layout. If desired, call 
    position() after creating the children but before displaying the window to 
    set the borders where you want.

    The 'borders' are part of the children - Fl_Tile does not draw any graphics 
    of its own. In the example above, all of the children have FL_DOWN_BOX types, 
    and the 'ridges' you see are actually two adjacent FL_DOWN_BOX's drawn next 
    to each other. All neighboring widgets share the same edge - the widget's 
    thick borders make it appear as though the widgets aren't actually touching, 
    but they are. If the edges of adjacent widgets do not touch, then it will be 
    impossible to drag the corresponding edges.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def handle(self, *args) -> "int":
        """handle(Fl_Tile self, int event) -> int"""
        return _fltk.Fl_Tile_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Tile self, int X, int Y, int W, int H, char const * L=None) -> Fl_Tile"""
        if self.__class__ == Fl_Tile:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Tile(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def resize(self, *args) -> "void":
        """resize(Fl_Tile self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Tile_resize(self, *args)


    def position(self, *args) -> "void":
        """position(Fl_Tile self, int oldx, int oldy, int newx, int newy)"""
        return _fltk.Fl_Tile_position(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Tile
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Tile(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Tile self)"""
        return _fltk.Fl_Tile_draw(self, *args)

Fl_Tile_swigregister = _fltk.Fl_Tile_swigregister
Fl_Tile_swigregister(Fl_Tile)

class Fl_Tiled_Image(Fl_Image):
    """

    The Fl_Tiled_Image class supports tiling of images over a specified area. 
    The source (tile) image is not copied unless you call the color_average(), 
    desaturate(), or inactive() methods.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Tiled_Image self, Fl_Image i, int W=0, int H=0) -> Fl_Tiled_Image"""
        if self.__class__ == Fl_Tiled_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Tiled_Image(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Tiled_Image
    __del__ = lambda self: None

    def copy(self, *args) -> "Fl_Image *":
        """
        copy(Fl_Tiled_Image self, int W, int H) -> Fl_Image
        copy(Fl_Tiled_Image self) -> Fl_Image
        """
        return _fltk.Fl_Tiled_Image_copy(self, *args)


    def color_average(self, *args) -> "void":
        """color_average(Fl_Tiled_Image self, Fl_Color c, float i)"""
        return _fltk.Fl_Tiled_Image_color_average(self, *args)


    def desaturate(self, *args) -> "void":
        """desaturate(Fl_Tiled_Image self)"""
        return _fltk.Fl_Tiled_Image_desaturate(self, *args)


    def draw(self, *args) -> "void":
        """
        draw(Fl_Tiled_Image self, int X, int Y, int W, int H, int cx, int cy)
        draw(Fl_Tiled_Image self, int X, int Y)
        """
        return _fltk.Fl_Tiled_Image_draw(self, *args)


    def image(self, *args) -> "Fl_Image *":
        """image(Fl_Tiled_Image self) -> Fl_Image"""
        return _fltk.Fl_Tiled_Image_image(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Tiled_Image(self)
        return weakref_proxy(self)
Fl_Tiled_Image_swigregister = _fltk.Fl_Tiled_Image_swigregister
Fl_Tiled_Image_swigregister(Fl_Tiled_Image)

FL_NORMAL_TIMER = _fltk.FL_NORMAL_TIMER
FL_VALUE_TIMER = _fltk.FL_VALUE_TIMER
FL_HIDDEN_TIMER = _fltk.FL_HIDDEN_TIMER
class Fl_Timer(Fl_Widget):
    """

    This is provided only to emulate the Forms Timer widget. It works by making 
    a timeout callback every 1/5 second. This is wasteful and inaccurate if you 
    just want something to happen a fixed time in the future. You should directly 
    call Fl::add_timeout() instead.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Timer self)"""
        return _fltk.Fl_Timer_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Timer self, int arg0) -> int"""
        return _fltk.Fl_Timer_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Timer self, uchar t, int x, int y, int w, int h, char const * l) -> Fl_Timer"""
        if self.__class__ == Fl_Timer:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Timer(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Timer
    __del__ = lambda self: None

    def value(self, *args) -> "double":
        """
        value(Fl_Timer self, double arg2)
        value(Fl_Timer self) -> double
        """
        return _fltk.Fl_Timer_value(self, *args)


    def direction(self, *args) -> "void":
        """
        direction(Fl_Timer self) -> char
        direction(Fl_Timer self, char d)
        """
        return _fltk.Fl_Timer_direction(self, *args)


    def suspended(self, *args) -> "void":
        """
        suspended(Fl_Timer self) -> char
        suspended(Fl_Timer self, char d)
        """
        return _fltk.Fl_Timer_suspended(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Timer(self)
        return weakref_proxy(self)
Fl_Timer_swigregister = _fltk.Fl_Timer_swigregister
Fl_Timer_swigregister(Fl_Timer)

class Fl_Toggle_Button(Fl_Button):
    """Proxy of C++ Fl_Toggle_Button class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Toggle_Button self, int X, int Y, int W, int H, char const * l=None) -> Fl_Toggle_Button"""
        if self.__class__ == Fl_Toggle_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Toggle_Button(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Toggle_Button
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Toggle_Button(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Toggle_Button self)"""
        return _fltk.Fl_Toggle_Button_draw(self, *args)

Fl_Toggle_Button_swigregister = _fltk.Fl_Toggle_Button_swigregister
Fl_Toggle_Button_swigregister(Fl_Toggle_Button)

class Fl_Tooltip(object):
    """

    The Fl_Tooltip class provides tooltip support for all FLTK widgets.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def delay(*args) -> "void":
        """
        delay() -> float
        delay(float f)
        """
        return _fltk.Fl_Tooltip_delay(*args)

    delay = staticmethod(delay)

    def hoverdelay(*args) -> "void":
        """
        hoverdelay() -> float
        hoverdelay(float f)
        """
        return _fltk.Fl_Tooltip_hoverdelay(*args)

    hoverdelay = staticmethod(hoverdelay)

    def enabled(*args) -> "int":
        """enabled() -> int"""
        return _fltk.Fl_Tooltip_enabled(*args)

    enabled = staticmethod(enabled)

    def enable(*args) -> "void":
        """enable(int b=1)"""
        return _fltk.Fl_Tooltip_enable(*args)

    enable = staticmethod(enable)

    def disable(*args) -> "void":
        """disable()"""
        return _fltk.Fl_Tooltip_disable(*args)

    disable = staticmethod(disable)

    def enter_area(*args) -> "void":
        """enter_area(Fl_Widget w, int X, int Y, int W, int H, char const * tip)"""
        return _fltk.Fl_Tooltip_enter_area(*args)

    enter_area = staticmethod(enter_area)

    def current(*args) -> "void":
        """
        current() -> Fl_Widget
        current(Fl_Widget arg1)
        """
        return _fltk.Fl_Tooltip_current(*args)

    current = staticmethod(current)

    def font(*args) -> "void":
        """
        font() -> Fl_Font
        font(Fl_Font i)
        """
        return _fltk.Fl_Tooltip_font(*args)

    font = staticmethod(font)

    def size(*args) -> "void":
        """
        size() -> Fl_Fontsize
        size(Fl_Fontsize s)
        """
        return _fltk.Fl_Tooltip_size(*args)

    size = staticmethod(size)

    def color(*args) -> "void":
        """
        color() -> Fl_Color
        color(Fl_Color c)
        """
        return _fltk.Fl_Tooltip_color(*args)

    color = staticmethod(color)

    def textcolor(*args) -> "void":
        """
        textcolor() -> Fl_Color
        textcolor(Fl_Color c)
        """
        return _fltk.Fl_Tooltip_textcolor(*args)

    textcolor = staticmethod(textcolor)

    def margin_width(*args) -> "int":
        """margin_width() -> int"""
        return _fltk.Fl_Tooltip_margin_width(*args)

    margin_width = staticmethod(margin_width)

    def margin_height(*args) -> "int":
        """margin_height() -> int"""
        return _fltk.Fl_Tooltip_margin_height(*args)

    margin_height = staticmethod(margin_height)

    def wrap_width(*args) -> "int":
        """wrap_width() -> int"""
        return _fltk.Fl_Tooltip_wrap_width(*args)

    wrap_width = staticmethod(wrap_width)

    def __init__(self, *args):
        """__init__(Fl_Tooltip self) -> Fl_Tooltip"""
        this = _fltk.new_Fl_Tooltip(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Tooltip
    __del__ = lambda self: None
Fl_Tooltip_swigregister = _fltk.Fl_Tooltip_swigregister
Fl_Tooltip_swigregister(Fl_Tooltip)

def Fl_Tooltip_delay(*args) -> "void":
    """
    delay() -> float
    Fl_Tooltip_delay(float f)
    """
    return _fltk.Fl_Tooltip_delay(*args)

def Fl_Tooltip_hoverdelay(*args) -> "void":
    """
    hoverdelay() -> float
    Fl_Tooltip_hoverdelay(float f)
    """
    return _fltk.Fl_Tooltip_hoverdelay(*args)

def Fl_Tooltip_enabled(*args) -> "int":
    """Fl_Tooltip_enabled() -> int"""
    return _fltk.Fl_Tooltip_enabled(*args)

def Fl_Tooltip_enable(*args) -> "void":
    """Fl_Tooltip_enable(int b=1)"""
    return _fltk.Fl_Tooltip_enable(*args)

def Fl_Tooltip_disable(*args) -> "void":
    """Fl_Tooltip_disable()"""
    return _fltk.Fl_Tooltip_disable(*args)

def Fl_Tooltip_enter_area(*args) -> "void":
    """Fl_Tooltip_enter_area(Fl_Widget w, int X, int Y, int W, int H, char const * tip)"""
    return _fltk.Fl_Tooltip_enter_area(*args)

def Fl_Tooltip_current(*args) -> "void":
    """
    current() -> Fl_Widget
    Fl_Tooltip_current(Fl_Widget arg2)
    """
    return _fltk.Fl_Tooltip_current(*args)

def Fl_Tooltip_font(*args) -> "void":
    """
    font() -> Fl_Font
    Fl_Tooltip_font(Fl_Font i)
    """
    return _fltk.Fl_Tooltip_font(*args)

def Fl_Tooltip_size(*args) -> "void":
    """
    size() -> Fl_Fontsize
    Fl_Tooltip_size(Fl_Fontsize s)
    """
    return _fltk.Fl_Tooltip_size(*args)

def Fl_Tooltip_color(*args) -> "void":
    """
    color() -> Fl_Color
    Fl_Tooltip_color(Fl_Color c)
    """
    return _fltk.Fl_Tooltip_color(*args)

def Fl_Tooltip_textcolor(*args) -> "void":
    """
    textcolor() -> Fl_Color
    Fl_Tooltip_textcolor(Fl_Color c)
    """
    return _fltk.Fl_Tooltip_textcolor(*args)

def Fl_Tooltip_margin_width(*args) -> "int":
    """Fl_Tooltip_margin_width() -> int"""
    return _fltk.Fl_Tooltip_margin_width(*args)

def Fl_Tooltip_margin_height(*args) -> "int":
    """Fl_Tooltip_margin_height() -> int"""
    return _fltk.Fl_Tooltip_margin_height(*args)

def Fl_Tooltip_wrap_width(*args) -> "int":
    """Fl_Tooltip_wrap_width() -> int"""
    return _fltk.Fl_Tooltip_wrap_width(*args)

class Fl_Value_Output(Fl_Valuator):
    """

    The Fl_Value_Output widget displays a floating point value. If step() is 
    not zero, the user can adjust the value by dragging the mouse left and right. 
    The left button moves one step()  per pixel, the middle by 10 * step(), and 
    the right button by 100 * step().

    This is much lighter-weight than Fl_Value_Input because it contains no text 
    editing code or character buffer. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def draw(self, *args) -> "void":
        """draw(Fl_Value_Output self)"""
        return _fltk.Fl_Value_Output_draw(self, *args)


    def handle(self, *args) -> "int":
        """handle(Fl_Value_Output self, int arg0) -> int"""
        return _fltk.Fl_Value_Output_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Value_Output self, int x, int y, int w, int h, char const * l=None) -> Fl_Value_Output"""
        if self.__class__ == Fl_Value_Output:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Value_Output(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def soft(self, *args) -> "uchar":
        """
        soft(Fl_Value_Output self, uchar s)
        soft(Fl_Value_Output self) -> uchar
        """
        return _fltk.Fl_Value_Output_soft(self, *args)


    def textfont(self, *args) -> "void":
        """
        textfont(Fl_Value_Output self) -> Fl_Font
        textfont(Fl_Value_Output self, Fl_Font s)
        """
        return _fltk.Fl_Value_Output_textfont(self, *args)


    def textsize(self, *args) -> "void":
        """
        textsize(Fl_Value_Output self) -> Fl_Fontsize
        textsize(Fl_Value_Output self, Fl_Fontsize s)
        """
        return _fltk.Fl_Value_Output_textsize(self, *args)


    def textcolor(self, *args) -> "void":
        """
        textcolor(Fl_Value_Output self) -> Fl_Color
        textcolor(Fl_Value_Output self, Fl_Color s)
        """
        return _fltk.Fl_Value_Output_textcolor(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Value_Output
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Value_Output(self)
        return weakref_proxy(self)
Fl_Value_Output_swigregister = _fltk.Fl_Value_Output_swigregister
Fl_Value_Output_swigregister(Fl_Value_Output)

class Fl_Wizard(Fl_Group):
    """

    The Fl_Wizard widget is based off the Fl_Tabs widget, but instead of 
    displaying tabs it only changes 'tabs' under program control. Its primary 
    purpose is to support 'wizards' that step a user through configuration or 
    troubleshooting tasks.

    As with Fl_Tabs, wizard panes are composed of child (usually Fl_Group) 
    widgets. Navigation buttons must be added separately. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Wizard self, int arg2, int arg3, int arg4, int arg5, char const * arg6=None) -> Fl_Wizard"""
        if self.__class__ == Fl_Wizard:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Wizard(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def next(self, *args) -> "void":
        """next(Fl_Wizard self)"""
        return _fltk.Fl_Wizard_next(self, *args)


    def prev(self, *args) -> "void":
        """prev(Fl_Wizard self)"""
        return _fltk.Fl_Wizard_prev(self, *args)


    def value(self, *args) -> "void":
        """
        value(Fl_Wizard self) -> Fl_Widget
        value(Fl_Wizard self, Fl_Widget arg2)
        """
        return _fltk.Fl_Wizard_value(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Wizard
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Wizard(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(Fl_Wizard self)"""
        return _fltk.Fl_Wizard_draw(self, *args)

Fl_Wizard_swigregister = _fltk.Fl_Wizard_swigregister
Fl_Wizard_swigregister(Fl_Wizard)

class Fl_XBM_Image(Fl_Bitmap):
    """

    The Fl_XBM_Image class supports loading, caching, and drawing of X Bitmap 
    (XBM) bitmap files.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_XBM_Image self, char const * filename) -> Fl_XBM_Image"""
        if self.__class__ == Fl_XBM_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_XBM_Image(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_XBM_Image
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_XBM_Image(self)
        return weakref_proxy(self)
Fl_XBM_Image_swigregister = _fltk.Fl_XBM_Image_swigregister
Fl_XBM_Image_swigregister(Fl_XBM_Image)

class Fl_XPM_Image(Fl_Pixmap):
    """

    The Fl_XPM_Image class supports loading, caching, and drawing of X Pixmap (XPM) images, including transparency.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_XPM_Image self, char const * filename) -> Fl_XPM_Image"""
        if self.__class__ == Fl_XPM_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_XPM_Image(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fltk.delete_Fl_XPM_Image
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_XPM_Image(self)
        return weakref_proxy(self)
Fl_XPM_Image_swigregister = _fltk.Fl_XPM_Image_swigregister
Fl_XPM_Image_swigregister(Fl_XPM_Image)

FL_TREE_SORT_NONE = _fltk.FL_TREE_SORT_NONE
FL_TREE_SORT_ASCENDING = _fltk.FL_TREE_SORT_ASCENDING
FL_TREE_SORT_DESCENDING = _fltk.FL_TREE_SORT_DESCENDING
FL_TREE_CONNECTOR_NONE = _fltk.FL_TREE_CONNECTOR_NONE
FL_TREE_CONNECTOR_DOTTED = _fltk.FL_TREE_CONNECTOR_DOTTED
FL_TREE_CONNECTOR_SOLID = _fltk.FL_TREE_CONNECTOR_SOLID
FL_TREE_SELECT_NONE = _fltk.FL_TREE_SELECT_NONE
FL_TREE_SELECT_SINGLE = _fltk.FL_TREE_SELECT_SINGLE
FL_TREE_SELECT_MULTI = _fltk.FL_TREE_SELECT_MULTI
FL_TREE_SELECT_SINGLE_DRAGGABLE = _fltk.FL_TREE_SELECT_SINGLE_DRAGGABLE
class Fl_Tree_Prefs(object):
    """Proxy of C++ Fl_Tree_Prefs class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Tree_Prefs self) -> Fl_Tree_Prefs"""
        this = _fltk.new_Fl_Tree_Prefs(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def item_labelfont(self, *args) -> "void":
        """
        item_labelfont(Fl_Tree_Prefs self) -> Fl_Font
        item_labelfont(Fl_Tree_Prefs self, Fl_Font val)
        """
        return _fltk.Fl_Tree_Prefs_item_labelfont(self, *args)


    def item_labelsize(self, *args) -> "void":
        """
        item_labelsize(Fl_Tree_Prefs self) -> Fl_Fontsize
        item_labelsize(Fl_Tree_Prefs self, Fl_Fontsize val)
        """
        return _fltk.Fl_Tree_Prefs_item_labelsize(self, *args)


    def item_labelfgcolor(self, *args) -> "void":
        """
        item_labelfgcolor(Fl_Tree_Prefs self) -> Fl_Color
        item_labelfgcolor(Fl_Tree_Prefs self, Fl_Color val)
        """
        return _fltk.Fl_Tree_Prefs_item_labelfgcolor(self, *args)


    def item_labelbgcolor(self, *args) -> "void":
        """
        item_labelbgcolor(Fl_Tree_Prefs self) -> Fl_Color
        item_labelbgcolor(Fl_Tree_Prefs self, Fl_Color val)
        """
        return _fltk.Fl_Tree_Prefs_item_labelbgcolor(self, *args)


    def labelfont(self, *args) -> "void":
        """
        labelfont(Fl_Tree_Prefs self) -> Fl_Font
        labelfont(Fl_Tree_Prefs self, Fl_Font val)
        """
        return _fltk.Fl_Tree_Prefs_labelfont(self, *args)


    def labelsize(self, *args) -> "void":
        """
        labelsize(Fl_Tree_Prefs self) -> Fl_Fontsize
        labelsize(Fl_Tree_Prefs self, Fl_Fontsize val)
        """
        return _fltk.Fl_Tree_Prefs_labelsize(self, *args)


    def labelfgcolor(self, *args) -> "void":
        """
        labelfgcolor(Fl_Tree_Prefs self) -> Fl_Color
        labelfgcolor(Fl_Tree_Prefs self, Fl_Color val)
        """
        return _fltk.Fl_Tree_Prefs_labelfgcolor(self, *args)


    def labelbgcolor(self, *args) -> "void":
        """
        labelbgcolor(Fl_Tree_Prefs self) -> Fl_Color
        labelbgcolor(Fl_Tree_Prefs self, Fl_Color val)
        """
        return _fltk.Fl_Tree_Prefs_labelbgcolor(self, *args)


    def marginleft(self, *args) -> "void":
        """
        marginleft(Fl_Tree_Prefs self) -> int
        marginleft(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_marginleft(self, *args)


    def margintop(self, *args) -> "void":
        """
        margintop(Fl_Tree_Prefs self) -> int
        margintop(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_margintop(self, *args)


    def openchild_marginbottom(self, *args) -> "void":
        """
        openchild_marginbottom(Fl_Tree_Prefs self) -> int
        openchild_marginbottom(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_openchild_marginbottom(self, *args)


    def usericonmarginleft(self, *args) -> "void":
        """
        usericonmarginleft(Fl_Tree_Prefs self) -> int
        usericonmarginleft(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_usericonmarginleft(self, *args)


    def labelmarginleft(self, *args) -> "void":
        """
        labelmarginleft(Fl_Tree_Prefs self) -> int
        labelmarginleft(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_labelmarginleft(self, *args)


    def linespacing(self, *args) -> "void":
        """
        linespacing(Fl_Tree_Prefs self) -> int
        linespacing(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_linespacing(self, *args)


    def connectorcolor(self, *args) -> "void":
        """
        connectorcolor(Fl_Tree_Prefs self) -> Fl_Color
        connectorcolor(Fl_Tree_Prefs self, Fl_Color val)
        """
        return _fltk.Fl_Tree_Prefs_connectorcolor(self, *args)


    def connectorstyle(self, *args) -> "void":
        """
        connectorstyle(Fl_Tree_Prefs self) -> Fl_Tree_Connector
        connectorstyle(Fl_Tree_Prefs self, Fl_Tree_Connector val)
        connectorstyle(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_connectorstyle(self, *args)


    def connectorwidth(self, *args) -> "void":
        """
        connectorwidth(Fl_Tree_Prefs self) -> int
        connectorwidth(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_connectorwidth(self, *args)


    def openicon(self, *args) -> "void":
        """
        openicon(Fl_Tree_Prefs self) -> Fl_Image
        openicon(Fl_Tree_Prefs self, Fl_Image val)
        """
        return _fltk.Fl_Tree_Prefs_openicon(self, *args)


    def closeicon(self, *args) -> "void":
        """
        closeicon(Fl_Tree_Prefs self) -> Fl_Image
        closeicon(Fl_Tree_Prefs self, Fl_Image val)
        """
        return _fltk.Fl_Tree_Prefs_closeicon(self, *args)


    def usericon(self, *args) -> "void":
        """
        usericon(Fl_Tree_Prefs self) -> Fl_Image
        usericon(Fl_Tree_Prefs self, Fl_Image val)
        """
        return _fltk.Fl_Tree_Prefs_usericon(self, *args)


    def showcollapse(self, *args) -> "void":
        """
        showcollapse(Fl_Tree_Prefs self) -> char
        showcollapse(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_showcollapse(self, *args)


    def sortorder(self, *args) -> "void":
        """
        sortorder(Fl_Tree_Prefs self) -> Fl_Tree_Sort
        sortorder(Fl_Tree_Prefs self, Fl_Tree_Sort val)
        """
        return _fltk.Fl_Tree_Prefs_sortorder(self, *args)


    def selectbox(self, *args) -> "void":
        """
        selectbox(Fl_Tree_Prefs self) -> Fl_Boxtype
        selectbox(Fl_Tree_Prefs self, Fl_Boxtype val)
        """
        return _fltk.Fl_Tree_Prefs_selectbox(self, *args)


    def showroot(self, *args) -> "void":
        """
        showroot(Fl_Tree_Prefs self) -> int
        showroot(Fl_Tree_Prefs self, int val)
        """
        return _fltk.Fl_Tree_Prefs_showroot(self, *args)


    def selectmode(self, *args) -> "void":
        """
        selectmode(Fl_Tree_Prefs self) -> Fl_Tree_Select
        selectmode(Fl_Tree_Prefs self, Fl_Tree_Select val)
        """
        return _fltk.Fl_Tree_Prefs_selectmode(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Tree_Prefs
    __del__ = lambda self: None
Fl_Tree_Prefs_swigregister = _fltk.Fl_Tree_Prefs_swigregister
Fl_Tree_Prefs_swigregister(Fl_Tree_Prefs)

class Fl_Tree_Item_Array(object):
    """

    Because FLTK 1.x.x. has mandated that templates and STL not be used, we use this class to dynamically manage the arrays.
    None of the methods do range checking on index values; the caller must be sure that index values are within the range 0<index<total() (unless otherwise noted).

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    __swig_destroy__ = _fltk.delete_Fl_Tree_Item_Array
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(Fl_Tree_Item_Array self, int new_chunksize=10) -> Fl_Tree_Item_Array
        __init__(Fl_Tree_Item_Array self, Fl_Tree_Item_Array o) -> Fl_Tree_Item_Array
        """
        this = _fltk.new_Fl_Tree_Item_Array(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def total(self, *args) -> "int":
        """total(Fl_Tree_Item_Array self) -> int"""
        return _fltk.Fl_Tree_Item_Array_total(self, *args)


    def swap(self, *args) -> "void":
        """swap(Fl_Tree_Item_Array self, int ax, int bx)"""
        return _fltk.Fl_Tree_Item_Array_swap(self, *args)


    def move(self, *args) -> "int":
        """move(Fl_Tree_Item_Array self, int to, int arg3) -> int"""
        return _fltk.Fl_Tree_Item_Array_move(self, *args)


    def deparent(self, *args) -> "int":
        """deparent(Fl_Tree_Item_Array self, int pos) -> int"""
        return _fltk.Fl_Tree_Item_Array_deparent(self, *args)


    def reparent(self, *args) -> "int":
        """reparent(Fl_Tree_Item_Array self, Fl_Tree_Item item, Fl_Tree_Item newparent, int pos) -> int"""
        return _fltk.Fl_Tree_Item_Array_reparent(self, *args)


    def clear(self, *args) -> "void":
        """clear(Fl_Tree_Item_Array self)"""
        return _fltk.Fl_Tree_Item_Array_clear(self, *args)


    def add(self, *args) -> "void":
        """add(Fl_Tree_Item_Array self, Fl_Tree_Item val)"""
        return _fltk.Fl_Tree_Item_Array_add(self, *args)


    def insert(self, *args) -> "void":
        """insert(Fl_Tree_Item_Array self, int pos, Fl_Tree_Item new_item)"""
        return _fltk.Fl_Tree_Item_Array_insert(self, *args)


    def replace(self, *args) -> "void":
        """replace(Fl_Tree_Item_Array self, int pos, Fl_Tree_Item new_item)"""
        return _fltk.Fl_Tree_Item_Array_replace(self, *args)


    def remove(self, *args) -> "int":
        """
        remove(Fl_Tree_Item_Array self, int index)
        remove(Fl_Tree_Item_Array self, Fl_Tree_Item item) -> int
        """
        return _fltk.Fl_Tree_Item_Array_remove(self, *args)

Fl_Tree_Item_Array_swigregister = _fltk.Fl_Tree_Item_Array_swigregister
Fl_Tree_Item_Array_swigregister(Fl_Tree_Item_Array)

class Fl_Tree_Item(object):
    """

    This class is a single tree item, and manages all of the item's attributes. Fl_Tree_Item is used by Fl_Tree, which is comprised of many instances of Fl_Tree_Item.
    Fl_Tree_Item is hierarchical; it dynamically manages an Fl_Tree_Item_Array of children that are themselves instances of Fl_Tree_Item. Each item can have zero or more children. When an item has children, close() and open() can be used to hide or show them. Items have their own attributes; font size, face, color. Items maintain their own hierarchy of children. When you make changes to items, you'll need to tell the tree to redraw() for the changes to show up.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    __swig_destroy__ = _fltk.delete_Fl_Tree_Item
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(Fl_Tree_Item self, Fl_Tree_Prefs prefs) -> Fl_Tree_Item
        __init__(Fl_Tree_Item self, Fl_Tree_Item o) -> Fl_Tree_Item
        """
        this = _fltk.new_Fl_Tree_Item(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def x(self, *args) -> "int":
        """x(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_x(self, *args)


    def y(self, *args) -> "int":
        """y(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_y(self, *args)


    def w(self, *args) -> "int":
        """w(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_w(self, *args)


    def h(self, *args) -> "int":
        """h(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_h(self, *args)


    def label_x(self, *args) -> "int":
        """label_x(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_label_x(self, *args)


    def label_y(self, *args) -> "int":
        """label_y(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_label_y(self, *args)


    def label_w(self, *args) -> "int":
        """label_w(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_label_w(self, *args)


    def label_h(self, *args) -> "int":
        """label_h(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_label_h(self, *args)


    def draw(self, *args) -> "void":
        """draw(Fl_Tree_Item self, int X, int W, Fl_Widget tree, Fl_Tree_Item itemfocus, Fl_Tree_Prefs prefs, int lastchild=1)"""
        return _fltk.Fl_Tree_Item_draw(self, *args)


    def show_self(self, *args) -> "void":
        """show_self(Fl_Tree_Item self, char const * indent)"""
        return _fltk.Fl_Tree_Item_show_self(self, *args)


    def label(self, *args) -> "char const *":
        """
        label(Fl_Tree_Item self, char const * val)
        label(Fl_Tree_Item self) -> char const *
        """
        return _fltk.Fl_Tree_Item_label(self, *args)


    def user_data(self, *args) -> "void *":
        """
        user_data(Fl_Tree_Item self, void * data)
        user_data(Fl_Tree_Item self) -> void *
        """
        return _fltk.Fl_Tree_Item_user_data(self, *args)


    def labelfont(self, *args) -> "Fl_Font":
        """
        labelfont(Fl_Tree_Item self, Fl_Font val)
        labelfont(Fl_Tree_Item self) -> Fl_Font
        """
        return _fltk.Fl_Tree_Item_labelfont(self, *args)


    def labelsize(self, *args) -> "Fl_Fontsize":
        """
        labelsize(Fl_Tree_Item self, Fl_Fontsize val)
        labelsize(Fl_Tree_Item self) -> Fl_Fontsize
        """
        return _fltk.Fl_Tree_Item_labelsize(self, *args)


    def labelfgcolor(self, *args) -> "Fl_Color":
        """
        labelfgcolor(Fl_Tree_Item self, Fl_Color val)
        labelfgcolor(Fl_Tree_Item self) -> Fl_Color
        """
        return _fltk.Fl_Tree_Item_labelfgcolor(self, *args)


    def labelcolor(self, *args) -> "Fl_Color":
        """
        labelcolor(Fl_Tree_Item self, Fl_Color val)
        labelcolor(Fl_Tree_Item self) -> Fl_Color
        """
        return _fltk.Fl_Tree_Item_labelcolor(self, *args)


    def labelbgcolor(self, *args) -> "Fl_Color":
        """
        labelbgcolor(Fl_Tree_Item self, Fl_Color val)
        labelbgcolor(Fl_Tree_Item self) -> Fl_Color
        """
        return _fltk.Fl_Tree_Item_labelbgcolor(self, *args)


    def widget(self, *args) -> "Fl_Widget *":
        """
        widget(Fl_Tree_Item self, Fl_Widget val)
        widget(Fl_Tree_Item self) -> Fl_Widget
        """
        return _fltk.Fl_Tree_Item_widget(self, *args)


    def children(self, *args) -> "int":
        """children(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_children(self, *args)


    def child(self, *args) -> "Fl_Tree_Item const *":
        """
        child(Fl_Tree_Item self, int index) -> Fl_Tree_Item
        child(Fl_Tree_Item self, int t) -> Fl_Tree_Item
        """
        return _fltk.Fl_Tree_Item_child(self, *args)


    def has_children(self, *args) -> "int":
        """has_children(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_has_children(self, *args)


    def find_child(self, *args) -> "int":
        """
        find_child(Fl_Tree_Item self, char const * name) -> int
        find_child(Fl_Tree_Item self, Fl_Tree_Item item) -> int
        """
        return _fltk.Fl_Tree_Item_find_child(self, *args)


    def remove_child(self, *args) -> "int":
        """
        remove_child(Fl_Tree_Item self, Fl_Tree_Item item) -> int
        remove_child(Fl_Tree_Item self, char const * new_label) -> int
        """
        return _fltk.Fl_Tree_Item_remove_child(self, *args)


    def clear_children(self, *args) -> "void":
        """clear_children(Fl_Tree_Item self)"""
        return _fltk.Fl_Tree_Item_clear_children(self, *args)


    def swap_children(self, *args) -> "int":
        """
        swap_children(Fl_Tree_Item self, int ax, int bx)
        swap_children(Fl_Tree_Item self, Fl_Tree_Item a, Fl_Tree_Item b) -> int
        """
        return _fltk.Fl_Tree_Item_swap_children(self, *args)


    def find_child_item(self, *args) -> "Fl_Tree_Item *":
        """
        find_child_item(Fl_Tree_Item self, char const * name) -> Fl_Tree_Item
        find_child_item(Fl_Tree_Item self, char const * name) -> Fl_Tree_Item
        find_child_item(Fl_Tree_Item self, char ** arr) -> Fl_Tree_Item
        find_child_item(Fl_Tree_Item self, char ** arr) -> Fl_Tree_Item
        """
        return _fltk.Fl_Tree_Item_find_child_item(self, *args)


    def find_item(self, *args) -> "Fl_Tree_Item *":
        """
        find_item(Fl_Tree_Item self, char ** arr) -> Fl_Tree_Item
        find_item(Fl_Tree_Item self, char ** arr) -> Fl_Tree_Item
        """
        return _fltk.Fl_Tree_Item_find_item(self, *args)


    def add(self, *args) -> "Fl_Tree_Item *":
        """
        add(Fl_Tree_Item self, Fl_Tree_Prefs prefs, char const * new_label, Fl_Tree_Item newitem) -> Fl_Tree_Item
        add(Fl_Tree_Item self, Fl_Tree_Prefs prefs, char const * new_label) -> Fl_Tree_Item
        add(Fl_Tree_Item self, Fl_Tree_Prefs prefs, char ** arr, Fl_Tree_Item newitem) -> Fl_Tree_Item
        add(Fl_Tree_Item self, Fl_Tree_Prefs prefs, char ** arr) -> Fl_Tree_Item
        """
        return _fltk.Fl_Tree_Item_add(self, *args)


    def insert(self, *args) -> "Fl_Tree_Item *":
        """insert(Fl_Tree_Item self, Fl_Tree_Prefs prefs, char const * new_label, int pos=0) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_insert(self, *args)


    def insert_above(self, *args) -> "Fl_Tree_Item *":
        """insert_above(Fl_Tree_Item self, Fl_Tree_Prefs prefs, char const * new_label) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_insert_above(self, *args)


    def deparent(self, *args) -> "Fl_Tree_Item *":
        """deparent(Fl_Tree_Item self, int index) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_deparent(self, *args)


    def reparent(self, *args) -> "int":
        """reparent(Fl_Tree_Item self, Fl_Tree_Item newchild, int index) -> int"""
        return _fltk.Fl_Tree_Item_reparent(self, *args)


    def move(self, *args) -> "int":
        """
        move(Fl_Tree_Item self, int to, int arg3) -> int
        move(Fl_Tree_Item self, Fl_Tree_Item item, int op=0, int pos=0) -> int
        """
        return _fltk.Fl_Tree_Item_move(self, *args)


    def move_above(self, *args) -> "int":
        """move_above(Fl_Tree_Item self, Fl_Tree_Item item) -> int"""
        return _fltk.Fl_Tree_Item_move_above(self, *args)


    def move_below(self, *args) -> "int":
        """move_below(Fl_Tree_Item self, Fl_Tree_Item item) -> int"""
        return _fltk.Fl_Tree_Item_move_below(self, *args)


    def move_into(self, *args) -> "int":
        """move_into(Fl_Tree_Item self, Fl_Tree_Item item, int pos=0) -> int"""
        return _fltk.Fl_Tree_Item_move_into(self, *args)


    def depth(self, *args) -> "int":
        """depth(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_depth(self, *args)


    def prev(self, *args) -> "Fl_Tree_Item *":
        """prev(Fl_Tree_Item self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_prev(self, *args)


    def next(self, *args) -> "Fl_Tree_Item *":
        """next(Fl_Tree_Item self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_next(self, *args)


    def next_sibling(self, *args) -> "Fl_Tree_Item *":
        """next_sibling(Fl_Tree_Item self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_next_sibling(self, *args)


    def prev_sibling(self, *args) -> "Fl_Tree_Item *":
        """prev_sibling(Fl_Tree_Item self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_prev_sibling(self, *args)


    def update_prev_next(self, *args) -> "void":
        """update_prev_next(Fl_Tree_Item self, int index)"""
        return _fltk.Fl_Tree_Item_update_prev_next(self, *args)


    def next_displayed(self, *args) -> "Fl_Tree_Item *":
        """next_displayed(Fl_Tree_Item self, Fl_Tree_Prefs prefs) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_next_displayed(self, *args)


    def prev_displayed(self, *args) -> "Fl_Tree_Item *":
        """prev_displayed(Fl_Tree_Item self, Fl_Tree_Prefs prefs) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_prev_displayed(self, *args)


    def next_visible(self, *args) -> "Fl_Tree_Item *":
        """next_visible(Fl_Tree_Item self, Fl_Tree_Prefs prefs) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_next_visible(self, *args)


    def prev_visible(self, *args) -> "Fl_Tree_Item *":
        """prev_visible(Fl_Tree_Item self, Fl_Tree_Prefs prefs) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_Item_prev_visible(self, *args)


    def parent(self, *args) -> "void":
        """
        parent(Fl_Tree_Item self) -> Fl_Tree_Item
        parent(Fl_Tree_Item self) -> Fl_Tree_Item
        parent(Fl_Tree_Item self, Fl_Tree_Item val)
        """
        return _fltk.Fl_Tree_Item_parent(self, *args)


    def open(self, *args) -> "void":
        """open(Fl_Tree_Item self)"""
        return _fltk.Fl_Tree_Item_open(self, *args)


    def close(self, *args) -> "void":
        """close(Fl_Tree_Item self)"""
        return _fltk.Fl_Tree_Item_close(self, *args)


    def is_open(self, *args) -> "int":
        """is_open(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_is_open(self, *args)


    def is_close(self, *args) -> "int":
        """is_close(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_is_close(self, *args)


    def open_toggle(self, *args) -> "void":
        """open_toggle(Fl_Tree_Item self)"""
        return _fltk.Fl_Tree_Item_open_toggle(self, *args)


    def select(self, *args) -> "void":
        """select(Fl_Tree_Item self, int val=1)"""
        return _fltk.Fl_Tree_Item_select(self, *args)


    def select_toggle(self, *args) -> "void":
        """select_toggle(Fl_Tree_Item self)"""
        return _fltk.Fl_Tree_Item_select_toggle(self, *args)


    def select_all(self, *args) -> "int":
        """select_all(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_select_all(self, *args)


    def deselect(self, *args) -> "void":
        """deselect(Fl_Tree_Item self)"""
        return _fltk.Fl_Tree_Item_deselect(self, *args)


    def deselect_all(self, *args) -> "int":
        """deselect_all(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_deselect_all(self, *args)


    def is_selected(self, *args) -> "char":
        """is_selected(Fl_Tree_Item self) -> char"""
        return _fltk.Fl_Tree_Item_is_selected(self, *args)


    def activate(self, *args) -> "void":
        """activate(Fl_Tree_Item self, int val=1)"""
        return _fltk.Fl_Tree_Item_activate(self, *args)


    def deactivate(self, *args) -> "void":
        """deactivate(Fl_Tree_Item self)"""
        return _fltk.Fl_Tree_Item_deactivate(self, *args)


    def is_activated(self, *args) -> "char":
        """is_activated(Fl_Tree_Item self) -> char"""
        return _fltk.Fl_Tree_Item_is_activated(self, *args)


    def is_active(self, *args) -> "char":
        """is_active(Fl_Tree_Item self) -> char"""
        return _fltk.Fl_Tree_Item_is_active(self, *args)


    def visible(self, *args) -> "int":
        """visible(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_visible(self, *args)


    def is_visible(self, *args) -> "int":
        """is_visible(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_is_visible(self, *args)


    def visible_r(self, *args) -> "int":
        """visible_r(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_visible_r(self, *args)


    def usericon(self, *args) -> "Fl_Image *":
        """
        usericon(Fl_Tree_Item self, Fl_Image val)
        usericon(Fl_Tree_Item self) -> Fl_Image
        """
        return _fltk.Fl_Tree_Item_usericon(self, *args)


    def find_clicked(self, *args) -> "Fl_Tree_Item *":
        """
        find_clicked(Fl_Tree_Item self, Fl_Tree_Prefs prefs) -> Fl_Tree_Item
        find_clicked(Fl_Tree_Item self, Fl_Tree_Prefs prefs) -> Fl_Tree_Item
        """
        return _fltk.Fl_Tree_Item_find_clicked(self, *args)


    def event_on_collapse_icon(self, *args) -> "int":
        """event_on_collapse_icon(Fl_Tree_Item self, Fl_Tree_Prefs prefs) -> int"""
        return _fltk.Fl_Tree_Item_event_on_collapse_icon(self, *args)


    def event_on_label(self, *args) -> "int":
        """event_on_label(Fl_Tree_Item self, Fl_Tree_Prefs prefs) -> int"""
        return _fltk.Fl_Tree_Item_event_on_label(self, *args)


    def is_root(self, *args) -> "int":
        """is_root(Fl_Tree_Item self) -> int"""
        return _fltk.Fl_Tree_Item_is_root(self, *args)

Fl_Tree_Item_swigregister = _fltk.Fl_Tree_Item_swigregister
Fl_Tree_Item_swigregister(Fl_Tree_Item)

FL_TREE_REASON_NONE = _fltk.FL_TREE_REASON_NONE
FL_TREE_REASON_SELECTED = _fltk.FL_TREE_REASON_SELECTED
FL_TREE_REASON_DESELECTED = _fltk.FL_TREE_REASON_DESELECTED
FL_TREE_REASON_OPENED = _fltk.FL_TREE_REASON_OPENED
FL_TREE_REASON_CLOSED = _fltk.FL_TREE_REASON_CLOSED
FL_TREE_REASON_DRAGGED = _fltk.FL_TREE_REASON_DRAGGED
class Fl_Tree(Fl_Group):
    """

    An expandable tree widget. Similar to Fl_Browser, Fl_Tree is browser of Fl_Tree_Item's, which can be in a parented hierarchy. Subtrees can be expanded or closed. Items can be added, deleted, inserted, sorted and re-ordered. The tree items may also contain other FLTK widgets, like buttons, input fields, or even 'custom' widgets.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Fl_Tree self, int X, int Y, int W, int H, char const * L=None) -> Fl_Tree"""
        if self.__class__ == Fl_Tree:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Tree(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Tree
    __del__ = lambda self: None

    def handle(self, *args) -> "int":
        """handle(Fl_Tree self, int e) -> int"""
        return _fltk.Fl_Tree_handle(self, *args)


    def draw(self, *args) -> "void":
        """draw(Fl_Tree self)"""
        return _fltk.Fl_Tree_draw(self, *args)


    def show_self(self, *args) -> "void":
        """show_self(Fl_Tree self)"""
        return _fltk.Fl_Tree_show_self(self, *args)


    def resize(self, *args) -> "void":
        """resize(Fl_Tree self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Tree_resize(self, *args)


    def root_label(self, *args) -> "void":
        """root_label(Fl_Tree self, char const * new_label)"""
        return _fltk.Fl_Tree_root_label(self, *args)


    def root(self, *args) -> "void":
        """
        root(Fl_Tree self) -> Fl_Tree_Item
        root(Fl_Tree self, Fl_Tree_Item newitem)
        """
        return _fltk.Fl_Tree_root(self, *args)


    def prefs(self, *args) -> "Fl_Tree_Prefs const &":
        """prefs(Fl_Tree self) -> Fl_Tree_Prefs"""
        return _fltk.Fl_Tree_prefs(self, *args)


    def add(self, *args) -> "Fl_Tree_Item *":
        """
        add(Fl_Tree self, char const * path) -> Fl_Tree_Item
        add(Fl_Tree self, char const * path, Fl_Tree_Item newitem) -> Fl_Tree_Item
        add(Fl_Tree self, Fl_Tree_Item parent_item, char const * name) -> Fl_Tree_Item
        """
        val = _fltk.Fl_Tree_add(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def insert_above(self, *args) -> "Fl_Tree_Item *":
        """insert_above(Fl_Tree self, Fl_Tree_Item above, char const * name) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_insert_above(self, *args)


    def insert(self, *args) -> "Fl_Tree_Item *":
        """insert(Fl_Tree self, Fl_Tree_Item item, char const * name, int pos) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_insert(self, *args)


    def remove(self, *args) -> "int":
        """remove(Fl_Tree self, Fl_Tree_Item item) -> int"""
        val = _fltk.Fl_Tree_remove(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def clear(self, *args) -> "void":
        """clear(Fl_Tree self)"""
        return _fltk.Fl_Tree_clear(self, *args)


    def clear_children(self, *args) -> "void":
        """clear_children(Fl_Tree self, Fl_Tree_Item item)"""
        return _fltk.Fl_Tree_clear_children(self, *args)


    def find_item(self, *args) -> "Fl_Tree_Item const *":
        """
        find_item(Fl_Tree self, char const * path) -> Fl_Tree_Item
        find_item(Fl_Tree self, char const * path) -> Fl_Tree_Item
        """
        return _fltk.Fl_Tree_find_item(self, *args)


    def item_pathname(self, *args) -> "int":
        """item_pathname(Fl_Tree self, char * pathname, int pathnamelen, Fl_Tree_Item item) -> int"""
        return _fltk.Fl_Tree_item_pathname(self, *args)


    def find_clicked(self, *args) -> "Fl_Tree_Item *":
        """
        find_clicked(Fl_Tree self) -> Fl_Tree_Item
        find_clicked(Fl_Tree self) -> Fl_Tree_Item
        """
        return _fltk.Fl_Tree_find_clicked(self, *args)


    def item_clicked(self, *args) -> "Fl_Tree_Item *":
        """item_clicked(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_item_clicked(self, *args)


    def first(self, *args) -> "Fl_Tree_Item *":
        """first(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_first(self, *args)


    def first_visible(self, *args) -> "Fl_Tree_Item *":
        """first_visible(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_first_visible(self, *args)


    def first_visible_item(self, *args) -> "Fl_Tree_Item *":
        """first_visible_item(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_first_visible_item(self, *args)


    def next(self, *args) -> "Fl_Tree_Item *":
        """next(Fl_Tree self, Fl_Tree_Item item=None) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_next(self, *args)


    def prev(self, *args) -> "Fl_Tree_Item *":
        """prev(Fl_Tree self, Fl_Tree_Item item=None) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_prev(self, *args)


    def last(self, *args) -> "Fl_Tree_Item *":
        """last(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_last(self, *args)


    def last_visible(self, *args) -> "Fl_Tree_Item *":
        """last_visible(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_last_visible(self, *args)


    def last_visible_item(self, *args) -> "Fl_Tree_Item *":
        """last_visible_item(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_last_visible_item(self, *args)


    def first_selected_item(self, *args) -> "Fl_Tree_Item *":
        """first_selected_item(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_first_selected_item(self, *args)


    def last_selected_item(self, *args) -> "Fl_Tree_Item *":
        """last_selected_item(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_last_selected_item(self, *args)


    def next_item(self, *args) -> "Fl_Tree_Item *":
        """next_item(Fl_Tree self, Fl_Tree_Item item, int dir=0xff54, bool visible=False) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_next_item(self, *args)


    def next_selected_item(self, *args) -> "Fl_Tree_Item *":
        """
        next_selected_item(Fl_Tree self, Fl_Tree_Item item=None) -> Fl_Tree_Item
        next_selected_item(Fl_Tree self, Fl_Tree_Item item, int dir) -> Fl_Tree_Item
        """
        return _fltk.Fl_Tree_next_selected_item(self, *args)


    def open(self, *args) -> "int":
        """
        open(Fl_Tree self, Fl_Tree_Item item, int docallback=1) -> int
        open(Fl_Tree self, char const * path, int docallback=1) -> int
        """
        return _fltk.Fl_Tree_open(self, *args)


    def open_toggle(self, *args) -> "void":
        """open_toggle(Fl_Tree self, Fl_Tree_Item item, int docallback=1)"""
        return _fltk.Fl_Tree_open_toggle(self, *args)


    def close(self, *args) -> "int":
        """
        close(Fl_Tree self, Fl_Tree_Item item, int docallback=1) -> int
        close(Fl_Tree self, char const * path, int docallback=1) -> int
        """
        return _fltk.Fl_Tree_close(self, *args)


    def is_open(self, *args) -> "int":
        """
        is_open(Fl_Tree self, Fl_Tree_Item item) -> int
        is_open(Fl_Tree self, char const * path) -> int
        """
        return _fltk.Fl_Tree_is_open(self, *args)


    def is_close(self, *args) -> "int":
        """
        is_close(Fl_Tree self, Fl_Tree_Item item) -> int
        is_close(Fl_Tree self, char const * path) -> int
        """
        return _fltk.Fl_Tree_is_close(self, *args)


    def select(self, *args) -> "int":
        """
        select(Fl_Tree self, Fl_Tree_Item item, int docallback=1) -> int
        select(Fl_Tree self, char const * path, int docallback=1) -> int
        """
        return _fltk.Fl_Tree_select(self, *args)


    def select_toggle(self, *args) -> "void":
        """select_toggle(Fl_Tree self, Fl_Tree_Item item, int docallback=1)"""
        return _fltk.Fl_Tree_select_toggle(self, *args)


    def deselect(self, *args) -> "int":
        """
        deselect(Fl_Tree self, Fl_Tree_Item item, int docallback=1) -> int
        deselect(Fl_Tree self, char const * path, int docallback=1) -> int
        """
        return _fltk.Fl_Tree_deselect(self, *args)


    def deselect_all(self, *args) -> "int":
        """deselect_all(Fl_Tree self, Fl_Tree_Item item=None, int docallback=1) -> int"""
        return _fltk.Fl_Tree_deselect_all(self, *args)


    def select_only(self, *args) -> "int":
        """select_only(Fl_Tree self, Fl_Tree_Item selitem, int docallback=1) -> int"""
        return _fltk.Fl_Tree_select_only(self, *args)


    def select_all(self, *args) -> "int":
        """select_all(Fl_Tree self, Fl_Tree_Item item=None, int docallback=1) -> int"""
        return _fltk.Fl_Tree_select_all(self, *args)


    def extend_selection_dir(self, *args) -> "int":
        """extend_selection_dir(Fl_Tree self, Fl_Tree_Item arg2, Fl_Tree_Item to, int dir, int val, bool visible) -> int"""
        return _fltk.Fl_Tree_extend_selection_dir(self, *args)


    def set_item_focus(self, *args) -> "void":
        """set_item_focus(Fl_Tree self, Fl_Tree_Item item)"""
        return _fltk.Fl_Tree_set_item_focus(self, *args)


    def get_item_focus(self, *args) -> "Fl_Tree_Item *":
        """get_item_focus(Fl_Tree self) -> Fl_Tree_Item"""
        return _fltk.Fl_Tree_get_item_focus(self, *args)


    def is_selected(self, *args) -> "int":
        """
        is_selected(Fl_Tree self, Fl_Tree_Item item) -> int
        is_selected(Fl_Tree self, char const * path) -> int
        """
        return _fltk.Fl_Tree_is_selected(self, *args)


    def item_labelfont(self, *args) -> "void":
        """
        item_labelfont(Fl_Tree self) -> Fl_Font
        item_labelfont(Fl_Tree self, Fl_Font val)
        """
        return _fltk.Fl_Tree_item_labelfont(self, *args)


    def item_labelsize(self, *args) -> "void":
        """
        item_labelsize(Fl_Tree self) -> Fl_Fontsize
        item_labelsize(Fl_Tree self, Fl_Fontsize val)
        """
        return _fltk.Fl_Tree_item_labelsize(self, *args)


    def item_labelfgcolor(self, *args) -> "void":
        """
        item_labelfgcolor(Fl_Tree self) -> Fl_Color
        item_labelfgcolor(Fl_Tree self, Fl_Color val)
        """
        return _fltk.Fl_Tree_item_labelfgcolor(self, *args)


    def item_labelbgcolor(self, *args) -> "void":
        """
        item_labelbgcolor(Fl_Tree self) -> Fl_Color
        item_labelbgcolor(Fl_Tree self, Fl_Color val)
        """
        return _fltk.Fl_Tree_item_labelbgcolor(self, *args)


    def connectorcolor(self, *args) -> "void":
        """
        connectorcolor(Fl_Tree self) -> Fl_Color
        connectorcolor(Fl_Tree self, Fl_Color val)
        """
        return _fltk.Fl_Tree_connectorcolor(self, *args)


    def marginleft(self, *args) -> "void":
        """
        marginleft(Fl_Tree self) -> int
        marginleft(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_marginleft(self, *args)


    def margintop(self, *args) -> "void":
        """
        margintop(Fl_Tree self) -> int
        margintop(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_margintop(self, *args)


    def linespacing(self, *args) -> "void":
        """
        linespacing(Fl_Tree self) -> int
        linespacing(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_linespacing(self, *args)


    def openchild_marginbottom(self, *args) -> "void":
        """
        openchild_marginbottom(Fl_Tree self) -> int
        openchild_marginbottom(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_openchild_marginbottom(self, *args)


    def usericonmarginleft(self, *args) -> "void":
        """
        usericonmarginleft(Fl_Tree self) -> int
        usericonmarginleft(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_usericonmarginleft(self, *args)


    def labelmarginleft(self, *args) -> "void":
        """
        labelmarginleft(Fl_Tree self) -> int
        labelmarginleft(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_labelmarginleft(self, *args)


    def connectorwidth(self, *args) -> "void":
        """
        connectorwidth(Fl_Tree self) -> int
        connectorwidth(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_connectorwidth(self, *args)


    def usericon(self, *args) -> "void":
        """
        usericon(Fl_Tree self) -> Fl_Image
        usericon(Fl_Tree self, Fl_Image val)
        """
        return _fltk.Fl_Tree_usericon(self, *args)


    def openicon(self, *args) -> "void":
        """
        openicon(Fl_Tree self) -> Fl_Image
        openicon(Fl_Tree self, Fl_Image val)
        """
        return _fltk.Fl_Tree_openicon(self, *args)


    def closeicon(self, *args) -> "void":
        """
        closeicon(Fl_Tree self) -> Fl_Image
        closeicon(Fl_Tree self, Fl_Image val)
        """
        return _fltk.Fl_Tree_closeicon(self, *args)


    def showcollapse(self, *args) -> "void":
        """
        showcollapse(Fl_Tree self) -> int
        showcollapse(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_showcollapse(self, *args)


    def showroot(self, *args) -> "void":
        """
        showroot(Fl_Tree self) -> int
        showroot(Fl_Tree self, int val)
        """
        return _fltk.Fl_Tree_showroot(self, *args)


    def connectorstyle(self, *args) -> "void":
        """
        connectorstyle(Fl_Tree self) -> Fl_Tree_Connector
        connectorstyle(Fl_Tree self, Fl_Tree_Connector val)
        """
        return _fltk.Fl_Tree_connectorstyle(self, *args)


    def sortorder(self, *args) -> "void":
        """
        sortorder(Fl_Tree self) -> Fl_Tree_Sort
        sortorder(Fl_Tree self, Fl_Tree_Sort val)
        """
        return _fltk.Fl_Tree_sortorder(self, *args)


    def selectbox(self, *args) -> "void":
        """
        selectbox(Fl_Tree self) -> Fl_Boxtype
        selectbox(Fl_Tree self, Fl_Boxtype val)
        """
        return _fltk.Fl_Tree_selectbox(self, *args)


    def selectmode(self, *args) -> "void":
        """
        selectmode(Fl_Tree self) -> Fl_Tree_Select
        selectmode(Fl_Tree self, Fl_Tree_Select val)
        """
        return _fltk.Fl_Tree_selectmode(self, *args)


    def recalc_tree(self, *args) -> "void":
        """recalc_tree(Fl_Tree self)"""
        return _fltk.Fl_Tree_recalc_tree(self, *args)


    def displayed(self, *args) -> "int":
        """displayed(Fl_Tree self, Fl_Tree_Item item) -> int"""
        return _fltk.Fl_Tree_displayed(self, *args)


    def show_item(self, *args) -> "void":
        """
        show_item(Fl_Tree self, Fl_Tree_Item item, int yoff)
        show_item(Fl_Tree self, Fl_Tree_Item item)
        """
        return _fltk.Fl_Tree_show_item(self, *args)


    def show_item_top(self, *args) -> "void":
        """show_item_top(Fl_Tree self, Fl_Tree_Item item)"""
        return _fltk.Fl_Tree_show_item_top(self, *args)


    def show_item_middle(self, *args) -> "void":
        """show_item_middle(Fl_Tree self, Fl_Tree_Item item)"""
        return _fltk.Fl_Tree_show_item_middle(self, *args)


    def show_item_bottom(self, *args) -> "void":
        """show_item_bottom(Fl_Tree self, Fl_Tree_Item item)"""
        return _fltk.Fl_Tree_show_item_bottom(self, *args)


    def display(self, *args) -> "void":
        """display(Fl_Tree self, Fl_Tree_Item item)"""
        return _fltk.Fl_Tree_display(self, *args)


    def vposition(self, *args) -> "void":
        """
        vposition(Fl_Tree self) -> int
        vposition(Fl_Tree self, int pos)
        """
        return _fltk.Fl_Tree_vposition(self, *args)


    def hposition(self, *args) -> "void":
        """
        hposition(Fl_Tree self) -> int
        hposition(Fl_Tree self, int pos)
        """
        return _fltk.Fl_Tree_hposition(self, *args)


    def is_scrollbar(self, *args) -> "int":
        """is_scrollbar(Fl_Tree self, Fl_Widget w) -> int"""
        return _fltk.Fl_Tree_is_scrollbar(self, *args)


    def scrollbar_size(self, *args) -> "void":
        """
        scrollbar_size(Fl_Tree self) -> int
        scrollbar_size(Fl_Tree self, int size)
        """
        return _fltk.Fl_Tree_scrollbar_size(self, *args)


    def is_vscroll_visible(self, *args) -> "int":
        """is_vscroll_visible(Fl_Tree self) -> int"""
        return _fltk.Fl_Tree_is_vscroll_visible(self, *args)


    def is_hscroll_visible(self, *args) -> "int":
        """is_hscroll_visible(Fl_Tree self) -> int"""
        return _fltk.Fl_Tree_is_hscroll_visible(self, *args)


    def callback_item(self, *args) -> "Fl_Tree_Item *":
        """
        callback_item(Fl_Tree self, Fl_Tree_Item item)
        callback_item(Fl_Tree self) -> Fl_Tree_Item
        """
        return _fltk.Fl_Tree_callback_item(self, *args)


    def callback_reason(self, *args) -> "Fl_Tree_Reason":
        """
        callback_reason(Fl_Tree self, Fl_Tree_Reason reason)
        callback_reason(Fl_Tree self) -> Fl_Tree_Reason
        """
        return _fltk.Fl_Tree_callback_reason(self, *args)


    def load(self, *args) -> "void":
        """load(Fl_Tree self, Fl_Preferences arg2)"""
        return _fltk.Fl_Tree_load(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Tree(self)
        return weakref_proxy(self)
Fl_Tree_swigregister = _fltk.Fl_Tree_swigregister
Fl_Tree_swigregister(Fl_Tree)

NO_PAGE_FORMATS = _fltk.NO_PAGE_FORMATS
class Fl_Paged_Device(object):
    """

    Represents page-structured drawing surfaces.

    This class has no public constructor: don't instantiate it; use Fl_Printer 
    or Fl_PostScript_File_Device instead.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    A0 = _fltk.Fl_Paged_Device_A0
    A1 = _fltk.Fl_Paged_Device_A1
    A2 = _fltk.Fl_Paged_Device_A2
    A3 = _fltk.Fl_Paged_Device_A3
    A4 = _fltk.Fl_Paged_Device_A4
    A5 = _fltk.Fl_Paged_Device_A5
    A6 = _fltk.Fl_Paged_Device_A6
    A7 = _fltk.Fl_Paged_Device_A7
    A8 = _fltk.Fl_Paged_Device_A8
    A9 = _fltk.Fl_Paged_Device_A9
    B0 = _fltk.Fl_Paged_Device_B0
    B1 = _fltk.Fl_Paged_Device_B1
    B2 = _fltk.Fl_Paged_Device_B2
    B3 = _fltk.Fl_Paged_Device_B3
    B4 = _fltk.Fl_Paged_Device_B4
    B5 = _fltk.Fl_Paged_Device_B5
    B6 = _fltk.Fl_Paged_Device_B6
    B7 = _fltk.Fl_Paged_Device_B7
    B8 = _fltk.Fl_Paged_Device_B8
    B9 = _fltk.Fl_Paged_Device_B9
    B10 = _fltk.Fl_Paged_Device_B10
    C5E = _fltk.Fl_Paged_Device_C5E
    DLE = _fltk.Fl_Paged_Device_DLE
    EXECUTIVE = _fltk.Fl_Paged_Device_EXECUTIVE
    FOLIO = _fltk.Fl_Paged_Device_FOLIO
    LEDGER = _fltk.Fl_Paged_Device_LEDGER
    LEGAL = _fltk.Fl_Paged_Device_LEGAL
    LETTER = _fltk.Fl_Paged_Device_LETTER
    TABLOID = _fltk.Fl_Paged_Device_TABLOID
    ENVELOPE = _fltk.Fl_Paged_Device_ENVELOPE
    MEDIA = _fltk.Fl_Paged_Device_MEDIA
    PORTRAIT = _fltk.Fl_Paged_Device_PORTRAIT
    LANDSCAPE = _fltk.Fl_Paged_Device_LANDSCAPE
    REVERSED = _fltk.Fl_Paged_Device_REVERSED
    ORIENTATION = _fltk.Fl_Paged_Device_ORIENTATION

    def __init__(self, *args):
        """__init__(Fl_Paged_Device self) -> Fl_Paged_Device"""
        if self.__class__ == Fl_Paged_Device:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Paged_Device(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def class_name(self, *args) -> "char const *":
        """class_name(Fl_Paged_Device self) -> char const *"""
        return _fltk.Fl_Paged_Device_class_name(self, *args)


    def start_job(self, *args) -> "int":
        """start_job(Fl_Paged_Device self, int pagecount, int * frompage=None, int * topage=None) -> int"""
        return _fltk.Fl_Paged_Device_start_job(self, *args)


    def start_page(self, *args) -> "int":
        """start_page(Fl_Paged_Device self) -> int"""
        return _fltk.Fl_Paged_Device_start_page(self, *args)


    def printable_rect(self, *args) -> "int":
        """printable_rect(Fl_Paged_Device self, int * w, int * h) -> int"""
        return _fltk.Fl_Paged_Device_printable_rect(self, *args)


    def margins(self, *args) -> "void":
        """margins(Fl_Paged_Device self, int * left, int * top, int * right, int * bottom)"""
        return _fltk.Fl_Paged_Device_margins(self, *args)


    def origin(self, *args) -> "void":
        """
        origin(Fl_Paged_Device self, int x, int y)
        origin(Fl_Paged_Device self, int * x, int * y)
        """
        return _fltk.Fl_Paged_Device_origin(self, *args)


    def scale(self, *args) -> "void":
        """scale(Fl_Paged_Device self, float scale_x, float scale_y=0.)"""
        return _fltk.Fl_Paged_Device_scale(self, *args)


    def rotate(self, *args) -> "void":
        """rotate(Fl_Paged_Device self, float angle)"""
        return _fltk.Fl_Paged_Device_rotate(self, *args)


    def translate(self, *args) -> "void":
        """translate(Fl_Paged_Device self, int x, int y)"""
        return _fltk.Fl_Paged_Device_translate(self, *args)


    def untranslate(self, *args) -> "void":
        """untranslate(Fl_Paged_Device self)"""
        return _fltk.Fl_Paged_Device_untranslate(self, *args)


    def print_widget(self, *args) -> "void":
        """print_widget(Fl_Paged_Device self, Fl_Widget widget, int delta_x=0, int delta_y=0)"""
        return _fltk.Fl_Paged_Device_print_widget(self, *args)


    def print_window(self, *args) -> "void":
        """print_window(Fl_Paged_Device self, Fl_Window win, int x_offset=0, int y_offset=0)"""
        return _fltk.Fl_Paged_Device_print_window(self, *args)


    def print_window_part(self, *args) -> "void":
        """print_window_part(Fl_Paged_Device self, Fl_Window win, int x, int y, int w, int h, int delta_x=0, int delta_y=0)"""
        return _fltk.Fl_Paged_Device_print_window_part(self, *args)


    def end_page(self, *args) -> "int":
        """end_page(Fl_Paged_Device self) -> int"""
        return _fltk.Fl_Paged_Device_end_page(self, *args)


    def end_job(self, *args) -> "void":
        """end_job(Fl_Paged_Device self)"""
        return _fltk.Fl_Paged_Device_end_job(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Paged_Device(self)
        return weakref_proxy(self)
Fl_Paged_Device_swigregister = _fltk.Fl_Paged_Device_swigregister
Fl_Paged_Device_swigregister(Fl_Paged_Device)

class Fl_Printer(Fl_Paged_Device):
    """

    Declaration of classes Fl_Printer, Fl_System_Printer and Fl_PostScript_Printer.

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def class_name(self, *args) -> "char const *":
        """class_name(Fl_Printer self) -> char const *"""
        return _fltk.Fl_Printer_class_name(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Printer self) -> Fl_Printer"""
        if self.__class__ == Fl_Printer:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Printer(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def start_job(self, *args) -> "int":
        """start_job(Fl_Printer self, int pagecount, int * frompage=None, int * topage=None) -> int"""
        return _fltk.Fl_Printer_start_job(self, *args)


    def start_page(self, *args) -> "int":
        """start_page(Fl_Printer self) -> int"""
        return _fltk.Fl_Printer_start_page(self, *args)


    def printable_rect(self, *args) -> "int":
        """printable_rect(Fl_Printer self, int * w, int * h) -> int"""
        return _fltk.Fl_Printer_printable_rect(self, *args)


    def margins(self, *args) -> "void":
        """margins(Fl_Printer self, int * left, int * top, int * right, int * bottom)"""
        return _fltk.Fl_Printer_margins(self, *args)


    def origin(self, *args) -> "void":
        """
        origin(Fl_Printer self, int * x, int * y)
        origin(Fl_Printer self, int x, int y)
        """
        return _fltk.Fl_Printer_origin(self, *args)


    def scale(self, *args) -> "void":
        """scale(Fl_Printer self, float scale_x, float scale_y=0.)"""
        return _fltk.Fl_Printer_scale(self, *args)


    def rotate(self, *args) -> "void":
        """rotate(Fl_Printer self, float angle)"""
        return _fltk.Fl_Printer_rotate(self, *args)


    def translate(self, *args) -> "void":
        """translate(Fl_Printer self, int x, int y)"""
        return _fltk.Fl_Printer_translate(self, *args)


    def untranslate(self, *args) -> "void":
        """untranslate(Fl_Printer self)"""
        return _fltk.Fl_Printer_untranslate(self, *args)


    def end_page(self, *args) -> "int":
        """end_page(Fl_Printer self) -> int"""
        return _fltk.Fl_Printer_end_page(self, *args)


    def end_job(self, *args) -> "void":
        """end_job(Fl_Printer self)"""
        return _fltk.Fl_Printer_end_job(self, *args)


    def print_widget(self, *args) -> "void":
        """print_widget(Fl_Printer self, Fl_Widget widget, int delta_x=0, int delta_y=0)"""
        return _fltk.Fl_Printer_print_widget(self, *args)


    def print_window_part(self, *args) -> "void":
        """print_window_part(Fl_Printer self, Fl_Window win, int x, int y, int w, int h, int delta_x=0, int delta_y=0)"""
        return _fltk.Fl_Printer_print_window_part(self, *args)


    def set_current(self, *args) -> "void":
        """set_current(Fl_Printer self)"""
        return _fltk.Fl_Printer_set_current(self, *args)


    def driver(self, *args) -> "Fl_Graphics_Driver *":
        """driver(Fl_Printer self) -> Fl_Graphics_Driver *"""
        return _fltk.Fl_Printer_driver(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Printer
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Printer(self)
        return weakref_proxy(self)
Fl_Printer_swigregister = _fltk.Fl_Printer_swigregister
Fl_Printer_swigregister(Fl_Printer)


def fl_utf8bytes(*args) -> "int":
    """fl_utf8bytes(unsigned int ucs) -> int"""
    return _fltk.fl_utf8bytes(*args)

def fl_utf8len(*args) -> "int":
    """fl_utf8len(char c) -> int"""
    return _fltk.fl_utf8len(*args)

def fl_utf_nb_char(*args) -> "int":
    """fl_utf_nb_char(unsigned char const * buf, int len) -> int"""
    return _fltk.fl_utf_nb_char(*args)

def fl_utf8decode(*args) -> "unsigned int":
    """fl_utf8decode(char const * p, char const * end, int * len) -> unsigned int"""
    return _fltk.fl_utf8decode(*args)

def fl_utf8encode(*args) -> "char *":
    """fl_utf8encode(unsigned int ucs) -> int"""
    return _fltk.fl_utf8encode(*args)

def fl_utf8fwd(*args) -> "char const *":
    """fl_utf8fwd(char const * p, char const * start, char const * end) -> char const *"""
    return _fltk.fl_utf8fwd(*args)

def fl_utf8back(*args) -> "char const *":
    """fl_utf8back(char const * p, char const * start, char const * end) -> char const *"""
    return _fltk.fl_utf8back(*args)

def fl_utf8toUtf16(*args) -> "unsigned short *":
    """fl_utf8toUtf16(char const * src, unsigned int srclen, unsigned int dstlen) -> unsigned int"""
    return _fltk.fl_utf8toUtf16(*args)

def fl_utf8toa(*args) -> "char *":
    """fl_utf8toa(char const * src, unsigned int srclen, unsigned int arg4) -> unsigned int"""
    return _fltk.fl_utf8toa(*args)

def fl_utf8froma(*args) -> "unsigned int":
    """fl_utf8froma(char * dst, unsigned int dstlen, char const * src, unsigned int srclen) -> unsigned int"""
    return _fltk.fl_utf8froma(*args)

def fl_utf8locale(*args) -> "int":
    """fl_utf8locale() -> int"""
    return _fltk.fl_utf8locale(*args)

def fl_utf8test(*args) -> "int":
    """fl_utf8test(char const * src, unsigned int len) -> int"""
    return _fltk.fl_utf8test(*args)

def fl_nonspacing(*args) -> "unsigned int":
    """fl_nonspacing(unsigned int ucs) -> unsigned int"""
    return _fltk.fl_nonspacing(*args)

def fl_utf8to_mb(*args) -> "unsigned int":
    """fl_utf8to_mb(char const * src, unsigned int srclen, char * dst, unsigned int dstlen) -> unsigned int"""
    return _fltk.fl_utf8to_mb(*args)

def fl_utf2mbcs(*args) -> "char *":
    """fl_utf2mbcs(char const * src) -> char *"""
    return _fltk.fl_utf2mbcs(*args)

def fl_utf8from_mb(*args) -> "unsigned int":
    """fl_utf8from_mb(char * dst, unsigned int dstlen, char const * src, unsigned int srclen) -> unsigned int"""
    return _fltk.fl_utf8from_mb(*args)

def fl_utf_strncasecmp(*args) -> "int":
    """fl_utf_strncasecmp(char const * s1, char const * s2, int n) -> int"""
    return _fltk.fl_utf_strncasecmp(*args)

def fl_utf_strcasecmp(*args) -> "int":
    """fl_utf_strcasecmp(char const * s1, char const * s2) -> int"""
    return _fltk.fl_utf_strcasecmp(*args)

def fl_tolower(*args) -> "int":
    """fl_tolower(unsigned int ucs) -> int"""
    return _fltk.fl_tolower(*args)

def fl_toupper(*args) -> "int":
    """fl_toupper(unsigned int ucs) -> int"""
    return _fltk.fl_toupper(*args)

def fl_utf_tolower(*args) -> "char *":
    """fl_utf_tolower(unsigned char const * str, int len) -> int"""
    return _fltk.fl_utf_tolower(*args)

def fl_utf_toupper(*args) -> "int":
    """fl_utf_toupper(unsigned char const * str, int len, char * buf) -> int"""
    return _fltk.fl_utf_toupper(*args)

def fl_chmod(*args) -> "int":
    """fl_chmod(char const * f, int mode) -> int"""
    return _fltk.fl_chmod(*args)

def fl_access(*args) -> "int":
    """fl_access(char const * f, int mode) -> int"""
    return _fltk.fl_access(*args)

def fl_getcwd(*args) -> "char *":
    """fl_getcwd(char * buf, int maxlen) -> char *"""
    return _fltk.fl_getcwd(*args)

def fl_fopen(*args) -> "FILE *":
    """fl_fopen(char const * f, char const * mode) -> FILE *"""
    return _fltk.fl_fopen(*args)

def fl_system(*args) -> "int":
    """fl_system(char const * f) -> int"""
    return _fltk.fl_system(*args)

def fl_execvp(*args) -> "int":
    """fl_execvp(char const * file, char *const * argv) -> int"""
    return _fltk.fl_execvp(*args)

def fl_open(*args) -> "int":
    """fl_open(char const * f, int o) -> int"""
    return _fltk.fl_open(*args)

def fl_unlink(*args) -> "int":
    """fl_unlink(char const * f) -> int"""
    return _fltk.fl_unlink(*args)

def fl_rmdir(*args) -> "int":
    """fl_rmdir(char const * f) -> int"""
    return _fltk.fl_rmdir(*args)

def fl_getenv(*args) -> "char *":
    """fl_getenv(char const * name) -> char *"""
    return _fltk.fl_getenv(*args)

def fl_mkdir(*args) -> "int":
    """fl_mkdir(char const * f, int mode) -> int"""
    return _fltk.fl_mkdir(*args)

def fl_rename(*args) -> "int":
    """fl_rename(char const * f, char const * t) -> int"""
    return _fltk.fl_rename(*args)

def fl_make_path_for_file(*args) -> "void":
    """fl_make_path_for_file(char const * path)"""
    return _fltk.fl_make_path_for_file(*args)

def fl_make_path(*args) -> "char":
    """fl_make_path(char const * path) -> char"""
    return _fltk.fl_make_path(*args)

def upCB(*args) -> "void":
    """upCB(Fl_Widget v, void * arg2)"""
    return _fltk.upCB(*args)

def downCB(*args) -> "void":
    """downCB(Fl_Widget v, void * arg2)"""
    return _fltk.downCB(*args)

def toggleCB(*args) -> "void":
    """toggleCB(Fl_Widget v, void * arg2)"""
    return _fltk.toggleCB(*args)
class ListSelect(Fl_Group):
    """Proxy of C++ ListSelect class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(ListSelect self, int x, int y, int w, int h, char * topLabel=None, char * bottomLabel=None) -> ListSelect"""
        if self.__class__ == ListSelect:
            _self = None
        else:
            _self = self
        this = _fltk.new_ListSelect(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()




    def getTopBrowser(self, *args) -> "Fl_Multi_Browser *":
        """getTopBrowser(ListSelect self) -> Fl_Multi_Browser"""
        return _fltk.ListSelect_getTopBrowser(self, *args)


    def getBottomBrowser(self, *args) -> "Fl_Multi_Browser *":
        """getBottomBrowser(ListSelect self) -> Fl_Multi_Browser"""
        return _fltk.ListSelect_getBottomBrowser(self, *args)


    def resize(self, *args) -> "void":
        """resize(ListSelect self, int x, int y, int w, int h)"""
        return _fltk.ListSelect_resize(self, *args)

    __swig_destroy__ = _fltk.delete_ListSelect
    __del__ = lambda self: None
    def __disown__(self):
        self.this.disown()
        _fltk.disown_ListSelect(self)
        return weakref_proxy(self)

    def draw(self, *args) -> "void":
        """draw(ListSelect self)"""
        return _fltk.ListSelect_draw(self, *args)

ListSelect_swigregister = _fltk.ListSelect_swigregister
ListSelect_swigregister(ListSelect)

class Fl_Table(Fl_Group):
    """

    This is the base class for table widgets. (eg. Fl_Table_Row). To be useful it must be subclassed and several virtual functions defined. Normally applications use widgets derived from this widget, and do not use this widget directly; this widget is usually too low level to be used directly by applications.

    This widget does not handle the data in the table. The draw_cell() method must be overridden by a subclass to manage drawing the contents of the cells.

    This widget can be used in several ways:

        * As a custom widget; see testtablerow.cxx. Very optimal for even extremely large tables.

        * As a table made up of a single FLTK widget instanced all over the table; see singleinput.cxx. Very optimal for even extremely large tables;

        * As a regular container of FLTK widgets, one widget per cell. See widgettable.cxx. Not recommended for large tables.

    When acting as part of a custom widget, events on the cells and/or headings generate callbacks when they are clicked by the user. You control when events are generated based on the setting for Fl_Table::when().

    When acting as a container for FLTK widgets, the FLTK widgets maintain themselves. Although the draw_cell() method must be overridden, its contents can be very simple. See the draw_cell() code in widgettable.cxx. 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    CONTEXT_NONE = _fltk.Fl_Table_CONTEXT_NONE
    CONTEXT_STARTPAGE = _fltk.Fl_Table_CONTEXT_STARTPAGE
    CONTEXT_ENDPAGE = _fltk.Fl_Table_CONTEXT_ENDPAGE
    CONTEXT_ROW_HEADER = _fltk.Fl_Table_CONTEXT_ROW_HEADER
    CONTEXT_COL_HEADER = _fltk.Fl_Table_CONTEXT_COL_HEADER
    CONTEXT_CELL = _fltk.Fl_Table_CONTEXT_CELL
    CONTEXT_TABLE = _fltk.Fl_Table_CONTEXT_TABLE
    CONTEXT_RC_RESIZE = _fltk.Fl_Table_CONTEXT_RC_RESIZE

    def handle(self, *args) -> "int":
        """handle(Fl_Table self, int e) -> int"""
        return _fltk.Fl_Table_handle(self, *args)


    def draw_cell(self, *args) -> "void":
        """draw_cell(Fl_Table self, Fl_Table::TableContext context, int R=0, int C=0, int X=0, int Y=0, int W=0, int H=0)"""
        return _fltk.Fl_Table_draw_cell(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Table self, int X, int Y, int W, int H, char const * l=None) -> Fl_Table"""
        if self.__class__ == Fl_Table:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Table(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Table
    __del__ = lambda self: None

    def clear(self, *args) -> "void":
        """clear(Fl_Table self)"""
        return _fltk.Fl_Table_clear(self, *args)


    def table_box(self, *args) -> "Fl_Boxtype":
        """
        table_box(Fl_Table self, Fl_Boxtype val)
        table_box(Fl_Table self) -> Fl_Boxtype
        """
        return _fltk.Fl_Table_table_box(self, *args)


    def rows(self, *args) -> "int":
        """
        rows(Fl_Table self, int val)
        rows(Fl_Table self) -> int
        """
        return _fltk.Fl_Table_rows(self, *args)


    def cols(self, *args) -> "int":
        """
        cols(Fl_Table self, int val)
        cols(Fl_Table self) -> int
        """
        return _fltk.Fl_Table_cols(self, *args)


    def visible_cells(self, *args) -> "void":
        """visible_cells(Fl_Table self)"""
        return _fltk.Fl_Table_visible_cells(self, *args)


    def is_interactive_resize(self, *args) -> "int":
        """is_interactive_resize(Fl_Table self) -> int"""
        return _fltk.Fl_Table_is_interactive_resize(self, *args)


    def row_resize(self, *args) -> "void":
        """
        row_resize(Fl_Table self) -> int
        row_resize(Fl_Table self, int flag)
        """
        return _fltk.Fl_Table_row_resize(self, *args)


    def col_resize(self, *args) -> "void":
        """
        col_resize(Fl_Table self) -> int
        col_resize(Fl_Table self, int flag)
        """
        return _fltk.Fl_Table_col_resize(self, *args)


    def col_resize_min(self, *args) -> "void":
        """
        col_resize_min(Fl_Table self) -> int
        col_resize_min(Fl_Table self, int val)
        """
        return _fltk.Fl_Table_col_resize_min(self, *args)


    def row_resize_min(self, *args) -> "void":
        """
        row_resize_min(Fl_Table self) -> int
        row_resize_min(Fl_Table self, int val)
        """
        return _fltk.Fl_Table_row_resize_min(self, *args)


    def row_header(self, *args) -> "void":
        """
        row_header(Fl_Table self) -> int
        row_header(Fl_Table self, int flag)
        """
        return _fltk.Fl_Table_row_header(self, *args)


    def col_header(self, *args) -> "void":
        """
        col_header(Fl_Table self) -> int
        col_header(Fl_Table self, int flag)
        """
        return _fltk.Fl_Table_col_header(self, *args)


    def col_header_height(self, *args) -> "int":
        """
        col_header_height(Fl_Table self, int height)
        col_header_height(Fl_Table self) -> int
        """
        return _fltk.Fl_Table_col_header_height(self, *args)


    def row_header_width(self, *args) -> "int":
        """
        row_header_width(Fl_Table self, int width)
        row_header_width(Fl_Table self) -> int
        """
        return _fltk.Fl_Table_row_header_width(self, *args)


    def row_header_color(self, *args) -> "Fl_Color":
        """
        row_header_color(Fl_Table self, Fl_Color val)
        row_header_color(Fl_Table self) -> Fl_Color
        """
        return _fltk.Fl_Table_row_header_color(self, *args)


    def col_header_color(self, *args) -> "Fl_Color":
        """
        col_header_color(Fl_Table self, Fl_Color val)
        col_header_color(Fl_Table self) -> Fl_Color
        """
        return _fltk.Fl_Table_col_header_color(self, *args)


    def row_height(self, *args) -> "int":
        """
        row_height(Fl_Table self, int row, int height)
        row_height(Fl_Table self, int row) -> int
        """
        return _fltk.Fl_Table_row_height(self, *args)


    def col_width(self, *args) -> "int":
        """
        col_width(Fl_Table self, int col, int width)
        col_width(Fl_Table self, int col) -> int
        """
        return _fltk.Fl_Table_col_width(self, *args)


    def row_height_all(self, *args) -> "void":
        """row_height_all(Fl_Table self, int height)"""
        return _fltk.Fl_Table_row_height_all(self, *args)


    def col_width_all(self, *args) -> "void":
        """col_width_all(Fl_Table self, int width)"""
        return _fltk.Fl_Table_col_width_all(self, *args)


    def row_position(self, *args) -> "int":
        """
        row_position(Fl_Table self, int row)
        row_position(Fl_Table self) -> int
        """
        return _fltk.Fl_Table_row_position(self, *args)


    def col_position(self, *args) -> "int":
        """
        col_position(Fl_Table self, int col)
        col_position(Fl_Table self) -> int
        """
        return _fltk.Fl_Table_col_position(self, *args)


    def top_row(self, *args) -> "int":
        """
        top_row(Fl_Table self, int row)
        top_row(Fl_Table self) -> int
        """
        return _fltk.Fl_Table_top_row(self, *args)


    def is_selected(self, *args) -> "int":
        """is_selected(Fl_Table self, int r, int c) -> int"""
        return _fltk.Fl_Table_is_selected(self, *args)


    def get_selection(self, *args) -> "void":
        """get_selection(Fl_Table self)"""
        return _fltk.Fl_Table_get_selection(self, *args)


    def set_selection(self, *args) -> "void":
        """set_selection(Fl_Table self, int row_top, int col_left, int row_bot, int col_right)"""
        return _fltk.Fl_Table_set_selection(self, *args)


    def move_cursor(self, *args) -> "int":
        """
        move_cursor(Fl_Table self, int R, int C, int shiftselect) -> int
        move_cursor(Fl_Table self, int R, int C) -> int
        """
        return _fltk.Fl_Table_move_cursor(self, *args)


    def resize(self, *args) -> "void":
        """resize(Fl_Table self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Table_resize(self, *args)


    def draw(self, *args) -> "void":
        """draw(Fl_Table self)"""
        return _fltk.Fl_Table_draw(self, *args)


    def init_sizes(self, *args) -> "void":
        """init_sizes(Fl_Table self)"""
        return _fltk.Fl_Table_init_sizes(self, *args)


    def add(self, *args) -> "void":
        """add(Fl_Table self, Fl_Widget wgt)"""
        val = _fltk.Fl_Table_add(self, *args)

        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val


    def insert(self, *args) -> "void":
        """insert(Fl_Table self, Fl_Widget wgt, int n)"""
        return _fltk.Fl_Table_insert(self, *args)


    def insert_before(self, *args) -> "void":
        """insert_before(Fl_Table self, Fl_Widget wgt, Fl_Widget w2)"""
        return _fltk.Fl_Table_insert_before(self, *args)


    def begin(self, *args) -> "void":
        """begin(Fl_Table self)"""
        return _fltk.Fl_Table_begin(self, *args)


    def end(self, *args) -> "void":
        """end(Fl_Table self)"""
        return _fltk.Fl_Table_end(self, *args)


    def child(self, *args) -> "Fl_Widget *":
        """child(Fl_Table self, int n) -> Fl_Widget"""
        return _fltk.Fl_Table_child(self, *args)


    def children(self, *args) -> "int":
        """children(Fl_Table self) -> int"""
        return _fltk.Fl_Table_children(self, *args)


    def find(self, *args) -> "int":
        """find(Fl_Table self, Fl_Widget wgt) -> int"""
        return _fltk.Fl_Table_find(self, *args)


    def callback_row(self, *args) -> "int":
        """callback_row(Fl_Table self) -> int"""
        return _fltk.Fl_Table_callback_row(self, *args)


    def callback_col(self, *args) -> "int":
        """callback_col(Fl_Table self) -> int"""
        return _fltk.Fl_Table_callback_col(self, *args)


    def callback_context(self, *args) -> "Fl_Table::TableContext":
        """callback_context(Fl_Table self) -> Fl_Table::TableContext"""
        return _fltk.Fl_Table_callback_context(self, *args)


    def do_callback(self, *args) -> "void":
        """do_callback(Fl_Table self, Fl_Table::TableContext context, int row, int col)"""
        return _fltk.Fl_Table_do_callback(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Table(self)
        return weakref_proxy(self)
Fl_Table_swigregister = _fltk.Fl_Table_swigregister
Fl_Table_swigregister(Fl_Table)

class Fl_Table_Row(Fl_Table):
    """

    This class implements a simple table of rows and columns that specializes in the selection of rows. This widget is similar in behavior to a 'mail subject browser', similar to that found in mozilla, netscape and outlook mail browsers.

    Most methods of importance will be found in the Fl_Table widget, such as rows() and cols().

    To be useful it must be subclassed and at minimum the draw_cell() method must be overridden to provide the content of the cells. This widget does not manage the cell's data content; it is up to the parent class's draw_cell() method override to provide this.

    Events on the cells and/or headings generate callbacks when they are clicked by the user. You control when events are generated based on the values you supply for when(). 

    """

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    SELECT_NONE = _fltk.Fl_Table_Row_SELECT_NONE
    SELECT_SINGLE = _fltk.Fl_Table_Row_SELECT_SINGLE
    SELECT_MULTI = _fltk.Fl_Table_Row_SELECT_MULTI

    def handle(self, *args) -> "int":
        """handle(Fl_Table_Row self, int event) -> int"""
        return _fltk.Fl_Table_Row_handle(self, *args)


    def __init__(self, *args):
        """__init__(Fl_Table_Row self, int X, int Y, int W, int H, char const * l=None) -> Fl_Table_Row"""
        if self.__class__ == Fl_Table_Row:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Table_Row(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if len(args) == 5:          
        #retain reference to label
            self.my_label = args[-1]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Table_Row
    __del__ = lambda self: None

    def rows(self, *args) -> "int":
        """
        rows(Fl_Table_Row self, int val)
        rows(Fl_Table_Row self) -> int
        """
        return _fltk.Fl_Table_Row_rows(self, *args)


    def type(self, *args) -> "Fl_Table_Row::TableRowSelectMode":
        """
        type(Fl_Table_Row self, Fl_Table_Row::TableRowSelectMode val)
        type(Fl_Table_Row self) -> Fl_Table_Row::TableRowSelectMode
        """
        return _fltk.Fl_Table_Row_type(self, *args)


    def row_selected(self, *args) -> "int":
        """row_selected(Fl_Table_Row self, int row) -> int"""
        return _fltk.Fl_Table_Row_row_selected(self, *args)


    def select_row(self, *args) -> "int":
        """select_row(Fl_Table_Row self, int row, int flag=1) -> int"""
        return _fltk.Fl_Table_Row_select_row(self, *args)


    def select_all_rows(self, *args) -> "void":
        """select_all_rows(Fl_Table_Row self, int flag=1)"""
        return _fltk.Fl_Table_Row_select_all_rows(self, *args)


    def clear(self, *args) -> "void":
        """clear(Fl_Table_Row self)"""
        return _fltk.Fl_Table_Row_clear(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Table_Row(self)
        return weakref_proxy(self)

    def draw_cell(self, *args) -> "void":
        """draw_cell(Fl_Table_Row self, Fl_Table::TableContext context, int R=0, int C=0, int X=0, int Y=0, int W=0, int H=0)"""
        return _fltk.Fl_Table_Row_draw_cell(self, *args)

Fl_Table_Row_swigregister = _fltk.Fl_Table_Row_swigregister
Fl_Table_Row_swigregister(Fl_Table_Row)


def glLoadIdentity(*args) -> "void":
    """glLoadIdentity()"""
    return _fltk.glLoadIdentity(*args)

def glViewport(*args) -> "void":
    """glViewport(int x, int y, int width, int height)"""
    return _fltk.glViewport(*args)

def glClear(*args) -> "void":
    """glClear(int mask)"""
    return _fltk.glClear(*args)

def glColor3f(*args) -> "void":
    """glColor3f(float red, float green, float blue)"""
    return _fltk.glColor3f(*args)

def glBegin(*args) -> "void":
    """glBegin(int mode)"""
    return _fltk.glBegin(*args)

def glEnd(*args) -> "void":
    """glEnd()"""
    return _fltk.glEnd(*args)

def glVertex3f(*args) -> "void":
    """glVertex3f(float x, float y, float z)"""
    return _fltk.glVertex3f(*args)
M_PI = _fltk.M_PI
M_PI_2 = _fltk.M_PI_2
M_PI_4 = _fltk.M_PI_4
M_1_PI = _fltk.M_1_PI
M_2_PI = _fltk.M_2_PI
M_SQRT2 = _fltk.M_SQRT2
M_SQRT1_2 = _fltk.M_SQRT1_2

__idleCallbacks = []
def Fl_add_idle( func, data=None):
    __idleCallbacks.append( (func, data) )
    if len(__idleCallbacks) == 1:
        pyFLTK_controlIdleCallbacks(1)

def Fl_remove_idle( func, data=None):
    for cb in __idleCallbacks:
        if cb == ( func, data ):
            __idleCallbacks.remove(cb)
            break

def pyFLTK_doIdleCallbacks():
    for cb in __idleCallbacks:
        cb[0](cb[1])

pyFLTK_registerDoIdle(pyFLTK_doIdleCallbacks)


Fl.add_idle = staticmethod(Fl_add_idle)
Fl.remove_idle = staticmethod(Fl_remove_idle)




# override the implementation of Fl_Widget.callback
# new version to be used with directors
def __Fl_WidgetCallback(self,*args):
        if len(args) == 1:
            new_args = (self, args[0], self)
        else:
            new_args = (self, args[0], self, args[1])
#return apply(_fltk.Fl_Widget_callback,new_args)
        return _fltk.Fl_Widget_callback(*new_args)

Fl_Widget.callback = __Fl_WidgetCallback
# end of the Fl_Widget.callback wrapper


# override the implementation of Fl_Text_Buffer.add_modify_callback
def __Fl_Text_BufferAddModifyCallback(self,*args):
        if len(args) == 1:
            new_args = (self, args[0])
        else:
            new_args = (self, args[0], args[1])
#return apply(_fltk.Fl_Text_Buffer_add_modify_callback,new_args)
        return _fltk.Fl_Text_Buffer_add_modify_callback(*new_args)

Fl_Text_Buffer.add_modify_callback = __Fl_Text_BufferAddModifyCallback
# end of the Fl_Text_Buffer.add_modify_callback wrapper


# override the implementation of Fl_Text_Buffer.remove_modify_callback
def __Fl_Text_BufferRemoveModifyCallback(self,*args):
        if len(args) == 1:
            new_args = (self, args[0], self)
        else:
            new_args = (self, args[0], self, args[1])
#return apply(_fltk.Fl_Text_Buffer_remove_modify_callback,new_args)
        return _fltk.Fl_Text_Buffer_remove_modify_callback(*new_args)

Fl_Text_Buffer.remove_modify_callback = __Fl_Text_BufferRemoveModifyCallback
# end of the Fl_Text_Buffer.remove_modify_callback wrapper


# override the implementation of Fl_File_Chooser.callback
def __Fl_File_ChooserCallback(self,*args):
        if len(args) == 1:
            new_args = (self, args[0], self)
        else:
            new_args = (self, args[0], self, args[1])
#return apply(_fltk.Fl_File_Chooser_callback,new_args)
        return _fltk.Fl_File_Chooser_callback(*new_args)

Fl_File_Chooser.callback = __Fl_File_ChooserCallback
# end of the Fl_File_Chooser.callback wrapper


# override the implementation of Fl_Help_View.link
def __Fl_Help_ViewLink(self,*args):
        if len(args) == 1:
            new_args = (self, args[0], self)
        else:
            new_args = (self, args[0], self, args[1])
#return apply(_fltk.Fl_Help_View_link,new_args)
        return _fltk.Fl_Help_View_link(*new_args)

Fl_Help_View.link = __Fl_Help_ViewLink
# end of the Fl_Help_View.link wrapper


Fl.add_timeout = staticmethod(Fl_add_timeout)
Fl.repeat_timeout = staticmethod(Fl_repeat_timeout)
Fl.remove_timeout = staticmethod(Fl_remove_timeout)
Fl.add_check = staticmethod(Fl_add_check)
Fl.remove_check = staticmethod(Fl_remove_check)
Fl.add_handler = staticmethod(Fl_add_handler)
Fl.remove_handler = staticmethod(Fl_remove_handler)
Fl.add_fd = staticmethod(Fl_add_fd)
Fl.remove_fd = staticmethod(Fl_remove_fd)
Fl.get_font_sizes = staticmethod(Fl_get_font_sizes_tmp)


setMenu = _fltk.setMenu

