import { TerraformModule } from 'cdktf';
import { Construct } from 'constructs';
export interface TerraformAwsModulesEcsAwsOptions {
    /**
     * List of short names of one or more capacity providers to associate with the cluster. Valid values also include FARGATE and FARGATE_SPOT.
     * @default
     */
    readonly capacityProviders?: string[];
    /**
     * Controls if ECS Cluster has container insights enabled
     */
    readonly containerInsights?: boolean;
    /**
     * Controls if ECS should be created
     * @default true
     */
    readonly createEcs?: boolean;
    /**
     * The capacity provider strategy to use by default for the cluster. Can be one or more.
     * @default
     */
    readonly defaultCapacityProviderStrategy?: {
        [key: string]: any;
    }[];
    /**
     * Name to be used on all the resources as identifier, also the name of the ECS cluster
     */
    readonly name?: string;
    /**
     * A map of tags to add to ECS Cluster
     * @default [object Object]
     */
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class TerraformAwsModulesEcsAws extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, options?: TerraformAwsModulesEcsAwsOptions);
    get capacityProviders(): string[] | undefined;
    set capacityProviders(value: string[] | undefined);
    get containerInsights(): boolean | undefined;
    set containerInsights(value: boolean | undefined);
    get createEcs(): boolean | undefined;
    set createEcs(value: boolean | undefined);
    get defaultCapacityProviderStrategy(): {
        [key: string]: any;
    }[] | undefined;
    set defaultCapacityProviderStrategy(value: {
        [key: string]: any;
    }[] | undefined);
    get name(): string | undefined;
    set name(value: string | undefined);
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get ecsClusterArnOutput(): string;
    get ecsClusterIdOutput(): string;
    get ecsClusterNameOutput(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
