import { ServiceSelection } from './serviceSelection';
export * from './cliContext';
export * from './cliContextEnvironmentProvider';
export * from './cliEnvironmentProvider';
export * from './feature-flags';
export * from './jsonUtilities';
export * from './jsonValidationError';
export * from './serviceSelection';
export * from './state-manager';
export * from './tags';
export * from './errors';
export * from './exitOnNextTick';
export * from './isPackaged';
export * from './cliConstants';
export * from './deploymentSecretsHelper';
export * from './deploymentState';
export declare type $TSAny = any;
export declare type $TSContext = {
    amplify: AmplifyToolkit;
    print: $TSAny;
    migrationInfo: $TSAny;
    projectHasMobileHubResources: boolean;
    prompt: $TSAny;
    exeInfo: $TSAny;
    input: $TSAny;
    parameters: $TSAny;
    usageData: $TSAny;
    runtime: $TSAny;
    pluginPlatform: IPluginPlatform;
};
export declare type IPluginPlatform = {
    pluginDirectories: string[];
    pluginPrefixes: string[];
    userAddedLocations: string[];
    lastScanTime: Date;
    maxScanIntervalInSeconds: Number;
    plugins: IPluginCollection;
    excluded: IPluginCollection;
};
export declare type IPluginCollection = {
    [pluginType: string]: IPluginInfo[];
};
export declare type IPluginInfo = {
    packageName: string;
    packageVersion: string;
    packageLocation: string;
    manifest: $IPluginManifest;
};
export declare type DeploymentSecrets = {
    appSecrets: Array<{
        rootStackId: string;
        environments: {
            [env: string]: {
                [category: string]: {
                    [resourceName: string]: {
                        [key: string]: string;
                    };
                };
            };
        };
    }>;
};
export declare type GetPackageAssetPaths = () => Promise<string[]>;
export declare type $IPluginManifest = $TSAny;
export declare type $TSMeta = any;
export declare type $TSTeamProviderInfo = any;
export declare type $TSObject = Record<string, $TSAny>;
export declare enum AmplifyFrontend {
    android = "android",
    ios = "ios",
    javascript = "javascript"
}
export interface AmplifyProjectConfig {
    projectName: string;
    version: string;
    frontend: AmplifyFrontend;
    providers: string[];
}
interface AmplifyToolkit {
    buildResources: () => $TSAny;
    confirmPrompt: (prompt: string, defaultValue?: boolean) => $TSAny;
    constants: $TSAny;
    constructExeInfo: () => $TSAny;
    copyBatch: () => $TSAny;
    crudFlow: () => $TSAny;
    deleteProject: () => $TSAny;
    executeProviderUtils: () => $TSAny;
    getAllEnvs: () => $TSAny;
    getPlugin: () => $TSAny;
    getCategoryPluginInfo: (context: $TSContext, category?: string, service?: string) => $TSAny;
    getAllCategoryPluginInfo: (context: $TSContext) => $TSAny;
    getFrontendPlugins: () => $TSAny;
    getEnvDetails: () => $TSAny;
    getEnvInfo: () => $TSAny;
    getProviderPlugins: (context: $TSContext) => $TSAny;
    getPluginInstance: () => $TSAny;
    getProjectConfig: () => $TSAny;
    getProjectDetails: () => $TSAny;
    getProjectMeta: () => $TSMeta;
    getResourceStatus: (category?: $TSAny, resourceName?: $TSAny, providerName?: $TSAny, filteredResources?: $TSAny) => $TSAny;
    getResourceOutputs: () => $TSAny;
    getWhen: () => $TSAny;
    inputValidation: (input: $TSAny) => $TSAny;
    listCategories: () => $TSAny;
    makeId: () => $TSAny;
    openEditor: () => $TSAny;
    onCategoryOutputsChange: (context: $TSContext, currentAmplifyMeta: $TSMeta | undefined, amplifyMeta?: $TSMeta) => $TSAny;
    pathManager: () => $TSAny;
    pressEnterToContinue: () => $TSAny;
    pushResources: () => $TSAny;
    storeCurrentCloudBackend: () => $TSAny;
    readJsonFile: () => $TSAny;
    removeEnvFromCloud: () => $TSAny;
    removeResource: () => $TSAny;
    sharedQuestions: () => $TSAny;
    showAllHelp: () => $TSAny;
    showHelp: () => $TSAny;
    showHelpfulProviderLinks: () => $TSAny;
    showResourceTable: () => $TSAny;
    serviceSelectionPrompt: (context: $TSContext, category: string, servicesMetadata: $TSAny, customQuestion?: $TSAny, optionNameOverrides?: Record<string, string>) => Promise<ServiceSelection>;
    updateProjectConfig: () => $TSAny;
    updateamplifyMetaAfterResourceUpdate: (category: string, resourceName: string, metaResourceKey?: $TSAny, metaResourceData?: $TSAny) => $TSAny;
    updateamplifyMetaAfterResourceAdd: (category: string, resourceName: string, metaResourceData: $TSAny, backendResourceData?: $TSAny, overwriteObjectIfExists?: boolean) => $TSAny;
    updateamplifyMetaAfterResourceDelete: () => $TSAny;
    updateProvideramplifyMeta: () => $TSAny;
    updateamplifyMetaAfterPush: () => $TSAny;
    updateamplifyMetaAfterBuild: () => $TSAny;
    updateAmplifyMetaAfterPackage: () => $TSAny;
    updateBackendConfigAfterResourceAdd: (category: string, resourceName: string, resourceData: $TSAny) => $TSAny;
    updateBackendConfigAfterResourceUpdate: () => $TSAny;
    updateBackendConfigAfterResourceRemove: () => $TSAny;
    loadEnvResourceParameters: (context: $TSContext, category: string, resourceName: string) => $TSAny;
    saveEnvResourceParameters: (context: $TSContext, category: string, resourceName: string, envSpecificParams: $TSObject) => $TSAny;
    removeResourceParameters: () => $TSAny;
    triggerFlow: () => $TSAny;
    addTrigger: () => $TSAny;
    updateTrigger: () => $TSAny;
    deleteTrigger: () => $TSAny;
    deleteAllTriggers: () => $TSAny;
    deleteDeselectedTriggers: () => $TSAny;
    dependsOnBlock: () => $TSAny;
    getTriggerMetadata: () => $TSAny;
    getTriggerPermissions: () => $TSAny;
    getTriggerEnvVariables: () => $TSAny;
    getTriggerEnvInputs: () => $TSAny;
    getUserPoolGroupList: () => $TSAny;
    forceRemoveResource: () => $TSAny;
    writeObjectAsJson: () => $TSAny;
    hashDir: () => $TSAny;
    leaveBreadcrumbs: () => $TSAny;
    readBreadcrumbs: () => $TSAny;
    loadRuntimePlugin: () => $TSAny;
    getImportedAuthProperties: (context: $TSContext) => {
        imported: boolean;
        userPoolId?: string;
        authRoleArn?: string;
        authRoleName?: string;
        unauthRoleArn?: string;
        unauthRoleName?: string;
    };
    invokePluginMethod: <T>(context: $TSContext, category: string, service: string | null, method: string, args: any[]) => Promise<T>;
}
//# sourceMappingURL=index.d.ts.map