from typing import Any, Dict, List, Sequence, Union

PY3: Any
str_type = str
GRAPH_ATTRIBUTES: Any
EDGE_ATTRIBUTES: Any
NODE_ATTRIBUTES: Any
CLUSTER_ATTRIBUTES: Any
DEFAULT_PROGRAMS: Any

def is_windows() -> bool: ...
def is_anaconda() -> bool: ...
def get_executable_extension() -> str: ...
def graph_from_dot_data(s: str) -> List["Dot"]: ...

class Common:
    def set_parent_graph(self, parent_graph: "Graph") -> None: ...
    def get_parent_graph(self) -> "Graph": ...
    def set(self, name: str, value: str) -> None: ...
    def get(self, name: str) -> str: ...
    def get_attributes(self) -> Dict[str, str]: ...
    def set_sequence(self, seq: str) -> None: ...
    def get_sequence(self) -> str: ...
    def create_attribute_methods(self, obj_attributes: List[str]) -> None: ...

class Error(Exception):
    value: Any
    def __init__(self, value: str) -> None: ...

class InvocationException(Exception):
    value: Any
    def __init__(self, value: str) -> None: ...

class Node(Common):
    obj_dict: Any
    def __init__(
        self, name: str = ..., obj_dict: Any | None = ..., **attrs: str
    ) -> None: ...
    def set_name(self, node_name: str) -> None: ...
    def get_name(self) -> str: ...
    def get_port(self) -> str: ...
    def add_style(self, style: str) -> None: ...
    def to_string(self) -> str: ...

class Edge(Common):
    obj_dict: Any
    def __init__(
        self,
        src: str = ...,
        dst: str = ...,
        obj_dict: Any | None = ...,
        **attrs: Dict[str, str]
    ) -> None: ...
    def get_source(self) -> str: ...
    def get_destination(self) -> str: ...
    def __hash__(self) -> int: ...
    def __eq__(self, edge: Any) -> bool: ...
    def parse_node_ref(self, node_str: str) -> str: ...
    def to_string(self) -> str: ...

class Graph(Common):
    obj_dict: Any
    def __init__(
        self,
        graph_name: str = ...,
        obj_dict: Any | None = ...,
        graph_type: str = ...,
        strict: bool = ...,
        suppress_disconnected: bool = ...,
        simplify: bool = ...,
        **attrs: Dict[str, str]
    ) -> None: ...
    def get_graph_type(self) -> str: ...
    def get_top_graph_type(self) -> str: ...
    def set_graph_defaults(self, **attrs: Dict[str, str]) -> None: ...
    def get_graph_defaults(self, **attrs: Dict[str, str]) -> Dict[str, str]: ...
    def set_node_defaults(self, **attrs: Dict[str, str]) -> None: ...
    def get_node_defaults(self, **attrs: Dict[str, str]) -> Dict[str, str]: ...
    def set_edge_defaults(self, **attrs: Dict[str, str]) -> None: ...
    def get_edge_defaults(self, **attrs: Dict[str, str]) -> Dict[str, str]: ...
    def set_simplify(self, simplify: bool) -> None: ...
    def get_simplify(self) -> bool: ...
    def set_type(self, graph_type: str) -> None: ...
    def get_type(self) -> str: ...
    def set_name(self, graph_name: str) -> None: ...
    def get_name(self) -> str: ...
    def set_strict(self, val: bool) -> None: ...
    def get_strict(self, val: Any) -> bool: ...
    def set_suppress_disconnected(self, val: bool) -> None: ...
    def get_suppress_disconnected(self, val: Any) -> None: ...
    def get_next_sequence_number(self) -> int: ...
    def add_node(self, graph_node: Node) -> None: ...
    def del_node(self, name: Union[str, Node], index: int | None = ...) -> bool: ...
    def get_node(self, name: str) -> Node: ...
    def get_nodes(self) -> List[Node]: ...
    def get_node_list(self) -> List[Node]: ...
    def add_edge(self, graph_edge: Edge) -> None: ...
    def del_edge(
        self,
        src_or_list: Union[Sequence[Node], Node],
        dst: str | int | None = ...,
        index: int | None = ...,
    ) -> bool: ...
    def get_edge(
        self, src_or_list: Union[Sequence[Node], Node], dst: Any | None = ...
    ) -> List[Edge]: ...
    def get_edges(self) -> List[Edge]: ...
    def get_edge_list(self) -> List[Edge]: ...
    def add_subgraph(self, sgraph: Union["Subgraph", "Cluster"]) -> None: ...
    def get_subgraph(self, name: str) -> List["Subgraph"]: ...
    def get_subgraphs(self) -> List["Subgraph"]: ...
    def get_subgraph_list(self) -> List["Subgraph"]: ...
    def set_parent_graph(self, parent_graph: "Graph") -> None: ...
    def to_string(self) -> str: ...

class Subgraph(Graph):
    def __init__(
        self,
        graph_name: str = ...,
        obj_dict: Any | Dict[str, str] = ...,
        suppress_disconnected: bool = ...,
        simplify: bool = ...,
        **attrs: Dict[str, str]
    ) -> None: ...

class Cluster(Graph):
    def __init__(
        self,
        graph_name: str = ...,
        obj_dict: Any | Dict[str, str] = ...,
        suppress_disconnected: bool = ...,
        simplify: bool = ...,
        **attrs: Dict[str, str]
    ) -> None: ...

class Dot(Graph):
    shape_files: Any
    formats: Any
    prog: str
    def __init__(self, *argsl: Any, **argsd: Dict[str, str]): ...
    def set_shape_files(self, file_paths: Union[str, Sequence[str]]) -> None: ...
    def set_prog(self, prog: str) -> None: ...
    def write(
        self,
        path: str,
        prog: Any | str = ...,
        format: str = ...,
        encoding: Any | str = ...,
    ) -> bool: ...
    def create(
        self, prog: Any | str = ..., format: str = ..., encoding: Any | str = ...
    ) -> bytes: ...
