# coding: utf-8

"""
    Singlearity Baseball API

    Baseball optimization API using machine learning  # noqa: E501

    The version of the OpenAPI document: 0.1.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from singlearity.configuration import Configuration


class State(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'on_1b': 'bool',
        'on_2b': 'bool',
        'on_3b': 'bool',
        'inning': 'int',
        'outs': 'int',
        'top': 'bool',
        'bat_score': 'int',
        'fld_score': 'int',
        'bat_lineup_order': 'int',
        'fld_lineup_order': 'int',
        'pitch_number': 'int',
        'frame_runs_scored': 'int'
    }

    attribute_map = {
        'on_1b': 'on_1b',
        'on_2b': 'on_2b',
        'on_3b': 'on_3b',
        'inning': 'inning',
        'outs': 'outs',
        'top': 'top',
        'bat_score': 'bat_score',
        'fld_score': 'fld_score',
        'bat_lineup_order': 'bat_lineup_order',
        'fld_lineup_order': 'fld_lineup_order',
        'pitch_number': 'pitch_number',
        'frame_runs_scored': 'frame_runs_scored'
    }

    def __init__(self, on_1b=False, on_2b=False, on_3b=False, inning=1, outs=0, top=True, bat_score=0, fld_score=0, bat_lineup_order=1, fld_lineup_order=1, pitch_number=0, frame_runs_scored=0, local_vars_configuration=None):  # noqa: E501
        """State - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._on_1b = None
        self._on_2b = None
        self._on_3b = None
        self._inning = None
        self._outs = None
        self._top = None
        self._bat_score = None
        self._fld_score = None
        self._bat_lineup_order = None
        self._fld_lineup_order = None
        self._pitch_number = None
        self._frame_runs_scored = None
        self.discriminator = None

        if on_1b is not None:
            self.on_1b = on_1b
        if on_2b is not None:
            self.on_2b = on_2b
        if on_3b is not None:
            self.on_3b = on_3b
        if inning is not None:
            self.inning = inning
        if outs is not None:
            self.outs = outs
        if top is not None:
            self.top = top
        if bat_score is not None:
            self.bat_score = bat_score
        if fld_score is not None:
            self.fld_score = fld_score
        if bat_lineup_order is not None:
            self.bat_lineup_order = bat_lineup_order
        if fld_lineup_order is not None:
            self.fld_lineup_order = fld_lineup_order
        if pitch_number is not None:
            self.pitch_number = pitch_number
        if frame_runs_scored is not None:
            self.frame_runs_scored = frame_runs_scored

    @property
    def on_1b(self):
        """Gets the on_1b of this State.  # noqa: E501

        True iff there is a runner on 1st base.  # noqa: E501

        :return: The on_1b of this State.  # noqa: E501
        :rtype: bool
        """
        return self._on_1b

    @on_1b.setter
    def on_1b(self, on_1b):
        """Sets the on_1b of this State.

        True iff there is a runner on 1st base.  # noqa: E501

        :param on_1b: The on_1b of this State.  # noqa: E501
        :type: bool
        """

        self._on_1b = on_1b

    @property
    def on_2b(self):
        """Gets the on_2b of this State.  # noqa: E501

        True iff there is a runner on 2nd base.  # noqa: E501

        :return: The on_2b of this State.  # noqa: E501
        :rtype: bool
        """
        return self._on_2b

    @on_2b.setter
    def on_2b(self, on_2b):
        """Sets the on_2b of this State.

        True iff there is a runner on 2nd base.  # noqa: E501

        :param on_2b: The on_2b of this State.  # noqa: E501
        :type: bool
        """

        self._on_2b = on_2b

    @property
    def on_3b(self):
        """Gets the on_3b of this State.  # noqa: E501

        True iff there is a runner on 3rd base.  # noqa: E501

        :return: The on_3b of this State.  # noqa: E501
        :rtype: bool
        """
        return self._on_3b

    @on_3b.setter
    def on_3b(self, on_3b):
        """Sets the on_3b of this State.

        True iff there is a runner on 3rd base.  # noqa: E501

        :param on_3b: The on_3b of this State.  # noqa: E501
        :type: bool
        """

        self._on_3b = on_3b

    @property
    def inning(self):
        """Gets the inning of this State.  # noqa: E501


        :return: The inning of this State.  # noqa: E501
        :rtype: int
        """
        return self._inning

    @inning.setter
    def inning(self, inning):
        """Sets the inning of this State.


        :param inning: The inning of this State.  # noqa: E501
        :type: int
        """

        self._inning = inning

    @property
    def outs(self):
        """Gets the outs of this State.  # noqa: E501


        :return: The outs of this State.  # noqa: E501
        :rtype: int
        """
        return self._outs

    @outs.setter
    def outs(self, outs):
        """Sets the outs of this State.


        :param outs: The outs of this State.  # noqa: E501
        :type: int
        """

        self._outs = outs

    @property
    def top(self):
        """Gets the top of this State.  # noqa: E501

        True if in the top half of the inning.  # noqa: E501

        :return: The top of this State.  # noqa: E501
        :rtype: bool
        """
        return self._top

    @top.setter
    def top(self, top):
        """Sets the top of this State.

        True if in the top half of the inning.  # noqa: E501

        :param top: The top of this State.  # noqa: E501
        :type: bool
        """

        self._top = top

    @property
    def bat_score(self):
        """Gets the bat_score of this State.  # noqa: E501

        Batting team score  # noqa: E501

        :return: The bat_score of this State.  # noqa: E501
        :rtype: int
        """
        return self._bat_score

    @bat_score.setter
    def bat_score(self, bat_score):
        """Sets the bat_score of this State.

        Batting team score  # noqa: E501

        :param bat_score: The bat_score of this State.  # noqa: E501
        :type: int
        """

        self._bat_score = bat_score

    @property
    def fld_score(self):
        """Gets the fld_score of this State.  # noqa: E501

        Batting team score  # noqa: E501

        :return: The fld_score of this State.  # noqa: E501
        :rtype: int
        """
        return self._fld_score

    @fld_score.setter
    def fld_score(self, fld_score):
        """Sets the fld_score of this State.

        Batting team score  # noqa: E501

        :param fld_score: The fld_score of this State.  # noqa: E501
        :type: int
        """

        self._fld_score = fld_score

    @property
    def bat_lineup_order(self):
        """Gets the bat_lineup_order of this State.  # noqa: E501

        Lineup position (1-9) of the batting team.  Used only for game simulations  # noqa: E501

        :return: The bat_lineup_order of this State.  # noqa: E501
        :rtype: int
        """
        return self._bat_lineup_order

    @bat_lineup_order.setter
    def bat_lineup_order(self, bat_lineup_order):
        """Sets the bat_lineup_order of this State.

        Lineup position (1-9) of the batting team.  Used only for game simulations  # noqa: E501

        :param bat_lineup_order: The bat_lineup_order of this State.  # noqa: E501
        :type: int
        """

        self._bat_lineup_order = bat_lineup_order

    @property
    def fld_lineup_order(self):
        """Gets the fld_lineup_order of this State.  # noqa: E501

        Lineup position (1-9) of the batting team.  Used only for game simulations  # noqa: E501

        :return: The fld_lineup_order of this State.  # noqa: E501
        :rtype: int
        """
        return self._fld_lineup_order

    @fld_lineup_order.setter
    def fld_lineup_order(self, fld_lineup_order):
        """Sets the fld_lineup_order of this State.

        Lineup position (1-9) of the batting team.  Used only for game simulations  # noqa: E501

        :param fld_lineup_order: The fld_lineup_order of this State.  # noqa: E501
        :type: int
        """

        self._fld_lineup_order = fld_lineup_order

    @property
    def pitch_number(self):
        """Gets the pitch_number of this State.  # noqa: E501

        Current pitcher's pitch count at the beginning of the plate appearance  # noqa: E501

        :return: The pitch_number of this State.  # noqa: E501
        :rtype: int
        """
        return self._pitch_number

    @pitch_number.setter
    def pitch_number(self, pitch_number):
        """Sets the pitch_number of this State.

        Current pitcher's pitch count at the beginning of the plate appearance  # noqa: E501

        :param pitch_number: The pitch_number of this State.  # noqa: E501
        :type: int
        """

        self._pitch_number = pitch_number

    @property
    def frame_runs_scored(self):
        """Gets the frame_runs_scored of this State.  # noqa: E501

        Number of runs scored in the current half inning so far  # noqa: E501

        :return: The frame_runs_scored of this State.  # noqa: E501
        :rtype: int
        """
        return self._frame_runs_scored

    @frame_runs_scored.setter
    def frame_runs_scored(self, frame_runs_scored):
        """Sets the frame_runs_scored of this State.

        Number of runs scored in the current half inning so far  # noqa: E501

        :param frame_runs_scored: The frame_runs_scored of this State.  # noqa: E501
        :type: int
        """

        self._frame_runs_scored = frame_runs_scored

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, State):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, State):
            return True

        return self.to_dict() != other.to_dict()
