"""
    SCIM API

    Janssen SCIM 2.0 server API. Developers can think of SCIM as a REST API with endpoints exposing CRUD functionality (create, update, retrieve and delete) for identity management resources such as users, groups, and fido devices.   # noqa: E501

    The version of the OpenAPI document: 5.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pyscim.api_client import ApiClient, Endpoint as _Endpoint
from pyscim.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from pyscim.model.error_response import ErrorResponse
from pyscim.model.generic_list_response import GenericListResponse
from pyscim.model.search_request import SearchRequest


class GlobalSearchApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.search_resources_endpoint = _Endpoint(
            settings={
                "response_type": (GenericListResponse,),
                "auth": ["scim_oauth"],
                "endpoint_path": "/.search",
                "operation_id": "search_resources",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "search_request",
                ],
                "required": [
                    "search_request",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "search_request": (SearchRequest,),
                },
                "attribute_map": {},
                "location_map": {
                    "search_request": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/scim+json", "application/json"],
                "content_type": ["application/scim+json", "application/json"],
            },
            api_client=api_client,
        )

    def search_resources(self, search_request, **kwargs):
        """search_resources  # noqa: E501

        Search (from system root) for one or more resource (see section 3.4.3 of RFC 7644)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_resources(search_request, async_req=True)
        >>> result = thread.get()

        Args:
            search_request (SearchRequest): Payload that represents the search criteria

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GenericListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["search_request"] = search_request
        return self.search_resources_endpoint.call_with_http_info(**kwargs)
