# pyscim
Janssen SCIM 2.0 server API. Developers can think of SCIM as a REST API with endpoints exposing CRUD functionality
(create, update, retrieve and delete) for identity management resources such as users, groups, and fido devices.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 5.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pyscim
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pyscim
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import pyscim
from pprint import pprint
from pyscim.api import default_api
from pyscim.model.bulk_data import BulkData
from pyscim.model.bulk_request import BulkRequest
from pyscim.model.error_response import ErrorResponse
# Defining the host is optional and defaults to https://jenkins-ldap.jans.io/jans-scim/restv1/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = pyscim.Configuration(
    host = "https://jenkins-ldap.jans.io/jans-scim/restv1/v2"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: scim_oauth
configuration = pyscim.Configuration(
    host = "https://jenkins-ldap.jans.io/jans-scim/restv1/v2"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with pyscim.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    request = BulkRequest(None) # BulkRequest | Payload describing the operations to perform

    try:
        api_response = api_instance.bulk_post(request)
        pprint(api_response)
    except pyscim.ApiException as e:
        print("Exception when calling DefaultApi->bulk_post: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://jenkins-ldap.jans.io/jans-scim/restv1/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**bulk_post**](docs/DefaultApi.md#bulk_post) | **POST** /Bulk | 
*DiscoveryApi* | [**get_resource_type_by_id**](docs/DiscoveryApi.md#get_resource_type_by_id) | **GET** /ResourceTypes/{resource} | 
*DiscoveryApi* | [**get_resource_types**](docs/DiscoveryApi.md#get_resource_types) | **GET** /ResourceTypes | 
*DiscoveryApi* | [**get_schema_by_uri**](docs/DiscoveryApi.md#get_schema_by_uri) | **GET** /Schemas/{uri} | 
*DiscoveryApi* | [**get_schemas**](docs/DiscoveryApi.md#get_schemas) | **GET** /Schemas | 
*DiscoveryApi* | [**get_service_provider_config**](docs/DiscoveryApi.md#get_service_provider_config) | **GET** /ServiceProviderConfig | 
*Fido2DevicesApi* | [**delete_fido2_device_by_id**](docs/Fido2DevicesApi.md#delete_fido2_device_by_id) | **DELETE** /Fido2Devices/{id} | 
*Fido2DevicesApi* | [**get_fido2_device_by_id**](docs/Fido2DevicesApi.md#get_fido2_device_by_id) | **GET** /Fido2Devices/{id} | 
*Fido2DevicesApi* | [**get_fido2_devices**](docs/Fido2DevicesApi.md#get_fido2_devices) | **GET** /Fido2Devices | 
*Fido2DevicesApi* | [**search_fido2_device**](docs/Fido2DevicesApi.md#search_fido2_device) | **POST** /Fido2Devices/.search | 
*Fido2DevicesApi* | [**update_fido2_device_by_id**](docs/Fido2DevicesApi.md#update_fido2_device_by_id) | **PUT** /Fido2Devices/{id} | 
*FidoDevicesApi* | [**delete_fido_device_by_id**](docs/FidoDevicesApi.md#delete_fido_device_by_id) | **DELETE** /FidoDevices/{id} | 
*FidoDevicesApi* | [**get_fido_device_by_id**](docs/FidoDevicesApi.md#get_fido_device_by_id) | **GET** /FidoDevices/{id} | 
*FidoDevicesApi* | [**get_fido_devices**](docs/FidoDevicesApi.md#get_fido_devices) | **GET** /FidoDevices | 
*FidoDevicesApi* | [**search_fido_device**](docs/FidoDevicesApi.md#search_fido_device) | **POST** /FidoDevices/.search | 
*FidoDevicesApi* | [**update_fido_device_by_id**](docs/FidoDevicesApi.md#update_fido_device_by_id) | **PUT** /FidoDevices/{id} | 
*GlobalSearchApi* | [**search_resources**](docs/GlobalSearchApi.md#search_resources) | **POST** /.search | 
*GroupApi* | [**create_group**](docs/GroupApi.md#create_group) | **POST** /Groups | 
*GroupApi* | [**delete_group_by_id**](docs/GroupApi.md#delete_group_by_id) | **DELETE** /Groups/{id} | 
*GroupApi* | [**get_group_by_id**](docs/GroupApi.md#get_group_by_id) | **GET** /Groups/{id} | 
*GroupApi* | [**get_groups**](docs/GroupApi.md#get_groups) | **GET** /Groups | 
*GroupApi* | [**patch_group_by_id**](docs/GroupApi.md#patch_group_by_id) | **PATCH** /Groups/{id} | 
*GroupApi* | [**search_group**](docs/GroupApi.md#search_group) | **POST** /Groups/.search | 
*GroupApi* | [**update_group_by_id**](docs/GroupApi.md#update_group_by_id) | **PUT** /Groups/{id} | 
*UserApi* | [**create_user**](docs/UserApi.md#create_user) | **POST** /Users | 
*UserApi* | [**delete_user_by_id**](docs/UserApi.md#delete_user_by_id) | **DELETE** /Users/{id} | 
*UserApi* | [**get_user_by_id**](docs/UserApi.md#get_user_by_id) | **GET** /Users/{id} | 
*UserApi* | [**get_users**](docs/UserApi.md#get_users) | **GET** /Users | 
*UserApi* | [**patch_user_by_id**](docs/UserApi.md#patch_user_by_id) | **PATCH** /Users/{id} | 
*UserApi* | [**search_user**](docs/UserApi.md#search_user) | **POST** /Users/.search | 
*UserApi* | [**update_user_by_id**](docs/UserApi.md#update_user_by_id) | **PUT** /Users/{id} | 


## Documentation For Models

 - [Address](docs/Address.md)
 - [BaseResource](docs/BaseResource.md)
 - [BasicListResponse](docs/BasicListResponse.md)
 - [BulkData](docs/BulkData.md)
 - [BulkOperation](docs/BulkOperation.md)
 - [BulkRequest](docs/BulkRequest.md)
 - [BulkRequestAllOf](docs/BulkRequestAllOf.md)
 - [Email](docs/Email.md)
 - [Entitlement](docs/Entitlement.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [Fido2DeviceResource](docs/Fido2DeviceResource.md)
 - [Fido2DeviceResourceAllOf](docs/Fido2DeviceResourceAllOf.md)
 - [Fido2ListResponse](docs/Fido2ListResponse.md)
 - [Fido2ListResponseAllOf](docs/Fido2ListResponseAllOf.md)
 - [FidoDeviceResource](docs/FidoDeviceResource.md)
 - [FidoDeviceResourceAllOf](docs/FidoDeviceResourceAllOf.md)
 - [FidoListResponse](docs/FidoListResponse.md)
 - [FidoListResponseAllOf](docs/FidoListResponseAllOf.md)
 - [GenericListResponse](docs/GenericListResponse.md)
 - [GenericListResponseAllOf](docs/GenericListResponseAllOf.md)
 - [GenericResource](docs/GenericResource.md)
 - [Group](docs/Group.md)
 - [GroupListResponse](docs/GroupListResponse.md)
 - [GroupListResponseAllOf](docs/GroupListResponseAllOf.md)
 - [GroupResource](docs/GroupResource.md)
 - [GroupResourceAllOf](docs/GroupResourceAllOf.md)
 - [InstantMessagingAddress](docs/InstantMessagingAddress.md)
 - [Member](docs/Member.md)
 - [Meta](docs/Meta.md)
 - [Name](docs/Name.md)
 - [PatchOperation](docs/PatchOperation.md)
 - [PatchRequest](docs/PatchRequest.md)
 - [PhoneNumber](docs/PhoneNumber.md)
 - [Photo](docs/Photo.md)
 - [ResourceType](docs/ResourceType.md)
 - [ResourceTypeListResponse](docs/ResourceTypeListResponse.md)
 - [ResourceTypeListResponseAllOf](docs/ResourceTypeListResponseAllOf.md)
 - [ResourceTypeSchemaExtensions](docs/ResourceTypeSchemaExtensions.md)
 - [Role](docs/Role.md)
 - [SchemaAttribute](docs/SchemaAttribute.md)
 - [SchemaListResponse](docs/SchemaListResponse.md)
 - [SchemaListResponseAllOf](docs/SchemaListResponseAllOf.md)
 - [SchemaResource](docs/SchemaResource.md)
 - [SearchRequest](docs/SearchRequest.md)
 - [ServiceProviderConfigResponse](docs/ServiceProviderConfigResponse.md)
 - [ServiceProviderConfigResponseAuthenticationSchemes](docs/ServiceProviderConfigResponseAuthenticationSchemes.md)
 - [ServiceProviderConfigResponseBulk](docs/ServiceProviderConfigResponseBulk.md)
 - [ServiceProviderConfigResponseFilter](docs/ServiceProviderConfigResponseFilter.md)
 - [ServiceProviderConfigResponseMeta](docs/ServiceProviderConfigResponseMeta.md)
 - [ServiceProviderConfigResponsePatch](docs/ServiceProviderConfigResponsePatch.md)
 - [UserListResponse](docs/UserListResponse.md)
 - [UserListResponseAllOf](docs/UserListResponseAllOf.md)
 - [UserResource](docs/UserResource.md)
 - [UserResourceAllOf](docs/UserResourceAllOf.md)
 - [X509Certificate](docs/X509Certificate.md)


## Documentation For Authorization


## scim_oauth

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **https://jans.io/scim/users.read**: Query user resources
 - **https://jans.io/scim/users.write**: Modify user resources
 - **https://jans.io/scim/groups.read**: Query group resources
 - **https://jans.io/scim/groups.write**: Modify group resources
 - **https://jans.io/scim/fido.read**: Query fido resources
 - **https://jans.io/scim/fido.write**: Modify fido resources
 - **https://jans.io/scim/fido2.read**: Query fido 2 resources
 - **https://jans.io/scim/fido2.write**: Modify fido 2 resources
 - **https://jans.io/scim/all-resources.search**: Access the root .search endpoint
 - **https://jans.io/scim/bulk**: Send requests to the bulk endpoint


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in pyscim.apis and pyscim.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from pyscim.api.default_api import DefaultApi`
- `from pyscim.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import pyscim
from pyscim.apis import *
from pyscim.models import *
```

