"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmsSubscription = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sns = require("@aws-cdk/aws-sns");
/**
 * Use an sms address as a subscription target
 */
class SmsSubscription {
    constructor(phoneNumber, props = {}) {
        this.phoneNumber = phoneNumber;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_sns_subscriptions_SmsSubscriptionProps(props);
    }
    bind(_topic) {
        return {
            subscriberId: this.phoneNumber,
            endpoint: this.phoneNumber,
            protocol: sns.SubscriptionProtocol.SMS,
            filterPolicy: this.props.filterPolicy,
        };
    }
}
exports.SmsSubscription = SmsSubscription;
_a = JSII_RTTI_SYMBOL_1;
SmsSubscription[_a] = { fqn: "@aws-cdk/aws-sns-subscriptions.SmsSubscription", version: "1.150.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic21zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic21zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHdDQUF3QztBQVN4Qzs7R0FFRztBQUNILE1BQWEsZUFBZTtJQUMxQixZQUE2QixXQUFtQixFQUFtQixRQUE4QixFQUFFO1FBQXRFLGdCQUFXLEdBQVgsV0FBVyxDQUFRO1FBQW1CLFVBQUssR0FBTCxLQUFLLENBQTJCOztLQUNsRztJQUVNLElBQUksQ0FBQyxNQUFrQjtRQUM1QixPQUFPO1lBQ0wsWUFBWSxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzlCLFFBQVEsRUFBRSxJQUFJLENBQUMsV0FBVztZQUMxQixRQUFRLEVBQUUsR0FBRyxDQUFDLG9CQUFvQixDQUFDLEdBQUc7WUFDdEMsWUFBWSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWTtTQUN0QyxDQUFDO0tBQ0g7O0FBWEgsMENBWUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBzbnMgZnJvbSAnQGF3cy1jZGsvYXdzLXNucyc7XG5pbXBvcnQgeyBTdWJzY3JpcHRpb25Qcm9wcyB9IGZyb20gJy4vc3Vic2NyaXB0aW9uJztcblxuLyoqXG4gKiBPcHRpb25zIGZvciBTTVMgc3Vic2NyaXB0aW9ucy5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTbXNTdWJzY3JpcHRpb25Qcm9wcyBleHRlbmRzIFN1YnNjcmlwdGlvblByb3BzIHtcbn1cblxuLyoqXG4gKiBVc2UgYW4gc21zIGFkZHJlc3MgYXMgYSBzdWJzY3JpcHRpb24gdGFyZ2V0XG4gKi9cbmV4cG9ydCBjbGFzcyBTbXNTdWJzY3JpcHRpb24gaW1wbGVtZW50cyBzbnMuSVRvcGljU3Vic2NyaXB0aW9uIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBwaG9uZU51bWJlcjogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBTbXNTdWJzY3JpcHRpb25Qcm9wcyA9IHt9KSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChfdG9waWM6IHNucy5JVG9waWMpOiBzbnMuVG9waWNTdWJzY3JpcHRpb25Db25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBzdWJzY3JpYmVySWQ6IHRoaXMucGhvbmVOdW1iZXIsXG4gICAgICBlbmRwb2ludDogdGhpcy5waG9uZU51bWJlcixcbiAgICAgIHByb3RvY29sOiBzbnMuU3Vic2NyaXB0aW9uUHJvdG9jb2wuU01TLFxuICAgICAgZmlsdGVyUG9saWN5OiB0aGlzLnByb3BzLmZpbHRlclBvbGljeSxcbiAgICB9O1xuICB9XG59XG4iXX0=