# Generated by Django 3.1.4 on 2021-01-09 21:30

from django.db import migrations

# This does not use historical models, but the current version of Permission
# It might break if models change in the future.


def create_initial_permissions(apps, schema_editor):
    from django.contrib.auth.models import Group, Permission
    from django.contrib.contenttypes.models import ContentType

    group_content_type = ContentType.objects.get_for_model(Group)
    Permission.objects.create(
        name="Decide whether requested working hours should be granted",
        codename="decide_workinghours_for_group",
        content_type=group_content_type,
    )


class Migration(migrations.Migration):
    dependencies = [
        ("user_management", "0005_auto_20210106_2219"),
        ("guardian", "0001_initial"),
    ]

    operations = [
        migrations.RunPython(create_initial_permissions),
    ]
