# The Call for Participation Process

## Overview

The organisation of your conference programme starts with the Call for Participation/Proposals (CfP).
Before you announce your CfP, obvious things to consider are:

* what is the audience we are trying to address? Beginners, experts, ... also first-time speakers, diverse & underrepresented groups.
* what information do wee need to know about our speakers? Name, country, biography, affiliation, job & position, social media, on-site availability, ...
* what are the topics of interest for our conference? How are those tracks named? E.g. PyCon: Libraries, PyData: Machine Learning & Stats, ...
* what is the presentation format, i.e. session types? 30min, 45min talks (including 5min Q&A), 90min tutorials...
* should a financial aid program be offered? Check out the [Financial Aid Programme of PyconDE / PyData 2023 Berlin](https://2023.pycon.de/financial-aid/) for an example.
* what are the rough milestones/deadlines of the whole process? [See below for an example](#example-milestones-of-pyconde-pydata-2023-berlin).
* what is the deadline of the CfP? Do we want to extend it later on? Do we have enough time for the reviews?

An example CfP can be found on the [Call for Proposals of the PyConDE / PyData 2023 Berlin](https://2023.pycon.de/blog/call-for-proposals/).
The actual CfP submission is handled easily by [Pretalx] as you can just fill out everything in the web UI.
As these tasks are all purely organisational/conceptional, there is no need to use Pytanis for any of this.

## Example: Milestones of PyConDE / PyData 2023 Berlin

* **2022-12-11**: (Sunday) CfP opens
* **2022-12-14**: Financial Aid Program opens
* **2023-01-05**: (Thursday) -> Extension **2023-01-09** (Monday) CfP closes. \[Voting can be prepared beforehand via Pretalx.\]
* **2023-01-06**: (Friday) Open the Review for external Reviewers
* **2023-01-11**: Q&A session 1 for external reviewers, 30min at 5pm
* **2023-01-17**: Q&A session 2 for external reviewers, 30min at 5pm
* **2022-01-16**: Financial Aid Program closes (2 weeks to select)
* **2023-01-16**: Ticket sales opens
* **2023-01-16**: (Monday) till **2023-01-23** (Sunday) talk voting over [Pretalx] (1 week)
* **2023-01-31**: (Tuesday) deadline for external & internal reviewers
* **2023-02-13**: (Monday) acceptance notices to speakers
* **2023-02-14**: (Tuesday) publish list of accepted talks
* **2023-02-20**: Financial Aid applicants will be notified by e-mail about acceptance or rejection
* **2023-03-01**: (Wednesday) publish talk schedule via Pretalx
* **2022-03-07**: Ticket prices increase to switch to late bird pricing
* **2023-04-16**: Set-up-day, the night before the conference 🎉
* **2023-04-17**: (Monday) conference starts, we have a lift-off 🚀

!!! warning
    Obviously, you should never announce a CfP extension before the deadline of the original CfP is over 😜.
    It is also useful to keep some of the above deadlines internally to avoid receiving a lot of emails when you have missed the deadline 🙈.
