# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import List, Dict, Any
from ....utils.dt import to_json_decorator
from ....event.model.event import *
import attr




@to_json_decorator
@attr.s
class NotificationOption(object):
    channels = attr.ib(type=List[str], default=None, metadata={'json': 'channels'})
    language = attr.ib(type=str, default=None, metadata={'json': 'language'})


@to_json_decorator
@attr.s
class I18nContent(object):
    locale = attr.ib(type=str, default=None, metadata={'json': 'locale'})
    value = attr.ib(type=str, default=None, metadata={'json': 'value'})


@to_json_decorator
@attr.s
class EmployeeTypeEnum(object):
    __int_to_string_fields__ = attr.ib(type=List[str], default=["enum_value"])
    enum_id = attr.ib(type=str, default=None, metadata={'json': 'enum_id'})
    enum_value = attr.ib(type=int, default=None, metadata={'json': 'enum_value'})
    content = attr.ib(type=str, default=None, metadata={'json': 'content'})
    enum_type = attr.ib(type=int, default=None, metadata={'json': 'enum_type'})
    enum_status = attr.ib(type=int, default=None, metadata={'json': 'enum_status'})
    i18n_content = attr.ib(type=List[I18nContent], default=None, metadata={'json': 'i18n_content'})


@to_json_decorator
@attr.s
class UserStatus(object):
    is_frozen = attr.ib(type=bool, default=None, metadata={'json': 'is_frozen'})
    is_resigned = attr.ib(type=bool, default=None, metadata={'json': 'is_resigned'})
    is_activated = attr.ib(type=bool, default=None, metadata={'json': 'is_activated'})


@to_json_decorator
@attr.s
class UserPosition(object):
    position_code = attr.ib(type=str, default=None, metadata={'json': 'position_code'})
    position_name = attr.ib(type=str, default=None, metadata={'json': 'position_name'})
    department_id = attr.ib(type=str, default=None, metadata={'json': 'department_id'})
    leader_user_id = attr.ib(type=str, default=None, metadata={'json': 'leader_user_id'})
    leader_position_code = attr.ib(type=str, default=None, metadata={'json': 'leader_position_code'})
    is_major = attr.ib(type=bool, default=None, metadata={'json': 'is_major'})


@to_json_decorator
@attr.s
class UserOrder(object):
    department_id = attr.ib(type=str, default=None, metadata={'json': 'department_id'})
    user_order = attr.ib(type=int, default=None, metadata={'json': 'user_order'})
    department_order = attr.ib(type=int, default=None, metadata={'json': 'department_order'})


@to_json_decorator
@attr.s
class UserGroup(object):
    user_group_id = attr.ib(type=str, default=None, metadata={'json': 'user_group_id'})
    name = attr.ib(type=str, default=None, metadata={'json': 'name'})
    type = attr.ib(type=int, default=None, metadata={'json': 'type'})
    member_count = attr.ib(type=int, default=None, metadata={'json': 'member_count'})
    status = attr.ib(type=int, default=None, metadata={'json': 'status'})


@to_json_decorator
@attr.s
class UserCustomAttrValue(object):
    text = attr.ib(type=str, default=None, metadata={'json': 'text'})
    url = attr.ib(type=str, default=None, metadata={'json': 'url'})
    pc_url = attr.ib(type=str, default=None, metadata={'json': 'pc_url'})


@to_json_decorator
@attr.s
class UserCustomAttr(object):
    type = attr.ib(type=str, default=None, metadata={'json': 'type'})
    id = attr.ib(type=str, default=None, metadata={'json': 'id'})
    value = attr.ib(type=UserCustomAttrValue, default=None, metadata={'json': 'value'})


@to_json_decorator
@attr.s
class DepartmentStatus(object):
    is_deleted = attr.ib(type=bool, default=None, metadata={'json': 'is_deleted'})


@to_json_decorator
@attr.s
class OldDepartmentObject(object):
    status = attr.ib(type=DepartmentStatus, default=None, metadata={'json': 'status'})
    open_department_id = attr.ib(type=str, default=None, metadata={'json': 'open_department_id'})


@to_json_decorator
@attr.s
class DepartmentEvent(object):
    name = attr.ib(type=str, default=None, metadata={'json': 'name'})
    parent_department_id = attr.ib(type=str, default=None, metadata={'json': 'parent_department_id'})
    department_id = attr.ib(type=str, default=None, metadata={'json': 'department_id'})
    open_department_id = attr.ib(type=str, default=None, metadata={'json': 'open_department_id'})
    leader_user_id = attr.ib(type=str, default=None, metadata={'json': 'leader_user_id'})
    chat_id = attr.ib(type=str, default=None, metadata={'json': 'chat_id'})
    order = attr.ib(type=int, default=None, metadata={'json': 'order'})
    
    status = attr.ib(type=DepartmentStatus, default=None, metadata={'json': 'status'})


@to_json_decorator
@attr.s
class DepartmentI18nName(object):
    zh_cn = attr.ib(type=str, default=None, metadata={'json': 'zh_cn'})
    ja_jp = attr.ib(type=str, default=None, metadata={'json': 'ja_jp'})
    en_us = attr.ib(type=str, default=None, metadata={'json': 'en_us'})


@to_json_decorator
@attr.s
class Department(object):
    __int_to_string_fields__ = attr.ib(type=List[str], default=["order"])
    name = attr.ib(type=str, default=None, metadata={'json': 'name'})
    i18n_name = attr.ib(type=DepartmentI18nName, default=None, metadata={'json': 'i18n_name'})
    parent_department_id = attr.ib(type=str, default=None, metadata={'json': 'parent_department_id'})
    department_id = attr.ib(type=str, default=None, metadata={'json': 'department_id'})
    open_department_id = attr.ib(type=str, default=None, metadata={'json': 'open_department_id'})
    leader_user_id = attr.ib(type=str, default=None, metadata={'json': 'leader_user_id'})
    chat_id = attr.ib(type=str, default=None, metadata={'json': 'chat_id'})
    order = attr.ib(type=int, default=None, metadata={'json': 'order'})
    unit_ids = attr.ib(type=List[str], default=None, metadata={'json': 'unit_ids'})
    member_count = attr.ib(type=int, default=None, metadata={'json': 'member_count'})
    status = attr.ib(type=DepartmentStatus, default=None, metadata={'json': 'status'})
    create_group_chat = attr.ib(type=bool, default=None, metadata={'json': 'create_group_chat'})


@to_json_decorator
@attr.s
class AvatarInfo(object):
    avatar_72 = attr.ib(type=str, default=None, metadata={'json': 'avatar_72'})
    avatar_240 = attr.ib(type=str, default=None, metadata={'json': 'avatar_240'})
    avatar_640 = attr.ib(type=str, default=None, metadata={'json': 'avatar_640'})
    avatar_origin = attr.ib(type=str, default=None, metadata={'json': 'avatar_origin'})


@to_json_decorator
@attr.s
class User(object):
    union_id = attr.ib(type=str, default=None, metadata={'json': 'union_id'})
    user_id = attr.ib(type=str, default=None, metadata={'json': 'user_id'})
    open_id = attr.ib(type=str, default=None, metadata={'json': 'open_id'})
    name = attr.ib(type=str, default=None, metadata={'json': 'name'})
    en_name = attr.ib(type=str, default=None, metadata={'json': 'en_name'})
    email = attr.ib(type=str, default=None, metadata={'json': 'email'})
    mobile = attr.ib(type=str, default=None, metadata={'json': 'mobile'})
    mobile_visible = attr.ib(type=bool, default=None, metadata={'json': 'mobile_visible'})
    gender = attr.ib(type=int, default=None, metadata={'json': 'gender'})
    avatar_key = attr.ib(type=str, default=None, metadata={'json': 'avatar_key'})
    avatar = attr.ib(type=AvatarInfo, default=None, metadata={'json': 'avatar'})
    status = attr.ib(type=UserStatus, default=None, metadata={'json': 'status'})
    department_ids = attr.ib(type=List[str], default=None, metadata={'json': 'department_ids'})
    leader_user_id = attr.ib(type=str, default=None, metadata={'json': 'leader_user_id'})
    city = attr.ib(type=str, default=None, metadata={'json': 'city'})
    country = attr.ib(type=str, default=None, metadata={'json': 'country'})
    work_station = attr.ib(type=str, default=None, metadata={'json': 'work_station'})
    join_time = attr.ib(type=int, default=None, metadata={'json': 'join_time'})
    is_tenant_manager = attr.ib(type=bool, default=None, metadata={'json': 'is_tenant_manager'})
    employee_no = attr.ib(type=str, default=None, metadata={'json': 'employee_no'})
    employee_type = attr.ib(type=int, default=None, metadata={'json': 'employee_type'})
    
    orders = attr.ib(type=List[UserOrder], default=None, metadata={'json': 'orders'})
    custom_attrs = attr.ib(type=List[UserCustomAttr], default=None, metadata={'json': 'custom_attrs'})
    enterprise_email = attr.ib(type=str, default=None, metadata={'json': 'enterprise_email'})
    
    
    
    job_title = attr.ib(type=str, default=None, metadata={'json': 'job_title'})
    need_send_notification = attr.ib(type=bool, default=None, metadata={'json': 'need_send_notification'})
    notification_option = attr.ib(type=NotificationOption, default=None, metadata={'json': 'notification_option'})
    is_frozen = attr.ib(type=bool, default=None, metadata={'json': 'is_frozen'})


@to_json_decorator
@attr.s
class Scope(object):
    departments = attr.ib(type=List[Department], default=None, metadata={'json': 'departments'})
    users = attr.ib(type=List[User], default=None, metadata={'json': 'users'})
    user_groups = attr.ib(type=List[UserGroup], default=None, metadata={'json': 'user_groups'})


@to_json_decorator
@attr.s
class UserEvent(object):
    open_id = attr.ib(type=str, default=None, metadata={'json': 'open_id'})
    user_id = attr.ib(type=str, default=None, metadata={'json': 'user_id'})
    name = attr.ib(type=str, default=None, metadata={'json': 'name'})
    en_name = attr.ib(type=str, default=None, metadata={'json': 'en_name'})
    email = attr.ib(type=str, default=None, metadata={'json': 'email'})
    mobile = attr.ib(type=str, default=None, metadata={'json': 'mobile'})
    
    gender = attr.ib(type=int, default=None, metadata={'json': 'gender'})
    avatar = attr.ib(type=AvatarInfo, default=None, metadata={'json': 'avatar'})
    status = attr.ib(type=UserStatus, default=None, metadata={'json': 'status'})
    department_ids = attr.ib(type=List[str], default=None, metadata={'json': 'department_ids'})
    leader_user_id = attr.ib(type=str, default=None, metadata={'json': 'leader_user_id'})
    city = attr.ib(type=str, default=None, metadata={'json': 'city'})
    country = attr.ib(type=str, default=None, metadata={'json': 'country'})
    work_station = attr.ib(type=str, default=None, metadata={'json': 'work_station'})
    join_time = attr.ib(type=int, default=None, metadata={'json': 'join_time'})
    
    employee_no = attr.ib(type=str, default=None, metadata={'json': 'employee_no'})
    employee_type = attr.ib(type=int, default=None, metadata={'json': 'employee_type'})
    
    orders = attr.ib(type=List[UserOrder], default=None, metadata={'json': 'orders'})
    
    custom_attrs = attr.ib(type=List[UserCustomAttr], default=None, metadata={'json': 'custom_attrs'})


@to_json_decorator
@attr.s
class CustomAttrEvent(object):
    contact_field_key = attr.ib(type=str, default=None, metadata={'json': 'contact_field_key'})
    field_value_types = attr.ib(type=str, default=None, metadata={'json': 'field_value_types'})
    i18n_field_names = attr.ib(type=str, default=None, metadata={'json': 'i18n_field_names'})
    allow_open_query = attr.ib(type=str, default=None, metadata={'json': 'allow_open_query'})


@to_json_decorator
@attr.s
class DepartmentUnit(object):
    unit_id = attr.ib(type=str, default=None, metadata={'json': 'unit_id'})
    unit_type = attr.ib(type=str, default=None, metadata={'json': 'unit_type'})
    unit_name = attr.ib(type=str, default=None, metadata={'json': 'unit_name'})


@to_json_decorator
@attr.s
class GroupEvent(object):
    user_group_id = attr.ib(type=str, default=None, metadata={'json': 'user_group_id'})
    name = attr.ib(type=str, default=None, metadata={'json': 'name'})


@to_json_decorator
@attr.s
class UserGroupMember(object):
    pass


@to_json_decorator
@attr.s
class DepartmentCount(object):
    department_id = attr.ib(type=str, default=None, metadata={'json': 'department_id'})
    direct_department_count = attr.ib(type=int, default=None, metadata={'json': 'direct_department_count'})
    direct_user_count = attr.ib(type=int, default=None, metadata={'json': 'direct_user_count'})
    department_count = attr.ib(type=int, default=None, metadata={'json': 'department_count'})
    user_count = attr.ib(type=int, default=None, metadata={'json': 'user_count'})


@to_json_decorator
@attr.s
class DepartmentParent(object):
    department_id = attr.ib(type=str, default=None, metadata={'json': 'department_id'})
    parent_ids = attr.ib(type=List[str], default=None, metadata={'json': 'parent_ids'})


@to_json_decorator
@attr.s
class OldUserObject(object):
    department_ids = attr.ib(type=List[str], default=None, metadata={'json': 'department_ids'})
    open_id = attr.ib(type=str, default=None, metadata={'json': 'open_id'})




@attr.s
class DepartmentGetResult(object):
    department = attr.ib(type=Department, default=None, metadata={'json': 'department'})


@to_json_decorator
@attr.s
class UserDeleteReqBody(object):
    department_chat_acceptor_user_id = attr.ib(type=str, default=None, metadata={'json': 'department_chat_acceptor_user_id'})
    external_chat_acceptor_user_id = attr.ib(type=str, default=None, metadata={'json': 'external_chat_acceptor_user_id'})
    docs_acceptor_user_id = attr.ib(type=str, default=None, metadata={'json': 'docs_acceptor_user_id'})
    calendar_acceptor_user_id = attr.ib(type=str, default=None, metadata={'json': 'calendar_acceptor_user_id'})
    application_acceptor_user_id = attr.ib(type=str, default=None, metadata={'json': 'application_acceptor_user_id'})
    helpdesk_acceptor_user_id = attr.ib(type=str, default=None, metadata={'json': 'helpdesk_acceptor_user_id'})




@attr.s
class DepartmentListResult(object):
    has_more = attr.ib(type=bool, default=None, metadata={'json': 'has_more'})
    page_token = attr.ib(type=str, default=None, metadata={'json': 'page_token'})
    items = attr.ib(type=List[Department], default=None, metadata={'json': 'items'})



@attr.s
class DepartmentPatchResult(object):
    department = attr.ib(type=Department, default=None, metadata={'json': 'department'})



@attr.s
class UserUpdateResult(object):
    user = attr.ib(type=User, default=None, metadata={'json': 'user'})



@attr.s
class UserCreateResult(object):
    user = attr.ib(type=User, default=None, metadata={'json': 'user'})



@attr.s
class UserPatchResult(object):
    user = attr.ib(type=User, default=None, metadata={'json': 'user'})



@attr.s
class DepartmentCreateResult(object):
    department = attr.ib(type=Department, default=None, metadata={'json': 'department'})





@attr.s
class UserGetResult(object):
    user = attr.ib(type=User, default=None, metadata={'json': 'user'})



@attr.s
class DepartmentUpdateResult(object):
    department = attr.ib(type=Department, default=None, metadata={'json': 'department'})



@attr.s
class UserListResult(object):
    has_more = attr.ib(type=bool, default=None, metadata={'json': 'has_more'})
    page_token = attr.ib(type=str, default=None, metadata={'json': 'page_token'})
    items = attr.ib(type=List[User], default=None, metadata={'json': 'items'})



@attr.s
class DepartmentParentResult(object):
    has_more = attr.ib(type=bool, default=None, metadata={'json': 'has_more'})
    page_token = attr.ib(type=str, default=None, metadata={'json': 'page_token'})
    items = attr.ib(type=List[Department], default=None, metadata={'json': 'items'})


@to_json_decorator
@attr.s
class DepartmentSearchReqBody(object):
    query = attr.ib(type=str, default=None, metadata={'json': 'query'})


@attr.s
class DepartmentSearchResult(object):
    items = attr.ib(type=List[Department], default=None, metadata={'json': 'items'})
    page_token = attr.ib(type=str, default=None, metadata={'json': 'page_token'})
    has_more = attr.ib(type=bool, default=None, metadata={'json': 'has_more'})


@attr.s
class DepartmentCreatedEventData(object):
    object = attr.ib(type=DepartmentEvent, default=None, metadata={'json': 'object'})


@attr.s
class DepartmentCreatedEvent(BaseEventV2):
    event = attr.ib(type=DepartmentCreatedEventData, default=None)



@attr.s
class DepartmentDeletedEventData(object):
    object = attr.ib(type=DepartmentEvent, default=None, metadata={'json': 'object'})
    old_object = attr.ib(type=OldDepartmentObject, default=None, metadata={'json': 'old_object'})


@attr.s
class DepartmentDeletedEvent(BaseEventV2):
    event = attr.ib(type=DepartmentDeletedEventData, default=None)



@attr.s
class DepartmentUpdatedEventData(object):
    object = attr.ib(type=DepartmentEvent, default=None, metadata={'json': 'object'})
    old_object = attr.ib(type=DepartmentEvent, default=None, metadata={'json': 'old_object'})


@attr.s
class DepartmentUpdatedEvent(BaseEventV2):
    event = attr.ib(type=DepartmentUpdatedEventData, default=None)



@attr.s
class UserCreatedEventData(object):
    object = attr.ib(type=UserEvent, default=None, metadata={'json': 'object'})


@attr.s
class UserCreatedEvent(BaseEventV2):
    event = attr.ib(type=UserCreatedEventData, default=None)



@attr.s
class UserDeletedEventData(object):
    object = attr.ib(type=UserEvent, default=None, metadata={'json': 'object'})
    old_object = attr.ib(type=OldUserObject, default=None, metadata={'json': 'old_object'})


@attr.s
class UserDeletedEvent(BaseEventV2):
    event = attr.ib(type=UserDeletedEventData, default=None)



@attr.s
class UserUpdatedEventData(object):
    object = attr.ib(type=UserEvent, default=None, metadata={'json': 'object'})
    old_object = attr.ib(type=UserEvent, default=None, metadata={'json': 'old_object'})


@attr.s
class UserUpdatedEvent(BaseEventV2):
    event = attr.ib(type=UserUpdatedEventData, default=None)



@attr.s
class UserGroupCreatedEventData(object):
    object = attr.ib(type=GroupEvent, default=None, metadata={'json': 'object'})


@attr.s
class UserGroupCreatedEvent(BaseEventV2):
    event = attr.ib(type=UserGroupCreatedEventData, default=None)



@attr.s
class UserGroupDeletedEventData(object):
    object = attr.ib(type=GroupEvent, default=None, metadata={'json': 'object'})


@attr.s
class UserGroupDeletedEvent(BaseEventV2):
    event = attr.ib(type=UserGroupDeletedEventData, default=None)



@attr.s
class UserGroupUpdatedEventData(object):
    object = attr.ib(type=GroupEvent, default=None, metadata={'json': 'object'})
    old_object = attr.ib(type=GroupEvent, default=None, metadata={'json': 'old_object'})


@attr.s
class UserGroupUpdatedEvent(BaseEventV2):
    event = attr.ib(type=UserGroupUpdatedEventData, default=None)



@attr.s
class ScopeUpdatedEventData(object):
    added = attr.ib(type=Scope, default=None, metadata={'json': 'added'})
    removed = attr.ib(type=Scope, default=None, metadata={'json': 'removed'})


@attr.s
class ScopeUpdatedEvent(BaseEventV2):
    event = attr.ib(type=ScopeUpdatedEventData, default=None)



@attr.s
class UserGroupMemberChangedEventData(object):
    object = attr.ib(type=GroupEvent, default=None, metadata={'json': 'object'})


@attr.s
class UserGroupMemberChangedEvent(BaseEventV2):
    event = attr.ib(type=UserGroupMemberChangedEventData, default=None)



@attr.s
class CustomAttrEventUpdatedEventData(object):
    object = attr.ib(type=CustomAttrEvent, default=None, metadata={'json': 'object'})
    old_object = attr.ib(type=CustomAttrEvent, default=None, metadata={'json': 'old_object'})


@attr.s
class CustomAttrEventUpdatedEvent(BaseEventV2):
    event = attr.ib(type=CustomAttrEventUpdatedEventData, default=None)



@attr.s
class EmployeeTypeEnumActivedEventData(object):
    old_enum = attr.ib(type=EmployeeTypeEnum, default=None, metadata={'json': 'old_enum'})
    new_enum = attr.ib(type=EmployeeTypeEnum, default=None, metadata={'json': 'new_enum'})


@attr.s
class EmployeeTypeEnumActivedEvent(BaseEventV2):
    event = attr.ib(type=EmployeeTypeEnumActivedEventData, default=None)



@attr.s
class EmployeeTypeEnumCreatedEventData(object):
    new_enum = attr.ib(type=EmployeeTypeEnum, default=None, metadata={'json': 'new_enum'})


@attr.s
class EmployeeTypeEnumCreatedEvent(BaseEventV2):
    event = attr.ib(type=EmployeeTypeEnumCreatedEventData, default=None)



@attr.s
class EmployeeTypeEnumDeactivatedEventData(object):
    old_enum = attr.ib(type=EmployeeTypeEnum, default=None, metadata={'json': 'old_enum'})
    new_enum = attr.ib(type=EmployeeTypeEnum, default=None, metadata={'json': 'new_enum'})


@attr.s
class EmployeeTypeEnumDeactivatedEvent(BaseEventV2):
    event = attr.ib(type=EmployeeTypeEnumDeactivatedEventData, default=None)



@attr.s
class EmployeeTypeEnumDeletedEventData(object):
    old_enum = attr.ib(type=EmployeeTypeEnum, default=None, metadata={'json': 'old_enum'})


@attr.s
class EmployeeTypeEnumDeletedEvent(BaseEventV2):
    event = attr.ib(type=EmployeeTypeEnumDeletedEventData, default=None)



@attr.s
class EmployeeTypeEnumUpdatedEventData(object):
    old_enum = attr.ib(type=EmployeeTypeEnum, default=None, metadata={'json': 'old_enum'})
    new_enum = attr.ib(type=EmployeeTypeEnum, default=None, metadata={'json': 'new_enum'})


@attr.s
class EmployeeTypeEnumUpdatedEvent(BaseEventV2):
    event = attr.ib(type=EmployeeTypeEnumUpdatedEventData, default=None)
