"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Fleet = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * The fleet of vehicles
 */
class Fleet extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.fleetId = '';
        this.signalCatalog = {};
        this.vehicles = undefined;
        this.arn = `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:fleet/${props.fleetId}`;
        this.signalCatalog = props.signalCatalog;
        this.fleetId = props.fleetId;
        this.vehicles = props.vehicles || [];
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'Lambda', {
            code: aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../src/handlers')),
            handler: 'fleethandler.on_event',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.signalCatalog.lambdaLayer],
            role: this.signalCatalog.lambdaRole,
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler: onEventHandler,
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: {
                fleet_id: this.fleetId,
                signal_catalog_arn: this.signalCatalog.arn,
                description: props.description,
                vehicle_ids: this.vehicles.map(v => v.vehicleId),
            },
        });
        resource.node.addDependency(this.signalCatalog);
        this.vehicles.map(v => resource.node.addDependency(v));
    }
}
exports.Fleet = Fleet;
_a = JSII_RTTI_SYMBOL_1;
Fleet[_a] = { fqn: "cdk-aws-iotfleetwise.Fleet", version: "0.2.3" };
//# sourceMappingURL=data:application/json;base64,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