import * as cdk from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { Vehicle } from './vehicle';
export declare class CollectionScheme {
    protected scheme: object;
    constructor();
    toObject(): object;
}
export declare class TimeBasedCollectionScheme extends CollectionScheme {
    constructor(period: cdk.Duration);
}
export declare class CampaignSignal {
    private signal;
    constructor(name: string, maxSampleCount?: number, minimumSamplingInterval?: cdk.Duration);
    toObject(): object;
}
export interface CampaignProps {
    readonly name: string;
    readonly target: Vehicle;
    readonly collectionScheme: CollectionScheme;
    readonly signals: CampaignSignal[];
}
export declare class Campaign extends Construct {
    readonly name: string;
    readonly arn: string;
    readonly target: Vehicle;
    constructor(scope: Construct, id: string, props: CampaignProps);
}
