# The GENO solver

[![Build Status](https://app.travis-ci.com/slaue/genosolver.svg?token=6e4Ji9xEp8uDra4uHsxu&branch=main)](https://travis-ci.com/slaue/genosolver)

GENO is a solver for non-linear optimization problems. It can solve constrained and unconstrained problems. It is fully written in Python with no dependencies and it can run on the CPU and on the GPU.

## Installing

```
pip install genosolver
```

## Project Homepage

See [geno-project.org](http://www.geno-project.org) for more details, examples, and for an easy-to-read  modeling language interface.


## Authors

* [**Sören Laue**](https://theinf2.informatik.uni-jena.de/People/Soeren+Laue.html) - most of the solver -
* [**Mark Blacher**](https://theinf2.informatik.uni-jena.de/People/Mark+Blacher.html) - GPU support
* [**Matthias Mitterreiter**](https://theinf2.informatik.uni-jena.de/People/Matthias+Mitterreiter.html)


## License

This project is licensed under the GNU Affero General Public License v3.

## Papers

For more information, see the papers 
* [Optimization for Classical Machine Learning Problems on the GPU](https://aaai.org/Conferences/AAAI-22). Sören Laue, Mark Blacher, and Joachim Giesen. In *AAAI Conference on Artificial Intelligence (AAAI),* 2022.
* [GENO -- GENeric Optimization for Classical Machine Learning](http://papers.nips.cc/paper/8491-geno-generic-optimization-for-classical-machine-learning). Sören Laue, Matthias Mitterreiter, and Joachim Giesen. In *Advances in Neural Information Processing Systems (NeurIPS),* 2019.
