"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_autoscaling_1 = require("monocdk/aws-autoscaling");
const aws_ec2_1 = require("monocdk/aws-ec2");
/**
 * EC2 instances have detailed monitoring enabled - (Control IDs: CA-7(a)(b), SI-4(2), SI-4(a)(b)(c)).
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ec2_1.CfnInstance) {
        const monitoring = monocdk_1.Stack.of(node).resolve(node.monitoring);
        if (monitoring == undefined || monitoring == false) {
            return false;
        }
    }
    else if (node instanceof aws_autoscaling_1.CfnLaunchConfiguration) {
        const monitoring = monocdk_1.Stack.of(node).resolve(node.instanceMonitoring);
        if (monitoring != undefined && monitoring == false) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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