"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HIPAASecurityChecks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const common_1 = require("../common");
const index_1 = require("./rules/cloudtrail/index");
/**
 * Check for HIPAA Security compliance.
 *
 * Based on the HIPAA Security AWS operational best practices: https://docs.aws.amazon.com/config/latest/developerguide/operational-best-practices-for-hipaa_security.html
 *
 * @stability stable
 */
class HIPAASecurityChecks extends common_1.NagPack {
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    visit(node) {
        var _b;
        if (node instanceof monocdk_1.CfnResource) {
            // Get ignores metadata if it exists
            const ignores = (_b = node.getMetadata('cdk_nag')) === null || _b === void 0 ? void 0 : _b.rules_to_suppress;
            // this.checkAPIGW(node, ignores);
            // this.checkAutoScaling(node, ignores);
            this.checkCloudTrail(node, ignores);
            // this.checkCloudWatch(node, ignores);
            // this.checkCodeBuild(node, ignores);
            // this.checkDMS(node, ignores);
            // this.checkDynamoDB(node, ignores);
            // this.checkEC2(node, ignores);
            // this.checkECS(node, ignores);
            // this.checkEFS(node, ignores);
            // this.checkElastiCache(node, ignores);
            // this.checkElasticBeanstalk(node, ignores);
            // this.checkElasticsearch(node, ignores);
            // this.checkELB(node, ignores);
            // this.checkEMR(node, ignores);
            // this.checkIAM(node, ignores);
            // this.checkLambda(node, ignores);
            // this.checkRDS(node, ignores);
            // this.checkRedshift(node, ignores);
            // this.checkS3(node, ignores);
            // this.checkSageMaker(node, ignores);
            // this.checkSecretsManager(node, ignores);
            // this.checkSNS(node, ignores);
            // this.checkVPC(node, ignores);
        }
    }
    //   /**
    //    * Check API Gateway Resources
    //    * @param node the IConstruct to evaluate
    //    * @param ignores list of ignores for the resource
    //    */
    //   private checkAPIGW(node: CfnResource, ignores: any): void {}
    //   /**
    //    * Check Auto Scaling Resources
    //    * @param node the IConstruct to evaluate
    //    * @param ignores list of ignores for the resource
    //    */
    //   private checkAutoScaling(node: CfnResource, ignores: any): void {}
    //   /**
    //    * Check CloudTrail Resources
    //    * @param node the IConstruct to evaluate
    //    * @param ignores list of ignores for the resource
    //    */
    checkCloudTrail(node, ignores) {
        if (!this.ignoreRule(ignores, 'HIPAA.Security-CloudTrailCloudWatchLogsEnabled') &&
            !index_1.hipaaSecurityCloudTrailCloudWatchLogsEnabled(node)) {
            const ruleId = 'HIPAA.Security-CloudTrailCloudWatchLogsEnabled';
            const info = 'The trail does not have CloudWatch logs enabled - (Control IDs: 164.308(a)(3)(ii)(A), 164.312(b)).';
            const explanation = 'Use Amazon CloudWatch to centrally collect and manage log event activity. Inclusion of AWS CloudTrail data provides details of API call activity within your AWS account.';
            monocdk_1.Annotations.of(node).addError(this.createMessage(ruleId, info, explanation));
        }
        if (!this.ignoreRule(ignores, 'HIPAA.Security-CloudTrailEncryptionEnabled') &&
            !index_1.hipaaSecurityCloudTrailEncryptionEnabled(node)) {
            const ruleId = 'HIPAA.Security-CloudTrailEncryptionEnabled';
            const info = 'The trail does not have a KMS key ID or have encryption enabled - (Control ID: 164.312(a)(2)(iv), 164.312(e)(2)(ii)).';
            const explanation = 'Because sensitive data may exist and to help protect data at rest, ensure encryption is enabled for your AWS CloudTrail trails.';
            monocdk_1.Annotations.of(node).addError(this.createMessage(ruleId, info, explanation));
        }
        if (!this.ignoreRule(ignores, 'HIPAA.Security-CloudTrailLogFileValidationEnabled') &&
            !index_1.hipaaSecurityCloudTrailLogFileValidationEnabled(node)) {
            const ruleId = 'HIPAA.Security-CloudTrailLogFileValidationEnabled';
            const info = 'The trail does not have log file validation enabled - (Control ID: 164.312(c)(1), 164.312(c)(2)).';
            const explanation = 'Utilize AWS CloudTrail log file validation to check the integrity of CloudTrail logs. Log file validation helps determine if a log file was modified or deleted or unchanged after CloudTrail delivered it. This feature is built using industry standard algorithms: SHA-256 for hashing and SHA-256 with RSA for digital signing. This makes it computationally infeasible to modify, delete or forge CloudTrail log files without detection.';
            monocdk_1.Annotations.of(node).addError(this.createMessage(ruleId, info, explanation));
        }
    }
}
exports.HIPAASecurityChecks = HIPAASecurityChecks;
_a = JSII_RTTI_SYMBOL_1;
HIPAASecurityChecks[_a] = { fqn: "monocdk-nag.HIPAASecurityChecks", version: "0.0.45" };
//# sourceMappingURL=data:application/json;base64,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