"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_dynamodb_1 = require("monocdk/aws-dynamodb");
/**
 * DynamoDB tables have Point-in-time Recovery enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_dynamodb_1.CfnTable) {
        if (node.pointInTimeRecoverySpecification == undefined) {
            return false;
        }
        const pitr = monocdk_1.Stack.of(node).resolve(node.pointInTimeRecoverySpecification);
        const enabled = monocdk_1.Stack.of(node).resolve(pitr.pointInTimeRecoveryEnabled);
        if (!enabled) {
            return false;
        }
    }
    //  else if (node instanceof CfnGlobalTable) {
    //   if (node.pointInTimeRecoverySpecification == undefined) {
    //     return false;
    //   }
    //   const pitr = Tokenization.isResolvable(
    //     node.pointInTimeRecoverySpecification,
    //   )
    //     ? Stack.of(node).resolve(node.pointInTimeRecoverySpecification)
    //     : node.pointInTimeRecoverySpecification;
    //   const enabled = Stack.of(node).resolve(pitr.pointInTimeRecoveryEnabled);
    //   if (!enabled) {
    //     return false;
    //   }
    // }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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