"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_ecr_1 = require("monocdk/aws-ecr");
/**
 * ECR Repositories do not allow open access
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ecr_1.CfnRegistryPolicy) {
        const policyText = monocdk_1.Stack.of(node).resolve(node.policyText);
        return checkStatement(policyText);
    }
    else if (node instanceof aws_ecr_1.CfnRepository) {
        const policyText = monocdk_1.Stack.of(node).resolve(node.repositoryPolicyText);
        return checkStatement(policyText);
    }
    return true;
}
exports.default = default_1;
/**
 * Helper function for parsing through the policy statement
 * @param policyText the JSON policy text
 * @returns boolean
 */
function checkStatement(policyText) {
    if (policyText == undefined || policyText.Statement == undefined) {
        return true;
    }
    for (const statement of policyText.Statement) {
        const effect = statement.Effect;
        if (effect == 'Allow') {
            const awsString = statement.Principal
                ? JSON.stringify(statement.Principal)
                : '';
            if (awsString.includes('*')) {
                return false;
            }
        }
    }
    return true;
}
//# sourceMappingURL=data:application/json;base64,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