"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_msk_1 = require("monocdk/aws-msk");
/**
 * MSK clusters send broker logs to a supported destination
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_msk_1.CfnCluster) {
        const loggingInfo = monocdk_1.Stack.of(node).resolve(node.loggingInfo);
        if (loggingInfo == undefined) {
            return false;
        }
        const resolvedBrokerLogs = monocdk_1.Stack.of(node).resolve(loggingInfo.brokerLogs);
        let enabled = false;
        const s3 = monocdk_1.Stack.of(node).resolve(resolvedBrokerLogs.s3);
        if (s3 != undefined) {
            const s3Enabled = monocdk_1.Stack.of(node).resolve(s3.enabled);
            if (s3Enabled) {
                enabled = true;
            }
        }
        const cloudWatchLogs = monocdk_1.Stack.of(node).resolve(resolvedBrokerLogs.cloudWatchLogs);
        if (cloudWatchLogs != undefined) {
            const cloudWatchLogsEnabled = monocdk_1.Stack.of(node).resolve(cloudWatchLogs.enabled);
            if (cloudWatchLogsEnabled) {
                enabled = true;
            }
        }
        const firehose = monocdk_1.Stack.of(node).resolve(resolvedBrokerLogs.firehose);
        if (firehose != undefined) {
            const firehoseEnabled = monocdk_1.Stack.of(node).resolve(firehose.enabled);
            if (firehoseEnabled) {
                enabled = true;
            }
        }
        if (!enabled) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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