"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_elasticsearch_1 = require("monocdk/aws-elasticsearch");
/**
 * ES domains use dedicated master nodes
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticsearch_1.CfnDomain) {
        const elasticsearchClusterConfig = monocdk_1.Stack.of(node).resolve(node.elasticsearchClusterConfig);
        if (elasticsearchClusterConfig == undefined) {
            return false;
        }
        const dedicatedMasterEnabled = monocdk_1.Stack.of(node).resolve(elasticsearchClusterConfig.dedicatedMasterEnabled);
        if (!dedicatedMasterEnabled) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiRVNINC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9Bd3NTb2x1dGlvbnMvcnVsZXMvYW5hbHl0aWNzL0VTSDQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7O0VBR0U7QUFDRixxQ0FBNEM7QUFDNUMsaUVBQXNEO0FBRXREOzs7R0FHRztBQUNILG1CQUF5QixJQUFnQjtJQUN2QyxJQUFJLElBQUksWUFBWSw2QkFBUyxFQUFFO1FBQzdCLE1BQU0sMEJBQTBCLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQ3ZELElBQUksQ0FBQywwQkFBMEIsQ0FDaEMsQ0FBQztRQUNGLElBQUksMEJBQTBCLElBQUksU0FBUyxFQUFFO1lBQzNDLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7UUFDRCxNQUFNLHNCQUFzQixHQUFHLGVBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUNuRCwwQkFBMEIsQ0FBQyxzQkFBc0IsQ0FDbEQsQ0FBQztRQUNGLElBQUksQ0FBQyxzQkFBc0IsRUFBRTtZQUMzQixPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFoQkQsNEJBZ0JDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBJQ29uc3RydWN0LCBTdGFjayB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuRG9tYWluIH0gZnJvbSAnbW9ub2Nkay9hd3MtZWxhc3RpY3NlYXJjaCc7XG5cbi8qKlxuICogRVMgZG9tYWlucyB1c2UgZGVkaWNhdGVkIG1hc3RlciBub2Rlc1xuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBJQ29uc3RydWN0KTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuRG9tYWluKSB7XG4gICAgY29uc3QgZWxhc3RpY3NlYXJjaENsdXN0ZXJDb25maWcgPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKFxuICAgICAgbm9kZS5lbGFzdGljc2VhcmNoQ2x1c3RlckNvbmZpZyxcbiAgICApO1xuICAgIGlmIChlbGFzdGljc2VhcmNoQ2x1c3RlckNvbmZpZyA9PSB1bmRlZmluZWQpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gICAgY29uc3QgZGVkaWNhdGVkTWFzdGVyRW5hYmxlZCA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUoXG4gICAgICBlbGFzdGljc2VhcmNoQ2x1c3RlckNvbmZpZy5kZWRpY2F0ZWRNYXN0ZXJFbmFibGVkLFxuICAgICk7XG4gICAgaWYgKCFkZWRpY2F0ZWRNYXN0ZXJFbmFibGVkKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19