# coding: utf-8

"""
    FlashArray REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: 2.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re

import six
import typing

from ....properties import Property
if typing.TYPE_CHECKING:
    from pypureclient.flasharray.FA_2_4 import models

class SnmpAgentPatch(object):
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'engine_id': 'str',
        'v2c': 'SnmpV2c',
        'v3': 'SnmpV3Patch',
        'version': 'str'
    }

    attribute_map = {
        'name': 'name',
        'engine_id': 'engine_id',
        'v2c': 'v2c',
        'v3': 'v3',
        'version': 'version'
    }

    required_args = {
    }

    def __init__(
        self,
        name=None,  # type: str
        engine_id=None,  # type: str
        v2c=None,  # type: models.SnmpV2c
        v3=None,  # type: models.SnmpV3Patch
        version=None,  # type: str
    ):
        """
        Keyword args:
            name (str): A user-specified name. The name must be locally unique and can be changed.
            engine_id (str): The administration domain unique name of an SNMP agent.
            v2c (SnmpV2c)
            v3 (SnmpV3Patch)
            version (str): Version of the SNMP protocol to be used by Purity//FA in communications with the specified manager. Valid values are `v2c` and `v3`.
        """
        if name is not None:
            self.name = name
        if engine_id is not None:
            self.engine_id = engine_id
        if v2c is not None:
            self.v2c = v2c
        if v3 is not None:
            self.v3 = v3
        if version is not None:
            self.version = version

    def __setattr__(self, key, value):
        if key not in self.attribute_map:
            raise KeyError("Invalid key `{}` for `SnmpAgentPatch`".format(key))
        if key == "engine_id" and value is not None:
            if len(value) > 32:
                raise ValueError("Invalid value for `engine_id`, length must be less than or equal to `32`")
        self.__dict__[key] = value

    def __getattribute__(self, item):
        value = object.__getattribute__(self, item)
        if isinstance(value, Property):
            raise AttributeError
        else:
            return value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            if hasattr(self, attr):
                value = getattr(self, attr)
                if isinstance(value, list):
                    result[attr] = list(map(
                        lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                        value
                    ))
                elif hasattr(value, "to_dict"):
                    result[attr] = value.to_dict()
                elif isinstance(value, dict):
                    result[attr] = dict(map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict") else item,
                        value.items()
                    ))
                else:
                    result[attr] = value
        if issubclass(SnmpAgentPatch, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnmpAgentPatch):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
