from switrs_to_sqlite.converters import convert, negative, string_to_bool
from switrs_to_sqlite.datatypes import DataType
import switrs_to_sqlite.value_maps as vm


COLLISION_ROW = (
    (0, "case_id", DataType.TEXT, None, convert, None),
    (3, "jurisdiction", DataType.INTEGER, None, convert, None),
    (6, "officer_id", DataType.TEXT, None, convert, None),
    (7, "reporting_district", DataType.TEXT, None, convert, None),
    (9, "chp_shift", DataType.TEXT, None, convert, None),
    (10, "population", DataType.TEXT, None, convert, None),
    (11, "county_city_location", DataType.TEXT, None, convert, None),
    (12, "special_condition", DataType.TEXT, None, convert, None),
    (13, "beat_type", DataType.TEXT, None, convert, None),
    (14, "chp_beat_type", DataType.TEXT, None, convert, vm.CHP_BEAT_TYPE),
    (15, "city_division_lapd", DataType.TEXT, ["0"], convert, None),
    (16, "chp_beat_class", DataType.TEXT, None, convert, vm.CHP_BEAT_CLASS),
    (17, "beat_number", DataType.TEXT, None, convert, None),
    (18, "primary_road", DataType.TEXT, None, convert, None),
    (19, "secondary_road", DataType.TEXT, None, convert, None),
    (20, "distance", DataType.REAL, None, convert, None),
    (21, "direction", DataType.TEXT, None, convert, vm.DIRECTION),
    (22, "intersection", DataType.INTEGER, None, string_to_bool, None),
    (23, "weather_1", DataType.TEXT, ['N', 'Y'], convert, vm.WEATHER),
    (24, "weather_2", DataType.TEXT, ['N', 'Y'], convert, vm.WEATHER),
    (25, "state_highway_indicator", DataType.INTEGER, None, string_to_bool, None),
    (26, "caltrans_county", DataType.TEXT, None, convert, None),
    (27, "caltrans_district", DataType.INTEGER, None, convert, None),
    (28, "state_route", DataType.INTEGER, None, convert, None),
    (29, "route_suffix", DataType.TEXT, None, convert, None),
    (30, "postmile_prefix", DataType.TEXT, None, convert, None),
    (31, "postmile", DataType.REAL, None, convert, None),
    (32, "location_type", DataType.TEXT, None, convert, vm.LOCATION_TYPE),
    (33, "ramp_intersection", DataType.INTEGER, None, convert, None),
    (34, "side_of_highway", DataType.TEXT, None, convert, vm.SIDE_OF_HIGHWAY),
    (35, "tow_away", DataType.INTEGER, None, string_to_bool, None),
    (36, "collision_severity", DataType.TEXT, None, convert, vm.COLLISION_SEVERITY),
    (37, "killed_victims", DataType.INTEGER, None, convert, None),
    (38, "injured_victims", DataType.INTEGER, None, convert, None),
    (39, "party_count", DataType.INTEGER, None, convert, None),
    (40, "primary_collision_factor", DataType.TEXT, None, convert, vm.PRIMARY_COLLISION_FACTOR),
    (41, "pcf_violation_code", DataType.TEXT, None, convert, vm.PCF_VIOLATION_CODE),
    (42, "pcf_violation_category", DataType.TEXT, None, convert, vm.PCF_VIOLATION_CATEGORY),
    (43, "pcf_violation", DataType.INTEGER, None, convert, None),
    (44, "pcf_violation_subsection", DataType.TEXT, None, convert, None),
    (45, "hit_and_run", DataType.TEXT, None, convert, vm.HIT_AND_RUN),
    (46, "type_of_collision", DataType.TEXT, ["M"], convert, vm.COLLISION_TYPE),
    (47, "motor_vehicle_involved_with", DataType.TEXT, None, convert, vm.INVOLVED_WITH),
    (48, "pedestrian_action", DataType.TEXT, None, convert, vm.PEDESTRIAN_ACTION),
    (49, "road_surface", DataType.TEXT, None, convert, vm.ROAD_SURFACE),
    (50, "road_condition_1", DataType.TEXT, None, convert, vm.ROAD_CONDITION),
    (51, "road_condition_2", DataType.TEXT, None, convert, vm.ROAD_CONDITION),
    (52, "lighting", DataType.TEXT, None, convert, vm.LIGHTING),
    (53, "control_device", DataType.TEXT, None, convert, vm.CONTROL_DEVICE),
    (54, "chp_road_type", DataType.TEXT, None, convert, None),
    (55, "pedestrian_collision", DataType.INTEGER, None, string_to_bool, None),
    (56, "bicycle_collision", DataType.INTEGER, None, string_to_bool, None),
    (57, "motorcycle_collision", DataType.INTEGER, None, string_to_bool, None),
    (58, "truck_collision", DataType.INTEGER, None, string_to_bool, None),
    (59, "not_private_property", DataType.INTEGER, None, string_to_bool, None),
    (60, "alcohol_involved", DataType.INTEGER, None, string_to_bool, None),
    (61, "statewide_vehicle_type_at_fault", DataType.TEXT, None, convert, vm.STATEWIDE_VEHICLE_TYPE),
    (62, "chp_vehicle_type_at_fault", DataType.TEXT, ["99"], convert, None),
    (63, "severe_injury_count", DataType.INTEGER, None, convert, None),
    (64, "other_visible_injury_count", DataType.INTEGER, None, convert, None),
    (65, "complaint_of_pain_injury_count", DataType.INTEGER, None, convert, None),
    (66, "pedestrian_killed_count", DataType.INTEGER, None, convert, None),
    (67, "pedestrian_injured_count", DataType.INTEGER, None, convert, None),
    (68, "bicyclist_killed_count", DataType.INTEGER, None, convert, None),
    (69, "bicyclist_injured_count", DataType.INTEGER, None, convert, None),
    (70, "motorcyclist_killed_count", DataType.INTEGER, None, convert, None),
    (71, "motorcyclist_injured_count", DataType.INTEGER, None, convert, None),
    (72, "primary_ramp", DataType.TEXT, None, convert, None),
    (73, "secondary_ramp", DataType.TEXT, None, convert, None),
    (74, "latitude", DataType.REAL, None, convert, None),
    (75, "longitude", DataType.REAL, None, negative, None),
)

COLLISION_DATE_TABLE = (
    (4, "collision_date", DataType.TEXT),
    (5, "collision_time", DataType.TEXT),
    (2, "process_date", DataType.TEXT),
)

PARTY_ROW = (
    (0, "case_id", DataType.TEXT, None, convert, None),
    (1, "party_number", DataType.INTEGER, None, convert, None),
    (2, "party_type", DataType.TEXT, None, convert, vm.PARTY_TYPE),
    (3, "at_fault", DataType.INTEGER, None, string_to_bool, None),
    (4, "party_sex", DataType.TEXT, None, convert, vm.SEX),
    (5, "party_age", DataType.INTEGER, ["998"], convert, None),
    (6, "party_sobriety", DataType.TEXT, None, convert, None),
    (7, "party_drug_physical", DataType.TEXT, None, convert, None),
    (8, "direction_of_travel", DataType.TEXT, None, convert, None),
    (9, "party_safety_equipment_1", DataType.TEXT, None, convert, None),
    (10, "party_safety_equipment_2", DataType.TEXT, None, convert, None),
    (11, "financial_responsibility", DataType.TEXT, None, convert, None),
    (12, "hazardous_materials", DataType.TEXT, None, convert, None),
    (13, "cellphone_use", DataType.TEXT, None, convert, None),
    (14, "school_bus_related", DataType.TEXT, None, convert, None),
    (15, "oaf_violation_code", DataType.TEXT, None, convert, None),
    (16, "oaf_violation_category", DataType.TEXT, ["00"], convert, None),
    (17, "oaf_violation_section", DataType.INTEGER, None, convert, None),
    (18, "oaf_violation_suffix", DataType.TEXT, None, convert, None),
    (19, "other_associate_factor_1", DataType.TEXT, None, convert, None),
    (20, "other_associate_factor_2", DataType.TEXT, None, convert, None),
    (21, "party_number_killed", DataType.INTEGER, None, convert, None),
    (22, "party_number_injured", DataType.INTEGER, None, convert, None),
    (23, "movement_preceding_collision", DataType.TEXT, None, convert, vm.MOVEMENT_PRECEDING),
    (24, "vehicle_year", DataType.INTEGER, ["9999"], convert, None),
    (25, "vehicle_make", DataType.TEXT, None, convert, None),
    (26, "statewide_vehicle_type", DataType.TEXT, None, convert, vm.STATEWIDE_VEHICLE_TYPE),
    (27, "chp_vehicle_type_towing", DataType.TEXT, ["99"], convert, None),
    (28, "chp_vehicle_type_towed", DataType.TEXT, ["99"], convert, None),
    (29, "party_race", DataType.TEXT, None, convert, vm.RACE),
)

VICTIM_ROW = (
    (0, "case_id", DataType.TEXT, None, convert, None),
    (1, "party_number", DataType.INTEGER, None, convert, None),
    (2, "victim_role", DataType.TEXT, None, convert, None),
    (3, "victim_sex", DataType.TEXT, None, convert, vm.SEX),
    (4, "victim_age", DataType.INTEGER, ["998"], convert, None),
    (5, "victim_degree_of_injury", DataType.TEXT, None, convert, vm.DEGREE_OF_INJURY),
    (6, "victim_seating_position", DataType.TEXT, None, convert, None),
    (7, "victim_safety_equipment_1", DataType.TEXT, None, convert, None),
    (8, "victim_safety_equipment_2", DataType.TEXT, None, convert, None),
    (9, "victim_ejected", DataType.TEXT, None, convert, None),
)
