"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const cdk = require("@aws-cdk/core");
const _1 = require("./");
class IntegTesting {
    constructor() {
        const devEnv = {
            account: process.env.CDK_DEFAULT_ACCOUNT,
            region: process.env.CDK_DEFAULT_REGION,
        };
        const app = new cdk.App();
        const stack = new cdk.Stack(app, 'ApiSixDemoStack', { env: devEnv });
        configureTheMock(stack);
        const apisix = new _1.Apisix(stack, 'apisix-demo');
        apisix.createWebService('flask', {
            environment: {
                PLATFORM: 'Apache APISIX on AWS Fargate',
            },
            image: aws_ecs_1.ContainerImage.fromRegistry('public.ecr.aws/pahudnet/flask-docker-sample'),
            port: 80,
        });
        app.synth();
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
function isContextAvailable(scope, key) {
    return cdk.Stack.of(scope).node.tryGetContext(key);
}
function configureTheMock(stack) {
    const required = [
        'ADMIN_KEY_ADMIN',
        'ADMIN_KEY_VIEWER',
        'DASHBOARD_ADMIN_PASSWORD',
        'DASHBOARD_USER_PASSWORD',
    ];
    required.map(c => {
        if (!isContextAvailable(stack, c))
            stack.node.setContext(c, 'mock');
    });
}
//# sourceMappingURL=data:application/json;base64,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