import { IVpc } from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import { NetworkLoadBalancedFargateService } from '@aws-cdk/aws-ecs-patterns';
import * as efs from '@aws-cdk/aws-efs';
import * as cdk from '@aws-cdk/core';
/**
 * construct properties for Apisix.
 *
 * @stability stable
 */
export interface ApisixProps {
    /**
     * Vpc for the APISIX.
     *
     * @default - create a new VPC or use existing one
     * @stability stable
     */
    readonly vpc?: IVpc;
    /**
     * Amazon ECS cluster.
     *
     * @default - create a new cluster
     * @stability stable
     */
    readonly cluster?: ecs.ICluster;
    /**
     * Amazon EFS filesystem for etcd data persistence.
     *
     * @default - ceate a new filesystem
     * @stability stable
     */
    readonly efsFilesystem?: efs.IFileSystem;
    /**
     * container for APISIX API service.
     *
     * @default - public.ecr.aws/d7p2r8s3/apisix
     * @stability stable
     */
    readonly apisixContainer?: ecs.ContainerImage;
    /**
     * container for the dashboard.
     *
     * @default - public.ecr.aws/d7p2r8s3/apisix-dashboard
     * @stability stable
     */
    readonly dashboardContainer?: ecs.ContainerImage;
    /**
     * container for the etcd.
     *
     * @default - public.ecr.aws/eks-distro/etcd-io/etcd:v3.4.14-eks-1-18-1
     * @stability stable
     */
    readonly etcdContainer?: ecs.ContainerImage;
}
/**
 * options for createWebService.
 *
 * @stability stable
 */
export interface WebServiceOptions {
    /**
     * @stability stable
     */
    readonly image?: ecs.RepositoryImage;
    /**
     * @stability stable
     */
    readonly port?: number;
    /**
     * @stability stable
     */
    readonly environment?: {
        [key: string]: string;
    };
}
/**
 * The Apisix construct.
 *
 * @stability stable
 */
export declare class Apisix extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly vpc: IVpc;
    /**
     * @stability stable
     */
    readonly cluster: ecs.ICluster;
    /**
     * @stability stable
     */
    readonly envVar: {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props?: ApisixProps);
    private _createEfsFilesystem;
    /**
     * Create a basic web service on AWS Fargate.
     *
     * @stability stable
     */
    createWebService(id: string, options: WebServiceOptions): NetworkLoadBalancedFargateService;
}
