from kanjize import int2kanji, kanji2int


class Kanji2Arabic:
    """漢数字の文字列をアラビア数字のテキストに変換する
    """

    __kurai_list = "十,百,千,万,億,兆,京".split(",")
    __kanji_arabic_dic = {"一": "1", "二": "2", "三": "3", "四": "4", "五": "5", "六": "6", "七": "7", "八": "8", "九": "9", "〇": "0"}

    @staticmethod
    def __is_renban(txt: str) -> bool:
        """連番の漢数字か ex. 一二三: True, 百二十三: False

        Args:
            txt(str):変換する漢数字

        Returns:
            True:連番, False:漢数字
        """
        for kurai in Kanji2Arabic.__kurai_list:
            if kurai in txt:
                return False
        return True

    @staticmethod
    def kanji2arabic(txt: str) -> str:
        """漢数字の文字列をアラビア数字のテキストに変換する

        Args:
            txt(str):漢数字文字列

        Returns:
            str:アラビア数字文字列

        """
        if Kanji2Arabic.__is_renban(txt):
            ret = ""
            for c in txt:
                ret += Kanji2Arabic.__kanji_arabic_dic[c]
            return ret
        else:
            return str(kanji2int(txt))


    @staticmethod
    def arabic2kanji(txt: str) -> str:
        """アラビア数字のテキストを漢字に変換する 例:123 -> 一二三

        Args:
            txt(str):アラビア数字文字列

        Returns:
            str:漢数字文字列

        """
        ret = ""
        for c in txt:
            if c == '0':
                ret += '〇'
            else:
                ret += int2kanji(int(c))
        return ret


if __name__ == "__main__":
    print(Kanji2Arabic.kanji2arabic("二〇二〇"))
    print(Kanji2Arabic.arabic2kanji("1012345"))