import pathlib
from crc import LIBRARY_VERSION
from setuptools import setup

current = pathlib.Path(__file__).parent.resolve()


def readme():
    return (current / 'README.md').read_text(encoding='utf-8')


if __name__ == '__main__':
    setup(
        name='crc',
        version=LIBRARY_VERSION,
        py_modules=['crc'],
        classifiers=[
            'Programming Language :: Python :: 3.7',
            'Programming Language :: Python :: 3.8',
            'Programming Language :: Python :: 3.9',
        ],
        url='https://github.com/Nicoretti/crc',
        license='BSD',
        python_requires='>=3.7',
        author='Nicola Coretti',
        author_email='nico.coretti@gmail.com',
        description='Library and CLI to calculate and verify all kinds of CRC checksums.',
        keywords=['CRC', 'CRC8', 'CRC16', 'CRC32', 'CRC64'],
        long_description=readme(),
        long_description_content_type='text/markdown',
        entry_points={
            'console_scripts': [
                'crc=crc:main',
            ],
        }
    )
