import { aws_s3 as s3, aws_cloudfront as cloudfront, aws_route53 as route53, aws_certificatemanager as certificateManager } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * Construct properties for `SinglePageApp`
 */
export interface SinglePageAppProps {
    /**
     * The path to the build files that are to be deployed to S3.
     */
    readonly buildPath: string;
    /**
     * Private hosted zone for DNS.
     *
     *
     */
    readonly hostedZone?: route53.IHostedZone;
    /**
     * The prefix for this app in the `privateHostedZone` for the app.
     * It is assumed the user has checked to ensure the prefix has not been used.
     */
    readonly domainPrefix?: string;
}
export declare class SinglePageApp extends Construct {
    readonly bucket: s3.Bucket;
    readonly domainName: string | undefined;
    readonly certificate: certificateManager.DnsValidatedCertificate | undefined;
    readonly distribution: cloudfront.Distribution;
    constructor(scope: Construct, id: string, props: SinglePageAppProps);
}
