# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="constructs"></a>

### SinglePageApp <a name="@sparkgeo/awscdk-constructs-library.SinglePageApp" id="sparkgeoawscdkconstructslibrarysinglepageapp"></a>

#### Initializers <a name="@sparkgeo/awscdk-constructs-library.SinglePageApp.Initializer" id="sparkgeoawscdkconstructslibrarysinglepageappinitializer"></a>

```typescript
import { SinglePageApp } from '@sparkgeo/awscdk-constructs-library'

new SinglePageApp(scope: Construct, id: string, props: SinglePageAppProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#sparkgeoawscdkconstructslibrarysinglepageappparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | *No description.* |
| [`id`](#sparkgeoawscdkconstructslibrarysinglepageappparameterid)<span title="Required">*</span> | `string` | *No description.* |
| [`props`](#sparkgeoawscdkconstructslibrarysinglepageappparameterprops)<span title="Required">*</span> | [`@sparkgeo/awscdk-constructs-library.SinglePageAppProps`](#@sparkgeo/awscdk-constructs-library.SinglePageAppProps) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@sparkgeo/awscdk-constructs-library.SinglePageApp.parameter.scope" id="sparkgeoawscdkconstructslibrarysinglepageappparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

---

##### `id`<sup>Required</sup> <a name="@sparkgeo/awscdk-constructs-library.SinglePageApp.parameter.id" id="sparkgeoawscdkconstructslibrarysinglepageappparameterid"></a>

- *Type:* `string`

---

##### `props`<sup>Required</sup> <a name="@sparkgeo/awscdk-constructs-library.SinglePageApp.parameter.props" id="sparkgeoawscdkconstructslibrarysinglepageappparameterprops"></a>

- *Type:* [`@sparkgeo/awscdk-constructs-library.SinglePageAppProps`](#@sparkgeo/awscdk-constructs-library.SinglePageAppProps)

---



#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`bucket`](#sparkgeoawscdkconstructslibrarysinglepageapppropertybucket)<span title="Required">*</span> | [`aws-cdk-lib.aws_s3.Bucket`](#aws-cdk-lib.aws_s3.Bucket) | *No description.* |
| [`distribution`](#sparkgeoawscdkconstructslibrarysinglepageapppropertydistribution)<span title="Required">*</span> | [`aws-cdk-lib.aws_cloudfront.Distribution`](#aws-cdk-lib.aws_cloudfront.Distribution) | *No description.* |
| [`certificate`](#sparkgeoawscdkconstructslibrarysinglepageapppropertycertificate) | [`aws-cdk-lib.aws_certificatemanager.DnsValidatedCertificate`](#aws-cdk-lib.aws_certificatemanager.DnsValidatedCertificate) | *No description.* |
| [`domainName`](#sparkgeoawscdkconstructslibrarysinglepageapppropertydomainname) | `string` | *No description.* |

---

##### `bucket`<sup>Required</sup> <a name="@sparkgeo/awscdk-constructs-library.SinglePageApp.property.bucket" id="sparkgeoawscdkconstructslibrarysinglepageapppropertybucket"></a>

```typescript
public readonly bucket: Bucket;
```

- *Type:* [`aws-cdk-lib.aws_s3.Bucket`](#aws-cdk-lib.aws_s3.Bucket)

---

##### `distribution`<sup>Required</sup> <a name="@sparkgeo/awscdk-constructs-library.SinglePageApp.property.distribution" id="sparkgeoawscdkconstructslibrarysinglepageapppropertydistribution"></a>

```typescript
public readonly distribution: Distribution;
```

- *Type:* [`aws-cdk-lib.aws_cloudfront.Distribution`](#aws-cdk-lib.aws_cloudfront.Distribution)

---

##### `certificate`<sup>Optional</sup> <a name="@sparkgeo/awscdk-constructs-library.SinglePageApp.property.certificate" id="sparkgeoawscdkconstructslibrarysinglepageapppropertycertificate"></a>

```typescript
public readonly certificate: DnsValidatedCertificate;
```

- *Type:* [`aws-cdk-lib.aws_certificatemanager.DnsValidatedCertificate`](#aws-cdk-lib.aws_certificatemanager.DnsValidatedCertificate)

---

##### `domainName`<sup>Optional</sup> <a name="@sparkgeo/awscdk-constructs-library.SinglePageApp.property.domainName" id="sparkgeoawscdkconstructslibrarysinglepageapppropertydomainname"></a>

```typescript
public readonly domainName: string;
```

- *Type:* `string`

---


## Structs <a name="Structs" id="structs"></a>

### SinglePageAppProps <a name="@sparkgeo/awscdk-constructs-library.SinglePageAppProps" id="sparkgeoawscdkconstructslibrarysinglepageappprops"></a>

Construct properties for `SinglePageApp`.

#### Initializer <a name="[object Object].Initializer" id="object-objectinitializer"></a>

```typescript
import { SinglePageAppProps } from '@sparkgeo/awscdk-constructs-library'

const singlePageAppProps: SinglePageAppProps = { ... }
```

#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`buildPath`](#sparkgeoawscdkconstructslibrarysinglepageapppropspropertybuildpath)<span title="Required">*</span> | `string` | The path to the build files that are to be deployed to S3. |
| [`domainPrefix`](#sparkgeoawscdkconstructslibrarysinglepageapppropspropertydomainprefix) | `string` | The prefix for this app in the `privateHostedZone` for the app. |
| [`hostedZone`](#sparkgeoawscdkconstructslibrarysinglepageapppropspropertyhostedzone) | [`aws-cdk-lib.aws_route53.IHostedZone`](#aws-cdk-lib.aws_route53.IHostedZone) | Private hosted zone for DNS. |

---

##### `buildPath`<sup>Required</sup> <a name="@sparkgeo/awscdk-constructs-library.SinglePageAppProps.property.buildPath" id="sparkgeoawscdkconstructslibrarysinglepageapppropspropertybuildpath"></a>

```typescript
public readonly buildPath: string;
```

- *Type:* `string`

The path to the build files that are to be deployed to S3.

---

##### `domainPrefix`<sup>Optional</sup> <a name="@sparkgeo/awscdk-constructs-library.SinglePageAppProps.property.domainPrefix" id="sparkgeoawscdkconstructslibrarysinglepageapppropspropertydomainprefix"></a>

```typescript
public readonly domainPrefix: string;
```

- *Type:* `string`

The prefix for this app in the `privateHostedZone` for the app.

It is assumed the user has checked to ensure the prefix has not been used.

---

##### `hostedZone`<sup>Optional</sup> <a name="@sparkgeo/awscdk-constructs-library.SinglePageAppProps.property.hostedZone" id="sparkgeoawscdkconstructslibrarysinglepageapppropspropertyhostedzone"></a>

```typescript
public readonly hostedZone: IHostedZone;
```

- *Type:* [`aws-cdk-lib.aws_route53.IHostedZone`](#aws-cdk-lib.aws_route53.IHostedZone)

Private hosted zone for DNS.

---



