from ctypes import Structure, _Pointer, c_int32, c_uint, c_void_p
from ctypes.wintypes import FLOAT, UINT

from d3dshot.dll import _HRESULT, _IUnknown
from d3dshot.dll.dxgi import IDXGIAdapter

class DXGI_SAMPLE_DESC(Structure):
    Count: UINT
    Quality: UINT

class D3D11_BOX(Structure):
    left: UINT
    top: UINT
    front: UINT
    right: UINT
    bottom: UINT
    back: UINT

class D3D11_TEXTURE2D_DESC(Structure):
    Width: UINT
    Height: UINT
    MipLevels: UINT
    ArraySize: UINT
    Format: UINT
    SampleDesc: DXGI_SAMPLE_DESC
    Usage: UINT
    BindFlags: UINT
    CPUAccessFlags: UINT
    MiscFlags: UINT

class ID3D11DeviceChild(_IUnknown):
    def GetDevice(self) -> None: ...
    def GetPrivateData(self) -> _HRESULT: ...
    def SetPrivateData(self) -> _HRESULT: ...
    def SetPrivateDataInterface(self) -> _HRESULT: ...

class ID3D11Resource(ID3D11DeviceChild):
    def GetType(self) -> None: ...
    def SetEvictionPriority(self) -> None: ...
    def GetEvictionPriority(self) -> UINT: ...

class ID3D11Texture2D(ID3D11Resource):
    def GetDesc(self, __pDesc: _Pointer[D3D11_TEXTURE2D_DESC]) -> None: ...

class ID3D11DeviceContext(ID3D11DeviceChild):
    def VSSetConstantBuffers(self) -> None: ...
    def PSSetShaderResources(self) -> None: ...
    def PSSetShader(self) -> None: ...
    def PSSetSamplers(self) -> None: ...
    def VSSetShader(self) -> None: ...
    def DrawIndexed(self) -> None: ...
    def Draw(self) -> None: ...
    def Map(self) -> _HRESULT: ...
    def Unmap(self) -> None: ...
    def PSSetConstantBuffers(self) -> None: ...
    def IASetInputLayout(self) -> None: ...
    def IASetVertexBuffers(self) -> None: ...
    def IASetIndexBuffer(self) -> None: ...
    def DrawIndexedInstanced(self) -> None: ...
    def DrawInstanced(self) -> None: ...
    def GSSetConstantBuffers(self) -> None: ...
    def GSSetShader(self) -> None: ...
    def IASetPrimitiveTopology(self) -> None: ...
    def VSSetShaderResources(self) -> None: ...
    def VSSetSamplers(self) -> None: ...
    def Begin(self) -> None: ...
    def End(self) -> None: ...
    def GetData(self) -> _HRESULT: ...
    def SetPredication(self) -> None: ...
    def GSSetShaderResources(self) -> None: ...
    def GSSetSamplers(self) -> None: ...
    def OMSetRenderTargets(self) -> None: ...
    def OMSetRenderTargetsAndUnorderedAccessViews(self) -> None: ...
    def OMSetBlendState(self) -> None: ...
    def OMSetDepthStencilState(self) -> None: ...
    def SOSetTargets(self) -> None: ...
    def DrawAuto(self) -> None: ...
    def DrawIndexedInstancedIndirect(self) -> None: ...
    def DrawInstancedIndirect(self) -> None: ...
    def Dispatch(self) -> None: ...
    def DispatchIndirect(self) -> None: ...
    def RSSetState(self) -> None: ...
    def RSSetViewports(self) -> None: ...
    def RSSetScissorRects(self) -> None: ...
    def CopySubresourceRegion(
        self,
        __pDstResource: _Pointer[ID3D11Resource],
        __DstSubresource: UINT,
        __DstX: UINT,
        __DstY: UINT,
        __DstZ: UINT,
        __pSrcResource: _Pointer[ID3D11Resource],
        __SrcSubresource: UINT,
        __pSrcBox: _Pointer[D3D11_BOX],
    ) -> None: ...
    def CopyResource(self, __pDstResource: _Pointer[ID3D11Resource], __pSrcResource: _Pointer[ID3D11Resource]) -> None: ...
    def UpdateSubresource(self) -> None: ...
    def CopyStructureCount(self) -> None: ...
    def ClearRenderTargetView(self) -> None: ...
    def ClearUnorderedAccessViewUint(self) -> None: ...
    def ClearUnorderedAccessViewFloat(self) -> None: ...
    def ClearDepthStencilView(self) -> None: ...
    def GenerateMips(self) -> None: ...
    def SetResourceMinLOD(self) -> None: ...
    def GetResourceMinLOD(self) -> FLOAT: ...
    def ResolveSubresource(self) -> None: ...
    def ExecuteCommandList(self) -> None: ...
    def HSSetShaderResources(self) -> None: ...
    def HSSetShader(self) -> None: ...
    def HSSetSamplers(self) -> None: ...
    def HSSetConstantBuffers(self) -> None: ...
    def DSSetShaderResources(self) -> None: ...
    def DSSetShader(self) -> None: ...
    def DSSetSamplers(self) -> None: ...
    def DSSetConstantBuffers(self) -> None: ...
    def CSSetShaderResources(self) -> None: ...
    def CSSetUnorderedAccessViews(self) -> None: ...
    def CSSetShader(self) -> None: ...
    def CSSetSamplers(self) -> None: ...
    def CSSetConstantBuffers(self) -> None: ...
    def VSGetConstantBuffers(self) -> None: ...
    def PSGetShaderResources(self) -> None: ...
    def PSGetShader(self) -> None: ...
    def PSGetSamplers(self) -> None: ...
    def VSGetShader(self) -> None: ...
    def PSGetConstantBuffers(self) -> None: ...
    def IAGetInputLayout(self) -> None: ...
    def IAGetVertexBuffers(self) -> None: ...
    def IAGetIndexBuffer(self) -> None: ...
    def GSGetConstantBuffers(self) -> None: ...
    def GSGetShader(self) -> None: ...
    def IAGetPrimitiveTopology(self) -> None: ...
    def VSGetShaderResources(self) -> None: ...
    def VSGetSamplers(self) -> None: ...
    def GetPredication(self) -> None: ...
    def GSGetShaderResources(self) -> None: ...
    def GSGetSamplers(self) -> None: ...
    def OMGetRenderTargets(self) -> None: ...
    def OMGetRenderTargetsAndUnorderedAccessViews(self) -> None: ...
    def OMGetBlendState(self) -> None: ...
    def OMGetDepthStencilState(self) -> None: ...
    def SOGetTargets(self) -> None: ...
    def RSGetState(self) -> None: ...
    def RSGetViewports(self) -> None: ...
    def RSGetScissorRects(self) -> None: ...
    def HSGetShaderResources(self) -> None: ...
    def HSGetShader(self) -> None: ...
    def HSGetSamplers(self) -> None: ...
    def HSGetConstantBuffers(self) -> None: ...
    def DSGetShaderResources(self) -> None: ...
    def DSGetShader(self) -> None: ...
    def DSGetSamplers(self) -> None: ...
    def DSGetConstantBuffers(self) -> None: ...
    def CSGetShaderResources(self) -> None: ...
    def CSGetUnorderedAccessViews(self) -> None: ...
    def CSGetShader(self) -> None: ...
    def CSGetSamplers(self) -> None: ...
    def CSGetConstantBuffers(self) -> None: ...
    def ClearState(self) -> None: ...
    def Flush(self) -> None: ...
    def GetType(self) -> None: ...
    def GetContextFlags(self) -> UINT: ...
    def FinishCommandList(self) -> _HRESULT: ...

class ID3D11Device(_IUnknown):
    def CreateBuffer(self) -> _HRESULT: ...
    def CreateTexture1D(self) -> _HRESULT: ...
    def CreateTexture2D(
        self,
        __pDesc: _Pointer[D3D11_TEXTURE2D_DESC],
        __pInitialData: c_void_p,
        __ppTexture2D: _Pointer[_Pointer[ID3D11Texture2D]],
    ) -> _HRESULT: ...
    def CreateTexture3D(self) -> _HRESULT: ...
    def CreateShaderResourceView(self) -> _HRESULT: ...
    def CreateUnorderedAccessView(self) -> _HRESULT: ...
    def CreateRenderTargetView(self) -> _HRESULT: ...
    def CreateDepthStencilView(self) -> _HRESULT: ...
    def CreateInputLayout(self) -> _HRESULT: ...
    def CreateVertexShader(self) -> _HRESULT: ...
    def CreateGeometryShader(self) -> _HRESULT: ...
    def CreateGeometryShaderWithStreamOutput(self) -> _HRESULT: ...
    def CreatePixelShader(self) -> _HRESULT: ...
    def CreateHullShader(self) -> _HRESULT: ...
    def CreateDomainShader(self) -> _HRESULT: ...
    def CreateComputeShader(self) -> _HRESULT: ...
    def CreateClassLinkage(self) -> _HRESULT: ...
    def CreateBlendState(self) -> _HRESULT: ...
    def CreateDepthStencilState(self) -> _HRESULT: ...
    def CreateRasterizerState(self) -> _HRESULT: ...
    def CreateSamplerState(self) -> _HRESULT: ...
    def CreateQuery(self) -> _HRESULT: ...
    def CreatePredicate(self) -> _HRESULT: ...
    def CreateCounter(self) -> _HRESULT: ...
    def CreateDeferredContext(self) -> _HRESULT: ...
    def OpenSharedResource(self) -> _HRESULT: ...
    def CheckFormatSupport(self) -> _HRESULT: ...
    def CheckMultisampleQualityLevels(self) -> _HRESULT: ...
    def CheckCounterInfo(self) -> _HRESULT: ...
    def CheckCounter(self) -> _HRESULT: ...
    def CheckFeatureSupport(self) -> _HRESULT: ...
    def GetPrivateData(self) -> _HRESULT: ...
    def SetPrivateData(self) -> _HRESULT: ...
    def SetPrivateDataInterface(self) -> _HRESULT: ...
    def GetFeatureLevel(self) -> c_int32: ...
    def GetCreationFlags(self) -> c_uint: ...
    def GetDeviceRemovedReason(self) -> _HRESULT: ...
    def GetImmediateContext(self, __ppImmediateContext: _Pointer[_Pointer[ID3D11DeviceContext]]) -> None: ...
    def SetExceptionMode(self) -> _HRESULT: ...
    def GetExceptionMode(self) -> c_uint: ...

def initialize_d3d_device(dxgi_adapter: _Pointer[IDXGIAdapter]) -> tuple[ID3D11Device, ID3D11DeviceContext]: ...
def describe_d3d11_texture_2d(d3d11_texture_2d: ID3D11Texture2D) -> D3D11_TEXTURE2D_DESC: ...
def prepare_d3d11_texture_2d_for_cpu(d3d11_texture_2d: ID3D11Texture2D, d3d_device: ID3D11Device) -> ID3D11Texture2D: ...
