/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;

public class HashIndex<E>
extends AbstractCollection<E>
implements Index<E>,
RandomAccess {
    private final List<E> objects;
    private final Map<E, Integer> indexes;
    private boolean locked;
    private static final long serialVersionUID = 5398562825928375260L;
    private final Semaphore semaphore = new Semaphore(1);

    @Override
    public void clear() {
        this.objects.clear();
        this.indexes.clear();
    }

    public int[] indices(Collection<E> elements) {
        int[] indices = new int[elements.size()];
        int i = 0;
        for (E elem : elements) {
            indices[i++] = this.indexOf(elem);
        }
        return indices;
    }

    @Override
    public Collection<E> objects(final int[] indices) {
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return HashIndex.this.objects.get(indices[index]);
            }

            @Override
            public int size() {
                return indices.length;
            }
        };
    }

    @Override
    public int size() {
        return this.objects.size();
    }

    @Override
    public E get(int i) {
        if (i < 0 || i >= this.objects.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + i + " outside the bounds [0," + this.size() + ")");
        }
        return this.objects.get(i);
    }

    @Override
    public List<E> objectsList() {
        return this.objects;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void lock() {
        this.locked = true;
    }

    @Override
    public void unlock() {
        this.locked = false;
    }

    @Override
    public int indexOf(E o) {
        Integer index = this.indexes.get(o);
        if (index == null) {
            return -1;
        }
        return index;
    }

    @Override
    public int addToIndex(E o) {
        Integer index = this.indexes.get(o);
        if (index == null) {
            if (!this.locked) {
                try {
                    this.semaphore.acquire();
                    index = this.indexes.get(o);
                    if (index == null) {
                        index = this.objects.size();
                        this.objects.add(o);
                        this.indexes.put(o, index);
                    }
                    this.semaphore.release();
                }
                catch (InterruptedException e) {
                    throw new RuntimeInterruptedException(e);
                }
            } else {
                return -1;
            }
        }
        return index;
    }

    public int addToIndexUnsafe(E o) {
        if (this.indexes.isEmpty()) {
            this.objects.add(o);
            this.indexes.put(o, 0);
            return 0;
        }
        Integer index = this.indexes.get(o);
        if (index == null) {
            if (this.locked) {
                index = -1;
            } else {
                index = this.objects.size();
                this.objects.add(o);
                this.indexes.put(o, index);
            }
        }
        return index;
    }

    @Override
    @Deprecated
    public int indexOf(E o, boolean add) {
        if (add) {
            return this.addToIndex(o);
        }
        return this.indexOf(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E element : c) {
            changed |= this.add(element);
        }
        return changed;
    }

    @Override
    public boolean add(E o) {
        Integer index = this.indexes.get(o);
        if (index == null && !this.locked) {
            index = this.objects.size();
            this.objects.add(o);
            this.indexes.put(o, index);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexes.containsKey(o);
    }

    public HashIndex() {
        this.objects = new ArrayList();
        this.indexes = Generics.newHashMap();
    }

    public HashIndex(int capacity) {
        this.objects = new ArrayList(capacity);
        this.indexes = Generics.newHashMap(capacity);
    }

    public HashIndex(Supplier<List<E>> objLookupFactory, Supplier<Map<E, Integer>> indexLookupFactory) {
        this(objLookupFactory.get(), indexLookupFactory.get());
    }

    private HashIndex(List<E> objects, Map<E, Integer> indexes) {
        this.objects = objects;
        this.indexes = indexes;
    }

    public HashIndex(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    public HashIndex(Index<? extends E> index) {
        this();
        this.addAll(index.objectsList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToFilename(String file) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file));
            int sz = this.size();
            for (int i = 0; i < sz; ++i) {
                bw.write(i + "=" + this.get(i) + '\n');
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Index<String> loadFromFilename(String file) {
        HashIndex<String> index = new HashIndex<String>();
        BufferedReader br = null;
        try {
            String line;
            br = IOUtils.readerFromString(file);
            while ((line = br.readLine()) != null) {
                int start = line.indexOf(61);
                if (start == -1 || start == line.length() - 1) continue;
                index.add(line.substring(start + 1));
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        finally {
            IOUtils.closeIgnoringExceptions(br);
        }
        return index;
    }

    @Override
    public void saveToWriter(Writer bw) throws IOException {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            bw.write(i + "=" + this.get(i) + '\n');
        }
    }

    public static Index<String> loadFromReader(BufferedReader br) throws IOException {
        HashIndex<String> index = new HashIndex<String>();
        String line = br.readLine();
        while (line != null && line.length() > 0) {
            int start = line.indexOf(61);
            if (start == -1 || start == line.length() - 1) continue;
            index.add(line.substring(start + 1));
            line = br.readLine();
        }
        return index;
    }

    @Override
    public String toString() {
        return this.toString(Integer.MAX_VALUE);
    }

    public String toStringOneEntryPerLine() {
        return this.toStringOneEntryPerLine(Integer.MAX_VALUE);
    }

    public String toString(int n) {
        int i;
        StringBuilder buff = new StringBuilder("[");
        int sz = this.objects.size();
        if (n > sz) {
            n = sz;
        }
        for (i = 0; i < n; ++i) {
            E e = this.objects.get(i);
            buff.append(i).append('=').append(e);
            if (i >= sz - 1) continue;
            buff.append(',');
        }
        if (i < sz) {
            buff.append("...");
        }
        buff.append(']');
        return buff.toString();
    }

    public String toStringOneEntryPerLine(int n) {
        int i;
        StringBuilder buff = new StringBuilder();
        int sz = this.objects.size();
        if (n > sz) {
            n = sz;
        }
        for (i = 0; i < n; ++i) {
            E e = this.objects.get(i);
            buff.append(e);
            if (i >= sz - 1) continue;
            buff.append('\n');
        }
        if (i < sz) {
            buff.append("...");
        }
        return buff.toString();
    }

    @Override
    public Iterator<E> iterator() {
        return this.objects.iterator();
    }

    public HashIndex<E> unmodifiableView() {
        HashIndex newIndex = new HashIndex<E>(this.objects, this.indexes){
            private static final long serialVersionUID = 3415903369787491736L;

            @Override
            public void unlock() {
                throw new UnsupportedOperationException("This is an unmodifiable view!");
            }
        };
        newIndex.lock();
        return newIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Index<String> loadFromFileWithList(String file) {
        HashIndex<String> index = new HashIndex<String>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                index.add(line.trim());
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return index;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HashIndex)) {
            return false;
        }
        HashIndex hashIndex = (HashIndex)o;
        return this.indexes.equals(hashIndex.indexes) && this.objects.equals(hashIndex.objects);
    }

    @Override
    public int hashCode() {
        int result = this.objects.hashCode();
        result = 31 * result + this.indexes.hashCode();
        return result;
    }
}

