# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository  # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Contact: contact@mailslurp.dev
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class ValidateEmailAddressListResult(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'valid_email_addresses': 'list[str]',
        'invalid_email_addresses': 'list[str]',
        'result_map_email_address_is_valid': 'dict(str, bool)'
    }

    attribute_map = {
        'valid_email_addresses': 'validEmailAddresses',
        'invalid_email_addresses': 'invalidEmailAddresses',
        'result_map_email_address_is_valid': 'resultMapEmailAddressIsValid'
    }

    def __init__(self, valid_email_addresses=None, invalid_email_addresses=None, result_map_email_address_is_valid=None, local_vars_configuration=None):  # noqa: E501
        """ValidateEmailAddressListResult - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._valid_email_addresses = None
        self._invalid_email_addresses = None
        self._result_map_email_address_is_valid = None
        self.discriminator = None

        self.valid_email_addresses = valid_email_addresses
        self.invalid_email_addresses = invalid_email_addresses
        self.result_map_email_address_is_valid = result_map_email_address_is_valid

    @property
    def valid_email_addresses(self):
        """Gets the valid_email_addresses of this ValidateEmailAddressListResult.  # noqa: E501


        :return: The valid_email_addresses of this ValidateEmailAddressListResult.  # noqa: E501
        :rtype: list[str]
        """
        return self._valid_email_addresses

    @valid_email_addresses.setter
    def valid_email_addresses(self, valid_email_addresses):
        """Sets the valid_email_addresses of this ValidateEmailAddressListResult.


        :param valid_email_addresses: The valid_email_addresses of this ValidateEmailAddressListResult.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and valid_email_addresses is None:  # noqa: E501
            raise ValueError("Invalid value for `valid_email_addresses`, must not be `None`")  # noqa: E501

        self._valid_email_addresses = valid_email_addresses

    @property
    def invalid_email_addresses(self):
        """Gets the invalid_email_addresses of this ValidateEmailAddressListResult.  # noqa: E501


        :return: The invalid_email_addresses of this ValidateEmailAddressListResult.  # noqa: E501
        :rtype: list[str]
        """
        return self._invalid_email_addresses

    @invalid_email_addresses.setter
    def invalid_email_addresses(self, invalid_email_addresses):
        """Sets the invalid_email_addresses of this ValidateEmailAddressListResult.


        :param invalid_email_addresses: The invalid_email_addresses of this ValidateEmailAddressListResult.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and invalid_email_addresses is None:  # noqa: E501
            raise ValueError("Invalid value for `invalid_email_addresses`, must not be `None`")  # noqa: E501

        self._invalid_email_addresses = invalid_email_addresses

    @property
    def result_map_email_address_is_valid(self):
        """Gets the result_map_email_address_is_valid of this ValidateEmailAddressListResult.  # noqa: E501


        :return: The result_map_email_address_is_valid of this ValidateEmailAddressListResult.  # noqa: E501
        :rtype: dict(str, bool)
        """
        return self._result_map_email_address_is_valid

    @result_map_email_address_is_valid.setter
    def result_map_email_address_is_valid(self, result_map_email_address_is_valid):
        """Sets the result_map_email_address_is_valid of this ValidateEmailAddressListResult.


        :param result_map_email_address_is_valid: The result_map_email_address_is_valid of this ValidateEmailAddressListResult.  # noqa: E501
        :type: dict(str, bool)
        """
        if self.local_vars_configuration.client_side_validation and result_map_email_address_is_valid is None:  # noqa: E501
            raise ValueError("Invalid value for `result_map_email_address_is_valid`, must not be `None`")  # noqa: E501

        self._result_map_email_address_is_valid = result_map_email_address_is_valid

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ValidateEmailAddressListResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ValidateEmailAddressListResult):
            return True

        return self.to_dict() != other.to_dict()
