import { Duration, Stack } from "aws-cdk-lib";
import { IBucket } from "aws-cdk-lib/aws-s3";
import { Construct } from "constructs";
export interface CacheProps {
    /**
     * The infix of the physical cache bucket name.
     *
     * @default "runner-cache"
     */
    readonly bucketName?: string;
    /**
     * The number of days after which the created cache objects are deleted from S3.
     * @default 30 days
     */
    readonly expiration?: Duration;
}
/**
 * A GitLab Runner cache consisting of an Amazon S3 bucket.
 *
 * The bucket is encrypted with a KMS managed master key, it has public access blocked and will be cleared and deleted on CFN stack deletion.
 */
export declare class Cache extends Construct {
    readonly bucket: IBucket;
    constructor(scope: Stack, id: string, props?: CacheProps);
}
//# sourceMappingURL=cache.d.ts.map