# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://docs.mailslurp.com/) - [Examples](https://github.com/mailslurp/examples) repository  # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Contact: contact@mailslurp.dev
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class Complaint(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'user_id': 'str',
        'event_type': 'str',
        'mail_source': 'str',
        'mail_message_id': 'str',
        'complaint_recipient': 'str',
        'created_at': 'datetime',
        'updated_at': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'user_id': 'userId',
        'event_type': 'eventType',
        'mail_source': 'mailSource',
        'mail_message_id': 'mailMessageId',
        'complaint_recipient': 'complaintRecipient',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt'
    }

    def __init__(self, id=None, user_id=None, event_type=None, mail_source=None, mail_message_id=None, complaint_recipient=None, created_at=None, updated_at=None, local_vars_configuration=None):  # noqa: E501
        """Complaint - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._user_id = None
        self._event_type = None
        self._mail_source = None
        self._mail_message_id = None
        self._complaint_recipient = None
        self._created_at = None
        self._updated_at = None
        self.discriminator = None

        self.id = id
        if user_id is not None:
            self.user_id = user_id
        if event_type is not None:
            self.event_type = event_type
        if mail_source is not None:
            self.mail_source = mail_source
        if mail_message_id is not None:
            self.mail_message_id = mail_message_id
        self.complaint_recipient = complaint_recipient
        self.created_at = created_at
        self.updated_at = updated_at

    @property
    def id(self):
        """Gets the id of this Complaint.  # noqa: E501


        :return: The id of this Complaint.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Complaint.


        :param id: The id of this Complaint.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def user_id(self):
        """Gets the user_id of this Complaint.  # noqa: E501


        :return: The user_id of this Complaint.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this Complaint.


        :param user_id: The user_id of this Complaint.  # noqa: E501
        :type: str
        """

        self._user_id = user_id

    @property
    def event_type(self):
        """Gets the event_type of this Complaint.  # noqa: E501


        :return: The event_type of this Complaint.  # noqa: E501
        :rtype: str
        """
        return self._event_type

    @event_type.setter
    def event_type(self, event_type):
        """Sets the event_type of this Complaint.


        :param event_type: The event_type of this Complaint.  # noqa: E501
        :type: str
        """

        self._event_type = event_type

    @property
    def mail_source(self):
        """Gets the mail_source of this Complaint.  # noqa: E501


        :return: The mail_source of this Complaint.  # noqa: E501
        :rtype: str
        """
        return self._mail_source

    @mail_source.setter
    def mail_source(self, mail_source):
        """Sets the mail_source of this Complaint.


        :param mail_source: The mail_source of this Complaint.  # noqa: E501
        :type: str
        """

        self._mail_source = mail_source

    @property
    def mail_message_id(self):
        """Gets the mail_message_id of this Complaint.  # noqa: E501


        :return: The mail_message_id of this Complaint.  # noqa: E501
        :rtype: str
        """
        return self._mail_message_id

    @mail_message_id.setter
    def mail_message_id(self, mail_message_id):
        """Sets the mail_message_id of this Complaint.


        :param mail_message_id: The mail_message_id of this Complaint.  # noqa: E501
        :type: str
        """

        self._mail_message_id = mail_message_id

    @property
    def complaint_recipient(self):
        """Gets the complaint_recipient of this Complaint.  # noqa: E501


        :return: The complaint_recipient of this Complaint.  # noqa: E501
        :rtype: str
        """
        return self._complaint_recipient

    @complaint_recipient.setter
    def complaint_recipient(self, complaint_recipient):
        """Sets the complaint_recipient of this Complaint.


        :param complaint_recipient: The complaint_recipient of this Complaint.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and complaint_recipient is None:  # noqa: E501
            raise ValueError("Invalid value for `complaint_recipient`, must not be `None`")  # noqa: E501

        self._complaint_recipient = complaint_recipient

    @property
    def created_at(self):
        """Gets the created_at of this Complaint.  # noqa: E501


        :return: The created_at of this Complaint.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Complaint.


        :param created_at: The created_at of this Complaint.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Complaint.  # noqa: E501


        :return: The updated_at of this Complaint.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Complaint.


        :param updated_at: The updated_at of this Complaint.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and updated_at is None:  # noqa: E501
            raise ValueError("Invalid value for `updated_at`, must not be `None`")  # noqa: E501

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Complaint):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Complaint):
            return True

        return self.to_dict() != other.to_dict()
