# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://docs.mailslurp.com/) - [Examples](https://github.com/mailslurp/examples) repository  # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Contact: contact@mailslurp.dev
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from mailslurp_client.api_client import ApiClient
from mailslurp_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class WaitForControllerApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def wait_for(self, wait_for_conditions, **kwargs):  # noqa: E501
        """Wait for an email to match the provided filter conditions such as subject contains keyword.  # noqa: E501

        Generic waitFor method that will wait until an inbox meets given conditions or return immediately if already met  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wait_for(wait_for_conditions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param WaitForConditions wait_for_conditions: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EmailPreview]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.wait_for_with_http_info(wait_for_conditions, **kwargs)  # noqa: E501

    def wait_for_with_http_info(self, wait_for_conditions, **kwargs):  # noqa: E501
        """Wait for an email to match the provided filter conditions such as subject contains keyword.  # noqa: E501

        Generic waitFor method that will wait until an inbox meets given conditions or return immediately if already met  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wait_for_with_http_info(wait_for_conditions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param WaitForConditions wait_for_conditions: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EmailPreview], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'wait_for_conditions'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wait_for" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'wait_for_conditions' is set
        if self.api_client.client_side_validation and ('wait_for_conditions' not in local_var_params or  # noqa: E501
                                                        local_var_params['wait_for_conditions'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `wait_for_conditions` when calling `wait_for`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'wait_for_conditions' in local_var_params:
            body_params = local_var_params['wait_for_conditions']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/waitFor', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EmailPreview]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def wait_for_email_count(self, inbox_id, count, **kwargs):  # noqa: E501
        """Wait for and return count number of emails. Hold connection until inbox count matches expected or timeout occurs  # noqa: E501

        If inbox contains count or more emails at time of request then return count worth of emails. If not wait until the count is reached and return those or return an error if timeout is exceeded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wait_for_email_count(inbox_id, count, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: Id of the inbox we are fetching emails from (required)
        :param int count: Number of emails to wait for. Must be greater that 1 (required)
        :param int timeout: Max milliseconds to wait
        :param bool unread_only: Optional filter for unread only
        :param datetime before: Filter for emails that were received before the given timestamp
        :param datetime since: Filter for emails that were received after the given timestamp
        :param str sort: Sort direction
        :param int delay: Max milliseconds delay between calls
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EmailPreview]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.wait_for_email_count_with_http_info(inbox_id, count, **kwargs)  # noqa: E501

    def wait_for_email_count_with_http_info(self, inbox_id, count, **kwargs):  # noqa: E501
        """Wait for and return count number of emails. Hold connection until inbox count matches expected or timeout occurs  # noqa: E501

        If inbox contains count or more emails at time of request then return count worth of emails. If not wait until the count is reached and return those or return an error if timeout is exceeded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wait_for_email_count_with_http_info(inbox_id, count, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: Id of the inbox we are fetching emails from (required)
        :param int count: Number of emails to wait for. Must be greater that 1 (required)
        :param int timeout: Max milliseconds to wait
        :param bool unread_only: Optional filter for unread only
        :param datetime before: Filter for emails that were received before the given timestamp
        :param datetime since: Filter for emails that were received after the given timestamp
        :param str sort: Sort direction
        :param int delay: Max milliseconds delay between calls
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EmailPreview], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'inbox_id',
            'count',
            'timeout',
            'unread_only',
            'before',
            'since',
            'sort',
            'delay'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wait_for_email_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inbox_id' is set
        if self.api_client.client_side_validation and ('inbox_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['inbox_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `inbox_id` when calling `wait_for_email_count`")  # noqa: E501
        # verify the required parameter 'count' is set
        if self.api_client.client_side_validation and ('count' not in local_var_params or  # noqa: E501
                                                        local_var_params['count'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `count` when calling `wait_for_email_count`")  # noqa: E501

        if self.api_client.client_side_validation and 'count' in local_var_params and local_var_params['count'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `count` when calling `wait_for_email_count`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'inbox_id' in local_var_params and local_var_params['inbox_id'] is not None:  # noqa: E501
            query_params.append(('inboxId', local_var_params['inbox_id']))  # noqa: E501
        if 'count' in local_var_params and local_var_params['count'] is not None:  # noqa: E501
            query_params.append(('count', local_var_params['count']))  # noqa: E501
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'unread_only' in local_var_params and local_var_params['unread_only'] is not None:  # noqa: E501
            query_params.append(('unreadOnly', local_var_params['unread_only']))  # noqa: E501
        if 'before' in local_var_params and local_var_params['before'] is not None:  # noqa: E501
            query_params.append(('before', local_var_params['before']))  # noqa: E501
        if 'since' in local_var_params and local_var_params['since'] is not None:  # noqa: E501
            query_params.append(('since', local_var_params['since']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'delay' in local_var_params and local_var_params['delay'] is not None:  # noqa: E501
            query_params.append(('delay', local_var_params['delay']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/waitForEmailCount', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EmailPreview]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def wait_for_latest_email(self, **kwargs):  # noqa: E501
        """Fetch inbox's latest email or if empty wait for an email to arrive  # noqa: E501

        Will return either the last received email or wait for an email to arrive and return that. If you need to wait for an email for a non-empty inbox set `unreadOnly=true` or see the other receive methods such as `waitForNthEmail` or `waitForEmailCount`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wait_for_latest_email(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: Id of the inbox we are fetching emails from
        :param int timeout: Max milliseconds to wait
        :param bool unread_only: Optional filter for unread only.
        :param datetime before: Filter for emails that were before after the given timestamp
        :param datetime since: Filter for emails that were received after the given timestamp
        :param str sort: Sort direction
        :param int delay: Max milliseconds delay between calls
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Email
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.wait_for_latest_email_with_http_info(**kwargs)  # noqa: E501

    def wait_for_latest_email_with_http_info(self, **kwargs):  # noqa: E501
        """Fetch inbox's latest email or if empty wait for an email to arrive  # noqa: E501

        Will return either the last received email or wait for an email to arrive and return that. If you need to wait for an email for a non-empty inbox set `unreadOnly=true` or see the other receive methods such as `waitForNthEmail` or `waitForEmailCount`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wait_for_latest_email_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: Id of the inbox we are fetching emails from
        :param int timeout: Max milliseconds to wait
        :param bool unread_only: Optional filter for unread only.
        :param datetime before: Filter for emails that were before after the given timestamp
        :param datetime since: Filter for emails that were received after the given timestamp
        :param str sort: Sort direction
        :param int delay: Max milliseconds delay between calls
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Email, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'inbox_id',
            'timeout',
            'unread_only',
            'before',
            'since',
            'sort',
            'delay'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wait_for_latest_email" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'inbox_id' in local_var_params and local_var_params['inbox_id'] is not None:  # noqa: E501
            query_params.append(('inboxId', local_var_params['inbox_id']))  # noqa: E501
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'unread_only' in local_var_params and local_var_params['unread_only'] is not None:  # noqa: E501
            query_params.append(('unreadOnly', local_var_params['unread_only']))  # noqa: E501
        if 'before' in local_var_params and local_var_params['before'] is not None:  # noqa: E501
            query_params.append(('before', local_var_params['before']))  # noqa: E501
        if 'since' in local_var_params and local_var_params['since'] is not None:  # noqa: E501
            query_params.append(('since', local_var_params['since']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'delay' in local_var_params and local_var_params['delay'] is not None:  # noqa: E501
            query_params.append(('delay', local_var_params['delay']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/waitForLatestEmail', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Email',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def wait_for_latest_sms(self, wait_for_single_sms_options, **kwargs):  # noqa: E501
        """Wait for the latest SMS message to match the provided filter conditions such as body contains keyword.  # noqa: E501

        Wait until a phone number meets given conditions or return immediately if already met  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wait_for_latest_sms(wait_for_single_sms_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param WaitForSingleSmsOptions wait_for_single_sms_options: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SmsDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.wait_for_latest_sms_with_http_info(wait_for_single_sms_options, **kwargs)  # noqa: E501

    def wait_for_latest_sms_with_http_info(self, wait_for_single_sms_options, **kwargs):  # noqa: E501
        """Wait for the latest SMS message to match the provided filter conditions such as body contains keyword.  # noqa: E501

        Wait until a phone number meets given conditions or return immediately if already met  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wait_for_latest_sms_with_http_info(wait_for_single_sms_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param WaitForSingleSmsOptions wait_for_single_sms_options: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SmsDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'wait_for_single_sms_options'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wait_for_latest_sms" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'wait_for_single_sms_options' is set
        if self.api_client.client_side_validation and ('wait_for_single_sms_options' not in local_var_params or  # noqa: E501
                                                        local_var_params['wait_for_single_sms_options'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `wait_for_single_sms_options` when calling `wait_for_latest_sms`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'wait_for_single_sms_options' in local_var_params:
            body_params = local_var_params['wait_for_single_sms_options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/waitForLatestSms', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmsDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def wait_for_matching_emails(self, inbox_id, count, match_options, **kwargs):  # noqa: E501
        """Wait or return list of emails that match simple matching patterns  # noqa: E501

        Perform a search of emails in an inbox with the given patterns. If results match expected count then return or else retry the search until results are found or timeout is reached. Match options allow simple CONTAINS or EQUALS filtering on SUBJECT, TO, BCC, CC, and FROM. See the `MatchOptions` object for options. An example payload is `{ matches: [{field: 'SUBJECT',should:'CONTAIN',value:'needle'}] }`. You can use an array of matches and they will be applied sequentially to filter out emails. If you want to perform matches and extractions of content using Regex patterns see the EmailController `getEmailContentMatch` method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wait_for_matching_emails(inbox_id, count, match_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: Id of the inbox we are fetching emails from (required)
        :param int count: Number of emails to wait for. Must be greater or equal to 1 (required)
        :param MatchOptions match_options: (required)
        :param datetime before: Filter for emails that were received before the given timestamp
        :param datetime since: Filter for emails that were received after the given timestamp
        :param str sort: Sort direction
        :param int delay: Max milliseconds delay between calls
        :param int timeout: Max milliseconds to wait
        :param bool unread_only: Optional filter for unread only
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EmailPreview]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.wait_for_matching_emails_with_http_info(inbox_id, count, match_options, **kwargs)  # noqa: E501

    def wait_for_matching_emails_with_http_info(self, inbox_id, count, match_options, **kwargs):  # noqa: E501
        """Wait or return list of emails that match simple matching patterns  # noqa: E501

        Perform a search of emails in an inbox with the given patterns. If results match expected count then return or else retry the search until results are found or timeout is reached. Match options allow simple CONTAINS or EQUALS filtering on SUBJECT, TO, BCC, CC, and FROM. See the `MatchOptions` object for options. An example payload is `{ matches: [{field: 'SUBJECT',should:'CONTAIN',value:'needle'}] }`. You can use an array of matches and they will be applied sequentially to filter out emails. If you want to perform matches and extractions of content using Regex patterns see the EmailController `getEmailContentMatch` method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wait_for_matching_emails_with_http_info(inbox_id, count, match_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: Id of the inbox we are fetching emails from (required)
        :param int count: Number of emails to wait for. Must be greater or equal to 1 (required)
        :param MatchOptions match_options: (required)
        :param datetime before: Filter for emails that were received before the given timestamp
        :param datetime since: Filter for emails that were received after the given timestamp
        :param str sort: Sort direction
        :param int delay: Max milliseconds delay between calls
        :param int timeout: Max milliseconds to wait
        :param bool unread_only: Optional filter for unread only
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EmailPreview], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'inbox_id',
            'count',
            'match_options',
            'before',
            'since',
            'sort',
            'delay',
            'timeout',
            'unread_only'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wait_for_matching_emails" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inbox_id' is set
        if self.api_client.client_side_validation and ('inbox_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['inbox_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `inbox_id` when calling `wait_for_matching_emails`")  # noqa: E501
        # verify the required parameter 'count' is set
        if self.api_client.client_side_validation and ('count' not in local_var_params or  # noqa: E501
                                                        local_var_params['count'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `count` when calling `wait_for_matching_emails`")  # noqa: E501
        # verify the required parameter 'match_options' is set
        if self.api_client.client_side_validation and ('match_options' not in local_var_params or  # noqa: E501
                                                        local_var_params['match_options'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `match_options` when calling `wait_for_matching_emails`")  # noqa: E501

        if self.api_client.client_side_validation and 'count' in local_var_params and local_var_params['count'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `count` when calling `wait_for_matching_emails`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'inbox_id' in local_var_params and local_var_params['inbox_id'] is not None:  # noqa: E501
            query_params.append(('inboxId', local_var_params['inbox_id']))  # noqa: E501
        if 'count' in local_var_params and local_var_params['count'] is not None:  # noqa: E501
            query_params.append(('count', local_var_params['count']))  # noqa: E501
        if 'before' in local_var_params and local_var_params['before'] is not None:  # noqa: E501
            query_params.append(('before', local_var_params['before']))  # noqa: E501
        if 'since' in local_var_params and local_var_params['since'] is not None:  # noqa: E501
            query_params.append(('since', local_var_params['since']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'delay' in local_var_params and local_var_params['delay'] is not None:  # noqa: E501
            query_params.append(('delay', local_var_params['delay']))  # noqa: E501
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'unread_only' in local_var_params and local_var_params['unread_only'] is not None:  # noqa: E501
            query_params.append(('unreadOnly', local_var_params['unread_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'match_options' in local_var_params:
            body_params = local_var_params['match_options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/waitForMatchingEmails', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EmailPreview]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def wait_for_matching_first_email(self, inbox_id, match_options, **kwargs):  # noqa: E501
        """Wait for or return the first email that matches provided MatchOptions array  # noqa: E501

        Perform a search of emails in an inbox with the given patterns. If a result if found then return or else retry the search until a result is found or timeout is reached. Match options allow simple CONTAINS or EQUALS filtering on SUBJECT, TO, BCC, CC, and FROM. See the `MatchOptions` object for options. An example payload is `{ matches: [{field: 'SUBJECT',should:'CONTAIN',value:'needle'}] }`. You can use an array of matches and they will be applied sequentially to filter out emails. If you want to perform matches and extractions of content using Regex patterns see the EmailController `getEmailContentMatch` method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wait_for_matching_first_email(inbox_id, match_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: Id of the inbox we are matching an email for (required)
        :param MatchOptions match_options: (required)
        :param int timeout: Max milliseconds to wait
        :param bool unread_only: Optional filter for unread only
        :param datetime since: Filter for emails that were received after the given timestamp
        :param datetime before: Filter for emails that were received before the given timestamp
        :param str sort: Sort direction
        :param int delay: Max milliseconds delay between calls
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Email
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.wait_for_matching_first_email_with_http_info(inbox_id, match_options, **kwargs)  # noqa: E501

    def wait_for_matching_first_email_with_http_info(self, inbox_id, match_options, **kwargs):  # noqa: E501
        """Wait for or return the first email that matches provided MatchOptions array  # noqa: E501

        Perform a search of emails in an inbox with the given patterns. If a result if found then return or else retry the search until a result is found or timeout is reached. Match options allow simple CONTAINS or EQUALS filtering on SUBJECT, TO, BCC, CC, and FROM. See the `MatchOptions` object for options. An example payload is `{ matches: [{field: 'SUBJECT',should:'CONTAIN',value:'needle'}] }`. You can use an array of matches and they will be applied sequentially to filter out emails. If you want to perform matches and extractions of content using Regex patterns see the EmailController `getEmailContentMatch` method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wait_for_matching_first_email_with_http_info(inbox_id, match_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: Id of the inbox we are matching an email for (required)
        :param MatchOptions match_options: (required)
        :param int timeout: Max milliseconds to wait
        :param bool unread_only: Optional filter for unread only
        :param datetime since: Filter for emails that were received after the given timestamp
        :param datetime before: Filter for emails that were received before the given timestamp
        :param str sort: Sort direction
        :param int delay: Max milliseconds delay between calls
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Email, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'inbox_id',
            'match_options',
            'timeout',
            'unread_only',
            'since',
            'before',
            'sort',
            'delay'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wait_for_matching_first_email" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inbox_id' is set
        if self.api_client.client_side_validation and ('inbox_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['inbox_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `inbox_id` when calling `wait_for_matching_first_email`")  # noqa: E501
        # verify the required parameter 'match_options' is set
        if self.api_client.client_side_validation and ('match_options' not in local_var_params or  # noqa: E501
                                                        local_var_params['match_options'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `match_options` when calling `wait_for_matching_first_email`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'inbox_id' in local_var_params and local_var_params['inbox_id'] is not None:  # noqa: E501
            query_params.append(('inboxId', local_var_params['inbox_id']))  # noqa: E501
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'unread_only' in local_var_params and local_var_params['unread_only'] is not None:  # noqa: E501
            query_params.append(('unreadOnly', local_var_params['unread_only']))  # noqa: E501
        if 'since' in local_var_params and local_var_params['since'] is not None:  # noqa: E501
            query_params.append(('since', local_var_params['since']))  # noqa: E501
        if 'before' in local_var_params and local_var_params['before'] is not None:  # noqa: E501
            query_params.append(('before', local_var_params['before']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'delay' in local_var_params and local_var_params['delay'] is not None:  # noqa: E501
            query_params.append(('delay', local_var_params['delay']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'match_options' in local_var_params:
            body_params = local_var_params['match_options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/waitForMatchingFirstEmail', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Email',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def wait_for_nth_email(self, **kwargs):  # noqa: E501
        """Wait for or fetch the email with a given index in the inbox specified. If index doesn't exist waits for it to exist or timeout to occur.  # noqa: E501

        If nth email is already present in inbox then return it. If not hold the connection open until timeout expires or the nth email is received and returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wait_for_nth_email(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: Id of the inbox you are fetching emails from
        :param int index: Zero based index of the email to wait for. If an inbox has 1 email already and you want to wait for the 2nd email pass index=1
        :param int timeout: Max milliseconds to wait for the nth email if not already present
        :param bool unread_only: Optional filter for unread only
        :param datetime since: Filter for emails that were received after the given timestamp
        :param datetime before: Filter for emails that were received before the given timestamp
        :param str sort: Sort direction
        :param int delay: Max milliseconds delay between calls
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Email
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.wait_for_nth_email_with_http_info(**kwargs)  # noqa: E501

    def wait_for_nth_email_with_http_info(self, **kwargs):  # noqa: E501
        """Wait for or fetch the email with a given index in the inbox specified. If index doesn't exist waits for it to exist or timeout to occur.  # noqa: E501

        If nth email is already present in inbox then return it. If not hold the connection open until timeout expires or the nth email is received and returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wait_for_nth_email_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str inbox_id: Id of the inbox you are fetching emails from
        :param int index: Zero based index of the email to wait for. If an inbox has 1 email already and you want to wait for the 2nd email pass index=1
        :param int timeout: Max milliseconds to wait for the nth email if not already present
        :param bool unread_only: Optional filter for unread only
        :param datetime since: Filter for emails that were received after the given timestamp
        :param datetime before: Filter for emails that were received before the given timestamp
        :param str sort: Sort direction
        :param int delay: Max milliseconds delay between calls
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Email, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'inbox_id',
            'index',
            'timeout',
            'unread_only',
            'since',
            'before',
            'sort',
            'delay'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wait_for_nth_email" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'index' in local_var_params and local_var_params['index'] > 2147483647:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `index` when calling `wait_for_nth_email`, must be a value less than or equal to `2147483647`")  # noqa: E501
        if self.api_client.client_side_validation and 'index' in local_var_params and local_var_params['index'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `index` when calling `wait_for_nth_email`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'inbox_id' in local_var_params and local_var_params['inbox_id'] is not None:  # noqa: E501
            query_params.append(('inboxId', local_var_params['inbox_id']))  # noqa: E501
        if 'index' in local_var_params and local_var_params['index'] is not None:  # noqa: E501
            query_params.append(('index', local_var_params['index']))  # noqa: E501
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'unread_only' in local_var_params and local_var_params['unread_only'] is not None:  # noqa: E501
            query_params.append(('unreadOnly', local_var_params['unread_only']))  # noqa: E501
        if 'since' in local_var_params and local_var_params['since'] is not None:  # noqa: E501
            query_params.append(('since', local_var_params['since']))  # noqa: E501
        if 'before' in local_var_params and local_var_params['before'] is not None:  # noqa: E501
            query_params.append(('before', local_var_params['before']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'delay' in local_var_params and local_var_params['delay'] is not None:  # noqa: E501
            query_params.append(('delay', local_var_params['delay']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/waitForNthEmail', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Email',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def wait_for_sms(self, wait_for_sms_conditions, **kwargs):  # noqa: E501
        """Wait for an SMS message to match the provided filter conditions such as body contains keyword.  # noqa: E501

        Generic waitFor method that will wait until a phone number meets given conditions or return immediately if already met  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wait_for_sms(wait_for_sms_conditions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param WaitForSmsConditions wait_for_sms_conditions: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[SmsPreview]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.wait_for_sms_with_http_info(wait_for_sms_conditions, **kwargs)  # noqa: E501

    def wait_for_sms_with_http_info(self, wait_for_sms_conditions, **kwargs):  # noqa: E501
        """Wait for an SMS message to match the provided filter conditions such as body contains keyword.  # noqa: E501

        Generic waitFor method that will wait until a phone number meets given conditions or return immediately if already met  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wait_for_sms_with_http_info(wait_for_sms_conditions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param WaitForSmsConditions wait_for_sms_conditions: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[SmsPreview], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'wait_for_sms_conditions'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wait_for_sms" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'wait_for_sms_conditions' is set
        if self.api_client.client_side_validation and ('wait_for_sms_conditions' not in local_var_params or  # noqa: E501
                                                        local_var_params['wait_for_sms_conditions'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `wait_for_sms_conditions` when calling `wait_for_sms`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'wait_for_sms_conditions' in local_var_params:
            body_params = local_var_params['wait_for_sms_conditions']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API_KEY']  # noqa: E501

        return self.api_client.call_api(
            '/waitForSms', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SmsPreview]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
